import {system, world} from '@minecraft/server';
    

  system.afterEvents.scriptEventReceive.subscribe((eventData)=>{
	try{
	if(eventData.id == "xps:drain"){
		let drainBlock = eventData.sourceBlock;
		let blockLocation = drainBlock.location;
		let blockDimension = drainBlock.dimension;
		let newBlockLocation = {x:blockLocation.x,y:blockLocation.y+1,z:blockLocation.z};
		let player = blockDimension.getPlayers({location:newBlockLocation,closest:1})[0];		
		let currentXP = player.getTotalXp();		
		if(player.level > 0){	
			player.addLevels(-1);
			let newCurrentXP = player.getTotalXp();
			let newStoredXP = currentXP-newCurrentXP;
			player.runCommandAsync(`scoreboard players add @s xp_stored ${newStoredXP}`);
		}

	}
	}catch(e){
		world.getDimension(`overworld`).runCommandAsync(`say Level Storage Encountered a Problem, Please Re-enter world or Contact the Addon Creator!`);
	}
  });

  function getTotalExp(player){
	let level = 0
	while(true){
		level++
		if(!player.runCommand(`testfor @s[l=${level}]`).successCount == 0){
			break
		}
	}
  }
  
  function getXp(level){
	  let xp = 0;
	  if(0 <= level && level <= 16){
		 xp = Math.pow(level, 2) + 6 * level; 
	  }else if(17 <= level && level <= 31){
		 xp = 2.5 * Math.pow(level, 2) - 40.5 * level + 360;
	  }else if(level >= 32){
		 xp = 4.5 * Math.pow(level, 2) - 162.5 * level + 2220;
	  }
	  
	  return Math.round(Math.abs(xp));
  }
  
  function getLvl(xp){
	  let lvl = 0;
	  if(0 <= xp && xp <= 352){
		 lvl = Math.sqrt(xp+9)-3;
	  }else if(394 <= xp && xp <= 1507){
		 lvl = (81/10)+Math.sqrt((2/5)(xp-(7839/40)));
	  }else if(xp >= 1628){
		 lvl = (325/18)+Math.sqrt((2/9)(xp-(54215/72)));
	  }
	  return Math.round(lvl);
  }