import { ItemStack, system, world } from "@minecraft/server";
import { randomNum } from "../math/randomNumbers";
import { ItemManager } from "../item/manager";
export class BlockManager {
    static destroyBlock(dimension, location) {
        dimension.runCommand(`setblock ${location.x} ${location.y} ${location.z} air destroy`);
    }
    static getBlocksAround(block) {
        let above = undefined;
        try {
            above = block.above(1);
        }
        catch { }
        let below = undefined;
        try {
            below = block.below(1);
        }
        catch { }
        let north = undefined;
        try {
            north = block.north(1);
        }
        catch { }
        let south = undefined;
        try {
            south = block.south(1);
        }
        catch { }
        let east = undefined;
        try {
            east = block.east(1);
        }
        catch { }
        let west = undefined;
        try {
            west = block.west(1);
        }
        catch { }
        return [
            above, below, north, south, east, west
        ];
    }
    static break(block, silkTouched) {
        let typeId = block.typeId;
        if (typeId.includes("lit_")) {
            typeId = typeId.replace("lit_", "");
        }
        const center = block.center();
        system.runTimeout(() => {
            if (silkTouched) {
                const lastRule = world.gameRules.doTileDrops;
                world.gameRules.doTileDrops = false;
                BlockManager.destroyBlock(block.dimension, block.location);
                world.gameRules.doTileDrops = lastRule;
                const item = new ItemStack(typeId, 1);
                const itemEntity = ItemManager.spawnItem(item, block.dimension, {
                    x: center.x,
                    y: center.y - 0.4,
                    z: center.z,
                });
                itemEntity?.applyImpulse({
                    x: randomNum(-0.1, 0.1),
                    y: randomNum(0.1, 0.25),
                    z: randomNum(-0.1, 0.1),
                });
            }
            else {
                BlockManager.destroyBlock(block.dimension, block.location);
            }
        });
    }
}
