import { treecapitatorManager } from './classes/treecapitatorManager';
import { world, EquipmentSlot, EntityEquippableComponent } from '@minecraft/server';
world.beforeEvents.playerBreakBlock.subscribe((data) => {
    const { block, itemStack, player } = data;
    if (!itemStack) return;
    const mainhand = player.getComponent(EntityEquippableComponent.componentId).getEquipmentSlot(EquipmentSlot.Mainhand);
    const item = mainhand.getItem();
    if (!item) return;
    if (!player.isSneaking) return;
    if (item.typeId.includes("_axe")) {
        if (treecapitatorManager.logIDs.includes(block.typeId)) {
            treecapitatorManager.start(player, block, item, mainhand);
        }
    }
});
