import { world } from "@minecraft/server";

export const DefaultSleepingCoffin = {
	accelerateTime: false,
	onlySleepAtNight: true,
	spawnEntities: true
};
export function getGlobalConfig() {
	const raw = world.getDynamicProperty("EndevGlobalConfig");
	if (!raw) {
		world.setDynamicProperty("EndevGlobalConfig", JSON.stringify({}));
		return {};
	}
	return JSON.parse(raw);
}
export function getAddonConfig(addonName) {
	const globalConfig = getGlobalConfig();
	const merged = {
		...DefaultSleepingCoffin,
		...(globalConfig[addonName] ?? {})
	};
	globalConfig[addonName] = merged;
	world.setDynamicProperty("EndevGlobalConfig", JSON.stringify(globalConfig));
	return merged;
}
export function updateAddonConfig(addonName, newValues) {
	const globalConfig = getGlobalConfig();
	if (!globalConfig[addonName]) return;
	globalConfig[addonName] = {
		...globalConfig[addonName],
		...newValues
	};
	world.setDynamicProperty("EndevGlobalConfig", JSON.stringify(globalConfig));
	return globalConfig[addonName];
}