import { system, ItemDurabilityComponent, GameMode, ItemEnchantableComponent } from '@minecraft/server';
import { BlockManager } from '../block/manager';
import { ItemManager } from '../item/manager';
export class hoeminerManager {
    static hoeBlockIDs = [
        "minecraft:hay_block",
        "minecraft:acacia_leaves",
        "minecraft:azalea_leaves",
        "minecraft:azalea_leaves_flowered",
        "minecraft:birch_leaves",
        "minecraft:cherry_leaves",
        "minecraft:dark_oak_leaves",
        "minecraft:jungle_leaves",
        "minecraft:mangrove_leaves",
        "minecraft:oak_leaves",
        "minecraft:spruce_leaves",
        "minecraft:nether_wart_block",
        "minecraft:warped_wart_block"
    ];
    static start(player, brokenBlock, item, mainhand) {
        const durComp = item.getComponent(ItemDurabilityComponent.componentId);
        if (!durComp)
            return;
        const enchComp = item.getComponent(ItemEnchantableComponent.componentId);
        let unbreakingLevel = undefined;
        let silkTouched = false;
        if (enchComp) {
            if (enchComp.hasEnchantment("unbreaking")) {
                unbreakingLevel = enchComp.getEnchantment("unbreaking").level;
            }
            if (enchComp.hasEnchantment("silk_touch"))
                silkTouched = true;
        }
        this.getBlocks(brokenBlock, player, item, mainhand, durComp, silkTouched, unbreakingLevel);
    }
    static limit = 64;
    static getBlocks(block, source, item, mainhand, durComp, silkTouched, unbreakingLevel) {
        let durability = durComp.damage;
        let blockNum = 0;
        let stop = false;
        const deniedLocs = [];
        function tick(block, takeDur, breakBlock) {
            deniedLocs.push(block.location);
            if (blockNum >= hoeminerManager.limit)
                return;
            if (stop == true)
                return;
            const sameID = block.typeId;
            const blocks = BlockManager.getBlocksAround(block);
            if (breakBlock)
                BlockManager.break(block, silkTouched);
            if (takeDur == true && ItemManager.reduceDurability(unbreakingLevel)) {
                durability = durability + 1;
                if (durability >= durComp.maxDurability) {
                    stop = true;
                    return;
                }
            }
            for (const newblock of blocks) {
                if (newblock != undefined) {
                    const newloc = newblock.location;
                    if (newblock.typeId == sameID && !hoeminerManager.isDenied(newloc, deniedLocs)) {
                        blockNum = blockNum + 1;
                        if (source.getGameMode() != GameMode.creative) {
                            tick(newblock, true, true);
                        }
                        else {
                            tick(newblock, false, true);
                        }
                    }
                }
            }
        }
        tick(block, true, false);
        if (durability >= durComp.maxDurability) {
            stop = true;
            system.runTimeout(() => {
                source.dimension.playSound("random.break", source.location);
                mainhand.setItem(undefined);
            });
            return;
        }
        else {
            system.runTimeout(() => {
                durComp.damage = durability;
                mainhand.setItem(item);
            });
        }
    }
    static isDenied(blockLoc, deniedList) {
        let isDenied = false;
        for (const loc of deniedList) {
            if (blockLoc.x == loc.x && blockLoc.y == loc.y && blockLoc.z == loc.z)
                isDenied = true;
        }
        return isDenied;
    }
}
