import { itemApplyDamage } from "../util/utils";

const blockMap = {
	"minecraft:acacia_planks": "drop:planks_acacia",
	"minecraft:bamboo_planks": "drop:planks_bamboo",
	"minecraft:birch_planks": "drop:planks_birch",
	"minecraft:cherry_planks": "drop:planks_cherry",
	"minecraft:crimson_planks": "drop:planks_crimson",
	"minecraft:dark_oak_planks": "drop:planks_dark_oak",
	"minecraft:jungle_planks": "drop:planks_jungle",
	"minecraft:mangrove_planks": "drop:planks_mangrove",
	"minecraft:oak_planks": "drop:planks_oak",
	"minecraft:pale_oak_planks": "drop:planks_pale_oak",
	"minecraft:spruce_planks": "drop:planks_spruce",
	"minecraft:warped_planks": "drop:planks_warped"
};
const reverseMap = Object.fromEntries(Object.entries(blockMap).map(([vanilla, base]) => [base, vanilla]));

export class DropChiselBlock {
	constructor() {
		this.maxState = 5;
		this.onUseOn = this.onUseOn.bind(this);
	}
	onUseOn(e) {
		const { block, itemStack, source } = e;
		const id = block.typeId;
		if (blockMap[id]) {
			block.setType(`${blockMap[id]}_0`);
			source.dimension.playSound("effect.chisel_block", block.center());
			itemApplyDamage(source, itemStack);
			return;
		}
		const lastUnderscore = id.lastIndexOf("_");
		if (lastUnderscore === -1) return;
		const baseId = id.substring(0, lastUnderscore);
		const currentState = parseInt(id.substring(lastUnderscore + 1));
		if (isNaN(currentState)) return;
		if (currentState < this.maxState) {
			block.setType(`${baseId}_${currentState + 1}`);
		} else {
			const vanillaId = reverseMap[baseId];
			if (vanillaId) block.setType(vanillaId);
		}
		source.dimension.playSound("effect.chisel_block", block.center());
		itemApplyDamage(source, itemStack);
	}
}