import { DropUpdateSideBlock } from './GlobalClass';
import { directionState, leftBlockLocation, rightBlockLocation } from '../util/globalVariables';

export class DropCurtain extends DropUpdateSideBlock {
	constructor(blockTag) {
		super(blockTag);
		this.topState = "drop:top";
		this.bottomState = "drop:bottom";
		this.onPlace = this.onPlace.bind(this);
		this.onPlayerDestroy = this.onPlayerDestroy.bind(this);
		this.onPlayerInteract = this.onPlayerInteract.bind(this);
	}
	updateVerticalConnections(block, direction) {
		const tag = `${this.blockTag}_${direction}`;
		const above = block.above();
		const below = block.below();
		block.setPermutation(block.permutation
			.withState(this.topState, above?.hasTag(tag))
			.withState(this.bottomState, below?.hasTag(tag))
		);
	}
	updateNearbyVertical(block, direction) {
		const tag = `${this.blockTag}_${direction}`;
		const above = block.above();
		const below = block.below();
		if (above?.hasTag(tag)) this.updateVerticalConnections(above, above.permutation.getState(directionState));
		if (below?.hasTag(tag)) this.updateVerticalConnections(below, below.permutation.getState(directionState));
	}
	toggleCurtains(block) {
		const direction = block.permutation.getState(directionState);
		const tag = `${this.blockTag}_${direction}`;
		const visited = new Set();
		const stack = [block];
		const originX = block.x;
		const originY = block.y;
		const originZ = block.z;
		const currentState = block.permutation.getState("drop:open");
		const newState = !currentState;
		while (stack.length > 0) {
			const current = stack.pop();
			const key = `${current.x},${current.y},${current.z}`;
			if (visited.has(key)) continue;
			visited.add(key);
			if (Math.abs(current.x - originX) > 10 || Math.abs(current.y - originY) > 10 || Math.abs(current.z - originZ) > 10) continue;
			if (current.permutation.getState("drop:open") !== currentState) continue;
			current.setPermutation(current.permutation.withState("drop:open", newState));
			const neighbors = [
				current.above(),
				current.below(),
				current.offset(leftBlockLocation[direction]),
				current.offset(rightBlockLocation[direction])
			];
			for (const neighbor of neighbors) {
				if (!neighbor?.hasTag(tag)) continue;
				if (neighbor.permutation.getState("drop:open") === currentState) {
					stack.push(neighbor);
				}
			}
		}
	}
	onPlace(e) {
		super.onPlace(e);
		const direction = e.block.permutation.getState(directionState);
		this.updateVerticalConnections(e.block, direction);
		this.updateNearbyVertical(e.block, direction);
	}
	onPlayerDestroy(e) {
		super.onPlayerDestroy(e);
		const direction = e.destroyedBlockPermutation.getState(directionState);
		this.updateNearbyVertical(e.block, direction);
	}
	onPlayerInteract(e) {
		this.toggleCurtains(e.block);
		e.dimension.playSound("use.cloth", e.block.center());
	}
}