/*! For license information please see Main.js.LICENSE.txt */
import * as __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__ from "@minecraft/server-editor";

import * as __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__ from "@minecraft/server";

import * as __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_private_bindings_ae1d7ddf__ from "@minecraft/server-editor-private-bindings";

import * as __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_bindings_e2bf1028__ from "@minecraft/server-editor-bindings";

var __webpack_modules__ = {
    401: (__unused_webpack_module, exports) => {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.clampNumber = void 0;
        function clampNumber(val, min, max) {
            return Math.min(Math.max(val, min), max);
        }
        exports.clampNumber = clampNumber;
    },
    107: function(__unused_webpack_module, exports, __webpack_require__) {
        var __createBinding = this && this.__createBinding || (Object.create ? function(o, m, k, k2) {
            if (k2 === undefined) k2 = k;
            var desc = Object.getOwnPropertyDescriptor(m, k);
            if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
                desc = {
                    enumerable: true,
                    get: function() {
                        return m[k];
                    }
                };
            }
            Object.defineProperty(o, k2, desc);
        } : function(o, m, k, k2) {
            if (k2 === undefined) k2 = k;
            o[k2] = m[k];
        });
        var __exportStar = this && this.__exportStar || function(m, exports) {
            for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
        };
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        __exportStar(__webpack_require__(401), exports);
    },
    607: function(__unused_webpack_module, exports, __webpack_require__) {
        var __createBinding = this && this.__createBinding || (Object.create ? function(o, m, k, k2) {
            if (k2 === undefined) k2 = k;
            var desc = Object.getOwnPropertyDescriptor(m, k);
            if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
                desc = {
                    enumerable: true,
                    get: function() {
                        return m[k];
                    }
                };
            }
            Object.defineProperty(o, k2, desc);
        } : function(o, m, k, k2) {
            if (k2 === undefined) k2 = k;
            o[k2] = m[k];
        });
        var __exportStar = this && this.__exportStar || function(m, exports) {
            for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
        };
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        __exportStar(__webpack_require__(360), exports);
        __exportStar(__webpack_require__(107), exports);
    },
    419: (__unused_webpack_module, exports, __webpack_require__) => {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.VECTOR3_SOUTH = exports.VECTOR3_NORTH = exports.VECTOR3_EAST = exports.VECTOR3_WEST = exports.VECTOR3_ZERO = exports.VECTOR3_ONE = exports.VECTOR3_BACK = exports.VECTOR3_FORWARD = exports.VECTOR3_RIGHT = exports.VECTOR3_LEFT = exports.VECTOR3_DOWN = exports.VECTOR3_UP = exports.Vector2Utils = exports.Vector3Utils = void 0;
        const clamp_1 = __webpack_require__(401);
        class Vector3Utils {
            static equals(v1, v2) {
                return v1.x === v2.x && v1.y === v2.y && v1.z === v2.z;
            }
            static add(v1, v2) {
                return {
                    x: v1.x + v2.x,
                    y: v1.y + v2.y,
                    z: v1.z + v2.z
                };
            }
            static subtract(v1, v2) {
                return {
                    x: v1.x - v2.x,
                    y: v1.y - v2.y,
                    z: v1.z - v2.z
                };
            }
            static scale(v1, scale) {
                return {
                    x: v1.x * scale,
                    y: v1.y * scale,
                    z: v1.z * scale
                };
            }
            static dot(a, b) {
                return a.x * b.x + a.y * b.y + a.z * b.z;
            }
            static cross(a, b) {
                return {
                    x: a.y * b.z - a.z * b.y,
                    y: a.z * b.x - a.x * b.z,
                    z: a.x * b.y - a.y * b.x
                };
            }
            static magnitude(v) {
                return Math.sqrt(v.x ** 2 + v.y ** 2 + v.z ** 2);
            }
            static normalize(v) {
                const mag = Vector3Utils.magnitude(v);
                return {
                    x: v.x / mag,
                    y: v.y / mag,
                    z: v.z / mag
                };
            }
            static floor(v) {
                return {
                    x: Math.floor(v.x),
                    y: Math.floor(v.y),
                    z: Math.floor(v.z)
                };
            }
            static toString(v, options) {
                const decimals = options?.decimals ?? 2;
                const str = [ v.x.toFixed(decimals), v.y.toFixed(decimals), v.z.toFixed(decimals) ];
                return str.join(options?.delimiter ?? ", ");
            }
            static clamp(v, limits) {
                return {
                    x: (0, clamp_1.clampNumber)(v.x, limits?.min?.x ?? Number.MIN_SAFE_INTEGER, limits?.max?.x ?? Number.MAX_SAFE_INTEGER),
                    y: (0, clamp_1.clampNumber)(v.y, limits?.min?.y ?? Number.MIN_SAFE_INTEGER, limits?.max?.y ?? Number.MAX_SAFE_INTEGER),
                    z: (0, clamp_1.clampNumber)(v.z, limits?.min?.z ?? Number.MIN_SAFE_INTEGER, limits?.max?.z ?? Number.MAX_SAFE_INTEGER)
                };
            }
        }
        exports.Vector3Utils = Vector3Utils;
        class Vector2Utils {
            static toString(v, options) {
                const decimals = options?.decimals ?? 2;
                const str = [ v.x.toFixed(decimals), v.y.toFixed(decimals) ];
                return str.join(options?.delimiter ?? ", ");
            }
        }
        exports.Vector2Utils = Vector2Utils;
        exports.VECTOR3_UP = {
            x: 0,
            y: 1,
            z: 0
        };
        exports.VECTOR3_DOWN = {
            x: 0,
            y: -1,
            z: 0
        };
        exports.VECTOR3_LEFT = {
            x: -1,
            y: 0,
            z: 0
        };
        exports.VECTOR3_RIGHT = {
            x: 1,
            y: 0,
            z: 0
        };
        exports.VECTOR3_FORWARD = {
            x: 0,
            y: 0,
            z: 1
        };
        exports.VECTOR3_BACK = {
            x: 0,
            y: 0,
            z: -1
        };
        exports.VECTOR3_ONE = {
            x: 1,
            y: 1,
            z: 1
        };
        exports.VECTOR3_ZERO = {
            x: 0,
            y: 0,
            z: 0
        };
        exports.VECTOR3_WEST = {
            x: -1,
            y: 0,
            z: 0
        };
        exports.VECTOR3_EAST = {
            x: 1,
            y: 0,
            z: 0
        };
        exports.VECTOR3_NORTH = {
            x: 0,
            y: 0,
            z: 1
        };
        exports.VECTOR3_SOUTH = {
            x: 0,
            y: 0,
            z: -1
        };
    },
    360: function(__unused_webpack_module, exports, __webpack_require__) {
        var __createBinding = this && this.__createBinding || (Object.create ? function(o, m, k, k2) {
            if (k2 === undefined) k2 = k;
            var desc = Object.getOwnPropertyDescriptor(m, k);
            if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
                desc = {
                    enumerable: true,
                    get: function() {
                        return m[k];
                    }
                };
            }
            Object.defineProperty(o, k2, desc);
        } : function(o, m, k, k2) {
            if (k2 === undefined) k2 = k;
            o[k2] = m[k];
        });
        var __exportStar = this && this.__exportStar || function(m, exports) {
            for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
        };
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        __exportStar(__webpack_require__(419), exports);
        __exportStar(__webpack_require__(53), exports);
    },
    53: (__unused_webpack_module, exports, __webpack_require__) => {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.Vector2Builder = exports.Vector3Builder = void 0;
        const coreHelpers_1 = __webpack_require__(419);
        class Vector3Builder {
            constructor(first, y, z) {
                if (typeof first === "object") {
                    this.x = first.x;
                    this.y = first.y;
                    this.z = first.z;
                } else {
                    this.x = first;
                    this.y = y ?? 0;
                    this.z = z ?? 0;
                }
            }
            assign(vec) {
                this.x = vec.x;
                this.y = vec.y;
                this.z = vec.z;
                return this;
            }
            equals(v) {
                return coreHelpers_1.Vector3Utils.equals(this, v);
            }
            add(v) {
                return this.assign(coreHelpers_1.Vector3Utils.add(this, v));
            }
            subtract(v) {
                return this.assign(coreHelpers_1.Vector3Utils.subtract(this, v));
            }
            scale(val) {
                return this.assign(coreHelpers_1.Vector3Utils.scale(this, val));
            }
            dot(vec) {
                return coreHelpers_1.Vector3Utils.dot(this, vec);
            }
            cross(vec) {
                return this.assign(coreHelpers_1.Vector3Utils.cross(this, vec));
            }
            magnitude() {
                return coreHelpers_1.Vector3Utils.magnitude(this);
            }
            normalize() {
                return this.assign(coreHelpers_1.Vector3Utils.normalize(this));
            }
            floor() {
                return this.assign(coreHelpers_1.Vector3Utils.floor(this));
            }
            toString(options) {
                return coreHelpers_1.Vector3Utils.toString(this, options);
            }
            clamp(limits) {
                return this.assign(coreHelpers_1.Vector3Utils.clamp(this, limits));
            }
        }
        exports.Vector3Builder = Vector3Builder;
        class Vector2Builder {
            constructor(first, y) {
                if (typeof first === "object") {
                    this.x = first.x;
                    this.y = first.y;
                } else {
                    this.x = first;
                    this.y = y ?? 0;
                }
            }
            toString(options) {
                return coreHelpers_1.Vector2Utils.toString(this, options);
            }
        }
        exports.Vector2Builder = Vector2Builder;
    },
    796: (__unused_webpack_module, exports) => {
        exports.byteLength = byteLength;
        exports.toByteArray = toByteArray;
        exports.fromByteArray = fromByteArray;
        var lookup = [];
        var revLookup = [];
        var Arr = typeof Uint8Array !== "undefined" ? Uint8Array : Array;
        var code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        for (var i = 0, len = code.length; i < len; ++i) {
            lookup[i] = code[i];
            revLookup[code.charCodeAt(i)] = i;
        }
        revLookup["-".charCodeAt(0)] = 62;
        revLookup["_".charCodeAt(0)] = 63;
        function getLens(b64) {
            var len = b64.length;
            if (len % 4 > 0) {
                throw new Error("Invalid string. Length must be a multiple of 4");
            }
            var validLen = b64.indexOf("=");
            if (validLen === -1) validLen = len;
            var placeHoldersLen = validLen === len ? 0 : 4 - validLen % 4;
            return [ validLen, placeHoldersLen ];
        }
        function byteLength(b64) {
            var lens = getLens(b64);
            var validLen = lens[0];
            var placeHoldersLen = lens[1];
            return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
        }
        function _byteLength(b64, validLen, placeHoldersLen) {
            return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
        }
        function toByteArray(b64) {
            var tmp;
            var lens = getLens(b64);
            var validLen = lens[0];
            var placeHoldersLen = lens[1];
            var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));
            var curByte = 0;
            var len = placeHoldersLen > 0 ? validLen - 4 : validLen;
            var i;
            for (i = 0; i < len; i += 4) {
                tmp = revLookup[b64.charCodeAt(i)] << 18 | revLookup[b64.charCodeAt(i + 1)] << 12 | revLookup[b64.charCodeAt(i + 2)] << 6 | revLookup[b64.charCodeAt(i + 3)];
                arr[curByte++] = tmp >> 16 & 255;
                arr[curByte++] = tmp >> 8 & 255;
                arr[curByte++] = tmp & 255;
            }
            if (placeHoldersLen === 2) {
                tmp = revLookup[b64.charCodeAt(i)] << 2 | revLookup[b64.charCodeAt(i + 1)] >> 4;
                arr[curByte++] = tmp & 255;
            }
            if (placeHoldersLen === 1) {
                tmp = revLookup[b64.charCodeAt(i)] << 10 | revLookup[b64.charCodeAt(i + 1)] << 4 | revLookup[b64.charCodeAt(i + 2)] >> 2;
                arr[curByte++] = tmp >> 8 & 255;
                arr[curByte++] = tmp & 255;
            }
            return arr;
        }
        function tripletToBase64(num) {
            return lookup[num >> 18 & 63] + lookup[num >> 12 & 63] + lookup[num >> 6 & 63] + lookup[num & 63];
        }
        function encodeChunk(uint8, start, end) {
            var tmp;
            var output = [];
            for (var i = start; i < end; i += 3) {
                tmp = (uint8[i] << 16 & 16711680) + (uint8[i + 1] << 8 & 65280) + (uint8[i + 2] & 255);
                output.push(tripletToBase64(tmp));
            }
            return output.join("");
        }
        function fromByteArray(uint8) {
            var tmp;
            var len = uint8.length;
            var extraBytes = len % 3;
            var parts = [];
            var maxChunkLength = 16383;
            for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
                parts.push(encodeChunk(uint8, i, i + maxChunkLength > len2 ? len2 : i + maxChunkLength));
            }
            if (extraBytes === 1) {
                tmp = uint8[len - 1];
                parts.push(lookup[tmp >> 2] + lookup[tmp << 4 & 63] + "==");
            } else if (extraBytes === 2) {
                tmp = (uint8[len - 2] << 8) + uint8[len - 1];
                parts.push(lookup[tmp >> 10] + lookup[tmp >> 4 & 63] + lookup[tmp << 2 & 63] + "=");
            }
            return parts.join("");
        }
    },
    945: (__unused_webpack_module, exports, __webpack_require__) => {
        var __webpack_unused_export__;
        var base64 = __webpack_require__(796);
        var ieee754 = __webpack_require__(710);
        var customInspectSymbol = typeof Symbol === "function" && typeof Symbol["for"] === "function" ? Symbol["for"]("nodejs.util.inspect.custom") : null;
        exports.lW = Buffer;
        __webpack_unused_export__ = SlowBuffer;
        exports.h2 = 50;
        var K_MAX_LENGTH = 2147483647;
        __webpack_unused_export__ = K_MAX_LENGTH;
        Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport();
        if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== "undefined" && typeof console.error === "function") {
            console.error("This browser lacks typed array (Uint8Array) support which is required by " + "`buffer` v5.x. Use `buffer` v4.x if you require old browser support.");
        }
        function typedArraySupport() {
            try {
                var arr = new Uint8Array(1);
                var proto = {
                    foo: function() {
                        return 42;
                    }
                };
                Object.setPrototypeOf(proto, Uint8Array.prototype);
                Object.setPrototypeOf(arr, proto);
                return arr.foo() === 42;
            } catch (e) {
                return false;
            }
        }
        Object.defineProperty(Buffer.prototype, "parent", {
            enumerable: true,
            get: function() {
                if (!Buffer.isBuffer(this)) return undefined;
                return this.buffer;
            }
        });
        Object.defineProperty(Buffer.prototype, "offset", {
            enumerable: true,
            get: function() {
                if (!Buffer.isBuffer(this)) return undefined;
                return this.byteOffset;
            }
        });
        function createBuffer(length) {
            if (length > K_MAX_LENGTH) {
                throw new RangeError('The value "' + length + '" is invalid for option "size"');
            }
            var buf = new Uint8Array(length);
            Object.setPrototypeOf(buf, Buffer.prototype);
            return buf;
        }
        function Buffer(arg, encodingOrOffset, length) {
            if (typeof arg === "number") {
                if (typeof encodingOrOffset === "string") {
                    throw new TypeError('The "string" argument must be of type string. Received type number');
                }
                return allocUnsafe(arg);
            }
            return from(arg, encodingOrOffset, length);
        }
        Buffer.poolSize = 8192;
        function from(value, encodingOrOffset, length) {
            if (typeof value === "string") {
                return fromString(value, encodingOrOffset);
            }
            if (ArrayBuffer.isView(value)) {
                return fromArrayView(value);
            }
            if (value == null) {
                throw new TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, " + "or Array-like Object. Received type " + typeof value);
            }
            if (isInstance(value, ArrayBuffer) || value && isInstance(value.buffer, ArrayBuffer)) {
                return fromArrayBuffer(value, encodingOrOffset, length);
            }
            if (typeof SharedArrayBuffer !== "undefined" && (isInstance(value, SharedArrayBuffer) || value && isInstance(value.buffer, SharedArrayBuffer))) {
                return fromArrayBuffer(value, encodingOrOffset, length);
            }
            if (typeof value === "number") {
                throw new TypeError('The "value" argument must not be of type number. Received type number');
            }
            var valueOf = value.valueOf && value.valueOf();
            if (valueOf != null && valueOf !== value) {
                return Buffer.from(valueOf, encodingOrOffset, length);
            }
            var b = fromObject(value);
            if (b) return b;
            if (typeof Symbol !== "undefined" && Symbol.toPrimitive != null && typeof value[Symbol.toPrimitive] === "function") {
                return Buffer.from(value[Symbol.toPrimitive]("string"), encodingOrOffset, length);
            }
            throw new TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, " + "or Array-like Object. Received type " + typeof value);
        }
        Buffer.from = function(value, encodingOrOffset, length) {
            return from(value, encodingOrOffset, length);
        };
        Object.setPrototypeOf(Buffer.prototype, Uint8Array.prototype);
        Object.setPrototypeOf(Buffer, Uint8Array);
        function assertSize(size) {
            if (typeof size !== "number") {
                throw new TypeError('"size" argument must be of type number');
            } else if (size < 0) {
                throw new RangeError('The value "' + size + '" is invalid for option "size"');
            }
        }
        function alloc(size, fill, encoding) {
            assertSize(size);
            if (size <= 0) {
                return createBuffer(size);
            }
            if (fill !== undefined) {
                return typeof encoding === "string" ? createBuffer(size).fill(fill, encoding) : createBuffer(size).fill(fill);
            }
            return createBuffer(size);
        }
        Buffer.alloc = function(size, fill, encoding) {
            return alloc(size, fill, encoding);
        };
        function allocUnsafe(size) {
            assertSize(size);
            return createBuffer(size < 0 ? 0 : checked(size) | 0);
        }
        Buffer.allocUnsafe = function(size) {
            return allocUnsafe(size);
        };
        Buffer.allocUnsafeSlow = function(size) {
            return allocUnsafe(size);
        };
        function fromString(string, encoding) {
            if (typeof encoding !== "string" || encoding === "") {
                encoding = "utf8";
            }
            if (!Buffer.isEncoding(encoding)) {
                throw new TypeError("Unknown encoding: " + encoding);
            }
            var length = byteLength(string, encoding) | 0;
            var buf = createBuffer(length);
            var actual = buf.write(string, encoding);
            if (actual !== length) {
                buf = buf.slice(0, actual);
            }
            return buf;
        }
        function fromArrayLike(array) {
            var length = array.length < 0 ? 0 : checked(array.length) | 0;
            var buf = createBuffer(length);
            for (var i = 0; i < length; i += 1) {
                buf[i] = array[i] & 255;
            }
            return buf;
        }
        function fromArrayView(arrayView) {
            if (isInstance(arrayView, Uint8Array)) {
                var copy = new Uint8Array(arrayView);
                return fromArrayBuffer(copy.buffer, copy.byteOffset, copy.byteLength);
            }
            return fromArrayLike(arrayView);
        }
        function fromArrayBuffer(array, byteOffset, length) {
            if (byteOffset < 0 || array.byteLength < byteOffset) {
                throw new RangeError('"offset" is outside of buffer bounds');
            }
            if (array.byteLength < byteOffset + (length || 0)) {
                throw new RangeError('"length" is outside of buffer bounds');
            }
            var buf;
            if (byteOffset === undefined && length === undefined) {
                buf = new Uint8Array(array);
            } else if (length === undefined) {
                buf = new Uint8Array(array, byteOffset);
            } else {
                buf = new Uint8Array(array, byteOffset, length);
            }
            Object.setPrototypeOf(buf, Buffer.prototype);
            return buf;
        }
        function fromObject(obj) {
            if (Buffer.isBuffer(obj)) {
                var len = checked(obj.length) | 0;
                var buf = createBuffer(len);
                if (buf.length === 0) {
                    return buf;
                }
                obj.copy(buf, 0, 0, len);
                return buf;
            }
            if (obj.length !== undefined) {
                if (typeof obj.length !== "number" || numberIsNaN(obj.length)) {
                    return createBuffer(0);
                }
                return fromArrayLike(obj);
            }
            if (obj.type === "Buffer" && Array.isArray(obj.data)) {
                return fromArrayLike(obj.data);
            }
        }
        function checked(length) {
            if (length >= K_MAX_LENGTH) {
                throw new RangeError("Attempt to allocate Buffer larger than maximum " + "size: 0x" + K_MAX_LENGTH.toString(16) + " bytes");
            }
            return length | 0;
        }
        function SlowBuffer(length) {
            if (+length != length) {
                length = 0;
            }
            return Buffer.alloc(+length);
        }
        Buffer.isBuffer = function isBuffer(b) {
            return b != null && b._isBuffer === true && b !== Buffer.prototype;
        };
        Buffer.compare = function compare(a, b) {
            if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength);
            if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength);
            if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
                throw new TypeError('The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array');
            }
            if (a === b) return 0;
            var x = a.length;
            var y = b.length;
            for (var i = 0, len = Math.min(x, y); i < len; ++i) {
                if (a[i] !== b[i]) {
                    x = a[i];
                    y = b[i];
                    break;
                }
            }
            if (x < y) return -1;
            if (y < x) return 1;
            return 0;
        };
        Buffer.isEncoding = function isEncoding(encoding) {
            switch (String(encoding).toLowerCase()) {
              case "hex":
              case "utf8":
              case "utf-8":
              case "ascii":
              case "latin1":
              case "binary":
              case "base64":
              case "ucs2":
              case "ucs-2":
              case "utf16le":
              case "utf-16le":
                return true;

              default:
                return false;
            }
        };
        Buffer.concat = function concat(list, length) {
            if (!Array.isArray(list)) {
                throw new TypeError('"list" argument must be an Array of Buffers');
            }
            if (list.length === 0) {
                return Buffer.alloc(0);
            }
            var i;
            if (length === undefined) {
                length = 0;
                for (i = 0; i < list.length; ++i) {
                    length += list[i].length;
                }
            }
            var buffer = Buffer.allocUnsafe(length);
            var pos = 0;
            for (i = 0; i < list.length; ++i) {
                var buf = list[i];
                if (isInstance(buf, Uint8Array)) {
                    if (pos + buf.length > buffer.length) {
                        Buffer.from(buf).copy(buffer, pos);
                    } else {
                        Uint8Array.prototype.set.call(buffer, buf, pos);
                    }
                } else if (!Buffer.isBuffer(buf)) {
                    throw new TypeError('"list" argument must be an Array of Buffers');
                } else {
                    buf.copy(buffer, pos);
                }
                pos += buf.length;
            }
            return buffer;
        };
        function byteLength(string, encoding) {
            if (Buffer.isBuffer(string)) {
                return string.length;
            }
            if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
                return string.byteLength;
            }
            if (typeof string !== "string") {
                throw new TypeError('The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' + "Received type " + typeof string);
            }
            var len = string.length;
            var mustMatch = arguments.length > 2 && arguments[2] === true;
            if (!mustMatch && len === 0) return 0;
            var loweredCase = false;
            for (;;) {
                switch (encoding) {
                  case "ascii":
                  case "latin1":
                  case "binary":
                    return len;

                  case "utf8":
                  case "utf-8":
                    return utf8ToBytes(string).length;

                  case "ucs2":
                  case "ucs-2":
                  case "utf16le":
                  case "utf-16le":
                    return len * 2;

                  case "hex":
                    return len >>> 1;

                  case "base64":
                    return base64ToBytes(string).length;

                  default:
                    if (loweredCase) {
                        return mustMatch ? -1 : utf8ToBytes(string).length;
                    }
                    encoding = ("" + encoding).toLowerCase();
                    loweredCase = true;
                }
            }
        }
        Buffer.byteLength = byteLength;
        function slowToString(encoding, start, end) {
            var loweredCase = false;
            if (start === undefined || start < 0) {
                start = 0;
            }
            if (start > this.length) {
                return "";
            }
            if (end === undefined || end > this.length) {
                end = this.length;
            }
            if (end <= 0) {
                return "";
            }
            end >>>= 0;
            start >>>= 0;
            if (end <= start) {
                return "";
            }
            if (!encoding) encoding = "utf8";
            while (true) {
                switch (encoding) {
                  case "hex":
                    return hexSlice(this, start, end);

                  case "utf8":
                  case "utf-8":
                    return utf8Slice(this, start, end);

                  case "ascii":
                    return asciiSlice(this, start, end);

                  case "latin1":
                  case "binary":
                    return latin1Slice(this, start, end);

                  case "base64":
                    return base64Slice(this, start, end);

                  case "ucs2":
                  case "ucs-2":
                  case "utf16le":
                  case "utf-16le":
                    return utf16leSlice(this, start, end);

                  default:
                    if (loweredCase) throw new TypeError("Unknown encoding: " + encoding);
                    encoding = (encoding + "").toLowerCase();
                    loweredCase = true;
                }
            }
        }
        Buffer.prototype._isBuffer = true;
        function swap(b, n, m) {
            var i = b[n];
            b[n] = b[m];
            b[m] = i;
        }
        Buffer.prototype.swap16 = function swap16() {
            var len = this.length;
            if (len % 2 !== 0) {
                throw new RangeError("Buffer size must be a multiple of 16-bits");
            }
            for (var i = 0; i < len; i += 2) {
                swap(this, i, i + 1);
            }
            return this;
        };
        Buffer.prototype.swap32 = function swap32() {
            var len = this.length;
            if (len % 4 !== 0) {
                throw new RangeError("Buffer size must be a multiple of 32-bits");
            }
            for (var i = 0; i < len; i += 4) {
                swap(this, i, i + 3);
                swap(this, i + 1, i + 2);
            }
            return this;
        };
        Buffer.prototype.swap64 = function swap64() {
            var len = this.length;
            if (len % 8 !== 0) {
                throw new RangeError("Buffer size must be a multiple of 64-bits");
            }
            for (var i = 0; i < len; i += 8) {
                swap(this, i, i + 7);
                swap(this, i + 1, i + 6);
                swap(this, i + 2, i + 5);
                swap(this, i + 3, i + 4);
            }
            return this;
        };
        Buffer.prototype.toString = function toString() {
            var length = this.length;
            if (length === 0) return "";
            if (arguments.length === 0) return utf8Slice(this, 0, length);
            return slowToString.apply(this, arguments);
        };
        Buffer.prototype.toLocaleString = Buffer.prototype.toString;
        Buffer.prototype.equals = function equals(b) {
            if (!Buffer.isBuffer(b)) throw new TypeError("Argument must be a Buffer");
            if (this === b) return true;
            return Buffer.compare(this, b) === 0;
        };
        Buffer.prototype.inspect = function inspect() {
            var str = "";
            var max = exports.h2;
            str = this.toString("hex", 0, max).replace(/(.{2})/g, "$1 ").trim();
            if (this.length > max) str += " ... ";
            return "<Buffer " + str + ">";
        };
        if (customInspectSymbol) {
            Buffer.prototype[customInspectSymbol] = Buffer.prototype.inspect;
        }
        Buffer.prototype.compare = function compare(target, start, end, thisStart, thisEnd) {
            if (isInstance(target, Uint8Array)) {
                target = Buffer.from(target, target.offset, target.byteLength);
            }
            if (!Buffer.isBuffer(target)) {
                throw new TypeError('The "target" argument must be one of type Buffer or Uint8Array. ' + "Received type " + typeof target);
            }
            if (start === undefined) {
                start = 0;
            }
            if (end === undefined) {
                end = target ? target.length : 0;
            }
            if (thisStart === undefined) {
                thisStart = 0;
            }
            if (thisEnd === undefined) {
                thisEnd = this.length;
            }
            if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
                throw new RangeError("out of range index");
            }
            if (thisStart >= thisEnd && start >= end) {
                return 0;
            }
            if (thisStart >= thisEnd) {
                return -1;
            }
            if (start >= end) {
                return 1;
            }
            start >>>= 0;
            end >>>= 0;
            thisStart >>>= 0;
            thisEnd >>>= 0;
            if (this === target) return 0;
            var x = thisEnd - thisStart;
            var y = end - start;
            var len = Math.min(x, y);
            var thisCopy = this.slice(thisStart, thisEnd);
            var targetCopy = target.slice(start, end);
            for (var i = 0; i < len; ++i) {
                if (thisCopy[i] !== targetCopy[i]) {
                    x = thisCopy[i];
                    y = targetCopy[i];
                    break;
                }
            }
            if (x < y) return -1;
            if (y < x) return 1;
            return 0;
        };
        function bidirectionalIndexOf(buffer, val, byteOffset, encoding, dir) {
            if (buffer.length === 0) return -1;
            if (typeof byteOffset === "string") {
                encoding = byteOffset;
                byteOffset = 0;
            } else if (byteOffset > 2147483647) {
                byteOffset = 2147483647;
            } else if (byteOffset < -2147483648) {
                byteOffset = -2147483648;
            }
            byteOffset = +byteOffset;
            if (numberIsNaN(byteOffset)) {
                byteOffset = dir ? 0 : buffer.length - 1;
            }
            if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
            if (byteOffset >= buffer.length) {
                if (dir) return -1; else byteOffset = buffer.length - 1;
            } else if (byteOffset < 0) {
                if (dir) byteOffset = 0; else return -1;
            }
            if (typeof val === "string") {
                val = Buffer.from(val, encoding);
            }
            if (Buffer.isBuffer(val)) {
                if (val.length === 0) {
                    return -1;
                }
                return arrayIndexOf(buffer, val, byteOffset, encoding, dir);
            } else if (typeof val === "number") {
                val = val & 255;
                if (typeof Uint8Array.prototype.indexOf === "function") {
                    if (dir) {
                        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset);
                    } else {
                        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset);
                    }
                }
                return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir);
            }
            throw new TypeError("val must be string, number or Buffer");
        }
        function arrayIndexOf(arr, val, byteOffset, encoding, dir) {
            var indexSize = 1;
            var arrLength = arr.length;
            var valLength = val.length;
            if (encoding !== undefined) {
                encoding = String(encoding).toLowerCase();
                if (encoding === "ucs2" || encoding === "ucs-2" || encoding === "utf16le" || encoding === "utf-16le") {
                    if (arr.length < 2 || val.length < 2) {
                        return -1;
                    }
                    indexSize = 2;
                    arrLength /= 2;
                    valLength /= 2;
                    byteOffset /= 2;
                }
            }
            function read(buf, i) {
                if (indexSize === 1) {
                    return buf[i];
                } else {
                    return buf.readUInt16BE(i * indexSize);
                }
            }
            var i;
            if (dir) {
                var foundIndex = -1;
                for (i = byteOffset; i < arrLength; i++) {
                    if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
                        if (foundIndex === -1) foundIndex = i;
                        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize;
                    } else {
                        if (foundIndex !== -1) i -= i - foundIndex;
                        foundIndex = -1;
                    }
                }
            } else {
                if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
                for (i = byteOffset; i >= 0; i--) {
                    var found = true;
                    for (var j = 0; j < valLength; j++) {
                        if (read(arr, i + j) !== read(val, j)) {
                            found = false;
                            break;
                        }
                    }
                    if (found) return i;
                }
            }
            return -1;
        }
        Buffer.prototype.includes = function includes(val, byteOffset, encoding) {
            return this.indexOf(val, byteOffset, encoding) !== -1;
        };
        Buffer.prototype.indexOf = function indexOf(val, byteOffset, encoding) {
            return bidirectionalIndexOf(this, val, byteOffset, encoding, true);
        };
        Buffer.prototype.lastIndexOf = function lastIndexOf(val, byteOffset, encoding) {
            return bidirectionalIndexOf(this, val, byteOffset, encoding, false);
        };
        function hexWrite(buf, string, offset, length) {
            offset = Number(offset) || 0;
            var remaining = buf.length - offset;
            if (!length) {
                length = remaining;
            } else {
                length = Number(length);
                if (length > remaining) {
                    length = remaining;
                }
            }
            var strLen = string.length;
            if (length > strLen / 2) {
                length = strLen / 2;
            }
            for (var i = 0; i < length; ++i) {
                var parsed = parseInt(string.substr(i * 2, 2), 16);
                if (numberIsNaN(parsed)) return i;
                buf[offset + i] = parsed;
            }
            return i;
        }
        function utf8Write(buf, string, offset, length) {
            return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length);
        }
        function asciiWrite(buf, string, offset, length) {
            return blitBuffer(asciiToBytes(string), buf, offset, length);
        }
        function base64Write(buf, string, offset, length) {
            return blitBuffer(base64ToBytes(string), buf, offset, length);
        }
        function ucs2Write(buf, string, offset, length) {
            return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length);
        }
        Buffer.prototype.write = function write(string, offset, length, encoding) {
            if (offset === undefined) {
                encoding = "utf8";
                length = this.length;
                offset = 0;
            } else if (length === undefined && typeof offset === "string") {
                encoding = offset;
                length = this.length;
                offset = 0;
            } else if (isFinite(offset)) {
                offset = offset >>> 0;
                if (isFinite(length)) {
                    length = length >>> 0;
                    if (encoding === undefined) encoding = "utf8";
                } else {
                    encoding = length;
                    length = undefined;
                }
            } else {
                throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");
            }
            var remaining = this.length - offset;
            if (length === undefined || length > remaining) length = remaining;
            if (string.length > 0 && (length < 0 || offset < 0) || offset > this.length) {
                throw new RangeError("Attempt to write outside buffer bounds");
            }
            if (!encoding) encoding = "utf8";
            var loweredCase = false;
            for (;;) {
                switch (encoding) {
                  case "hex":
                    return hexWrite(this, string, offset, length);

                  case "utf8":
                  case "utf-8":
                    return utf8Write(this, string, offset, length);

                  case "ascii":
                  case "latin1":
                  case "binary":
                    return asciiWrite(this, string, offset, length);

                  case "base64":
                    return base64Write(this, string, offset, length);

                  case "ucs2":
                  case "ucs-2":
                  case "utf16le":
                  case "utf-16le":
                    return ucs2Write(this, string, offset, length);

                  default:
                    if (loweredCase) throw new TypeError("Unknown encoding: " + encoding);
                    encoding = ("" + encoding).toLowerCase();
                    loweredCase = true;
                }
            }
        };
        Buffer.prototype.toJSON = function toJSON() {
            return {
                type: "Buffer",
                data: Array.prototype.slice.call(this._arr || this, 0)
            };
        };
        function base64Slice(buf, start, end) {
            if (start === 0 && end === buf.length) {
                return base64.fromByteArray(buf);
            } else {
                return base64.fromByteArray(buf.slice(start, end));
            }
        }
        function utf8Slice(buf, start, end) {
            end = Math.min(buf.length, end);
            var res = [];
            var i = start;
            while (i < end) {
                var firstByte = buf[i];
                var codePoint = null;
                var bytesPerSequence = firstByte > 239 ? 4 : firstByte > 223 ? 3 : firstByte > 191 ? 2 : 1;
                if (i + bytesPerSequence <= end) {
                    var secondByte, thirdByte, fourthByte, tempCodePoint;
                    switch (bytesPerSequence) {
                      case 1:
                        if (firstByte < 128) {
                            codePoint = firstByte;
                        }
                        break;

                      case 2:
                        secondByte = buf[i + 1];
                        if ((secondByte & 192) === 128) {
                            tempCodePoint = (firstByte & 31) << 6 | secondByte & 63;
                            if (tempCodePoint > 127) {
                                codePoint = tempCodePoint;
                            }
                        }
                        break;

                      case 3:
                        secondByte = buf[i + 1];
                        thirdByte = buf[i + 2];
                        if ((secondByte & 192) === 128 && (thirdByte & 192) === 128) {
                            tempCodePoint = (firstByte & 15) << 12 | (secondByte & 63) << 6 | thirdByte & 63;
                            if (tempCodePoint > 2047 && (tempCodePoint < 55296 || tempCodePoint > 57343)) {
                                codePoint = tempCodePoint;
                            }
                        }
                        break;

                      case 4:
                        secondByte = buf[i + 1];
                        thirdByte = buf[i + 2];
                        fourthByte = buf[i + 3];
                        if ((secondByte & 192) === 128 && (thirdByte & 192) === 128 && (fourthByte & 192) === 128) {
                            tempCodePoint = (firstByte & 15) << 18 | (secondByte & 63) << 12 | (thirdByte & 63) << 6 | fourthByte & 63;
                            if (tempCodePoint > 65535 && tempCodePoint < 1114112) {
                                codePoint = tempCodePoint;
                            }
                        }
                    }
                }
                if (codePoint === null) {
                    codePoint = 65533;
                    bytesPerSequence = 1;
                } else if (codePoint > 65535) {
                    codePoint -= 65536;
                    res.push(codePoint >>> 10 & 1023 | 55296);
                    codePoint = 56320 | codePoint & 1023;
                }
                res.push(codePoint);
                i += bytesPerSequence;
            }
            return decodeCodePointsArray(res);
        }
        var MAX_ARGUMENTS_LENGTH = 4096;
        function decodeCodePointsArray(codePoints) {
            var len = codePoints.length;
            if (len <= MAX_ARGUMENTS_LENGTH) {
                return String.fromCharCode.apply(String, codePoints);
            }
            var res = "";
            var i = 0;
            while (i < len) {
                res += String.fromCharCode.apply(String, codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH));
            }
            return res;
        }
        function asciiSlice(buf, start, end) {
            var ret = "";
            end = Math.min(buf.length, end);
            for (var i = start; i < end; ++i) {
                ret += String.fromCharCode(buf[i] & 127);
            }
            return ret;
        }
        function latin1Slice(buf, start, end) {
            var ret = "";
            end = Math.min(buf.length, end);
            for (var i = start; i < end; ++i) {
                ret += String.fromCharCode(buf[i]);
            }
            return ret;
        }
        function hexSlice(buf, start, end) {
            var len = buf.length;
            if (!start || start < 0) start = 0;
            if (!end || end < 0 || end > len) end = len;
            var out = "";
            for (var i = start; i < end; ++i) {
                out += hexSliceLookupTable[buf[i]];
            }
            return out;
        }
        function utf16leSlice(buf, start, end) {
            var bytes = buf.slice(start, end);
            var res = "";
            for (var i = 0; i < bytes.length - 1; i += 2) {
                res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
            }
            return res;
        }
        Buffer.prototype.slice = function slice(start, end) {
            var len = this.length;
            start = ~~start;
            end = end === undefined ? len : ~~end;
            if (start < 0) {
                start += len;
                if (start < 0) start = 0;
            } else if (start > len) {
                start = len;
            }
            if (end < 0) {
                end += len;
                if (end < 0) end = 0;
            } else if (end > len) {
                end = len;
            }
            if (end < start) end = start;
            var newBuf = this.subarray(start, end);
            Object.setPrototypeOf(newBuf, Buffer.prototype);
            return newBuf;
        };
        function checkOffset(offset, ext, length) {
            if (offset % 1 !== 0 || offset < 0) throw new RangeError("offset is not uint");
            if (offset + ext > length) throw new RangeError("Trying to access beyond buffer length");
        }
        Buffer.prototype.readUintLE = Buffer.prototype.readUIntLE = function readUIntLE(offset, byteLength, noAssert) {
            offset = offset >>> 0;
            byteLength = byteLength >>> 0;
            if (!noAssert) checkOffset(offset, byteLength, this.length);
            var val = this[offset];
            var mul = 1;
            var i = 0;
            while (++i < byteLength && (mul *= 256)) {
                val += this[offset + i] * mul;
            }
            return val;
        };
        Buffer.prototype.readUintBE = Buffer.prototype.readUIntBE = function readUIntBE(offset, byteLength, noAssert) {
            offset = offset >>> 0;
            byteLength = byteLength >>> 0;
            if (!noAssert) {
                checkOffset(offset, byteLength, this.length);
            }
            var val = this[offset + --byteLength];
            var mul = 1;
            while (byteLength > 0 && (mul *= 256)) {
                val += this[offset + --byteLength] * mul;
            }
            return val;
        };
        Buffer.prototype.readUint8 = Buffer.prototype.readUInt8 = function readUInt8(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 1, this.length);
            return this[offset];
        };
        Buffer.prototype.readUint16LE = Buffer.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 2, this.length);
            return this[offset] | this[offset + 1] << 8;
        };
        Buffer.prototype.readUint16BE = Buffer.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 2, this.length);
            return this[offset] << 8 | this[offset + 1];
        };
        Buffer.prototype.readUint32LE = Buffer.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 4, this.length);
            return (this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16) + this[offset + 3] * 16777216;
        };
        Buffer.prototype.readUint32BE = Buffer.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 4, this.length);
            return this[offset] * 16777216 + (this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3]);
        };
        Buffer.prototype.readIntLE = function readIntLE(offset, byteLength, noAssert) {
            offset = offset >>> 0;
            byteLength = byteLength >>> 0;
            if (!noAssert) checkOffset(offset, byteLength, this.length);
            var val = this[offset];
            var mul = 1;
            var i = 0;
            while (++i < byteLength && (mul *= 256)) {
                val += this[offset + i] * mul;
            }
            mul *= 128;
            if (val >= mul) val -= Math.pow(2, 8 * byteLength);
            return val;
        };
        Buffer.prototype.readIntBE = function readIntBE(offset, byteLength, noAssert) {
            offset = offset >>> 0;
            byteLength = byteLength >>> 0;
            if (!noAssert) checkOffset(offset, byteLength, this.length);
            var i = byteLength;
            var mul = 1;
            var val = this[offset + --i];
            while (i > 0 && (mul *= 256)) {
                val += this[offset + --i] * mul;
            }
            mul *= 128;
            if (val >= mul) val -= Math.pow(2, 8 * byteLength);
            return val;
        };
        Buffer.prototype.readInt8 = function readInt8(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 1, this.length);
            if (!(this[offset] & 128)) return this[offset];
            return (255 - this[offset] + 1) * -1;
        };
        Buffer.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 2, this.length);
            var val = this[offset] | this[offset + 1] << 8;
            return val & 32768 ? val | 4294901760 : val;
        };
        Buffer.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 2, this.length);
            var val = this[offset + 1] | this[offset] << 8;
            return val & 32768 ? val | 4294901760 : val;
        };
        Buffer.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 4, this.length);
            return this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16 | this[offset + 3] << 24;
        };
        Buffer.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 4, this.length);
            return this[offset] << 24 | this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3];
        };
        Buffer.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 4, this.length);
            return ieee754.read(this, offset, true, 23, 4);
        };
        Buffer.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 4, this.length);
            return ieee754.read(this, offset, false, 23, 4);
        };
        Buffer.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 8, this.length);
            return ieee754.read(this, offset, true, 52, 8);
        };
        Buffer.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 8, this.length);
            return ieee754.read(this, offset, false, 52, 8);
        };
        function checkInt(buf, value, offset, ext, max, min) {
            if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance');
            if (value > max || value < min) throw new RangeError('"value" argument is out of bounds');
            if (offset + ext > buf.length) throw new RangeError("Index out of range");
        }
        Buffer.prototype.writeUintLE = Buffer.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength, noAssert) {
            value = +value;
            offset = offset >>> 0;
            byteLength = byteLength >>> 0;
            if (!noAssert) {
                var maxBytes = Math.pow(2, 8 * byteLength) - 1;
                checkInt(this, value, offset, byteLength, maxBytes, 0);
            }
            var mul = 1;
            var i = 0;
            this[offset] = value & 255;
            while (++i < byteLength && (mul *= 256)) {
                this[offset + i] = value / mul & 255;
            }
            return offset + byteLength;
        };
        Buffer.prototype.writeUintBE = Buffer.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength, noAssert) {
            value = +value;
            offset = offset >>> 0;
            byteLength = byteLength >>> 0;
            if (!noAssert) {
                var maxBytes = Math.pow(2, 8 * byteLength) - 1;
                checkInt(this, value, offset, byteLength, maxBytes, 0);
            }
            var i = byteLength - 1;
            var mul = 1;
            this[offset + i] = value & 255;
            while (--i >= 0 && (mul *= 256)) {
                this[offset + i] = value / mul & 255;
            }
            return offset + byteLength;
        };
        Buffer.prototype.writeUint8 = Buffer.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 1, 255, 0);
            this[offset] = value & 255;
            return offset + 1;
        };
        Buffer.prototype.writeUint16LE = Buffer.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 2, 65535, 0);
            this[offset] = value & 255;
            this[offset + 1] = value >>> 8;
            return offset + 2;
        };
        Buffer.prototype.writeUint16BE = Buffer.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 2, 65535, 0);
            this[offset] = value >>> 8;
            this[offset + 1] = value & 255;
            return offset + 2;
        };
        Buffer.prototype.writeUint32LE = Buffer.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 4, 4294967295, 0);
            this[offset + 3] = value >>> 24;
            this[offset + 2] = value >>> 16;
            this[offset + 1] = value >>> 8;
            this[offset] = value & 255;
            return offset + 4;
        };
        Buffer.prototype.writeUint32BE = Buffer.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 4, 4294967295, 0);
            this[offset] = value >>> 24;
            this[offset + 1] = value >>> 16;
            this[offset + 2] = value >>> 8;
            this[offset + 3] = value & 255;
            return offset + 4;
        };
        Buffer.prototype.writeIntLE = function writeIntLE(value, offset, byteLength, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) {
                var limit = Math.pow(2, 8 * byteLength - 1);
                checkInt(this, value, offset, byteLength, limit - 1, -limit);
            }
            var i = 0;
            var mul = 1;
            var sub = 0;
            this[offset] = value & 255;
            while (++i < byteLength && (mul *= 256)) {
                if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
                    sub = 1;
                }
                this[offset + i] = (value / mul >> 0) - sub & 255;
            }
            return offset + byteLength;
        };
        Buffer.prototype.writeIntBE = function writeIntBE(value, offset, byteLength, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) {
                var limit = Math.pow(2, 8 * byteLength - 1);
                checkInt(this, value, offset, byteLength, limit - 1, -limit);
            }
            var i = byteLength - 1;
            var mul = 1;
            var sub = 0;
            this[offset + i] = value & 255;
            while (--i >= 0 && (mul *= 256)) {
                if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
                    sub = 1;
                }
                this[offset + i] = (value / mul >> 0) - sub & 255;
            }
            return offset + byteLength;
        };
        Buffer.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 1, 127, -128);
            if (value < 0) value = 255 + value + 1;
            this[offset] = value & 255;
            return offset + 1;
        };
        Buffer.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 2, 32767, -32768);
            this[offset] = value & 255;
            this[offset + 1] = value >>> 8;
            return offset + 2;
        };
        Buffer.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 2, 32767, -32768);
            this[offset] = value >>> 8;
            this[offset + 1] = value & 255;
            return offset + 2;
        };
        Buffer.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 4, 2147483647, -2147483648);
            this[offset] = value & 255;
            this[offset + 1] = value >>> 8;
            this[offset + 2] = value >>> 16;
            this[offset + 3] = value >>> 24;
            return offset + 4;
        };
        Buffer.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 4, 2147483647, -2147483648);
            if (value < 0) value = 4294967295 + value + 1;
            this[offset] = value >>> 24;
            this[offset + 1] = value >>> 16;
            this[offset + 2] = value >>> 8;
            this[offset + 3] = value & 255;
            return offset + 4;
        };
        function checkIEEE754(buf, value, offset, ext, max, min) {
            if (offset + ext > buf.length) throw new RangeError("Index out of range");
            if (offset < 0) throw new RangeError("Index out of range");
        }
        function writeFloat(buf, value, offset, littleEndian, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) {
                checkIEEE754(buf, value, offset, 4, 34028234663852886e22, -34028234663852886e22);
            }
            ieee754.write(buf, value, offset, littleEndian, 23, 4);
            return offset + 4;
        }
        Buffer.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
            return writeFloat(this, value, offset, true, noAssert);
        };
        Buffer.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
            return writeFloat(this, value, offset, false, noAssert);
        };
        function writeDouble(buf, value, offset, littleEndian, noAssert) {
            value = +value;
            offset = offset >>> 0;
            if (!noAssert) {
                checkIEEE754(buf, value, offset, 8, 17976931348623157e292, -17976931348623157e292);
            }
            ieee754.write(buf, value, offset, littleEndian, 52, 8);
            return offset + 8;
        }
        Buffer.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
            return writeDouble(this, value, offset, true, noAssert);
        };
        Buffer.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
            return writeDouble(this, value, offset, false, noAssert);
        };
        Buffer.prototype.copy = function copy(target, targetStart, start, end) {
            if (!Buffer.isBuffer(target)) throw new TypeError("argument should be a Buffer");
            if (!start) start = 0;
            if (!end && end !== 0) end = this.length;
            if (targetStart >= target.length) targetStart = target.length;
            if (!targetStart) targetStart = 0;
            if (end > 0 && end < start) end = start;
            if (end === start) return 0;
            if (target.length === 0 || this.length === 0) return 0;
            if (targetStart < 0) {
                throw new RangeError("targetStart out of bounds");
            }
            if (start < 0 || start >= this.length) throw new RangeError("Index out of range");
            if (end < 0) throw new RangeError("sourceEnd out of bounds");
            if (end > this.length) end = this.length;
            if (target.length - targetStart < end - start) {
                end = target.length - targetStart + start;
            }
            var len = end - start;
            if (this === target && typeof Uint8Array.prototype.copyWithin === "function") {
                this.copyWithin(targetStart, start, end);
            } else {
                Uint8Array.prototype.set.call(target, this.subarray(start, end), targetStart);
            }
            return len;
        };
        Buffer.prototype.fill = function fill(val, start, end, encoding) {
            if (typeof val === "string") {
                if (typeof start === "string") {
                    encoding = start;
                    start = 0;
                    end = this.length;
                } else if (typeof end === "string") {
                    encoding = end;
                    end = this.length;
                }
                if (encoding !== undefined && typeof encoding !== "string") {
                    throw new TypeError("encoding must be a string");
                }
                if (typeof encoding === "string" && !Buffer.isEncoding(encoding)) {
                    throw new TypeError("Unknown encoding: " + encoding);
                }
                if (val.length === 1) {
                    var code = val.charCodeAt(0);
                    if (encoding === "utf8" && code < 128 || encoding === "latin1") {
                        val = code;
                    }
                }
            } else if (typeof val === "number") {
                val = val & 255;
            } else if (typeof val === "boolean") {
                val = Number(val);
            }
            if (start < 0 || this.length < start || this.length < end) {
                throw new RangeError("Out of range index");
            }
            if (end <= start) {
                return this;
            }
            start = start >>> 0;
            end = end === undefined ? this.length : end >>> 0;
            if (!val) val = 0;
            var i;
            if (typeof val === "number") {
                for (i = start; i < end; ++i) {
                    this[i] = val;
                }
            } else {
                var bytes = Buffer.isBuffer(val) ? val : Buffer.from(val, encoding);
                var len = bytes.length;
                if (len === 0) {
                    throw new TypeError('The value "' + val + '" is invalid for argument "value"');
                }
                for (i = 0; i < end - start; ++i) {
                    this[i + start] = bytes[i % len];
                }
            }
            return this;
        };
        var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;
        function base64clean(str) {
            str = str.split("=")[0];
            str = str.trim().replace(INVALID_BASE64_RE, "");
            if (str.length < 2) return "";
            while (str.length % 4 !== 0) {
                str = str + "=";
            }
            return str;
        }
        function utf8ToBytes(string, units) {
            units = units || Infinity;
            var codePoint;
            var length = string.length;
            var leadSurrogate = null;
            var bytes = [];
            for (var i = 0; i < length; ++i) {
                codePoint = string.charCodeAt(i);
                if (codePoint > 55295 && codePoint < 57344) {
                    if (!leadSurrogate) {
                        if (codePoint > 56319) {
                            if ((units -= 3) > -1) bytes.push(239, 191, 189);
                            continue;
                        } else if (i + 1 === length) {
                            if ((units -= 3) > -1) bytes.push(239, 191, 189);
                            continue;
                        }
                        leadSurrogate = codePoint;
                        continue;
                    }
                    if (codePoint < 56320) {
                        if ((units -= 3) > -1) bytes.push(239, 191, 189);
                        leadSurrogate = codePoint;
                        continue;
                    }
                    codePoint = (leadSurrogate - 55296 << 10 | codePoint - 56320) + 65536;
                } else if (leadSurrogate) {
                    if ((units -= 3) > -1) bytes.push(239, 191, 189);
                }
                leadSurrogate = null;
                if (codePoint < 128) {
                    if ((units -= 1) < 0) break;
                    bytes.push(codePoint);
                } else if (codePoint < 2048) {
                    if ((units -= 2) < 0) break;
                    bytes.push(codePoint >> 6 | 192, codePoint & 63 | 128);
                } else if (codePoint < 65536) {
                    if ((units -= 3) < 0) break;
                    bytes.push(codePoint >> 12 | 224, codePoint >> 6 & 63 | 128, codePoint & 63 | 128);
                } else if (codePoint < 1114112) {
                    if ((units -= 4) < 0) break;
                    bytes.push(codePoint >> 18 | 240, codePoint >> 12 & 63 | 128, codePoint >> 6 & 63 | 128, codePoint & 63 | 128);
                } else {
                    throw new Error("Invalid code point");
                }
            }
            return bytes;
        }
        function asciiToBytes(str) {
            var byteArray = [];
            for (var i = 0; i < str.length; ++i) {
                byteArray.push(str.charCodeAt(i) & 255);
            }
            return byteArray;
        }
        function utf16leToBytes(str, units) {
            var c, hi, lo;
            var byteArray = [];
            for (var i = 0; i < str.length; ++i) {
                if ((units -= 2) < 0) break;
                c = str.charCodeAt(i);
                hi = c >> 8;
                lo = c % 256;
                byteArray.push(lo);
                byteArray.push(hi);
            }
            return byteArray;
        }
        function base64ToBytes(str) {
            return base64.toByteArray(base64clean(str));
        }
        function blitBuffer(src, dst, offset, length) {
            for (var i = 0; i < length; ++i) {
                if (i + offset >= dst.length || i >= src.length) break;
                dst[i + offset] = src[i];
            }
            return i;
        }
        function isInstance(obj, type) {
            return obj instanceof type || obj != null && obj.constructor != null && obj.constructor.name != null && obj.constructor.name === type.name;
        }
        function numberIsNaN(obj) {
            return obj !== obj;
        }
        var hexSliceLookupTable = function() {
            var alphabet = "0123456789abcdef";
            var table = new Array(256);
            for (var i = 0; i < 16; ++i) {
                var i16 = i * 16;
                for (var j = 0; j < 16; ++j) {
                    table[i16 + j] = alphabet[i] + alphabet[j];
                }
            }
            return table;
        }();
    },
    710: (__unused_webpack_module, exports) => {
        exports.read = function(buffer, offset, isLE, mLen, nBytes) {
            var e, m;
            var eLen = nBytes * 8 - mLen - 1;
            var eMax = (1 << eLen) - 1;
            var eBias = eMax >> 1;
            var nBits = -7;
            var i = isLE ? nBytes - 1 : 0;
            var d = isLE ? -1 : 1;
            var s = buffer[offset + i];
            i += d;
            e = s & (1 << -nBits) - 1;
            s >>= -nBits;
            nBits += eLen;
            for (;nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}
            m = e & (1 << -nBits) - 1;
            e >>= -nBits;
            nBits += mLen;
            for (;nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}
            if (e === 0) {
                e = 1 - eBias;
            } else if (e === eMax) {
                return m ? NaN : (s ? -1 : 1) * Infinity;
            } else {
                m = m + Math.pow(2, mLen);
                e = e - eBias;
            }
            return (s ? -1 : 1) * m * Math.pow(2, e - mLen);
        };
        exports.write = function(buffer, value, offset, isLE, mLen, nBytes) {
            var e, m, c;
            var eLen = nBytes * 8 - mLen - 1;
            var eMax = (1 << eLen) - 1;
            var eBias = eMax >> 1;
            var rt = mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0;
            var i = isLE ? 0 : nBytes - 1;
            var d = isLE ? 1 : -1;
            var s = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
            value = Math.abs(value);
            if (isNaN(value) || value === Infinity) {
                m = isNaN(value) ? 1 : 0;
                e = eMax;
            } else {
                e = Math.floor(Math.log(value) / Math.LN2);
                if (value * (c = Math.pow(2, -e)) < 1) {
                    e--;
                    c *= 2;
                }
                if (e + eBias >= 1) {
                    value += rt / c;
                } else {
                    value += rt * Math.pow(2, 1 - eBias);
                }
                if (value * c >= 2) {
                    e++;
                    c /= 2;
                }
                if (e + eBias >= eMax) {
                    m = 0;
                    e = eMax;
                } else if (e + eBias >= 1) {
                    m = (value * c - 1) * Math.pow(2, mLen);
                    e = e + eBias;
                } else {
                    m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
                    e = 0;
                }
            }
            for (;mLen >= 8; buffer[offset + i] = m & 255, i += d, m /= 256, mLen -= 8) {}
            e = e << mLen | m;
            eLen += mLen;
            for (;eLen > 0; buffer[offset + i] = e & 255, i += d, e /= 256, eLen -= 8) {}
            buffer[offset + i - d] |= s * 128;
        };
    }
};

var __webpack_module_cache__ = {};

function __webpack_require__(moduleId) {
    var cachedModule = __webpack_module_cache__[moduleId];
    if (cachedModule !== undefined) {
        return cachedModule.exports;
    }
    var module = __webpack_module_cache__[moduleId] = {
        exports: {}
    };
    __webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
    return module.exports;
}

(() => {
    __webpack_require__.d = (exports, definition) => {
        for (var key in definition) {
            if (__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
                Object.defineProperty(exports, key, {
                    enumerable: true,
                    get: definition[key]
                });
            }
        }
    };
})();

(() => {
    __webpack_require__.o = (obj, prop) => Object.prototype.hasOwnProperty.call(obj, prop);
})();

var __webpack_exports__ = {};

(() => {
    var x = y => {
        var x = {};
        __webpack_require__.d(x, y);
        return x;
    };
    var y = x => () => x;
    const server_editor_namespaceObject = x({
        ["ActionTypes"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.ActionTypes,
        ["AudioSettingsProperty"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.AudioSettingsProperty,
        ["Axis"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.Axis,
        ["BlockMaskListType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.BlockMaskListType,
        ["BoolPropertyItemVariant"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.BoolPropertyItemVariant,
        ["BrushDirectionalPlacementMode"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.BrushDirectionalPlacementMode,
        ["ButtonPropertyItemVariant"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.ButtonPropertyItemVariant,
        ["ColorPickerPropertyItemVariant"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.ColorPickerPropertyItemVariant,
        ["ComboBoxPropertyItemDataType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.ComboBoxPropertyItemDataType,
        ["ContinuousActionState"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.ContinuousActionState,
        ["CoreActionBarItemType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.CoreActionBarItemType,
        ["CoreBrushShapeType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.CoreBrushShapeType,
        ["CoreMenuType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.CoreMenuType,
        ["CuboidBrushShape"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.CuboidBrushShape,
        ["CursorControlMode"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.CursorControlMode,
        ["CursorTargetMode"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.CursorTargetMode,
        ["CylinderBrushShape"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.CylinderBrushShape,
        ["DaylightCycle"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.DaylightCycle,
        ["EditorInputContext"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.EditorInputContext,
        ["EditorMode"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.EditorMode,
        ["EllipsoidBrushShape"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.EllipsoidBrushShape,
        ["EntityOperationType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.EntityOperationType,
        ["ExportResult"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.ExportResult,
        ["FlattenMode"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.FlattenMode,
        ["GamePublishSetting"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.GamePublishSetting,
        ["GraphicsSettingsProperty"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.GraphicsSettingsProperty,
        ["ImageResourceType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.ImageResourceType,
        ["InputModifier"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.InputModifier,
        ["KeyboardKey"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.KeyboardKey,
        ["LayoutAlignment"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.LayoutAlignment,
        ["LogChannel"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.LogChannel,
        ["MouseActionType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.MouseActionType,
        ["MouseInputType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.MouseInputType,
        ["NumberPropertyItemVariant"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.NumberPropertyItemVariant,
        ["PaintCompletionState"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.PaintCompletionState,
        ["PaintMode"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.PaintMode,
        ["PlaytestSessionResult"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.PlaytestSessionResult,
        ["RelativeVolumeListBlockVolume"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.RelativeVolumeListBlockVolume,
        ["SelectionVolumeEventType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.SelectionVolumeEventType,
        ["SingleBlockBrushShape"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.SingleBlockBrushShape,
        ["SpeedSettingsProperty"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.SpeedSettingsProperty,
        ["SplineType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.SplineType,
        ["StatusBarAlignment"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.StatusBarAlignment,
        ["ThemeSettingsColorKey"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.ThemeSettingsColorKey,
        ["WidgetGizmoEventType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.WidgetGizmoEventType,
        ["WidgetGroupSelectionMode"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.WidgetGroupSelectionMode,
        ["WidgetMouseButtonActionType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.WidgetMouseButtonActionType,
        ["WorldGeneratorType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.WorldGeneratorType,
        ["deserialize"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.deserialize,
        ["editor"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.editor,
        ["executeLargeOperationFromIterator"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.executeLargeOperationFromIterator,
        ["getDefaultBrushShapes"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.getDefaultBrushShapes,
        ["makeObservable"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.makeObservable,
        ["registerEditorExtension"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.registerEditorExtension,
        ["registerUserDefinedTransactionHandler"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.registerUserDefinedTransactionHandler,
        ["serialize"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.serialize,
        ["stringFromException"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.stringFromException
    });
    var server_x = y => {
        var x = {};
        __webpack_require__.d(x, y);
        return x;
    };
    var server_y = x => () => x;
    const server_namespaceObject = server_x({
        ["BiomeTypes"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BiomeTypes,
        ["BlockBoundingBoxUtils"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BlockBoundingBoxUtils,
        ["BlockComponentTypes"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BlockComponentTypes,
        ["BlockFluidContainerComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BlockFluidContainerComponent,
        ["BlockPermutation"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BlockPermutation,
        ["BlockPistonComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BlockPistonComponent,
        ["BlockSignComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BlockSignComponent,
        ["BlockStates"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BlockStates,
        ["BlockTypes"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BlockTypes,
        ["BlockVolume"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BlockVolume,
        ["BlockVolumeBase"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BlockVolumeBase,
        ["Difficulty"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.Difficulty,
        ["Direction"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.Direction,
        ["EasingType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EasingType,
        ["EntityAddRiderComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityAddRiderComponent,
        ["EntityAgeableComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityAgeableComponent,
        ["EntityBreathableComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityBreathableComponent,
        ["EntityColorComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityColorComponent,
        ["EntityComponentTypes"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityComponentTypes,
        ["EntityEquippableComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityEquippableComponent,
        ["EntityFlyingSpeedComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityFlyingSpeedComponent,
        ["EntityFrictionModifierComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityFrictionModifierComponent,
        ["EntityHealableComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityHealableComponent,
        ["EntityInventoryComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityInventoryComponent,
        ["EntityLeashableComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityLeashableComponent,
        ["EntityMarkVariantComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityMarkVariantComponent,
        ["EntityNpcComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityNpcComponent,
        ["EntityOnFireComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityOnFireComponent,
        ["EntityProjectileComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityProjectileComponent,
        ["EntityPushThroughComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityPushThroughComponent,
        ["EntityRideableComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityRideableComponent,
        ["EntityScaleComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityScaleComponent,
        ["EntitySkinIdComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntitySkinIdComponent,
        ["EntityStrengthComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityStrengthComponent,
        ["EntityTameMountComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityTameMountComponent,
        ["EntityTameableComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityTameableComponent,
        ["EntityTypeFamilyComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityTypeFamilyComponent,
        ["EntityVariantComponent"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.EntityVariantComponent,
        ["GameMode"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.GameMode,
        ["GraphicsMode"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.GraphicsMode,
        ["ItemStack"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.ItemStack,
        ["ItemTypes"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.ItemTypes,
        ["PlayerPermissionLevel"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.PlayerPermissionLevel,
        ["SignSide"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.SignSide,
        ["StructureMirrorAxis"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.StructureMirrorAxis,
        ["StructureRotation"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.StructureRotation,
        ["TicksPerSecond"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.TicksPerSecond,
        ["TimeOfDay"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.TimeOfDay,
        ["WeatherType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.WeatherType,
        ["system"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.system,
        ["world"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.world
    });
    var MinecraftBiomeTypes = (MinecraftBiomeTypes2 => {
        MinecraftBiomeTypes2["BambooJungle"] = "minecraft:bamboo_jungle";
        MinecraftBiomeTypes2["BambooJungleHills"] = "minecraft:bamboo_jungle_hills";
        MinecraftBiomeTypes2["BasaltDeltas"] = "minecraft:basalt_deltas";
        MinecraftBiomeTypes2["Beach"] = "minecraft:beach";
        MinecraftBiomeTypes2["BirchForest"] = "minecraft:birch_forest";
        MinecraftBiomeTypes2["BirchForestHills"] = "minecraft:birch_forest_hills";
        MinecraftBiomeTypes2["BirchForestHillsMutated"] = "minecraft:birch_forest_hills_mutated";
        MinecraftBiomeTypes2["BirchForestMutated"] = "minecraft:birch_forest_mutated";
        MinecraftBiomeTypes2["CherryGrove"] = "minecraft:cherry_grove";
        MinecraftBiomeTypes2["ColdBeach"] = "minecraft:cold_beach";
        MinecraftBiomeTypes2["ColdOcean"] = "minecraft:cold_ocean";
        MinecraftBiomeTypes2["ColdTaiga"] = "minecraft:cold_taiga";
        MinecraftBiomeTypes2["ColdTaigaHills"] = "minecraft:cold_taiga_hills";
        MinecraftBiomeTypes2["ColdTaigaMutated"] = "minecraft:cold_taiga_mutated";
        MinecraftBiomeTypes2["CrimsonForest"] = "minecraft:crimson_forest";
        MinecraftBiomeTypes2["DeepColdOcean"] = "minecraft:deep_cold_ocean";
        MinecraftBiomeTypes2["DeepDark"] = "minecraft:deep_dark";
        MinecraftBiomeTypes2["DeepFrozenOcean"] = "minecraft:deep_frozen_ocean";
        MinecraftBiomeTypes2["DeepLukewarmOcean"] = "minecraft:deep_lukewarm_ocean";
        MinecraftBiomeTypes2["DeepOcean"] = "minecraft:deep_ocean";
        MinecraftBiomeTypes2["DeepWarmOcean"] = "minecraft:deep_warm_ocean";
        MinecraftBiomeTypes2["Desert"] = "minecraft:desert";
        MinecraftBiomeTypes2["DesertHills"] = "minecraft:desert_hills";
        MinecraftBiomeTypes2["DesertMutated"] = "minecraft:desert_mutated";
        MinecraftBiomeTypes2["DripstoneCaves"] = "minecraft:dripstone_caves";
        MinecraftBiomeTypes2["ExtremeHills"] = "minecraft:extreme_hills";
        MinecraftBiomeTypes2["ExtremeHillsEdge"] = "minecraft:extreme_hills_edge";
        MinecraftBiomeTypes2["ExtremeHillsMutated"] = "minecraft:extreme_hills_mutated";
        MinecraftBiomeTypes2["ExtremeHillsPlusTrees"] = "minecraft:extreme_hills_plus_trees";
        MinecraftBiomeTypes2["ExtremeHillsPlusTreesMutated"] = "minecraft:extreme_hills_plus_trees_mutated";
        MinecraftBiomeTypes2["FlowerForest"] = "minecraft:flower_forest";
        MinecraftBiomeTypes2["Forest"] = "minecraft:forest";
        MinecraftBiomeTypes2["ForestHills"] = "minecraft:forest_hills";
        MinecraftBiomeTypes2["FrozenOcean"] = "minecraft:frozen_ocean";
        MinecraftBiomeTypes2["FrozenPeaks"] = "minecraft:frozen_peaks";
        MinecraftBiomeTypes2["FrozenRiver"] = "minecraft:frozen_river";
        MinecraftBiomeTypes2["Grove"] = "minecraft:grove";
        MinecraftBiomeTypes2["Hell"] = "minecraft:hell";
        MinecraftBiomeTypes2["IceMountains"] = "minecraft:ice_mountains";
        MinecraftBiomeTypes2["IcePlains"] = "minecraft:ice_plains";
        MinecraftBiomeTypes2["IcePlainsSpikes"] = "minecraft:ice_plains_spikes";
        MinecraftBiomeTypes2["JaggedPeaks"] = "minecraft:jagged_peaks";
        MinecraftBiomeTypes2["Jungle"] = "minecraft:jungle";
        MinecraftBiomeTypes2["JungleEdge"] = "minecraft:jungle_edge";
        MinecraftBiomeTypes2["JungleEdgeMutated"] = "minecraft:jungle_edge_mutated";
        MinecraftBiomeTypes2["JungleHills"] = "minecraft:jungle_hills";
        MinecraftBiomeTypes2["JungleMutated"] = "minecraft:jungle_mutated";
        MinecraftBiomeTypes2["LegacyFrozenOcean"] = "minecraft:legacy_frozen_ocean";
        MinecraftBiomeTypes2["LukewarmOcean"] = "minecraft:lukewarm_ocean";
        MinecraftBiomeTypes2["LushCaves"] = "minecraft:lush_caves";
        MinecraftBiomeTypes2["MangroveSwamp"] = "minecraft:mangrove_swamp";
        MinecraftBiomeTypes2["Meadow"] = "minecraft:meadow";
        MinecraftBiomeTypes2["MegaTaiga"] = "minecraft:mega_taiga";
        MinecraftBiomeTypes2["MegaTaigaHills"] = "minecraft:mega_taiga_hills";
        MinecraftBiomeTypes2["Mesa"] = "minecraft:mesa";
        MinecraftBiomeTypes2["MesaBryce"] = "minecraft:mesa_bryce";
        MinecraftBiomeTypes2["MesaPlateau"] = "minecraft:mesa_plateau";
        MinecraftBiomeTypes2["MesaPlateauMutated"] = "minecraft:mesa_plateau_mutated";
        MinecraftBiomeTypes2["MesaPlateauStone"] = "minecraft:mesa_plateau_stone";
        MinecraftBiomeTypes2["MesaPlateauStoneMutated"] = "minecraft:mesa_plateau_stone_mutated";
        MinecraftBiomeTypes2["MushroomIsland"] = "minecraft:mushroom_island";
        MinecraftBiomeTypes2["MushroomIslandShore"] = "minecraft:mushroom_island_shore";
        MinecraftBiomeTypes2["Ocean"] = "minecraft:ocean";
        MinecraftBiomeTypes2["PaleGarden"] = "minecraft:pale_garden";
        MinecraftBiomeTypes2["Plains"] = "minecraft:plains";
        MinecraftBiomeTypes2["RedwoodTaigaHillsMutated"] = "minecraft:redwood_taiga_hills_mutated";
        MinecraftBiomeTypes2["RedwoodTaigaMutated"] = "minecraft:redwood_taiga_mutated";
        MinecraftBiomeTypes2["River"] = "minecraft:river";
        MinecraftBiomeTypes2["RoofedForest"] = "minecraft:roofed_forest";
        MinecraftBiomeTypes2["RoofedForestMutated"] = "minecraft:roofed_forest_mutated";
        MinecraftBiomeTypes2["Savanna"] = "minecraft:savanna";
        MinecraftBiomeTypes2["SavannaMutated"] = "minecraft:savanna_mutated";
        MinecraftBiomeTypes2["SavannaPlateau"] = "minecraft:savanna_plateau";
        MinecraftBiomeTypes2["SavannaPlateauMutated"] = "minecraft:savanna_plateau_mutated";
        MinecraftBiomeTypes2["SnowySlopes"] = "minecraft:snowy_slopes";
        MinecraftBiomeTypes2["SoulsandValley"] = "minecraft:soulsand_valley";
        MinecraftBiomeTypes2["StoneBeach"] = "minecraft:stone_beach";
        MinecraftBiomeTypes2["StonyPeaks"] = "minecraft:stony_peaks";
        MinecraftBiomeTypes2["SunflowerPlains"] = "minecraft:sunflower_plains";
        MinecraftBiomeTypes2["Swampland"] = "minecraft:swampland";
        MinecraftBiomeTypes2["SwamplandMutated"] = "minecraft:swampland_mutated";
        MinecraftBiomeTypes2["Taiga"] = "minecraft:taiga";
        MinecraftBiomeTypes2["TaigaHills"] = "minecraft:taiga_hills";
        MinecraftBiomeTypes2["TaigaMutated"] = "minecraft:taiga_mutated";
        MinecraftBiomeTypes2["TheEnd"] = "minecraft:the_end";
        MinecraftBiomeTypes2["WarmOcean"] = "minecraft:warm_ocean";
        MinecraftBiomeTypes2["WarpedForest"] = "minecraft:warped_forest";
        return MinecraftBiomeTypes2;
    })(MinecraftBiomeTypes || {});
    var lib_vanilla_MinecraftBlockTypes = (MinecraftBlockTypes2 => {
        MinecraftBlockTypes2["AcaciaButton"] = "minecraft:acacia_button";
        MinecraftBlockTypes2["AcaciaDoor"] = "minecraft:acacia_door";
        MinecraftBlockTypes2["AcaciaDoubleSlab"] = "minecraft:acacia_double_slab";
        MinecraftBlockTypes2["AcaciaFence"] = "minecraft:acacia_fence";
        MinecraftBlockTypes2["AcaciaFenceGate"] = "minecraft:acacia_fence_gate";
        MinecraftBlockTypes2["AcaciaHangingSign"] = "minecraft:acacia_hanging_sign";
        MinecraftBlockTypes2["AcaciaLeaves"] = "minecraft:acacia_leaves";
        MinecraftBlockTypes2["AcaciaLog"] = "minecraft:acacia_log";
        MinecraftBlockTypes2["AcaciaPlanks"] = "minecraft:acacia_planks";
        MinecraftBlockTypes2["AcaciaPressurePlate"] = "minecraft:acacia_pressure_plate";
        MinecraftBlockTypes2["AcaciaSapling"] = "minecraft:acacia_sapling";
        MinecraftBlockTypes2["AcaciaShelf"] = "minecraft:acacia_shelf";
        MinecraftBlockTypes2["AcaciaSlab"] = "minecraft:acacia_slab";
        MinecraftBlockTypes2["AcaciaStairs"] = "minecraft:acacia_stairs";
        MinecraftBlockTypes2["AcaciaStandingSign"] = "minecraft:acacia_standing_sign";
        MinecraftBlockTypes2["AcaciaTrapdoor"] = "minecraft:acacia_trapdoor";
        MinecraftBlockTypes2["AcaciaWallSign"] = "minecraft:acacia_wall_sign";
        MinecraftBlockTypes2["AcaciaWood"] = "minecraft:acacia_wood";
        MinecraftBlockTypes2["ActivatorRail"] = "minecraft:activator_rail";
        MinecraftBlockTypes2["Air"] = "minecraft:air";
        MinecraftBlockTypes2["Allium"] = "minecraft:allium";
        MinecraftBlockTypes2["Allow"] = "minecraft:allow";
        MinecraftBlockTypes2["AmethystBlock"] = "minecraft:amethyst_block";
        MinecraftBlockTypes2["AmethystCluster"] = "minecraft:amethyst_cluster";
        MinecraftBlockTypes2["AncientDebris"] = "minecraft:ancient_debris";
        MinecraftBlockTypes2["Andesite"] = "minecraft:andesite";
        MinecraftBlockTypes2["AndesiteDoubleSlab"] = "minecraft:andesite_double_slab";
        MinecraftBlockTypes2["AndesiteSlab"] = "minecraft:andesite_slab";
        MinecraftBlockTypes2["AndesiteStairs"] = "minecraft:andesite_stairs";
        MinecraftBlockTypes2["AndesiteWall"] = "minecraft:andesite_wall";
        MinecraftBlockTypes2["Anvil"] = "minecraft:anvil";
        MinecraftBlockTypes2["Azalea"] = "minecraft:azalea";
        MinecraftBlockTypes2["AzaleaLeaves"] = "minecraft:azalea_leaves";
        MinecraftBlockTypes2["AzaleaLeavesFlowered"] = "minecraft:azalea_leaves_flowered";
        MinecraftBlockTypes2["AzureBluet"] = "minecraft:azure_bluet";
        MinecraftBlockTypes2["Bamboo"] = "minecraft:bamboo";
        MinecraftBlockTypes2["BambooBlock"] = "minecraft:bamboo_block";
        MinecraftBlockTypes2["BambooButton"] = "minecraft:bamboo_button";
        MinecraftBlockTypes2["BambooDoor"] = "minecraft:bamboo_door";
        MinecraftBlockTypes2["BambooDoubleSlab"] = "minecraft:bamboo_double_slab";
        MinecraftBlockTypes2["BambooFence"] = "minecraft:bamboo_fence";
        MinecraftBlockTypes2["BambooFenceGate"] = "minecraft:bamboo_fence_gate";
        MinecraftBlockTypes2["BambooHangingSign"] = "minecraft:bamboo_hanging_sign";
        MinecraftBlockTypes2["BambooMosaic"] = "minecraft:bamboo_mosaic";
        MinecraftBlockTypes2["BambooMosaicDoubleSlab"] = "minecraft:bamboo_mosaic_double_slab";
        MinecraftBlockTypes2["BambooMosaicSlab"] = "minecraft:bamboo_mosaic_slab";
        MinecraftBlockTypes2["BambooMosaicStairs"] = "minecraft:bamboo_mosaic_stairs";
        MinecraftBlockTypes2["BambooPlanks"] = "minecraft:bamboo_planks";
        MinecraftBlockTypes2["BambooPressurePlate"] = "minecraft:bamboo_pressure_plate";
        MinecraftBlockTypes2["BambooSapling"] = "minecraft:bamboo_sapling";
        MinecraftBlockTypes2["BambooShelf"] = "minecraft:bamboo_shelf";
        MinecraftBlockTypes2["BambooSlab"] = "minecraft:bamboo_slab";
        MinecraftBlockTypes2["BambooStairs"] = "minecraft:bamboo_stairs";
        MinecraftBlockTypes2["BambooStandingSign"] = "minecraft:bamboo_standing_sign";
        MinecraftBlockTypes2["BambooTrapdoor"] = "minecraft:bamboo_trapdoor";
        MinecraftBlockTypes2["BambooWallSign"] = "minecraft:bamboo_wall_sign";
        MinecraftBlockTypes2["Barrel"] = "minecraft:barrel";
        MinecraftBlockTypes2["Barrier"] = "minecraft:barrier";
        MinecraftBlockTypes2["Basalt"] = "minecraft:basalt";
        MinecraftBlockTypes2["Beacon"] = "minecraft:beacon";
        MinecraftBlockTypes2["Bed"] = "minecraft:bed";
        MinecraftBlockTypes2["Bedrock"] = "minecraft:bedrock";
        MinecraftBlockTypes2["BeeNest"] = "minecraft:bee_nest";
        MinecraftBlockTypes2["Beehive"] = "minecraft:beehive";
        MinecraftBlockTypes2["Beetroot"] = "minecraft:beetroot";
        MinecraftBlockTypes2["Bell"] = "minecraft:bell";
        MinecraftBlockTypes2["BigDripleaf"] = "minecraft:big_dripleaf";
        MinecraftBlockTypes2["BirchButton"] = "minecraft:birch_button";
        MinecraftBlockTypes2["BirchDoor"] = "minecraft:birch_door";
        MinecraftBlockTypes2["BirchDoubleSlab"] = "minecraft:birch_double_slab";
        MinecraftBlockTypes2["BirchFence"] = "minecraft:birch_fence";
        MinecraftBlockTypes2["BirchFenceGate"] = "minecraft:birch_fence_gate";
        MinecraftBlockTypes2["BirchHangingSign"] = "minecraft:birch_hanging_sign";
        MinecraftBlockTypes2["BirchLeaves"] = "minecraft:birch_leaves";
        MinecraftBlockTypes2["BirchLog"] = "minecraft:birch_log";
        MinecraftBlockTypes2["BirchPlanks"] = "minecraft:birch_planks";
        MinecraftBlockTypes2["BirchPressurePlate"] = "minecraft:birch_pressure_plate";
        MinecraftBlockTypes2["BirchSapling"] = "minecraft:birch_sapling";
        MinecraftBlockTypes2["BirchShelf"] = "minecraft:birch_shelf";
        MinecraftBlockTypes2["BirchSlab"] = "minecraft:birch_slab";
        MinecraftBlockTypes2["BirchStairs"] = "minecraft:birch_stairs";
        MinecraftBlockTypes2["BirchStandingSign"] = "minecraft:birch_standing_sign";
        MinecraftBlockTypes2["BirchTrapdoor"] = "minecraft:birch_trapdoor";
        MinecraftBlockTypes2["BirchWallSign"] = "minecraft:birch_wall_sign";
        MinecraftBlockTypes2["BirchWood"] = "minecraft:birch_wood";
        MinecraftBlockTypes2["BlackCandle"] = "minecraft:black_candle";
        MinecraftBlockTypes2["BlackCandleCake"] = "minecraft:black_candle_cake";
        MinecraftBlockTypes2["BlackCarpet"] = "minecraft:black_carpet";
        MinecraftBlockTypes2["BlackConcrete"] = "minecraft:black_concrete";
        MinecraftBlockTypes2["BlackConcretePowder"] = "minecraft:black_concrete_powder";
        MinecraftBlockTypes2["BlackGlazedTerracotta"] = "minecraft:black_glazed_terracotta";
        MinecraftBlockTypes2["BlackShulkerBox"] = "minecraft:black_shulker_box";
        MinecraftBlockTypes2["BlackStainedGlass"] = "minecraft:black_stained_glass";
        MinecraftBlockTypes2["BlackStainedGlassPane"] = "minecraft:black_stained_glass_pane";
        MinecraftBlockTypes2["BlackTerracotta"] = "minecraft:black_terracotta";
        MinecraftBlockTypes2["BlackWool"] = "minecraft:black_wool";
        MinecraftBlockTypes2["Blackstone"] = "minecraft:blackstone";
        MinecraftBlockTypes2["BlackstoneDoubleSlab"] = "minecraft:blackstone_double_slab";
        MinecraftBlockTypes2["BlackstoneSlab"] = "minecraft:blackstone_slab";
        MinecraftBlockTypes2["BlackstoneStairs"] = "minecraft:blackstone_stairs";
        MinecraftBlockTypes2["BlackstoneWall"] = "minecraft:blackstone_wall";
        MinecraftBlockTypes2["BlastFurnace"] = "minecraft:blast_furnace";
        MinecraftBlockTypes2["BlueCandle"] = "minecraft:blue_candle";
        MinecraftBlockTypes2["BlueCandleCake"] = "minecraft:blue_candle_cake";
        MinecraftBlockTypes2["BlueCarpet"] = "minecraft:blue_carpet";
        MinecraftBlockTypes2["BlueConcrete"] = "minecraft:blue_concrete";
        MinecraftBlockTypes2["BlueConcretePowder"] = "minecraft:blue_concrete_powder";
        MinecraftBlockTypes2["BlueGlazedTerracotta"] = "minecraft:blue_glazed_terracotta";
        MinecraftBlockTypes2["BlueIce"] = "minecraft:blue_ice";
        MinecraftBlockTypes2["BlueOrchid"] = "minecraft:blue_orchid";
        MinecraftBlockTypes2["BlueShulkerBox"] = "minecraft:blue_shulker_box";
        MinecraftBlockTypes2["BlueStainedGlass"] = "minecraft:blue_stained_glass";
        MinecraftBlockTypes2["BlueStainedGlassPane"] = "minecraft:blue_stained_glass_pane";
        MinecraftBlockTypes2["BlueTerracotta"] = "minecraft:blue_terracotta";
        MinecraftBlockTypes2["BlueWool"] = "minecraft:blue_wool";
        MinecraftBlockTypes2["BoneBlock"] = "minecraft:bone_block";
        MinecraftBlockTypes2["Bookshelf"] = "minecraft:bookshelf";
        MinecraftBlockTypes2["BorderBlock"] = "minecraft:border_block";
        MinecraftBlockTypes2["BrainCoral"] = "minecraft:brain_coral";
        MinecraftBlockTypes2["BrainCoralBlock"] = "minecraft:brain_coral_block";
        MinecraftBlockTypes2["BrainCoralFan"] = "minecraft:brain_coral_fan";
        MinecraftBlockTypes2["BrainCoralWallFan"] = "minecraft:brain_coral_wall_fan";
        MinecraftBlockTypes2["BrewingStand"] = "minecraft:brewing_stand";
        MinecraftBlockTypes2["BrickBlock"] = "minecraft:brick_block";
        MinecraftBlockTypes2["BrickDoubleSlab"] = "minecraft:brick_double_slab";
        MinecraftBlockTypes2["BrickSlab"] = "minecraft:brick_slab";
        MinecraftBlockTypes2["BrickStairs"] = "minecraft:brick_stairs";
        MinecraftBlockTypes2["BrickWall"] = "minecraft:brick_wall";
        MinecraftBlockTypes2["BrownCandle"] = "minecraft:brown_candle";
        MinecraftBlockTypes2["BrownCandleCake"] = "minecraft:brown_candle_cake";
        MinecraftBlockTypes2["BrownCarpet"] = "minecraft:brown_carpet";
        MinecraftBlockTypes2["BrownConcrete"] = "minecraft:brown_concrete";
        MinecraftBlockTypes2["BrownConcretePowder"] = "minecraft:brown_concrete_powder";
        MinecraftBlockTypes2["BrownGlazedTerracotta"] = "minecraft:brown_glazed_terracotta";
        MinecraftBlockTypes2["BrownMushroom"] = "minecraft:brown_mushroom";
        MinecraftBlockTypes2["BrownMushroomBlock"] = "minecraft:brown_mushroom_block";
        MinecraftBlockTypes2["BrownShulkerBox"] = "minecraft:brown_shulker_box";
        MinecraftBlockTypes2["BrownStainedGlass"] = "minecraft:brown_stained_glass";
        MinecraftBlockTypes2["BrownStainedGlassPane"] = "minecraft:brown_stained_glass_pane";
        MinecraftBlockTypes2["BrownTerracotta"] = "minecraft:brown_terracotta";
        MinecraftBlockTypes2["BrownWool"] = "minecraft:brown_wool";
        MinecraftBlockTypes2["BubbleColumn"] = "minecraft:bubble_column";
        MinecraftBlockTypes2["BubbleCoral"] = "minecraft:bubble_coral";
        MinecraftBlockTypes2["BubbleCoralBlock"] = "minecraft:bubble_coral_block";
        MinecraftBlockTypes2["BubbleCoralFan"] = "minecraft:bubble_coral_fan";
        MinecraftBlockTypes2["BubbleCoralWallFan"] = "minecraft:bubble_coral_wall_fan";
        MinecraftBlockTypes2["BuddingAmethyst"] = "minecraft:budding_amethyst";
        MinecraftBlockTypes2["Bush"] = "minecraft:bush";
        MinecraftBlockTypes2["Cactus"] = "minecraft:cactus";
        MinecraftBlockTypes2["CactusFlower"] = "minecraft:cactus_flower";
        MinecraftBlockTypes2["Cake"] = "minecraft:cake";
        MinecraftBlockTypes2["Calcite"] = "minecraft:calcite";
        MinecraftBlockTypes2["CalibratedSculkSensor"] = "minecraft:calibrated_sculk_sensor";
        MinecraftBlockTypes2["Camera"] = "minecraft:camera";
        MinecraftBlockTypes2["Campfire"] = "minecraft:campfire";
        MinecraftBlockTypes2["Candle"] = "minecraft:candle";
        MinecraftBlockTypes2["CandleCake"] = "minecraft:candle_cake";
        MinecraftBlockTypes2["Carrots"] = "minecraft:carrots";
        MinecraftBlockTypes2["CartographyTable"] = "minecraft:cartography_table";
        MinecraftBlockTypes2["CarvedPumpkin"] = "minecraft:carved_pumpkin";
        MinecraftBlockTypes2["Cauldron"] = "minecraft:cauldron";
        MinecraftBlockTypes2["CaveVines"] = "minecraft:cave_vines";
        MinecraftBlockTypes2["CaveVinesBodyWithBerries"] = "minecraft:cave_vines_body_with_berries";
        MinecraftBlockTypes2["CaveVinesHeadWithBerries"] = "minecraft:cave_vines_head_with_berries";
        MinecraftBlockTypes2["ChainCommandBlock"] = "minecraft:chain_command_block";
        MinecraftBlockTypes2["ChemicalHeat"] = "minecraft:chemical_heat";
        MinecraftBlockTypes2["CherryButton"] = "minecraft:cherry_button";
        MinecraftBlockTypes2["CherryDoor"] = "minecraft:cherry_door";
        MinecraftBlockTypes2["CherryDoubleSlab"] = "minecraft:cherry_double_slab";
        MinecraftBlockTypes2["CherryFence"] = "minecraft:cherry_fence";
        MinecraftBlockTypes2["CherryFenceGate"] = "minecraft:cherry_fence_gate";
        MinecraftBlockTypes2["CherryHangingSign"] = "minecraft:cherry_hanging_sign";
        MinecraftBlockTypes2["CherryLeaves"] = "minecraft:cherry_leaves";
        MinecraftBlockTypes2["CherryLog"] = "minecraft:cherry_log";
        MinecraftBlockTypes2["CherryPlanks"] = "minecraft:cherry_planks";
        MinecraftBlockTypes2["CherryPressurePlate"] = "minecraft:cherry_pressure_plate";
        MinecraftBlockTypes2["CherrySapling"] = "minecraft:cherry_sapling";
        MinecraftBlockTypes2["CherryShelf"] = "minecraft:cherry_shelf";
        MinecraftBlockTypes2["CherrySlab"] = "minecraft:cherry_slab";
        MinecraftBlockTypes2["CherryStairs"] = "minecraft:cherry_stairs";
        MinecraftBlockTypes2["CherryStandingSign"] = "minecraft:cherry_standing_sign";
        MinecraftBlockTypes2["CherryTrapdoor"] = "minecraft:cherry_trapdoor";
        MinecraftBlockTypes2["CherryWallSign"] = "minecraft:cherry_wall_sign";
        MinecraftBlockTypes2["CherryWood"] = "minecraft:cherry_wood";
        MinecraftBlockTypes2["Chest"] = "minecraft:chest";
        MinecraftBlockTypes2["ChippedAnvil"] = "minecraft:chipped_anvil";
        MinecraftBlockTypes2["ChiseledBookshelf"] = "minecraft:chiseled_bookshelf";
        MinecraftBlockTypes2["ChiseledCopper"] = "minecraft:chiseled_copper";
        MinecraftBlockTypes2["ChiseledDeepslate"] = "minecraft:chiseled_deepslate";
        MinecraftBlockTypes2["ChiseledNetherBricks"] = "minecraft:chiseled_nether_bricks";
        MinecraftBlockTypes2["ChiseledPolishedBlackstone"] = "minecraft:chiseled_polished_blackstone";
        MinecraftBlockTypes2["ChiseledQuartzBlock"] = "minecraft:chiseled_quartz_block";
        MinecraftBlockTypes2["ChiseledRedSandstone"] = "minecraft:chiseled_red_sandstone";
        MinecraftBlockTypes2["ChiseledResinBricks"] = "minecraft:chiseled_resin_bricks";
        MinecraftBlockTypes2["ChiseledSandstone"] = "minecraft:chiseled_sandstone";
        MinecraftBlockTypes2["ChiseledStoneBricks"] = "minecraft:chiseled_stone_bricks";
        MinecraftBlockTypes2["ChiseledTuff"] = "minecraft:chiseled_tuff";
        MinecraftBlockTypes2["ChiseledTuffBricks"] = "minecraft:chiseled_tuff_bricks";
        MinecraftBlockTypes2["ChorusFlower"] = "minecraft:chorus_flower";
        MinecraftBlockTypes2["ChorusPlant"] = "minecraft:chorus_plant";
        MinecraftBlockTypes2["Clay"] = "minecraft:clay";
        MinecraftBlockTypes2["ClosedEyeblossom"] = "minecraft:closed_eyeblossom";
        MinecraftBlockTypes2["CoalBlock"] = "minecraft:coal_block";
        MinecraftBlockTypes2["CoalOre"] = "minecraft:coal_ore";
        MinecraftBlockTypes2["CoarseDirt"] = "minecraft:coarse_dirt";
        MinecraftBlockTypes2["CobbledDeepslate"] = "minecraft:cobbled_deepslate";
        MinecraftBlockTypes2["CobbledDeepslateDoubleSlab"] = "minecraft:cobbled_deepslate_double_slab";
        MinecraftBlockTypes2["CobbledDeepslateSlab"] = "minecraft:cobbled_deepslate_slab";
        MinecraftBlockTypes2["CobbledDeepslateStairs"] = "minecraft:cobbled_deepslate_stairs";
        MinecraftBlockTypes2["CobbledDeepslateWall"] = "minecraft:cobbled_deepslate_wall";
        MinecraftBlockTypes2["Cobblestone"] = "minecraft:cobblestone";
        MinecraftBlockTypes2["CobblestoneDoubleSlab"] = "minecraft:cobblestone_double_slab";
        MinecraftBlockTypes2["CobblestoneSlab"] = "minecraft:cobblestone_slab";
        MinecraftBlockTypes2["CobblestoneWall"] = "minecraft:cobblestone_wall";
        MinecraftBlockTypes2["Cocoa"] = "minecraft:cocoa";
        MinecraftBlockTypes2["ColoredTorchBlue"] = "minecraft:colored_torch_blue";
        MinecraftBlockTypes2["ColoredTorchGreen"] = "minecraft:colored_torch_green";
        MinecraftBlockTypes2["ColoredTorchPurple"] = "minecraft:colored_torch_purple";
        MinecraftBlockTypes2["ColoredTorchRed"] = "minecraft:colored_torch_red";
        MinecraftBlockTypes2["CommandBlock"] = "minecraft:command_block";
        MinecraftBlockTypes2["Composter"] = "minecraft:composter";
        MinecraftBlockTypes2["CompoundCreator"] = "minecraft:compound_creator";
        MinecraftBlockTypes2["Conduit"] = "minecraft:conduit";
        MinecraftBlockTypes2["CopperBars"] = "minecraft:copper_bars";
        MinecraftBlockTypes2["CopperBlock"] = "minecraft:copper_block";
        MinecraftBlockTypes2["CopperBulb"] = "minecraft:copper_bulb";
        MinecraftBlockTypes2["CopperChain"] = "minecraft:copper_chain";
        MinecraftBlockTypes2["CopperChest"] = "minecraft:copper_chest";
        MinecraftBlockTypes2["CopperDoor"] = "minecraft:copper_door";
        MinecraftBlockTypes2["CopperGolemStatue"] = "minecraft:copper_golem_statue";
        MinecraftBlockTypes2["CopperGrate"] = "minecraft:copper_grate";
        MinecraftBlockTypes2["CopperLantern"] = "minecraft:copper_lantern";
        MinecraftBlockTypes2["CopperOre"] = "minecraft:copper_ore";
        MinecraftBlockTypes2["CopperTorch"] = "minecraft:copper_torch";
        MinecraftBlockTypes2["CopperTrapdoor"] = "minecraft:copper_trapdoor";
        MinecraftBlockTypes2["Cornflower"] = "minecraft:cornflower";
        MinecraftBlockTypes2["CrackedDeepslateBricks"] = "minecraft:cracked_deepslate_bricks";
        MinecraftBlockTypes2["CrackedDeepslateTiles"] = "minecraft:cracked_deepslate_tiles";
        MinecraftBlockTypes2["CrackedNetherBricks"] = "minecraft:cracked_nether_bricks";
        MinecraftBlockTypes2["CrackedPolishedBlackstoneBricks"] = "minecraft:cracked_polished_blackstone_bricks";
        MinecraftBlockTypes2["CrackedStoneBricks"] = "minecraft:cracked_stone_bricks";
        MinecraftBlockTypes2["Crafter"] = "minecraft:crafter";
        MinecraftBlockTypes2["CraftingTable"] = "minecraft:crafting_table";
        MinecraftBlockTypes2["CreakingHeart"] = "minecraft:creaking_heart";
        MinecraftBlockTypes2["CreeperHead"] = "minecraft:creeper_head";
        MinecraftBlockTypes2["CrimsonButton"] = "minecraft:crimson_button";
        MinecraftBlockTypes2["CrimsonDoor"] = "minecraft:crimson_door";
        MinecraftBlockTypes2["CrimsonDoubleSlab"] = "minecraft:crimson_double_slab";
        MinecraftBlockTypes2["CrimsonFence"] = "minecraft:crimson_fence";
        MinecraftBlockTypes2["CrimsonFenceGate"] = "minecraft:crimson_fence_gate";
        MinecraftBlockTypes2["CrimsonFungus"] = "minecraft:crimson_fungus";
        MinecraftBlockTypes2["CrimsonHangingSign"] = "minecraft:crimson_hanging_sign";
        MinecraftBlockTypes2["CrimsonHyphae"] = "minecraft:crimson_hyphae";
        MinecraftBlockTypes2["CrimsonNylium"] = "minecraft:crimson_nylium";
        MinecraftBlockTypes2["CrimsonPlanks"] = "minecraft:crimson_planks";
        MinecraftBlockTypes2["CrimsonPressurePlate"] = "minecraft:crimson_pressure_plate";
        MinecraftBlockTypes2["CrimsonRoots"] = "minecraft:crimson_roots";
        MinecraftBlockTypes2["CrimsonShelf"] = "minecraft:crimson_shelf";
        MinecraftBlockTypes2["CrimsonSlab"] = "minecraft:crimson_slab";
        MinecraftBlockTypes2["CrimsonStairs"] = "minecraft:crimson_stairs";
        MinecraftBlockTypes2["CrimsonStandingSign"] = "minecraft:crimson_standing_sign";
        MinecraftBlockTypes2["CrimsonStem"] = "minecraft:crimson_stem";
        MinecraftBlockTypes2["CrimsonTrapdoor"] = "minecraft:crimson_trapdoor";
        MinecraftBlockTypes2["CrimsonWallSign"] = "minecraft:crimson_wall_sign";
        MinecraftBlockTypes2["CryingObsidian"] = "minecraft:crying_obsidian";
        MinecraftBlockTypes2["CutCopper"] = "minecraft:cut_copper";
        MinecraftBlockTypes2["CutCopperSlab"] = "minecraft:cut_copper_slab";
        MinecraftBlockTypes2["CutCopperStairs"] = "minecraft:cut_copper_stairs";
        MinecraftBlockTypes2["CutRedSandstone"] = "minecraft:cut_red_sandstone";
        MinecraftBlockTypes2["CutRedSandstoneDoubleSlab"] = "minecraft:cut_red_sandstone_double_slab";
        MinecraftBlockTypes2["CutRedSandstoneSlab"] = "minecraft:cut_red_sandstone_slab";
        MinecraftBlockTypes2["CutSandstone"] = "minecraft:cut_sandstone";
        MinecraftBlockTypes2["CutSandstoneDoubleSlab"] = "minecraft:cut_sandstone_double_slab";
        MinecraftBlockTypes2["CutSandstoneSlab"] = "minecraft:cut_sandstone_slab";
        MinecraftBlockTypes2["CyanCandle"] = "minecraft:cyan_candle";
        MinecraftBlockTypes2["CyanCandleCake"] = "minecraft:cyan_candle_cake";
        MinecraftBlockTypes2["CyanCarpet"] = "minecraft:cyan_carpet";
        MinecraftBlockTypes2["CyanConcrete"] = "minecraft:cyan_concrete";
        MinecraftBlockTypes2["CyanConcretePowder"] = "minecraft:cyan_concrete_powder";
        MinecraftBlockTypes2["CyanGlazedTerracotta"] = "minecraft:cyan_glazed_terracotta";
        MinecraftBlockTypes2["CyanShulkerBox"] = "minecraft:cyan_shulker_box";
        MinecraftBlockTypes2["CyanStainedGlass"] = "minecraft:cyan_stained_glass";
        MinecraftBlockTypes2["CyanStainedGlassPane"] = "minecraft:cyan_stained_glass_pane";
        MinecraftBlockTypes2["CyanTerracotta"] = "minecraft:cyan_terracotta";
        MinecraftBlockTypes2["CyanWool"] = "minecraft:cyan_wool";
        MinecraftBlockTypes2["DamagedAnvil"] = "minecraft:damaged_anvil";
        MinecraftBlockTypes2["Dandelion"] = "minecraft:dandelion";
        MinecraftBlockTypes2["DarkOakButton"] = "minecraft:dark_oak_button";
        MinecraftBlockTypes2["DarkOakDoor"] = "minecraft:dark_oak_door";
        MinecraftBlockTypes2["DarkOakDoubleSlab"] = "minecraft:dark_oak_double_slab";
        MinecraftBlockTypes2["DarkOakFence"] = "minecraft:dark_oak_fence";
        MinecraftBlockTypes2["DarkOakFenceGate"] = "minecraft:dark_oak_fence_gate";
        MinecraftBlockTypes2["DarkOakHangingSign"] = "minecraft:dark_oak_hanging_sign";
        MinecraftBlockTypes2["DarkOakLeaves"] = "minecraft:dark_oak_leaves";
        MinecraftBlockTypes2["DarkOakLog"] = "minecraft:dark_oak_log";
        MinecraftBlockTypes2["DarkOakPlanks"] = "minecraft:dark_oak_planks";
        MinecraftBlockTypes2["DarkOakPressurePlate"] = "minecraft:dark_oak_pressure_plate";
        MinecraftBlockTypes2["DarkOakSapling"] = "minecraft:dark_oak_sapling";
        MinecraftBlockTypes2["DarkOakShelf"] = "minecraft:dark_oak_shelf";
        MinecraftBlockTypes2["DarkOakSlab"] = "minecraft:dark_oak_slab";
        MinecraftBlockTypes2["DarkOakStairs"] = "minecraft:dark_oak_stairs";
        MinecraftBlockTypes2["DarkOakTrapdoor"] = "minecraft:dark_oak_trapdoor";
        MinecraftBlockTypes2["DarkOakWood"] = "minecraft:dark_oak_wood";
        MinecraftBlockTypes2["DarkPrismarine"] = "minecraft:dark_prismarine";
        MinecraftBlockTypes2["DarkPrismarineDoubleSlab"] = "minecraft:dark_prismarine_double_slab";
        MinecraftBlockTypes2["DarkPrismarineSlab"] = "minecraft:dark_prismarine_slab";
        MinecraftBlockTypes2["DarkPrismarineStairs"] = "minecraft:dark_prismarine_stairs";
        MinecraftBlockTypes2["DarkoakStandingSign"] = "minecraft:darkoak_standing_sign";
        MinecraftBlockTypes2["DarkoakWallSign"] = "minecraft:darkoak_wall_sign";
        MinecraftBlockTypes2["DaylightDetector"] = "minecraft:daylight_detector";
        MinecraftBlockTypes2["DaylightDetectorInverted"] = "minecraft:daylight_detector_inverted";
        MinecraftBlockTypes2["DeadBrainCoral"] = "minecraft:dead_brain_coral";
        MinecraftBlockTypes2["DeadBrainCoralBlock"] = "minecraft:dead_brain_coral_block";
        MinecraftBlockTypes2["DeadBrainCoralFan"] = "minecraft:dead_brain_coral_fan";
        MinecraftBlockTypes2["DeadBrainCoralWallFan"] = "minecraft:dead_brain_coral_wall_fan";
        MinecraftBlockTypes2["DeadBubbleCoral"] = "minecraft:dead_bubble_coral";
        MinecraftBlockTypes2["DeadBubbleCoralBlock"] = "minecraft:dead_bubble_coral_block";
        MinecraftBlockTypes2["DeadBubbleCoralFan"] = "minecraft:dead_bubble_coral_fan";
        MinecraftBlockTypes2["DeadBubbleCoralWallFan"] = "minecraft:dead_bubble_coral_wall_fan";
        MinecraftBlockTypes2["DeadFireCoral"] = "minecraft:dead_fire_coral";
        MinecraftBlockTypes2["DeadFireCoralBlock"] = "minecraft:dead_fire_coral_block";
        MinecraftBlockTypes2["DeadFireCoralFan"] = "minecraft:dead_fire_coral_fan";
        MinecraftBlockTypes2["DeadFireCoralWallFan"] = "minecraft:dead_fire_coral_wall_fan";
        MinecraftBlockTypes2["DeadHornCoral"] = "minecraft:dead_horn_coral";
        MinecraftBlockTypes2["DeadHornCoralBlock"] = "minecraft:dead_horn_coral_block";
        MinecraftBlockTypes2["DeadHornCoralFan"] = "minecraft:dead_horn_coral_fan";
        MinecraftBlockTypes2["DeadHornCoralWallFan"] = "minecraft:dead_horn_coral_wall_fan";
        MinecraftBlockTypes2["DeadTubeCoral"] = "minecraft:dead_tube_coral";
        MinecraftBlockTypes2["DeadTubeCoralBlock"] = "minecraft:dead_tube_coral_block";
        MinecraftBlockTypes2["DeadTubeCoralFan"] = "minecraft:dead_tube_coral_fan";
        MinecraftBlockTypes2["DeadTubeCoralWallFan"] = "minecraft:dead_tube_coral_wall_fan";
        MinecraftBlockTypes2["Deadbush"] = "minecraft:deadbush";
        MinecraftBlockTypes2["DecoratedPot"] = "minecraft:decorated_pot";
        MinecraftBlockTypes2["Deepslate"] = "minecraft:deepslate";
        MinecraftBlockTypes2["DeepslateBrickDoubleSlab"] = "minecraft:deepslate_brick_double_slab";
        MinecraftBlockTypes2["DeepslateBrickSlab"] = "minecraft:deepslate_brick_slab";
        MinecraftBlockTypes2["DeepslateBrickStairs"] = "minecraft:deepslate_brick_stairs";
        MinecraftBlockTypes2["DeepslateBrickWall"] = "minecraft:deepslate_brick_wall";
        MinecraftBlockTypes2["DeepslateBricks"] = "minecraft:deepslate_bricks";
        MinecraftBlockTypes2["DeepslateCoalOre"] = "minecraft:deepslate_coal_ore";
        MinecraftBlockTypes2["DeepslateCopperOre"] = "minecraft:deepslate_copper_ore";
        MinecraftBlockTypes2["DeepslateDiamondOre"] = "minecraft:deepslate_diamond_ore";
        MinecraftBlockTypes2["DeepslateEmeraldOre"] = "minecraft:deepslate_emerald_ore";
        MinecraftBlockTypes2["DeepslateGoldOre"] = "minecraft:deepslate_gold_ore";
        MinecraftBlockTypes2["DeepslateIronOre"] = "minecraft:deepslate_iron_ore";
        MinecraftBlockTypes2["DeepslateLapisOre"] = "minecraft:deepslate_lapis_ore";
        MinecraftBlockTypes2["DeepslateRedstoneOre"] = "minecraft:deepslate_redstone_ore";
        MinecraftBlockTypes2["DeepslateTileDoubleSlab"] = "minecraft:deepslate_tile_double_slab";
        MinecraftBlockTypes2["DeepslateTileSlab"] = "minecraft:deepslate_tile_slab";
        MinecraftBlockTypes2["DeepslateTileStairs"] = "minecraft:deepslate_tile_stairs";
        MinecraftBlockTypes2["DeepslateTileWall"] = "minecraft:deepslate_tile_wall";
        MinecraftBlockTypes2["DeepslateTiles"] = "minecraft:deepslate_tiles";
        MinecraftBlockTypes2["Deny"] = "minecraft:deny";
        MinecraftBlockTypes2["DetectorRail"] = "minecraft:detector_rail";
        MinecraftBlockTypes2["DiamondBlock"] = "minecraft:diamond_block";
        MinecraftBlockTypes2["DiamondOre"] = "minecraft:diamond_ore";
        MinecraftBlockTypes2["Diorite"] = "minecraft:diorite";
        MinecraftBlockTypes2["DioriteDoubleSlab"] = "minecraft:diorite_double_slab";
        MinecraftBlockTypes2["DioriteSlab"] = "minecraft:diorite_slab";
        MinecraftBlockTypes2["DioriteStairs"] = "minecraft:diorite_stairs";
        MinecraftBlockTypes2["DioriteWall"] = "minecraft:diorite_wall";
        MinecraftBlockTypes2["Dirt"] = "minecraft:dirt";
        MinecraftBlockTypes2["DirtWithRoots"] = "minecraft:dirt_with_roots";
        MinecraftBlockTypes2["Dispenser"] = "minecraft:dispenser";
        MinecraftBlockTypes2["DoubleCutCopperSlab"] = "minecraft:double_cut_copper_slab";
        MinecraftBlockTypes2["DragonEgg"] = "minecraft:dragon_egg";
        MinecraftBlockTypes2["DragonHead"] = "minecraft:dragon_head";
        MinecraftBlockTypes2["DriedGhast"] = "minecraft:dried_ghast";
        MinecraftBlockTypes2["DriedKelpBlock"] = "minecraft:dried_kelp_block";
        MinecraftBlockTypes2["DripstoneBlock"] = "minecraft:dripstone_block";
        MinecraftBlockTypes2["Dropper"] = "minecraft:dropper";
        MinecraftBlockTypes2["Element0"] = "minecraft:element_0";
        MinecraftBlockTypes2["Element1"] = "minecraft:element_1";
        MinecraftBlockTypes2["Element10"] = "minecraft:element_10";
        MinecraftBlockTypes2["Element100"] = "minecraft:element_100";
        MinecraftBlockTypes2["Element101"] = "minecraft:element_101";
        MinecraftBlockTypes2["Element102"] = "minecraft:element_102";
        MinecraftBlockTypes2["Element103"] = "minecraft:element_103";
        MinecraftBlockTypes2["Element104"] = "minecraft:element_104";
        MinecraftBlockTypes2["Element105"] = "minecraft:element_105";
        MinecraftBlockTypes2["Element106"] = "minecraft:element_106";
        MinecraftBlockTypes2["Element107"] = "minecraft:element_107";
        MinecraftBlockTypes2["Element108"] = "minecraft:element_108";
        MinecraftBlockTypes2["Element109"] = "minecraft:element_109";
        MinecraftBlockTypes2["Element11"] = "minecraft:element_11";
        MinecraftBlockTypes2["Element110"] = "minecraft:element_110";
        MinecraftBlockTypes2["Element111"] = "minecraft:element_111";
        MinecraftBlockTypes2["Element112"] = "minecraft:element_112";
        MinecraftBlockTypes2["Element113"] = "minecraft:element_113";
        MinecraftBlockTypes2["Element114"] = "minecraft:element_114";
        MinecraftBlockTypes2["Element115"] = "minecraft:element_115";
        MinecraftBlockTypes2["Element116"] = "minecraft:element_116";
        MinecraftBlockTypes2["Element117"] = "minecraft:element_117";
        MinecraftBlockTypes2["Element118"] = "minecraft:element_118";
        MinecraftBlockTypes2["Element12"] = "minecraft:element_12";
        MinecraftBlockTypes2["Element13"] = "minecraft:element_13";
        MinecraftBlockTypes2["Element14"] = "minecraft:element_14";
        MinecraftBlockTypes2["Element15"] = "minecraft:element_15";
        MinecraftBlockTypes2["Element16"] = "minecraft:element_16";
        MinecraftBlockTypes2["Element17"] = "minecraft:element_17";
        MinecraftBlockTypes2["Element18"] = "minecraft:element_18";
        MinecraftBlockTypes2["Element19"] = "minecraft:element_19";
        MinecraftBlockTypes2["Element2"] = "minecraft:element_2";
        MinecraftBlockTypes2["Element20"] = "minecraft:element_20";
        MinecraftBlockTypes2["Element21"] = "minecraft:element_21";
        MinecraftBlockTypes2["Element22"] = "minecraft:element_22";
        MinecraftBlockTypes2["Element23"] = "minecraft:element_23";
        MinecraftBlockTypes2["Element24"] = "minecraft:element_24";
        MinecraftBlockTypes2["Element25"] = "minecraft:element_25";
        MinecraftBlockTypes2["Element26"] = "minecraft:element_26";
        MinecraftBlockTypes2["Element27"] = "minecraft:element_27";
        MinecraftBlockTypes2["Element28"] = "minecraft:element_28";
        MinecraftBlockTypes2["Element29"] = "minecraft:element_29";
        MinecraftBlockTypes2["Element3"] = "minecraft:element_3";
        MinecraftBlockTypes2["Element30"] = "minecraft:element_30";
        MinecraftBlockTypes2["Element31"] = "minecraft:element_31";
        MinecraftBlockTypes2["Element32"] = "minecraft:element_32";
        MinecraftBlockTypes2["Element33"] = "minecraft:element_33";
        MinecraftBlockTypes2["Element34"] = "minecraft:element_34";
        MinecraftBlockTypes2["Element35"] = "minecraft:element_35";
        MinecraftBlockTypes2["Element36"] = "minecraft:element_36";
        MinecraftBlockTypes2["Element37"] = "minecraft:element_37";
        MinecraftBlockTypes2["Element38"] = "minecraft:element_38";
        MinecraftBlockTypes2["Element39"] = "minecraft:element_39";
        MinecraftBlockTypes2["Element4"] = "minecraft:element_4";
        MinecraftBlockTypes2["Element40"] = "minecraft:element_40";
        MinecraftBlockTypes2["Element41"] = "minecraft:element_41";
        MinecraftBlockTypes2["Element42"] = "minecraft:element_42";
        MinecraftBlockTypes2["Element43"] = "minecraft:element_43";
        MinecraftBlockTypes2["Element44"] = "minecraft:element_44";
        MinecraftBlockTypes2["Element45"] = "minecraft:element_45";
        MinecraftBlockTypes2["Element46"] = "minecraft:element_46";
        MinecraftBlockTypes2["Element47"] = "minecraft:element_47";
        MinecraftBlockTypes2["Element48"] = "minecraft:element_48";
        MinecraftBlockTypes2["Element49"] = "minecraft:element_49";
        MinecraftBlockTypes2["Element5"] = "minecraft:element_5";
        MinecraftBlockTypes2["Element50"] = "minecraft:element_50";
        MinecraftBlockTypes2["Element51"] = "minecraft:element_51";
        MinecraftBlockTypes2["Element52"] = "minecraft:element_52";
        MinecraftBlockTypes2["Element53"] = "minecraft:element_53";
        MinecraftBlockTypes2["Element54"] = "minecraft:element_54";
        MinecraftBlockTypes2["Element55"] = "minecraft:element_55";
        MinecraftBlockTypes2["Element56"] = "minecraft:element_56";
        MinecraftBlockTypes2["Element57"] = "minecraft:element_57";
        MinecraftBlockTypes2["Element58"] = "minecraft:element_58";
        MinecraftBlockTypes2["Element59"] = "minecraft:element_59";
        MinecraftBlockTypes2["Element6"] = "minecraft:element_6";
        MinecraftBlockTypes2["Element60"] = "minecraft:element_60";
        MinecraftBlockTypes2["Element61"] = "minecraft:element_61";
        MinecraftBlockTypes2["Element62"] = "minecraft:element_62";
        MinecraftBlockTypes2["Element63"] = "minecraft:element_63";
        MinecraftBlockTypes2["Element64"] = "minecraft:element_64";
        MinecraftBlockTypes2["Element65"] = "minecraft:element_65";
        MinecraftBlockTypes2["Element66"] = "minecraft:element_66";
        MinecraftBlockTypes2["Element67"] = "minecraft:element_67";
        MinecraftBlockTypes2["Element68"] = "minecraft:element_68";
        MinecraftBlockTypes2["Element69"] = "minecraft:element_69";
        MinecraftBlockTypes2["Element7"] = "minecraft:element_7";
        MinecraftBlockTypes2["Element70"] = "minecraft:element_70";
        MinecraftBlockTypes2["Element71"] = "minecraft:element_71";
        MinecraftBlockTypes2["Element72"] = "minecraft:element_72";
        MinecraftBlockTypes2["Element73"] = "minecraft:element_73";
        MinecraftBlockTypes2["Element74"] = "minecraft:element_74";
        MinecraftBlockTypes2["Element75"] = "minecraft:element_75";
        MinecraftBlockTypes2["Element76"] = "minecraft:element_76";
        MinecraftBlockTypes2["Element77"] = "minecraft:element_77";
        MinecraftBlockTypes2["Element78"] = "minecraft:element_78";
        MinecraftBlockTypes2["Element79"] = "minecraft:element_79";
        MinecraftBlockTypes2["Element8"] = "minecraft:element_8";
        MinecraftBlockTypes2["Element80"] = "minecraft:element_80";
        MinecraftBlockTypes2["Element81"] = "minecraft:element_81";
        MinecraftBlockTypes2["Element82"] = "minecraft:element_82";
        MinecraftBlockTypes2["Element83"] = "minecraft:element_83";
        MinecraftBlockTypes2["Element84"] = "minecraft:element_84";
        MinecraftBlockTypes2["Element85"] = "minecraft:element_85";
        MinecraftBlockTypes2["Element86"] = "minecraft:element_86";
        MinecraftBlockTypes2["Element87"] = "minecraft:element_87";
        MinecraftBlockTypes2["Element88"] = "minecraft:element_88";
        MinecraftBlockTypes2["Element89"] = "minecraft:element_89";
        MinecraftBlockTypes2["Element9"] = "minecraft:element_9";
        MinecraftBlockTypes2["Element90"] = "minecraft:element_90";
        MinecraftBlockTypes2["Element91"] = "minecraft:element_91";
        MinecraftBlockTypes2["Element92"] = "minecraft:element_92";
        MinecraftBlockTypes2["Element93"] = "minecraft:element_93";
        MinecraftBlockTypes2["Element94"] = "minecraft:element_94";
        MinecraftBlockTypes2["Element95"] = "minecraft:element_95";
        MinecraftBlockTypes2["Element96"] = "minecraft:element_96";
        MinecraftBlockTypes2["Element97"] = "minecraft:element_97";
        MinecraftBlockTypes2["Element98"] = "minecraft:element_98";
        MinecraftBlockTypes2["Element99"] = "minecraft:element_99";
        MinecraftBlockTypes2["ElementConstructor"] = "minecraft:element_constructor";
        MinecraftBlockTypes2["EmeraldBlock"] = "minecraft:emerald_block";
        MinecraftBlockTypes2["EmeraldOre"] = "minecraft:emerald_ore";
        MinecraftBlockTypes2["EnchantingTable"] = "minecraft:enchanting_table";
        MinecraftBlockTypes2["EndBrickStairs"] = "minecraft:end_brick_stairs";
        MinecraftBlockTypes2["EndBricks"] = "minecraft:end_bricks";
        MinecraftBlockTypes2["EndPortal"] = "minecraft:end_portal";
        MinecraftBlockTypes2["EndPortalFrame"] = "minecraft:end_portal_frame";
        MinecraftBlockTypes2["EndRod"] = "minecraft:end_rod";
        MinecraftBlockTypes2["EndStone"] = "minecraft:end_stone";
        MinecraftBlockTypes2["EndStoneBrickDoubleSlab"] = "minecraft:end_stone_brick_double_slab";
        MinecraftBlockTypes2["EndStoneBrickSlab"] = "minecraft:end_stone_brick_slab";
        MinecraftBlockTypes2["EndStoneBrickWall"] = "minecraft:end_stone_brick_wall";
        MinecraftBlockTypes2["EnderChest"] = "minecraft:ender_chest";
        MinecraftBlockTypes2["ExposedChiseledCopper"] = "minecraft:exposed_chiseled_copper";
        MinecraftBlockTypes2["ExposedCopper"] = "minecraft:exposed_copper";
        MinecraftBlockTypes2["ExposedCopperBars"] = "minecraft:exposed_copper_bars";
        MinecraftBlockTypes2["ExposedCopperBulb"] = "minecraft:exposed_copper_bulb";
        MinecraftBlockTypes2["ExposedCopperChain"] = "minecraft:exposed_copper_chain";
        MinecraftBlockTypes2["ExposedCopperChest"] = "minecraft:exposed_copper_chest";
        MinecraftBlockTypes2["ExposedCopperDoor"] = "minecraft:exposed_copper_door";
        MinecraftBlockTypes2["ExposedCopperGolemStatue"] = "minecraft:exposed_copper_golem_statue";
        MinecraftBlockTypes2["ExposedCopperGrate"] = "minecraft:exposed_copper_grate";
        MinecraftBlockTypes2["ExposedCopperLantern"] = "minecraft:exposed_copper_lantern";
        MinecraftBlockTypes2["ExposedCopperTrapdoor"] = "minecraft:exposed_copper_trapdoor";
        MinecraftBlockTypes2["ExposedCutCopper"] = "minecraft:exposed_cut_copper";
        MinecraftBlockTypes2["ExposedCutCopperSlab"] = "minecraft:exposed_cut_copper_slab";
        MinecraftBlockTypes2["ExposedCutCopperStairs"] = "minecraft:exposed_cut_copper_stairs";
        MinecraftBlockTypes2["ExposedDoubleCutCopperSlab"] = "minecraft:exposed_double_cut_copper_slab";
        MinecraftBlockTypes2["ExposedLightningRod"] = "minecraft:exposed_lightning_rod";
        MinecraftBlockTypes2["Farmland"] = "minecraft:farmland";
        MinecraftBlockTypes2["FenceGate"] = "minecraft:fence_gate";
        MinecraftBlockTypes2["Fern"] = "minecraft:fern";
        MinecraftBlockTypes2["Fire"] = "minecraft:fire";
        MinecraftBlockTypes2["FireCoral"] = "minecraft:fire_coral";
        MinecraftBlockTypes2["FireCoralBlock"] = "minecraft:fire_coral_block";
        MinecraftBlockTypes2["FireCoralFan"] = "minecraft:fire_coral_fan";
        MinecraftBlockTypes2["FireCoralWallFan"] = "minecraft:fire_coral_wall_fan";
        MinecraftBlockTypes2["FireflyBush"] = "minecraft:firefly_bush";
        MinecraftBlockTypes2["FletchingTable"] = "minecraft:fletching_table";
        MinecraftBlockTypes2["FlowerPot"] = "minecraft:flower_pot";
        MinecraftBlockTypes2["FloweringAzalea"] = "minecraft:flowering_azalea";
        MinecraftBlockTypes2["FlowingLava"] = "minecraft:flowing_lava";
        MinecraftBlockTypes2["FlowingWater"] = "minecraft:flowing_water";
        MinecraftBlockTypes2["Frame"] = "minecraft:frame";
        MinecraftBlockTypes2["FrogSpawn"] = "minecraft:frog_spawn";
        MinecraftBlockTypes2["FrostedIce"] = "minecraft:frosted_ice";
        MinecraftBlockTypes2["Furnace"] = "minecraft:furnace";
        MinecraftBlockTypes2["GildedBlackstone"] = "minecraft:gilded_blackstone";
        MinecraftBlockTypes2["Glass"] = "minecraft:glass";
        MinecraftBlockTypes2["GlassPane"] = "minecraft:glass_pane";
        MinecraftBlockTypes2["GlowFrame"] = "minecraft:glow_frame";
        MinecraftBlockTypes2["GlowLichen"] = "minecraft:glow_lichen";
        MinecraftBlockTypes2["Glowstone"] = "minecraft:glowstone";
        MinecraftBlockTypes2["GoldBlock"] = "minecraft:gold_block";
        MinecraftBlockTypes2["GoldOre"] = "minecraft:gold_ore";
        MinecraftBlockTypes2["GoldenRail"] = "minecraft:golden_rail";
        MinecraftBlockTypes2["Granite"] = "minecraft:granite";
        MinecraftBlockTypes2["GraniteDoubleSlab"] = "minecraft:granite_double_slab";
        MinecraftBlockTypes2["GraniteSlab"] = "minecraft:granite_slab";
        MinecraftBlockTypes2["GraniteStairs"] = "minecraft:granite_stairs";
        MinecraftBlockTypes2["GraniteWall"] = "minecraft:granite_wall";
        MinecraftBlockTypes2["GrassBlock"] = "minecraft:grass_block";
        MinecraftBlockTypes2["GrassPath"] = "minecraft:grass_path";
        MinecraftBlockTypes2["Gravel"] = "minecraft:gravel";
        MinecraftBlockTypes2["GrayCandle"] = "minecraft:gray_candle";
        MinecraftBlockTypes2["GrayCandleCake"] = "minecraft:gray_candle_cake";
        MinecraftBlockTypes2["GrayCarpet"] = "minecraft:gray_carpet";
        MinecraftBlockTypes2["GrayConcrete"] = "minecraft:gray_concrete";
        MinecraftBlockTypes2["GrayConcretePowder"] = "minecraft:gray_concrete_powder";
        MinecraftBlockTypes2["GrayGlazedTerracotta"] = "minecraft:gray_glazed_terracotta";
        MinecraftBlockTypes2["GrayShulkerBox"] = "minecraft:gray_shulker_box";
        MinecraftBlockTypes2["GrayStainedGlass"] = "minecraft:gray_stained_glass";
        MinecraftBlockTypes2["GrayStainedGlassPane"] = "minecraft:gray_stained_glass_pane";
        MinecraftBlockTypes2["GrayTerracotta"] = "minecraft:gray_terracotta";
        MinecraftBlockTypes2["GrayWool"] = "minecraft:gray_wool";
        MinecraftBlockTypes2["GreenCandle"] = "minecraft:green_candle";
        MinecraftBlockTypes2["GreenCandleCake"] = "minecraft:green_candle_cake";
        MinecraftBlockTypes2["GreenCarpet"] = "minecraft:green_carpet";
        MinecraftBlockTypes2["GreenConcrete"] = "minecraft:green_concrete";
        MinecraftBlockTypes2["GreenConcretePowder"] = "minecraft:green_concrete_powder";
        MinecraftBlockTypes2["GreenGlazedTerracotta"] = "minecraft:green_glazed_terracotta";
        MinecraftBlockTypes2["GreenShulkerBox"] = "minecraft:green_shulker_box";
        MinecraftBlockTypes2["GreenStainedGlass"] = "minecraft:green_stained_glass";
        MinecraftBlockTypes2["GreenStainedGlassPane"] = "minecraft:green_stained_glass_pane";
        MinecraftBlockTypes2["GreenTerracotta"] = "minecraft:green_terracotta";
        MinecraftBlockTypes2["GreenWool"] = "minecraft:green_wool";
        MinecraftBlockTypes2["Grindstone"] = "minecraft:grindstone";
        MinecraftBlockTypes2["HangingRoots"] = "minecraft:hanging_roots";
        MinecraftBlockTypes2["HardBlackStainedGlass"] = "minecraft:hard_black_stained_glass";
        MinecraftBlockTypes2["HardBlackStainedGlassPane"] = "minecraft:hard_black_stained_glass_pane";
        MinecraftBlockTypes2["HardBlueStainedGlass"] = "minecraft:hard_blue_stained_glass";
        MinecraftBlockTypes2["HardBlueStainedGlassPane"] = "minecraft:hard_blue_stained_glass_pane";
        MinecraftBlockTypes2["HardBrownStainedGlass"] = "minecraft:hard_brown_stained_glass";
        MinecraftBlockTypes2["HardBrownStainedGlassPane"] = "minecraft:hard_brown_stained_glass_pane";
        MinecraftBlockTypes2["HardCyanStainedGlass"] = "minecraft:hard_cyan_stained_glass";
        MinecraftBlockTypes2["HardCyanStainedGlassPane"] = "minecraft:hard_cyan_stained_glass_pane";
        MinecraftBlockTypes2["HardGlass"] = "minecraft:hard_glass";
        MinecraftBlockTypes2["HardGlassPane"] = "minecraft:hard_glass_pane";
        MinecraftBlockTypes2["HardGrayStainedGlass"] = "minecraft:hard_gray_stained_glass";
        MinecraftBlockTypes2["HardGrayStainedGlassPane"] = "minecraft:hard_gray_stained_glass_pane";
        MinecraftBlockTypes2["HardGreenStainedGlass"] = "minecraft:hard_green_stained_glass";
        MinecraftBlockTypes2["HardGreenStainedGlassPane"] = "minecraft:hard_green_stained_glass_pane";
        MinecraftBlockTypes2["HardLightBlueStainedGlass"] = "minecraft:hard_light_blue_stained_glass";
        MinecraftBlockTypes2["HardLightBlueStainedGlassPane"] = "minecraft:hard_light_blue_stained_glass_pane";
        MinecraftBlockTypes2["HardLightGrayStainedGlass"] = "minecraft:hard_light_gray_stained_glass";
        MinecraftBlockTypes2["HardLightGrayStainedGlassPane"] = "minecraft:hard_light_gray_stained_glass_pane";
        MinecraftBlockTypes2["HardLimeStainedGlass"] = "minecraft:hard_lime_stained_glass";
        MinecraftBlockTypes2["HardLimeStainedGlassPane"] = "minecraft:hard_lime_stained_glass_pane";
        MinecraftBlockTypes2["HardMagentaStainedGlass"] = "minecraft:hard_magenta_stained_glass";
        MinecraftBlockTypes2["HardMagentaStainedGlassPane"] = "minecraft:hard_magenta_stained_glass_pane";
        MinecraftBlockTypes2["HardOrangeStainedGlass"] = "minecraft:hard_orange_stained_glass";
        MinecraftBlockTypes2["HardOrangeStainedGlassPane"] = "minecraft:hard_orange_stained_glass_pane";
        MinecraftBlockTypes2["HardPinkStainedGlass"] = "minecraft:hard_pink_stained_glass";
        MinecraftBlockTypes2["HardPinkStainedGlassPane"] = "minecraft:hard_pink_stained_glass_pane";
        MinecraftBlockTypes2["HardPurpleStainedGlass"] = "minecraft:hard_purple_stained_glass";
        MinecraftBlockTypes2["HardPurpleStainedGlassPane"] = "minecraft:hard_purple_stained_glass_pane";
        MinecraftBlockTypes2["HardRedStainedGlass"] = "minecraft:hard_red_stained_glass";
        MinecraftBlockTypes2["HardRedStainedGlassPane"] = "minecraft:hard_red_stained_glass_pane";
        MinecraftBlockTypes2["HardWhiteStainedGlass"] = "minecraft:hard_white_stained_glass";
        MinecraftBlockTypes2["HardWhiteStainedGlassPane"] = "minecraft:hard_white_stained_glass_pane";
        MinecraftBlockTypes2["HardYellowStainedGlass"] = "minecraft:hard_yellow_stained_glass";
        MinecraftBlockTypes2["HardYellowStainedGlassPane"] = "minecraft:hard_yellow_stained_glass_pane";
        MinecraftBlockTypes2["HardenedClay"] = "minecraft:hardened_clay";
        MinecraftBlockTypes2["HayBlock"] = "minecraft:hay_block";
        MinecraftBlockTypes2["HeavyCore"] = "minecraft:heavy_core";
        MinecraftBlockTypes2["HeavyWeightedPressurePlate"] = "minecraft:heavy_weighted_pressure_plate";
        MinecraftBlockTypes2["HoneyBlock"] = "minecraft:honey_block";
        MinecraftBlockTypes2["HoneycombBlock"] = "minecraft:honeycomb_block";
        MinecraftBlockTypes2["Hopper"] = "minecraft:hopper";
        MinecraftBlockTypes2["HornCoral"] = "minecraft:horn_coral";
        MinecraftBlockTypes2["HornCoralBlock"] = "minecraft:horn_coral_block";
        MinecraftBlockTypes2["HornCoralFan"] = "minecraft:horn_coral_fan";
        MinecraftBlockTypes2["HornCoralWallFan"] = "minecraft:horn_coral_wall_fan";
        MinecraftBlockTypes2["Ice"] = "minecraft:ice";
        MinecraftBlockTypes2["InfestedChiseledStoneBricks"] = "minecraft:infested_chiseled_stone_bricks";
        MinecraftBlockTypes2["InfestedCobblestone"] = "minecraft:infested_cobblestone";
        MinecraftBlockTypes2["InfestedCrackedStoneBricks"] = "minecraft:infested_cracked_stone_bricks";
        MinecraftBlockTypes2["InfestedDeepslate"] = "minecraft:infested_deepslate";
        MinecraftBlockTypes2["InfestedMossyStoneBricks"] = "minecraft:infested_mossy_stone_bricks";
        MinecraftBlockTypes2["InfestedStone"] = "minecraft:infested_stone";
        MinecraftBlockTypes2["InfestedStoneBricks"] = "minecraft:infested_stone_bricks";
        MinecraftBlockTypes2["IronBars"] = "minecraft:iron_bars";
        MinecraftBlockTypes2["IronBlock"] = "minecraft:iron_block";
        MinecraftBlockTypes2["IronChain"] = "minecraft:iron_chain";
        MinecraftBlockTypes2["IronDoor"] = "minecraft:iron_door";
        MinecraftBlockTypes2["IronOre"] = "minecraft:iron_ore";
        MinecraftBlockTypes2["IronTrapdoor"] = "minecraft:iron_trapdoor";
        MinecraftBlockTypes2["Jigsaw"] = "minecraft:jigsaw";
        MinecraftBlockTypes2["Jukebox"] = "minecraft:jukebox";
        MinecraftBlockTypes2["JungleButton"] = "minecraft:jungle_button";
        MinecraftBlockTypes2["JungleDoor"] = "minecraft:jungle_door";
        MinecraftBlockTypes2["JungleDoubleSlab"] = "minecraft:jungle_double_slab";
        MinecraftBlockTypes2["JungleFence"] = "minecraft:jungle_fence";
        MinecraftBlockTypes2["JungleFenceGate"] = "minecraft:jungle_fence_gate";
        MinecraftBlockTypes2["JungleHangingSign"] = "minecraft:jungle_hanging_sign";
        MinecraftBlockTypes2["JungleLeaves"] = "minecraft:jungle_leaves";
        MinecraftBlockTypes2["JungleLog"] = "minecraft:jungle_log";
        MinecraftBlockTypes2["JunglePlanks"] = "minecraft:jungle_planks";
        MinecraftBlockTypes2["JunglePressurePlate"] = "minecraft:jungle_pressure_plate";
        MinecraftBlockTypes2["JungleSapling"] = "minecraft:jungle_sapling";
        MinecraftBlockTypes2["JungleShelf"] = "minecraft:jungle_shelf";
        MinecraftBlockTypes2["JungleSlab"] = "minecraft:jungle_slab";
        MinecraftBlockTypes2["JungleStairs"] = "minecraft:jungle_stairs";
        MinecraftBlockTypes2["JungleStandingSign"] = "minecraft:jungle_standing_sign";
        MinecraftBlockTypes2["JungleTrapdoor"] = "minecraft:jungle_trapdoor";
        MinecraftBlockTypes2["JungleWallSign"] = "minecraft:jungle_wall_sign";
        MinecraftBlockTypes2["JungleWood"] = "minecraft:jungle_wood";
        MinecraftBlockTypes2["Kelp"] = "minecraft:kelp";
        MinecraftBlockTypes2["LabTable"] = "minecraft:lab_table";
        MinecraftBlockTypes2["Ladder"] = "minecraft:ladder";
        MinecraftBlockTypes2["Lantern"] = "minecraft:lantern";
        MinecraftBlockTypes2["LapisBlock"] = "minecraft:lapis_block";
        MinecraftBlockTypes2["LapisOre"] = "minecraft:lapis_ore";
        MinecraftBlockTypes2["LargeAmethystBud"] = "minecraft:large_amethyst_bud";
        MinecraftBlockTypes2["LargeFern"] = "minecraft:large_fern";
        MinecraftBlockTypes2["Lava"] = "minecraft:lava";
        MinecraftBlockTypes2["LeafLitter"] = "minecraft:leaf_litter";
        MinecraftBlockTypes2["Lectern"] = "minecraft:lectern";
        MinecraftBlockTypes2["Lever"] = "minecraft:lever";
        MinecraftBlockTypes2["LightBlock0"] = "minecraft:light_block_0";
        MinecraftBlockTypes2["LightBlock1"] = "minecraft:light_block_1";
        MinecraftBlockTypes2["LightBlock10"] = "minecraft:light_block_10";
        MinecraftBlockTypes2["LightBlock11"] = "minecraft:light_block_11";
        MinecraftBlockTypes2["LightBlock12"] = "minecraft:light_block_12";
        MinecraftBlockTypes2["LightBlock13"] = "minecraft:light_block_13";
        MinecraftBlockTypes2["LightBlock14"] = "minecraft:light_block_14";
        MinecraftBlockTypes2["LightBlock15"] = "minecraft:light_block_15";
        MinecraftBlockTypes2["LightBlock2"] = "minecraft:light_block_2";
        MinecraftBlockTypes2["LightBlock3"] = "minecraft:light_block_3";
        MinecraftBlockTypes2["LightBlock4"] = "minecraft:light_block_4";
        MinecraftBlockTypes2["LightBlock5"] = "minecraft:light_block_5";
        MinecraftBlockTypes2["LightBlock6"] = "minecraft:light_block_6";
        MinecraftBlockTypes2["LightBlock7"] = "minecraft:light_block_7";
        MinecraftBlockTypes2["LightBlock8"] = "minecraft:light_block_8";
        MinecraftBlockTypes2["LightBlock9"] = "minecraft:light_block_9";
        MinecraftBlockTypes2["LightBlueCandle"] = "minecraft:light_blue_candle";
        MinecraftBlockTypes2["LightBlueCandleCake"] = "minecraft:light_blue_candle_cake";
        MinecraftBlockTypes2["LightBlueCarpet"] = "minecraft:light_blue_carpet";
        MinecraftBlockTypes2["LightBlueConcrete"] = "minecraft:light_blue_concrete";
        MinecraftBlockTypes2["LightBlueConcretePowder"] = "minecraft:light_blue_concrete_powder";
        MinecraftBlockTypes2["LightBlueGlazedTerracotta"] = "minecraft:light_blue_glazed_terracotta";
        MinecraftBlockTypes2["LightBlueShulkerBox"] = "minecraft:light_blue_shulker_box";
        MinecraftBlockTypes2["LightBlueStainedGlass"] = "minecraft:light_blue_stained_glass";
        MinecraftBlockTypes2["LightBlueStainedGlassPane"] = "minecraft:light_blue_stained_glass_pane";
        MinecraftBlockTypes2["LightBlueTerracotta"] = "minecraft:light_blue_terracotta";
        MinecraftBlockTypes2["LightBlueWool"] = "minecraft:light_blue_wool";
        MinecraftBlockTypes2["LightGrayCandle"] = "minecraft:light_gray_candle";
        MinecraftBlockTypes2["LightGrayCandleCake"] = "minecraft:light_gray_candle_cake";
        MinecraftBlockTypes2["LightGrayCarpet"] = "minecraft:light_gray_carpet";
        MinecraftBlockTypes2["LightGrayConcrete"] = "minecraft:light_gray_concrete";
        MinecraftBlockTypes2["LightGrayConcretePowder"] = "minecraft:light_gray_concrete_powder";
        MinecraftBlockTypes2["LightGrayShulkerBox"] = "minecraft:light_gray_shulker_box";
        MinecraftBlockTypes2["LightGrayStainedGlass"] = "minecraft:light_gray_stained_glass";
        MinecraftBlockTypes2["LightGrayStainedGlassPane"] = "minecraft:light_gray_stained_glass_pane";
        MinecraftBlockTypes2["LightGrayTerracotta"] = "minecraft:light_gray_terracotta";
        MinecraftBlockTypes2["LightGrayWool"] = "minecraft:light_gray_wool";
        MinecraftBlockTypes2["LightWeightedPressurePlate"] = "minecraft:light_weighted_pressure_plate";
        MinecraftBlockTypes2["LightningRod"] = "minecraft:lightning_rod";
        MinecraftBlockTypes2["Lilac"] = "minecraft:lilac";
        MinecraftBlockTypes2["LilyOfTheValley"] = "minecraft:lily_of_the_valley";
        MinecraftBlockTypes2["LimeCandle"] = "minecraft:lime_candle";
        MinecraftBlockTypes2["LimeCandleCake"] = "minecraft:lime_candle_cake";
        MinecraftBlockTypes2["LimeCarpet"] = "minecraft:lime_carpet";
        MinecraftBlockTypes2["LimeConcrete"] = "minecraft:lime_concrete";
        MinecraftBlockTypes2["LimeConcretePowder"] = "minecraft:lime_concrete_powder";
        MinecraftBlockTypes2["LimeGlazedTerracotta"] = "minecraft:lime_glazed_terracotta";
        MinecraftBlockTypes2["LimeShulkerBox"] = "minecraft:lime_shulker_box";
        MinecraftBlockTypes2["LimeStainedGlass"] = "minecraft:lime_stained_glass";
        MinecraftBlockTypes2["LimeStainedGlassPane"] = "minecraft:lime_stained_glass_pane";
        MinecraftBlockTypes2["LimeTerracotta"] = "minecraft:lime_terracotta";
        MinecraftBlockTypes2["LimeWool"] = "minecraft:lime_wool";
        MinecraftBlockTypes2["LitBlastFurnace"] = "minecraft:lit_blast_furnace";
        MinecraftBlockTypes2["LitDeepslateRedstoneOre"] = "minecraft:lit_deepslate_redstone_ore";
        MinecraftBlockTypes2["LitFurnace"] = "minecraft:lit_furnace";
        MinecraftBlockTypes2["LitPumpkin"] = "minecraft:lit_pumpkin";
        MinecraftBlockTypes2["LitRedstoneLamp"] = "minecraft:lit_redstone_lamp";
        MinecraftBlockTypes2["LitRedstoneOre"] = "minecraft:lit_redstone_ore";
        MinecraftBlockTypes2["LitSmoker"] = "minecraft:lit_smoker";
        MinecraftBlockTypes2["Lodestone"] = "minecraft:lodestone";
        MinecraftBlockTypes2["Loom"] = "minecraft:loom";
        MinecraftBlockTypes2["MagentaCandle"] = "minecraft:magenta_candle";
        MinecraftBlockTypes2["MagentaCandleCake"] = "minecraft:magenta_candle_cake";
        MinecraftBlockTypes2["MagentaCarpet"] = "minecraft:magenta_carpet";
        MinecraftBlockTypes2["MagentaConcrete"] = "minecraft:magenta_concrete";
        MinecraftBlockTypes2["MagentaConcretePowder"] = "minecraft:magenta_concrete_powder";
        MinecraftBlockTypes2["MagentaGlazedTerracotta"] = "minecraft:magenta_glazed_terracotta";
        MinecraftBlockTypes2["MagentaShulkerBox"] = "minecraft:magenta_shulker_box";
        MinecraftBlockTypes2["MagentaStainedGlass"] = "minecraft:magenta_stained_glass";
        MinecraftBlockTypes2["MagentaStainedGlassPane"] = "minecraft:magenta_stained_glass_pane";
        MinecraftBlockTypes2["MagentaTerracotta"] = "minecraft:magenta_terracotta";
        MinecraftBlockTypes2["MagentaWool"] = "minecraft:magenta_wool";
        MinecraftBlockTypes2["Magma"] = "minecraft:magma";
        MinecraftBlockTypes2["MangroveButton"] = "minecraft:mangrove_button";
        MinecraftBlockTypes2["MangroveDoor"] = "minecraft:mangrove_door";
        MinecraftBlockTypes2["MangroveDoubleSlab"] = "minecraft:mangrove_double_slab";
        MinecraftBlockTypes2["MangroveFence"] = "minecraft:mangrove_fence";
        MinecraftBlockTypes2["MangroveFenceGate"] = "minecraft:mangrove_fence_gate";
        MinecraftBlockTypes2["MangroveHangingSign"] = "minecraft:mangrove_hanging_sign";
        MinecraftBlockTypes2["MangroveLeaves"] = "minecraft:mangrove_leaves";
        MinecraftBlockTypes2["MangroveLog"] = "minecraft:mangrove_log";
        MinecraftBlockTypes2["MangrovePlanks"] = "minecraft:mangrove_planks";
        MinecraftBlockTypes2["MangrovePressurePlate"] = "minecraft:mangrove_pressure_plate";
        MinecraftBlockTypes2["MangrovePropagule"] = "minecraft:mangrove_propagule";
        MinecraftBlockTypes2["MangroveRoots"] = "minecraft:mangrove_roots";
        MinecraftBlockTypes2["MangroveShelf"] = "minecraft:mangrove_shelf";
        MinecraftBlockTypes2["MangroveSlab"] = "minecraft:mangrove_slab";
        MinecraftBlockTypes2["MangroveStairs"] = "minecraft:mangrove_stairs";
        MinecraftBlockTypes2["MangroveStandingSign"] = "minecraft:mangrove_standing_sign";
        MinecraftBlockTypes2["MangroveTrapdoor"] = "minecraft:mangrove_trapdoor";
        MinecraftBlockTypes2["MangroveWallSign"] = "minecraft:mangrove_wall_sign";
        MinecraftBlockTypes2["MangroveWood"] = "minecraft:mangrove_wood";
        MinecraftBlockTypes2["MaterialReducer"] = "minecraft:material_reducer";
        MinecraftBlockTypes2["MediumAmethystBud"] = "minecraft:medium_amethyst_bud";
        MinecraftBlockTypes2["MelonBlock"] = "minecraft:melon_block";
        MinecraftBlockTypes2["MelonStem"] = "minecraft:melon_stem";
        MinecraftBlockTypes2["MobSpawner"] = "minecraft:mob_spawner";
        MinecraftBlockTypes2["MossBlock"] = "minecraft:moss_block";
        MinecraftBlockTypes2["MossCarpet"] = "minecraft:moss_carpet";
        MinecraftBlockTypes2["MossyCobblestone"] = "minecraft:mossy_cobblestone";
        MinecraftBlockTypes2["MossyCobblestoneDoubleSlab"] = "minecraft:mossy_cobblestone_double_slab";
        MinecraftBlockTypes2["MossyCobblestoneSlab"] = "minecraft:mossy_cobblestone_slab";
        MinecraftBlockTypes2["MossyCobblestoneStairs"] = "minecraft:mossy_cobblestone_stairs";
        MinecraftBlockTypes2["MossyCobblestoneWall"] = "minecraft:mossy_cobblestone_wall";
        MinecraftBlockTypes2["MossyStoneBrickDoubleSlab"] = "minecraft:mossy_stone_brick_double_slab";
        MinecraftBlockTypes2["MossyStoneBrickSlab"] = "minecraft:mossy_stone_brick_slab";
        MinecraftBlockTypes2["MossyStoneBrickStairs"] = "minecraft:mossy_stone_brick_stairs";
        MinecraftBlockTypes2["MossyStoneBrickWall"] = "minecraft:mossy_stone_brick_wall";
        MinecraftBlockTypes2["MossyStoneBricks"] = "minecraft:mossy_stone_bricks";
        MinecraftBlockTypes2["Mud"] = "minecraft:mud";
        MinecraftBlockTypes2["MudBrickDoubleSlab"] = "minecraft:mud_brick_double_slab";
        MinecraftBlockTypes2["MudBrickSlab"] = "minecraft:mud_brick_slab";
        MinecraftBlockTypes2["MudBrickStairs"] = "minecraft:mud_brick_stairs";
        MinecraftBlockTypes2["MudBrickWall"] = "minecraft:mud_brick_wall";
        MinecraftBlockTypes2["MudBricks"] = "minecraft:mud_bricks";
        MinecraftBlockTypes2["MuddyMangroveRoots"] = "minecraft:muddy_mangrove_roots";
        MinecraftBlockTypes2["MushroomStem"] = "minecraft:mushroom_stem";
        MinecraftBlockTypes2["Mycelium"] = "minecraft:mycelium";
        MinecraftBlockTypes2["NetherBrick"] = "minecraft:nether_brick";
        MinecraftBlockTypes2["NetherBrickDoubleSlab"] = "minecraft:nether_brick_double_slab";
        MinecraftBlockTypes2["NetherBrickFence"] = "minecraft:nether_brick_fence";
        MinecraftBlockTypes2["NetherBrickSlab"] = "minecraft:nether_brick_slab";
        MinecraftBlockTypes2["NetherBrickStairs"] = "minecraft:nether_brick_stairs";
        MinecraftBlockTypes2["NetherBrickWall"] = "minecraft:nether_brick_wall";
        MinecraftBlockTypes2["NetherGoldOre"] = "minecraft:nether_gold_ore";
        MinecraftBlockTypes2["NetherSprouts"] = "minecraft:nether_sprouts";
        MinecraftBlockTypes2["NetherWart"] = "minecraft:nether_wart";
        MinecraftBlockTypes2["NetherWartBlock"] = "minecraft:nether_wart_block";
        MinecraftBlockTypes2["NetheriteBlock"] = "minecraft:netherite_block";
        MinecraftBlockTypes2["Netherrack"] = "minecraft:netherrack";
        MinecraftBlockTypes2["NormalStoneDoubleSlab"] = "minecraft:normal_stone_double_slab";
        MinecraftBlockTypes2["NormalStoneSlab"] = "minecraft:normal_stone_slab";
        MinecraftBlockTypes2["NormalStoneStairs"] = "minecraft:normal_stone_stairs";
        MinecraftBlockTypes2["Noteblock"] = "minecraft:noteblock";
        MinecraftBlockTypes2["OakDoubleSlab"] = "minecraft:oak_double_slab";
        MinecraftBlockTypes2["OakFence"] = "minecraft:oak_fence";
        MinecraftBlockTypes2["OakHangingSign"] = "minecraft:oak_hanging_sign";
        MinecraftBlockTypes2["OakLeaves"] = "minecraft:oak_leaves";
        MinecraftBlockTypes2["OakLog"] = "minecraft:oak_log";
        MinecraftBlockTypes2["OakPlanks"] = "minecraft:oak_planks";
        MinecraftBlockTypes2["OakSapling"] = "minecraft:oak_sapling";
        MinecraftBlockTypes2["OakShelf"] = "minecraft:oak_shelf";
        MinecraftBlockTypes2["OakSlab"] = "minecraft:oak_slab";
        MinecraftBlockTypes2["OakStairs"] = "minecraft:oak_stairs";
        MinecraftBlockTypes2["OakWood"] = "minecraft:oak_wood";
        MinecraftBlockTypes2["Observer"] = "minecraft:observer";
        MinecraftBlockTypes2["Obsidian"] = "minecraft:obsidian";
        MinecraftBlockTypes2["OchreFroglight"] = "minecraft:ochre_froglight";
        MinecraftBlockTypes2["OpenEyeblossom"] = "minecraft:open_eyeblossom";
        MinecraftBlockTypes2["OrangeCandle"] = "minecraft:orange_candle";
        MinecraftBlockTypes2["OrangeCandleCake"] = "minecraft:orange_candle_cake";
        MinecraftBlockTypes2["OrangeCarpet"] = "minecraft:orange_carpet";
        MinecraftBlockTypes2["OrangeConcrete"] = "minecraft:orange_concrete";
        MinecraftBlockTypes2["OrangeConcretePowder"] = "minecraft:orange_concrete_powder";
        MinecraftBlockTypes2["OrangeGlazedTerracotta"] = "minecraft:orange_glazed_terracotta";
        MinecraftBlockTypes2["OrangeShulkerBox"] = "minecraft:orange_shulker_box";
        MinecraftBlockTypes2["OrangeStainedGlass"] = "minecraft:orange_stained_glass";
        MinecraftBlockTypes2["OrangeStainedGlassPane"] = "minecraft:orange_stained_glass_pane";
        MinecraftBlockTypes2["OrangeTerracotta"] = "minecraft:orange_terracotta";
        MinecraftBlockTypes2["OrangeTulip"] = "minecraft:orange_tulip";
        MinecraftBlockTypes2["OrangeWool"] = "minecraft:orange_wool";
        MinecraftBlockTypes2["OxeyeDaisy"] = "minecraft:oxeye_daisy";
        MinecraftBlockTypes2["OxidizedChiseledCopper"] = "minecraft:oxidized_chiseled_copper";
        MinecraftBlockTypes2["OxidizedCopper"] = "minecraft:oxidized_copper";
        MinecraftBlockTypes2["OxidizedCopperBars"] = "minecraft:oxidized_copper_bars";
        MinecraftBlockTypes2["OxidizedCopperBulb"] = "minecraft:oxidized_copper_bulb";
        MinecraftBlockTypes2["OxidizedCopperChain"] = "minecraft:oxidized_copper_chain";
        MinecraftBlockTypes2["OxidizedCopperChest"] = "minecraft:oxidized_copper_chest";
        MinecraftBlockTypes2["OxidizedCopperDoor"] = "minecraft:oxidized_copper_door";
        MinecraftBlockTypes2["OxidizedCopperGolemStatue"] = "minecraft:oxidized_copper_golem_statue";
        MinecraftBlockTypes2["OxidizedCopperGrate"] = "minecraft:oxidized_copper_grate";
        MinecraftBlockTypes2["OxidizedCopperLantern"] = "minecraft:oxidized_copper_lantern";
        MinecraftBlockTypes2["OxidizedCopperTrapdoor"] = "minecraft:oxidized_copper_trapdoor";
        MinecraftBlockTypes2["OxidizedCutCopper"] = "minecraft:oxidized_cut_copper";
        MinecraftBlockTypes2["OxidizedCutCopperSlab"] = "minecraft:oxidized_cut_copper_slab";
        MinecraftBlockTypes2["OxidizedCutCopperStairs"] = "minecraft:oxidized_cut_copper_stairs";
        MinecraftBlockTypes2["OxidizedDoubleCutCopperSlab"] = "minecraft:oxidized_double_cut_copper_slab";
        MinecraftBlockTypes2["OxidizedLightningRod"] = "minecraft:oxidized_lightning_rod";
        MinecraftBlockTypes2["PackedIce"] = "minecraft:packed_ice";
        MinecraftBlockTypes2["PackedMud"] = "minecraft:packed_mud";
        MinecraftBlockTypes2["PaleHangingMoss"] = "minecraft:pale_hanging_moss";
        MinecraftBlockTypes2["PaleMossBlock"] = "minecraft:pale_moss_block";
        MinecraftBlockTypes2["PaleMossCarpet"] = "minecraft:pale_moss_carpet";
        MinecraftBlockTypes2["PaleOakButton"] = "minecraft:pale_oak_button";
        MinecraftBlockTypes2["PaleOakDoor"] = "minecraft:pale_oak_door";
        MinecraftBlockTypes2["PaleOakDoubleSlab"] = "minecraft:pale_oak_double_slab";
        MinecraftBlockTypes2["PaleOakFence"] = "minecraft:pale_oak_fence";
        MinecraftBlockTypes2["PaleOakFenceGate"] = "minecraft:pale_oak_fence_gate";
        MinecraftBlockTypes2["PaleOakHangingSign"] = "minecraft:pale_oak_hanging_sign";
        MinecraftBlockTypes2["PaleOakLeaves"] = "minecraft:pale_oak_leaves";
        MinecraftBlockTypes2["PaleOakLog"] = "minecraft:pale_oak_log";
        MinecraftBlockTypes2["PaleOakPlanks"] = "minecraft:pale_oak_planks";
        MinecraftBlockTypes2["PaleOakPressurePlate"] = "minecraft:pale_oak_pressure_plate";
        MinecraftBlockTypes2["PaleOakSapling"] = "minecraft:pale_oak_sapling";
        MinecraftBlockTypes2["PaleOakShelf"] = "minecraft:pale_oak_shelf";
        MinecraftBlockTypes2["PaleOakSlab"] = "minecraft:pale_oak_slab";
        MinecraftBlockTypes2["PaleOakStairs"] = "minecraft:pale_oak_stairs";
        MinecraftBlockTypes2["PaleOakStandingSign"] = "minecraft:pale_oak_standing_sign";
        MinecraftBlockTypes2["PaleOakTrapdoor"] = "minecraft:pale_oak_trapdoor";
        MinecraftBlockTypes2["PaleOakWallSign"] = "minecraft:pale_oak_wall_sign";
        MinecraftBlockTypes2["PaleOakWood"] = "minecraft:pale_oak_wood";
        MinecraftBlockTypes2["PearlescentFroglight"] = "minecraft:pearlescent_froglight";
        MinecraftBlockTypes2["Peony"] = "minecraft:peony";
        MinecraftBlockTypes2["PetrifiedOakDoubleSlab"] = "minecraft:petrified_oak_double_slab";
        MinecraftBlockTypes2["PetrifiedOakSlab"] = "minecraft:petrified_oak_slab";
        MinecraftBlockTypes2["PiglinHead"] = "minecraft:piglin_head";
        MinecraftBlockTypes2["PinkCandle"] = "minecraft:pink_candle";
        MinecraftBlockTypes2["PinkCandleCake"] = "minecraft:pink_candle_cake";
        MinecraftBlockTypes2["PinkCarpet"] = "minecraft:pink_carpet";
        MinecraftBlockTypes2["PinkConcrete"] = "minecraft:pink_concrete";
        MinecraftBlockTypes2["PinkConcretePowder"] = "minecraft:pink_concrete_powder";
        MinecraftBlockTypes2["PinkGlazedTerracotta"] = "minecraft:pink_glazed_terracotta";
        MinecraftBlockTypes2["PinkPetals"] = "minecraft:pink_petals";
        MinecraftBlockTypes2["PinkShulkerBox"] = "minecraft:pink_shulker_box";
        MinecraftBlockTypes2["PinkStainedGlass"] = "minecraft:pink_stained_glass";
        MinecraftBlockTypes2["PinkStainedGlassPane"] = "minecraft:pink_stained_glass_pane";
        MinecraftBlockTypes2["PinkTerracotta"] = "minecraft:pink_terracotta";
        MinecraftBlockTypes2["PinkTulip"] = "minecraft:pink_tulip";
        MinecraftBlockTypes2["PinkWool"] = "minecraft:pink_wool";
        MinecraftBlockTypes2["Piston"] = "minecraft:piston";
        MinecraftBlockTypes2["PistonArmCollision"] = "minecraft:piston_arm_collision";
        MinecraftBlockTypes2["PitcherCrop"] = "minecraft:pitcher_crop";
        MinecraftBlockTypes2["PitcherPlant"] = "minecraft:pitcher_plant";
        MinecraftBlockTypes2["PlayerHead"] = "minecraft:player_head";
        MinecraftBlockTypes2["Podzol"] = "minecraft:podzol";
        MinecraftBlockTypes2["PointedDripstone"] = "minecraft:pointed_dripstone";
        MinecraftBlockTypes2["PolishedAndesite"] = "minecraft:polished_andesite";
        MinecraftBlockTypes2["PolishedAndesiteDoubleSlab"] = "minecraft:polished_andesite_double_slab";
        MinecraftBlockTypes2["PolishedAndesiteSlab"] = "minecraft:polished_andesite_slab";
        MinecraftBlockTypes2["PolishedAndesiteStairs"] = "minecraft:polished_andesite_stairs";
        MinecraftBlockTypes2["PolishedBasalt"] = "minecraft:polished_basalt";
        MinecraftBlockTypes2["PolishedBlackstone"] = "minecraft:polished_blackstone";
        MinecraftBlockTypes2["PolishedBlackstoneBrickDoubleSlab"] = "minecraft:polished_blackstone_brick_double_slab";
        MinecraftBlockTypes2["PolishedBlackstoneBrickSlab"] = "minecraft:polished_blackstone_brick_slab";
        MinecraftBlockTypes2["PolishedBlackstoneBrickStairs"] = "minecraft:polished_blackstone_brick_stairs";
        MinecraftBlockTypes2["PolishedBlackstoneBrickWall"] = "minecraft:polished_blackstone_brick_wall";
        MinecraftBlockTypes2["PolishedBlackstoneBricks"] = "minecraft:polished_blackstone_bricks";
        MinecraftBlockTypes2["PolishedBlackstoneButton"] = "minecraft:polished_blackstone_button";
        MinecraftBlockTypes2["PolishedBlackstoneDoubleSlab"] = "minecraft:polished_blackstone_double_slab";
        MinecraftBlockTypes2["PolishedBlackstonePressurePlate"] = "minecraft:polished_blackstone_pressure_plate";
        MinecraftBlockTypes2["PolishedBlackstoneSlab"] = "minecraft:polished_blackstone_slab";
        MinecraftBlockTypes2["PolishedBlackstoneStairs"] = "minecraft:polished_blackstone_stairs";
        MinecraftBlockTypes2["PolishedBlackstoneWall"] = "minecraft:polished_blackstone_wall";
        MinecraftBlockTypes2["PolishedDeepslate"] = "minecraft:polished_deepslate";
        MinecraftBlockTypes2["PolishedDeepslateDoubleSlab"] = "minecraft:polished_deepslate_double_slab";
        MinecraftBlockTypes2["PolishedDeepslateSlab"] = "minecraft:polished_deepslate_slab";
        MinecraftBlockTypes2["PolishedDeepslateStairs"] = "minecraft:polished_deepslate_stairs";
        MinecraftBlockTypes2["PolishedDeepslateWall"] = "minecraft:polished_deepslate_wall";
        MinecraftBlockTypes2["PolishedDiorite"] = "minecraft:polished_diorite";
        MinecraftBlockTypes2["PolishedDioriteDoubleSlab"] = "minecraft:polished_diorite_double_slab";
        MinecraftBlockTypes2["PolishedDioriteSlab"] = "minecraft:polished_diorite_slab";
        MinecraftBlockTypes2["PolishedDioriteStairs"] = "minecraft:polished_diorite_stairs";
        MinecraftBlockTypes2["PolishedGranite"] = "minecraft:polished_granite";
        MinecraftBlockTypes2["PolishedGraniteDoubleSlab"] = "minecraft:polished_granite_double_slab";
        MinecraftBlockTypes2["PolishedGraniteSlab"] = "minecraft:polished_granite_slab";
        MinecraftBlockTypes2["PolishedGraniteStairs"] = "minecraft:polished_granite_stairs";
        MinecraftBlockTypes2["PolishedTuff"] = "minecraft:polished_tuff";
        MinecraftBlockTypes2["PolishedTuffDoubleSlab"] = "minecraft:polished_tuff_double_slab";
        MinecraftBlockTypes2["PolishedTuffSlab"] = "minecraft:polished_tuff_slab";
        MinecraftBlockTypes2["PolishedTuffStairs"] = "minecraft:polished_tuff_stairs";
        MinecraftBlockTypes2["PolishedTuffWall"] = "minecraft:polished_tuff_wall";
        MinecraftBlockTypes2["Poppy"] = "minecraft:poppy";
        MinecraftBlockTypes2["Portal"] = "minecraft:portal";
        MinecraftBlockTypes2["Potatoes"] = "minecraft:potatoes";
        MinecraftBlockTypes2["PowderSnow"] = "minecraft:powder_snow";
        MinecraftBlockTypes2["PoweredComparator"] = "minecraft:powered_comparator";
        MinecraftBlockTypes2["PoweredRepeater"] = "minecraft:powered_repeater";
        MinecraftBlockTypes2["Prismarine"] = "minecraft:prismarine";
        MinecraftBlockTypes2["PrismarineBrickDoubleSlab"] = "minecraft:prismarine_brick_double_slab";
        MinecraftBlockTypes2["PrismarineBrickSlab"] = "minecraft:prismarine_brick_slab";
        MinecraftBlockTypes2["PrismarineBricks"] = "minecraft:prismarine_bricks";
        MinecraftBlockTypes2["PrismarineBricksStairs"] = "minecraft:prismarine_bricks_stairs";
        MinecraftBlockTypes2["PrismarineDoubleSlab"] = "minecraft:prismarine_double_slab";
        MinecraftBlockTypes2["PrismarineSlab"] = "minecraft:prismarine_slab";
        MinecraftBlockTypes2["PrismarineStairs"] = "minecraft:prismarine_stairs";
        MinecraftBlockTypes2["PrismarineWall"] = "minecraft:prismarine_wall";
        MinecraftBlockTypes2["Pumpkin"] = "minecraft:pumpkin";
        MinecraftBlockTypes2["PumpkinStem"] = "minecraft:pumpkin_stem";
        MinecraftBlockTypes2["PurpleCandle"] = "minecraft:purple_candle";
        MinecraftBlockTypes2["PurpleCandleCake"] = "minecraft:purple_candle_cake";
        MinecraftBlockTypes2["PurpleCarpet"] = "minecraft:purple_carpet";
        MinecraftBlockTypes2["PurpleConcrete"] = "minecraft:purple_concrete";
        MinecraftBlockTypes2["PurpleConcretePowder"] = "minecraft:purple_concrete_powder";
        MinecraftBlockTypes2["PurpleGlazedTerracotta"] = "minecraft:purple_glazed_terracotta";
        MinecraftBlockTypes2["PurpleShulkerBox"] = "minecraft:purple_shulker_box";
        MinecraftBlockTypes2["PurpleStainedGlass"] = "minecraft:purple_stained_glass";
        MinecraftBlockTypes2["PurpleStainedGlassPane"] = "minecraft:purple_stained_glass_pane";
        MinecraftBlockTypes2["PurpleTerracotta"] = "minecraft:purple_terracotta";
        MinecraftBlockTypes2["PurpleWool"] = "minecraft:purple_wool";
        MinecraftBlockTypes2["PurpurBlock"] = "minecraft:purpur_block";
        MinecraftBlockTypes2["PurpurDoubleSlab"] = "minecraft:purpur_double_slab";
        MinecraftBlockTypes2["PurpurPillar"] = "minecraft:purpur_pillar";
        MinecraftBlockTypes2["PurpurSlab"] = "minecraft:purpur_slab";
        MinecraftBlockTypes2["PurpurStairs"] = "minecraft:purpur_stairs";
        MinecraftBlockTypes2["QuartzBlock"] = "minecraft:quartz_block";
        MinecraftBlockTypes2["QuartzBricks"] = "minecraft:quartz_bricks";
        MinecraftBlockTypes2["QuartzDoubleSlab"] = "minecraft:quartz_double_slab";
        MinecraftBlockTypes2["QuartzOre"] = "minecraft:quartz_ore";
        MinecraftBlockTypes2["QuartzPillar"] = "minecraft:quartz_pillar";
        MinecraftBlockTypes2["QuartzSlab"] = "minecraft:quartz_slab";
        MinecraftBlockTypes2["QuartzStairs"] = "minecraft:quartz_stairs";
        MinecraftBlockTypes2["Rail"] = "minecraft:rail";
        MinecraftBlockTypes2["RawCopperBlock"] = "minecraft:raw_copper_block";
        MinecraftBlockTypes2["RawGoldBlock"] = "minecraft:raw_gold_block";
        MinecraftBlockTypes2["RawIronBlock"] = "minecraft:raw_iron_block";
        MinecraftBlockTypes2["RedCandle"] = "minecraft:red_candle";
        MinecraftBlockTypes2["RedCandleCake"] = "minecraft:red_candle_cake";
        MinecraftBlockTypes2["RedCarpet"] = "minecraft:red_carpet";
        MinecraftBlockTypes2["RedConcrete"] = "minecraft:red_concrete";
        MinecraftBlockTypes2["RedConcretePowder"] = "minecraft:red_concrete_powder";
        MinecraftBlockTypes2["RedGlazedTerracotta"] = "minecraft:red_glazed_terracotta";
        MinecraftBlockTypes2["RedMushroom"] = "minecraft:red_mushroom";
        MinecraftBlockTypes2["RedMushroomBlock"] = "minecraft:red_mushroom_block";
        MinecraftBlockTypes2["RedNetherBrick"] = "minecraft:red_nether_brick";
        MinecraftBlockTypes2["RedNetherBrickDoubleSlab"] = "minecraft:red_nether_brick_double_slab";
        MinecraftBlockTypes2["RedNetherBrickSlab"] = "minecraft:red_nether_brick_slab";
        MinecraftBlockTypes2["RedNetherBrickStairs"] = "minecraft:red_nether_brick_stairs";
        MinecraftBlockTypes2["RedNetherBrickWall"] = "minecraft:red_nether_brick_wall";
        MinecraftBlockTypes2["RedSand"] = "minecraft:red_sand";
        MinecraftBlockTypes2["RedSandstone"] = "minecraft:red_sandstone";
        MinecraftBlockTypes2["RedSandstoneDoubleSlab"] = "minecraft:red_sandstone_double_slab";
        MinecraftBlockTypes2["RedSandstoneSlab"] = "minecraft:red_sandstone_slab";
        MinecraftBlockTypes2["RedSandstoneStairs"] = "minecraft:red_sandstone_stairs";
        MinecraftBlockTypes2["RedSandstoneWall"] = "minecraft:red_sandstone_wall";
        MinecraftBlockTypes2["RedShulkerBox"] = "minecraft:red_shulker_box";
        MinecraftBlockTypes2["RedStainedGlass"] = "minecraft:red_stained_glass";
        MinecraftBlockTypes2["RedStainedGlassPane"] = "minecraft:red_stained_glass_pane";
        MinecraftBlockTypes2["RedTerracotta"] = "minecraft:red_terracotta";
        MinecraftBlockTypes2["RedTulip"] = "minecraft:red_tulip";
        MinecraftBlockTypes2["RedWool"] = "minecraft:red_wool";
        MinecraftBlockTypes2["RedstoneBlock"] = "minecraft:redstone_block";
        MinecraftBlockTypes2["RedstoneLamp"] = "minecraft:redstone_lamp";
        MinecraftBlockTypes2["RedstoneOre"] = "minecraft:redstone_ore";
        MinecraftBlockTypes2["RedstoneTorch"] = "minecraft:redstone_torch";
        MinecraftBlockTypes2["RedstoneWire"] = "minecraft:redstone_wire";
        MinecraftBlockTypes2["Reeds"] = "minecraft:reeds";
        MinecraftBlockTypes2["ReinforcedDeepslate"] = "minecraft:reinforced_deepslate";
        MinecraftBlockTypes2["RepeatingCommandBlock"] = "minecraft:repeating_command_block";
        MinecraftBlockTypes2["ResinBlock"] = "minecraft:resin_block";
        MinecraftBlockTypes2["ResinBrickDoubleSlab"] = "minecraft:resin_brick_double_slab";
        MinecraftBlockTypes2["ResinBrickSlab"] = "minecraft:resin_brick_slab";
        MinecraftBlockTypes2["ResinBrickStairs"] = "minecraft:resin_brick_stairs";
        MinecraftBlockTypes2["ResinBrickWall"] = "minecraft:resin_brick_wall";
        MinecraftBlockTypes2["ResinBricks"] = "minecraft:resin_bricks";
        MinecraftBlockTypes2["ResinClump"] = "minecraft:resin_clump";
        MinecraftBlockTypes2["RespawnAnchor"] = "minecraft:respawn_anchor";
        MinecraftBlockTypes2["RoseBush"] = "minecraft:rose_bush";
        MinecraftBlockTypes2["Sand"] = "minecraft:sand";
        MinecraftBlockTypes2["Sandstone"] = "minecraft:sandstone";
        MinecraftBlockTypes2["SandstoneDoubleSlab"] = "minecraft:sandstone_double_slab";
        MinecraftBlockTypes2["SandstoneSlab"] = "minecraft:sandstone_slab";
        MinecraftBlockTypes2["SandstoneStairs"] = "minecraft:sandstone_stairs";
        MinecraftBlockTypes2["SandstoneWall"] = "minecraft:sandstone_wall";
        MinecraftBlockTypes2["Scaffolding"] = "minecraft:scaffolding";
        MinecraftBlockTypes2["Sculk"] = "minecraft:sculk";
        MinecraftBlockTypes2["SculkCatalyst"] = "minecraft:sculk_catalyst";
        MinecraftBlockTypes2["SculkSensor"] = "minecraft:sculk_sensor";
        MinecraftBlockTypes2["SculkShrieker"] = "minecraft:sculk_shrieker";
        MinecraftBlockTypes2["SculkVein"] = "minecraft:sculk_vein";
        MinecraftBlockTypes2["SeaLantern"] = "minecraft:sea_lantern";
        MinecraftBlockTypes2["SeaPickle"] = "minecraft:sea_pickle";
        MinecraftBlockTypes2["Seagrass"] = "minecraft:seagrass";
        MinecraftBlockTypes2["ShortDryGrass"] = "minecraft:short_dry_grass";
        MinecraftBlockTypes2["ShortGrass"] = "minecraft:short_grass";
        MinecraftBlockTypes2["Shroomlight"] = "minecraft:shroomlight";
        MinecraftBlockTypes2["SilverGlazedTerracotta"] = "minecraft:silver_glazed_terracotta";
        MinecraftBlockTypes2["SkeletonSkull"] = "minecraft:skeleton_skull";
        MinecraftBlockTypes2["Slime"] = "minecraft:slime";
        MinecraftBlockTypes2["SmallAmethystBud"] = "minecraft:small_amethyst_bud";
        MinecraftBlockTypes2["SmallDripleafBlock"] = "minecraft:small_dripleaf_block";
        MinecraftBlockTypes2["SmithingTable"] = "minecraft:smithing_table";
        MinecraftBlockTypes2["Smoker"] = "minecraft:smoker";
        MinecraftBlockTypes2["SmoothBasalt"] = "minecraft:smooth_basalt";
        MinecraftBlockTypes2["SmoothQuartz"] = "minecraft:smooth_quartz";
        MinecraftBlockTypes2["SmoothQuartzDoubleSlab"] = "minecraft:smooth_quartz_double_slab";
        MinecraftBlockTypes2["SmoothQuartzSlab"] = "minecraft:smooth_quartz_slab";
        MinecraftBlockTypes2["SmoothQuartzStairs"] = "minecraft:smooth_quartz_stairs";
        MinecraftBlockTypes2["SmoothRedSandstone"] = "minecraft:smooth_red_sandstone";
        MinecraftBlockTypes2["SmoothRedSandstoneDoubleSlab"] = "minecraft:smooth_red_sandstone_double_slab";
        MinecraftBlockTypes2["SmoothRedSandstoneSlab"] = "minecraft:smooth_red_sandstone_slab";
        MinecraftBlockTypes2["SmoothRedSandstoneStairs"] = "minecraft:smooth_red_sandstone_stairs";
        MinecraftBlockTypes2["SmoothSandstone"] = "minecraft:smooth_sandstone";
        MinecraftBlockTypes2["SmoothSandstoneDoubleSlab"] = "minecraft:smooth_sandstone_double_slab";
        MinecraftBlockTypes2["SmoothSandstoneSlab"] = "minecraft:smooth_sandstone_slab";
        MinecraftBlockTypes2["SmoothSandstoneStairs"] = "minecraft:smooth_sandstone_stairs";
        MinecraftBlockTypes2["SmoothStone"] = "minecraft:smooth_stone";
        MinecraftBlockTypes2["SmoothStoneDoubleSlab"] = "minecraft:smooth_stone_double_slab";
        MinecraftBlockTypes2["SmoothStoneSlab"] = "minecraft:smooth_stone_slab";
        MinecraftBlockTypes2["SnifferEgg"] = "minecraft:sniffer_egg";
        MinecraftBlockTypes2["Snow"] = "minecraft:snow";
        MinecraftBlockTypes2["SnowLayer"] = "minecraft:snow_layer";
        MinecraftBlockTypes2["SoulCampfire"] = "minecraft:soul_campfire";
        MinecraftBlockTypes2["SoulFire"] = "minecraft:soul_fire";
        MinecraftBlockTypes2["SoulLantern"] = "minecraft:soul_lantern";
        MinecraftBlockTypes2["SoulSand"] = "minecraft:soul_sand";
        MinecraftBlockTypes2["SoulSoil"] = "minecraft:soul_soil";
        MinecraftBlockTypes2["SoulTorch"] = "minecraft:soul_torch";
        MinecraftBlockTypes2["Sponge"] = "minecraft:sponge";
        MinecraftBlockTypes2["SporeBlossom"] = "minecraft:spore_blossom";
        MinecraftBlockTypes2["SpruceButton"] = "minecraft:spruce_button";
        MinecraftBlockTypes2["SpruceDoor"] = "minecraft:spruce_door";
        MinecraftBlockTypes2["SpruceDoubleSlab"] = "minecraft:spruce_double_slab";
        MinecraftBlockTypes2["SpruceFence"] = "minecraft:spruce_fence";
        MinecraftBlockTypes2["SpruceFenceGate"] = "minecraft:spruce_fence_gate";
        MinecraftBlockTypes2["SpruceHangingSign"] = "minecraft:spruce_hanging_sign";
        MinecraftBlockTypes2["SpruceLeaves"] = "minecraft:spruce_leaves";
        MinecraftBlockTypes2["SpruceLog"] = "minecraft:spruce_log";
        MinecraftBlockTypes2["SprucePlanks"] = "minecraft:spruce_planks";
        MinecraftBlockTypes2["SprucePressurePlate"] = "minecraft:spruce_pressure_plate";
        MinecraftBlockTypes2["SpruceSapling"] = "minecraft:spruce_sapling";
        MinecraftBlockTypes2["SpruceShelf"] = "minecraft:spruce_shelf";
        MinecraftBlockTypes2["SpruceSlab"] = "minecraft:spruce_slab";
        MinecraftBlockTypes2["SpruceStairs"] = "minecraft:spruce_stairs";
        MinecraftBlockTypes2["SpruceStandingSign"] = "minecraft:spruce_standing_sign";
        MinecraftBlockTypes2["SpruceTrapdoor"] = "minecraft:spruce_trapdoor";
        MinecraftBlockTypes2["SpruceWallSign"] = "minecraft:spruce_wall_sign";
        MinecraftBlockTypes2["SpruceWood"] = "minecraft:spruce_wood";
        MinecraftBlockTypes2["StandingBanner"] = "minecraft:standing_banner";
        MinecraftBlockTypes2["StandingSign"] = "minecraft:standing_sign";
        MinecraftBlockTypes2["StickyPiston"] = "minecraft:sticky_piston";
        MinecraftBlockTypes2["StickyPistonArmCollision"] = "minecraft:sticky_piston_arm_collision";
        MinecraftBlockTypes2["Stone"] = "minecraft:stone";
        MinecraftBlockTypes2["StoneBrickDoubleSlab"] = "minecraft:stone_brick_double_slab";
        MinecraftBlockTypes2["StoneBrickSlab"] = "minecraft:stone_brick_slab";
        MinecraftBlockTypes2["StoneBrickStairs"] = "minecraft:stone_brick_stairs";
        MinecraftBlockTypes2["StoneBrickWall"] = "minecraft:stone_brick_wall";
        MinecraftBlockTypes2["StoneBricks"] = "minecraft:stone_bricks";
        MinecraftBlockTypes2["StoneButton"] = "minecraft:stone_button";
        MinecraftBlockTypes2["StonePressurePlate"] = "minecraft:stone_pressure_plate";
        MinecraftBlockTypes2["StoneStairs"] = "minecraft:stone_stairs";
        MinecraftBlockTypes2["StonecutterBlock"] = "minecraft:stonecutter_block";
        MinecraftBlockTypes2["StrippedAcaciaLog"] = "minecraft:stripped_acacia_log";
        MinecraftBlockTypes2["StrippedAcaciaWood"] = "minecraft:stripped_acacia_wood";
        MinecraftBlockTypes2["StrippedBambooBlock"] = "minecraft:stripped_bamboo_block";
        MinecraftBlockTypes2["StrippedBirchLog"] = "minecraft:stripped_birch_log";
        MinecraftBlockTypes2["StrippedBirchWood"] = "minecraft:stripped_birch_wood";
        MinecraftBlockTypes2["StrippedCherryLog"] = "minecraft:stripped_cherry_log";
        MinecraftBlockTypes2["StrippedCherryWood"] = "minecraft:stripped_cherry_wood";
        MinecraftBlockTypes2["StrippedCrimsonHyphae"] = "minecraft:stripped_crimson_hyphae";
        MinecraftBlockTypes2["StrippedCrimsonStem"] = "minecraft:stripped_crimson_stem";
        MinecraftBlockTypes2["StrippedDarkOakLog"] = "minecraft:stripped_dark_oak_log";
        MinecraftBlockTypes2["StrippedDarkOakWood"] = "minecraft:stripped_dark_oak_wood";
        MinecraftBlockTypes2["StrippedJungleLog"] = "minecraft:stripped_jungle_log";
        MinecraftBlockTypes2["StrippedJungleWood"] = "minecraft:stripped_jungle_wood";
        MinecraftBlockTypes2["StrippedMangroveLog"] = "minecraft:stripped_mangrove_log";
        MinecraftBlockTypes2["StrippedMangroveWood"] = "minecraft:stripped_mangrove_wood";
        MinecraftBlockTypes2["StrippedOakLog"] = "minecraft:stripped_oak_log";
        MinecraftBlockTypes2["StrippedOakWood"] = "minecraft:stripped_oak_wood";
        MinecraftBlockTypes2["StrippedPaleOakLog"] = "minecraft:stripped_pale_oak_log";
        MinecraftBlockTypes2["StrippedPaleOakWood"] = "minecraft:stripped_pale_oak_wood";
        MinecraftBlockTypes2["StrippedSpruceLog"] = "minecraft:stripped_spruce_log";
        MinecraftBlockTypes2["StrippedSpruceWood"] = "minecraft:stripped_spruce_wood";
        MinecraftBlockTypes2["StrippedWarpedHyphae"] = "minecraft:stripped_warped_hyphae";
        MinecraftBlockTypes2["StrippedWarpedStem"] = "minecraft:stripped_warped_stem";
        MinecraftBlockTypes2["StructureBlock"] = "minecraft:structure_block";
        MinecraftBlockTypes2["StructureVoid"] = "minecraft:structure_void";
        MinecraftBlockTypes2["Sunflower"] = "minecraft:sunflower";
        MinecraftBlockTypes2["SuspiciousGravel"] = "minecraft:suspicious_gravel";
        MinecraftBlockTypes2["SuspiciousSand"] = "minecraft:suspicious_sand";
        MinecraftBlockTypes2["SweetBerryBush"] = "minecraft:sweet_berry_bush";
        MinecraftBlockTypes2["TallDryGrass"] = "minecraft:tall_dry_grass";
        MinecraftBlockTypes2["TallGrass"] = "minecraft:tall_grass";
        MinecraftBlockTypes2["Target"] = "minecraft:target";
        MinecraftBlockTypes2["TintedGlass"] = "minecraft:tinted_glass";
        MinecraftBlockTypes2["Tnt"] = "minecraft:tnt";
        MinecraftBlockTypes2["Torch"] = "minecraft:torch";
        MinecraftBlockTypes2["Torchflower"] = "minecraft:torchflower";
        MinecraftBlockTypes2["TorchflowerCrop"] = "minecraft:torchflower_crop";
        MinecraftBlockTypes2["Trapdoor"] = "minecraft:trapdoor";
        MinecraftBlockTypes2["TrappedChest"] = "minecraft:trapped_chest";
        MinecraftBlockTypes2["TrialSpawner"] = "minecraft:trial_spawner";
        MinecraftBlockTypes2["TripWire"] = "minecraft:trip_wire";
        MinecraftBlockTypes2["TripwireHook"] = "minecraft:tripwire_hook";
        MinecraftBlockTypes2["TubeCoral"] = "minecraft:tube_coral";
        MinecraftBlockTypes2["TubeCoralBlock"] = "minecraft:tube_coral_block";
        MinecraftBlockTypes2["TubeCoralFan"] = "minecraft:tube_coral_fan";
        MinecraftBlockTypes2["TubeCoralWallFan"] = "minecraft:tube_coral_wall_fan";
        MinecraftBlockTypes2["Tuff"] = "minecraft:tuff";
        MinecraftBlockTypes2["TuffBrickDoubleSlab"] = "minecraft:tuff_brick_double_slab";
        MinecraftBlockTypes2["TuffBrickSlab"] = "minecraft:tuff_brick_slab";
        MinecraftBlockTypes2["TuffBrickStairs"] = "minecraft:tuff_brick_stairs";
        MinecraftBlockTypes2["TuffBrickWall"] = "minecraft:tuff_brick_wall";
        MinecraftBlockTypes2["TuffBricks"] = "minecraft:tuff_bricks";
        MinecraftBlockTypes2["TuffDoubleSlab"] = "minecraft:tuff_double_slab";
        MinecraftBlockTypes2["TuffSlab"] = "minecraft:tuff_slab";
        MinecraftBlockTypes2["TuffStairs"] = "minecraft:tuff_stairs";
        MinecraftBlockTypes2["TuffWall"] = "minecraft:tuff_wall";
        MinecraftBlockTypes2["TurtleEgg"] = "minecraft:turtle_egg";
        MinecraftBlockTypes2["TwistingVines"] = "minecraft:twisting_vines";
        MinecraftBlockTypes2["UnderwaterTnt"] = "minecraft:underwater_tnt";
        MinecraftBlockTypes2["UnderwaterTorch"] = "minecraft:underwater_torch";
        MinecraftBlockTypes2["UndyedShulkerBox"] = "minecraft:undyed_shulker_box";
        MinecraftBlockTypes2["Unknown"] = "minecraft:unknown";
        MinecraftBlockTypes2["UnlitRedstoneTorch"] = "minecraft:unlit_redstone_torch";
        MinecraftBlockTypes2["UnpoweredComparator"] = "minecraft:unpowered_comparator";
        MinecraftBlockTypes2["UnpoweredRepeater"] = "minecraft:unpowered_repeater";
        MinecraftBlockTypes2["Vault"] = "minecraft:vault";
        MinecraftBlockTypes2["VerdantFroglight"] = "minecraft:verdant_froglight";
        MinecraftBlockTypes2["Vine"] = "minecraft:vine";
        MinecraftBlockTypes2["WallBanner"] = "minecraft:wall_banner";
        MinecraftBlockTypes2["WallSign"] = "minecraft:wall_sign";
        MinecraftBlockTypes2["WarpedButton"] = "minecraft:warped_button";
        MinecraftBlockTypes2["WarpedDoor"] = "minecraft:warped_door";
        MinecraftBlockTypes2["WarpedDoubleSlab"] = "minecraft:warped_double_slab";
        MinecraftBlockTypes2["WarpedFence"] = "minecraft:warped_fence";
        MinecraftBlockTypes2["WarpedFenceGate"] = "minecraft:warped_fence_gate";
        MinecraftBlockTypes2["WarpedFungus"] = "minecraft:warped_fungus";
        MinecraftBlockTypes2["WarpedHangingSign"] = "minecraft:warped_hanging_sign";
        MinecraftBlockTypes2["WarpedHyphae"] = "minecraft:warped_hyphae";
        MinecraftBlockTypes2["WarpedNylium"] = "minecraft:warped_nylium";
        MinecraftBlockTypes2["WarpedPlanks"] = "minecraft:warped_planks";
        MinecraftBlockTypes2["WarpedPressurePlate"] = "minecraft:warped_pressure_plate";
        MinecraftBlockTypes2["WarpedRoots"] = "minecraft:warped_roots";
        MinecraftBlockTypes2["WarpedShelf"] = "minecraft:warped_shelf";
        MinecraftBlockTypes2["WarpedSlab"] = "minecraft:warped_slab";
        MinecraftBlockTypes2["WarpedStairs"] = "minecraft:warped_stairs";
        MinecraftBlockTypes2["WarpedStandingSign"] = "minecraft:warped_standing_sign";
        MinecraftBlockTypes2["WarpedStem"] = "minecraft:warped_stem";
        MinecraftBlockTypes2["WarpedTrapdoor"] = "minecraft:warped_trapdoor";
        MinecraftBlockTypes2["WarpedWallSign"] = "minecraft:warped_wall_sign";
        MinecraftBlockTypes2["WarpedWartBlock"] = "minecraft:warped_wart_block";
        MinecraftBlockTypes2["Water"] = "minecraft:water";
        MinecraftBlockTypes2["Waterlily"] = "minecraft:waterlily";
        MinecraftBlockTypes2["WaxedChiseledCopper"] = "minecraft:waxed_chiseled_copper";
        MinecraftBlockTypes2["WaxedCopper"] = "minecraft:waxed_copper";
        MinecraftBlockTypes2["WaxedCopperBars"] = "minecraft:waxed_copper_bars";
        MinecraftBlockTypes2["WaxedCopperBulb"] = "minecraft:waxed_copper_bulb";
        MinecraftBlockTypes2["WaxedCopperChain"] = "minecraft:waxed_copper_chain";
        MinecraftBlockTypes2["WaxedCopperChest"] = "minecraft:waxed_copper_chest";
        MinecraftBlockTypes2["WaxedCopperDoor"] = "minecraft:waxed_copper_door";
        MinecraftBlockTypes2["WaxedCopperGolemStatue"] = "minecraft:waxed_copper_golem_statue";
        MinecraftBlockTypes2["WaxedCopperGrate"] = "minecraft:waxed_copper_grate";
        MinecraftBlockTypes2["WaxedCopperLantern"] = "minecraft:waxed_copper_lantern";
        MinecraftBlockTypes2["WaxedCopperTrapdoor"] = "minecraft:waxed_copper_trapdoor";
        MinecraftBlockTypes2["WaxedCutCopper"] = "minecraft:waxed_cut_copper";
        MinecraftBlockTypes2["WaxedCutCopperSlab"] = "minecraft:waxed_cut_copper_slab";
        MinecraftBlockTypes2["WaxedCutCopperStairs"] = "minecraft:waxed_cut_copper_stairs";
        MinecraftBlockTypes2["WaxedDoubleCutCopperSlab"] = "minecraft:waxed_double_cut_copper_slab";
        MinecraftBlockTypes2["WaxedExposedChiseledCopper"] = "minecraft:waxed_exposed_chiseled_copper";
        MinecraftBlockTypes2["WaxedExposedCopper"] = "minecraft:waxed_exposed_copper";
        MinecraftBlockTypes2["WaxedExposedCopperBars"] = "minecraft:waxed_exposed_copper_bars";
        MinecraftBlockTypes2["WaxedExposedCopperBulb"] = "minecraft:waxed_exposed_copper_bulb";
        MinecraftBlockTypes2["WaxedExposedCopperChain"] = "minecraft:waxed_exposed_copper_chain";
        MinecraftBlockTypes2["WaxedExposedCopperChest"] = "minecraft:waxed_exposed_copper_chest";
        MinecraftBlockTypes2["WaxedExposedCopperDoor"] = "minecraft:waxed_exposed_copper_door";
        MinecraftBlockTypes2["WaxedExposedCopperGolemStatue"] = "minecraft:waxed_exposed_copper_golem_statue";
        MinecraftBlockTypes2["WaxedExposedCopperGrate"] = "minecraft:waxed_exposed_copper_grate";
        MinecraftBlockTypes2["WaxedExposedCopperLantern"] = "minecraft:waxed_exposed_copper_lantern";
        MinecraftBlockTypes2["WaxedExposedCopperTrapdoor"] = "minecraft:waxed_exposed_copper_trapdoor";
        MinecraftBlockTypes2["WaxedExposedCutCopper"] = "minecraft:waxed_exposed_cut_copper";
        MinecraftBlockTypes2["WaxedExposedCutCopperSlab"] = "minecraft:waxed_exposed_cut_copper_slab";
        MinecraftBlockTypes2["WaxedExposedCutCopperStairs"] = "minecraft:waxed_exposed_cut_copper_stairs";
        MinecraftBlockTypes2["WaxedExposedDoubleCutCopperSlab"] = "minecraft:waxed_exposed_double_cut_copper_slab";
        MinecraftBlockTypes2["WaxedExposedLightningRod"] = "minecraft:waxed_exposed_lightning_rod";
        MinecraftBlockTypes2["WaxedLightningRod"] = "minecraft:waxed_lightning_rod";
        MinecraftBlockTypes2["WaxedOxidizedChiseledCopper"] = "minecraft:waxed_oxidized_chiseled_copper";
        MinecraftBlockTypes2["WaxedOxidizedCopper"] = "minecraft:waxed_oxidized_copper";
        MinecraftBlockTypes2["WaxedOxidizedCopperBars"] = "minecraft:waxed_oxidized_copper_bars";
        MinecraftBlockTypes2["WaxedOxidizedCopperBulb"] = "minecraft:waxed_oxidized_copper_bulb";
        MinecraftBlockTypes2["WaxedOxidizedCopperChain"] = "minecraft:waxed_oxidized_copper_chain";
        MinecraftBlockTypes2["WaxedOxidizedCopperChest"] = "minecraft:waxed_oxidized_copper_chest";
        MinecraftBlockTypes2["WaxedOxidizedCopperDoor"] = "minecraft:waxed_oxidized_copper_door";
        MinecraftBlockTypes2["WaxedOxidizedCopperGolemStatue"] = "minecraft:waxed_oxidized_copper_golem_statue";
        MinecraftBlockTypes2["WaxedOxidizedCopperGrate"] = "minecraft:waxed_oxidized_copper_grate";
        MinecraftBlockTypes2["WaxedOxidizedCopperLantern"] = "minecraft:waxed_oxidized_copper_lantern";
        MinecraftBlockTypes2["WaxedOxidizedCopperTrapdoor"] = "minecraft:waxed_oxidized_copper_trapdoor";
        MinecraftBlockTypes2["WaxedOxidizedCutCopper"] = "minecraft:waxed_oxidized_cut_copper";
        MinecraftBlockTypes2["WaxedOxidizedCutCopperSlab"] = "minecraft:waxed_oxidized_cut_copper_slab";
        MinecraftBlockTypes2["WaxedOxidizedCutCopperStairs"] = "minecraft:waxed_oxidized_cut_copper_stairs";
        MinecraftBlockTypes2["WaxedOxidizedDoubleCutCopperSlab"] = "minecraft:waxed_oxidized_double_cut_copper_slab";
        MinecraftBlockTypes2["WaxedOxidizedLightningRod"] = "minecraft:waxed_oxidized_lightning_rod";
        MinecraftBlockTypes2["WaxedWeatheredChiseledCopper"] = "minecraft:waxed_weathered_chiseled_copper";
        MinecraftBlockTypes2["WaxedWeatheredCopper"] = "minecraft:waxed_weathered_copper";
        MinecraftBlockTypes2["WaxedWeatheredCopperBars"] = "minecraft:waxed_weathered_copper_bars";
        MinecraftBlockTypes2["WaxedWeatheredCopperBulb"] = "minecraft:waxed_weathered_copper_bulb";
        MinecraftBlockTypes2["WaxedWeatheredCopperChain"] = "minecraft:waxed_weathered_copper_chain";
        MinecraftBlockTypes2["WaxedWeatheredCopperChest"] = "minecraft:waxed_weathered_copper_chest";
        MinecraftBlockTypes2["WaxedWeatheredCopperDoor"] = "minecraft:waxed_weathered_copper_door";
        MinecraftBlockTypes2["WaxedWeatheredCopperGolemStatue"] = "minecraft:waxed_weathered_copper_golem_statue";
        MinecraftBlockTypes2["WaxedWeatheredCopperGrate"] = "minecraft:waxed_weathered_copper_grate";
        MinecraftBlockTypes2["WaxedWeatheredCopperLantern"] = "minecraft:waxed_weathered_copper_lantern";
        MinecraftBlockTypes2["WaxedWeatheredCopperTrapdoor"] = "minecraft:waxed_weathered_copper_trapdoor";
        MinecraftBlockTypes2["WaxedWeatheredCutCopper"] = "minecraft:waxed_weathered_cut_copper";
        MinecraftBlockTypes2["WaxedWeatheredCutCopperSlab"] = "minecraft:waxed_weathered_cut_copper_slab";
        MinecraftBlockTypes2["WaxedWeatheredCutCopperStairs"] = "minecraft:waxed_weathered_cut_copper_stairs";
        MinecraftBlockTypes2["WaxedWeatheredDoubleCutCopperSlab"] = "minecraft:waxed_weathered_double_cut_copper_slab";
        MinecraftBlockTypes2["WaxedWeatheredLightningRod"] = "minecraft:waxed_weathered_lightning_rod";
        MinecraftBlockTypes2["WeatheredChiseledCopper"] = "minecraft:weathered_chiseled_copper";
        MinecraftBlockTypes2["WeatheredCopper"] = "minecraft:weathered_copper";
        MinecraftBlockTypes2["WeatheredCopperBars"] = "minecraft:weathered_copper_bars";
        MinecraftBlockTypes2["WeatheredCopperBulb"] = "minecraft:weathered_copper_bulb";
        MinecraftBlockTypes2["WeatheredCopperChain"] = "minecraft:weathered_copper_chain";
        MinecraftBlockTypes2["WeatheredCopperChest"] = "minecraft:weathered_copper_chest";
        MinecraftBlockTypes2["WeatheredCopperDoor"] = "minecraft:weathered_copper_door";
        MinecraftBlockTypes2["WeatheredCopperGolemStatue"] = "minecraft:weathered_copper_golem_statue";
        MinecraftBlockTypes2["WeatheredCopperGrate"] = "minecraft:weathered_copper_grate";
        MinecraftBlockTypes2["WeatheredCopperLantern"] = "minecraft:weathered_copper_lantern";
        MinecraftBlockTypes2["WeatheredCopperTrapdoor"] = "minecraft:weathered_copper_trapdoor";
        MinecraftBlockTypes2["WeatheredCutCopper"] = "minecraft:weathered_cut_copper";
        MinecraftBlockTypes2["WeatheredCutCopperSlab"] = "minecraft:weathered_cut_copper_slab";
        MinecraftBlockTypes2["WeatheredCutCopperStairs"] = "minecraft:weathered_cut_copper_stairs";
        MinecraftBlockTypes2["WeatheredDoubleCutCopperSlab"] = "minecraft:weathered_double_cut_copper_slab";
        MinecraftBlockTypes2["WeatheredLightningRod"] = "minecraft:weathered_lightning_rod";
        MinecraftBlockTypes2["Web"] = "minecraft:web";
        MinecraftBlockTypes2["WeepingVines"] = "minecraft:weeping_vines";
        MinecraftBlockTypes2["WetSponge"] = "minecraft:wet_sponge";
        MinecraftBlockTypes2["Wheat"] = "minecraft:wheat";
        MinecraftBlockTypes2["WhiteCandle"] = "minecraft:white_candle";
        MinecraftBlockTypes2["WhiteCandleCake"] = "minecraft:white_candle_cake";
        MinecraftBlockTypes2["WhiteCarpet"] = "minecraft:white_carpet";
        MinecraftBlockTypes2["WhiteConcrete"] = "minecraft:white_concrete";
        MinecraftBlockTypes2["WhiteConcretePowder"] = "minecraft:white_concrete_powder";
        MinecraftBlockTypes2["WhiteGlazedTerracotta"] = "minecraft:white_glazed_terracotta";
        MinecraftBlockTypes2["WhiteShulkerBox"] = "minecraft:white_shulker_box";
        MinecraftBlockTypes2["WhiteStainedGlass"] = "minecraft:white_stained_glass";
        MinecraftBlockTypes2["WhiteStainedGlassPane"] = "minecraft:white_stained_glass_pane";
        MinecraftBlockTypes2["WhiteTerracotta"] = "minecraft:white_terracotta";
        MinecraftBlockTypes2["WhiteTulip"] = "minecraft:white_tulip";
        MinecraftBlockTypes2["WhiteWool"] = "minecraft:white_wool";
        MinecraftBlockTypes2["Wildflowers"] = "minecraft:wildflowers";
        MinecraftBlockTypes2["WitherRose"] = "minecraft:wither_rose";
        MinecraftBlockTypes2["WitherSkeletonSkull"] = "minecraft:wither_skeleton_skull";
        MinecraftBlockTypes2["WoodenButton"] = "minecraft:wooden_button";
        MinecraftBlockTypes2["WoodenDoor"] = "minecraft:wooden_door";
        MinecraftBlockTypes2["WoodenPressurePlate"] = "minecraft:wooden_pressure_plate";
        MinecraftBlockTypes2["YellowCandle"] = "minecraft:yellow_candle";
        MinecraftBlockTypes2["YellowCandleCake"] = "minecraft:yellow_candle_cake";
        MinecraftBlockTypes2["YellowCarpet"] = "minecraft:yellow_carpet";
        MinecraftBlockTypes2["YellowConcrete"] = "minecraft:yellow_concrete";
        MinecraftBlockTypes2["YellowConcretePowder"] = "minecraft:yellow_concrete_powder";
        MinecraftBlockTypes2["YellowGlazedTerracotta"] = "minecraft:yellow_glazed_terracotta";
        MinecraftBlockTypes2["YellowShulkerBox"] = "minecraft:yellow_shulker_box";
        MinecraftBlockTypes2["YellowStainedGlass"] = "minecraft:yellow_stained_glass";
        MinecraftBlockTypes2["YellowStainedGlassPane"] = "minecraft:yellow_stained_glass_pane";
        MinecraftBlockTypes2["YellowTerracotta"] = "minecraft:yellow_terracotta";
        MinecraftBlockTypes2["YellowWool"] = "minecraft:yellow_wool";
        MinecraftBlockTypes2["ZombieHead"] = "minecraft:zombie_head";
        return MinecraftBlockTypes2;
    })(lib_vanilla_MinecraftBlockTypes || {});
    var MinecraftCameraPresetsTypes = (MinecraftCameraPresetsTypes2 => {
        MinecraftCameraPresetsTypes2["ControlSchemeCamera"] = "minecraft:control_scheme_camera";
        MinecraftCameraPresetsTypes2["FirstPerson"] = "minecraft:first_person";
        MinecraftCameraPresetsTypes2["FixedBoom"] = "minecraft:fixed_boom";
        MinecraftCameraPresetsTypes2["FollowOrbit"] = "minecraft:follow_orbit";
        MinecraftCameraPresetsTypes2["Free"] = "minecraft:free";
        MinecraftCameraPresetsTypes2["ThirdPerson"] = "minecraft:third_person";
        MinecraftCameraPresetsTypes2["ThirdPersonFront"] = "minecraft:third_person_front";
        return MinecraftCameraPresetsTypes2;
    })(MinecraftCameraPresetsTypes || {});
    var MinecraftCooldownCategoryTypes = (MinecraftCooldownCategoryTypes2 => {
        MinecraftCooldownCategoryTypes2["Chorusfruit"] = "minecraft:chorusfruit";
        MinecraftCooldownCategoryTypes2["EnderPearl"] = "minecraft:ender_pearl";
        MinecraftCooldownCategoryTypes2["GoatHorn"] = "minecraft:goat_horn";
        MinecraftCooldownCategoryTypes2["Shield"] = "minecraft:shield";
        MinecraftCooldownCategoryTypes2["WindCharge"] = "minecraft:wind_charge";
        return MinecraftCooldownCategoryTypes2;
    })(MinecraftCooldownCategoryTypes || {});
    var MinecraftDimensionTypes = (MinecraftDimensionTypes2 => {
        MinecraftDimensionTypes2["Nether"] = "minecraft:nether";
        MinecraftDimensionTypes2["Overworld"] = "minecraft:overworld";
        MinecraftDimensionTypes2["TheEnd"] = "minecraft:the_end";
        return MinecraftDimensionTypes2;
    })(MinecraftDimensionTypes || {});
    var MinecraftEffectTypes = (MinecraftEffectTypes2 => {
        MinecraftEffectTypes2["Absorption"] = "minecraft:absorption";
        MinecraftEffectTypes2["BadOmen"] = "minecraft:bad_omen";
        MinecraftEffectTypes2["Blindness"] = "minecraft:blindness";
        MinecraftEffectTypes2["ConduitPower"] = "minecraft:conduit_power";
        MinecraftEffectTypes2["Darkness"] = "minecraft:darkness";
        MinecraftEffectTypes2["FatalPoison"] = "minecraft:fatal_poison";
        MinecraftEffectTypes2["FireResistance"] = "minecraft:fire_resistance";
        MinecraftEffectTypes2["Haste"] = "minecraft:haste";
        MinecraftEffectTypes2["HealthBoost"] = "minecraft:health_boost";
        MinecraftEffectTypes2["Hunger"] = "minecraft:hunger";
        MinecraftEffectTypes2["Infested"] = "minecraft:infested";
        MinecraftEffectTypes2["InstantDamage"] = "minecraft:instant_damage";
        MinecraftEffectTypes2["InstantHealth"] = "minecraft:instant_health";
        MinecraftEffectTypes2["Invisibility"] = "minecraft:invisibility";
        MinecraftEffectTypes2["JumpBoost"] = "minecraft:jump_boost";
        MinecraftEffectTypes2["Levitation"] = "minecraft:levitation";
        MinecraftEffectTypes2["MiningFatigue"] = "minecraft:mining_fatigue";
        MinecraftEffectTypes2["Nausea"] = "minecraft:nausea";
        MinecraftEffectTypes2["NightVision"] = "minecraft:night_vision";
        MinecraftEffectTypes2["Oozing"] = "minecraft:oozing";
        MinecraftEffectTypes2["Poison"] = "minecraft:poison";
        MinecraftEffectTypes2["RaidOmen"] = "minecraft:raid_omen";
        MinecraftEffectTypes2["Regeneration"] = "minecraft:regeneration";
        MinecraftEffectTypes2["Resistance"] = "minecraft:resistance";
        MinecraftEffectTypes2["Saturation"] = "minecraft:saturation";
        MinecraftEffectTypes2["SlowFalling"] = "minecraft:slow_falling";
        MinecraftEffectTypes2["Slowness"] = "minecraft:slowness";
        MinecraftEffectTypes2["Speed"] = "minecraft:speed";
        MinecraftEffectTypes2["Strength"] = "minecraft:strength";
        MinecraftEffectTypes2["TrialOmen"] = "minecraft:trial_omen";
        MinecraftEffectTypes2["VillageHero"] = "minecraft:village_hero";
        MinecraftEffectTypes2["WaterBreathing"] = "minecraft:water_breathing";
        MinecraftEffectTypes2["Weakness"] = "minecraft:weakness";
        MinecraftEffectTypes2["Weaving"] = "minecraft:weaving";
        MinecraftEffectTypes2["WindCharged"] = "minecraft:wind_charged";
        MinecraftEffectTypes2["Wither"] = "minecraft:wither";
        return MinecraftEffectTypes2;
    })(MinecraftEffectTypes || {});
    var MinecraftEnchantmentTypes = (MinecraftEnchantmentTypes2 => {
        MinecraftEnchantmentTypes2["AquaAffinity"] = "minecraft:aqua_affinity";
        MinecraftEnchantmentTypes2["BaneOfArthropods"] = "minecraft:bane_of_arthropods";
        MinecraftEnchantmentTypes2["Binding"] = "minecraft:binding";
        MinecraftEnchantmentTypes2["BlastProtection"] = "minecraft:blast_protection";
        MinecraftEnchantmentTypes2["BowInfinity"] = "minecraft:infinity";
        MinecraftEnchantmentTypes2["Breach"] = "minecraft:breach";
        MinecraftEnchantmentTypes2["Channeling"] = "minecraft:channeling";
        MinecraftEnchantmentTypes2["Density"] = "minecraft:density";
        MinecraftEnchantmentTypes2["DepthStrider"] = "minecraft:depth_strider";
        MinecraftEnchantmentTypes2["Efficiency"] = "minecraft:efficiency";
        MinecraftEnchantmentTypes2["FeatherFalling"] = "minecraft:feather_falling";
        MinecraftEnchantmentTypes2["FireAspect"] = "minecraft:fire_aspect";
        MinecraftEnchantmentTypes2["FireProtection"] = "minecraft:fire_protection";
        MinecraftEnchantmentTypes2["Flame"] = "minecraft:flame";
        MinecraftEnchantmentTypes2["Fortune"] = "minecraft:fortune";
        MinecraftEnchantmentTypes2["FrostWalker"] = "minecraft:frost_walker";
        MinecraftEnchantmentTypes2["Impaling"] = "minecraft:impaling";
        MinecraftEnchantmentTypes2["Knockback"] = "minecraft:knockback";
        MinecraftEnchantmentTypes2["Looting"] = "minecraft:looting";
        MinecraftEnchantmentTypes2["Loyalty"] = "minecraft:loyalty";
        MinecraftEnchantmentTypes2["LuckOfTheSea"] = "minecraft:luck_of_the_sea";
        MinecraftEnchantmentTypes2["Lure"] = "minecraft:lure";
        MinecraftEnchantmentTypes2["Mending"] = "minecraft:mending";
        MinecraftEnchantmentTypes2["Multishot"] = "minecraft:multishot";
        MinecraftEnchantmentTypes2["Piercing"] = "minecraft:piercing";
        MinecraftEnchantmentTypes2["Power"] = "minecraft:power";
        MinecraftEnchantmentTypes2["ProjectileProtection"] = "minecraft:projectile_protection";
        MinecraftEnchantmentTypes2["Protection"] = "minecraft:protection";
        MinecraftEnchantmentTypes2["Punch"] = "minecraft:punch";
        MinecraftEnchantmentTypes2["QuickCharge"] = "minecraft:quick_charge";
        MinecraftEnchantmentTypes2["Respiration"] = "minecraft:respiration";
        MinecraftEnchantmentTypes2["Riptide"] = "minecraft:riptide";
        MinecraftEnchantmentTypes2["Sharpness"] = "minecraft:sharpness";
        MinecraftEnchantmentTypes2["SilkTouch"] = "minecraft:silk_touch";
        MinecraftEnchantmentTypes2["Smite"] = "minecraft:smite";
        MinecraftEnchantmentTypes2["SoulSpeed"] = "minecraft:soul_speed";
        MinecraftEnchantmentTypes2["SwiftSneak"] = "minecraft:swift_sneak";
        MinecraftEnchantmentTypes2["Thorns"] = "minecraft:thorns";
        MinecraftEnchantmentTypes2["Unbreaking"] = "minecraft:unbreaking";
        MinecraftEnchantmentTypes2["Vanishing"] = "minecraft:vanishing";
        MinecraftEnchantmentTypes2["WindBurst"] = "minecraft:wind_burst";
        return MinecraftEnchantmentTypes2;
    })(MinecraftEnchantmentTypes || {});
    var MinecraftEntityTypes = (MinecraftEntityTypes2 => {
        MinecraftEntityTypes2["Agent"] = "minecraft:agent";
        MinecraftEntityTypes2["Allay"] = "minecraft:allay";
        MinecraftEntityTypes2["AreaEffectCloud"] = "minecraft:area_effect_cloud";
        MinecraftEntityTypes2["Armadillo"] = "minecraft:armadillo";
        MinecraftEntityTypes2["ArmorStand"] = "minecraft:armor_stand";
        MinecraftEntityTypes2["Arrow"] = "minecraft:arrow";
        MinecraftEntityTypes2["Axolotl"] = "minecraft:axolotl";
        MinecraftEntityTypes2["Bat"] = "minecraft:bat";
        MinecraftEntityTypes2["Bee"] = "minecraft:bee";
        MinecraftEntityTypes2["Blaze"] = "minecraft:blaze";
        MinecraftEntityTypes2["Boat"] = "minecraft:boat";
        MinecraftEntityTypes2["Bogged"] = "minecraft:bogged";
        MinecraftEntityTypes2["Breeze"] = "minecraft:breeze";
        MinecraftEntityTypes2["BreezeWindChargeProjectile"] = "minecraft:breeze_wind_charge_projectile";
        MinecraftEntityTypes2["Camel"] = "minecraft:camel";
        MinecraftEntityTypes2["Cat"] = "minecraft:cat";
        MinecraftEntityTypes2["CaveSpider"] = "minecraft:cave_spider";
        MinecraftEntityTypes2["ChestBoat"] = "minecraft:chest_boat";
        MinecraftEntityTypes2["ChestMinecart"] = "minecraft:chest_minecart";
        MinecraftEntityTypes2["Chicken"] = "minecraft:chicken";
        MinecraftEntityTypes2["Cod"] = "minecraft:cod";
        MinecraftEntityTypes2["CommandBlockMinecart"] = "minecraft:command_block_minecart";
        MinecraftEntityTypes2["CopperGolem"] = "minecraft:copper_golem";
        MinecraftEntityTypes2["Cow"] = "minecraft:cow";
        MinecraftEntityTypes2["Creaking"] = "minecraft:creaking";
        MinecraftEntityTypes2["Creeper"] = "minecraft:creeper";
        MinecraftEntityTypes2["Dolphin"] = "minecraft:dolphin";
        MinecraftEntityTypes2["Donkey"] = "minecraft:donkey";
        MinecraftEntityTypes2["DragonFireball"] = "minecraft:dragon_fireball";
        MinecraftEntityTypes2["Drowned"] = "minecraft:drowned";
        MinecraftEntityTypes2["Egg"] = "minecraft:egg";
        MinecraftEntityTypes2["ElderGuardian"] = "minecraft:elder_guardian";
        MinecraftEntityTypes2["EnderCrystal"] = "minecraft:ender_crystal";
        MinecraftEntityTypes2["EnderDragon"] = "minecraft:ender_dragon";
        MinecraftEntityTypes2["EnderPearl"] = "minecraft:ender_pearl";
        MinecraftEntityTypes2["Enderman"] = "minecraft:enderman";
        MinecraftEntityTypes2["Endermite"] = "minecraft:endermite";
        MinecraftEntityTypes2["EvocationIllager"] = "minecraft:evocation_illager";
        MinecraftEntityTypes2["EyeOfEnderSignal"] = "minecraft:eye_of_ender_signal";
        MinecraftEntityTypes2["Fireball"] = "minecraft:fireball";
        MinecraftEntityTypes2["FireworksRocket"] = "minecraft:fireworks_rocket";
        MinecraftEntityTypes2["FishingHook"] = "minecraft:fishing_hook";
        MinecraftEntityTypes2["Fox"] = "minecraft:fox";
        MinecraftEntityTypes2["Frog"] = "minecraft:frog";
        MinecraftEntityTypes2["Ghast"] = "minecraft:ghast";
        MinecraftEntityTypes2["GlowSquid"] = "minecraft:glow_squid";
        MinecraftEntityTypes2["Goat"] = "minecraft:goat";
        MinecraftEntityTypes2["Guardian"] = "minecraft:guardian";
        MinecraftEntityTypes2["HappyGhast"] = "minecraft:happy_ghast";
        MinecraftEntityTypes2["Hoglin"] = "minecraft:hoglin";
        MinecraftEntityTypes2["HopperMinecart"] = "minecraft:hopper_minecart";
        MinecraftEntityTypes2["Horse"] = "minecraft:horse";
        MinecraftEntityTypes2["Husk"] = "minecraft:husk";
        MinecraftEntityTypes2["IronGolem"] = "minecraft:iron_golem";
        MinecraftEntityTypes2["LightningBolt"] = "minecraft:lightning_bolt";
        MinecraftEntityTypes2["LingeringPotion"] = "minecraft:lingering_potion";
        MinecraftEntityTypes2["Llama"] = "minecraft:llama";
        MinecraftEntityTypes2["LlamaSpit"] = "minecraft:llama_spit";
        MinecraftEntityTypes2["MagmaCube"] = "minecraft:magma_cube";
        MinecraftEntityTypes2["Minecart"] = "minecraft:minecart";
        MinecraftEntityTypes2["Mooshroom"] = "minecraft:mooshroom";
        MinecraftEntityTypes2["Mule"] = "minecraft:mule";
        MinecraftEntityTypes2["Npc"] = "minecraft:npc";
        MinecraftEntityTypes2["Ocelot"] = "minecraft:ocelot";
        MinecraftEntityTypes2["OminousItemSpawner"] = "minecraft:ominous_item_spawner";
        MinecraftEntityTypes2["Panda"] = "minecraft:panda";
        MinecraftEntityTypes2["Parrot"] = "minecraft:parrot";
        MinecraftEntityTypes2["Phantom"] = "minecraft:phantom";
        MinecraftEntityTypes2["Pig"] = "minecraft:pig";
        MinecraftEntityTypes2["Piglin"] = "minecraft:piglin";
        MinecraftEntityTypes2["PiglinBrute"] = "minecraft:piglin_brute";
        MinecraftEntityTypes2["Pillager"] = "minecraft:pillager";
        MinecraftEntityTypes2["Player"] = "minecraft:player";
        MinecraftEntityTypes2["PolarBear"] = "minecraft:polar_bear";
        MinecraftEntityTypes2["Pufferfish"] = "minecraft:pufferfish";
        MinecraftEntityTypes2["Rabbit"] = "minecraft:rabbit";
        MinecraftEntityTypes2["Ravager"] = "minecraft:ravager";
        MinecraftEntityTypes2["Salmon"] = "minecraft:salmon";
        MinecraftEntityTypes2["Sheep"] = "minecraft:sheep";
        MinecraftEntityTypes2["Shulker"] = "minecraft:shulker";
        MinecraftEntityTypes2["ShulkerBullet"] = "minecraft:shulker_bullet";
        MinecraftEntityTypes2["Silverfish"] = "minecraft:silverfish";
        MinecraftEntityTypes2["Skeleton"] = "minecraft:skeleton";
        MinecraftEntityTypes2["SkeletonHorse"] = "minecraft:skeleton_horse";
        MinecraftEntityTypes2["Slime"] = "minecraft:slime";
        MinecraftEntityTypes2["SmallFireball"] = "minecraft:small_fireball";
        MinecraftEntityTypes2["Sniffer"] = "minecraft:sniffer";
        MinecraftEntityTypes2["SnowGolem"] = "minecraft:snow_golem";
        MinecraftEntityTypes2["Snowball"] = "minecraft:snowball";
        MinecraftEntityTypes2["Spider"] = "minecraft:spider";
        MinecraftEntityTypes2["SplashPotion"] = "minecraft:splash_potion";
        MinecraftEntityTypes2["Squid"] = "minecraft:squid";
        MinecraftEntityTypes2["Stray"] = "minecraft:stray";
        MinecraftEntityTypes2["Strider"] = "minecraft:strider";
        MinecraftEntityTypes2["Tadpole"] = "minecraft:tadpole";
        MinecraftEntityTypes2["ThrownTrident"] = "minecraft:thrown_trident";
        MinecraftEntityTypes2["Tnt"] = "minecraft:tnt";
        MinecraftEntityTypes2["TntMinecart"] = "minecraft:tnt_minecart";
        MinecraftEntityTypes2["TraderLlama"] = "minecraft:trader_llama";
        MinecraftEntityTypes2["TripodCamera"] = "minecraft:tripod_camera";
        MinecraftEntityTypes2["Tropicalfish"] = "minecraft:tropicalfish";
        MinecraftEntityTypes2["Turtle"] = "minecraft:turtle";
        MinecraftEntityTypes2["Vex"] = "minecraft:vex";
        MinecraftEntityTypes2["Villager"] = "minecraft:villager";
        MinecraftEntityTypes2["VillagerV2"] = "minecraft:villager_v2";
        MinecraftEntityTypes2["Vindicator"] = "minecraft:vindicator";
        MinecraftEntityTypes2["WanderingTrader"] = "minecraft:wandering_trader";
        MinecraftEntityTypes2["Warden"] = "minecraft:warden";
        MinecraftEntityTypes2["WindChargeProjectile"] = "minecraft:wind_charge_projectile";
        MinecraftEntityTypes2["Witch"] = "minecraft:witch";
        MinecraftEntityTypes2["Wither"] = "minecraft:wither";
        MinecraftEntityTypes2["WitherSkeleton"] = "minecraft:wither_skeleton";
        MinecraftEntityTypes2["WitherSkull"] = "minecraft:wither_skull";
        MinecraftEntityTypes2["WitherSkullDangerous"] = "minecraft:wither_skull_dangerous";
        MinecraftEntityTypes2["Wolf"] = "minecraft:wolf";
        MinecraftEntityTypes2["XpBottle"] = "minecraft:xp_bottle";
        MinecraftEntityTypes2["XpOrb"] = "minecraft:xp_orb";
        MinecraftEntityTypes2["Zoglin"] = "minecraft:zoglin";
        MinecraftEntityTypes2["Zombie"] = "minecraft:zombie";
        MinecraftEntityTypes2["ZombieHorse"] = "minecraft:zombie_horse";
        MinecraftEntityTypes2["ZombiePigman"] = "minecraft:zombie_pigman";
        MinecraftEntityTypes2["ZombieVillager"] = "minecraft:zombie_villager";
        MinecraftEntityTypes2["ZombieVillagerV2"] = "minecraft:zombie_villager_v2";
        return MinecraftEntityTypes2;
    })(MinecraftEntityTypes || {});
    var MinecraftFeatureTypes = (MinecraftFeatureTypes2 => {
        MinecraftFeatureTypes2["AncientCity"] = "minecraft:ancient_city";
        MinecraftFeatureTypes2["BastionRemnant"] = "minecraft:bastion_remnant";
        MinecraftFeatureTypes2["BuriedTreasure"] = "minecraft:buried_treasure";
        MinecraftFeatureTypes2["EndCity"] = "minecraft:end_city";
        MinecraftFeatureTypes2["Fortress"] = "minecraft:fortress";
        MinecraftFeatureTypes2["Mansion"] = "minecraft:mansion";
        MinecraftFeatureTypes2["Mineshaft"] = "minecraft:mineshaft";
        MinecraftFeatureTypes2["Monument"] = "minecraft:monument";
        MinecraftFeatureTypes2["PillagerOutpost"] = "minecraft:pillager_outpost";
        MinecraftFeatureTypes2["RuinedPortal"] = "minecraft:ruined_portal";
        MinecraftFeatureTypes2["Ruins"] = "minecraft:ruins";
        MinecraftFeatureTypes2["Shipwreck"] = "minecraft:shipwreck";
        MinecraftFeatureTypes2["Stronghold"] = "minecraft:stronghold";
        MinecraftFeatureTypes2["Temple"] = "minecraft:temple";
        MinecraftFeatureTypes2["TrailRuins"] = "minecraft:trail_ruins";
        MinecraftFeatureTypes2["TrialChambers"] = "minecraft:trial_chambers";
        MinecraftFeatureTypes2["Village"] = "minecraft:village";
        return MinecraftFeatureTypes2;
    })(MinecraftFeatureTypes || {});
    var MinecraftItemTypes = (MinecraftItemTypes2 => {
        MinecraftItemTypes2["AcaciaBoat"] = "minecraft:acacia_boat";
        MinecraftItemTypes2["AcaciaButton"] = "minecraft:acacia_button";
        MinecraftItemTypes2["AcaciaChestBoat"] = "minecraft:acacia_chest_boat";
        MinecraftItemTypes2["AcaciaDoor"] = "minecraft:acacia_door";
        MinecraftItemTypes2["AcaciaFence"] = "minecraft:acacia_fence";
        MinecraftItemTypes2["AcaciaFenceGate"] = "minecraft:acacia_fence_gate";
        MinecraftItemTypes2["AcaciaHangingSign"] = "minecraft:acacia_hanging_sign";
        MinecraftItemTypes2["AcaciaLeaves"] = "minecraft:acacia_leaves";
        MinecraftItemTypes2["AcaciaLog"] = "minecraft:acacia_log";
        MinecraftItemTypes2["AcaciaPlanks"] = "minecraft:acacia_planks";
        MinecraftItemTypes2["AcaciaPressurePlate"] = "minecraft:acacia_pressure_plate";
        MinecraftItemTypes2["AcaciaSapling"] = "minecraft:acacia_sapling";
        MinecraftItemTypes2["AcaciaShelf"] = "minecraft:acacia_shelf";
        MinecraftItemTypes2["AcaciaSign"] = "minecraft:acacia_sign";
        MinecraftItemTypes2["AcaciaSlab"] = "minecraft:acacia_slab";
        MinecraftItemTypes2["AcaciaStairs"] = "minecraft:acacia_stairs";
        MinecraftItemTypes2["AcaciaTrapdoor"] = "minecraft:acacia_trapdoor";
        MinecraftItemTypes2["AcaciaWood"] = "minecraft:acacia_wood";
        MinecraftItemTypes2["ActivatorRail"] = "minecraft:activator_rail";
        MinecraftItemTypes2["AllaySpawnEgg"] = "minecraft:allay_spawn_egg";
        MinecraftItemTypes2["Allium"] = "minecraft:allium";
        MinecraftItemTypes2["Allow"] = "minecraft:allow";
        MinecraftItemTypes2["AmethystBlock"] = "minecraft:amethyst_block";
        MinecraftItemTypes2["AmethystCluster"] = "minecraft:amethyst_cluster";
        MinecraftItemTypes2["AmethystShard"] = "minecraft:amethyst_shard";
        MinecraftItemTypes2["AncientDebris"] = "minecraft:ancient_debris";
        MinecraftItemTypes2["Andesite"] = "minecraft:andesite";
        MinecraftItemTypes2["AndesiteSlab"] = "minecraft:andesite_slab";
        MinecraftItemTypes2["AndesiteStairs"] = "minecraft:andesite_stairs";
        MinecraftItemTypes2["AndesiteWall"] = "minecraft:andesite_wall";
        MinecraftItemTypes2["AnglerPotterySherd"] = "minecraft:angler_pottery_sherd";
        MinecraftItemTypes2["Anvil"] = "minecraft:anvil";
        MinecraftItemTypes2["Apple"] = "minecraft:apple";
        MinecraftItemTypes2["ArcherPotterySherd"] = "minecraft:archer_pottery_sherd";
        MinecraftItemTypes2["ArmadilloScute"] = "minecraft:armadillo_scute";
        MinecraftItemTypes2["ArmadilloSpawnEgg"] = "minecraft:armadillo_spawn_egg";
        MinecraftItemTypes2["ArmorStand"] = "minecraft:armor_stand";
        MinecraftItemTypes2["ArmsUpPotterySherd"] = "minecraft:arms_up_pottery_sherd";
        MinecraftItemTypes2["Arrow"] = "minecraft:arrow";
        MinecraftItemTypes2["AxolotlBucket"] = "minecraft:axolotl_bucket";
        MinecraftItemTypes2["AxolotlSpawnEgg"] = "minecraft:axolotl_spawn_egg";
        MinecraftItemTypes2["Azalea"] = "minecraft:azalea";
        MinecraftItemTypes2["AzaleaLeaves"] = "minecraft:azalea_leaves";
        MinecraftItemTypes2["AzaleaLeavesFlowered"] = "minecraft:azalea_leaves_flowered";
        MinecraftItemTypes2["AzureBluet"] = "minecraft:azure_bluet";
        MinecraftItemTypes2["BakedPotato"] = "minecraft:baked_potato";
        MinecraftItemTypes2["Bamboo"] = "minecraft:bamboo";
        MinecraftItemTypes2["BambooBlock"] = "minecraft:bamboo_block";
        MinecraftItemTypes2["BambooButton"] = "minecraft:bamboo_button";
        MinecraftItemTypes2["BambooChestRaft"] = "minecraft:bamboo_chest_raft";
        MinecraftItemTypes2["BambooDoor"] = "minecraft:bamboo_door";
        MinecraftItemTypes2["BambooFence"] = "minecraft:bamboo_fence";
        MinecraftItemTypes2["BambooFenceGate"] = "minecraft:bamboo_fence_gate";
        MinecraftItemTypes2["BambooHangingSign"] = "minecraft:bamboo_hanging_sign";
        MinecraftItemTypes2["BambooMosaic"] = "minecraft:bamboo_mosaic";
        MinecraftItemTypes2["BambooMosaicSlab"] = "minecraft:bamboo_mosaic_slab";
        MinecraftItemTypes2["BambooMosaicStairs"] = "minecraft:bamboo_mosaic_stairs";
        MinecraftItemTypes2["BambooPlanks"] = "minecraft:bamboo_planks";
        MinecraftItemTypes2["BambooPressurePlate"] = "minecraft:bamboo_pressure_plate";
        MinecraftItemTypes2["BambooRaft"] = "minecraft:bamboo_raft";
        MinecraftItemTypes2["BambooShelf"] = "minecraft:bamboo_shelf";
        MinecraftItemTypes2["BambooSign"] = "minecraft:bamboo_sign";
        MinecraftItemTypes2["BambooSlab"] = "minecraft:bamboo_slab";
        MinecraftItemTypes2["BambooStairs"] = "minecraft:bamboo_stairs";
        MinecraftItemTypes2["BambooTrapdoor"] = "minecraft:bamboo_trapdoor";
        MinecraftItemTypes2["Banner"] = "minecraft:banner";
        MinecraftItemTypes2["Barrel"] = "minecraft:barrel";
        MinecraftItemTypes2["Barrier"] = "minecraft:barrier";
        MinecraftItemTypes2["Basalt"] = "minecraft:basalt";
        MinecraftItemTypes2["BatSpawnEgg"] = "minecraft:bat_spawn_egg";
        MinecraftItemTypes2["Beacon"] = "minecraft:beacon";
        MinecraftItemTypes2["Bed"] = "minecraft:bed";
        MinecraftItemTypes2["Bedrock"] = "minecraft:bedrock";
        MinecraftItemTypes2["BeeNest"] = "minecraft:bee_nest";
        MinecraftItemTypes2["BeeSpawnEgg"] = "minecraft:bee_spawn_egg";
        MinecraftItemTypes2["Beef"] = "minecraft:beef";
        MinecraftItemTypes2["Beehive"] = "minecraft:beehive";
        MinecraftItemTypes2["Beetroot"] = "minecraft:beetroot";
        MinecraftItemTypes2["BeetrootSeeds"] = "minecraft:beetroot_seeds";
        MinecraftItemTypes2["BeetrootSoup"] = "minecraft:beetroot_soup";
        MinecraftItemTypes2["Bell"] = "minecraft:bell";
        MinecraftItemTypes2["BigDripleaf"] = "minecraft:big_dripleaf";
        MinecraftItemTypes2["BirchBoat"] = "minecraft:birch_boat";
        MinecraftItemTypes2["BirchButton"] = "minecraft:birch_button";
        MinecraftItemTypes2["BirchChestBoat"] = "minecraft:birch_chest_boat";
        MinecraftItemTypes2["BirchDoor"] = "minecraft:birch_door";
        MinecraftItemTypes2["BirchFence"] = "minecraft:birch_fence";
        MinecraftItemTypes2["BirchFenceGate"] = "minecraft:birch_fence_gate";
        MinecraftItemTypes2["BirchHangingSign"] = "minecraft:birch_hanging_sign";
        MinecraftItemTypes2["BirchLeaves"] = "minecraft:birch_leaves";
        MinecraftItemTypes2["BirchLog"] = "minecraft:birch_log";
        MinecraftItemTypes2["BirchPlanks"] = "minecraft:birch_planks";
        MinecraftItemTypes2["BirchPressurePlate"] = "minecraft:birch_pressure_plate";
        MinecraftItemTypes2["BirchSapling"] = "minecraft:birch_sapling";
        MinecraftItemTypes2["BirchShelf"] = "minecraft:birch_shelf";
        MinecraftItemTypes2["BirchSign"] = "minecraft:birch_sign";
        MinecraftItemTypes2["BirchSlab"] = "minecraft:birch_slab";
        MinecraftItemTypes2["BirchStairs"] = "minecraft:birch_stairs";
        MinecraftItemTypes2["BirchTrapdoor"] = "minecraft:birch_trapdoor";
        MinecraftItemTypes2["BirchWood"] = "minecraft:birch_wood";
        MinecraftItemTypes2["BlackBundle"] = "minecraft:black_bundle";
        MinecraftItemTypes2["BlackCandle"] = "minecraft:black_candle";
        MinecraftItemTypes2["BlackCarpet"] = "minecraft:black_carpet";
        MinecraftItemTypes2["BlackConcrete"] = "minecraft:black_concrete";
        MinecraftItemTypes2["BlackConcretePowder"] = "minecraft:black_concrete_powder";
        MinecraftItemTypes2["BlackDye"] = "minecraft:black_dye";
        MinecraftItemTypes2["BlackGlazedTerracotta"] = "minecraft:black_glazed_terracotta";
        MinecraftItemTypes2["BlackHarness"] = "minecraft:black_harness";
        MinecraftItemTypes2["BlackShulkerBox"] = "minecraft:black_shulker_box";
        MinecraftItemTypes2["BlackStainedGlass"] = "minecraft:black_stained_glass";
        MinecraftItemTypes2["BlackStainedGlassPane"] = "minecraft:black_stained_glass_pane";
        MinecraftItemTypes2["BlackTerracotta"] = "minecraft:black_terracotta";
        MinecraftItemTypes2["BlackWool"] = "minecraft:black_wool";
        MinecraftItemTypes2["Blackstone"] = "minecraft:blackstone";
        MinecraftItemTypes2["BlackstoneSlab"] = "minecraft:blackstone_slab";
        MinecraftItemTypes2["BlackstoneStairs"] = "minecraft:blackstone_stairs";
        MinecraftItemTypes2["BlackstoneWall"] = "minecraft:blackstone_wall";
        MinecraftItemTypes2["BladePotterySherd"] = "minecraft:blade_pottery_sherd";
        MinecraftItemTypes2["BlastFurnace"] = "minecraft:blast_furnace";
        MinecraftItemTypes2["BlazePowder"] = "minecraft:blaze_powder";
        MinecraftItemTypes2["BlazeRod"] = "minecraft:blaze_rod";
        MinecraftItemTypes2["BlazeSpawnEgg"] = "minecraft:blaze_spawn_egg";
        MinecraftItemTypes2["BlueBundle"] = "minecraft:blue_bundle";
        MinecraftItemTypes2["BlueCandle"] = "minecraft:blue_candle";
        MinecraftItemTypes2["BlueCarpet"] = "minecraft:blue_carpet";
        MinecraftItemTypes2["BlueConcrete"] = "minecraft:blue_concrete";
        MinecraftItemTypes2["BlueConcretePowder"] = "minecraft:blue_concrete_powder";
        MinecraftItemTypes2["BlueDye"] = "minecraft:blue_dye";
        MinecraftItemTypes2["BlueEgg"] = "minecraft:blue_egg";
        MinecraftItemTypes2["BlueGlazedTerracotta"] = "minecraft:blue_glazed_terracotta";
        MinecraftItemTypes2["BlueHarness"] = "minecraft:blue_harness";
        MinecraftItemTypes2["BlueIce"] = "minecraft:blue_ice";
        MinecraftItemTypes2["BlueOrchid"] = "minecraft:blue_orchid";
        MinecraftItemTypes2["BlueShulkerBox"] = "minecraft:blue_shulker_box";
        MinecraftItemTypes2["BlueStainedGlass"] = "minecraft:blue_stained_glass";
        MinecraftItemTypes2["BlueStainedGlassPane"] = "minecraft:blue_stained_glass_pane";
        MinecraftItemTypes2["BlueTerracotta"] = "minecraft:blue_terracotta";
        MinecraftItemTypes2["BlueWool"] = "minecraft:blue_wool";
        MinecraftItemTypes2["BoggedSpawnEgg"] = "minecraft:bogged_spawn_egg";
        MinecraftItemTypes2["BoltArmorTrimSmithingTemplate"] = "minecraft:bolt_armor_trim_smithing_template";
        MinecraftItemTypes2["Bone"] = "minecraft:bone";
        MinecraftItemTypes2["BoneBlock"] = "minecraft:bone_block";
        MinecraftItemTypes2["BoneMeal"] = "minecraft:bone_meal";
        MinecraftItemTypes2["Book"] = "minecraft:book";
        MinecraftItemTypes2["Bookshelf"] = "minecraft:bookshelf";
        MinecraftItemTypes2["BorderBlock"] = "minecraft:border_block";
        MinecraftItemTypes2["BordureIndentedBannerPattern"] = "minecraft:bordure_indented_banner_pattern";
        MinecraftItemTypes2["Bow"] = "minecraft:bow";
        MinecraftItemTypes2["Bowl"] = "minecraft:bowl";
        MinecraftItemTypes2["BrainCoral"] = "minecraft:brain_coral";
        MinecraftItemTypes2["BrainCoralBlock"] = "minecraft:brain_coral_block";
        MinecraftItemTypes2["BrainCoralFan"] = "minecraft:brain_coral_fan";
        MinecraftItemTypes2["Bread"] = "minecraft:bread";
        MinecraftItemTypes2["BreezeRod"] = "minecraft:breeze_rod";
        MinecraftItemTypes2["BreezeSpawnEgg"] = "minecraft:breeze_spawn_egg";
        MinecraftItemTypes2["BrewerPotterySherd"] = "minecraft:brewer_pottery_sherd";
        MinecraftItemTypes2["BrewingStand"] = "minecraft:brewing_stand";
        MinecraftItemTypes2["Brick"] = "minecraft:brick";
        MinecraftItemTypes2["BrickBlock"] = "minecraft:brick_block";
        MinecraftItemTypes2["BrickSlab"] = "minecraft:brick_slab";
        MinecraftItemTypes2["BrickStairs"] = "minecraft:brick_stairs";
        MinecraftItemTypes2["BrickWall"] = "minecraft:brick_wall";
        MinecraftItemTypes2["BrownBundle"] = "minecraft:brown_bundle";
        MinecraftItemTypes2["BrownCandle"] = "minecraft:brown_candle";
        MinecraftItemTypes2["BrownCarpet"] = "minecraft:brown_carpet";
        MinecraftItemTypes2["BrownConcrete"] = "minecraft:brown_concrete";
        MinecraftItemTypes2["BrownConcretePowder"] = "minecraft:brown_concrete_powder";
        MinecraftItemTypes2["BrownDye"] = "minecraft:brown_dye";
        MinecraftItemTypes2["BrownEgg"] = "minecraft:brown_egg";
        MinecraftItemTypes2["BrownGlazedTerracotta"] = "minecraft:brown_glazed_terracotta";
        MinecraftItemTypes2["BrownHarness"] = "minecraft:brown_harness";
        MinecraftItemTypes2["BrownMushroom"] = "minecraft:brown_mushroom";
        MinecraftItemTypes2["BrownMushroomBlock"] = "minecraft:brown_mushroom_block";
        MinecraftItemTypes2["BrownShulkerBox"] = "minecraft:brown_shulker_box";
        MinecraftItemTypes2["BrownStainedGlass"] = "minecraft:brown_stained_glass";
        MinecraftItemTypes2["BrownStainedGlassPane"] = "minecraft:brown_stained_glass_pane";
        MinecraftItemTypes2["BrownTerracotta"] = "minecraft:brown_terracotta";
        MinecraftItemTypes2["BrownWool"] = "minecraft:brown_wool";
        MinecraftItemTypes2["Brush"] = "minecraft:brush";
        MinecraftItemTypes2["BubbleCoral"] = "minecraft:bubble_coral";
        MinecraftItemTypes2["BubbleCoralBlock"] = "minecraft:bubble_coral_block";
        MinecraftItemTypes2["BubbleCoralFan"] = "minecraft:bubble_coral_fan";
        MinecraftItemTypes2["Bucket"] = "minecraft:bucket";
        MinecraftItemTypes2["BuddingAmethyst"] = "minecraft:budding_amethyst";
        MinecraftItemTypes2["Bundle"] = "minecraft:bundle";
        MinecraftItemTypes2["BurnPotterySherd"] = "minecraft:burn_pottery_sherd";
        MinecraftItemTypes2["Bush"] = "minecraft:bush";
        MinecraftItemTypes2["Cactus"] = "minecraft:cactus";
        MinecraftItemTypes2["CactusFlower"] = "minecraft:cactus_flower";
        MinecraftItemTypes2["Cake"] = "minecraft:cake";
        MinecraftItemTypes2["Calcite"] = "minecraft:calcite";
        MinecraftItemTypes2["CalibratedSculkSensor"] = "minecraft:calibrated_sculk_sensor";
        MinecraftItemTypes2["CamelSpawnEgg"] = "minecraft:camel_spawn_egg";
        MinecraftItemTypes2["Campfire"] = "minecraft:campfire";
        MinecraftItemTypes2["Candle"] = "minecraft:candle";
        MinecraftItemTypes2["Carrot"] = "minecraft:carrot";
        MinecraftItemTypes2["CarrotOnAStick"] = "minecraft:carrot_on_a_stick";
        MinecraftItemTypes2["CartographyTable"] = "minecraft:cartography_table";
        MinecraftItemTypes2["CarvedPumpkin"] = "minecraft:carved_pumpkin";
        MinecraftItemTypes2["CatSpawnEgg"] = "minecraft:cat_spawn_egg";
        MinecraftItemTypes2["Cauldron"] = "minecraft:cauldron";
        MinecraftItemTypes2["CaveSpiderSpawnEgg"] = "minecraft:cave_spider_spawn_egg";
        MinecraftItemTypes2["ChainCommandBlock"] = "minecraft:chain_command_block";
        MinecraftItemTypes2["ChainmailBoots"] = "minecraft:chainmail_boots";
        MinecraftItemTypes2["ChainmailChestplate"] = "minecraft:chainmail_chestplate";
        MinecraftItemTypes2["ChainmailHelmet"] = "minecraft:chainmail_helmet";
        MinecraftItemTypes2["ChainmailLeggings"] = "minecraft:chainmail_leggings";
        MinecraftItemTypes2["Charcoal"] = "minecraft:charcoal";
        MinecraftItemTypes2["CherryBoat"] = "minecraft:cherry_boat";
        MinecraftItemTypes2["CherryButton"] = "minecraft:cherry_button";
        MinecraftItemTypes2["CherryChestBoat"] = "minecraft:cherry_chest_boat";
        MinecraftItemTypes2["CherryDoor"] = "minecraft:cherry_door";
        MinecraftItemTypes2["CherryFence"] = "minecraft:cherry_fence";
        MinecraftItemTypes2["CherryFenceGate"] = "minecraft:cherry_fence_gate";
        MinecraftItemTypes2["CherryHangingSign"] = "minecraft:cherry_hanging_sign";
        MinecraftItemTypes2["CherryLeaves"] = "minecraft:cherry_leaves";
        MinecraftItemTypes2["CherryLog"] = "minecraft:cherry_log";
        MinecraftItemTypes2["CherryPlanks"] = "minecraft:cherry_planks";
        MinecraftItemTypes2["CherryPressurePlate"] = "minecraft:cherry_pressure_plate";
        MinecraftItemTypes2["CherrySapling"] = "minecraft:cherry_sapling";
        MinecraftItemTypes2["CherryShelf"] = "minecraft:cherry_shelf";
        MinecraftItemTypes2["CherrySign"] = "minecraft:cherry_sign";
        MinecraftItemTypes2["CherrySlab"] = "minecraft:cherry_slab";
        MinecraftItemTypes2["CherryStairs"] = "minecraft:cherry_stairs";
        MinecraftItemTypes2["CherryTrapdoor"] = "minecraft:cherry_trapdoor";
        MinecraftItemTypes2["CherryWood"] = "minecraft:cherry_wood";
        MinecraftItemTypes2["Chest"] = "minecraft:chest";
        MinecraftItemTypes2["ChestMinecart"] = "minecraft:chest_minecart";
        MinecraftItemTypes2["Chicken"] = "minecraft:chicken";
        MinecraftItemTypes2["ChickenSpawnEgg"] = "minecraft:chicken_spawn_egg";
        MinecraftItemTypes2["ChippedAnvil"] = "minecraft:chipped_anvil";
        MinecraftItemTypes2["ChiseledBookshelf"] = "minecraft:chiseled_bookshelf";
        MinecraftItemTypes2["ChiseledCopper"] = "minecraft:chiseled_copper";
        MinecraftItemTypes2["ChiseledDeepslate"] = "minecraft:chiseled_deepslate";
        MinecraftItemTypes2["ChiseledNetherBricks"] = "minecraft:chiseled_nether_bricks";
        MinecraftItemTypes2["ChiseledPolishedBlackstone"] = "minecraft:chiseled_polished_blackstone";
        MinecraftItemTypes2["ChiseledQuartzBlock"] = "minecraft:chiseled_quartz_block";
        MinecraftItemTypes2["ChiseledRedSandstone"] = "minecraft:chiseled_red_sandstone";
        MinecraftItemTypes2["ChiseledResinBricks"] = "minecraft:chiseled_resin_bricks";
        MinecraftItemTypes2["ChiseledSandstone"] = "minecraft:chiseled_sandstone";
        MinecraftItemTypes2["ChiseledStoneBricks"] = "minecraft:chiseled_stone_bricks";
        MinecraftItemTypes2["ChiseledTuff"] = "minecraft:chiseled_tuff";
        MinecraftItemTypes2["ChiseledTuffBricks"] = "minecraft:chiseled_tuff_bricks";
        MinecraftItemTypes2["ChorusFlower"] = "minecraft:chorus_flower";
        MinecraftItemTypes2["ChorusFruit"] = "minecraft:chorus_fruit";
        MinecraftItemTypes2["ChorusPlant"] = "minecraft:chorus_plant";
        MinecraftItemTypes2["Clay"] = "minecraft:clay";
        MinecraftItemTypes2["ClayBall"] = "minecraft:clay_ball";
        MinecraftItemTypes2["Clock"] = "minecraft:clock";
        MinecraftItemTypes2["ClosedEyeblossom"] = "minecraft:closed_eyeblossom";
        MinecraftItemTypes2["Coal"] = "minecraft:coal";
        MinecraftItemTypes2["CoalBlock"] = "minecraft:coal_block";
        MinecraftItemTypes2["CoalOre"] = "minecraft:coal_ore";
        MinecraftItemTypes2["CoarseDirt"] = "minecraft:coarse_dirt";
        MinecraftItemTypes2["CoastArmorTrimSmithingTemplate"] = "minecraft:coast_armor_trim_smithing_template";
        MinecraftItemTypes2["CobbledDeepslate"] = "minecraft:cobbled_deepslate";
        MinecraftItemTypes2["CobbledDeepslateSlab"] = "minecraft:cobbled_deepslate_slab";
        MinecraftItemTypes2["CobbledDeepslateStairs"] = "minecraft:cobbled_deepslate_stairs";
        MinecraftItemTypes2["CobbledDeepslateWall"] = "minecraft:cobbled_deepslate_wall";
        MinecraftItemTypes2["Cobblestone"] = "minecraft:cobblestone";
        MinecraftItemTypes2["CobblestoneSlab"] = "minecraft:cobblestone_slab";
        MinecraftItemTypes2["CobblestoneWall"] = "minecraft:cobblestone_wall";
        MinecraftItemTypes2["CocoaBeans"] = "minecraft:cocoa_beans";
        MinecraftItemTypes2["Cod"] = "minecraft:cod";
        MinecraftItemTypes2["CodBucket"] = "minecraft:cod_bucket";
        MinecraftItemTypes2["CodSpawnEgg"] = "minecraft:cod_spawn_egg";
        MinecraftItemTypes2["CommandBlock"] = "minecraft:command_block";
        MinecraftItemTypes2["CommandBlockMinecart"] = "minecraft:command_block_minecart";
        MinecraftItemTypes2["Comparator"] = "minecraft:comparator";
        MinecraftItemTypes2["Compass"] = "minecraft:compass";
        MinecraftItemTypes2["Composter"] = "minecraft:composter";
        MinecraftItemTypes2["Conduit"] = "minecraft:conduit";
        MinecraftItemTypes2["CookedBeef"] = "minecraft:cooked_beef";
        MinecraftItemTypes2["CookedChicken"] = "minecraft:cooked_chicken";
        MinecraftItemTypes2["CookedCod"] = "minecraft:cooked_cod";
        MinecraftItemTypes2["CookedMutton"] = "minecraft:cooked_mutton";
        MinecraftItemTypes2["CookedPorkchop"] = "minecraft:cooked_porkchop";
        MinecraftItemTypes2["CookedRabbit"] = "minecraft:cooked_rabbit";
        MinecraftItemTypes2["CookedSalmon"] = "minecraft:cooked_salmon";
        MinecraftItemTypes2["Cookie"] = "minecraft:cookie";
        MinecraftItemTypes2["CopperAxe"] = "minecraft:copper_axe";
        MinecraftItemTypes2["CopperBars"] = "minecraft:copper_bars";
        MinecraftItemTypes2["CopperBlock"] = "minecraft:copper_block";
        MinecraftItemTypes2["CopperBoots"] = "minecraft:copper_boots";
        MinecraftItemTypes2["CopperBulb"] = "minecraft:copper_bulb";
        MinecraftItemTypes2["CopperChain"] = "minecraft:copper_chain";
        MinecraftItemTypes2["CopperChest"] = "minecraft:copper_chest";
        MinecraftItemTypes2["CopperChestplate"] = "minecraft:copper_chestplate";
        MinecraftItemTypes2["CopperDoor"] = "minecraft:copper_door";
        MinecraftItemTypes2["CopperGolemSpawnEgg"] = "minecraft:copper_golem_spawn_egg";
        MinecraftItemTypes2["CopperGolemStatue"] = "minecraft:copper_golem_statue";
        MinecraftItemTypes2["CopperGrate"] = "minecraft:copper_grate";
        MinecraftItemTypes2["CopperHelmet"] = "minecraft:copper_helmet";
        MinecraftItemTypes2["CopperHoe"] = "minecraft:copper_hoe";
        MinecraftItemTypes2["CopperHorseArmor"] = "minecraft:copper_horse_armor";
        MinecraftItemTypes2["CopperIngot"] = "minecraft:copper_ingot";
        MinecraftItemTypes2["CopperLantern"] = "minecraft:copper_lantern";
        MinecraftItemTypes2["CopperLeggings"] = "minecraft:copper_leggings";
        MinecraftItemTypes2["CopperNugget"] = "minecraft:copper_nugget";
        MinecraftItemTypes2["CopperOre"] = "minecraft:copper_ore";
        MinecraftItemTypes2["CopperPickaxe"] = "minecraft:copper_pickaxe";
        MinecraftItemTypes2["CopperShovel"] = "minecraft:copper_shovel";
        MinecraftItemTypes2["CopperSword"] = "minecraft:copper_sword";
        MinecraftItemTypes2["CopperTorch"] = "minecraft:copper_torch";
        MinecraftItemTypes2["CopperTrapdoor"] = "minecraft:copper_trapdoor";
        MinecraftItemTypes2["Cornflower"] = "minecraft:cornflower";
        MinecraftItemTypes2["CowSpawnEgg"] = "minecraft:cow_spawn_egg";
        MinecraftItemTypes2["CrackedDeepslateBricks"] = "minecraft:cracked_deepslate_bricks";
        MinecraftItemTypes2["CrackedDeepslateTiles"] = "minecraft:cracked_deepslate_tiles";
        MinecraftItemTypes2["CrackedNetherBricks"] = "minecraft:cracked_nether_bricks";
        MinecraftItemTypes2["CrackedPolishedBlackstoneBricks"] = "minecraft:cracked_polished_blackstone_bricks";
        MinecraftItemTypes2["CrackedStoneBricks"] = "minecraft:cracked_stone_bricks";
        MinecraftItemTypes2["Crafter"] = "minecraft:crafter";
        MinecraftItemTypes2["CraftingTable"] = "minecraft:crafting_table";
        MinecraftItemTypes2["CreakingHeart"] = "minecraft:creaking_heart";
        MinecraftItemTypes2["CreakingSpawnEgg"] = "minecraft:creaking_spawn_egg";
        MinecraftItemTypes2["CreeperBannerPattern"] = "minecraft:creeper_banner_pattern";
        MinecraftItemTypes2["CreeperHead"] = "minecraft:creeper_head";
        MinecraftItemTypes2["CreeperSpawnEgg"] = "minecraft:creeper_spawn_egg";
        MinecraftItemTypes2["CrimsonButton"] = "minecraft:crimson_button";
        MinecraftItemTypes2["CrimsonDoor"] = "minecraft:crimson_door";
        MinecraftItemTypes2["CrimsonFence"] = "minecraft:crimson_fence";
        MinecraftItemTypes2["CrimsonFenceGate"] = "minecraft:crimson_fence_gate";
        MinecraftItemTypes2["CrimsonFungus"] = "minecraft:crimson_fungus";
        MinecraftItemTypes2["CrimsonHangingSign"] = "minecraft:crimson_hanging_sign";
        MinecraftItemTypes2["CrimsonHyphae"] = "minecraft:crimson_hyphae";
        MinecraftItemTypes2["CrimsonNylium"] = "minecraft:crimson_nylium";
        MinecraftItemTypes2["CrimsonPlanks"] = "minecraft:crimson_planks";
        MinecraftItemTypes2["CrimsonPressurePlate"] = "minecraft:crimson_pressure_plate";
        MinecraftItemTypes2["CrimsonRoots"] = "minecraft:crimson_roots";
        MinecraftItemTypes2["CrimsonShelf"] = "minecraft:crimson_shelf";
        MinecraftItemTypes2["CrimsonSign"] = "minecraft:crimson_sign";
        MinecraftItemTypes2["CrimsonSlab"] = "minecraft:crimson_slab";
        MinecraftItemTypes2["CrimsonStairs"] = "minecraft:crimson_stairs";
        MinecraftItemTypes2["CrimsonStem"] = "minecraft:crimson_stem";
        MinecraftItemTypes2["CrimsonTrapdoor"] = "minecraft:crimson_trapdoor";
        MinecraftItemTypes2["Crossbow"] = "minecraft:crossbow";
        MinecraftItemTypes2["CryingObsidian"] = "minecraft:crying_obsidian";
        MinecraftItemTypes2["CutCopper"] = "minecraft:cut_copper";
        MinecraftItemTypes2["CutCopperSlab"] = "minecraft:cut_copper_slab";
        MinecraftItemTypes2["CutCopperStairs"] = "minecraft:cut_copper_stairs";
        MinecraftItemTypes2["CutRedSandstone"] = "minecraft:cut_red_sandstone";
        MinecraftItemTypes2["CutRedSandstoneSlab"] = "minecraft:cut_red_sandstone_slab";
        MinecraftItemTypes2["CutSandstone"] = "minecraft:cut_sandstone";
        MinecraftItemTypes2["CutSandstoneSlab"] = "minecraft:cut_sandstone_slab";
        MinecraftItemTypes2["CyanBundle"] = "minecraft:cyan_bundle";
        MinecraftItemTypes2["CyanCandle"] = "minecraft:cyan_candle";
        MinecraftItemTypes2["CyanCarpet"] = "minecraft:cyan_carpet";
        MinecraftItemTypes2["CyanConcrete"] = "minecraft:cyan_concrete";
        MinecraftItemTypes2["CyanConcretePowder"] = "minecraft:cyan_concrete_powder";
        MinecraftItemTypes2["CyanDye"] = "minecraft:cyan_dye";
        MinecraftItemTypes2["CyanGlazedTerracotta"] = "minecraft:cyan_glazed_terracotta";
        MinecraftItemTypes2["CyanHarness"] = "minecraft:cyan_harness";
        MinecraftItemTypes2["CyanShulkerBox"] = "minecraft:cyan_shulker_box";
        MinecraftItemTypes2["CyanStainedGlass"] = "minecraft:cyan_stained_glass";
        MinecraftItemTypes2["CyanStainedGlassPane"] = "minecraft:cyan_stained_glass_pane";
        MinecraftItemTypes2["CyanTerracotta"] = "minecraft:cyan_terracotta";
        MinecraftItemTypes2["CyanWool"] = "minecraft:cyan_wool";
        MinecraftItemTypes2["DamagedAnvil"] = "minecraft:damaged_anvil";
        MinecraftItemTypes2["Dandelion"] = "minecraft:dandelion";
        MinecraftItemTypes2["DangerPotterySherd"] = "minecraft:danger_pottery_sherd";
        MinecraftItemTypes2["DarkOakBoat"] = "minecraft:dark_oak_boat";
        MinecraftItemTypes2["DarkOakButton"] = "minecraft:dark_oak_button";
        MinecraftItemTypes2["DarkOakChestBoat"] = "minecraft:dark_oak_chest_boat";
        MinecraftItemTypes2["DarkOakDoor"] = "minecraft:dark_oak_door";
        MinecraftItemTypes2["DarkOakFence"] = "minecraft:dark_oak_fence";
        MinecraftItemTypes2["DarkOakFenceGate"] = "minecraft:dark_oak_fence_gate";
        MinecraftItemTypes2["DarkOakHangingSign"] = "minecraft:dark_oak_hanging_sign";
        MinecraftItemTypes2["DarkOakLeaves"] = "minecraft:dark_oak_leaves";
        MinecraftItemTypes2["DarkOakLog"] = "minecraft:dark_oak_log";
        MinecraftItemTypes2["DarkOakPlanks"] = "minecraft:dark_oak_planks";
        MinecraftItemTypes2["DarkOakPressurePlate"] = "minecraft:dark_oak_pressure_plate";
        MinecraftItemTypes2["DarkOakSapling"] = "minecraft:dark_oak_sapling";
        MinecraftItemTypes2["DarkOakShelf"] = "minecraft:dark_oak_shelf";
        MinecraftItemTypes2["DarkOakSign"] = "minecraft:dark_oak_sign";
        MinecraftItemTypes2["DarkOakSlab"] = "minecraft:dark_oak_slab";
        MinecraftItemTypes2["DarkOakStairs"] = "minecraft:dark_oak_stairs";
        MinecraftItemTypes2["DarkOakTrapdoor"] = "minecraft:dark_oak_trapdoor";
        MinecraftItemTypes2["DarkOakWood"] = "minecraft:dark_oak_wood";
        MinecraftItemTypes2["DarkPrismarine"] = "minecraft:dark_prismarine";
        MinecraftItemTypes2["DarkPrismarineSlab"] = "minecraft:dark_prismarine_slab";
        MinecraftItemTypes2["DarkPrismarineStairs"] = "minecraft:dark_prismarine_stairs";
        MinecraftItemTypes2["DaylightDetector"] = "minecraft:daylight_detector";
        MinecraftItemTypes2["DeadBrainCoral"] = "minecraft:dead_brain_coral";
        MinecraftItemTypes2["DeadBrainCoralBlock"] = "minecraft:dead_brain_coral_block";
        MinecraftItemTypes2["DeadBrainCoralFan"] = "minecraft:dead_brain_coral_fan";
        MinecraftItemTypes2["DeadBubbleCoral"] = "minecraft:dead_bubble_coral";
        MinecraftItemTypes2["DeadBubbleCoralBlock"] = "minecraft:dead_bubble_coral_block";
        MinecraftItemTypes2["DeadBubbleCoralFan"] = "minecraft:dead_bubble_coral_fan";
        MinecraftItemTypes2["DeadFireCoral"] = "minecraft:dead_fire_coral";
        MinecraftItemTypes2["DeadFireCoralBlock"] = "minecraft:dead_fire_coral_block";
        MinecraftItemTypes2["DeadFireCoralFan"] = "minecraft:dead_fire_coral_fan";
        MinecraftItemTypes2["DeadHornCoral"] = "minecraft:dead_horn_coral";
        MinecraftItemTypes2["DeadHornCoralBlock"] = "minecraft:dead_horn_coral_block";
        MinecraftItemTypes2["DeadHornCoralFan"] = "minecraft:dead_horn_coral_fan";
        MinecraftItemTypes2["DeadTubeCoral"] = "minecraft:dead_tube_coral";
        MinecraftItemTypes2["DeadTubeCoralBlock"] = "minecraft:dead_tube_coral_block";
        MinecraftItemTypes2["DeadTubeCoralFan"] = "minecraft:dead_tube_coral_fan";
        MinecraftItemTypes2["Deadbush"] = "minecraft:deadbush";
        MinecraftItemTypes2["DebugStick"] = "minecraft:debug_stick";
        MinecraftItemTypes2["DecoratedPot"] = "minecraft:decorated_pot";
        MinecraftItemTypes2["Deepslate"] = "minecraft:deepslate";
        MinecraftItemTypes2["DeepslateBrickSlab"] = "minecraft:deepslate_brick_slab";
        MinecraftItemTypes2["DeepslateBrickStairs"] = "minecraft:deepslate_brick_stairs";
        MinecraftItemTypes2["DeepslateBrickWall"] = "minecraft:deepslate_brick_wall";
        MinecraftItemTypes2["DeepslateBricks"] = "minecraft:deepslate_bricks";
        MinecraftItemTypes2["DeepslateCoalOre"] = "minecraft:deepslate_coal_ore";
        MinecraftItemTypes2["DeepslateCopperOre"] = "minecraft:deepslate_copper_ore";
        MinecraftItemTypes2["DeepslateDiamondOre"] = "minecraft:deepslate_diamond_ore";
        MinecraftItemTypes2["DeepslateEmeraldOre"] = "minecraft:deepslate_emerald_ore";
        MinecraftItemTypes2["DeepslateGoldOre"] = "minecraft:deepslate_gold_ore";
        MinecraftItemTypes2["DeepslateIronOre"] = "minecraft:deepslate_iron_ore";
        MinecraftItemTypes2["DeepslateLapisOre"] = "minecraft:deepslate_lapis_ore";
        MinecraftItemTypes2["DeepslateRedstoneOre"] = "minecraft:deepslate_redstone_ore";
        MinecraftItemTypes2["DeepslateTileSlab"] = "minecraft:deepslate_tile_slab";
        MinecraftItemTypes2["DeepslateTileStairs"] = "minecraft:deepslate_tile_stairs";
        MinecraftItemTypes2["DeepslateTileWall"] = "minecraft:deepslate_tile_wall";
        MinecraftItemTypes2["DeepslateTiles"] = "minecraft:deepslate_tiles";
        MinecraftItemTypes2["Deny"] = "minecraft:deny";
        MinecraftItemTypes2["DetectorRail"] = "minecraft:detector_rail";
        MinecraftItemTypes2["Diamond"] = "minecraft:diamond";
        MinecraftItemTypes2["DiamondAxe"] = "minecraft:diamond_axe";
        MinecraftItemTypes2["DiamondBlock"] = "minecraft:diamond_block";
        MinecraftItemTypes2["DiamondBoots"] = "minecraft:diamond_boots";
        MinecraftItemTypes2["DiamondChestplate"] = "minecraft:diamond_chestplate";
        MinecraftItemTypes2["DiamondHelmet"] = "minecraft:diamond_helmet";
        MinecraftItemTypes2["DiamondHoe"] = "minecraft:diamond_hoe";
        MinecraftItemTypes2["DiamondHorseArmor"] = "minecraft:diamond_horse_armor";
        MinecraftItemTypes2["DiamondLeggings"] = "minecraft:diamond_leggings";
        MinecraftItemTypes2["DiamondOre"] = "minecraft:diamond_ore";
        MinecraftItemTypes2["DiamondPickaxe"] = "minecraft:diamond_pickaxe";
        MinecraftItemTypes2["DiamondShovel"] = "minecraft:diamond_shovel";
        MinecraftItemTypes2["DiamondSword"] = "minecraft:diamond_sword";
        MinecraftItemTypes2["Diorite"] = "minecraft:diorite";
        MinecraftItemTypes2["DioriteSlab"] = "minecraft:diorite_slab";
        MinecraftItemTypes2["DioriteStairs"] = "minecraft:diorite_stairs";
        MinecraftItemTypes2["DioriteWall"] = "minecraft:diorite_wall";
        MinecraftItemTypes2["Dirt"] = "minecraft:dirt";
        MinecraftItemTypes2["DirtWithRoots"] = "minecraft:dirt_with_roots";
        MinecraftItemTypes2["DiscFragment5"] = "minecraft:disc_fragment_5";
        MinecraftItemTypes2["Dispenser"] = "minecraft:dispenser";
        MinecraftItemTypes2["DolphinSpawnEgg"] = "minecraft:dolphin_spawn_egg";
        MinecraftItemTypes2["DonkeySpawnEgg"] = "minecraft:donkey_spawn_egg";
        MinecraftItemTypes2["DragonBreath"] = "minecraft:dragon_breath";
        MinecraftItemTypes2["DragonEgg"] = "minecraft:dragon_egg";
        MinecraftItemTypes2["DragonHead"] = "minecraft:dragon_head";
        MinecraftItemTypes2["DriedGhast"] = "minecraft:dried_ghast";
        MinecraftItemTypes2["DriedKelp"] = "minecraft:dried_kelp";
        MinecraftItemTypes2["DriedKelpBlock"] = "minecraft:dried_kelp_block";
        MinecraftItemTypes2["DripstoneBlock"] = "minecraft:dripstone_block";
        MinecraftItemTypes2["Dropper"] = "minecraft:dropper";
        MinecraftItemTypes2["DrownedSpawnEgg"] = "minecraft:drowned_spawn_egg";
        MinecraftItemTypes2["DuneArmorTrimSmithingTemplate"] = "minecraft:dune_armor_trim_smithing_template";
        MinecraftItemTypes2["EchoShard"] = "minecraft:echo_shard";
        MinecraftItemTypes2["Egg"] = "minecraft:egg";
        MinecraftItemTypes2["ElderGuardianSpawnEgg"] = "minecraft:elder_guardian_spawn_egg";
        MinecraftItemTypes2["Elytra"] = "minecraft:elytra";
        MinecraftItemTypes2["Emerald"] = "minecraft:emerald";
        MinecraftItemTypes2["EmeraldBlock"] = "minecraft:emerald_block";
        MinecraftItemTypes2["EmeraldOre"] = "minecraft:emerald_ore";
        MinecraftItemTypes2["EmptyMap"] = "minecraft:empty_map";
        MinecraftItemTypes2["EnchantedBook"] = "minecraft:enchanted_book";
        MinecraftItemTypes2["EnchantedGoldenApple"] = "minecraft:enchanted_golden_apple";
        MinecraftItemTypes2["EnchantingTable"] = "minecraft:enchanting_table";
        MinecraftItemTypes2["EndBrickStairs"] = "minecraft:end_brick_stairs";
        MinecraftItemTypes2["EndBricks"] = "minecraft:end_bricks";
        MinecraftItemTypes2["EndCrystal"] = "minecraft:end_crystal";
        MinecraftItemTypes2["EndPortalFrame"] = "minecraft:end_portal_frame";
        MinecraftItemTypes2["EndRod"] = "minecraft:end_rod";
        MinecraftItemTypes2["EndStone"] = "minecraft:end_stone";
        MinecraftItemTypes2["EndStoneBrickSlab"] = "minecraft:end_stone_brick_slab";
        MinecraftItemTypes2["EndStoneBrickWall"] = "minecraft:end_stone_brick_wall";
        MinecraftItemTypes2["EnderChest"] = "minecraft:ender_chest";
        MinecraftItemTypes2["EnderDragonSpawnEgg"] = "minecraft:ender_dragon_spawn_egg";
        MinecraftItemTypes2["EnderEye"] = "minecraft:ender_eye";
        MinecraftItemTypes2["EnderPearl"] = "minecraft:ender_pearl";
        MinecraftItemTypes2["EndermanSpawnEgg"] = "minecraft:enderman_spawn_egg";
        MinecraftItemTypes2["EndermiteSpawnEgg"] = "minecraft:endermite_spawn_egg";
        MinecraftItemTypes2["EvokerSpawnEgg"] = "minecraft:evoker_spawn_egg";
        MinecraftItemTypes2["ExperienceBottle"] = "minecraft:experience_bottle";
        MinecraftItemTypes2["ExplorerPotterySherd"] = "minecraft:explorer_pottery_sherd";
        MinecraftItemTypes2["ExposedChiseledCopper"] = "minecraft:exposed_chiseled_copper";
        MinecraftItemTypes2["ExposedCopper"] = "minecraft:exposed_copper";
        MinecraftItemTypes2["ExposedCopperBars"] = "minecraft:exposed_copper_bars";
        MinecraftItemTypes2["ExposedCopperBulb"] = "minecraft:exposed_copper_bulb";
        MinecraftItemTypes2["ExposedCopperChain"] = "minecraft:exposed_copper_chain";
        MinecraftItemTypes2["ExposedCopperChest"] = "minecraft:exposed_copper_chest";
        MinecraftItemTypes2["ExposedCopperDoor"] = "minecraft:exposed_copper_door";
        MinecraftItemTypes2["ExposedCopperGolemStatue"] = "minecraft:exposed_copper_golem_statue";
        MinecraftItemTypes2["ExposedCopperGrate"] = "minecraft:exposed_copper_grate";
        MinecraftItemTypes2["ExposedCopperLantern"] = "minecraft:exposed_copper_lantern";
        MinecraftItemTypes2["ExposedCopperTrapdoor"] = "minecraft:exposed_copper_trapdoor";
        MinecraftItemTypes2["ExposedCutCopper"] = "minecraft:exposed_cut_copper";
        MinecraftItemTypes2["ExposedCutCopperSlab"] = "minecraft:exposed_cut_copper_slab";
        MinecraftItemTypes2["ExposedCutCopperStairs"] = "minecraft:exposed_cut_copper_stairs";
        MinecraftItemTypes2["ExposedLightningRod"] = "minecraft:exposed_lightning_rod";
        MinecraftItemTypes2["EyeArmorTrimSmithingTemplate"] = "minecraft:eye_armor_trim_smithing_template";
        MinecraftItemTypes2["Farmland"] = "minecraft:farmland";
        MinecraftItemTypes2["Feather"] = "minecraft:feather";
        MinecraftItemTypes2["FenceGate"] = "minecraft:fence_gate";
        MinecraftItemTypes2["FermentedSpiderEye"] = "minecraft:fermented_spider_eye";
        MinecraftItemTypes2["Fern"] = "minecraft:fern";
        MinecraftItemTypes2["FieldMasonedBannerPattern"] = "minecraft:field_masoned_banner_pattern";
        MinecraftItemTypes2["FilledMap"] = "minecraft:filled_map";
        MinecraftItemTypes2["FireCharge"] = "minecraft:fire_charge";
        MinecraftItemTypes2["FireCoral"] = "minecraft:fire_coral";
        MinecraftItemTypes2["FireCoralBlock"] = "minecraft:fire_coral_block";
        MinecraftItemTypes2["FireCoralFan"] = "minecraft:fire_coral_fan";
        MinecraftItemTypes2["FireflyBush"] = "minecraft:firefly_bush";
        MinecraftItemTypes2["FireworkRocket"] = "minecraft:firework_rocket";
        MinecraftItemTypes2["FireworkStar"] = "minecraft:firework_star";
        MinecraftItemTypes2["FishingRod"] = "minecraft:fishing_rod";
        MinecraftItemTypes2["FletchingTable"] = "minecraft:fletching_table";
        MinecraftItemTypes2["Flint"] = "minecraft:flint";
        MinecraftItemTypes2["FlintAndSteel"] = "minecraft:flint_and_steel";
        MinecraftItemTypes2["FlowArmorTrimSmithingTemplate"] = "minecraft:flow_armor_trim_smithing_template";
        MinecraftItemTypes2["FlowBannerPattern"] = "minecraft:flow_banner_pattern";
        MinecraftItemTypes2["FlowPotterySherd"] = "minecraft:flow_pottery_sherd";
        MinecraftItemTypes2["FlowerBannerPattern"] = "minecraft:flower_banner_pattern";
        MinecraftItemTypes2["FlowerPot"] = "minecraft:flower_pot";
        MinecraftItemTypes2["FloweringAzalea"] = "minecraft:flowering_azalea";
        MinecraftItemTypes2["FoxSpawnEgg"] = "minecraft:fox_spawn_egg";
        MinecraftItemTypes2["Frame"] = "minecraft:frame";
        MinecraftItemTypes2["FriendPotterySherd"] = "minecraft:friend_pottery_sherd";
        MinecraftItemTypes2["FrogSpawn"] = "minecraft:frog_spawn";
        MinecraftItemTypes2["FrogSpawnEgg"] = "minecraft:frog_spawn_egg";
        MinecraftItemTypes2["FrostedIce"] = "minecraft:frosted_ice";
        MinecraftItemTypes2["Furnace"] = "minecraft:furnace";
        MinecraftItemTypes2["GhastSpawnEgg"] = "minecraft:ghast_spawn_egg";
        MinecraftItemTypes2["GhastTear"] = "minecraft:ghast_tear";
        MinecraftItemTypes2["GildedBlackstone"] = "minecraft:gilded_blackstone";
        MinecraftItemTypes2["Glass"] = "minecraft:glass";
        MinecraftItemTypes2["GlassBottle"] = "minecraft:glass_bottle";
        MinecraftItemTypes2["GlassPane"] = "minecraft:glass_pane";
        MinecraftItemTypes2["GlisteringMelonSlice"] = "minecraft:glistering_melon_slice";
        MinecraftItemTypes2["GlobeBannerPattern"] = "minecraft:globe_banner_pattern";
        MinecraftItemTypes2["GlowBerries"] = "minecraft:glow_berries";
        MinecraftItemTypes2["GlowFrame"] = "minecraft:glow_frame";
        MinecraftItemTypes2["GlowInkSac"] = "minecraft:glow_ink_sac";
        MinecraftItemTypes2["GlowLichen"] = "minecraft:glow_lichen";
        MinecraftItemTypes2["GlowSquidSpawnEgg"] = "minecraft:glow_squid_spawn_egg";
        MinecraftItemTypes2["Glowstone"] = "minecraft:glowstone";
        MinecraftItemTypes2["GlowstoneDust"] = "minecraft:glowstone_dust";
        MinecraftItemTypes2["GoatHorn"] = "minecraft:goat_horn";
        MinecraftItemTypes2["GoatSpawnEgg"] = "minecraft:goat_spawn_egg";
        MinecraftItemTypes2["GoldBlock"] = "minecraft:gold_block";
        MinecraftItemTypes2["GoldIngot"] = "minecraft:gold_ingot";
        MinecraftItemTypes2["GoldNugget"] = "minecraft:gold_nugget";
        MinecraftItemTypes2["GoldOre"] = "minecraft:gold_ore";
        MinecraftItemTypes2["GoldenApple"] = "minecraft:golden_apple";
        MinecraftItemTypes2["GoldenAxe"] = "minecraft:golden_axe";
        MinecraftItemTypes2["GoldenBoots"] = "minecraft:golden_boots";
        MinecraftItemTypes2["GoldenCarrot"] = "minecraft:golden_carrot";
        MinecraftItemTypes2["GoldenChestplate"] = "minecraft:golden_chestplate";
        MinecraftItemTypes2["GoldenHelmet"] = "minecraft:golden_helmet";
        MinecraftItemTypes2["GoldenHoe"] = "minecraft:golden_hoe";
        MinecraftItemTypes2["GoldenHorseArmor"] = "minecraft:golden_horse_armor";
        MinecraftItemTypes2["GoldenLeggings"] = "minecraft:golden_leggings";
        MinecraftItemTypes2["GoldenPickaxe"] = "minecraft:golden_pickaxe";
        MinecraftItemTypes2["GoldenRail"] = "minecraft:golden_rail";
        MinecraftItemTypes2["GoldenShovel"] = "minecraft:golden_shovel";
        MinecraftItemTypes2["GoldenSword"] = "minecraft:golden_sword";
        MinecraftItemTypes2["Granite"] = "minecraft:granite";
        MinecraftItemTypes2["GraniteSlab"] = "minecraft:granite_slab";
        MinecraftItemTypes2["GraniteStairs"] = "minecraft:granite_stairs";
        MinecraftItemTypes2["GraniteWall"] = "minecraft:granite_wall";
        MinecraftItemTypes2["GrassBlock"] = "minecraft:grass_block";
        MinecraftItemTypes2["GrassPath"] = "minecraft:grass_path";
        MinecraftItemTypes2["Gravel"] = "minecraft:gravel";
        MinecraftItemTypes2["GrayBundle"] = "minecraft:gray_bundle";
        MinecraftItemTypes2["GrayCandle"] = "minecraft:gray_candle";
        MinecraftItemTypes2["GrayCarpet"] = "minecraft:gray_carpet";
        MinecraftItemTypes2["GrayConcrete"] = "minecraft:gray_concrete";
        MinecraftItemTypes2["GrayConcretePowder"] = "minecraft:gray_concrete_powder";
        MinecraftItemTypes2["GrayDye"] = "minecraft:gray_dye";
        MinecraftItemTypes2["GrayGlazedTerracotta"] = "minecraft:gray_glazed_terracotta";
        MinecraftItemTypes2["GrayHarness"] = "minecraft:gray_harness";
        MinecraftItemTypes2["GrayShulkerBox"] = "minecraft:gray_shulker_box";
        MinecraftItemTypes2["GrayStainedGlass"] = "minecraft:gray_stained_glass";
        MinecraftItemTypes2["GrayStainedGlassPane"] = "minecraft:gray_stained_glass_pane";
        MinecraftItemTypes2["GrayTerracotta"] = "minecraft:gray_terracotta";
        MinecraftItemTypes2["GrayWool"] = "minecraft:gray_wool";
        MinecraftItemTypes2["GreenBundle"] = "minecraft:green_bundle";
        MinecraftItemTypes2["GreenCandle"] = "minecraft:green_candle";
        MinecraftItemTypes2["GreenCarpet"] = "minecraft:green_carpet";
        MinecraftItemTypes2["GreenConcrete"] = "minecraft:green_concrete";
        MinecraftItemTypes2["GreenConcretePowder"] = "minecraft:green_concrete_powder";
        MinecraftItemTypes2["GreenDye"] = "minecraft:green_dye";
        MinecraftItemTypes2["GreenGlazedTerracotta"] = "minecraft:green_glazed_terracotta";
        MinecraftItemTypes2["GreenHarness"] = "minecraft:green_harness";
        MinecraftItemTypes2["GreenShulkerBox"] = "minecraft:green_shulker_box";
        MinecraftItemTypes2["GreenStainedGlass"] = "minecraft:green_stained_glass";
        MinecraftItemTypes2["GreenStainedGlassPane"] = "minecraft:green_stained_glass_pane";
        MinecraftItemTypes2["GreenTerracotta"] = "minecraft:green_terracotta";
        MinecraftItemTypes2["GreenWool"] = "minecraft:green_wool";
        MinecraftItemTypes2["Grindstone"] = "minecraft:grindstone";
        MinecraftItemTypes2["GuardianSpawnEgg"] = "minecraft:guardian_spawn_egg";
        MinecraftItemTypes2["Gunpowder"] = "minecraft:gunpowder";
        MinecraftItemTypes2["GusterBannerPattern"] = "minecraft:guster_banner_pattern";
        MinecraftItemTypes2["GusterPotterySherd"] = "minecraft:guster_pottery_sherd";
        MinecraftItemTypes2["HangingRoots"] = "minecraft:hanging_roots";
        MinecraftItemTypes2["HappyGhastSpawnEgg"] = "minecraft:happy_ghast_spawn_egg";
        MinecraftItemTypes2["HardenedClay"] = "minecraft:hardened_clay";
        MinecraftItemTypes2["HayBlock"] = "minecraft:hay_block";
        MinecraftItemTypes2["HeartOfTheSea"] = "minecraft:heart_of_the_sea";
        MinecraftItemTypes2["HeartPotterySherd"] = "minecraft:heart_pottery_sherd";
        MinecraftItemTypes2["HeartbreakPotterySherd"] = "minecraft:heartbreak_pottery_sherd";
        MinecraftItemTypes2["HeavyCore"] = "minecraft:heavy_core";
        MinecraftItemTypes2["HeavyWeightedPressurePlate"] = "minecraft:heavy_weighted_pressure_plate";
        MinecraftItemTypes2["HoglinSpawnEgg"] = "minecraft:hoglin_spawn_egg";
        MinecraftItemTypes2["HoneyBlock"] = "minecraft:honey_block";
        MinecraftItemTypes2["HoneyBottle"] = "minecraft:honey_bottle";
        MinecraftItemTypes2["Honeycomb"] = "minecraft:honeycomb";
        MinecraftItemTypes2["HoneycombBlock"] = "minecraft:honeycomb_block";
        MinecraftItemTypes2["Hopper"] = "minecraft:hopper";
        MinecraftItemTypes2["HopperMinecart"] = "minecraft:hopper_minecart";
        MinecraftItemTypes2["HornCoral"] = "minecraft:horn_coral";
        MinecraftItemTypes2["HornCoralBlock"] = "minecraft:horn_coral_block";
        MinecraftItemTypes2["HornCoralFan"] = "minecraft:horn_coral_fan";
        MinecraftItemTypes2["HorseSpawnEgg"] = "minecraft:horse_spawn_egg";
        MinecraftItemTypes2["HostArmorTrimSmithingTemplate"] = "minecraft:host_armor_trim_smithing_template";
        MinecraftItemTypes2["HowlPotterySherd"] = "minecraft:howl_pottery_sherd";
        MinecraftItemTypes2["HuskSpawnEgg"] = "minecraft:husk_spawn_egg";
        MinecraftItemTypes2["Ice"] = "minecraft:ice";
        MinecraftItemTypes2["InfestedChiseledStoneBricks"] = "minecraft:infested_chiseled_stone_bricks";
        MinecraftItemTypes2["InfestedCobblestone"] = "minecraft:infested_cobblestone";
        MinecraftItemTypes2["InfestedCrackedStoneBricks"] = "minecraft:infested_cracked_stone_bricks";
        MinecraftItemTypes2["InfestedDeepslate"] = "minecraft:infested_deepslate";
        MinecraftItemTypes2["InfestedMossyStoneBricks"] = "minecraft:infested_mossy_stone_bricks";
        MinecraftItemTypes2["InfestedStone"] = "minecraft:infested_stone";
        MinecraftItemTypes2["InfestedStoneBricks"] = "minecraft:infested_stone_bricks";
        MinecraftItemTypes2["InkSac"] = "minecraft:ink_sac";
        MinecraftItemTypes2["IronAxe"] = "minecraft:iron_axe";
        MinecraftItemTypes2["IronBars"] = "minecraft:iron_bars";
        MinecraftItemTypes2["IronBlock"] = "minecraft:iron_block";
        MinecraftItemTypes2["IronBoots"] = "minecraft:iron_boots";
        MinecraftItemTypes2["IronChain"] = "minecraft:iron_chain";
        MinecraftItemTypes2["IronChestplate"] = "minecraft:iron_chestplate";
        MinecraftItemTypes2["IronDoor"] = "minecraft:iron_door";
        MinecraftItemTypes2["IronGolemSpawnEgg"] = "minecraft:iron_golem_spawn_egg";
        MinecraftItemTypes2["IronHelmet"] = "minecraft:iron_helmet";
        MinecraftItemTypes2["IronHoe"] = "minecraft:iron_hoe";
        MinecraftItemTypes2["IronHorseArmor"] = "minecraft:iron_horse_armor";
        MinecraftItemTypes2["IronIngot"] = "minecraft:iron_ingot";
        MinecraftItemTypes2["IronLeggings"] = "minecraft:iron_leggings";
        MinecraftItemTypes2["IronNugget"] = "minecraft:iron_nugget";
        MinecraftItemTypes2["IronOre"] = "minecraft:iron_ore";
        MinecraftItemTypes2["IronPickaxe"] = "minecraft:iron_pickaxe";
        MinecraftItemTypes2["IronShovel"] = "minecraft:iron_shovel";
        MinecraftItemTypes2["IronSword"] = "minecraft:iron_sword";
        MinecraftItemTypes2["IronTrapdoor"] = "minecraft:iron_trapdoor";
        MinecraftItemTypes2["Jigsaw"] = "minecraft:jigsaw";
        MinecraftItemTypes2["Jukebox"] = "minecraft:jukebox";
        MinecraftItemTypes2["JungleBoat"] = "minecraft:jungle_boat";
        MinecraftItemTypes2["JungleButton"] = "minecraft:jungle_button";
        MinecraftItemTypes2["JungleChestBoat"] = "minecraft:jungle_chest_boat";
        MinecraftItemTypes2["JungleDoor"] = "minecraft:jungle_door";
        MinecraftItemTypes2["JungleFence"] = "minecraft:jungle_fence";
        MinecraftItemTypes2["JungleFenceGate"] = "minecraft:jungle_fence_gate";
        MinecraftItemTypes2["JungleHangingSign"] = "minecraft:jungle_hanging_sign";
        MinecraftItemTypes2["JungleLeaves"] = "minecraft:jungle_leaves";
        MinecraftItemTypes2["JungleLog"] = "minecraft:jungle_log";
        MinecraftItemTypes2["JunglePlanks"] = "minecraft:jungle_planks";
        MinecraftItemTypes2["JunglePressurePlate"] = "minecraft:jungle_pressure_plate";
        MinecraftItemTypes2["JungleSapling"] = "minecraft:jungle_sapling";
        MinecraftItemTypes2["JungleShelf"] = "minecraft:jungle_shelf";
        MinecraftItemTypes2["JungleSign"] = "minecraft:jungle_sign";
        MinecraftItemTypes2["JungleSlab"] = "minecraft:jungle_slab";
        MinecraftItemTypes2["JungleStairs"] = "minecraft:jungle_stairs";
        MinecraftItemTypes2["JungleTrapdoor"] = "minecraft:jungle_trapdoor";
        MinecraftItemTypes2["JungleWood"] = "minecraft:jungle_wood";
        MinecraftItemTypes2["Kelp"] = "minecraft:kelp";
        MinecraftItemTypes2["Ladder"] = "minecraft:ladder";
        MinecraftItemTypes2["Lantern"] = "minecraft:lantern";
        MinecraftItemTypes2["LapisBlock"] = "minecraft:lapis_block";
        MinecraftItemTypes2["LapisLazuli"] = "minecraft:lapis_lazuli";
        MinecraftItemTypes2["LapisOre"] = "minecraft:lapis_ore";
        MinecraftItemTypes2["LargeAmethystBud"] = "minecraft:large_amethyst_bud";
        MinecraftItemTypes2["LargeFern"] = "minecraft:large_fern";
        MinecraftItemTypes2["LavaBucket"] = "minecraft:lava_bucket";
        MinecraftItemTypes2["Lead"] = "minecraft:lead";
        MinecraftItemTypes2["LeafLitter"] = "minecraft:leaf_litter";
        MinecraftItemTypes2["Leather"] = "minecraft:leather";
        MinecraftItemTypes2["LeatherBoots"] = "minecraft:leather_boots";
        MinecraftItemTypes2["LeatherChestplate"] = "minecraft:leather_chestplate";
        MinecraftItemTypes2["LeatherHelmet"] = "minecraft:leather_helmet";
        MinecraftItemTypes2["LeatherHorseArmor"] = "minecraft:leather_horse_armor";
        MinecraftItemTypes2["LeatherLeggings"] = "minecraft:leather_leggings";
        MinecraftItemTypes2["Lectern"] = "minecraft:lectern";
        MinecraftItemTypes2["Lever"] = "minecraft:lever";
        MinecraftItemTypes2["LightBlock0"] = "minecraft:light_block_0";
        MinecraftItemTypes2["LightBlock1"] = "minecraft:light_block_1";
        MinecraftItemTypes2["LightBlock10"] = "minecraft:light_block_10";
        MinecraftItemTypes2["LightBlock11"] = "minecraft:light_block_11";
        MinecraftItemTypes2["LightBlock12"] = "minecraft:light_block_12";
        MinecraftItemTypes2["LightBlock13"] = "minecraft:light_block_13";
        MinecraftItemTypes2["LightBlock14"] = "minecraft:light_block_14";
        MinecraftItemTypes2["LightBlock15"] = "minecraft:light_block_15";
        MinecraftItemTypes2["LightBlock2"] = "minecraft:light_block_2";
        MinecraftItemTypes2["LightBlock3"] = "minecraft:light_block_3";
        MinecraftItemTypes2["LightBlock4"] = "minecraft:light_block_4";
        MinecraftItemTypes2["LightBlock5"] = "minecraft:light_block_5";
        MinecraftItemTypes2["LightBlock6"] = "minecraft:light_block_6";
        MinecraftItemTypes2["LightBlock7"] = "minecraft:light_block_7";
        MinecraftItemTypes2["LightBlock8"] = "minecraft:light_block_8";
        MinecraftItemTypes2["LightBlock9"] = "minecraft:light_block_9";
        MinecraftItemTypes2["LightBlueBundle"] = "minecraft:light_blue_bundle";
        MinecraftItemTypes2["LightBlueCandle"] = "minecraft:light_blue_candle";
        MinecraftItemTypes2["LightBlueCarpet"] = "minecraft:light_blue_carpet";
        MinecraftItemTypes2["LightBlueConcrete"] = "minecraft:light_blue_concrete";
        MinecraftItemTypes2["LightBlueConcretePowder"] = "minecraft:light_blue_concrete_powder";
        MinecraftItemTypes2["LightBlueDye"] = "minecraft:light_blue_dye";
        MinecraftItemTypes2["LightBlueGlazedTerracotta"] = "minecraft:light_blue_glazed_terracotta";
        MinecraftItemTypes2["LightBlueHarness"] = "minecraft:light_blue_harness";
        MinecraftItemTypes2["LightBlueShulkerBox"] = "minecraft:light_blue_shulker_box";
        MinecraftItemTypes2["LightBlueStainedGlass"] = "minecraft:light_blue_stained_glass";
        MinecraftItemTypes2["LightBlueStainedGlassPane"] = "minecraft:light_blue_stained_glass_pane";
        MinecraftItemTypes2["LightBlueTerracotta"] = "minecraft:light_blue_terracotta";
        MinecraftItemTypes2["LightBlueWool"] = "minecraft:light_blue_wool";
        MinecraftItemTypes2["LightGrayBundle"] = "minecraft:light_gray_bundle";
        MinecraftItemTypes2["LightGrayCandle"] = "minecraft:light_gray_candle";
        MinecraftItemTypes2["LightGrayCarpet"] = "minecraft:light_gray_carpet";
        MinecraftItemTypes2["LightGrayConcrete"] = "minecraft:light_gray_concrete";
        MinecraftItemTypes2["LightGrayConcretePowder"] = "minecraft:light_gray_concrete_powder";
        MinecraftItemTypes2["LightGrayDye"] = "minecraft:light_gray_dye";
        MinecraftItemTypes2["LightGrayHarness"] = "minecraft:light_gray_harness";
        MinecraftItemTypes2["LightGrayShulkerBox"] = "minecraft:light_gray_shulker_box";
        MinecraftItemTypes2["LightGrayStainedGlass"] = "minecraft:light_gray_stained_glass";
        MinecraftItemTypes2["LightGrayStainedGlassPane"] = "minecraft:light_gray_stained_glass_pane";
        MinecraftItemTypes2["LightGrayTerracotta"] = "minecraft:light_gray_terracotta";
        MinecraftItemTypes2["LightGrayWool"] = "minecraft:light_gray_wool";
        MinecraftItemTypes2["LightWeightedPressurePlate"] = "minecraft:light_weighted_pressure_plate";
        MinecraftItemTypes2["LightningRod"] = "minecraft:lightning_rod";
        MinecraftItemTypes2["Lilac"] = "minecraft:lilac";
        MinecraftItemTypes2["LilyOfTheValley"] = "minecraft:lily_of_the_valley";
        MinecraftItemTypes2["LimeBundle"] = "minecraft:lime_bundle";
        MinecraftItemTypes2["LimeCandle"] = "minecraft:lime_candle";
        MinecraftItemTypes2["LimeCarpet"] = "minecraft:lime_carpet";
        MinecraftItemTypes2["LimeConcrete"] = "minecraft:lime_concrete";
        MinecraftItemTypes2["LimeConcretePowder"] = "minecraft:lime_concrete_powder";
        MinecraftItemTypes2["LimeDye"] = "minecraft:lime_dye";
        MinecraftItemTypes2["LimeGlazedTerracotta"] = "minecraft:lime_glazed_terracotta";
        MinecraftItemTypes2["LimeHarness"] = "minecraft:lime_harness";
        MinecraftItemTypes2["LimeShulkerBox"] = "minecraft:lime_shulker_box";
        MinecraftItemTypes2["LimeStainedGlass"] = "minecraft:lime_stained_glass";
        MinecraftItemTypes2["LimeStainedGlassPane"] = "minecraft:lime_stained_glass_pane";
        MinecraftItemTypes2["LimeTerracotta"] = "minecraft:lime_terracotta";
        MinecraftItemTypes2["LimeWool"] = "minecraft:lime_wool";
        MinecraftItemTypes2["LingeringPotion"] = "minecraft:lingering_potion";
        MinecraftItemTypes2["LitPumpkin"] = "minecraft:lit_pumpkin";
        MinecraftItemTypes2["LlamaSpawnEgg"] = "minecraft:llama_spawn_egg";
        MinecraftItemTypes2["Lodestone"] = "minecraft:lodestone";
        MinecraftItemTypes2["LodestoneCompass"] = "minecraft:lodestone_compass";
        MinecraftItemTypes2["Loom"] = "minecraft:loom";
        MinecraftItemTypes2["Mace"] = "minecraft:mace";
        MinecraftItemTypes2["MagentaBundle"] = "minecraft:magenta_bundle";
        MinecraftItemTypes2["MagentaCandle"] = "minecraft:magenta_candle";
        MinecraftItemTypes2["MagentaCarpet"] = "minecraft:magenta_carpet";
        MinecraftItemTypes2["MagentaConcrete"] = "minecraft:magenta_concrete";
        MinecraftItemTypes2["MagentaConcretePowder"] = "minecraft:magenta_concrete_powder";
        MinecraftItemTypes2["MagentaDye"] = "minecraft:magenta_dye";
        MinecraftItemTypes2["MagentaGlazedTerracotta"] = "minecraft:magenta_glazed_terracotta";
        MinecraftItemTypes2["MagentaHarness"] = "minecraft:magenta_harness";
        MinecraftItemTypes2["MagentaShulkerBox"] = "minecraft:magenta_shulker_box";
        MinecraftItemTypes2["MagentaStainedGlass"] = "minecraft:magenta_stained_glass";
        MinecraftItemTypes2["MagentaStainedGlassPane"] = "minecraft:magenta_stained_glass_pane";
        MinecraftItemTypes2["MagentaTerracotta"] = "minecraft:magenta_terracotta";
        MinecraftItemTypes2["MagentaWool"] = "minecraft:magenta_wool";
        MinecraftItemTypes2["Magma"] = "minecraft:magma";
        MinecraftItemTypes2["MagmaCream"] = "minecraft:magma_cream";
        MinecraftItemTypes2["MagmaCubeSpawnEgg"] = "minecraft:magma_cube_spawn_egg";
        MinecraftItemTypes2["MangroveBoat"] = "minecraft:mangrove_boat";
        MinecraftItemTypes2["MangroveButton"] = "minecraft:mangrove_button";
        MinecraftItemTypes2["MangroveChestBoat"] = "minecraft:mangrove_chest_boat";
        MinecraftItemTypes2["MangroveDoor"] = "minecraft:mangrove_door";
        MinecraftItemTypes2["MangroveFence"] = "minecraft:mangrove_fence";
        MinecraftItemTypes2["MangroveFenceGate"] = "minecraft:mangrove_fence_gate";
        MinecraftItemTypes2["MangroveHangingSign"] = "minecraft:mangrove_hanging_sign";
        MinecraftItemTypes2["MangroveLeaves"] = "minecraft:mangrove_leaves";
        MinecraftItemTypes2["MangroveLog"] = "minecraft:mangrove_log";
        MinecraftItemTypes2["MangrovePlanks"] = "minecraft:mangrove_planks";
        MinecraftItemTypes2["MangrovePressurePlate"] = "minecraft:mangrove_pressure_plate";
        MinecraftItemTypes2["MangrovePropagule"] = "minecraft:mangrove_propagule";
        MinecraftItemTypes2["MangroveRoots"] = "minecraft:mangrove_roots";
        MinecraftItemTypes2["MangroveShelf"] = "minecraft:mangrove_shelf";
        MinecraftItemTypes2["MangroveSign"] = "minecraft:mangrove_sign";
        MinecraftItemTypes2["MangroveSlab"] = "minecraft:mangrove_slab";
        MinecraftItemTypes2["MangroveStairs"] = "minecraft:mangrove_stairs";
        MinecraftItemTypes2["MangroveTrapdoor"] = "minecraft:mangrove_trapdoor";
        MinecraftItemTypes2["MangroveWood"] = "minecraft:mangrove_wood";
        MinecraftItemTypes2["MediumAmethystBud"] = "minecraft:medium_amethyst_bud";
        MinecraftItemTypes2["MelonBlock"] = "minecraft:melon_block";
        MinecraftItemTypes2["MelonSeeds"] = "minecraft:melon_seeds";
        MinecraftItemTypes2["MelonSlice"] = "minecraft:melon_slice";
        MinecraftItemTypes2["MilkBucket"] = "minecraft:milk_bucket";
        MinecraftItemTypes2["Minecart"] = "minecraft:minecart";
        MinecraftItemTypes2["MinerPotterySherd"] = "minecraft:miner_pottery_sherd";
        MinecraftItemTypes2["MobSpawner"] = "minecraft:mob_spawner";
        MinecraftItemTypes2["MojangBannerPattern"] = "minecraft:mojang_banner_pattern";
        MinecraftItemTypes2["MooshroomSpawnEgg"] = "minecraft:mooshroom_spawn_egg";
        MinecraftItemTypes2["MossBlock"] = "minecraft:moss_block";
        MinecraftItemTypes2["MossCarpet"] = "minecraft:moss_carpet";
        MinecraftItemTypes2["MossyCobblestone"] = "minecraft:mossy_cobblestone";
        MinecraftItemTypes2["MossyCobblestoneSlab"] = "minecraft:mossy_cobblestone_slab";
        MinecraftItemTypes2["MossyCobblestoneStairs"] = "minecraft:mossy_cobblestone_stairs";
        MinecraftItemTypes2["MossyCobblestoneWall"] = "minecraft:mossy_cobblestone_wall";
        MinecraftItemTypes2["MossyStoneBrickSlab"] = "minecraft:mossy_stone_brick_slab";
        MinecraftItemTypes2["MossyStoneBrickStairs"] = "minecraft:mossy_stone_brick_stairs";
        MinecraftItemTypes2["MossyStoneBrickWall"] = "minecraft:mossy_stone_brick_wall";
        MinecraftItemTypes2["MossyStoneBricks"] = "minecraft:mossy_stone_bricks";
        MinecraftItemTypes2["MournerPotterySherd"] = "minecraft:mourner_pottery_sherd";
        MinecraftItemTypes2["Mud"] = "minecraft:mud";
        MinecraftItemTypes2["MudBrickSlab"] = "minecraft:mud_brick_slab";
        MinecraftItemTypes2["MudBrickStairs"] = "minecraft:mud_brick_stairs";
        MinecraftItemTypes2["MudBrickWall"] = "minecraft:mud_brick_wall";
        MinecraftItemTypes2["MudBricks"] = "minecraft:mud_bricks";
        MinecraftItemTypes2["MuddyMangroveRoots"] = "minecraft:muddy_mangrove_roots";
        MinecraftItemTypes2["MuleSpawnEgg"] = "minecraft:mule_spawn_egg";
        MinecraftItemTypes2["MushroomStem"] = "minecraft:mushroom_stem";
        MinecraftItemTypes2["MushroomStew"] = "minecraft:mushroom_stew";
        MinecraftItemTypes2["MusicDisc11"] = "minecraft:music_disc_11";
        MinecraftItemTypes2["MusicDisc13"] = "minecraft:music_disc_13";
        MinecraftItemTypes2["MusicDisc5"] = "minecraft:music_disc_5";
        MinecraftItemTypes2["MusicDiscBlocks"] = "minecraft:music_disc_blocks";
        MinecraftItemTypes2["MusicDiscCat"] = "minecraft:music_disc_cat";
        MinecraftItemTypes2["MusicDiscChirp"] = "minecraft:music_disc_chirp";
        MinecraftItemTypes2["MusicDiscCreator"] = "minecraft:music_disc_creator";
        MinecraftItemTypes2["MusicDiscCreatorMusicBox"] = "minecraft:music_disc_creator_music_box";
        MinecraftItemTypes2["MusicDiscFar"] = "minecraft:music_disc_far";
        MinecraftItemTypes2["MusicDiscLavaChicken"] = "minecraft:music_disc_lava_chicken";
        MinecraftItemTypes2["MusicDiscMall"] = "minecraft:music_disc_mall";
        MinecraftItemTypes2["MusicDiscMellohi"] = "minecraft:music_disc_mellohi";
        MinecraftItemTypes2["MusicDiscOtherside"] = "minecraft:music_disc_otherside";
        MinecraftItemTypes2["MusicDiscPigstep"] = "minecraft:music_disc_pigstep";
        MinecraftItemTypes2["MusicDiscPrecipice"] = "minecraft:music_disc_precipice";
        MinecraftItemTypes2["MusicDiscRelic"] = "minecraft:music_disc_relic";
        MinecraftItemTypes2["MusicDiscStal"] = "minecraft:music_disc_stal";
        MinecraftItemTypes2["MusicDiscStrad"] = "minecraft:music_disc_strad";
        MinecraftItemTypes2["MusicDiscTears"] = "minecraft:music_disc_tears";
        MinecraftItemTypes2["MusicDiscWait"] = "minecraft:music_disc_wait";
        MinecraftItemTypes2["MusicDiscWard"] = "minecraft:music_disc_ward";
        MinecraftItemTypes2["Mutton"] = "minecraft:mutton";
        MinecraftItemTypes2["Mycelium"] = "minecraft:mycelium";
        MinecraftItemTypes2["NameTag"] = "minecraft:name_tag";
        MinecraftItemTypes2["NautilusShell"] = "minecraft:nautilus_shell";
        MinecraftItemTypes2["NetherBrick"] = "minecraft:nether_brick";
        MinecraftItemTypes2["NetherBrickFence"] = "minecraft:nether_brick_fence";
        MinecraftItemTypes2["NetherBrickSlab"] = "minecraft:nether_brick_slab";
        MinecraftItemTypes2["NetherBrickStairs"] = "minecraft:nether_brick_stairs";
        MinecraftItemTypes2["NetherBrickWall"] = "minecraft:nether_brick_wall";
        MinecraftItemTypes2["NetherGoldOre"] = "minecraft:nether_gold_ore";
        MinecraftItemTypes2["NetherSprouts"] = "minecraft:nether_sprouts";
        MinecraftItemTypes2["NetherStar"] = "minecraft:nether_star";
        MinecraftItemTypes2["NetherWart"] = "minecraft:nether_wart";
        MinecraftItemTypes2["NetherWartBlock"] = "minecraft:nether_wart_block";
        MinecraftItemTypes2["Netherbrick"] = "minecraft:netherbrick";
        MinecraftItemTypes2["NetheriteAxe"] = "minecraft:netherite_axe";
        MinecraftItemTypes2["NetheriteBlock"] = "minecraft:netherite_block";
        MinecraftItemTypes2["NetheriteBoots"] = "minecraft:netherite_boots";
        MinecraftItemTypes2["NetheriteChestplate"] = "minecraft:netherite_chestplate";
        MinecraftItemTypes2["NetheriteHelmet"] = "minecraft:netherite_helmet";
        MinecraftItemTypes2["NetheriteHoe"] = "minecraft:netherite_hoe";
        MinecraftItemTypes2["NetheriteIngot"] = "minecraft:netherite_ingot";
        MinecraftItemTypes2["NetheriteLeggings"] = "minecraft:netherite_leggings";
        MinecraftItemTypes2["NetheritePickaxe"] = "minecraft:netherite_pickaxe";
        MinecraftItemTypes2["NetheriteScrap"] = "minecraft:netherite_scrap";
        MinecraftItemTypes2["NetheriteShovel"] = "minecraft:netherite_shovel";
        MinecraftItemTypes2["NetheriteSword"] = "minecraft:netherite_sword";
        MinecraftItemTypes2["NetheriteUpgradeSmithingTemplate"] = "minecraft:netherite_upgrade_smithing_template";
        MinecraftItemTypes2["Netherrack"] = "minecraft:netherrack";
        MinecraftItemTypes2["NormalStoneSlab"] = "minecraft:normal_stone_slab";
        MinecraftItemTypes2["NormalStoneStairs"] = "minecraft:normal_stone_stairs";
        MinecraftItemTypes2["Noteblock"] = "minecraft:noteblock";
        MinecraftItemTypes2["OakBoat"] = "minecraft:oak_boat";
        MinecraftItemTypes2["OakChestBoat"] = "minecraft:oak_chest_boat";
        MinecraftItemTypes2["OakFence"] = "minecraft:oak_fence";
        MinecraftItemTypes2["OakHangingSign"] = "minecraft:oak_hanging_sign";
        MinecraftItemTypes2["OakLeaves"] = "minecraft:oak_leaves";
        MinecraftItemTypes2["OakLog"] = "minecraft:oak_log";
        MinecraftItemTypes2["OakPlanks"] = "minecraft:oak_planks";
        MinecraftItemTypes2["OakSapling"] = "minecraft:oak_sapling";
        MinecraftItemTypes2["OakShelf"] = "minecraft:oak_shelf";
        MinecraftItemTypes2["OakSign"] = "minecraft:oak_sign";
        MinecraftItemTypes2["OakSlab"] = "minecraft:oak_slab";
        MinecraftItemTypes2["OakStairs"] = "minecraft:oak_stairs";
        MinecraftItemTypes2["OakWood"] = "minecraft:oak_wood";
        MinecraftItemTypes2["Observer"] = "minecraft:observer";
        MinecraftItemTypes2["Obsidian"] = "minecraft:obsidian";
        MinecraftItemTypes2["OcelotSpawnEgg"] = "minecraft:ocelot_spawn_egg";
        MinecraftItemTypes2["OchreFroglight"] = "minecraft:ochre_froglight";
        MinecraftItemTypes2["OminousBottle"] = "minecraft:ominous_bottle";
        MinecraftItemTypes2["OminousTrialKey"] = "minecraft:ominous_trial_key";
        MinecraftItemTypes2["OpenEyeblossom"] = "minecraft:open_eyeblossom";
        MinecraftItemTypes2["OrangeBundle"] = "minecraft:orange_bundle";
        MinecraftItemTypes2["OrangeCandle"] = "minecraft:orange_candle";
        MinecraftItemTypes2["OrangeCarpet"] = "minecraft:orange_carpet";
        MinecraftItemTypes2["OrangeConcrete"] = "minecraft:orange_concrete";
        MinecraftItemTypes2["OrangeConcretePowder"] = "minecraft:orange_concrete_powder";
        MinecraftItemTypes2["OrangeDye"] = "minecraft:orange_dye";
        MinecraftItemTypes2["OrangeGlazedTerracotta"] = "minecraft:orange_glazed_terracotta";
        MinecraftItemTypes2["OrangeHarness"] = "minecraft:orange_harness";
        MinecraftItemTypes2["OrangeShulkerBox"] = "minecraft:orange_shulker_box";
        MinecraftItemTypes2["OrangeStainedGlass"] = "minecraft:orange_stained_glass";
        MinecraftItemTypes2["OrangeStainedGlassPane"] = "minecraft:orange_stained_glass_pane";
        MinecraftItemTypes2["OrangeTerracotta"] = "minecraft:orange_terracotta";
        MinecraftItemTypes2["OrangeTulip"] = "minecraft:orange_tulip";
        MinecraftItemTypes2["OrangeWool"] = "minecraft:orange_wool";
        MinecraftItemTypes2["OxeyeDaisy"] = "minecraft:oxeye_daisy";
        MinecraftItemTypes2["OxidizedChiseledCopper"] = "minecraft:oxidized_chiseled_copper";
        MinecraftItemTypes2["OxidizedCopper"] = "minecraft:oxidized_copper";
        MinecraftItemTypes2["OxidizedCopperBars"] = "minecraft:oxidized_copper_bars";
        MinecraftItemTypes2["OxidizedCopperBulb"] = "minecraft:oxidized_copper_bulb";
        MinecraftItemTypes2["OxidizedCopperChain"] = "minecraft:oxidized_copper_chain";
        MinecraftItemTypes2["OxidizedCopperChest"] = "minecraft:oxidized_copper_chest";
        MinecraftItemTypes2["OxidizedCopperDoor"] = "minecraft:oxidized_copper_door";
        MinecraftItemTypes2["OxidizedCopperGolemStatue"] = "minecraft:oxidized_copper_golem_statue";
        MinecraftItemTypes2["OxidizedCopperGrate"] = "minecraft:oxidized_copper_grate";
        MinecraftItemTypes2["OxidizedCopperLantern"] = "minecraft:oxidized_copper_lantern";
        MinecraftItemTypes2["OxidizedCopperTrapdoor"] = "minecraft:oxidized_copper_trapdoor";
        MinecraftItemTypes2["OxidizedCutCopper"] = "minecraft:oxidized_cut_copper";
        MinecraftItemTypes2["OxidizedCutCopperSlab"] = "minecraft:oxidized_cut_copper_slab";
        MinecraftItemTypes2["OxidizedCutCopperStairs"] = "minecraft:oxidized_cut_copper_stairs";
        MinecraftItemTypes2["OxidizedLightningRod"] = "minecraft:oxidized_lightning_rod";
        MinecraftItemTypes2["PackedIce"] = "minecraft:packed_ice";
        MinecraftItemTypes2["PackedMud"] = "minecraft:packed_mud";
        MinecraftItemTypes2["Painting"] = "minecraft:painting";
        MinecraftItemTypes2["PaleHangingMoss"] = "minecraft:pale_hanging_moss";
        MinecraftItemTypes2["PaleMossBlock"] = "minecraft:pale_moss_block";
        MinecraftItemTypes2["PaleMossCarpet"] = "minecraft:pale_moss_carpet";
        MinecraftItemTypes2["PaleOakBoat"] = "minecraft:pale_oak_boat";
        MinecraftItemTypes2["PaleOakButton"] = "minecraft:pale_oak_button";
        MinecraftItemTypes2["PaleOakChestBoat"] = "minecraft:pale_oak_chest_boat";
        MinecraftItemTypes2["PaleOakDoor"] = "minecraft:pale_oak_door";
        MinecraftItemTypes2["PaleOakFence"] = "minecraft:pale_oak_fence";
        MinecraftItemTypes2["PaleOakFenceGate"] = "minecraft:pale_oak_fence_gate";
        MinecraftItemTypes2["PaleOakHangingSign"] = "minecraft:pale_oak_hanging_sign";
        MinecraftItemTypes2["PaleOakLeaves"] = "minecraft:pale_oak_leaves";
        MinecraftItemTypes2["PaleOakLog"] = "minecraft:pale_oak_log";
        MinecraftItemTypes2["PaleOakPlanks"] = "minecraft:pale_oak_planks";
        MinecraftItemTypes2["PaleOakPressurePlate"] = "minecraft:pale_oak_pressure_plate";
        MinecraftItemTypes2["PaleOakSapling"] = "minecraft:pale_oak_sapling";
        MinecraftItemTypes2["PaleOakShelf"] = "minecraft:pale_oak_shelf";
        MinecraftItemTypes2["PaleOakSign"] = "minecraft:pale_oak_sign";
        MinecraftItemTypes2["PaleOakSlab"] = "minecraft:pale_oak_slab";
        MinecraftItemTypes2["PaleOakStairs"] = "minecraft:pale_oak_stairs";
        MinecraftItemTypes2["PaleOakTrapdoor"] = "minecraft:pale_oak_trapdoor";
        MinecraftItemTypes2["PaleOakWood"] = "minecraft:pale_oak_wood";
        MinecraftItemTypes2["PandaSpawnEgg"] = "minecraft:panda_spawn_egg";
        MinecraftItemTypes2["Paper"] = "minecraft:paper";
        MinecraftItemTypes2["ParrotSpawnEgg"] = "minecraft:parrot_spawn_egg";
        MinecraftItemTypes2["PearlescentFroglight"] = "minecraft:pearlescent_froglight";
        MinecraftItemTypes2["Peony"] = "minecraft:peony";
        MinecraftItemTypes2["PetrifiedOakSlab"] = "minecraft:petrified_oak_slab";
        MinecraftItemTypes2["PhantomMembrane"] = "minecraft:phantom_membrane";
        MinecraftItemTypes2["PhantomSpawnEgg"] = "minecraft:phantom_spawn_egg";
        MinecraftItemTypes2["PigSpawnEgg"] = "minecraft:pig_spawn_egg";
        MinecraftItemTypes2["PiglinBannerPattern"] = "minecraft:piglin_banner_pattern";
        MinecraftItemTypes2["PiglinBruteSpawnEgg"] = "minecraft:piglin_brute_spawn_egg";
        MinecraftItemTypes2["PiglinHead"] = "minecraft:piglin_head";
        MinecraftItemTypes2["PiglinSpawnEgg"] = "minecraft:piglin_spawn_egg";
        MinecraftItemTypes2["PillagerSpawnEgg"] = "minecraft:pillager_spawn_egg";
        MinecraftItemTypes2["PinkBundle"] = "minecraft:pink_bundle";
        MinecraftItemTypes2["PinkCandle"] = "minecraft:pink_candle";
        MinecraftItemTypes2["PinkCarpet"] = "minecraft:pink_carpet";
        MinecraftItemTypes2["PinkConcrete"] = "minecraft:pink_concrete";
        MinecraftItemTypes2["PinkConcretePowder"] = "minecraft:pink_concrete_powder";
        MinecraftItemTypes2["PinkDye"] = "minecraft:pink_dye";
        MinecraftItemTypes2["PinkGlazedTerracotta"] = "minecraft:pink_glazed_terracotta";
        MinecraftItemTypes2["PinkHarness"] = "minecraft:pink_harness";
        MinecraftItemTypes2["PinkPetals"] = "minecraft:pink_petals";
        MinecraftItemTypes2["PinkShulkerBox"] = "minecraft:pink_shulker_box";
        MinecraftItemTypes2["PinkStainedGlass"] = "minecraft:pink_stained_glass";
        MinecraftItemTypes2["PinkStainedGlassPane"] = "minecraft:pink_stained_glass_pane";
        MinecraftItemTypes2["PinkTerracotta"] = "minecraft:pink_terracotta";
        MinecraftItemTypes2["PinkTulip"] = "minecraft:pink_tulip";
        MinecraftItemTypes2["PinkWool"] = "minecraft:pink_wool";
        MinecraftItemTypes2["Piston"] = "minecraft:piston";
        MinecraftItemTypes2["PitcherPlant"] = "minecraft:pitcher_plant";
        MinecraftItemTypes2["PitcherPod"] = "minecraft:pitcher_pod";
        MinecraftItemTypes2["PlayerHead"] = "minecraft:player_head";
        MinecraftItemTypes2["PlentyPotterySherd"] = "minecraft:plenty_pottery_sherd";
        MinecraftItemTypes2["Podzol"] = "minecraft:podzol";
        MinecraftItemTypes2["PointedDripstone"] = "minecraft:pointed_dripstone";
        MinecraftItemTypes2["PoisonousPotato"] = "minecraft:poisonous_potato";
        MinecraftItemTypes2["PolarBearSpawnEgg"] = "minecraft:polar_bear_spawn_egg";
        MinecraftItemTypes2["PolishedAndesite"] = "minecraft:polished_andesite";
        MinecraftItemTypes2["PolishedAndesiteSlab"] = "minecraft:polished_andesite_slab";
        MinecraftItemTypes2["PolishedAndesiteStairs"] = "minecraft:polished_andesite_stairs";
        MinecraftItemTypes2["PolishedBasalt"] = "minecraft:polished_basalt";
        MinecraftItemTypes2["PolishedBlackstone"] = "minecraft:polished_blackstone";
        MinecraftItemTypes2["PolishedBlackstoneBrickSlab"] = "minecraft:polished_blackstone_brick_slab";
        MinecraftItemTypes2["PolishedBlackstoneBrickStairs"] = "minecraft:polished_blackstone_brick_stairs";
        MinecraftItemTypes2["PolishedBlackstoneBrickWall"] = "minecraft:polished_blackstone_brick_wall";
        MinecraftItemTypes2["PolishedBlackstoneBricks"] = "minecraft:polished_blackstone_bricks";
        MinecraftItemTypes2["PolishedBlackstoneButton"] = "minecraft:polished_blackstone_button";
        MinecraftItemTypes2["PolishedBlackstonePressurePlate"] = "minecraft:polished_blackstone_pressure_plate";
        MinecraftItemTypes2["PolishedBlackstoneSlab"] = "minecraft:polished_blackstone_slab";
        MinecraftItemTypes2["PolishedBlackstoneStairs"] = "minecraft:polished_blackstone_stairs";
        MinecraftItemTypes2["PolishedBlackstoneWall"] = "minecraft:polished_blackstone_wall";
        MinecraftItemTypes2["PolishedDeepslate"] = "minecraft:polished_deepslate";
        MinecraftItemTypes2["PolishedDeepslateSlab"] = "minecraft:polished_deepslate_slab";
        MinecraftItemTypes2["PolishedDeepslateStairs"] = "minecraft:polished_deepslate_stairs";
        MinecraftItemTypes2["PolishedDeepslateWall"] = "minecraft:polished_deepslate_wall";
        MinecraftItemTypes2["PolishedDiorite"] = "minecraft:polished_diorite";
        MinecraftItemTypes2["PolishedDioriteSlab"] = "minecraft:polished_diorite_slab";
        MinecraftItemTypes2["PolishedDioriteStairs"] = "minecraft:polished_diorite_stairs";
        MinecraftItemTypes2["PolishedGranite"] = "minecraft:polished_granite";
        MinecraftItemTypes2["PolishedGraniteSlab"] = "minecraft:polished_granite_slab";
        MinecraftItemTypes2["PolishedGraniteStairs"] = "minecraft:polished_granite_stairs";
        MinecraftItemTypes2["PolishedTuff"] = "minecraft:polished_tuff";
        MinecraftItemTypes2["PolishedTuffSlab"] = "minecraft:polished_tuff_slab";
        MinecraftItemTypes2["PolishedTuffStairs"] = "minecraft:polished_tuff_stairs";
        MinecraftItemTypes2["PolishedTuffWall"] = "minecraft:polished_tuff_wall";
        MinecraftItemTypes2["PoppedChorusFruit"] = "minecraft:popped_chorus_fruit";
        MinecraftItemTypes2["Poppy"] = "minecraft:poppy";
        MinecraftItemTypes2["Porkchop"] = "minecraft:porkchop";
        MinecraftItemTypes2["Potato"] = "minecraft:potato";
        MinecraftItemTypes2["Potion"] = "minecraft:potion";
        MinecraftItemTypes2["PowderSnowBucket"] = "minecraft:powder_snow_bucket";
        MinecraftItemTypes2["Prismarine"] = "minecraft:prismarine";
        MinecraftItemTypes2["PrismarineBrickSlab"] = "minecraft:prismarine_brick_slab";
        MinecraftItemTypes2["PrismarineBricks"] = "minecraft:prismarine_bricks";
        MinecraftItemTypes2["PrismarineBricksStairs"] = "minecraft:prismarine_bricks_stairs";
        MinecraftItemTypes2["PrismarineCrystals"] = "minecraft:prismarine_crystals";
        MinecraftItemTypes2["PrismarineShard"] = "minecraft:prismarine_shard";
        MinecraftItemTypes2["PrismarineSlab"] = "minecraft:prismarine_slab";
        MinecraftItemTypes2["PrismarineStairs"] = "minecraft:prismarine_stairs";
        MinecraftItemTypes2["PrismarineWall"] = "minecraft:prismarine_wall";
        MinecraftItemTypes2["PrizePotterySherd"] = "minecraft:prize_pottery_sherd";
        MinecraftItemTypes2["Pufferfish"] = "minecraft:pufferfish";
        MinecraftItemTypes2["PufferfishBucket"] = "minecraft:pufferfish_bucket";
        MinecraftItemTypes2["PufferfishSpawnEgg"] = "minecraft:pufferfish_spawn_egg";
        MinecraftItemTypes2["Pumpkin"] = "minecraft:pumpkin";
        MinecraftItemTypes2["PumpkinPie"] = "minecraft:pumpkin_pie";
        MinecraftItemTypes2["PumpkinSeeds"] = "minecraft:pumpkin_seeds";
        MinecraftItemTypes2["PurpleBundle"] = "minecraft:purple_bundle";
        MinecraftItemTypes2["PurpleCandle"] = "minecraft:purple_candle";
        MinecraftItemTypes2["PurpleCarpet"] = "minecraft:purple_carpet";
        MinecraftItemTypes2["PurpleConcrete"] = "minecraft:purple_concrete";
        MinecraftItemTypes2["PurpleConcretePowder"] = "minecraft:purple_concrete_powder";
        MinecraftItemTypes2["PurpleDye"] = "minecraft:purple_dye";
        MinecraftItemTypes2["PurpleGlazedTerracotta"] = "minecraft:purple_glazed_terracotta";
        MinecraftItemTypes2["PurpleHarness"] = "minecraft:purple_harness";
        MinecraftItemTypes2["PurpleShulkerBox"] = "minecraft:purple_shulker_box";
        MinecraftItemTypes2["PurpleStainedGlass"] = "minecraft:purple_stained_glass";
        MinecraftItemTypes2["PurpleStainedGlassPane"] = "minecraft:purple_stained_glass_pane";
        MinecraftItemTypes2["PurpleTerracotta"] = "minecraft:purple_terracotta";
        MinecraftItemTypes2["PurpleWool"] = "minecraft:purple_wool";
        MinecraftItemTypes2["PurpurBlock"] = "minecraft:purpur_block";
        MinecraftItemTypes2["PurpurPillar"] = "minecraft:purpur_pillar";
        MinecraftItemTypes2["PurpurSlab"] = "minecraft:purpur_slab";
        MinecraftItemTypes2["PurpurStairs"] = "minecraft:purpur_stairs";
        MinecraftItemTypes2["Quartz"] = "minecraft:quartz";
        MinecraftItemTypes2["QuartzBlock"] = "minecraft:quartz_block";
        MinecraftItemTypes2["QuartzBricks"] = "minecraft:quartz_bricks";
        MinecraftItemTypes2["QuartzOre"] = "minecraft:quartz_ore";
        MinecraftItemTypes2["QuartzPillar"] = "minecraft:quartz_pillar";
        MinecraftItemTypes2["QuartzSlab"] = "minecraft:quartz_slab";
        MinecraftItemTypes2["QuartzStairs"] = "minecraft:quartz_stairs";
        MinecraftItemTypes2["Rabbit"] = "minecraft:rabbit";
        MinecraftItemTypes2["RabbitFoot"] = "minecraft:rabbit_foot";
        MinecraftItemTypes2["RabbitHide"] = "minecraft:rabbit_hide";
        MinecraftItemTypes2["RabbitSpawnEgg"] = "minecraft:rabbit_spawn_egg";
        MinecraftItemTypes2["RabbitStew"] = "minecraft:rabbit_stew";
        MinecraftItemTypes2["Rail"] = "minecraft:rail";
        MinecraftItemTypes2["RaiserArmorTrimSmithingTemplate"] = "minecraft:raiser_armor_trim_smithing_template";
        MinecraftItemTypes2["RavagerSpawnEgg"] = "minecraft:ravager_spawn_egg";
        MinecraftItemTypes2["RawCopper"] = "minecraft:raw_copper";
        MinecraftItemTypes2["RawCopperBlock"] = "minecraft:raw_copper_block";
        MinecraftItemTypes2["RawGold"] = "minecraft:raw_gold";
        MinecraftItemTypes2["RawGoldBlock"] = "minecraft:raw_gold_block";
        MinecraftItemTypes2["RawIron"] = "minecraft:raw_iron";
        MinecraftItemTypes2["RawIronBlock"] = "minecraft:raw_iron_block";
        MinecraftItemTypes2["RecoveryCompass"] = "minecraft:recovery_compass";
        MinecraftItemTypes2["RedBundle"] = "minecraft:red_bundle";
        MinecraftItemTypes2["RedCandle"] = "minecraft:red_candle";
        MinecraftItemTypes2["RedCarpet"] = "minecraft:red_carpet";
        MinecraftItemTypes2["RedConcrete"] = "minecraft:red_concrete";
        MinecraftItemTypes2["RedConcretePowder"] = "minecraft:red_concrete_powder";
        MinecraftItemTypes2["RedDye"] = "minecraft:red_dye";
        MinecraftItemTypes2["RedGlazedTerracotta"] = "minecraft:red_glazed_terracotta";
        MinecraftItemTypes2["RedHarness"] = "minecraft:red_harness";
        MinecraftItemTypes2["RedMushroom"] = "minecraft:red_mushroom";
        MinecraftItemTypes2["RedMushroomBlock"] = "minecraft:red_mushroom_block";
        MinecraftItemTypes2["RedNetherBrick"] = "minecraft:red_nether_brick";
        MinecraftItemTypes2["RedNetherBrickSlab"] = "minecraft:red_nether_brick_slab";
        MinecraftItemTypes2["RedNetherBrickStairs"] = "minecraft:red_nether_brick_stairs";
        MinecraftItemTypes2["RedNetherBrickWall"] = "minecraft:red_nether_brick_wall";
        MinecraftItemTypes2["RedSand"] = "minecraft:red_sand";
        MinecraftItemTypes2["RedSandstone"] = "minecraft:red_sandstone";
        MinecraftItemTypes2["RedSandstoneSlab"] = "minecraft:red_sandstone_slab";
        MinecraftItemTypes2["RedSandstoneStairs"] = "minecraft:red_sandstone_stairs";
        MinecraftItemTypes2["RedSandstoneWall"] = "minecraft:red_sandstone_wall";
        MinecraftItemTypes2["RedShulkerBox"] = "minecraft:red_shulker_box";
        MinecraftItemTypes2["RedStainedGlass"] = "minecraft:red_stained_glass";
        MinecraftItemTypes2["RedStainedGlassPane"] = "minecraft:red_stained_glass_pane";
        MinecraftItemTypes2["RedTerracotta"] = "minecraft:red_terracotta";
        MinecraftItemTypes2["RedTulip"] = "minecraft:red_tulip";
        MinecraftItemTypes2["RedWool"] = "minecraft:red_wool";
        MinecraftItemTypes2["Redstone"] = "minecraft:redstone";
        MinecraftItemTypes2["RedstoneBlock"] = "minecraft:redstone_block";
        MinecraftItemTypes2["RedstoneLamp"] = "minecraft:redstone_lamp";
        MinecraftItemTypes2["RedstoneOre"] = "minecraft:redstone_ore";
        MinecraftItemTypes2["RedstoneTorch"] = "minecraft:redstone_torch";
        MinecraftItemTypes2["ReinforcedDeepslate"] = "minecraft:reinforced_deepslate";
        MinecraftItemTypes2["Repeater"] = "minecraft:repeater";
        MinecraftItemTypes2["RepeatingCommandBlock"] = "minecraft:repeating_command_block";
        MinecraftItemTypes2["ResinBlock"] = "minecraft:resin_block";
        MinecraftItemTypes2["ResinBrick"] = "minecraft:resin_brick";
        MinecraftItemTypes2["ResinBrickSlab"] = "minecraft:resin_brick_slab";
        MinecraftItemTypes2["ResinBrickStairs"] = "minecraft:resin_brick_stairs";
        MinecraftItemTypes2["ResinBrickWall"] = "minecraft:resin_brick_wall";
        MinecraftItemTypes2["ResinBricks"] = "minecraft:resin_bricks";
        MinecraftItemTypes2["ResinClump"] = "minecraft:resin_clump";
        MinecraftItemTypes2["RespawnAnchor"] = "minecraft:respawn_anchor";
        MinecraftItemTypes2["RibArmorTrimSmithingTemplate"] = "minecraft:rib_armor_trim_smithing_template";
        MinecraftItemTypes2["RoseBush"] = "minecraft:rose_bush";
        MinecraftItemTypes2["RottenFlesh"] = "minecraft:rotten_flesh";
        MinecraftItemTypes2["Saddle"] = "minecraft:saddle";
        MinecraftItemTypes2["Salmon"] = "minecraft:salmon";
        MinecraftItemTypes2["SalmonBucket"] = "minecraft:salmon_bucket";
        MinecraftItemTypes2["SalmonSpawnEgg"] = "minecraft:salmon_spawn_egg";
        MinecraftItemTypes2["Sand"] = "minecraft:sand";
        MinecraftItemTypes2["Sandstone"] = "minecraft:sandstone";
        MinecraftItemTypes2["SandstoneSlab"] = "minecraft:sandstone_slab";
        MinecraftItemTypes2["SandstoneStairs"] = "minecraft:sandstone_stairs";
        MinecraftItemTypes2["SandstoneWall"] = "minecraft:sandstone_wall";
        MinecraftItemTypes2["Scaffolding"] = "minecraft:scaffolding";
        MinecraftItemTypes2["ScrapePotterySherd"] = "minecraft:scrape_pottery_sherd";
        MinecraftItemTypes2["Sculk"] = "minecraft:sculk";
        MinecraftItemTypes2["SculkCatalyst"] = "minecraft:sculk_catalyst";
        MinecraftItemTypes2["SculkSensor"] = "minecraft:sculk_sensor";
        MinecraftItemTypes2["SculkShrieker"] = "minecraft:sculk_shrieker";
        MinecraftItemTypes2["SculkVein"] = "minecraft:sculk_vein";
        MinecraftItemTypes2["SeaLantern"] = "minecraft:sea_lantern";
        MinecraftItemTypes2["SeaPickle"] = "minecraft:sea_pickle";
        MinecraftItemTypes2["Seagrass"] = "minecraft:seagrass";
        MinecraftItemTypes2["SentryArmorTrimSmithingTemplate"] = "minecraft:sentry_armor_trim_smithing_template";
        MinecraftItemTypes2["ShaperArmorTrimSmithingTemplate"] = "minecraft:shaper_armor_trim_smithing_template";
        MinecraftItemTypes2["SheafPotterySherd"] = "minecraft:sheaf_pottery_sherd";
        MinecraftItemTypes2["Shears"] = "minecraft:shears";
        MinecraftItemTypes2["SheepSpawnEgg"] = "minecraft:sheep_spawn_egg";
        MinecraftItemTypes2["ShelterPotterySherd"] = "minecraft:shelter_pottery_sherd";
        MinecraftItemTypes2["Shield"] = "minecraft:shield";
        MinecraftItemTypes2["ShortDryGrass"] = "minecraft:short_dry_grass";
        MinecraftItemTypes2["ShortGrass"] = "minecraft:short_grass";
        MinecraftItemTypes2["Shroomlight"] = "minecraft:shroomlight";
        MinecraftItemTypes2["ShulkerShell"] = "minecraft:shulker_shell";
        MinecraftItemTypes2["ShulkerSpawnEgg"] = "minecraft:shulker_spawn_egg";
        MinecraftItemTypes2["SilenceArmorTrimSmithingTemplate"] = "minecraft:silence_armor_trim_smithing_template";
        MinecraftItemTypes2["SilverGlazedTerracotta"] = "minecraft:silver_glazed_terracotta";
        MinecraftItemTypes2["SilverfishSpawnEgg"] = "minecraft:silverfish_spawn_egg";
        MinecraftItemTypes2["SkeletonHorseSpawnEgg"] = "minecraft:skeleton_horse_spawn_egg";
        MinecraftItemTypes2["SkeletonSkull"] = "minecraft:skeleton_skull";
        MinecraftItemTypes2["SkeletonSpawnEgg"] = "minecraft:skeleton_spawn_egg";
        MinecraftItemTypes2["SkullBannerPattern"] = "minecraft:skull_banner_pattern";
        MinecraftItemTypes2["SkullPotterySherd"] = "minecraft:skull_pottery_sherd";
        MinecraftItemTypes2["Slime"] = "minecraft:slime";
        MinecraftItemTypes2["SlimeBall"] = "minecraft:slime_ball";
        MinecraftItemTypes2["SlimeSpawnEgg"] = "minecraft:slime_spawn_egg";
        MinecraftItemTypes2["SmallAmethystBud"] = "minecraft:small_amethyst_bud";
        MinecraftItemTypes2["SmallDripleafBlock"] = "minecraft:small_dripleaf_block";
        MinecraftItemTypes2["SmithingTable"] = "minecraft:smithing_table";
        MinecraftItemTypes2["Smoker"] = "minecraft:smoker";
        MinecraftItemTypes2["SmoothBasalt"] = "minecraft:smooth_basalt";
        MinecraftItemTypes2["SmoothQuartz"] = "minecraft:smooth_quartz";
        MinecraftItemTypes2["SmoothQuartzSlab"] = "minecraft:smooth_quartz_slab";
        MinecraftItemTypes2["SmoothQuartzStairs"] = "minecraft:smooth_quartz_stairs";
        MinecraftItemTypes2["SmoothRedSandstone"] = "minecraft:smooth_red_sandstone";
        MinecraftItemTypes2["SmoothRedSandstoneSlab"] = "minecraft:smooth_red_sandstone_slab";
        MinecraftItemTypes2["SmoothRedSandstoneStairs"] = "minecraft:smooth_red_sandstone_stairs";
        MinecraftItemTypes2["SmoothSandstone"] = "minecraft:smooth_sandstone";
        MinecraftItemTypes2["SmoothSandstoneSlab"] = "minecraft:smooth_sandstone_slab";
        MinecraftItemTypes2["SmoothSandstoneStairs"] = "minecraft:smooth_sandstone_stairs";
        MinecraftItemTypes2["SmoothStone"] = "minecraft:smooth_stone";
        MinecraftItemTypes2["SmoothStoneSlab"] = "minecraft:smooth_stone_slab";
        MinecraftItemTypes2["SnifferEgg"] = "minecraft:sniffer_egg";
        MinecraftItemTypes2["SnifferSpawnEgg"] = "minecraft:sniffer_spawn_egg";
        MinecraftItemTypes2["SnortPotterySherd"] = "minecraft:snort_pottery_sherd";
        MinecraftItemTypes2["SnoutArmorTrimSmithingTemplate"] = "minecraft:snout_armor_trim_smithing_template";
        MinecraftItemTypes2["Snow"] = "minecraft:snow";
        MinecraftItemTypes2["SnowGolemSpawnEgg"] = "minecraft:snow_golem_spawn_egg";
        MinecraftItemTypes2["SnowLayer"] = "minecraft:snow_layer";
        MinecraftItemTypes2["Snowball"] = "minecraft:snowball";
        MinecraftItemTypes2["SoulCampfire"] = "minecraft:soul_campfire";
        MinecraftItemTypes2["SoulLantern"] = "minecraft:soul_lantern";
        MinecraftItemTypes2["SoulSand"] = "minecraft:soul_sand";
        MinecraftItemTypes2["SoulSoil"] = "minecraft:soul_soil";
        MinecraftItemTypes2["SoulTorch"] = "minecraft:soul_torch";
        MinecraftItemTypes2["SpiderEye"] = "minecraft:spider_eye";
        MinecraftItemTypes2["SpiderSpawnEgg"] = "minecraft:spider_spawn_egg";
        MinecraftItemTypes2["SpireArmorTrimSmithingTemplate"] = "minecraft:spire_armor_trim_smithing_template";
        MinecraftItemTypes2["SplashPotion"] = "minecraft:splash_potion";
        MinecraftItemTypes2["Sponge"] = "minecraft:sponge";
        MinecraftItemTypes2["SporeBlossom"] = "minecraft:spore_blossom";
        MinecraftItemTypes2["SpruceBoat"] = "minecraft:spruce_boat";
        MinecraftItemTypes2["SpruceButton"] = "minecraft:spruce_button";
        MinecraftItemTypes2["SpruceChestBoat"] = "minecraft:spruce_chest_boat";
        MinecraftItemTypes2["SpruceDoor"] = "minecraft:spruce_door";
        MinecraftItemTypes2["SpruceFence"] = "minecraft:spruce_fence";
        MinecraftItemTypes2["SpruceFenceGate"] = "minecraft:spruce_fence_gate";
        MinecraftItemTypes2["SpruceHangingSign"] = "minecraft:spruce_hanging_sign";
        MinecraftItemTypes2["SpruceLeaves"] = "minecraft:spruce_leaves";
        MinecraftItemTypes2["SpruceLog"] = "minecraft:spruce_log";
        MinecraftItemTypes2["SprucePlanks"] = "minecraft:spruce_planks";
        MinecraftItemTypes2["SprucePressurePlate"] = "minecraft:spruce_pressure_plate";
        MinecraftItemTypes2["SpruceSapling"] = "minecraft:spruce_sapling";
        MinecraftItemTypes2["SpruceShelf"] = "minecraft:spruce_shelf";
        MinecraftItemTypes2["SpruceSign"] = "minecraft:spruce_sign";
        MinecraftItemTypes2["SpruceSlab"] = "minecraft:spruce_slab";
        MinecraftItemTypes2["SpruceStairs"] = "minecraft:spruce_stairs";
        MinecraftItemTypes2["SpruceTrapdoor"] = "minecraft:spruce_trapdoor";
        MinecraftItemTypes2["SpruceWood"] = "minecraft:spruce_wood";
        MinecraftItemTypes2["Spyglass"] = "minecraft:spyglass";
        MinecraftItemTypes2["SquidSpawnEgg"] = "minecraft:squid_spawn_egg";
        MinecraftItemTypes2["Stick"] = "minecraft:stick";
        MinecraftItemTypes2["StickyPiston"] = "minecraft:sticky_piston";
        MinecraftItemTypes2["Stone"] = "minecraft:stone";
        MinecraftItemTypes2["StoneAxe"] = "minecraft:stone_axe";
        MinecraftItemTypes2["StoneBrickSlab"] = "minecraft:stone_brick_slab";
        MinecraftItemTypes2["StoneBrickStairs"] = "minecraft:stone_brick_stairs";
        MinecraftItemTypes2["StoneBrickWall"] = "minecraft:stone_brick_wall";
        MinecraftItemTypes2["StoneBricks"] = "minecraft:stone_bricks";
        MinecraftItemTypes2["StoneButton"] = "minecraft:stone_button";
        MinecraftItemTypes2["StoneHoe"] = "minecraft:stone_hoe";
        MinecraftItemTypes2["StonePickaxe"] = "minecraft:stone_pickaxe";
        MinecraftItemTypes2["StonePressurePlate"] = "minecraft:stone_pressure_plate";
        MinecraftItemTypes2["StoneShovel"] = "minecraft:stone_shovel";
        MinecraftItemTypes2["StoneStairs"] = "minecraft:stone_stairs";
        MinecraftItemTypes2["StoneSword"] = "minecraft:stone_sword";
        MinecraftItemTypes2["StonecutterBlock"] = "minecraft:stonecutter_block";
        MinecraftItemTypes2["StraySpawnEgg"] = "minecraft:stray_spawn_egg";
        MinecraftItemTypes2["StriderSpawnEgg"] = "minecraft:strider_spawn_egg";
        MinecraftItemTypes2["String"] = "minecraft:string";
        MinecraftItemTypes2["StrippedAcaciaLog"] = "minecraft:stripped_acacia_log";
        MinecraftItemTypes2["StrippedAcaciaWood"] = "minecraft:stripped_acacia_wood";
        MinecraftItemTypes2["StrippedBambooBlock"] = "minecraft:stripped_bamboo_block";
        MinecraftItemTypes2["StrippedBirchLog"] = "minecraft:stripped_birch_log";
        MinecraftItemTypes2["StrippedBirchWood"] = "minecraft:stripped_birch_wood";
        MinecraftItemTypes2["StrippedCherryLog"] = "minecraft:stripped_cherry_log";
        MinecraftItemTypes2["StrippedCherryWood"] = "minecraft:stripped_cherry_wood";
        MinecraftItemTypes2["StrippedCrimsonHyphae"] = "minecraft:stripped_crimson_hyphae";
        MinecraftItemTypes2["StrippedCrimsonStem"] = "minecraft:stripped_crimson_stem";
        MinecraftItemTypes2["StrippedDarkOakLog"] = "minecraft:stripped_dark_oak_log";
        MinecraftItemTypes2["StrippedDarkOakWood"] = "minecraft:stripped_dark_oak_wood";
        MinecraftItemTypes2["StrippedJungleLog"] = "minecraft:stripped_jungle_log";
        MinecraftItemTypes2["StrippedJungleWood"] = "minecraft:stripped_jungle_wood";
        MinecraftItemTypes2["StrippedMangroveLog"] = "minecraft:stripped_mangrove_log";
        MinecraftItemTypes2["StrippedMangroveWood"] = "minecraft:stripped_mangrove_wood";
        MinecraftItemTypes2["StrippedOakLog"] = "minecraft:stripped_oak_log";
        MinecraftItemTypes2["StrippedOakWood"] = "minecraft:stripped_oak_wood";
        MinecraftItemTypes2["StrippedPaleOakLog"] = "minecraft:stripped_pale_oak_log";
        MinecraftItemTypes2["StrippedPaleOakWood"] = "minecraft:stripped_pale_oak_wood";
        MinecraftItemTypes2["StrippedSpruceLog"] = "minecraft:stripped_spruce_log";
        MinecraftItemTypes2["StrippedSpruceWood"] = "minecraft:stripped_spruce_wood";
        MinecraftItemTypes2["StrippedWarpedHyphae"] = "minecraft:stripped_warped_hyphae";
        MinecraftItemTypes2["StrippedWarpedStem"] = "minecraft:stripped_warped_stem";
        MinecraftItemTypes2["StructureBlock"] = "minecraft:structure_block";
        MinecraftItemTypes2["StructureVoid"] = "minecraft:structure_void";
        MinecraftItemTypes2["Sugar"] = "minecraft:sugar";
        MinecraftItemTypes2["SugarCane"] = "minecraft:sugar_cane";
        MinecraftItemTypes2["Sunflower"] = "minecraft:sunflower";
        MinecraftItemTypes2["SuspiciousGravel"] = "minecraft:suspicious_gravel";
        MinecraftItemTypes2["SuspiciousSand"] = "minecraft:suspicious_sand";
        MinecraftItemTypes2["SuspiciousStew"] = "minecraft:suspicious_stew";
        MinecraftItemTypes2["SweetBerries"] = "minecraft:sweet_berries";
        MinecraftItemTypes2["TadpoleBucket"] = "minecraft:tadpole_bucket";
        MinecraftItemTypes2["TadpoleSpawnEgg"] = "minecraft:tadpole_spawn_egg";
        MinecraftItemTypes2["TallDryGrass"] = "minecraft:tall_dry_grass";
        MinecraftItemTypes2["TallGrass"] = "minecraft:tall_grass";
        MinecraftItemTypes2["Target"] = "minecraft:target";
        MinecraftItemTypes2["TideArmorTrimSmithingTemplate"] = "minecraft:tide_armor_trim_smithing_template";
        MinecraftItemTypes2["TintedGlass"] = "minecraft:tinted_glass";
        MinecraftItemTypes2["Tnt"] = "minecraft:tnt";
        MinecraftItemTypes2["TntMinecart"] = "minecraft:tnt_minecart";
        MinecraftItemTypes2["Torch"] = "minecraft:torch";
        MinecraftItemTypes2["Torchflower"] = "minecraft:torchflower";
        MinecraftItemTypes2["TorchflowerSeeds"] = "minecraft:torchflower_seeds";
        MinecraftItemTypes2["TotemOfUndying"] = "minecraft:totem_of_undying";
        MinecraftItemTypes2["TraderLlamaSpawnEgg"] = "minecraft:trader_llama_spawn_egg";
        MinecraftItemTypes2["Trapdoor"] = "minecraft:trapdoor";
        MinecraftItemTypes2["TrappedChest"] = "minecraft:trapped_chest";
        MinecraftItemTypes2["TrialKey"] = "minecraft:trial_key";
        MinecraftItemTypes2["TrialSpawner"] = "minecraft:trial_spawner";
        MinecraftItemTypes2["Trident"] = "minecraft:trident";
        MinecraftItemTypes2["TripwireHook"] = "minecraft:tripwire_hook";
        MinecraftItemTypes2["TropicalFish"] = "minecraft:tropical_fish";
        MinecraftItemTypes2["TropicalFishBucket"] = "minecraft:tropical_fish_bucket";
        MinecraftItemTypes2["TropicalFishSpawnEgg"] = "minecraft:tropical_fish_spawn_egg";
        MinecraftItemTypes2["TubeCoral"] = "minecraft:tube_coral";
        MinecraftItemTypes2["TubeCoralBlock"] = "minecraft:tube_coral_block";
        MinecraftItemTypes2["TubeCoralFan"] = "minecraft:tube_coral_fan";
        MinecraftItemTypes2["Tuff"] = "minecraft:tuff";
        MinecraftItemTypes2["TuffBrickSlab"] = "minecraft:tuff_brick_slab";
        MinecraftItemTypes2["TuffBrickStairs"] = "minecraft:tuff_brick_stairs";
        MinecraftItemTypes2["TuffBrickWall"] = "minecraft:tuff_brick_wall";
        MinecraftItemTypes2["TuffBricks"] = "minecraft:tuff_bricks";
        MinecraftItemTypes2["TuffSlab"] = "minecraft:tuff_slab";
        MinecraftItemTypes2["TuffStairs"] = "minecraft:tuff_stairs";
        MinecraftItemTypes2["TuffWall"] = "minecraft:tuff_wall";
        MinecraftItemTypes2["TurtleEgg"] = "minecraft:turtle_egg";
        MinecraftItemTypes2["TurtleHelmet"] = "minecraft:turtle_helmet";
        MinecraftItemTypes2["TurtleScute"] = "minecraft:turtle_scute";
        MinecraftItemTypes2["TurtleSpawnEgg"] = "minecraft:turtle_spawn_egg";
        MinecraftItemTypes2["TwistingVines"] = "minecraft:twisting_vines";
        MinecraftItemTypes2["UndyedShulkerBox"] = "minecraft:undyed_shulker_box";
        MinecraftItemTypes2["Vault"] = "minecraft:vault";
        MinecraftItemTypes2["VerdantFroglight"] = "minecraft:verdant_froglight";
        MinecraftItemTypes2["VexArmorTrimSmithingTemplate"] = "minecraft:vex_armor_trim_smithing_template";
        MinecraftItemTypes2["VexSpawnEgg"] = "minecraft:vex_spawn_egg";
        MinecraftItemTypes2["VillagerSpawnEgg"] = "minecraft:villager_spawn_egg";
        MinecraftItemTypes2["VindicatorSpawnEgg"] = "minecraft:vindicator_spawn_egg";
        MinecraftItemTypes2["Vine"] = "minecraft:vine";
        MinecraftItemTypes2["WanderingTraderSpawnEgg"] = "minecraft:wandering_trader_spawn_egg";
        MinecraftItemTypes2["WardArmorTrimSmithingTemplate"] = "minecraft:ward_armor_trim_smithing_template";
        MinecraftItemTypes2["WardenSpawnEgg"] = "minecraft:warden_spawn_egg";
        MinecraftItemTypes2["WarpedButton"] = "minecraft:warped_button";
        MinecraftItemTypes2["WarpedDoor"] = "minecraft:warped_door";
        MinecraftItemTypes2["WarpedFence"] = "minecraft:warped_fence";
        MinecraftItemTypes2["WarpedFenceGate"] = "minecraft:warped_fence_gate";
        MinecraftItemTypes2["WarpedFungus"] = "minecraft:warped_fungus";
        MinecraftItemTypes2["WarpedFungusOnAStick"] = "minecraft:warped_fungus_on_a_stick";
        MinecraftItemTypes2["WarpedHangingSign"] = "minecraft:warped_hanging_sign";
        MinecraftItemTypes2["WarpedHyphae"] = "minecraft:warped_hyphae";
        MinecraftItemTypes2["WarpedNylium"] = "minecraft:warped_nylium";
        MinecraftItemTypes2["WarpedPlanks"] = "minecraft:warped_planks";
        MinecraftItemTypes2["WarpedPressurePlate"] = "minecraft:warped_pressure_plate";
        MinecraftItemTypes2["WarpedRoots"] = "minecraft:warped_roots";
        MinecraftItemTypes2["WarpedShelf"] = "minecraft:warped_shelf";
        MinecraftItemTypes2["WarpedSign"] = "minecraft:warped_sign";
        MinecraftItemTypes2["WarpedSlab"] = "minecraft:warped_slab";
        MinecraftItemTypes2["WarpedStairs"] = "minecraft:warped_stairs";
        MinecraftItemTypes2["WarpedStem"] = "minecraft:warped_stem";
        MinecraftItemTypes2["WarpedTrapdoor"] = "minecraft:warped_trapdoor";
        MinecraftItemTypes2["WarpedWartBlock"] = "minecraft:warped_wart_block";
        MinecraftItemTypes2["WaterBucket"] = "minecraft:water_bucket";
        MinecraftItemTypes2["Waterlily"] = "minecraft:waterlily";
        MinecraftItemTypes2["WaxedChiseledCopper"] = "minecraft:waxed_chiseled_copper";
        MinecraftItemTypes2["WaxedCopper"] = "minecraft:waxed_copper";
        MinecraftItemTypes2["WaxedCopperBars"] = "minecraft:waxed_copper_bars";
        MinecraftItemTypes2["WaxedCopperBulb"] = "minecraft:waxed_copper_bulb";
        MinecraftItemTypes2["WaxedCopperChain"] = "minecraft:waxed_copper_chain";
        MinecraftItemTypes2["WaxedCopperChest"] = "minecraft:waxed_copper_chest";
        MinecraftItemTypes2["WaxedCopperDoor"] = "minecraft:waxed_copper_door";
        MinecraftItemTypes2["WaxedCopperGolemStatue"] = "minecraft:waxed_copper_golem_statue";
        MinecraftItemTypes2["WaxedCopperGrate"] = "minecraft:waxed_copper_grate";
        MinecraftItemTypes2["WaxedCopperLantern"] = "minecraft:waxed_copper_lantern";
        MinecraftItemTypes2["WaxedCopperTrapdoor"] = "minecraft:waxed_copper_trapdoor";
        MinecraftItemTypes2["WaxedCutCopper"] = "minecraft:waxed_cut_copper";
        MinecraftItemTypes2["WaxedCutCopperSlab"] = "minecraft:waxed_cut_copper_slab";
        MinecraftItemTypes2["WaxedCutCopperStairs"] = "minecraft:waxed_cut_copper_stairs";
        MinecraftItemTypes2["WaxedExposedChiseledCopper"] = "minecraft:waxed_exposed_chiseled_copper";
        MinecraftItemTypes2["WaxedExposedCopper"] = "minecraft:waxed_exposed_copper";
        MinecraftItemTypes2["WaxedExposedCopperBars"] = "minecraft:waxed_exposed_copper_bars";
        MinecraftItemTypes2["WaxedExposedCopperBulb"] = "minecraft:waxed_exposed_copper_bulb";
        MinecraftItemTypes2["WaxedExposedCopperChain"] = "minecraft:waxed_exposed_copper_chain";
        MinecraftItemTypes2["WaxedExposedCopperChest"] = "minecraft:waxed_exposed_copper_chest";
        MinecraftItemTypes2["WaxedExposedCopperDoor"] = "minecraft:waxed_exposed_copper_door";
        MinecraftItemTypes2["WaxedExposedCopperGolemStatue"] = "minecraft:waxed_exposed_copper_golem_statue";
        MinecraftItemTypes2["WaxedExposedCopperGrate"] = "minecraft:waxed_exposed_copper_grate";
        MinecraftItemTypes2["WaxedExposedCopperLantern"] = "minecraft:waxed_exposed_copper_lantern";
        MinecraftItemTypes2["WaxedExposedCopperTrapdoor"] = "minecraft:waxed_exposed_copper_trapdoor";
        MinecraftItemTypes2["WaxedExposedCutCopper"] = "minecraft:waxed_exposed_cut_copper";
        MinecraftItemTypes2["WaxedExposedCutCopperSlab"] = "minecraft:waxed_exposed_cut_copper_slab";
        MinecraftItemTypes2["WaxedExposedCutCopperStairs"] = "minecraft:waxed_exposed_cut_copper_stairs";
        MinecraftItemTypes2["WaxedExposedLightningRod"] = "minecraft:waxed_exposed_lightning_rod";
        MinecraftItemTypes2["WaxedLightningRod"] = "minecraft:waxed_lightning_rod";
        MinecraftItemTypes2["WaxedOxidizedChiseledCopper"] = "minecraft:waxed_oxidized_chiseled_copper";
        MinecraftItemTypes2["WaxedOxidizedCopper"] = "minecraft:waxed_oxidized_copper";
        MinecraftItemTypes2["WaxedOxidizedCopperBars"] = "minecraft:waxed_oxidized_copper_bars";
        MinecraftItemTypes2["WaxedOxidizedCopperBulb"] = "minecraft:waxed_oxidized_copper_bulb";
        MinecraftItemTypes2["WaxedOxidizedCopperChain"] = "minecraft:waxed_oxidized_copper_chain";
        MinecraftItemTypes2["WaxedOxidizedCopperChest"] = "minecraft:waxed_oxidized_copper_chest";
        MinecraftItemTypes2["WaxedOxidizedCopperDoor"] = "minecraft:waxed_oxidized_copper_door";
        MinecraftItemTypes2["WaxedOxidizedCopperGolemStatue"] = "minecraft:waxed_oxidized_copper_golem_statue";
        MinecraftItemTypes2["WaxedOxidizedCopperGrate"] = "minecraft:waxed_oxidized_copper_grate";
        MinecraftItemTypes2["WaxedOxidizedCopperLantern"] = "minecraft:waxed_oxidized_copper_lantern";
        MinecraftItemTypes2["WaxedOxidizedCopperTrapdoor"] = "minecraft:waxed_oxidized_copper_trapdoor";
        MinecraftItemTypes2["WaxedOxidizedCutCopper"] = "minecraft:waxed_oxidized_cut_copper";
        MinecraftItemTypes2["WaxedOxidizedCutCopperSlab"] = "minecraft:waxed_oxidized_cut_copper_slab";
        MinecraftItemTypes2["WaxedOxidizedCutCopperStairs"] = "minecraft:waxed_oxidized_cut_copper_stairs";
        MinecraftItemTypes2["WaxedOxidizedLightningRod"] = "minecraft:waxed_oxidized_lightning_rod";
        MinecraftItemTypes2["WaxedWeatheredChiseledCopper"] = "minecraft:waxed_weathered_chiseled_copper";
        MinecraftItemTypes2["WaxedWeatheredCopper"] = "minecraft:waxed_weathered_copper";
        MinecraftItemTypes2["WaxedWeatheredCopperBars"] = "minecraft:waxed_weathered_copper_bars";
        MinecraftItemTypes2["WaxedWeatheredCopperBulb"] = "minecraft:waxed_weathered_copper_bulb";
        MinecraftItemTypes2["WaxedWeatheredCopperChain"] = "minecraft:waxed_weathered_copper_chain";
        MinecraftItemTypes2["WaxedWeatheredCopperChest"] = "minecraft:waxed_weathered_copper_chest";
        MinecraftItemTypes2["WaxedWeatheredCopperDoor"] = "minecraft:waxed_weathered_copper_door";
        MinecraftItemTypes2["WaxedWeatheredCopperGolemStatue"] = "minecraft:waxed_weathered_copper_golem_statue";
        MinecraftItemTypes2["WaxedWeatheredCopperGrate"] = "minecraft:waxed_weathered_copper_grate";
        MinecraftItemTypes2["WaxedWeatheredCopperLantern"] = "minecraft:waxed_weathered_copper_lantern";
        MinecraftItemTypes2["WaxedWeatheredCopperTrapdoor"] = "minecraft:waxed_weathered_copper_trapdoor";
        MinecraftItemTypes2["WaxedWeatheredCutCopper"] = "minecraft:waxed_weathered_cut_copper";
        MinecraftItemTypes2["WaxedWeatheredCutCopperSlab"] = "minecraft:waxed_weathered_cut_copper_slab";
        MinecraftItemTypes2["WaxedWeatheredCutCopperStairs"] = "minecraft:waxed_weathered_cut_copper_stairs";
        MinecraftItemTypes2["WaxedWeatheredLightningRod"] = "minecraft:waxed_weathered_lightning_rod";
        MinecraftItemTypes2["WayfinderArmorTrimSmithingTemplate"] = "minecraft:wayfinder_armor_trim_smithing_template";
        MinecraftItemTypes2["WeatheredChiseledCopper"] = "minecraft:weathered_chiseled_copper";
        MinecraftItemTypes2["WeatheredCopper"] = "minecraft:weathered_copper";
        MinecraftItemTypes2["WeatheredCopperBars"] = "minecraft:weathered_copper_bars";
        MinecraftItemTypes2["WeatheredCopperBulb"] = "minecraft:weathered_copper_bulb";
        MinecraftItemTypes2["WeatheredCopperChain"] = "minecraft:weathered_copper_chain";
        MinecraftItemTypes2["WeatheredCopperChest"] = "minecraft:weathered_copper_chest";
        MinecraftItemTypes2["WeatheredCopperDoor"] = "minecraft:weathered_copper_door";
        MinecraftItemTypes2["WeatheredCopperGolemStatue"] = "minecraft:weathered_copper_golem_statue";
        MinecraftItemTypes2["WeatheredCopperGrate"] = "minecraft:weathered_copper_grate";
        MinecraftItemTypes2["WeatheredCopperLantern"] = "minecraft:weathered_copper_lantern";
        MinecraftItemTypes2["WeatheredCopperTrapdoor"] = "minecraft:weathered_copper_trapdoor";
        MinecraftItemTypes2["WeatheredCutCopper"] = "minecraft:weathered_cut_copper";
        MinecraftItemTypes2["WeatheredCutCopperSlab"] = "minecraft:weathered_cut_copper_slab";
        MinecraftItemTypes2["WeatheredCutCopperStairs"] = "minecraft:weathered_cut_copper_stairs";
        MinecraftItemTypes2["WeatheredLightningRod"] = "minecraft:weathered_lightning_rod";
        MinecraftItemTypes2["Web"] = "minecraft:web";
        MinecraftItemTypes2["WeepingVines"] = "minecraft:weeping_vines";
        MinecraftItemTypes2["WetSponge"] = "minecraft:wet_sponge";
        MinecraftItemTypes2["Wheat"] = "minecraft:wheat";
        MinecraftItemTypes2["WheatSeeds"] = "minecraft:wheat_seeds";
        MinecraftItemTypes2["WhiteBundle"] = "minecraft:white_bundle";
        MinecraftItemTypes2["WhiteCandle"] = "minecraft:white_candle";
        MinecraftItemTypes2["WhiteCarpet"] = "minecraft:white_carpet";
        MinecraftItemTypes2["WhiteConcrete"] = "minecraft:white_concrete";
        MinecraftItemTypes2["WhiteConcretePowder"] = "minecraft:white_concrete_powder";
        MinecraftItemTypes2["WhiteDye"] = "minecraft:white_dye";
        MinecraftItemTypes2["WhiteGlazedTerracotta"] = "minecraft:white_glazed_terracotta";
        MinecraftItemTypes2["WhiteHarness"] = "minecraft:white_harness";
        MinecraftItemTypes2["WhiteShulkerBox"] = "minecraft:white_shulker_box";
        MinecraftItemTypes2["WhiteStainedGlass"] = "minecraft:white_stained_glass";
        MinecraftItemTypes2["WhiteStainedGlassPane"] = "minecraft:white_stained_glass_pane";
        MinecraftItemTypes2["WhiteTerracotta"] = "minecraft:white_terracotta";
        MinecraftItemTypes2["WhiteTulip"] = "minecraft:white_tulip";
        MinecraftItemTypes2["WhiteWool"] = "minecraft:white_wool";
        MinecraftItemTypes2["WildArmorTrimSmithingTemplate"] = "minecraft:wild_armor_trim_smithing_template";
        MinecraftItemTypes2["Wildflowers"] = "minecraft:wildflowers";
        MinecraftItemTypes2["WindCharge"] = "minecraft:wind_charge";
        MinecraftItemTypes2["WitchSpawnEgg"] = "minecraft:witch_spawn_egg";
        MinecraftItemTypes2["WitherRose"] = "minecraft:wither_rose";
        MinecraftItemTypes2["WitherSkeletonSkull"] = "minecraft:wither_skeleton_skull";
        MinecraftItemTypes2["WitherSkeletonSpawnEgg"] = "minecraft:wither_skeleton_spawn_egg";
        MinecraftItemTypes2["WitherSpawnEgg"] = "minecraft:wither_spawn_egg";
        MinecraftItemTypes2["WolfArmor"] = "minecraft:wolf_armor";
        MinecraftItemTypes2["WolfSpawnEgg"] = "minecraft:wolf_spawn_egg";
        MinecraftItemTypes2["WoodenAxe"] = "minecraft:wooden_axe";
        MinecraftItemTypes2["WoodenButton"] = "minecraft:wooden_button";
        MinecraftItemTypes2["WoodenDoor"] = "minecraft:wooden_door";
        MinecraftItemTypes2["WoodenHoe"] = "minecraft:wooden_hoe";
        MinecraftItemTypes2["WoodenPickaxe"] = "minecraft:wooden_pickaxe";
        MinecraftItemTypes2["WoodenPressurePlate"] = "minecraft:wooden_pressure_plate";
        MinecraftItemTypes2["WoodenShovel"] = "minecraft:wooden_shovel";
        MinecraftItemTypes2["WoodenSword"] = "minecraft:wooden_sword";
        MinecraftItemTypes2["WritableBook"] = "minecraft:writable_book";
        MinecraftItemTypes2["YellowBundle"] = "minecraft:yellow_bundle";
        MinecraftItemTypes2["YellowCandle"] = "minecraft:yellow_candle";
        MinecraftItemTypes2["YellowCarpet"] = "minecraft:yellow_carpet";
        MinecraftItemTypes2["YellowConcrete"] = "minecraft:yellow_concrete";
        MinecraftItemTypes2["YellowConcretePowder"] = "minecraft:yellow_concrete_powder";
        MinecraftItemTypes2["YellowDye"] = "minecraft:yellow_dye";
        MinecraftItemTypes2["YellowGlazedTerracotta"] = "minecraft:yellow_glazed_terracotta";
        MinecraftItemTypes2["YellowHarness"] = "minecraft:yellow_harness";
        MinecraftItemTypes2["YellowShulkerBox"] = "minecraft:yellow_shulker_box";
        MinecraftItemTypes2["YellowStainedGlass"] = "minecraft:yellow_stained_glass";
        MinecraftItemTypes2["YellowStainedGlassPane"] = "minecraft:yellow_stained_glass_pane";
        MinecraftItemTypes2["YellowTerracotta"] = "minecraft:yellow_terracotta";
        MinecraftItemTypes2["YellowWool"] = "minecraft:yellow_wool";
        MinecraftItemTypes2["ZoglinSpawnEgg"] = "minecraft:zoglin_spawn_egg";
        MinecraftItemTypes2["ZombieHead"] = "minecraft:zombie_head";
        MinecraftItemTypes2["ZombieHorseSpawnEgg"] = "minecraft:zombie_horse_spawn_egg";
        MinecraftItemTypes2["ZombiePigmanSpawnEgg"] = "minecraft:zombie_pigman_spawn_egg";
        MinecraftItemTypes2["ZombieSpawnEgg"] = "minecraft:zombie_spawn_egg";
        MinecraftItemTypes2["ZombieVillagerSpawnEgg"] = "minecraft:zombie_villager_spawn_egg";
        return MinecraftItemTypes2;
    })(MinecraftItemTypes || {});
    var MinecraftPotionDeliveryTypes = (MinecraftPotionDeliveryTypes2 => {
        MinecraftPotionDeliveryTypes2["Consume"] = "Consume";
        MinecraftPotionDeliveryTypes2["ThrownLingering"] = "ThrownLingering";
        MinecraftPotionDeliveryTypes2["ThrownSplash"] = "ThrownSplash";
        return MinecraftPotionDeliveryTypes2;
    })(MinecraftPotionDeliveryTypes || {});
    var MinecraftPotionEffectTypes = (MinecraftPotionEffectTypes2 => {
        MinecraftPotionEffectTypes2["Awkward"] = "minecraft:awkward";
        MinecraftPotionEffectTypes2["FireResistance"] = "minecraft:fire_resistance";
        MinecraftPotionEffectTypes2["Harming"] = "minecraft:harming";
        MinecraftPotionEffectTypes2["Healing"] = "minecraft:healing";
        MinecraftPotionEffectTypes2["Infested"] = "minecraft:infested";
        MinecraftPotionEffectTypes2["Invisibility"] = "minecraft:invisibility";
        MinecraftPotionEffectTypes2["Leaping"] = "minecraft:leaping";
        MinecraftPotionEffectTypes2["LongFireResistance"] = "minecraft:long_fire_resistance";
        MinecraftPotionEffectTypes2["LongInvisibility"] = "minecraft:long_invisibility";
        MinecraftPotionEffectTypes2["LongLeaping"] = "minecraft:long_leaping";
        MinecraftPotionEffectTypes2["LongMundane"] = "minecraft:long_mundane";
        MinecraftPotionEffectTypes2["LongNightvision"] = "minecraft:long_nightvision";
        MinecraftPotionEffectTypes2["LongPoison"] = "minecraft:long_poison";
        MinecraftPotionEffectTypes2["LongRegeneration"] = "minecraft:long_regeneration";
        MinecraftPotionEffectTypes2["LongSlowFalling"] = "minecraft:long_slow_falling";
        MinecraftPotionEffectTypes2["LongSlowness"] = "minecraft:long_slowness";
        MinecraftPotionEffectTypes2["LongStrength"] = "minecraft:long_strength";
        MinecraftPotionEffectTypes2["LongSwiftness"] = "minecraft:long_swiftness";
        MinecraftPotionEffectTypes2["LongTurtleMaster"] = "minecraft:long_turtle_master";
        MinecraftPotionEffectTypes2["LongWaterBreathing"] = "minecraft:long_water_breathing";
        MinecraftPotionEffectTypes2["LongWeakness"] = "minecraft:long_weakness";
        MinecraftPotionEffectTypes2["Mundane"] = "minecraft:mundane";
        MinecraftPotionEffectTypes2["Nightvision"] = "minecraft:nightvision";
        MinecraftPotionEffectTypes2["Oozing"] = "minecraft:oozing";
        MinecraftPotionEffectTypes2["Poison"] = "minecraft:poison";
        MinecraftPotionEffectTypes2["Regeneration"] = "minecraft:regeneration";
        MinecraftPotionEffectTypes2["SlowFalling"] = "minecraft:slow_falling";
        MinecraftPotionEffectTypes2["Slowness"] = "minecraft:slowness";
        MinecraftPotionEffectTypes2["Strength"] = "minecraft:strength";
        MinecraftPotionEffectTypes2["StrongHarming"] = "minecraft:strong_harming";
        MinecraftPotionEffectTypes2["StrongHealing"] = "minecraft:strong_healing";
        MinecraftPotionEffectTypes2["StrongLeaping"] = "minecraft:strong_leaping";
        MinecraftPotionEffectTypes2["StrongPoison"] = "minecraft:strong_poison";
        MinecraftPotionEffectTypes2["StrongRegeneration"] = "minecraft:strong_regeneration";
        MinecraftPotionEffectTypes2["StrongSlowness"] = "minecraft:strong_slowness";
        MinecraftPotionEffectTypes2["StrongStrength"] = "minecraft:strong_strength";
        MinecraftPotionEffectTypes2["StrongSwiftness"] = "minecraft:strong_swiftness";
        MinecraftPotionEffectTypes2["StrongTurtleMaster"] = "minecraft:strong_turtle_master";
        MinecraftPotionEffectTypes2["Swiftness"] = "minecraft:swiftness";
        MinecraftPotionEffectTypes2["Thick"] = "minecraft:thick";
        MinecraftPotionEffectTypes2["TurtleMaster"] = "minecraft:turtle_master";
        MinecraftPotionEffectTypes2["Water"] = "minecraft:water";
        MinecraftPotionEffectTypes2["WaterBreathing"] = "minecraft:water_breathing";
        MinecraftPotionEffectTypes2["Weakness"] = "minecraft:weakness";
        MinecraftPotionEffectTypes2["Weaving"] = "minecraft:weaving";
        MinecraftPotionEffectTypes2["WindCharged"] = "minecraft:wind_charged";
        MinecraftPotionEffectTypes2["Wither"] = "minecraft:wither";
        return MinecraftPotionEffectTypes2;
    })(MinecraftPotionEffectTypes || {});
    function guid() {
        const s4 = () => Math.floor((1 + Math.random()) * 65536).toString(16).substring(1);
        return s4() + s4() + "-" + s4() + "-" + s4() + "-" + s4() + "-" + s4() + s4() + s4();
    }
    const EDITOR_PREFIX = "editor::";
    function UniqueIdUtils_createUniqueEditorString(name) {
        if (name.startsWith(EDITOR_PREFIX)) {
            return name;
        }
        return EDITOR_PREFIX + name + "::" + guid();
    }
    var server_editor_private_bindings_x = y => {
        var x = {};
        __webpack_require__.d(x, y);
        return x;
    };
    var server_editor_private_bindings_y = x => () => x;
    const server_editor_private_bindings_namespaceObject = server_editor_private_bindings_x({
        ["EditorRealmsServiceAvailability"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_private_bindings_ae1d7ddf__.EditorRealmsServiceAvailability,
        ["ProjectRegionAvailabilityMode"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_private_bindings_ae1d7ddf__.ProjectRegionAvailabilityMode,
        ["RealmsWorldUploadResult"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_private_bindings_ae1d7ddf__.RealmsWorldUploadResult,
        ["editorInternal"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_private_bindings_ae1d7ddf__.editorInternal
    });
    function stringFromException(e) {
        if (typeof e === "string") {
            return e;
        } else if (typeof e === "object" && e !== null && "message" in e) {
            return e.message;
        }
        return "Unknown exception";
    }
    async function executeTickSafeOperation(context, logger, bounds, operation) {
        await RegionOperationHelper_executeTickSafeAsyncOperation(context, logger, bounds, operation);
    }
    async function RegionOperationHelper_executeTickSafeAsyncOperation(context, logger, bounds, operation) {
        if (!server_namespaceObject.BlockBoundingBoxUtils.isValid(bounds)) {
            throw new Error(`Invalid operation region bounds: ${JSON.stringify(bounds)}`);
        }
        let region = undefined;
        try {
            const regionManager = server_editor_private_bindings_namespaceObject.editorInternal.getPlayerServices(context.player).regionManager;
            region = regionManager.leaseRegion({
                extentX: {
                    min: bounds.min.x,
                    max: bounds.max.x
                },
                extentZ: {
                    min: bounds.min.z,
                    max: bounds.max.z
                },
                availabilityMode: server_editor_private_bindings_namespaceObject.ProjectRegionAvailabilityMode.Ticking
            });
            await region.waitUntilAvailable();
            const result = operation();
            if (result instanceof Promise) {
                await result;
            }
        } catch (e) {
            logger.error(`Failed to execute operation: ${stringFromException(e)}`);
        } finally {
            if (region) {
                region.dispose();
            }
        }
    }
    async function executeLargeOperationWithTransactionAndTicking(context, logger, transactionString, operation) {
        transactionString = createUniqueEditorString(transactionString);
        const selectionVolume = context.selectionManager.volume.get();
        const bounds = selectionVolume.getBoundingBox();
        if (!context.transactionManager.openTransaction(transactionString)) {
            throw Error("Failed to open transaction");
        }
        try {
            context.transactionManager.trackBlockChangeArea(bounds.min, bounds.max);
        } catch (e) {
            context.transactionManager.discardOpenTransaction();
            throw e;
        }
        await executeTickSafeAsyncOperation(context, logger, bounds, (async () => {
            await executeLargeOperation(selectionVolume, operation);
        })).catch((e => {
            context.transactionManager.discardOpenTransaction();
            throw e;
        })).then((() => {
            if (!context.transactionManager.commitOpenTransaction()) {
                throw Error("Failed to commit transaction");
            }
        }));
    }
    async function executeLargeOperationFromIteratorWithTransactionAndTicking(context, logger, bounds, blockLocationIterator, transactionString, operation) {
        transactionString = UniqueIdUtils_createUniqueEditorString(transactionString);
        if (!context.transactionManager.openTransaction(transactionString)) {
            throw Error("Failed to open transaction");
        }
        try {
            context.transactionManager.trackBlockChangeArea(bounds.min, bounds.max);
        } catch (e) {
            context.transactionManager.discardOpenTransaction();
            throw Error((0, server_editor_namespaceObject.stringFromException)(e));
        }
        await RegionOperationHelper_executeTickSafeAsyncOperation(context, logger, bounds, (async () => {
            await (0, server_editor_namespaceObject.executeLargeOperationFromIterator)(blockLocationIterator, operation).catch((e => {
                context.transactionManager.discardOpenTransaction();
                throw e;
            })).then((() => {
                if (!context.transactionManager.commitOpenTransaction()) {
                    throw Error("Failed to commit transaction");
                }
            }));
        }));
    }
    async function executeFunctionWithTransactionAndTicking(context, logger, volume, transactionString, operation) {
        transactionString = UniqueIdUtils_createUniqueEditorString(transactionString);
        let bounds;
        if (volume instanceof server_editor_namespaceObject.RelativeVolumeListBlockVolume) {
            bounds = volume.getBoundingBox();
        } else if (volume instanceof server_namespaceObject.BlockVolumeBase) {
            bounds = volume.getBoundingBox();
        } else {
            throw new Error("Invalid volume type");
        }
        if (!context.transactionManager.openTransaction(transactionString)) {
            throw Error("Failed to open transaction");
        }
        try {
            context.transactionManager.trackBlockChangeArea(bounds.min, bounds.max);
        } catch (e) {
            context.transactionManager.discardOpenTransaction();
            throw e;
        }
        await executeTickSafeOperation(context, logger, bounds, operation).catch((e => {
            context.transactionManager.discardOpenTransaction();
            throw e;
        })).then((() => {
            if (!context.transactionManager.commitOpenTransaction()) {
                throw Error("Failed to commit transaction");
            }
        }));
    }
    var lib = __webpack_require__(607);
    var direction_Direction;
    (function(Direction) {
        Direction[Direction["Forward"] = 0] = "Forward";
        Direction[Direction["Right"] = 1] = "Right";
        Direction[Direction["Back"] = 2] = "Back";
        Direction[Direction["Left"] = 3] = "Left";
        Direction[Direction["Up"] = 4] = "Up";
        Direction[Direction["Down"] = 5] = "Down";
    })(direction_Direction || (direction_Direction = {}));
    const directionLookup = {
        [direction_Direction.Forward]: lib.VECTOR3_FORWARD,
        [direction_Direction.Right]: lib.VECTOR3_LEFT,
        [direction_Direction.Back]: lib.VECTOR3_BACK,
        [direction_Direction.Left]: lib.VECTOR3_RIGHT,
        [direction_Direction.Up]: lib.VECTOR3_UP,
        [direction_Direction.Down]: lib.VECTOR3_DOWN
    };
    function direction_getRotationCorrectedDirection(rotationY, realDirection) {
        if (realDirection === direction_Direction.Up || realDirection === direction_Direction.Down) {
            return realDirection;
        }
        const directionQuadrant = Math.floor((rotationY + 405 + realDirection * 90) % 360 / 90);
        return directionQuadrant;
    }
    function getRotationCorrectedDirectionVector(rotationY, realDirection) {
        const relativeDirection = direction_getRotationCorrectedDirection(rotationY, realDirection);
        return directionLookup[relativeDirection];
    }
    function getDirectionVector(direction) {
        return directionLookup[direction];
    }
    function getScaledDirectionVector(direction, scaleValue) {
        const vec = Vector3Utils.scale(getDirectionVector(direction), scaleValue);
        return vec;
    }
    function shrinkVolumeAlongAbsoluteAxis(volume, direction, amount, worldBounds) {
        const bounds = volume.getBoundingBox();
        const size = server_namespaceObject.BlockBoundingBoxUtils.getSpan(bounds);
        const min = bounds.min;
        const max = bounds.max;
        switch (direction) {
          case direction_Direction.Up:
            {
                const span = size.y;
                if (span > 1) {
                    const clampAmount = Math.min(amount, span - 1);
                    const limit = worldBounds?.max.y ?? Infinity;
                    max.y = Math.min(max.y - clampAmount, limit);
                }
                break;
            }

          case direction_Direction.Down:
            {
                const span = size.y;
                if (span > 1) {
                    const clampAmount = Math.min(amount, span - 1);
                    const limit = worldBounds?.min.y ?? -Infinity;
                    min.y = Math.max(min.y + clampAmount, limit);
                }
                break;
            }

          case direction_Direction.Forward:
            {
                const span = size.z;
                if (span > 1) {
                    const clampAmount = Math.min(amount, span - 1);
                    const limit = worldBounds?.max.z ?? Infinity;
                    max.z = Math.min(max.z - clampAmount, limit);
                }
                break;
            }

          case direction_Direction.Back:
            {
                const span = size.z;
                if (span > 1) {
                    const clampAmount = Math.min(amount, span - 1);
                    const limit = worldBounds?.min.z ?? -Infinity;
                    min.z = Math.max(min.z + clampAmount, limit);
                }
                break;
            }

          case direction_Direction.Left:
            {
                const span = size.x;
                if (span > 1) {
                    const clampAmount = Math.min(amount, span - 1);
                    const limit = worldBounds?.max.x ?? Infinity;
                    max.x = Math.min(max.x - clampAmount, limit);
                }
                break;
            }

          case direction_Direction.Right:
            {
                const span = size.x;
                if (span > 1) {
                    const clampAmount = Math.min(amount, span - 1);
                    const limit = worldBounds?.min.x ?? -Infinity;
                    min.x = Math.max(min.x + clampAmount, limit);
                }
                break;
            }
        }
        return new server_namespaceObject.BlockVolume(min, max);
    }
    function shrinkVolumeAlongViewAxis(volume, rotationY, direction, amount, worldBounds) {
        const relativeDirection = direction_getRotationCorrectedDirection(rotationY, direction);
        return shrinkVolumeAlongAbsoluteAxis(volume, relativeDirection, amount, worldBounds);
    }
    function growVolumeAlongAbsoluteAxis(volume, direction, amount, worldBounds) {
        const bounds = volume.getBoundingBox();
        const size = server_namespaceObject.BlockBoundingBoxUtils.getSpan(bounds);
        const min = bounds.min;
        const max = bounds.max;
        const maxSize = server_editor_namespaceObject.editor.constants.maxSelectionSize;
        switch (direction) {
          case direction_Direction.Up:
            {
                const span = size.y;
                const maxAllowed = maxSize.y - span;
                const boundLimit = (worldBounds?.max.y ?? Infinity) - max.y;
                max.y += Math.min(amount, maxAllowed, boundLimit);
                break;
            }

          case direction_Direction.Down:
            {
                const span = size.y;
                const maxAllowed = maxSize.y - span;
                const boundLimit = min.y - (worldBounds?.min.y ?? -Infinity);
                min.y -= Math.min(amount, maxAllowed, boundLimit);
                break;
            }

          case direction_Direction.Forward:
            {
                const span = size.z;
                const maxAllowed = maxSize.z - span;
                const boundLimit = (worldBounds?.max.z ?? Infinity) - max.z;
                max.z += Math.min(amount, maxAllowed, boundLimit);
                break;
            }

          case direction_Direction.Back:
            {
                const span = size.z;
                const maxAllowed = maxSize.z - span;
                const boundLimit = min.z - (worldBounds?.min.z ?? -Infinity);
                min.z -= Math.min(amount, maxAllowed, boundLimit);
                break;
            }

          case direction_Direction.Left:
            {
                const span = size.x;
                const maxAllowed = maxSize.x - span;
                const boundLimit = (worldBounds?.max.x ?? Infinity) - max.x;
                max.x += Math.min(amount, maxAllowed, boundLimit);
                break;
            }

          case direction_Direction.Right:
            {
                const span = size.x;
                const maxAllowed = maxSize.x - span;
                const boundLimit = min.x - (worldBounds?.min.x ?? -Infinity);
                min.x -= Math.min(amount, maxAllowed, boundLimit);
                break;
            }
        }
        return new server_namespaceObject.BlockVolume(min, max);
    }
    function growVolumeAlongViewAxis(volume, rotationY, direction, amount, worldBounds) {
        const relativeDirection = direction_getRotationCorrectedDirection(rotationY, direction);
        return growVolumeAlongAbsoluteAxis(volume, relativeDirection, amount, worldBounds);
    }
    var AxisPlanes;
    (function(AxisPlanes) {
        AxisPlanes[AxisPlanes["XZ"] = 0] = "XZ";
        AxisPlanes[AxisPlanes["XY"] = 1] = "XY";
        AxisPlanes[AxisPlanes["YZ"] = 2] = "YZ";
    })(AxisPlanes || (AxisPlanes = {}));
    const axisNormalLookup = {
        [AxisPlanes.XZ]: lib.VECTOR3_UP,
        [AxisPlanes.XY]: lib.VECTOR3_FORWARD,
        [AxisPlanes.YZ]: lib.VECTOR3_LEFT
    };
    function getAxisNormal(axis) {
        return axisNormalLookup[axis];
    }
    function getRelativeXYAxisAsNormal(rotation) {
        const direction = getRotationCorrectedDirection(rotation, Direction.Forward);
        switch (direction) {
          case Direction.Forward:
          case Direction.Back:
            return axisNormalLookup[AxisPlanes.XY];

          case Direction.Right:
          case Direction.Left:
            return axisNormalLookup[AxisPlanes.YZ];

          default:
            throw new Error("Invalid quadrant");
        }
    }
    function intersectRayPlane(rayLocation, rayDirection, planeNormal, planeDistance) {
        const denominator = Vector3Utils.dot(rayDirection, planeNormal);
        if (denominator !== 0) {
            const t = -(Vector3Utils.dot(rayLocation, planeNormal) + planeDistance) / denominator;
            if (t < 0) {
                return undefined;
            }
            const scaledDirection = Vector3Utils.scale(rayDirection, t);
            const result = Vector3Utils.add(rayLocation, scaledDirection);
            return result;
        } else if (Vector3Utils.dot(planeNormal, rayLocation) + planeDistance === 0) {
            return rayLocation;
        }
        return undefined;
    }
    class Vector3Map {
        constructor(initialItems) {
            this._vector3Map = new Map;
            if (initialItems !== undefined) {
                for (let i = 0; i < initialItems.length; i++) {
                    this._vector3Map.set(`${initialItems[i].x},${initialItems[i].y},${initialItems[i].z}`, initialItems[i]);
                }
            }
        }
        add(newVec) {
            const key = `${newVec.x},${newVec.y},${newVec.z}`;
            if (!this._vector3Map.has(key)) {
                this._vector3Map.set(key, newVec);
            }
        }
        has(vec) {
            return this._vector3Map.has(`${vec.x},${vec.y},${vec.z}`);
        }
        remove(vec) {
            this._vector3Map.delete(`${vec.x},${vec.y},${vec.z}`);
        }
        get length() {
            return this._vector3Map.size;
        }
        get keys() {
            return this._vector3Map.keys();
        }
        get values() {
            return this._vector3Map.values();
        }
        get entries() {
            return this._vector3Map.entries();
        }
    }
    var CursorTargetMode;
    (function(CursorTargetMode) {
        CursorTargetMode[CursorTargetMode["Block"] = 0] = "Block";
        CursorTargetMode[CursorTargetMode["Face"] = 1] = "Face";
    })(CursorTargetMode || (CursorTargetMode = {}));
    var BlockPointType;
    (function(BlockPointType) {
        BlockPointType[BlockPointType["Normal"] = 0] = "Normal";
        BlockPointType[BlockPointType["Contour"] = 1] = "Contour";
    })(BlockPointType || (BlockPointType = {}));
    class BlockPoint {
        constructor(location, requestCursorTargetMode, requestGroundLevelAtLocation, blockPointOptions) {
            this._location = location;
            this._requestCursorTargetMode = requestCursorTargetMode;
            this._requestGroundLevelAtLocation = requestGroundLevelAtLocation;
            this._horizontalWeight = blockPointOptions?.horizontalWeight ?? 1;
            this._verticalWeight = blockPointOptions?.verticalWeight ?? 1;
            this._blockPointType = blockPointOptions?.blockPointType ?? BlockPointType.Normal;
            this._plot = {
                x: this._location.x,
                y: this._location.y,
                z: this._location.z
            };
            this._pointData = new Vector3Map;
            this.generatePoint();
        }
        get location() {
            return this._location;
        }
        get horizontalWeight() {
            return this._horizontalWeight;
        }
        get verticalWeight() {
            return this._verticalWeight;
        }
        get blockPointType() {
            return this._blockPointType;
        }
        get lineDataIterator() {
            return this._pointData.values;
        }
        movePoint(targetLocation) {
            if (!lib.Vector3Utils.equals(this._location, targetLocation)) {
                this._location = targetLocation;
                return this.generatePoint();
            }
            return {
                pointsAdded: [],
                pointsRemoved: []
            };
        }
        setWeights(newHorizontalWeight, newVerticalWeight) {
            let changed = false;
            if (newHorizontalWeight !== this._horizontalWeight) {
                this._horizontalWeight = newHorizontalWeight;
                changed = true;
            }
            if (newVerticalWeight !== this._verticalWeight) {
                this._verticalWeight = newVerticalWeight;
                changed = true;
            }
            if (changed) {
                return this.generatePoint();
            }
            return {
                pointsAdded: [],
                pointsRemoved: []
            };
        }
        setBlockPointType(newBlockPointType) {
            if (newBlockPointType !== this._blockPointType) {
                this._blockPointType = newBlockPointType;
                return this.generatePoint();
            }
            return {
                pointsAdded: [],
                pointsRemoved: []
            };
        }
        generatePoint() {
            this.updatePlot();
            return this.applyThickness();
        }
        updatePlot() {
            switch (this._blockPointType) {
              case BlockPointType.Normal:
                {
                    this._plot = {
                        x: this._location.x,
                        y: this._location.y,
                        z: this._location.z
                    };
                    break;
                }

              case BlockPointType.Contour:
                {
                    this.applySurfaceContour();
                    break;
                }

              default:
                break;
            }
        }
        applySurfaceContour() {
            const targetMode = this._requestCursorTargetMode();
            const offset = targetMode === CursorTargetMode.Block ? 0 : 1;
            const elevation = this._requestGroundLevelAtLocation(this._location);
            if (elevation !== Infinity) {
                this._plot = {
                    x: this._location.x,
                    y: elevation + offset,
                    z: this._location.z
                };
            }
        }
        applyThickness() {
            return this.updateData([ this._plot ]);
        }
        applyVerticalThickness() {
            const newPoints = new Vector3Map([ this._plot ]);
            if (this._blockPointType === BlockPointType.Contour) {
                for (let i = 1; i < this._verticalWeight; i++) {
                    const newPt = {
                        x: this._plot.x,
                        y: this._plot.y + i,
                        z: this._plot.z
                    };
                    if (!newPoints.has(newPt)) {
                        newPoints.add(newPt);
                    }
                }
            } else {
                for (let i = 2; i <= this._verticalWeight; i++) {
                    const offset = i % 2 === 0 ? i / 2 : -(i - 1) / 2;
                    const newPt = {
                        x: this._plot.x,
                        y: this._plot.y + offset,
                        z: this._plot.z
                    };
                    if (!newPoints.has(newPt)) {
                        newPoints.add(newPt);
                    }
                }
            }
            return newPoints;
        }
        applyHorizontalThicknessToVerticalResults(verticalResults) {
            const newXPoints = new Vector3Map;
            const newZPoints = new Vector3Map;
            for (const pt of verticalResults.values) {
                let newPt = pt;
                let off;
                if (!newXPoints.has(pt)) {
                    newXPoints.add(pt);
                }
                for (let i = 2; i <= this._horizontalWeight; i++) {
                    off = i % 2 === 0 ? i / 2 : -(i - 1) / 2;
                    newPt = {
                        x: pt.x + off,
                        y: pt.y,
                        z: pt.z
                    };
                    if (!newXPoints.has(newPt) && !verticalResults.has(newPt)) {
                        newXPoints.add(newPt);
                    }
                }
            }
            for (const pt of newXPoints.values) {
                let newPt;
                let off;
                for (let i = 2; i <= this._horizontalWeight; i++) {
                    off = i % 2 === 0 ? i / 2 : -(i - 1) / 2;
                    newPt = {
                        x: pt.x,
                        y: pt.y,
                        z: pt.z + off
                    };
                    if (!newXPoints.has(newPt) && !newZPoints.has(newPt) && !verticalResults.has(newPt)) {
                        newZPoints.add(newPt);
                    }
                }
            }
            return [ ...newXPoints.values, ...newZPoints.values ];
        }
        updateData(newData) {
            const toAdd = [];
            const toRemove = [];
            const newKeys = new Set;
            for (let i = 0; i < newData.length; i++) {
                if (!this._pointData.has(newData[i])) {
                    toAdd.push(newData[i]);
                }
                newKeys.add(`${newData[i].x},${newData[i].y},${newData[i].z}`);
            }
            for (const [dataKey, dataPoint] of this._pointData.entries) {
                if (!newKeys.has(dataKey)) {
                    toRemove.push(dataPoint);
                }
            }
            for (let i = 0; i < toRemove.length; i++) {
                this._pointData.remove(toRemove[i]);
            }
            for (let i = 0; i < toAdd.length; i++) {
                this._pointData.add(toAdd[i]);
            }
            return {
                pointsAdded: toAdd,
                pointsRemoved: toRemove
            };
        }
    }
    var BlockLineType;
    (function(BlockLineType) {
        BlockLineType[BlockLineType["Direct"] = 0] = "Direct";
        BlockLineType[BlockLineType["Staggered"] = 1] = "Staggered";
        BlockLineType[BlockLineType["DirectContour"] = 2] = "DirectContour";
        BlockLineType[BlockLineType["StaggeredContour"] = 3] = "StaggeredContour";
    })(BlockLineType || (BlockLineType = {}));
    class BlockLine {
        constructor(start, end, requestCursorTargetMode, requestGroundLevelAtLocation, blockLineOptions) {
            this._start = start;
            this._end = end;
            this._startData = blockLineOptions?.startData;
            this._endData = blockLineOptions?.endData;
            this._requestCursorTargetMode = requestCursorTargetMode;
            this._requestGroundLevelAtLocation = requestGroundLevelAtLocation;
            this._horizontalWeight = blockLineOptions?.horizontalWeight ?? 1;
            this._verticalWeight = blockLineOptions?.verticalWeight ?? 1;
            this._blockLineType = blockLineOptions?.blockLineType ?? BlockLineType.Direct;
            this._linePlot = [];
            this._lineData = new Vector3Map;
            void this.generateLine();
        }
        get start() {
            return this._start;
        }
        get end() {
            return this._end;
        }
        get horizontalWeight() {
            return this._horizontalWeight;
        }
        get verticalWeight() {
            return this._verticalWeight;
        }
        get blockLineType() {
            return this._blockLineType;
        }
        get lineDataIterator() {
            return this._lineData.values;
        }
        get linePlotIterator() {
            return this._linePlot.values();
        }
        teardown() {
            if (this._applyWeightsJobHandle !== undefined) {
                server_namespaceObject.system.clearJob(this._applyWeightsJobHandle);
            }
            if (this._applyHorizontalWeightsJobHandle !== undefined) {
                server_namespaceObject.system.clearJob(this._applyHorizontalWeightsJobHandle);
            }
        }
        async setStart(newStart, startData = undefined) {
            if (!lib.Vector3Utils.equals(this._start, newStart) || this._startData !== startData) {
                this._start = newStart;
                this._startData = startData;
                return this.generateLine();
            }
            return {
                pointsAdded: [],
                pointsRemoved: []
            };
        }
        async setEnd(newEnd, endData = undefined) {
            if (!lib.Vector3Utils.equals(this._end, newEnd) || this._endData !== endData) {
                this._end = newEnd;
                this._endData = endData;
                return this.generateLine();
            }
            return {
                pointsAdded: [],
                pointsRemoved: []
            };
        }
        async translateLine(translationVector) {
            let changed = false;
            const newStart = lib.Vector3Utils.add(this._start, translationVector);
            const newEnd = lib.Vector3Utils.add(this._end, translationVector);
            if (!lib.Vector3Utils.equals(this._start, newStart)) {
                this._start = newStart;
                changed = true;
            }
            if (!lib.Vector3Utils.equals(this._end, newEnd)) {
                this._end = newEnd;
                changed = true;
            }
            if (changed) {
                return this.generateLine();
            }
            return {
                pointsAdded: [],
                pointsRemoved: []
            };
        }
        async setWeights(newHorizontalWeight, newVerticalWeight) {
            let changed = false;
            if (newHorizontalWeight !== this._horizontalWeight) {
                this._horizontalWeight = newHorizontalWeight;
                changed = true;
            }
            if (newVerticalWeight !== this._verticalWeight) {
                this._verticalWeight = newVerticalWeight;
                changed = true;
            }
            if (changed) {
                return this.generateLine();
            }
            return {
                pointsAdded: [],
                pointsRemoved: []
            };
        }
        async setBlockLineType(newBlockLineType) {
            if (newBlockLineType !== this._blockLineType) {
                this._blockLineType = newBlockLineType;
                return this.generateLine();
            }
            return {
                pointsAdded: [],
                pointsRemoved: []
            };
        }
        async generateLine() {
            this.updatePlot();
            return await this.applyThickness();
        }
        updatePlot() {
            switch (this._blockLineType) {
              case BlockLineType.Direct:
                {
                    this.plotBresenhamLine3D();
                    break;
                }

              case BlockLineType.Staggered:
                {
                    this.plotManhattanLine3D();
                    break;
                }

              case BlockLineType.DirectContour:
                {
                    this.plotBresenhamLine3D();
                    this.applySurfaceContour();
                    break;
                }

              case BlockLineType.StaggeredContour:
                {
                    this.plotManhattanLine3D();
                    this.applySurfaceContour();
                    break;
                }

              default:
                break;
            }
        }
        plotBresenhamLine3D() {
            this._linePlot.length = 0;
            this._linePlot.push({
                x: this._start.x,
                y: this._start.y,
                z: this._start.z
            });
            const dx = Math.abs(this._end.x - this._start.x);
            const dy = Math.abs(this._end.y - this._start.y);
            const dz = Math.abs(this._end.z - this._start.z);
            const xs = this._end.x > this._start.x ? 1 : -1;
            const ys = this._end.y > this._start.y ? 1 : -1;
            const zs = this._end.z > this._start.z ? 1 : -1;
            if (dx >= dy && dx >= dz) {
                let p0 = 2 * dy - dx;
                let p1 = 2 * dz - dx;
                let x0 = this._start.x;
                let y0 = this._start.y;
                let z0 = this._start.z;
                while (x0 !== this._end.x) {
                    x0 += xs;
                    if (p0 >= 0) {
                        y0 += ys;
                        p0 -= 2 * dx;
                    }
                    if (p1 >= 0) {
                        z0 += zs;
                        p1 -= 2 * dx;
                    }
                    p0 += 2 * dy;
                    p1 += 2 * dz;
                    this._linePlot.push({
                        x: x0,
                        y: y0,
                        z: z0
                    });
                }
            } else if (dy >= dx && dy >= dz) {
                let p0 = 2 * dx - dy;
                let p1 = 2 * dz - dy;
                let y0 = this._start.y;
                let x0 = this._start.x;
                let z0 = this._start.z;
                while (y0 !== this._end.y) {
                    y0 += ys;
                    if (p0 >= 0) {
                        x0 += xs;
                        p0 -= 2 * dy;
                    }
                    if (p1 >= 0) {
                        z0 += zs;
                        p1 -= 2 * dy;
                    }
                    p0 += 2 * dx;
                    p1 += 2 * dz;
                    this._linePlot.push({
                        x: x0,
                        y: y0,
                        z: z0
                    });
                }
            } else {
                let p0 = 2 * dy - dz;
                let p1 = 2 * dx - dz;
                let z0 = this._start.z;
                let x0 = this._start.x;
                let y0 = this._start.y;
                while (z0 !== this._end.z) {
                    z0 += zs;
                    if (p0 >= 0) {
                        y0 += ys;
                        p0 -= 2 * dz;
                    }
                    if (p1 >= 0) {
                        x0 += xs;
                        p1 -= 2 * dz;
                    }
                    p0 += 2 * dy;
                    p1 += 2 * dx;
                    this._linePlot.push({
                        x: x0,
                        y: y0,
                        z: z0
                    });
                }
            }
        }
        plotManhattanLine3D() {
            this._linePlot.length = 0;
            let x = this._start.x;
            let y = this._start.y;
            let z = this._start.z;
            this._linePlot.push({
                x: this._start.x,
                y: this._start.y,
                z: this._start.z
            });
            while (x !== this._end.x || y !== this._end.y || z !== this._end.z) {
                if (x < this._end.x) {
                    x++;
                    this._linePlot.push({
                        x,
                        y,
                        z
                    });
                } else if (x > this._end.x) {
                    x--;
                    this._linePlot.push({
                        x,
                        y,
                        z
                    });
                }
                if (y < this._end.y) {
                    y++;
                    this._linePlot.push({
                        x,
                        y,
                        z
                    });
                } else if (y > this._end.y) {
                    y--;
                    this._linePlot.push({
                        x,
                        y,
                        z
                    });
                }
                if (z < this._end.z) {
                    z++;
                    this._linePlot.push({
                        x,
                        y,
                        z
                    });
                } else if (z > this._end.z) {
                    z--;
                    this._linePlot.push({
                        x,
                        y,
                        z
                    });
                }
            }
        }
        applySurfaceContour() {
            const contourResults = [];
            const visited = new Set;
            const targetMode = this._requestCursorTargetMode();
            const offset = targetMode === CursorTargetMode.Block ? 0 : 1;
            for (let i = 0; i < this._linePlot.length; i++) {
                const key = `${this._linePlot[i].x},${this._linePlot[i].z}`;
                if (!visited.has(key)) {
                    const elevation = this._requestGroundLevelAtLocation(this._linePlot[i]);
                    if (elevation !== Infinity) {
                        contourResults.push({
                            x: this._linePlot[i].x,
                            y: elevation + offset,
                            z: this._linePlot[i].z
                        });
                        visited.add(key);
                    }
                }
            }
            this._linePlot.length = 0;
            this._linePlot.push(...contourResults);
        }
        async applyThickness() {
            if (this._horizontalWeight === 1 && this._verticalWeight === 1 && !this._startData && !this._endData) {
                return this.updateData(this._linePlot);
            }
            const [verticalResults, horizontalWeightMap] = await this.applyVerticalThickness();
            const horizontalAndVerticalResults = await this.applyHorizontalThicknessToVerticalResults(verticalResults, horizontalWeightMap);
            return this.updateData(horizontalAndVerticalResults);
        }
        async applyVerticalThickness() {
            const newPoints = new Vector3Map(this._linePlot);
            const pointHorizontalWeightMap = new Map;
            const contourOperation = (index, blockPos) => {
                const [verticalWeight, horizontalWeight] = this.getWeightFromPointInLengthLinear(index);
                if (!pointHorizontalWeightMap.has(blockPos)) {
                    pointHorizontalWeightMap.set(blockPos, horizontalWeight);
                }
                for (let j = 1; j < verticalWeight; j++) {
                    const newPt = {
                        x: blockPos.x,
                        y: blockPos.y + j,
                        z: blockPos.z
                    };
                    if (!newPoints.has(newPt)) {
                        newPoints.add(newPt);
                    }
                    if (!pointHorizontalWeightMap.has(newPt)) {
                        pointHorizontalWeightMap.set(newPt, horizontalWeight);
                    }
                }
            };
            const nonContourOperation = (index, blockPos) => {
                const [verticalWeight, horizontalWeight] = this.getWeightFromPointInLengthLinear(index);
                if (!pointHorizontalWeightMap.has(blockPos)) {
                    pointHorizontalWeightMap.set(blockPos, horizontalWeight);
                }
                for (let j = 2; j <= verticalWeight; j++) {
                    const offset = j % 2 === 0 ? j / 2 : -(j - 1) / 2;
                    const newPt = {
                        x: blockPos.x,
                        y: blockPos.y + offset,
                        z: blockPos.z
                    };
                    if (!newPoints.has(newPt)) {
                        newPoints.add(newPt);
                    }
                    if (!pointHorizontalWeightMap.has(newPt)) {
                        pointHorizontalWeightMap.set(newPt, horizontalWeight);
                    }
                }
            };
            if (this._blockLineType === BlockLineType.DirectContour || this._blockLineType === BlockLineType.StaggeredContour) {
                await new Promise(((resolve, reject) => {
                    if (this._applyWeightsJobHandle) {
                        server_namespaceObject.system.clearJob(this._applyWeightsJobHandle);
                    }
                    this._applyWeightsJobHandle = server_namespaceObject.system.runJob(workerGeneratorLine(resolve, reject, this._linePlot, contourOperation));
                }));
            } else {
                await new Promise(((resolve, reject) => {
                    if (this._applyWeightsJobHandle) {
                        server_namespaceObject.system.clearJob(this._applyWeightsJobHandle);
                    }
                    this._applyWeightsJobHandle = server_namespaceObject.system.runJob(workerGeneratorLine(resolve, reject, this._linePlot, nonContourOperation));
                }));
            }
            return [ newPoints, pointHorizontalWeightMap ];
        }
        getWeightFromPointInLengthLinear(pos) {
            let verticalWeight = this._verticalWeight;
            const startVertWeight = this._startData?.verticalWeight ?? this._verticalWeight;
            const endVertWeight = this._endData?.verticalWeight ?? this._verticalWeight;
            let horizontalWeight = this._horizontalWeight;
            const startHoriWeight = this._startData?.horizontalWeight ?? this._horizontalWeight;
            const endHoriWeight = this._endData?.horizontalWeight ?? this._horizontalWeight;
            if (this._startData || this._endData) {
                if (endVertWeight === startVertWeight) {
                    verticalWeight = startVertWeight;
                } else {
                    const vertSteps = Math.abs(startVertWeight - endVertWeight) + 1;
                    const vertStep = Math.floor(pos / this._linePlot.length * vertSteps);
                    verticalWeight = startVertWeight < endVertWeight ? startVertWeight + vertStep : startVertWeight - vertStep;
                }
                if (endHoriWeight === startHoriWeight) {
                    horizontalWeight = startHoriWeight;
                } else {
                    const horiSteps = Math.abs(startHoriWeight - endHoriWeight) + 1;
                    const horiStep = Math.floor(pos / this._linePlot.length * horiSteps);
                    horizontalWeight = startHoriWeight < endHoriWeight ? startHoriWeight + horiStep : startHoriWeight - horiStep;
                }
            }
            return [ verticalWeight, horizontalWeight ];
        }
        async applyHorizontalThicknessToVerticalResults(verticalResults, horizontalWeightMap) {
            const newPoints = new Vector3Map;
            const dx = this._end.x - this._start.x;
            const dz = this._end.z - this._start.z;
            const absDx = Math.abs(dx);
            const absDz = Math.abs(dz);
            if (absDx !== absDz) {
                if (absDz > absDx) {
                    const operation = pt => {
                        let newPt;
                        let off;
                        const horizontalWeightEntry = horizontalWeightMap.get(pt);
                        const horizontalWeight = horizontalWeightEntry ? horizontalWeightEntry : 1;
                        for (let i = 2; i <= horizontalWeight; i++) {
                            off = i % 2 === 0 ? i / 2 : -(i - 1) / 2;
                            newPt = {
                                x: pt.x + off,
                                y: pt.y,
                                z: pt.z
                            };
                            if (!newPoints.has(newPt) && !verticalResults.has(newPt)) {
                                newPoints.add(newPt);
                            }
                        }
                    };
                    if (this._applyHorizontalWeightsJobHandle) {
                        server_namespaceObject.system.clearJob(this._applyHorizontalWeightsJobHandle);
                    }
                    await new Promise(((resolve, reject) => {
                        this._applyHorizontalWeightsJobHandle = server_namespaceObject.system.runJob(workerGeneratorMap(resolve, reject, verticalResults, operation));
                    }));
                } else {
                    const operation = pt => {
                        let newPt;
                        let off;
                        const horizontalWeightEntry = horizontalWeightMap.get(pt);
                        const horizontalWeight = horizontalWeightEntry ? horizontalWeightEntry : 1;
                        for (let i = 2; i <= horizontalWeight; i++) {
                            off = i % 2 === 0 ? i / 2 : -(i - 1) / 2;
                            newPt = {
                                x: pt.x,
                                y: pt.y,
                                z: pt.z + off
                            };
                            if (!newPoints.has(newPt) && !verticalResults.has(newPt)) {
                                newPoints.add(newPt);
                            }
                        }
                    };
                    if (this._applyHorizontalWeightsJobHandle) {
                        server_namespaceObject.system.clearJob(this._applyHorizontalWeightsJobHandle);
                    }
                    await new Promise(((resolve, reject) => {
                        this._applyHorizontalWeightsJobHandle = server_namespaceObject.system.runJob(workerGeneratorMap(resolve, reject, verticalResults, operation));
                    }));
                }
            } else {
                const sameSigns = dx < 0 && dz < 0 || dx >= 0 && dz >= 0;
                if (sameSigns) {
                    const operation = pt => {
                        let newPt;
                        let offX = 1;
                        let offZ = 0;
                        const horizontalWeightEntry = horizontalWeightMap.get(pt);
                        const horizontalWeight = horizontalWeightEntry ? horizontalWeightEntry : 1;
                        for (let i = 2; i <= horizontalWeight; i++) {
                            newPt = {
                                x: pt.x + offX,
                                y: pt.y,
                                z: pt.z + offZ
                            };
                            if (!newPoints.has(newPt) && !verticalResults.has(newPt)) {
                                newPoints.add(newPt);
                            }
                            newPt = {
                                x: pt.x + offZ,
                                y: pt.y,
                                z: pt.z + offX
                            };
                            if (!newPoints.has(newPt) && !verticalResults.has(newPt)) {
                                newPoints.add(newPt);
                            }
                            i % 2 === 0 ? offZ-- : offX++;
                        }
                    };
                    if (this._applyHorizontalWeightsJobHandle) {
                        server_namespaceObject.system.clearJob(this._applyHorizontalWeightsJobHandle);
                    }
                    await new Promise(((resolve, reject) => {
                        this._applyHorizontalWeightsJobHandle = server_namespaceObject.system.runJob(workerGeneratorMap(resolve, reject, verticalResults, operation));
                    }));
                } else {
                    const operation = pt => {
                        let newPt;
                        let isEven;
                        let offX = 0;
                        let offZ = 1;
                        const horizontalWeightEntry = horizontalWeightMap.get(pt);
                        const horizontalWeight = horizontalWeightEntry ? horizontalWeightEntry : 1;
                        for (let i = 2; i <= horizontalWeight; i++) {
                            isEven = i % 2 === 0;
                            newPt = {
                                x: isEven ? pt.x + offX : pt.x - offX,
                                y: pt.y,
                                z: isEven ? pt.z + offZ : pt.z - offZ
                            };
                            if (!newPoints.has(newPt) && !verticalResults.has(newPt)) {
                                newPoints.add(newPt);
                            }
                            newPt = {
                                x: isEven ? pt.x + offZ : pt.x - offZ,
                                y: pt.y,
                                z: isEven ? pt.z + offZ : pt.z - offZ
                            };
                            if (!newPoints.has(newPt) && !verticalResults.has(newPt)) {
                                newPoints.add(newPt);
                            }
                            if (!isEven) {
                                offX++;
                                offZ++;
                            }
                        }
                    };
                    if (this._applyHorizontalWeightsJobHandle) {
                        server_namespaceObject.system.clearJob(this._applyHorizontalWeightsJobHandle);
                    }
                    await new Promise(((resolve, reject) => {
                        this._applyHorizontalWeightsJobHandle = server_namespaceObject.system.runJob(workerGeneratorMap(resolve, reject, verticalResults, operation));
                    }));
                }
            }
            return [ ...verticalResults.values, ...newPoints.values ];
        }
        updateData(newData) {
            const toAdd = [];
            const toRemove = [];
            const newKeys = new Set;
            for (let i = 0; i < newData.length; i++) {
                if (!this._lineData.has(newData[i])) {
                    toAdd.push(newData[i]);
                }
                newKeys.add(`${newData[i].x},${newData[i].y},${newData[i].z}`);
            }
            for (const [dataKey, dataPoint] of this._lineData.entries) {
                if (!newKeys.has(dataKey)) {
                    toRemove.push(dataPoint);
                }
            }
            for (let i = 0; i < toRemove.length; i++) {
                this._lineData.remove(toRemove[i]);
            }
            for (let i = 0; i < toAdd.length; i++) {
                this._lineData.add(toAdd[i]);
            }
            return {
                pointsAdded: toAdd,
                pointsRemoved: toRemove
            };
        }
    }
    const MAX_WORKER_OPERATIONS = 1e3;
    function* workerGeneratorLine(jobCompleted, jobFailed, line, operation) {
        try {
            let opCount = 0;
            for (let i = 0; i < line.length; ++i) {
                operation(i, line[i]);
                ++opCount;
                if (opCount > MAX_WORKER_OPERATIONS) {
                    opCount = 0;
                    yield;
                }
            }
        } catch (e) {
            jobFailed(e);
        }
        jobCompleted();
    }
    function* workerGeneratorMap(jobCompleted, jobFailed, map, operation) {
        try {
            let opCount = 0;
            for (const pt of map.values) {
                operation(pt);
                ++opCount;
                if (opCount > MAX_WORKER_OPERATIONS) {
                    opCount = 0;
                    yield;
                }
            }
        } catch (e) {
            jobFailed(e);
        }
        jobCompleted();
    }
    class SimpleStateSelector {
        constructor(initialState) {
            this.state = initialState;
        }
        changeState(next, action, state, predicate) {
            if (state === undefined) {
                this.state = next;
                action();
                return true;
            }
            if (predicate === undefined) {
                throw Error("All optional arguments must be provided");
            }
            if (predicate && this.state === state) {
                action();
                this.state = next;
                return true;
            }
            return false;
        }
        getState() {
            return this.state;
        }
        resetState(initialState) {
            this.state = initialState;
        }
    }
    function calculateClipboardNormalizedAnchorValue(item, absolute) {
        const itemSize = item.size;
        if (itemSize.x < 1 || itemSize.y < 1 || itemSize.z < 1) {
            return lib.VECTOR3_ZERO;
        }
        const clamped = lib.Vector3Utils.clamp(absolute, {
            min: lib.VECTOR3_ZERO,
            max: lib.Vector3Utils.subtract(itemSize, lib.VECTOR3_ONE)
        });
        const x = itemSize.x <= 1 ? 0 : clamped.x * 2 / (itemSize.x - 1) - 1;
        const y = itemSize.y <= 1 ? 0 : clamped.y * 2 / (itemSize.y - 1) - 1;
        const z = itemSize.z <= 1 ? 0 : clamped.z * 2 / (itemSize.z - 1) - 1;
        return new lib.Vector3Builder(x, y, z);
    }
    function calculateClipboardAbsoluteAnchorValue(item) {
        const itemSize = item.size;
        const normalizedOrigin = item.normalizedOrigin;
        const x = Math.round((normalizedOrigin.x + 1) * ((itemSize.x - 1) / 2));
        const y = Math.round((normalizedOrigin.y + 1) * ((itemSize.y - 1) / 2));
        const z = Math.round((normalizedOrigin.z + 1) * ((itemSize.z - 1) / 2));
        return new lib.Vector3Builder(x, y, z);
    }
    var node_modules_buffer = __webpack_require__(945);
    function CreateBase64ImageFromRGB(rgbValues, width, height) {
        const HEADER_SIZE = 54;
        const DIB_HEADER_SIZE = 40;
        const PIXELS_PER_METER = 2835;
        const fileSize = HEADER_SIZE + 3 * width * height;
        const buffer = node_modules_buffer.lW.alloc(fileSize);
        buffer.write("BM");
        buffer.writeUInt32LE(fileSize, 2);
        buffer.writeUInt32LE(HEADER_SIZE, 10);
        buffer.writeUInt32LE(DIB_HEADER_SIZE, 14);
        buffer.writeInt32LE(width, 18);
        buffer.writeInt32LE(height, 22);
        buffer.writeUInt16LE(1, 26);
        buffer.writeUInt16LE(24, 28);
        buffer.writeUInt32LE(0, 30);
        buffer.writeUInt32LE(3 * width * height, 34);
        buffer.writeInt32LE(PIXELS_PER_METER, 38);
        buffer.writeInt32LE(PIXELS_PER_METER, 42);
        let offset = HEADER_SIZE;
        for (let y = height - 1; y >= 0; y--) {
            for (let x = 0; x < width; x++) {
                const idx = y * width + x;
                if (idx < rgbValues.length) {
                    const {r, g, b} = rgbValues[idx];
                    buffer.writeUInt8(b, offset);
                    buffer.writeUInt8(g, offset + 1);
                    buffer.writeUInt8(r, offset + 2);
                }
                offset += 3;
            }
        }
        return `data:image/bmp;base64,${buffer.toString("base64")}`;
    }
    function backupColors(extensionContext) {
        const cursorProperties = extensionContext.cursor.getProperties();
        const colorBackup = {};
        if (cursorProperties.fillColor) {
            colorBackup.cursorFillColor = cursorProperties.fillColor;
        }
        if (cursorProperties.outlineColor) {
            colorBackup.cursorOutlineColor = cursorProperties.outlineColor;
        }
        return colorBackup;
    }
    function restoreBackedUpColors(extensionContext, backedUpColors) {
        const cursorProperties = extensionContext.cursor.getProperties();
        if (!backedUpColors.cursorFillColor) {
            delete cursorProperties.fillColor;
        } else {
            cursorProperties.fillColor = backedUpColors.cursorFillColor;
        }
        if (!backedUpColors.cursorOutlineColor) {
            delete cursorProperties.outlineColor;
        } else {
            cursorProperties.outlineColor = backedUpColors.cursorOutlineColor;
        }
        extensionContext.cursor.setProperties(cursorProperties);
    }
    function getMapValueFromKey(map, key) {
        const value = map.get(key);
        if (value === undefined) {
            throw new Error(`Key ${String(key)} not found in map`);
        }
        return value;
    }
    function getMapKeyFromValue(map, value) {
        for (const [key, val] of map.entries()) {
            if (val === value) {
                return key;
            }
        }
        throw new Error(`Value ${String(value)} not found in map`);
    }
    function getEnumKeyByEnumValue(myEnum, enumValue) {
        const keys = Object.keys(myEnum);
        for (const key of keys) {
            if (myEnum[key] === enumValue) {
                return key;
            }
        }
        return "";
    }
    function capitalizeAndSpaceEnumName(currentString) {
        if (!currentString) {
            return "";
        }
        const isUpperCase = char => char === char.toUpperCase() && char !== char.toLowerCase();
        let result = currentString.charAt(0).toUpperCase();
        for (let i = 1; i < currentString.length; i++) {
            if (isUpperCase(currentString.charAt(i))) {
                result = result + " ";
            }
            result += currentString.charAt(i).toLowerCase();
        }
        return result;
    }
    function toBase64(input) {
        const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        let str = "";
        let i = 0;
        while (i < input.length) {
            const c1 = input.charCodeAt(i++);
            const c2 = input.charCodeAt(i++);
            const c3 = input.charCodeAt(i++);
            const e1 = c1 >> 2;
            const e2 = (c1 & 3) << 4 | c2 >> 4;
            const e3 = (c2 & 15) << 2 | c3 >> 6;
            const e4 = c3 & 63;
            if (isNaN(c2)) {
                str += chars.charAt(e1) + chars.charAt(e2) + "==";
            } else if (isNaN(c3)) {
                str += chars.charAt(e1) + chars.charAt(e2) + chars.charAt(e3) + "=";
            } else {
                str += chars.charAt(e1) + chars.charAt(e2) + chars.charAt(e3) + chars.charAt(e4);
            }
        }
        return str;
    }
    class CustomSet {
        constructor(hashFunction) {
            this.values = new Map;
            this.hashFunction = hashFunction;
        }
        add(value) {
            const hash = this.hashFunction(value);
            this.values.set(hash, value);
        }
        contains(value) {
            const hash = this.hashFunction(value);
            return this.values.has(hash);
        }
        delete(value) {
            const hash = this.hashFunction(value);
            this.values.delete(hash);
        }
        get size() {
            return this.values.size;
        }
        value(hash) {
            return this.values.get(hash);
        }
        forEach(callback) {
            this.values.forEach(callback);
        }
        clear() {
            this.values.clear();
        }
        get isEmpty() {
            return this.values.size === 0;
        }
        generateKey(value) {
            return this.hashFunction(value);
        }
    }
    const vec3HashFunction = v => {
        const prime1 = 73856093;
        const prime2 = 19349663;
        const prime3 = 83492791;
        return v.x * prime1 ^ v.y * prime2 ^ v.z * prime3;
    };
    class Vector3Set extends CustomSet {
        constructor() {
            super(vec3HashFunction);
        }
    }
    var ClockType;
    (function(ClockType) {
        ClockType[ClockType["CLOCK_24HR"] = 0] = "CLOCK_24HR";
        ClockType[ClockType["CLOCK_12HR"] = 1] = "CLOCK_12HR";
        ClockType[ClockType["MINECRAFT_CLOCK"] = 2] = "MINECRAFT_CLOCK";
    })(ClockType || (ClockType = {}));
    var TODDropDown;
    (function(TODDropDown) {
        TODDropDown[TODDropDown["Day"] = 1e3] = "Day";
        TODDropDown[TODDropDown["Noon"] = 6e3] = "Noon";
        TODDropDown[TODDropDown["Sunset"] = 12e3] = "Sunset";
        TODDropDown[TODDropDown["Night"] = 13e3] = "Night";
        TODDropDown[TODDropDown["Midnight"] = 18e3] = "Midnight";
        TODDropDown[TODDropDown["Sunrise"] = 23e3] = "Sunrise";
        TODDropDown[TODDropDown["None"] = 100001] = "None";
    })(TODDropDown || (TODDropDown = {}));
    const clockValues = [ {
        stringId: "resourcePack.editor.timeOfDay.24hrClock",
        index: ClockType.CLOCK_24HR
    }, {
        stringId: "resourcePack.editor.timeOfDay.12hrClock",
        index: ClockType.CLOCK_12HR
    }, {
        stringId: "resourcePack.editor.timeOfDay.minecraftClock",
        index: ClockType.MINECRAFT_CLOCK
    } ];
    const validPresets = [ {
        stringId: "resourcePack.editor.timeOfDay.dropDown.none",
        time: TODDropDown.None
    }, {
        stringId: "resourcePack.editor.timeOfDay.dropDown.day",
        time: TODDropDown.Day
    }, {
        stringId: "resourcePack.editor.timeOfDay.dropDown.noon",
        time: TODDropDown.Noon
    }, {
        stringId: "resourcePack.editor.timeOfDay.dropDown.sunset",
        time: TODDropDown.Sunset
    }, {
        stringId: "resourcePack.editor.timeOfDay.dropDown.night",
        time: TODDropDown.Night
    }, {
        stringId: "resourcePack.editor.timeOfDay.dropDown.midnight",
        time: TODDropDown.Midnight
    }, {
        stringId: "resourcePack.editor.timeOfDay.dropDown.sunrise",
        time: TODDropDown.Sunrise
    } ];
    const mcHoursPerTick = 1e3;
    const mcMinsPerTick = 16.6667;
    function convertTODToTime(timeOfDay, use24HrClock) {
        const _amStr = "A.M.";
        const _pmStr = "P.M.";
        let ampm = "";
        const isPM = timeOfDay >= server_namespaceObject.TimeOfDay.Noon && timeOfDay < server_namespaceObject.TimeOfDay.Midnight;
        if (!use24HrClock) {
            if (isPM) {
                ampm = " " + _pmStr;
            } else {
                ampm = " " + _amStr;
            }
        }
        let hours = (6 + Math.floor(timeOfDay / mcHoursPerTick)) % 24;
        let numZeroes = 2;
        if (!use24HrClock) {
            hours = hours % 12;
            hours = hours === 0 ? 12 : hours;
            numZeroes = 1;
        }
        const hourStr = hours.toString().padStart(numZeroes, "0");
        timeOfDay %= mcHoursPerTick;
        const minutes = Math.floor(timeOfDay / mcMinsPerTick);
        const minuteStr = minutes.toString().padStart(2, "0");
        return `${hourStr}:${minuteStr}${ampm}`;
    }
    function convertToTOD(hours, minutes) {
        hours -= 6;
        if (hours < 0) {
            hours = 24 - (6 + hours);
        }
        return hours * mcHoursPerTick + minutes * mcMinsPerTick;
    }
    function getInputMarkup(id, prefix, suffix) {
        let markupStart = "[*input|$id=" + id;
        if (prefix) {
            markupStart = markupStart.concat("|$format=", prefix, "*input");
        } else {
            markupStart = markupStart.concat("|$format=", "*input");
        }
        if (suffix) {
            markupStart = markupStart.concat(suffix);
        }
        return markupStart.concat("]");
    }
    const newLineMarkup = "[*newLine]";
    class SharedControlImpl {
        constructor(session, parentTool, parentPropertyPane, controlName, localizationPrefix) {
            this._session = session;
            this._parentTool = parentTool;
            this._parentPropertyPane = parentPropertyPane;
            this._controlName = controlName;
            this._isActive = false;
            this._isInitialized = false;
            this._localizationPrefix = localizationPrefix;
        }
        initialize() {
            this._isInitialized = true;
        }
        shutdown() {
            this._isInitialized = false;
        }
        activateControl() {
            if (!this._isInitialized) {
                throw new Error("Control must be initialized before it can be activated");
            }
            if (this._isActive) {
                throw new Error("Control is already active");
            }
            this._isActive = true;
        }
        deactivateControl() {
            if (!this._isActive) {
                throw new Error("Control is not active");
            }
            this._isActive = false;
        }
        registerToolKeyBinding(action, binding, tag) {
            this._parentTool.registerKeyBinding(action, binding, {
                uniqueId: `editor:${this._controlName}:${tag}`,
                label: `${this._localizationPrefix}.keybinding.${tag}.title`,
                tooltip: `${this._localizationPrefix}.keybinding.${tag}.tooltip`
            });
        }
        localize(key) {
            return `${this.localizationPrefix}.${key}`;
        }
        get session() {
            return this._session;
        }
        get propertyPane() {
            return this._parentPropertyPane;
        }
        get controlName() {
            return this._controlName;
        }
        get tool() {
            return this._parentTool;
        }
        get isActive() {
            return this._isActive;
        }
        get isInitialized() {
            return this._isInitialized;
        }
        get localizationPrefix() {
            return this._localizationPrefix;
        }
    }
    var ContiguousSelectionUtils_ContiguousSelectionType;
    (function(ContiguousSelectionType) {
        ContiguousSelectionType[ContiguousSelectionType["SameBlock"] = 0] = "SameBlock";
        ContiguousSelectionType[ContiguousSelectionType["BlockStates"] = 1] = "BlockStates";
        ContiguousSelectionType[ContiguousSelectionType["SolidBlock"] = 2] = "SolidBlock";
        ContiguousSelectionType[ContiguousSelectionType["AllBlocks"] = 3] = "AllBlocks";
        ContiguousSelectionType[ContiguousSelectionType["Custom"] = 4] = "Custom";
    })(ContiguousSelectionUtils_ContiguousSelectionType || (ContiguousSelectionUtils_ContiguousSelectionType = {}));
    function getBoundsForContiguousSelection(initialLocation, selectionDirection, size, isFace) {
        const faceSize = (size - 1) / 2;
        const from = {
            x: initialLocation.x - faceSize,
            y: initialLocation.y - faceSize,
            z: initialLocation.z - faceSize
        };
        const to = {
            x: initialLocation.x + faceSize,
            y: initialLocation.y + faceSize,
            z: initialLocation.z + faceSize
        };
        if (isFace) {
            switch (selectionDirection) {
              case Direction.Up:
              case Direction.Down:
                from.y = initialLocation.y;
                to.y = initialLocation.y;
                break;

              case Direction.North:
              case Direction.South:
                from.z = initialLocation.z;
                to.z = initialLocation.z;
                break;

              case Direction.East:
              case Direction.West:
                from.x = initialLocation.x;
                to.x = initialLocation.x;
                break;
            }
        } else {
            switch (selectionDirection) {
              case Direction.Up:
                from.y = initialLocation.y;
                to.y = initialLocation.y - (size - 1);
                break;

              case Direction.Down:
                from.y = initialLocation.y;
                to.y = initialLocation.y + (size - 1);
                break;

              case Direction.North:
                from.z = initialLocation.z;
                to.z = initialLocation.z + (size - 1);
                break;

              case Direction.South:
                from.z = initialLocation.z;
                to.z = initialLocation.z - (size - 1);
                break;

              case Direction.East:
                from.x = initialLocation.x;
                to.x = initialLocation.x - (size - 1);
                break;

              case Direction.West:
                from.x = initialLocation.x;
                to.x = initialLocation.x + (size - 1);
                break;
            }
        }
        return {
            from,
            to
        };
    }
    function isBlockExposedInDirection(dimension, targetLocation, direction) {
        const ExtrusionDirection = {
            x: 0,
            y: 0,
            z: 0
        };
        switch (direction) {
          case Direction.Up:
            ExtrusionDirection.y = 1;
            break;

          case Direction.Down:
            ExtrusionDirection.y = -1;
            break;

          case Direction.North:
            ExtrusionDirection.z = -1;
            break;

          case Direction.South:
            ExtrusionDirection.z = 1;
            break;

          case Direction.East:
            ExtrusionDirection.x = 1;
            break;

          case Direction.West:
            ExtrusionDirection.x = -1;
            break;
        }
        const blockToCheck = dimension.getBlock(Vector3Utils.add(targetLocation, ExtrusionDirection));
        if (blockToCheck === undefined) {
            return false;
        }
        switch (blockToCheck.typeId) {
          case MinecraftBlockTypes.Air.toString():
          case MinecraftBlockTypes.FlowingWater.toString():
          case MinecraftBlockTypes.Water.toString():
          case MinecraftBlockTypes.FlowingLava.toString():
          case MinecraftBlockTypes.Lava.toString():
            return true;

          default:
            return false;
        }
    }
    function getPositionKey(loc) {
        return [ loc.x, loc.y, loc.z ].join(",");
    }
    function getContiguousSelection(size, selectionDirection, block, isFace, fullSelectionToleranceLevel, checkForAdjacentFaceBlocks, contiguousSelectionType, contiguousSelectionBlockList) {
        const blockSelection = new Map;
        if (isFace && checkForAdjacentFaceBlocks === undefined) {
            return blockSelection;
        }
        if (!isFace && fullSelectionToleranceLevel === undefined) {
            return blockSelection;
        }
        if (contiguousSelectionType === ContiguousSelectionUtils_ContiguousSelectionType.Custom && contiguousSelectionBlockList === undefined) {
            return blockSelection;
        }
        if (block) {
            const limits = getBoundsForContiguousSelection(block.location, selectionDirection, size, isFace);
            const from = limits.from;
            const to = limits.to;
            let bounds = new BlockVolume(from, to);
            let furthestUp = block.location.y;
            let furthestDown = block.location.y;
            let furthestWest = block.location.x;
            let furthestEast = block.location.x;
            let furthestNorth = block.location.z;
            let furthestSouth = block.location.z;
            const searchOffsets = [];
            searchOffsets.push({
                x: 0,
                y: 0,
                z: 0
            });
            for (let x = -1; x <= 1; x += 2) {
                searchOffsets.push({
                    x,
                    y: 0,
                    z: 0
                });
            }
            for (let y = -1; y <= 1; y += 2) {
                searchOffsets.push({
                    x: 0,
                    y,
                    z: 0
                });
            }
            for (let z = -1; z <= 1; z += 2) {
                searchOffsets.push({
                    x: 0,
                    y: 0,
                    z
                });
            }
            const dimension = block.dimension;
            let fillStack = [];
            let hasAdjustedBounds = false;
            const outOfBoundsBlocks = [];
            const visitedBlocks = new Map;
            let initialTolerance = 0;
            if (isFace && checkForAdjacentFaceBlocks) {
                initialTolerance = 1;
            } else if (!isFace && fullSelectionToleranceLevel !== undefined) {
                initialTolerance = fullSelectionToleranceLevel - 1;
            }
            fillStack.push({
                position: block.location,
                tolerance: initialTolerance
            });
            visitedBlocks.set(getPositionKey(block.location), {
                checked: true,
                tolerance: initialTolerance
            });
            while (fillStack.length > 0 || !hasAdjustedBounds && isFace) {
                if (fillStack.length <= 0) {
                    if (furthestUp < Math.floor(to.y) && furthestDown === Math.floor(from.y)) {
                        from.y = furthestUp - (to.y - from.y);
                    } else if (furthestUp === Math.floor(to.y) && furthestDown > Math.floor(from.y)) {
                        to.y = furthestDown + (to.y - from.y);
                    }
                    if (furthestEast < Math.floor(to.x) && furthestWest === Math.floor(from.x)) {
                        from.x = furthestEast - (to.x - from.x);
                    } else if (furthestEast === Math.floor(to.x) && furthestWest > Math.floor(from.x)) {
                        to.x = furthestWest + (to.x - from.x);
                    }
                    if (furthestSouth === Math.floor(to.z) && furthestNorth > Math.floor(from.z)) {
                        to.z = furthestNorth + (to.z - from.z);
                    } else if (furthestSouth < Math.floor(to.z) && furthestNorth === Math.floor(from.z)) {
                        from.z = furthestSouth - (to.z - from.z);
                    }
                    fillStack = outOfBoundsBlocks;
                    bounds = new BlockVolume(from, to);
                    hasAdjustedBounds = true;
                }
                const checkBlock = fillStack.pop();
                if (checkBlock !== undefined) {
                    const loc = checkBlock.position;
                    visitedBlocks.set(getPositionKey(loc), {
                        checked: true,
                        tolerance: checkBlock.tolerance
                    });
                    if (loc === undefined || !bounds.isInside(loc)) continue;
                    let isContiguous = true;
                    try {
                        const blockAtLoc = dimension.getBlock(loc);
                        if (blockAtLoc !== undefined) {
                            if (!areBlocksContiguous(contiguousSelectionType, blockAtLoc, block, contiguousSelectionBlockList)) {
                                isContiguous = false;
                                if (checkBlock.tolerance <= 0) {
                                    continue;
                                }
                            }
                            if (isFace && !isBlockExposedInDirection(dimension, loc, selectionDirection)) {
                                isContiguous = false;
                                if (checkBlock.tolerance <= 0) {
                                    continue;
                                }
                            }
                        } else {
                            continue;
                        }
                    } catch {
                        continue;
                    }
                    let remainingTolerance = checkBlock.tolerance - 1;
                    if (isContiguous) {
                        if (loc.x < furthestWest) {
                            furthestWest = loc.x;
                        }
                        if (loc.x > furthestEast) {
                            furthestEast = loc.x;
                        }
                        if (loc.z < furthestNorth) {
                            furthestNorth = loc.z;
                        }
                        if (loc.z > furthestSouth) {
                            furthestSouth = loc.z;
                        }
                        if (loc.y < furthestDown) {
                            furthestDown = loc.y;
                        }
                        if (loc.y > furthestUp) {
                            furthestUp = loc.y;
                        }
                        blockSelection.set(Vector3Utils.toString(loc), loc);
                        remainingTolerance = initialTolerance;
                    }
                    for (const offset of searchOffsets) {
                        const offsetLoc = {
                            x: loc.x + offset.x,
                            y: loc.y + offset.y,
                            z: loc.z + offset.z
                        };
                        if (!bounds.isInside(offsetLoc)) {
                            outOfBoundsBlocks.push({
                                position: offsetLoc,
                                tolerance: remainingTolerance
                            });
                            continue;
                        }
                        const visitedBlock = visitedBlocks.get(getPositionKey(offsetLoc));
                        if (visitedBlock !== undefined) {
                            if (visitedBlock.tolerance >= remainingTolerance && visitedBlock.checked) {
                                continue;
                            }
                        }
                        fillStack.push({
                            position: offsetLoc,
                            tolerance: remainingTolerance
                        });
                        visitedBlocks.set(getPositionKey(offsetLoc), {
                            checked: false,
                            tolerance: remainingTolerance
                        });
                    }
                }
            }
        }
        return blockSelection;
    }
    function BlockUtils_areBlocksContiguous(contiguousSelectionType, blockToTest, blockToFollow, allowList) {
        switch (contiguousSelectionType) {
          case ContiguousSelectionType.SameBlock:
            if (blockToFollow !== undefined) {
                return isSameBlockType(blockToFollow, blockToTest);
            }
            break;

          case ContiguousSelectionType.BlockStates:
            if (blockToFollow !== undefined) {
                return isSameBlockAndProperties(blockToFollow, blockToTest);
            }
            break;

          case ContiguousSelectionType.SolidBlock:
            return isBlockSolid(blockToTest);

          case ContiguousSelectionType.AllBlocks:
            return isBlockNotAir(blockToTest);

          case ContiguousSelectionType.Custom:
            if (allowList !== undefined) {
                return isBlockTypeInSelectionList(blockToTest, allowList);
            }
            break;
        }
        return false;
    }
    function arraysAreEqual(a, b) {
        if (a === undefined || b === undefined) {
            return a === b;
        }
        return a.length === b.length && a.every(((value, index) => value === b[index]));
    }
    function convertBlockStringsToBlockType(blockString) {
        const blockTypes = [];
        for (let blockStringElement of blockString) {
            if (!blockStringElement.includes(":")) {
                blockStringElement = "minecraft:" + blockStringElement;
            }
            const blockType = server_namespaceObject.BlockTypes.get(blockStringElement);
            if (blockType) {
                blockTypes.push(blockType);
            }
        }
        return blockTypes;
    }
    function convertBlockStringsToSetOfBlockType(blockString) {
        const blockTypes = new Set;
        for (let blockStringElement of blockString) {
            if (!blockStringElement.includes(":")) {
                blockStringElement = "minecraft:" + blockStringElement;
            }
            const blockType = BlockTypes.get(blockStringElement);
            if (blockType) {
                blockTypes.add(blockType);
            }
        }
        return blockTypes;
    }
    function convertBlockTypesToBlockStrings(blockTypes) {
        const blockStrings = [];
        for (const blockType of blockTypes) {
            let blockName = blockType.id;
            if (blockName.startsWith("minecraft:")) {
                blockName = blockName.substring(10);
            }
            blockStrings.push(blockName);
        }
        return blockStrings;
    }
    function isBlockNotAir(block) {
        return block.typeId !== lib_vanilla_MinecraftBlockTypes.Air;
    }
    function isBlockSolid(block) {
        return block.isSolid;
    }
    function isSameBlockAndProperties(BlockA, BlockB) {
        if (!isSameBlockType(BlockA, BlockB)) {
            return false;
        }
        const BlockAPermutationProperties = BlockA.permutation.getAllStates();
        const BlockBPermutationProperties = BlockB.permutation.getAllStates();
        return JSON.stringify(BlockAPermutationProperties) === JSON.stringify(BlockBPermutationProperties);
    }
    function isSameBlockType(BlockA, BlockB) {
        return BlockA.typeId === BlockB.typeId;
    }
    function isBlockTypeInSelectionList(block, allowList) {
        if (allowList === undefined || allowList.size === 0) {
            return false;
        }
        const blockType = block.type;
        if (blockType === undefined) {
            return false;
        }
        for (const type of allowList) {
            if (type === blockType) {
                return true;
            }
        }
        return false;
    }
    const PROPERTY_BRUSHPAINTCONTROL_NAME = "BrushPaintControl";
    const PROPERTY_BRUSHPAINTCONTROL_BLOCKMASK_SETTINGS_MASK = `${PROPERTY_BRUSHPAINTCONTROL_NAME}:BlockMask:Mask`;
    const PROPERTY_BRUSHPAINTCONTROL_BLOCKMASK_SETTINGS_REPLACE = `${PROPERTY_BRUSHPAINTCONTROL_NAME}:BlockMask:Replace`;
    const PROPERTY_BRUSHPAINTCONTROL_LOCALIZATION_PREFIX = `resourcePack.editor.${PROPERTY_BRUSHPAINTCONTROL_NAME}`;
    var InternalMaskType;
    (function(InternalMaskType) {
        InternalMaskType[InternalMaskType["Disabled"] = 0] = "Disabled";
        InternalMaskType[InternalMaskType["Mask"] = 1] = "Mask";
        InternalMaskType[InternalMaskType["Replace"] = 2] = "Replace";
    })(InternalMaskType || (InternalMaskType = {}));
    var BrushPaintControlStringKeys;
    (function(BrushPaintControlStringKeys) {
        BrushPaintControlStringKeys["RootPaneTitle"] = "rootPane.title";
        BrushPaintControlStringKeys["RootPaneTooltip"] = "brushSettings.tooltip";
        BrushPaintControlStringKeys["BrushShapeSelectionTitle"] = "brush.title";
        BrushPaintControlStringKeys["BrushShapeSelectionTooltip"] = "brush.tooltip";
        BrushPaintControlStringKeys["OffsetTitle"] = "offset.title";
        BrushPaintControlStringKeys["OffsetTooltip"] = "offset.tooltip";
        BrushPaintControlStringKeys["BrushShapeSettingsTitle"] = "shapeSettings.title";
        BrushPaintControlStringKeys["BrushShapeSettingsTooltip"] = "shapeSettings.tooltip";
        BrushPaintControlStringKeys["FillConstraintsTitle"] = "fillConstraints.title";
        BrushPaintControlStringKeys["FillConstraintsTooltip"] = "fillConstraints.tooltip";
        BrushPaintControlStringKeys["MaskModeTitle"] = "fillConstraints.maskMode.title";
        BrushPaintControlStringKeys["MaskModeTooltip"] = "fillConstraints.maskMode.tooltip";
    })(BrushPaintControlStringKeys || (BrushPaintControlStringKeys = {}));
    class BrushPaintSharedControl extends SharedControlImpl {
        get isUIConstructed() {
            return this._brushSettingsSubPane !== undefined;
        }
        constructor(session, parentTool, parentPropertyPane, _brushSettings, _brushShapes, _options) {
            super(session, parentTool, parentPropertyPane, PROPERTY_BRUSHPAINTCONTROL_NAME, PROPERTY_BRUSHPAINTCONTROL_LOCALIZATION_PREFIX);
            this._brushShapes = _brushShapes;
            this._options = _options;
            this._selectedBrushIndex = (0, server_editor_namespaceObject.makeObservable)(0);
            this._internalMaskType = (0, server_editor_namespaceObject.makeObservable)(InternalMaskType.Disabled);
            this._brushSettingsCollection = [];
            this._brushShapeOffset = (0, server_editor_namespaceObject.makeObservable)({
                x: 0,
                y: 0,
                z: 0
            });
            this._brushControlRootPane = undefined;
            this._brushSettingsSubPane = undefined;
            this._customSettingsSubPane = undefined;
            this._fillConstraintsSubPane = undefined;
            this._fillReplaceSubPane = undefined;
            this._fillMaskSubPane = undefined;
            this._blockListReplaceIds = (0, server_editor_namespaceObject.makeObservable)([]);
            this._blockListReplace = [];
            this._blockListMaskIds = (0, server_editor_namespaceObject.makeObservable)([]);
            this._blockListMask = [];
            this._updateSettingsOperations = [];
            this._updateSettingsOperationTickHandle = undefined;
            this._editorMode = server_editor_namespaceObject.EditorMode.Tool;
            this._needsRefresh = false;
            this._brushSettings = _brushSettings;
            if (this._options?.locOverride) {
                this._locFunction = key => this._options?.locOverride?.get(key) ?? this.localize(key);
            } else {
                this._locFunction = key => this.localize(key);
            }
        }
        initialize() {
            super.initialize();
            this._blockListMask = this._loadBlockMask(PROPERTY_BRUSHPAINTCONTROL_BLOCKMASK_SETTINGS_MASK, convertBlockStringsToBlockType([ "air" ]));
            this._blockListReplace = this._loadBlockMask(PROPERTY_BRUSHPAINTCONTROL_BLOCKMASK_SETTINGS_REPLACE, convertBlockStringsToBlockType([ "air" ]));
            if (!this.tool) {
                throw new Error("SharedControl tool is not set");
            }
            const offsetNudgeUpAction = this.session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this._nudgeOffset(lib.VECTOR3_UP);
                }
            });
            const offsetNudgeDownAction = this.session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this._nudgeOffset(lib.VECTOR3_DOWN);
                }
            });
            const offsetNudgeForwardAction = this.session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const nudgeVector = this._getRelativeNudgeDirection(direction_Direction.Forward);
                    this._nudgeOffset(nudgeVector);
                }
            });
            const offsetNudgeBackAction = this.session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const nudgeVector = this._getRelativeNudgeDirection(direction_Direction.Back);
                    this._nudgeOffset(nudgeVector);
                }
            });
            const offsetNudgeLeftAction = this.session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const nudgeVector = this._getRelativeNudgeDirection(direction_Direction.Left);
                    this._nudgeOffset(nudgeVector);
                }
            });
            const offsetNudgeRightAction = this.session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const nudgeVector = this._getRelativeNudgeDirection(direction_Direction.Right);
                    this._nudgeOffset(nudgeVector);
                }
            });
            this.registerToolKeyBinding(offsetNudgeUpAction, {
                key: server_editor_namespaceObject.KeyboardKey.PAGE_UP,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, "nudgeOffsetUp");
            this.registerToolKeyBinding(offsetNudgeDownAction, {
                key: server_editor_namespaceObject.KeyboardKey.PAGE_DOWN,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, "nudgeOffsetDown");
            this.registerToolKeyBinding(offsetNudgeForwardAction, {
                key: server_editor_namespaceObject.KeyboardKey.UP,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, "nudgeOffsetForward");
            this.registerToolKeyBinding(offsetNudgeBackAction, {
                key: server_editor_namespaceObject.KeyboardKey.DOWN,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, "nudgeOffsetBack");
            this.registerToolKeyBinding(offsetNudgeLeftAction, {
                key: server_editor_namespaceObject.KeyboardKey.LEFT,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, "nudgeOffsetLeft");
            this.registerToolKeyBinding(offsetNudgeRightAction, {
                key: server_editor_namespaceObject.KeyboardKey.RIGHT,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, "nudgeOffsetRight");
            const cycleMaskAction = this.session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    switch (this._internalMaskType.value) {
                      case InternalMaskType.Mask:
                        this._internalMaskType.set(InternalMaskType.Replace);
                        break;

                      case InternalMaskType.Disabled:
                        this._internalMaskType.set(InternalMaskType.Mask);
                        break;

                      case InternalMaskType.Replace:
                      default:
                        this._internalMaskType.set(InternalMaskType.Disabled);
                    }
                    this._switchBrushMaskPanes();
                    this._setBrushMask();
                }
            });
            this.registerToolKeyBinding(cycleMaskAction, {
                key: server_editor_namespaceObject.KeyboardKey.KEY_M
            }, "maskMask");
        }
        shutdown() {
            super.shutdown();
            this._brushControlRootPane = undefined;
            this._brushSettingsSubPane = undefined;
            this._customSettingsSubPane = undefined;
            this._fillConstraintsSubPane = undefined;
            this._fillReplaceSubPane = undefined;
            this._fillMaskSubPane = undefined;
        }
        activateControl() {
            super.activateControl();
            this._modeChangeEventSubscriptionHandle = this.session.extensionContext.afterEvents.modeChange.subscribe((event => {
                this._editorMode = event.mode;
                if (this._editorMode === server_editor_namespaceObject.EditorMode.Tool) {
                    if (this.isActive) {
                        this.activateVisualization();
                    } else {
                        this.deactivateVisualization();
                    }
                } else {
                    this.deactivateVisualization();
                }
            }));
            this._brushShapeOffset.set(this.session.extensionContext.brushShapeManager.getBrushShapeOffset());
            this._constructControlUI();
            this._setupBrushModeAndType();
            this._updateSettingsOperationTickHandle = server_namespaceObject.system.runInterval((() => {
                this._runUpdateOperation();
            }), 20);
            this._brushControlRootPane?.show();
            this._setBrushVolume();
            this.activateVisualization();
        }
        deactivateControl() {
            super.deactivateControl();
            this._needsRefresh = false;
            if (this._modeChangeEventSubscriptionHandle) {
                this.session.extensionContext.afterEvents.modeChange.unsubscribe(this._modeChangeEventSubscriptionHandle);
                this._modeChangeEventSubscriptionHandle = undefined;
            }
            this.deactivateVisualization();
            this._destroyControlUI();
            if (this._updateSettingsOperationTickHandle !== undefined) {
                server_namespaceObject.system.clearRun(this._updateSettingsOperationTickHandle);
            }
            this._brushControlRootPane?.hide();
        }
        activateVisualization() {
            this.session.extensionContext.brushShapeManager.activateBrushTool();
            this._setBrushVolume();
            this._setBrushMask();
            this._switchBrushMaskPanes();
        }
        showVisualization() {
            this.session.extensionContext.brushShapeManager.setBrushShapeVisible(true);
        }
        deactivateVisualization() {
            this.session.extensionContext.brushShapeManager.deactivateBrushTool();
        }
        hideVisualization() {
            this.session.extensionContext.brushShapeManager.setBrushShapeVisible(false);
        }
        switchBrushPaintMode(paintMode) {
            this._brushSettings.paintMode = paintMode;
            this.session.extensionContext.brushShapeManager.switchBrushPaintMode(paintMode);
        }
        updateBrushShapes(shapes) {
            this._brushShapes = shapes;
            if (this._brushShapeDropdown) {
                this._brushShapeDropdown.updateEntries(this._getBrushShapeDropdownEntries());
            }
            if (this.isActive) {
                this._setBrushVolume();
            }
        }
        _setupBrushModeAndType() {
            const paintMode = this._brushSettings.paintMode;
            this.session.extensionContext.brushShapeManager.switchBrushPaintMode(paintMode);
        }
        _destroyControlUI() {
            if (this._brushControlRootPane) {
                this.propertyPane.removeSubPane(this._brushControlRootPane);
                this._brushControlRootPane = undefined;
            }
        }
        _constructControlUI() {
            if (this._brushShapes.length === 0) {
                throw new Error(`${this.controlName} - No brush shapes found`);
            }
            if (this._brushControlRootPane) {
                this._destroyControlUI();
            }
            this._brushControlRootPane = this.propertyPane.createSubPane({
                title: this._locFunction(BrushPaintControlStringKeys.RootPaneTitle),
                infoTooltip: {
                    title: this._locFunction(BrushPaintControlStringKeys.RootPaneTitle),
                    description: [ this._locFunction(BrushPaintControlStringKeys.RootPaneTooltip) ]
                },
                hasMargins: this._options?.hasPaneMargins
            });
            {
                if (this._brushShapes.length > 1) {
                    this._brushShapeDropdown = this._brushControlRootPane.addDropdown(this._selectedBrushIndex, {
                        title: this._locFunction(BrushPaintControlStringKeys.BrushShapeSelectionTitle),
                        tooltip: this._locFunction(BrushPaintControlStringKeys.BrushShapeSelectionTooltip),
                        entries: this._getBrushShapeDropdownEntries(),
                        onChange: () => {
                            this._setBrushVolume();
                            this._updateSettingsSubPane();
                        }
                    });
                } else {
                    this._brushShapeDropdown = undefined;
                }
                this._brushShapeOffset.set(this.session.extensionContext.brushShapeManager.getBrushShapeOffset());
                this._brushControlRootPane.addVector3(this._brushShapeOffset, {
                    title: this._locFunction(BrushPaintControlStringKeys.OffsetTitle),
                    tooltip: this._locFunction(BrushPaintControlStringKeys.OffsetTooltip),
                    isInteger: true,
                    min: BrushPaintSharedControl.MIN_OFFSET,
                    max: BrushPaintSharedControl.MAX_OFFSET,
                    onChange: newValue => {
                        this.session.extensionContext.brushShapeManager.setBrushShapeOffset(newValue);
                    }
                });
            }
            this._brushSettingsSubPane = this._brushControlRootPane.createSubPane({
                title: this._locFunction(BrushPaintControlStringKeys.BrushShapeSettingsTitle),
                infoTooltip: {
                    title: this._locFunction(BrushPaintControlStringKeys.BrushShapeSettingsTitle),
                    description: [ this._locFunction(BrushPaintControlStringKeys.BrushShapeSettingsTooltip) ]
                }
            });
            this._updateSettingsSubPane();
            this._fillConstraintsSubPane = this._brushControlRootPane.createSubPane({
                title: this._locFunction(BrushPaintControlStringKeys.FillConstraintsTitle),
                infoTooltip: {
                    title: this._locFunction(BrushPaintControlStringKeys.FillConstraintsTitle),
                    description: [ this._locFunction(BrushPaintControlStringKeys.FillConstraintsTooltip) ]
                }
            });
            this._fillConstraintsSubPane.addToggleGroup(this._internalMaskType, {
                title: this._locFunction(BrushPaintControlStringKeys.MaskModeTitle),
                tooltip: this._locFunction(BrushPaintControlStringKeys.MaskModeTooltip),
                entries: [ {
                    value: InternalMaskType.Disabled,
                    icon: "squareIcon",
                    tooltip: {
                        title: {
                            id: this.localize("fillConstraints.maskMode.disabled"),
                            props: [ getInputMarkup("editor:BrushPaintControl:maskMask", "[", "]") ]
                        },
                        description: {
                            id: this.localize("fillConstraints.maskMode.disabled.tooltip"),
                            props: [ newLineMarkup + newLineMarkup, getInputMarkup("editor:BrushPaintControl:maskMask", "[", "]") ]
                        }
                    }
                }, {
                    label: {
                        id: this.localize("fillConstraints.maskMode.mask"),
                        props: [ getInputMarkup("editor:BrushPaintControl:maskMask", "[", "]") ]
                    },
                    value: InternalMaskType.Mask,
                    icon: "pack://textures/editor/mask.png",
                    tooltip: {
                        id: this.localize("fillConstraints.maskMode.mask.tooltip"),
                        props: [ newLineMarkup + newLineMarkup, getInputMarkup("editor:BrushPaintControl:maskMask", "[", "]") ]
                    }
                }, {
                    label: {
                        id: this.localize("fillConstraints.maskMode.replace"),
                        props: [ getInputMarkup("editor:BrushPaintControl:maskMask", "[", "]") ]
                    },
                    value: InternalMaskType.Replace,
                    icon: "pack://textures/editor/replace.png",
                    tooltip: {
                        id: this.localize("fillConstraints.replace.tooltip"),
                        props: [ newLineMarkup + newLineMarkup, getInputMarkup("editor:BrushPaintControl:maskMask", "[", "]") ]
                    }
                } ],
                onChange: () => {
                    this._switchBrushMaskPanes();
                    this._setBrushMask();
                }
            });
            {
                this._fillReplaceSubPane = this._fillConstraintsSubPane.createSubPane({
                    title: this.localize("fillConstraints.replace.title")
                });
                this._blockListReplaceIds.set(convertBlockTypesToBlockStrings(this._blockListReplace));
                this._fillReplaceSubPane?.addBlockList(this._blockListReplaceIds, {
                    onChange: newVal => {
                        this._blockListReplace = convertBlockStringsToBlockType(newVal);
                        this._setBrushMask();
                        this._saveBlockMasks();
                    }
                });
                this._fillReplaceSubPane.hide();
            }
            {
                this._fillMaskSubPane = this._fillConstraintsSubPane.createSubPane({
                    title: this.localize("fillConstraints.mask.title")
                });
                this._blockListMaskIds.set(convertBlockTypesToBlockStrings(this._blockListMask));
                this._fillMaskSubPane?.addBlockList(this._blockListMaskIds, {
                    onChange: newVal => {
                        this._blockListMask = convertBlockStringsToBlockType(newVal);
                        this._setBrushMask();
                        this._saveBlockMasks();
                    }
                });
                this._fillMaskSubPane.hide();
            }
        }
        _getBlockMaskListTypeFromInternalMaskType(internalMaskType) {
            switch (internalMaskType) {
              case InternalMaskType.Mask:
                return server_editor_namespaceObject.BlockMaskListType.Mask;

              case InternalMaskType.Replace:
                return server_editor_namespaceObject.BlockMaskListType.Replace;

              case InternalMaskType.Disabled:
                return server_editor_namespaceObject.BlockMaskListType.Disabled;

              default:
                throw new Error("Invalid internal mask type");
            }
        }
        _getInternalMaskTypeFromBlockMaskListType(blockMaskListType) {
            switch (blockMaskListType) {
              case server_editor_namespaceObject.BlockMaskListType.Mask:
                return InternalMaskType.Mask;

              case server_editor_namespaceObject.BlockMaskListType.Replace:
                return InternalMaskType.Replace;

              case server_editor_namespaceObject.BlockMaskListType.Disabled:
                return InternalMaskType.Disabled;

              default:
                throw new Error("Invalid block mask list type");
            }
        }
        _setBrushMask(mask) {
            if (mask === undefined) {
                mask = {
                    maskType: this._getBlockMaskListTypeFromInternalMaskType(this._internalMaskType.value),
                    blockList: this._internalMaskType.value === InternalMaskType.Mask ? this._blockListMask : this._blockListReplace
                };
            }
            this.session.extensionContext.brushShapeManager.setBrushMask(mask);
        }
        _switchBrushMaskPanes() {
            switch (this._internalMaskType.value) {
              case InternalMaskType.Replace:
                {
                    this._fillConstraintsSubPane?.toggleSubPaneVisibility(this._fillReplaceSubPane?.id);
                    break;
                }

              case InternalMaskType.Mask:
                {
                    this._fillConstraintsSubPane?.toggleSubPaneVisibility(this._fillMaskSubPane?.id);
                    break;
                }

              case InternalMaskType.Disabled:
                {
                    this._fillConstraintsSubPane?.toggleSubPaneVisibility(undefined);
                    break;
                }
            }
        }
        _getSelectedBrushShape() {
            const currentBrushIndex = this._selectedBrushIndex.value;
            if (currentBrushIndex < 0 || currentBrushIndex >= this._brushShapes.length) {
                throw new Error("Invalid brush index");
            }
            return this._brushShapes[currentBrushIndex];
        }
        _setBrushVolume() {
            try {
                const brush = this._getSelectedBrushShape();
                this.session.extensionContext.brushShapeManager.setBrushShape(brush.createShape());
            } catch (e) {
                this.session.log.error(`Error updating brush: ${stringFromException(e)}`, {
                    channelMask: server_editor_namespaceObject.LogChannel.All
                });
                return;
            }
        }
        _updateSettingsSubPane() {
            if (!this._brushControlRootPane) {
                this.session.log.debug(`No settings pane`);
                return;
            }
            if (!this._brushSettingsSubPane) {
                this.session.log.debug(`No custom settings pane`);
                return;
            }
            this._brushControlRootPane.hide();
            if (this._customSettingsSubPane) {
                this._brushSettingsSubPane.removeSubPane(this._customSettingsSubPane);
            }
            const brushShape = this._getSelectedBrushShape();
            this._customSettingsSubPane = brushShape.createSettingsPane(this._brushSettingsSubPane, (() => {
                this._needsRefresh = true;
            }));
            this._customSettingsSubPane?.show();
            if (this._customSettingsSubPane) {
                this._brushSettingsSubPane.show();
            } else {
                this._brushSettingsSubPane.hide();
            }
            this._brushControlRootPane.show();
        }
        _runUpdateOperation() {
            if (this.isActive && this._needsRefresh) {
                this._setBrushVolume();
                this._needsRefresh = false;
            }
        }
        _saveBlockMasks() {
            const maskList = convertBlockTypesToBlockStrings(this._blockListMask);
            this.session.extensionContext.player.setDynamicProperty(PROPERTY_BRUSHPAINTCONTROL_BLOCKMASK_SETTINGS_MASK, JSON.stringify(maskList));
            const replaceList = convertBlockTypesToBlockStrings(this._blockListReplace);
            this.session.extensionContext.player.setDynamicProperty(PROPERTY_BRUSHPAINTCONTROL_BLOCKMASK_SETTINGS_REPLACE, JSON.stringify(replaceList));
        }
        _loadBlockMask(key, defaultList) {
            const data = this.session.extensionContext.player.getDynamicProperty(key);
            if (data) {
                try {
                    const blockStringList = JSON.parse(data);
                    if (blockStringList !== undefined && blockStringList.length > 0) {
                        const blockList = convertBlockStringsToBlockType(blockStringList);
                        if (blockList.length > 0) {
                            return blockList;
                        }
                    }
                    return defaultList;
                } catch (_e) {
                    return defaultList;
                }
            }
            return defaultList;
        }
        _getRelativeNudgeDirection(direction) {
            const rotationY = this.session.extensionContext.player.getRotation().y;
            const rotationCorrectedVector = getRotationCorrectedDirectionVector(rotationY, direction);
            return rotationCorrectedVector;
        }
        _nudgeOffset(nudgeVector) {
            let update = lib.Vector3Utils.add(this._brushShapeOffset.value, nudgeVector);
            update = lib.Vector3Utils.clamp(update, {
                min: BrushPaintSharedControl.MIN_OFFSET,
                max: BrushPaintSharedControl.MAX_OFFSET
            });
            this._brushShapeOffset.set(update);
            this.session.extensionContext.brushShapeManager.setBrushShapeOffset(update);
        }
        _getBrushShapeDropdownEntries() {
            return this._brushShapes.map(((brush, index) => {
                const item = {
                    label: brush.displayName,
                    value: index,
                    imageData: {
                        path: brush.icon,
                        type: server_editor_namespaceObject.ImageResourceType.Icon
                    }
                };
                return item;
            }));
        }
    }
    BrushPaintSharedControl.DEFAULT_NUMBER_MIN = 1;
    BrushPaintSharedControl.DEFAULT_NUMBER_MAX = 6;
    BrushPaintSharedControl.MIN_OFFSET = {
        x: -20,
        y: -20,
        z: -20
    };
    BrushPaintSharedControl.MAX_OFFSET = {
        x: 20,
        y: 20,
        z: 20
    };
    const PROPERTY_CURSORMODECONTROL_NAME = "CursorModeControl";
    const PROPERTY_CURSORMODECONTROL_LOCALIZATION_PREFIX = `resourcePack.editor.${PROPERTY_CURSORMODECONTROL_NAME}`;
    const KEY_REPEAT_DELAY = 5;
    const KEY_REPEAT_INTERVAL = 1;
    class CursorModeControl extends SharedControlImpl {
        get cursorProperties() {
            const props = {
                ...this._overrideCursorProperties,
                controlMode: this._mouseControlMode.value,
                targetMode: this._cursorTargetMode.value,
                fixedModeDistance: this._fixedDistanceCursor.value
            };
            return props;
        }
        constructor(_session, _parentTool, _parentPropertyPane, _bindManualInput, _overrideCursorProperties, _options) {
            super(_session, _parentTool, _parentPropertyPane, PROPERTY_CURSORMODECONTROL_NAME, PROPERTY_CURSORMODECONTROL_LOCALIZATION_PREFIX);
            this._options = _options;
            this._controlRootPane = undefined;
            this._mouseControlMode = (0, server_editor_namespaceObject.makeObservable)(server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse);
            this._cursorTargetMode = (0, server_editor_namespaceObject.makeObservable)(server_editor_namespaceObject.CursorTargetMode.Block);
            this._projectThroughWater = (0, server_editor_namespaceObject.makeObservable)(true);
            this._fixedDistanceCursor = (0, server_editor_namespaceObject.makeObservable)(5);
            this._canMoveManually = () => true;
            this._updateCursorProperties = (session, cursorControlMode, cursorTargetMode, fixedDistanceValue, fixedDistanceSliderControl) => {
                const cursorProperties = {
                    ...this._overrideCursorProperties,
                    controlMode: cursorControlMode,
                    targetMode: cursorTargetMode,
                    fixedModeDistance: fixedDistanceValue
                };
                if (fixedDistanceSliderControl) {
                    fixedDistanceSliderControl.visible = cursorControlMode === server_editor_namespaceObject.CursorControlMode.Fixed;
                }
                if (cursorControlMode === server_editor_namespaceObject.CursorControlMode.Keyboard) {
                    this.session.toolRail.focusToolInputContext();
                }
                if (this._projectThroughWaterCheckbox) {
                    this._projectThroughWaterCheckbox.visible = cursorControlMode === server_editor_namespaceObject.CursorControlMode.Mouse || cursorControlMode === server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse;
                }
                session.extensionContext.cursor.setProperties(cursorProperties);
            };
            this._storedCursorProperties = this.session.extensionContext.cursor.getProperties();
            this._overrideCursorProperties = {
                ..._overrideCursorProperties
            };
            this._bindManualInput = _bindManualInput ?? true;
            const currentCursorProperties = _overrideCursorProperties ?? this._storedCursorProperties;
            this._mouseControlMode.set(currentCursorProperties.controlMode ?? server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse);
            this._cursorTargetMode.set(currentCursorProperties.targetMode ?? server_editor_namespaceObject.CursorTargetMode.Block);
            this._projectThroughWater.set(currentCursorProperties.projectThroughLiquid ?? true);
            this._fixedDistanceCursor.set(currentCursorProperties.fixedModeDistance ?? 5);
        }
        bindMovementFunctions(canMove, moveForward, moveBack, moveLeft, moveRight, moveUp, moveDown) {
            this._canMoveManually = canMove ?? this._canMoveManually;
            this._moveForward = moveForward;
            this._moveBack = moveBack;
            this._moveLeft = moveLeft;
            this._moveRight = moveRight;
            this._moveUp = moveUp;
            this._moveDown = moveDown;
        }
        initialize() {
            super.initialize();
            this.tool.onModalToolActivation.subscribe((eventData => {
                if (eventData.isActiveTool) {
                    this._updateCursorProperties(this.session, this._mouseControlMode.value, this._cursorTargetMode.value, this._fixedDistanceCursor.value, this._fixedDistanceSliderControl);
                } else {
                    this.session.extensionContext.cursor.setProperties(this._storedCursorProperties);
                }
            }));
            if (this._bindManualInput) {
                const _moveBlockCursorManually = (_session, _direction) => {
                    const rotationY = _session.extensionContext.player.getRotation().y;
                    const rotationCorrectedVector = getRotationCorrectedDirectionVector(rotationY, _direction);
                    _session.extensionContext.cursor.moveBy(rotationCorrectedVector);
                };
                const keyUpAction = this.session.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            return;
                        }
                        if (this._canMoveManually()) {
                            this.session.extensionContext.cursor.moveBy(lib.VECTOR3_UP);
                            if (this._moveUp) {
                                this._moveUp();
                            }
                        }
                    },
                    repeatInterval: KEY_REPEAT_INTERVAL,
                    repeatDelay: KEY_REPEAT_DELAY
                });
                const keyDownAction = this.session.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            return;
                        }
                        if (this._canMoveManually()) {
                            this.session.extensionContext.cursor.moveBy(lib.VECTOR3_DOWN);
                            if (this._moveDown) {
                                this._moveDown();
                            }
                        }
                    },
                    repeatInterval: KEY_REPEAT_INTERVAL,
                    repeatDelay: KEY_REPEAT_DELAY
                });
                const keyLeftAction = this.session.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            return;
                        }
                        if (this._canMoveManually()) {
                            _moveBlockCursorManually(this.session, direction_Direction.Left);
                            if (this._moveLeft) {
                                this._moveLeft();
                            }
                        }
                    },
                    repeatInterval: KEY_REPEAT_INTERVAL,
                    repeatDelay: KEY_REPEAT_DELAY
                });
                const keyRightAction = this.session.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            return;
                        }
                        if (this._canMoveManually()) {
                            _moveBlockCursorManually(this.session, direction_Direction.Right);
                            if (this._moveRight) {
                                this._moveRight();
                            }
                        }
                    },
                    repeatInterval: KEY_REPEAT_INTERVAL,
                    repeatDelay: KEY_REPEAT_DELAY
                });
                const keyForwardAction = this.session.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            return;
                        }
                        if (this._canMoveManually()) {
                            _moveBlockCursorManually(this.session, direction_Direction.Forward);
                            if (this._moveForward) {
                                this._moveForward();
                            }
                        }
                    },
                    repeatInterval: KEY_REPEAT_INTERVAL,
                    repeatDelay: KEY_REPEAT_DELAY
                });
                const keyBackAction = this.session.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            return;
                        }
                        if (this._canMoveManually()) {
                            _moveBlockCursorManually(this.session, direction_Direction.Back);
                            if (this._moveBack) {
                                this._moveBack();
                            }
                        }
                    },
                    repeatInterval: KEY_REPEAT_INTERVAL,
                    repeatDelay: KEY_REPEAT_DELAY
                });
                this.registerToolKeyBinding(keyForwardAction, {
                    key: server_editor_namespaceObject.KeyboardKey.UP
                }, "moveCursorForward");
                this.registerToolKeyBinding(keyBackAction, {
                    key: server_editor_namespaceObject.KeyboardKey.DOWN
                }, "moveCursorBack");
                this.registerToolKeyBinding(keyLeftAction, {
                    key: server_editor_namespaceObject.KeyboardKey.LEFT
                }, "moveCursorLeft");
                this.registerToolKeyBinding(keyRightAction, {
                    key: server_editor_namespaceObject.KeyboardKey.RIGHT
                }, "moveCursorRight");
                this.registerToolKeyBinding(keyUpAction, {
                    key: server_editor_namespaceObject.KeyboardKey.PAGE_UP
                }, "moveCursorUp");
                this.registerToolKeyBinding(keyDownAction, {
                    key: server_editor_namespaceObject.KeyboardKey.PAGE_DOWN
                }, "moveCursorDown");
                {
                    const keyToggleMouseControlModeAction = this.session.actionManager.createAction({
                        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                        onExecute: () => {
                            const currentMode = this._mouseControlMode.value;
                            let newMode = server_editor_namespaceObject.CursorControlMode.Fixed;
                            switch (currentMode) {
                              case server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse:
                                newMode = server_editor_namespaceObject.CursorControlMode.Fixed;
                                break;

                              case server_editor_namespaceObject.CursorControlMode.Fixed:
                                newMode = server_editor_namespaceObject.CursorControlMode.Keyboard;
                                break;

                              case server_editor_namespaceObject.CursorControlMode.Keyboard:
                              default:
                                newMode = server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse;
                            }
                            this._mouseControlMode.set(newMode);
                            this._updateCursorProperties(this.session, this._mouseControlMode.value, this._cursorTargetMode.value, this._fixedDistanceCursor.value, this._fixedDistanceSliderControl);
                        }
                    });
                    this.registerToolKeyBinding(keyToggleMouseControlModeAction, {
                        key: server_editor_namespaceObject.KeyboardKey.KEY_T
                    }, "toggleMouseTracking");
                }
                const mouseWheelAction = this.session.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
                    onExecute: (mouseRay, mouseProps) => {
                        if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.WheelOut && mouseProps.modifiers.shift) {
                            if (this._mouseControlMode.value === server_editor_namespaceObject.CursorControlMode.Fixed) {
                                let currentDistance = this._fixedDistanceCursor.value;
                                if (mouseProps.modifiers.shift) {
                                    currentDistance += 5;
                                } else {
                                    currentDistance += 1;
                                }
                                if (currentDistance > CursorModeControl.MAX_FIXED_DISTANCE) {
                                    currentDistance = CursorModeControl.MAX_FIXED_DISTANCE;
                                }
                                this._fixedDistanceCursor.set(currentDistance);
                                this._updateCursorProperties(this.session, this._mouseControlMode.value, this._cursorTargetMode.value, this._fixedDistanceCursor.value, this._fixedDistanceSliderControl);
                            }
                        } else if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.WheelIn && mouseProps.modifiers.shift) {
                            if (this._mouseControlMode.value === server_editor_namespaceObject.CursorControlMode.Fixed) {
                                let currentDistance = this._fixedDistanceCursor.value;
                                if (mouseProps.modifiers.shift) {
                                    currentDistance -= 5;
                                } else {
                                    currentDistance -= 1;
                                }
                                if (currentDistance < CursorModeControl.MIN_FIXED_DISTANCE) {
                                    currentDistance = CursorModeControl.MIN_FIXED_DISTANCE;
                                }
                                this._fixedDistanceCursor.set(currentDistance);
                                this._updateCursorProperties(this.session, this._mouseControlMode.value, this._cursorTargetMode.value, this._fixedDistanceCursor.value, this._fixedDistanceSliderControl);
                            }
                        }
                    }
                });
                this.tool.registerMouseWheelBinding(mouseWheelAction);
            }
            {
                const keyToggleTargetModeAction = this.session.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                    onExecute: () => {
                        const currentMode = this._cursorTargetMode.value;
                        const newMode = currentMode === server_editor_namespaceObject.CursorTargetMode.Block ? server_editor_namespaceObject.CursorTargetMode.Face : server_editor_namespaceObject.CursorTargetMode.Block;
                        this._cursorTargetMode.set(newMode);
                        this._updateCursorProperties(this.session, this._mouseControlMode.value, this._cursorTargetMode.value, this._fixedDistanceCursor.value, this._fixedDistanceSliderControl);
                    }
                });
                this.registerToolKeyBinding(keyToggleTargetModeAction, {
                    key: server_editor_namespaceObject.KeyboardKey.KEY_B
                }, "toggleBlockTargetMode");
                this._updateCursorProperties(this.session, this._mouseControlMode.value, this._cursorTargetMode.value, this._fixedDistanceCursor.value, this._fixedDistanceSliderControl);
            }
        }
        shutdown() {
            super.shutdown();
            if (this._cursorPropertyEventSub) {
                this.session.extensionContext.afterEvents.cursorPropertyChange.unsubscribe(this._cursorPropertyEventSub);
            }
            this.session.extensionContext.cursor.setProperties(this._storedCursorProperties);
        }
        activateControl() {
            super.activateControl();
            this._constructControlUI();
        }
        deactivateControl() {
            super.deactivateControl();
            this._destroyControlUI();
        }
        _destroyControlUI() {
            if (this._controlRootPane) {
                this.propertyPane.removeSubPane(this._controlRootPane);
                this._controlRootPane = undefined;
            }
        }
        _constructControlUI() {
            if (this._controlRootPane) {
                this._destroyControlUI();
            }
            this._controlRootPane = this.propertyPane.createSubPane({
                title: this.localize("rootPane.title"),
                infoTooltip: {
                    title: this.localize("rootPane.title"),
                    description: [ this.localize("rootPane.tooltip") ]
                },
                hasMargins: this._options?.hasPaneMargins
            });
            {
                this._controlRootPane.addDropdown(this._mouseControlMode, {
                    title: this.localize("mouseControlMode.title"),
                    tooltip: {
                        title: {
                            id: this.localize("mouseControlMode.tooltip.title"),
                            props: [ getInputMarkup("editor:CursorModeControl:toggleMouseTracking", "[", "]") ]
                        },
                        description: {
                            id: this.localize("mouseControlMode.tooltip"),
                            props: [ newLineMarkup + newLineMarkup, getInputMarkup("editor:CursorModeControl:toggleMouseTracking", "[", "]") ]
                        }
                    },
                    entries: [ {
                        label: this.localize("mouseControlMode.keyboard"),
                        value: server_editor_namespaceObject.CursorControlMode.Keyboard
                    }, {
                        label: this.localize("mouseControlMode.keyboardAndMouse"),
                        value: server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse
                    }, {
                        label: this.localize("mouseControlMode.fixed"),
                        value: server_editor_namespaceObject.CursorControlMode.Fixed
                    } ],
                    onChange: () => {
                        this._updateCursorProperties(this.session, this._mouseControlMode.value, this._cursorTargetMode.value, this._fixedDistanceCursor.value, this._fixedDistanceSliderControl);
                    }
                });
                const cursorProperties = this.session.extensionContext.cursor.getProperties();
                this._fixedDistanceCursor.set(cursorProperties.fixedModeDistance ?? 5);
                const fixedDistanceSliderVisible = cursorProperties.controlMode === server_editor_namespaceObject.CursorControlMode.Fixed;
                this._fixedDistanceSliderControl = this._controlRootPane.addNumber(this._fixedDistanceCursor, {
                    visible: fixedDistanceSliderVisible,
                    isInteger: true,
                    min: CursorModeControl.MIN_FIXED_DISTANCE,
                    max: CursorModeControl.MAX_FIXED_DISTANCE,
                    title: this.localize("fixedDistance.slider.title"),
                    tooltip: this.localize("fixedDistance.slider.tooltip"),
                    variant: server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider,
                    onChange: () => {
                        this._updateCursorProperties(this.session, this._mouseControlMode.value, this._cursorTargetMode.value, this._fixedDistanceCursor.value, this._fixedDistanceSliderControl);
                    }
                });
                this.session.extensionContext.afterEvents.cursorPropertyChange.subscribe((_event => {
                    if (_event.properties.fixedModeDistance !== undefined && _event.properties.fixedModeDistance !== this._fixedDistanceCursor.value) {
                        this._fixedDistanceCursor.set(_event.properties.fixedModeDistance);
                    }
                }));
            }
            {
                this._controlRootPane.addToggleGroup(this._cursorTargetMode, {
                    title: this.localize("cursorTargetMode.title"),
                    tooltip: {
                        title: {
                            id: this.localize("cursorTargetMode.tooltip.title"),
                            props: [ getInputMarkup("editor:CursorModeControl:toggleBlockTargetMode", "[", "]") ]
                        },
                        description: {
                            id: this.localize("cursorTargetMode.tooltip"),
                            props: [ getInputMarkup("editor:CursorModeControl:toggleBlockTargetMode", "[", "]") ]
                        }
                    },
                    entries: [ {
                        tooltip: {
                            title: {
                                id: this.localize("cursorTargetMode.block"),
                                props: [ getInputMarkup("editor:CursorModeControl:toggleBlockTargetMode", "[", "]") ]
                            },
                            description: {
                                id: this.localize("cursorTargetMode.block.tooltip"),
                                props: [ newLineMarkup + newLineMarkup, getInputMarkup("editor:CursorModeControl:toggleBlockTargetMode", "[", "]") ]
                            }
                        },
                        value: server_editor_namespaceObject.CursorTargetMode.Block,
                        icon: "pack://textures/editor/block-mode.png"
                    }, {
                        tooltip: {
                            title: {
                                id: this.localize("cursorTargetMode.face"),
                                props: [ getInputMarkup("editor:CursorModeControl:toggleBlockTargetMode", "[", "]") ]
                            },
                            description: {
                                id: this.localize("cursorTargetMode.face.tooltip"),
                                props: [ newLineMarkup + newLineMarkup, getInputMarkup("editor:CursorModeControl:toggleBlockTargetMode", "[", "]") ]
                            }
                        },
                        value: server_editor_namespaceObject.CursorTargetMode.Face,
                        icon: "pack://textures/editor/face-mode.png"
                    } ],
                    onChange: () => {
                        this._updateCursorProperties(this.session, this._mouseControlMode.value, this._cursorTargetMode.value, this._fixedDistanceCursor.value, this._fixedDistanceSliderControl);
                    }
                });
            }
            {
                this._projectThroughWaterCheckbox = this._controlRootPane.addBool(this._projectThroughWater, {
                    title: this.localize("projectThroughWater.title"),
                    tooltip: this.localize("projectThroughWater.tooltip"),
                    visible: this._mouseControlMode.value === server_editor_namespaceObject.CursorControlMode.Mouse || this._mouseControlMode.value === server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse,
                    onChange: () => {
                        const cursorProperties = {
                            projectThroughLiquid: this._projectThroughWater.value
                        };
                        this.session.extensionContext.cursor.setProperties(cursorProperties);
                    }
                });
                this._cursorPropertyEventSub = this.session.extensionContext.afterEvents.cursorPropertyChange.subscribe((event => {
                    if (event.properties.projectThroughLiquid !== undefined) {
                        this._projectThroughWater.set(event.properties.projectThroughLiquid);
                    }
                }));
            }
        }
    }
    CursorModeControl.MAX_FIXED_DISTANCE = 32;
    CursorModeControl.MIN_FIXED_DISTANCE = 1;
    const gameModeLookUpIndex = {
        Survival: 0,
        Creative: 1,
        Adventure: 2,
        Spectator: 6
    };
    const difficultyLookUpIndex = {
        [server_namespaceObject.Difficulty.Peaceful]: 0,
        [server_namespaceObject.Difficulty.Easy]: 1,
        [server_namespaceObject.Difficulty.Normal]: 2,
        [server_namespaceObject.Difficulty.Hard]: 3
    };
    function getDifficultyByValue(value) {
        return Object.keys(difficultyLookUpIndex).find((key => difficultyLookUpIndex[key] === value));
    }
    const gameModeDropDownItems = [ {
        label: "resourcePack.editor.exportProject.gameMode.survival",
        value: gameModeLookUpIndex[server_namespaceObject.GameMode.Survival]
    }, {
        label: "resourcePack.editor.exportProject.gameMode.creative",
        value: gameModeLookUpIndex[server_namespaceObject.GameMode.Creative]
    }, {
        label: "resourcePack.editor.exportProject.gameMode.adventure",
        value: gameModeLookUpIndex[server_namespaceObject.GameMode.Adventure]
    } ];
    const validGameModes = [ server_namespaceObject.GameMode.Survival, server_namespaceObject.GameMode.Creative, server_namespaceObject.GameMode.Adventure ];
    const difficultyLocalization = {
        [server_namespaceObject.Difficulty.Peaceful]: "resourcePack.editor.exportProject.difficulty.peaceful",
        [server_namespaceObject.Difficulty.Easy]: "resourcePack.editor.exportProject.difficulty.easy",
        [server_namespaceObject.Difficulty.Normal]: "resourcePack.editor.exportProject.difficulty.normal",
        [server_namespaceObject.Difficulty.Hard]: "resourcePack.editor.exportProject.difficulty.hard"
    };
    const difficultyDropDownItems = [ {
        label: difficultyLocalization[server_namespaceObject.Difficulty.Peaceful],
        value: difficultyLookUpIndex[server_namespaceObject.Difficulty.Peaceful]
    }, {
        label: difficultyLocalization[server_namespaceObject.Difficulty.Easy],
        value: difficultyLookUpIndex[server_namespaceObject.Difficulty.Easy]
    }, {
        label: difficultyLocalization[server_namespaceObject.Difficulty.Normal],
        value: difficultyLookUpIndex[server_namespaceObject.Difficulty.Normal]
    }, {
        label: difficultyLocalization[server_namespaceObject.Difficulty.Hard],
        value: difficultyLookUpIndex[server_namespaceObject.Difficulty.Hard]
    } ];
    var Weather;
    (function(Weather) {
        Weather[Weather["Default"] = -1] = "Default";
        Weather[Weather["Clear"] = 0] = "Clear";
        Weather[Weather["Rain"] = 1] = "Rain";
        Weather[Weather["Thunder"] = 2] = "Thunder";
    })(Weather || (Weather = {}));
    const weatherDropdownItems = [ {
        label: "resourcePack.editor.exportProject.weather.default",
        value: Weather.Default
    }, {
        label: "resourcePack.editor.exportProject.weather.clear",
        value: Weather.Clear
    }, {
        label: "resourcePack.editor.exportProject.weather.rain",
        value: Weather.Rain
    }, {
        label: "resourcePack.editor.exportProject.weather.thunder",
        value: Weather.Thunder
    } ];
    const validPlayerAccess = [ server_editor_namespaceObject.GamePublishSetting.InviteOnly, server_editor_namespaceObject.GamePublishSetting.FriendsOnly, server_editor_namespaceObject.GamePublishSetting.FriendsOfFriends ];
    const playerAccessLocalization = {
        [server_editor_namespaceObject.GamePublishSetting.FriendsOfFriends]: "resourcePack.editor.exportProject.multiplayerSettings.playerAccess.friendsOfFriends",
        [server_editor_namespaceObject.GamePublishSetting.FriendsOnly]: "resourcePack.editor.exportProject.multiplayerSettings.playerAccess.friendsOnly",
        [server_editor_namespaceObject.GamePublishSetting.InviteOnly]: "resourcePack.editor.exportProject.multiplayerSettings.playerAccess.inviteOnly",
        [server_editor_namespaceObject.GamePublishSetting.Public]: "Public",
        [server_editor_namespaceObject.GamePublishSetting.NoMultiPlay]: "NoMultiPlay"
    };
    const validPlayerPermissionLevels = [ server_namespaceObject.PlayerPermissionLevel.Visitor, server_namespaceObject.PlayerPermissionLevel.Member, server_namespaceObject.PlayerPermissionLevel.Operator, server_namespaceObject.PlayerPermissionLevel.Custom ];
    const playerPermissionLocalization = {
        [server_namespaceObject.PlayerPermissionLevel.Visitor]: "resourcePack.editor.exportProject.multiplayerSettings.playerPermissions.visitor",
        [server_namespaceObject.PlayerPermissionLevel.Member]: "resourcePack.editor.exportProject.multiplayerSettings.playerPermissions.member",
        [server_namespaceObject.PlayerPermissionLevel.Operator]: "resourcePack.editor.exportProject.multiplayerSettings.playerPermissions.operator",
        [server_namespaceObject.PlayerPermissionLevel.Custom]: "resourcePack.editor.exportProject.multiplayerSettings.playerPermissions.custom"
    };
    const validDaylightCycle = [ server_editor_namespaceObject.DaylightCycle.Normal, server_editor_namespaceObject.DaylightCycle.AlwaysDay, server_editor_namespaceObject.DaylightCycle.LockTime ];
    const daylightCycleLocalization = {
        [server_editor_namespaceObject.DaylightCycle.AlwaysDay]: "resourcePack.editor.exportProject.cheatsSettings.daylightCycle.alwaysDay",
        [server_editor_namespaceObject.DaylightCycle.LockTime]: "resourcePack.editor.exportProject.cheatsSettings.daylightCycle.lockTime",
        [server_editor_namespaceObject.DaylightCycle.Normal]: "resourcePack.editor.exportProject.cheatsSettings.daylightCycle.normal"
    };
    const MAX_ACTOR_COMMAND_COORDINATE = 3e7;
    class WorldSettingsPane {
        constructor(_uiSession, parentPane, includeMultiplayer, exportOnly = true) {
            this._uiSession = _uiSession;
            this._clockType = (0, server_editor_namespaceObject.makeObservable)(ClockType.MINECRAFT_CLOCK);
            this._currentStartTime = (0, server_editor_namespaceObject.makeObservable)(TODDropDown.None);
            this._timeOfDayTimeString = (0, server_editor_namespaceObject.makeObservable)(convertTODToTime(0, false));
            this._cheatItems = new Map;
            this._multiplayerPropertyItems = [];
            this._nonHardCorePropertyItems = [];
            this._lastCheatsValues = new Map;
            this._includeMultiplayer = includeMultiplayer;
            this._exportOnly = exportOnly;
            const gameOptions = this._uiSession.extensionContext.exportManager.getGameOptions();
            this._defaultGameOptions = this._uiSession.extensionContext.exportManager.getGameOptions(true);
            this._defaultGameOptions.worldName = gameOptions.worldName;
            this._defaultGameOptions.spawnPosition = gameOptions.spawnPosition;
            this._worldSettingsPaneData = Object.entries(gameOptions).reduce(((data, [key, value]) => {
                const optKey = key;
                switch (optKey) {
                  case "gameMode":
                    data["gameMode"] = (0, server_editor_namespaceObject.makeObservable)(gameModeLookUpIndex[gameOptions["gameMode"]]);
                    break;

                  case "difficulty":
                    data["difficulty"] = (0, server_editor_namespaceObject.makeObservable)(difficultyLookUpIndex[gameOptions["difficulty"]]);
                    break;

                  default:
                    data[optKey] = (0, server_editor_namespaceObject.makeObservable)(value);
                }
                return data;
            }), {});
            this._currentGameModeDropdownItems = this._getGameModeDropdownItems(gameOptions.hardcore);
            this._currentDifficultyDropDownItems = this._getDifficultyDropdownItems(gameOptions.hardcore);
            this._lastDifficultyIndex = !gameOptions.hardcore ? difficultyLookUpIndex[gameOptions.difficulty] : 0;
            this._lastGameModeIndex = gameModeLookUpIndex[gameOptions.gameMode];
            this._lastStartingMap = this._worldSettingsPaneData.startingMap.value;
            this._lastBonusChest = this._worldSettingsPaneData.bonusChest.value;
            this._lastCheatsEnabled = this._worldSettingsPaneData.cheats.value;
            this._parentPane = parentPane;
            this._spawnPosition = this._worldSettingsPaneData.spawnPosition.value;
            this._weatherIndex = this._worldSettingsPaneData.weather.value;
            this._uiSession.eventSubscriptionCache.subscribeToBedrockEvent("playerDimensionChange", (event => {
                if (this._usePlayerAsSpawnPointPropItem && event.player.id === this._uiSession.extensionContext.player.id) {
                    this._usePlayerAsSpawnPointPropItem.enable = this._isPlayerAsSpawnPointPropItemEnabled(event.toDimension);
                }
            }));
        }
        setToDefaultGameOptions() {
            const prevHardcore = this._worldSettingsPaneData.hardcore.value;
            Object.entries(this._defaultGameOptions).forEach((([key, value]) => {
                const optKey = key;
                switch (optKey) {
                  case "gameMode":
                    this._worldSettingsPaneData["gameMode"].set(gameModeLookUpIndex[this._defaultGameOptions["gameMode"]]);
                    break;

                  case "difficulty":
                    this._worldSettingsPaneData["difficulty"].set(difficultyLookUpIndex[this._defaultGameOptions["difficulty"]]);
                    break;

                  default:
                    this._worldSettingsPaneData[optKey].set(value);
                }
            }));
            this._setToDefaultInitialPayOptions();
            this._setToDefaultCheatOptions(this._defaultGameOptions.cheats);
            if (this._includeMultiplayer) {
                this._setMultiplayerOptionsEnableState(this._defaultGameOptions.multiplayerGame);
            }
            if (prevHardcore !== this._defaultGameOptions.hardcore) {
                this._onHardcoreChanged(this._defaultGameOptions.hardcore, this._worldSettingsPaneData.gameMode.value, difficultyLookUpIndex[this._defaultGameOptions.difficulty]);
            }
            if (this._sleepSkipPercentPropItem) {
                this._sleepSkipPercentPropItem.enable = this._worldSettingsPaneData.bedsWork.value;
                this._sleepSkipPercentPropItem.setTitle(`Required Sleeping players (${this._worldSettingsPaneData.sleepSkipPercent.value}%%)`);
            }
        }
        getGameOptions() {
            const options = Object.entries(this._worldSettingsPaneData).reduce(((data, [key, observable]) => {
                const optKey = key;
                switch (optKey) {
                  case "gameMode":
                    data["gameMode"] = validGameModes[this._worldSettingsPaneData["gameMode"].value];
                    break;

                  case "disableWeather":
                    data["disableWeather"] = !this._worldSettingsPaneData["disableWeather"].value;
                    break;

                  case "difficulty":
                    data["difficulty"] = getDifficultyByValue(this._worldSettingsPaneData["difficulty"].value);
                    break;

                  case "weather":
                    if (this._worldSettingsPaneData["weather"].value === Weather.Default) {
                        const overworldWeather = server_namespaceObject.world.getDimension(MinecraftDimensionTypes.Overworld).getWeather();
                        data["weather"] = Weather[overworldWeather];
                    } else {
                        data["weather"] = this._worldSettingsPaneData["weather"].value;
                    }
                    break;

                  default:
                    data[key] = observable.value;
                }
                return data;
            }), {});
            return options;
        }
        getObservablePaneElements() {
            return this._worldSettingsPaneData;
        }
        BuildPropertyPane() {
            this._buildGeneralSectionOfPane();
            this._buildInitialPlaySectionOfPane();
            this._buildAdvancedSectionOfPane();
            if (this._includeMultiplayer) {
                this._buildMultiplayerSectionOfPane();
            }
            this._buildCheatSectionOfPane();
        }
        _buildGeneralSectionOfPane() {
            const generalSettingsPane = this._parentPane.createSubPane({
                title: `resourcePack.editor.exportProject.generalSettings`,
                collapsed: true,
                infoTooltip: {
                    title: `resourcePack.editor.exportProject.generalSettings`,
                    description: [ "resourcePack.editor.exportProject.generalSettings.tooltip" ]
                }
            });
            generalSettingsPane.beginConstruct();
            generalSettingsPane.addString(this._worldSettingsPaneData.worldName, {
                title: `resourcePack.editor.exportProject.generalSettings.worldName`,
                tooltip: `resourcePack.editor.exportProject.generalSettings.worldName.tooltip`
            });
            this._gameModePropertyItem = generalSettingsPane.addDropdown(this._worldSettingsPaneData.gameMode, {
                title: "resourcePack.editor.exportProject.generalSettings.gameMode",
                tooltip: "resourcePack.editor.exportProject.generalSettings.gameMode.tooltip",
                entries: this._currentGameModeDropdownItems
            });
            this._difficultyPropertyItem = generalSettingsPane.addDropdown(this._worldSettingsPaneData.difficulty, {
                title: "resourcePack.editor.exportProject.generalSettings.difficulty",
                tooltip: "resourcePack.editor.exportProject.generalSettings.difficulty.tooltip",
                entries: this._currentDifficultyDropDownItems
            });
            generalSettingsPane.addBool(this._worldSettingsPaneData.hardcore, {
                title: "resourcePack.editor.exportProject.generalSettings.hardcore",
                tooltip: "resourcePack.editor.exportProject.generalSettings.hardcore.tooltip",
                onChange: isHardCore => {
                    if (isHardCore) {
                        this._lastDifficultyIndex = this._worldSettingsPaneData.difficulty.value;
                        this._lastGameModeIndex = this._worldSettingsPaneData.gameMode.value;
                        this._lastBonusChest = this._worldSettingsPaneData.bonusChest.value;
                        this._lastStartingMap = this._worldSettingsPaneData.startingMap.value;
                        this._lastCheatsEnabled = this._worldSettingsPaneData.cheats.value;
                        this._worldSettingsPaneData.startingMap.set(this._defaultGameOptions.startingMap);
                        this._worldSettingsPaneData.bonusChest.set(this._defaultGameOptions.bonusChest);
                        this._worldSettingsPaneData.cheats.set(this._defaultGameOptions.cheats);
                        this._storeLastCheatValues();
                        this._setToDefaultCheatOptions(this._worldSettingsPaneData.cheats.value);
                    } else {
                        this._worldSettingsPaneData.startingMap.set(this._lastStartingMap);
                        this._worldSettingsPaneData.bonusChest.set(this._lastBonusChest);
                        this._worldSettingsPaneData.cheats.set(this._lastCheatsEnabled);
                        this._setCheatsToLastValues(this._worldSettingsPaneData.cheats.value);
                    }
                    this._onHardcoreChanged(isHardCore, this._lastGameModeIndex, this._lastDifficultyIndex);
                }
            });
            generalSettingsPane.endConstruct();
        }
        _buildInitialPlaySectionOfPane() {
            const generalSettingsPane = this._parentPane.createSubPane({
                title: `resourcePack.editor.exportProject.initialPlaySettings`,
                infoTooltip: {
                    title: `resourcePack.editor.exportProject.initialPlaySettings`,
                    description: [ `resourcePack.editor.exportProject.initialPlaySettings.tooltip` ]
                },
                collapsed: true
            });
            generalSettingsPane.beginConstruct();
            generalSettingsPane.addVector3(this._worldSettingsPaneData.spawnPosition, {
                title: `resourcePack.editor.exportProject.initialPlaySettings.spawnPosition`,
                tooltip: `resourcePack.editor.exportProject.initialPlaySettings.spawnPosition.tooltip`,
                min: {
                    x: -MAX_ACTOR_COMMAND_COORDINATE,
                    y: -MAX_ACTOR_COMMAND_COORDINATE,
                    z: -MAX_ACTOR_COMMAND_COORDINATE
                },
                max: {
                    x: MAX_ACTOR_COMMAND_COORDINATE,
                    y: MAX_ACTOR_COMMAND_COORDINATE,
                    z: MAX_ACTOR_COMMAND_COORDINATE
                },
                isInteger: true
            });
            this._usePlayerAsSpawnPointPropItem = generalSettingsPane.addButton((() => {
                const player = this._uiSession.extensionContext.player;
                if (player.dimension.id === MinecraftDimensionTypes.Overworld) {
                    this._worldSettingsPaneData.spawnPosition.set(lib.Vector3Utils.floor(player.location));
                }
            }), {
                title: "resourcePack.editor.exportProject.initialPlaySettings.usePlayerAsSpawnPoint",
                tooltip: "resourcePack.editor.exportProject.initialPlaySettings.usePlayerAsSpawnPoint.tooltip",
                enable: this._isPlayerAsSpawnPointPropItemEnabled(this._uiSession.extensionContext.player.dimension)
            });
            const timeItems = this._getTimeItemDropdownItems();
            this._timeOfDayPropItem = generalSettingsPane.addDropdown(this._currentStartTime, {
                title: "resourcePack.editor.exportProject.initialPlaySettings.startTime",
                tooltip: "resourcePack.editor.exportProject.initialPlaySettings.startTime.tooltip",
                entries: timeItems,
                onChange: newValue => {
                    if (newValue === TODDropDown.None) {
                        clockTypePropItem.visible = true;
                        customTimePropItem.visible = true;
                        dayTimePropItem.visible = true;
                    } else {
                        this._worldSettingsPaneData.timeOfDay.set(newValue);
                        clockTypePropItem.visible = false;
                        customTimePropItem.visible = false;
                        dayTimePropItem.visible = false;
                    }
                }
            });
            const clockItems = this._getClockTypeDropdownItems();
            const clockTypePropItem = generalSettingsPane.addDropdown(this._clockType, {
                title: "resourcePack.editor.timeOfDay.clockType",
                tooltip: "resourcePack.editor.timeOfDay.clockType.tooltip",
                enable: true,
                entries: clockItems,
                onChange: newValue => {
                    if (newValue !== ClockType.MINECRAFT_CLOCK) {
                        dayTimePropItem.visible = true;
                        const is24HrClock = this._clockType.value === ClockType.CLOCK_24HR ? true : false;
                        this._timeOfDayTimeString.set(convertTODToTime(this._worldSettingsPaneData.timeOfDay.value, is24HrClock));
                    } else {
                        dayTimePropItem.visible = false;
                    }
                }
            });
            this._clockTypePropItem = clockTypePropItem;
            const dayTimePropItem = generalSettingsPane.addString(this._timeOfDayTimeString, {
                title: "resourcePack.editor.timeOfDay.customTime",
                tooltip: "resourcePack.editor.timeOfDay.customTime.tooltip",
                enable: false,
                visible: false
            });
            const customTimePropItem = generalSettingsPane.addNumber(this._worldSettingsPaneData.timeOfDay, {
                title: "resourcePack.editor.timeOfDay.customTime",
                tooltip: "resourcePack.editor.timeOfDay.customTime.tooltip",
                min: 0,
                max: 24 * mcHoursPerTick - 1,
                variant: server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider,
                isInteger: true,
                onChange: newValue => {
                    const is24HrClock = this._clockType.value === ClockType.CLOCK_24HR ? true : false;
                    this._timeOfDayTimeString.set(convertTODToTime(newValue, is24HrClock));
                }
            });
            this._weatherPropItem = generalSettingsPane.addDropdown(this._weatherIndex, {
                title: `resourcePack.editor.exportProject.initialPlaySettings.weather`,
                tooltip: `resourcePack.editor.exportProject.initialPlaySettings.weather.tooltip`,
                entries: weatherDropdownItems,
                onChange: newValue => {
                    this._worldSettingsPaneData.weather.set(newValue);
                }
            });
            generalSettingsPane.endConstruct();
        }
        _buildAdvancedSectionOfPane() {
            const advancedSettingsPane = this._parentPane.createSubPane({
                title: `resourcePack.editor.exportProject.advancedSettings`,
                collapsed: true,
                infoTooltip: {
                    title: `resourcePack.editor.exportProject.advancedSettings`,
                    description: [ `resourcePack.editor.exportProject.advancedSettings.tooltip` ]
                }
            });
            advancedSettingsPane.beginConstruct();
            const startingMapPropItem = advancedSettingsPane.addBool(this._worldSettingsPaneData.startingMap, {
                title: "resourcePack.editor.exportProject.advancedSettings.startingMap",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.startingMap.tooltip"
            });
            this._nonHardCorePropertyItems.push(startingMapPropItem);
            if (this._exportOnly) {
                const bonusChestPropItem = advancedSettingsPane.addBool(this._worldSettingsPaneData.bonusChest, {
                    title: "resourcePack.editor.exportProject.advancedSettings.bonusChest",
                    tooltip: "resourcePack.editor.exportProject.advancedSettings.bonusChest.tooltip"
                });
                this._nonHardCorePropertyItems.push(bonusChestPropItem);
            }
            advancedSettingsPane.addBool(this._worldSettingsPaneData.showCoordinates, {
                title: "resourcePack.editor.exportProject.advancedSettings.showCoordinates",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.showCoordinates.tooltip"
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.locatorBar, {
                title: "resourcePack.editor.exportProject.advancedSettings.showLocatorBar"
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.showDaysPlayed, {
                title: "resourcePack.editor.exportProject.advancedSettings.showDaysPlayed",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.showDaysPlayed.tooltip"
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.recipeUnlocking, {
                title: "resourcePack.editor.exportProject.advancedSettings.recipeUnlocking",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.recipeUnlocking.tooltip"
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.limitedCrafting, {
                title: "resourcePack.editor.exportProject.advancedSettings.limitedCrafting",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.limitedCrafting.tooltip"
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.fireSpreads, {
                title: "resourcePack.editor.exportProject.advancedSettings.fireSpreads",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.fireSpreads.tooltip"
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.tntExplodes, {
                title: "resourcePack.editor.exportProject.advancedSettings.tntExplodes",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.tntExplodes.tooltip"
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.respawnBlocksExplode, {
                title: "resourcePack.editor.exportProject.advancedSettings.resawnBlocksExplode",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.resawnBlocksExplode.tooltip"
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.mobLoot, {
                title: "resourcePack.editor.exportProject.advancedSettings.mobLoot",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.mobLoot.tooltip"
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.naturalRegeneration, {
                title: "resourcePack.editor.exportProject.advancedSettings.naturalRegeneration",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.naturalRegeneration.tooltip"
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.tileDrops, {
                title: "resourcePack.editor.exportProject.advancedSettings.tileDrops",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.tileDrops.tooltip"
            });
            const oneSleepingPlayerMessage = {
                id: "resourcePack.editor.exportProject.advancedSettings.requiredSleepingPlayers.onePlayerMessage"
            };
            const initialTitlePercentMessage = this._worldSettingsPaneData.sleepSkipPercent.value <= 0 ? oneSleepingPlayerMessage.id : this._worldSettingsPaneData.sleepSkipPercent.value >= 101 ? `${100}` + `%%` : `${this._worldSettingsPaneData.sleepSkipPercent.value}` + `%%`;
            const localizedPercentTitle = {
                id: "resourcePack.editor.exportProject.advancedSettings.requiredSleepingPlayers",
                props: [ `${initialTitlePercentMessage}` ]
            };
            advancedSettingsPane.addBool(this._worldSettingsPaneData.bedsWork, {
                title: "resourcePack.editor.exportProject.advancedSettings.bedsWork",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.bedsWork.tooltip",
                variant: server_editor_namespaceObject.BoolPropertyItemVariant.Checkbox,
                onChange: newValue => {
                    if (this._sleepSkipPercentPropItem) {
                        this._sleepSkipPercentPropItem.enable = newValue;
                        if (newValue) {
                            this._worldSettingsPaneData.sleepSkipPercent.set(this._defaultGameOptions.sleepSkipPercent);
                        } else {
                            const sleepDisabledValue = this._defaultGameOptions.sleepSkipPercent + 1;
                            this._worldSettingsPaneData.sleepSkipPercent.set(sleepDisabledValue);
                            if (localizedPercentTitle.props) {
                                localizedPercentTitle.props = [ `${this._worldSettingsPaneData.sleepSkipPercent.value}%%` ];
                            }
                            this._sleepSkipPercentPropItem.setTitle(localizedPercentTitle);
                        }
                    }
                }
            });
            this._sleepSkipPercentPropItem = advancedSettingsPane.addNumber(this._worldSettingsPaneData.sleepSkipPercent, {
                title: localizedPercentTitle,
                tooltip: "resourcePack.editor.exportProject.advancedSettings.requiredSleepingPlayers.tooltip",
                min: 0,
                max: 100,
                isInteger: true,
                enable: this._worldSettingsPaneData.bedsWork.value,
                variant: server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider,
                onChange: newValue => {
                    if (localizedPercentTitle.props && newValue > 0) {
                        localizedPercentTitle.props = [ `${newValue}%%` ];
                    } else {
                        localizedPercentTitle.props = [ oneSleepingPlayerMessage.id ];
                    }
                    this._sleepSkipPercentPropItem?.setTitle(localizedPercentTitle);
                }
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.immediateRespawn, {
                title: "resourcePack.editor.exportProject.advancedSettings.immediateRespawn",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.immediateRespawn.tooltip"
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.showDeathMessage, {
                title: "resourcePack.editor.exportProject.advancedSettings.showDeathMessage",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.showDeathMessage.tooltip"
            });
            advancedSettingsPane.addNumber(this._worldSettingsPaneData.respawnRadius, {
                title: `resourcePack.editor.exportProject.advancedSettings.respawnRadius`,
                tooltip: `resourcePack.editor.exportProject.advancedSettings.respawnRadius.tooltip`,
                min: 0,
                max: 128
            });
            advancedSettingsPane.addNumber(this._worldSettingsPaneData.simulationDistance, {
                title: `resourcePack.editor.exportProject.advancedSettings.simulationDistance`,
                tooltip: `resourcePack.editor.exportProject.advancedSettings.simulationDistance.tooltip`,
                min: 4,
                max: 12
            });
            advancedSettingsPane.addBool(this._worldSettingsPaneData.showItemTags, {
                title: "resourcePack.editor.exportProject.advancedSettings.showItemTags",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.showItemTags.tooltip"
            });
            advancedSettingsPane.endConstruct();
        }
        _buildMultiplayerSectionOfPane() {
            const multiplayerSettingsPane = this._parentPane.createSubPane({
                title: `resourcePack.editor.exportProject.multiplayerSettings`,
                collapsed: true,
                infoTooltip: {
                    title: `resourcePack.editor.exportProject.multiplayerSettings`,
                    description: [ `resourcePack.editor.exportProject.multiplayerSettings.tooltip` ]
                }
            });
            multiplayerSettingsPane.beginConstruct();
            const isMultiplayerEnabled = this._worldSettingsPaneData.multiplayerGame.value;
            multiplayerSettingsPane.addBool(this._worldSettingsPaneData.multiplayerGame, {
                title: "resourcePack.editor.exportProject.multiplayerSettings.multiplayerGame",
                tooltip: "resourcePack.editor.exportProject.multiplayerSettings.multiplayerGame.tooltip",
                onChange: newValue => {
                    this._setMultiplayerOptionsEnableState(newValue);
                }
            });
            const playerAccessItems = validPlayerAccess.map((v => {
                const item = {
                    label: playerAccessLocalization[v],
                    value: v
                };
                return item;
            }));
            const playerAccessPropItem = multiplayerSettingsPane.addDropdown(this._worldSettingsPaneData.playerAccess, {
                title: "resourcePack.editor.exportProject.multiplayerSettings.playerAccess",
                tooltip: "resourcePack.editor.exportProject.multiplayerSettings.playerAccess.tooltip",
                entries: playerAccessItems,
                enable: isMultiplayerEnabled
            });
            this._multiplayerPropertyItems.push(playerAccessPropItem);
            const playerPermissionLevelItems = validPlayerPermissionLevels.map((v => {
                const item = {
                    label: playerPermissionLocalization[v],
                    value: v
                };
                return item;
            }));
            const playerPermissionsPropItem = multiplayerSettingsPane.addDropdown(this._worldSettingsPaneData.playerPermissions, {
                title: "resourcePack.editor.exportProject.multiplayerSettings.playerPermissions",
                tooltip: "resourcePack.editor.exportProject.multiplayerSettings.playerPermissions.tooltip",
                entries: playerPermissionLevelItems,
                enable: isMultiplayerEnabled
            });
            this._multiplayerPropertyItems.push(playerPermissionsPropItem);
            const lanVisibilityPropItem = multiplayerSettingsPane.addBool(this._worldSettingsPaneData.lanVisibility, {
                title: "resourcePack.editor.exportProject.multiplayerSettings.visibleToLAN",
                tooltip: "resourcePack.editor.exportProject.multiplayerSettings.visibleToLAN.tooltip",
                enable: isMultiplayerEnabled
            });
            this._multiplayerPropertyItems.push(lanVisibilityPropItem);
            const friendlyFirePropItem = multiplayerSettingsPane.addBool(this._worldSettingsPaneData.friendlyFire, {
                title: "resourcePack.editor.exportProject.multiplayerSettings.friendlyFire",
                tooltip: "resourcePack.editor.exportProject.multiplayerSettings.friendlyFire.tooltip",
                enable: isMultiplayerEnabled
            });
            this._multiplayerPropertyItems.push(friendlyFirePropItem);
            multiplayerSettingsPane.endConstruct();
        }
        _buildCheatSectionOfPane() {
            const cheatsSettingsPane = this._parentPane.createSubPane({
                title: `resourcePack.editor.exportProject.cheatsSettings`,
                collapsed: true,
                infoTooltip: {
                    title: `resourcePack.editor.exportProject.cheatsSettings`,
                    description: [ `resourcePack.editor.exportProject.cheatsSettings.tooltip` ]
                }
            });
            cheatsSettingsPane.beginConstruct();
            const cheatsPropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.cheats, {
                title: `resourcePack.editor.exportProject.cheatsSettings.cheats`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.cheats.tooltip`,
                onChange: newValue => {
                    this._setToDefaultCheatOptions(newValue);
                }
            });
            this._nonHardCorePropertyItems.push(cheatsPropItem);
            const daylightCycleItems = validDaylightCycle.map((v => {
                const item = {
                    label: daylightCycleLocalization[v],
                    value: v
                };
                return item;
            }));
            const daylightCyclePropItem = cheatsSettingsPane.addDropdown(this._worldSettingsPaneData.daylightCycle, {
                title: `resourcePack.editor.exportProject.cheatsSettings.daylightCycle`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.daylightCycle.tooltip`,
                enable: cheatsPropItem.value,
                entries: daylightCycleItems
            });
            this._cheatItems.set("daylightCycle", {
                item: daylightCyclePropItem,
                observable: this._worldSettingsPaneData.daylightCycle
            });
            const keepInventoryPropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.keepInventory, {
                title: `resourcePack.editor.exportProject.cheatsSettings.keepInventory`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.keepInventory.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("keepInventory", {
                item: keepInventoryPropItem,
                observable: this._worldSettingsPaneData.keepInventory
            });
            const mobSpawningPropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.mobSpawning, {
                title: `resourcePack.editor.exportProject.cheatsSettings.mobSpawning`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.mobSpawning.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("mobSpawning", {
                item: mobSpawningPropItem,
                observable: this._worldSettingsPaneData.mobSpawning
            });
            const mobGriefingPropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.mobGriefing, {
                title: `resourcePack.editor.exportProject.cheatsSettings.mobGriefing`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.mobGriefing.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("mobGriefing", {
                item: mobGriefingPropItem,
                observable: this._worldSettingsPaneData.mobGriefing
            });
            const entitiesDropLootPropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.entitiesDropLoot, {
                title: `resourcePack.editor.exportProject.cheatsSettings.entitiesDropLoot`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.entitiesDropLoot.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("entitiesDropLoot", {
                item: entitiesDropLootPropItem,
                observable: this._worldSettingsPaneData.entitiesDropLoot
            });
            const disableWeatherPropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.disableWeather, {
                title: `resourcePack.editor.exportProject.cheatsSettings.weatherCycle`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.weatherCycle.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("disableWeather", {
                item: disableWeatherPropItem,
                observable: this._worldSettingsPaneData.disableWeather
            });
            const commandBlockEnabledPropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.commandBlockEnabled, {
                title: `resourcePack.editor.exportProject.cheatsSettings.commandBlocks`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.commandBlocks.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("commandBlockEnabled", {
                item: commandBlockEnabledPropItem,
                observable: this._worldSettingsPaneData.commandBlockEnabled
            });
            const commandBlockOutputPropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.commandBlockOutput, {
                title: `resourcePack.editor.exportProject.cheatsSettings.commandBlockOutput`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.commandBlockOutput.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("commandBlockOutput", {
                item: commandBlockOutputPropItem,
                observable: this._worldSettingsPaneData.commandBlockOutput
            });
            const sendCommandFeedbackPropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.sendCommandFeedback, {
                title: `resourcePack.editor.exportProject.cheatsSettings.sendCommandFeedback`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.sendCommandFeedback.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("sendCommandFeedback", {
                item: sendCommandFeedbackPropItem,
                observable: this._worldSettingsPaneData.sendCommandFeedback
            });
            const maxCommandChainLengthPropItem = cheatsSettingsPane.addNumber(this._worldSettingsPaneData.maxCommandChainLength, {
                title: `resourcePack.editor.exportProject.cheatsSettings.maxCommandChainLength`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.maxCommandChainLength.tooltip`,
                enable: cheatsPropItem.value,
                min: 0,
                max: 2147483647
            });
            this._cheatItems.set("maxCommandChainLength", {
                item: maxCommandChainLengthPropItem,
                observable: this._worldSettingsPaneData.maxCommandChainLength
            });
            const fireDamagePropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.fireDamage, {
                title: `resourcePack.editor.exportProject.cheatsSettings.fireDamage`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.fireDamage.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("fireDamage", {
                item: fireDamagePropItem,
                observable: this._worldSettingsPaneData.fireDamage
            });
            const freezeDamagePropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.freezeDamage, {
                title: `resourcePack.editor.exportProject.cheatsSettings.freezeDamage`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.freezeDamage.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("freezeDamage", {
                item: freezeDamagePropItem,
                observable: this._worldSettingsPaneData.freezeDamage
            });
            const fallDamagePropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.fallDamage, {
                title: `resourcePack.editor.exportProject.cheatsSettings.fallDamage`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.fallDamage.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("fallDamage", {
                item: fallDamagePropItem,
                observable: this._worldSettingsPaneData.fallDamage
            });
            const drowningDamagePropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.drowningDamage, {
                title: `resourcePack.editor.exportProject.cheatsSettings.drowningDamage`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("drowningDamage", {
                item: drowningDamagePropItem,
                observable: this._worldSettingsPaneData.drowningDamage
            });
            const insomniaPropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.insomnia, {
                title: `resourcePack.editor.exportProject.cheatsSettings.insomnia`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.insomnia.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("insomnia", {
                item: insomniaPropItem,
                observable: this._worldSettingsPaneData.insomnia
            });
            const showBorderEffectPropItem = cheatsSettingsPane.addBool(this._worldSettingsPaneData.showBorderEffect, {
                title: `resourcePack.editor.exportProject.cheatsSettings.showBorderEffect`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.showBorderEffect.tooltip`,
                enable: cheatsPropItem.value
            });
            this._cheatItems.set("showBorderEffect", {
                item: showBorderEffectPropItem,
                observable: this._worldSettingsPaneData.showBorderEffect
            });
            const functionCommandLimitPropItem = cheatsSettingsPane.addNumber(this._worldSettingsPaneData.functionCommandLimit, {
                title: `resourcePack.editor.exportProject.cheatsSettings.functionCommandLimit`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.functionCommandLimit.tooltip`,
                enable: cheatsPropItem.value,
                min: 0,
                max: 1e4
            });
            this._cheatItems.set("functionCommandLimit", {
                item: functionCommandLimitPropItem,
                observable: this._worldSettingsPaneData.functionCommandLimit
            });
            cheatsSettingsPane.addBool(this._worldSettingsPaneData.educationEdition, {
                title: "resourcePack.editor.exportProject.cheatsSettings.educationFeatures",
                tooltip: "resourcePack.editor.exportProject.cheatsSettings.educationFeatures.tooltip",
                enable: false
            });
            const randomTickSpeedPropItem = cheatsSettingsPane.addNumber(this._worldSettingsPaneData.randomTickSpeed, {
                title: `resourcePack.editor.exportProject.cheatsSettings.randomTickSpeed`,
                tooltip: `resourcePack.editor.exportProject.cheatsSettings.randomTickSpeed.tooltip`,
                enable: cheatsPropItem.value,
                min: 0,
                max: 4096
            });
            this._cheatItems.set("randomTickSpeed", {
                item: randomTickSpeedPropItem,
                observable: this._worldSettingsPaneData.randomTickSpeed
            });
            cheatsSettingsPane.endConstruct();
        }
        _setMultiplayerOptionsEnableState(isMultiplayerOptionEnabled) {
            this._multiplayerPropertyItems.forEach((propItem => {
                propItem.enable = isMultiplayerOptionEnabled;
            }));
        }
        _onHardcoreChanged(isHardCore, gameModeIndex, difficultyIndex) {
            this._currentGameModeDropdownItems = this._getGameModeDropdownItems(isHardCore);
            this._currentDifficultyDropDownItems = this._getDifficultyDropdownItems(isHardCore);
            this._gameModePropertyItem.updateEntries(this._currentGameModeDropdownItems, this._currentGameModeDropdownItems[isHardCore ? 0 : gameModeIndex].value);
            this._difficultyPropertyItem.updateEntries(this._currentDifficultyDropDownItems, this._currentDifficultyDropDownItems[isHardCore ? 0 : difficultyIndex].value);
            this._nonHardCorePropertyItems.forEach((item => {
                item.enable = !isHardCore;
            }));
        }
        _setToDefaultCheatOptions(isCheatsOptionEnabled) {
            this._cheatItems.forEach(((prop, key) => {
                prop.item.enable = isCheatsOptionEnabled;
                if (!isCheatsOptionEnabled) {
                    prop.observable.set(this._defaultGameOptions[key]);
                }
            }));
        }
        _setToDefaultInitialPayOptions() {
            const timeItems = this._getTimeItemDropdownItems();
            this._timeOfDayPropItem?.updateEntries(timeItems, TODDropDown.None);
            const clockItems = this._getClockTypeDropdownItems();
            this._clockTypePropItem?.updateEntries(clockItems, ClockType.MINECRAFT_CLOCK);
            this._weatherPropItem?.updateEntries(weatherDropdownItems, this._defaultGameOptions.weather);
        }
        _getTimeItemDropdownItems() {
            const timeItem = validPresets.map((v => {
                if (v.time === TODDropDown.None) {
                    const item = {
                        label: "resourcePack.editor.timeOfDay.dropDown.custom",
                        value: v.time
                    };
                    return item;
                }
                const item = {
                    label: v.stringId,
                    value: v.time
                };
                return item;
            }));
            return timeItem;
        }
        _getClockTypeDropdownItems() {
            return clockValues.map((v => {
                const item = {
                    label: v.stringId,
                    value: v.index
                };
                return item;
            }));
        }
        _getGameModeDropdownItems(hardcore) {
            if (hardcore) {
                return gameModeDropDownItems.filter((dropDownItem => dropDownItem.value !== gameModeLookUpIndex[server_namespaceObject.GameMode.Creative]));
            }
            return gameModeDropDownItems;
        }
        _getDifficultyDropdownItems(hardcore) {
            if (hardcore) {
                const hardcoreDifficultyItem = {
                    label: difficultyLocalization[server_namespaceObject.Difficulty.Hard],
                    value: difficultyLookUpIndex[server_namespaceObject.Difficulty.Hard]
                };
                return [ hardcoreDifficultyItem ];
            }
            return difficultyDropDownItems;
        }
        _isPlayerAsSpawnPointPropItemEnabled(dimension) {
            return MinecraftDimensionTypes.Overworld === dimension.id;
        }
        _storeLastCheatValues() {
            this._cheatItems.forEach(((prop, key) => {
                if (this._lastCheatsValues) {
                    this._lastCheatsValues.set(key, prop.observable.value);
                }
            }));
        }
        _setCheatsToLastValues(cheatsEnabled) {
            if (this._lastCheatsValues) {
                this._cheatItems.forEach(((prop, key) => {
                    const lastVal = this._lastCheatsValues.get(key);
                    if (lastVal !== undefined) {
                        prop.observable.set(lastVal);
                    }
                    prop.item.enable = cheatsEnabled;
                }));
            }
        }
        teardown() {}
    }
    const SHOULD_LOG_TELEMETRY = false;
    var TelemetrySource;
    (function(TelemetrySource) {
        TelemetrySource["Selection"] = "SELECTION";
        TelemetrySource["PastePreview"] = "PASTE_PREVIEW";
        TelemetrySource["Line"] = "LINE";
        TelemetrySource["Summon"] = "SUMMON";
        TelemetrySource["Ruler"] = "RULER";
        TelemetrySource["Brush"] = "BRUSH";
        TelemetrySource["Flatten"] = "FLATTEN";
        TelemetrySource["SmartFill"] = "SMART_FILL";
        TelemetrySource["Terrain"] = "TERRAIN";
        TelemetrySource["Extrude"] = "EXTRUDE";
        TelemetrySource["Repeater"] = "REPEATER";
        TelemetrySource["Farm"] = "FARM";
        TelemetrySource["Grapple"] = "GRAPPLE";
        TelemetrySource["DeferredLighting"] = "DEFERRED_LIGHTING";
        TelemetrySource["TimeOfDay"] = "TIME_OF_DAY";
        TelemetrySource["Export"] = "EXPORT";
        TelemetrySource["TestWorld"] = "TEST_WORLD";
        TelemetrySource["Settings"] = "SETTINGS";
        TelemetrySource["Locate"] = "LOCATE";
        TelemetrySource["Navigation"] = "NAVIGATION";
        TelemetrySource["BlockInspector"] = "BLOCK_INSPECTOR";
        TelemetrySource["EntityInspector"] = "ENTITY_INSPECTOR";
        TelemetrySource["Workbench"] = "WORKBENCH";
        TelemetrySource["RealmsUpload"] = "REALMS_UPLOAD";
        TelemetrySource["Pencil"] = "PENCIL";
    })(TelemetrySource || (TelemetrySource = {}));
    function fireTelemetryEvent(player, source, eventName, properties = {}) {
        if (SHOULD_LOG_TELEMETRY) {
            server_editor_namespaceObject.editor.log.debug(`${source}::${eventName}::${JSON.stringify(properties)}`, {
                player,
                tags: [ "Telemetry" ]
            });
        }
        server_editor_private_bindings_namespaceObject.editorInternal.fireTelemetryEvent(player, source, eventName, JSON.stringify(properties));
    }
    class TelemetryManager {
        constructor(player, telemetrySource) {
            this._player = player;
            this._source = telemetrySource;
        }
        fireTelemetryEvent(eventName, properties = {}, shouldFire = true) {
            if (!shouldFire) {
                return;
            }
            fireTelemetryEvent(this._player, this._source, eventName, properties);
        }
    }
    class logInterface {
        debug(_m) {
            if (this._debug) this._debug(_m);
        }
        error(_m) {
            if (this._error) this._error(_m);
        }
        onStep(_path, _key, _type, _data, _properties) {
            if (this._onStep) {
                this._onStep(_path, _key, _type, _data, _properties);
            }
        }
    }
    var OpNodeSourceType;
    (function(OpNodeSourceType) {
        OpNodeSourceType["NULL"] = "null";
        OpNodeSourceType["BOOLEAN"] = "boolean";
        OpNodeSourceType["OBJECT"] = "object";
        OpNodeSourceType["ARRAY"] = "array";
        OpNodeSourceType["NUMBER"] = "number";
        OpNodeSourceType["INTEGER"] = "integer";
        OpNodeSourceType["STRING"] = "string";
        OpNodeSourceType["MAP"] = "map";
        OpNodeSourceType["ENUM"] = "enum";
    })(OpNodeSourceType || (OpNodeSourceType = {}));
    function _isDataOfType(data, type) {
        switch (type) {
          case OpNodeSourceType.NULL:
            return data === undefined;

          case OpNodeSourceType.BOOLEAN:
            return typeof data === "boolean";

          case OpNodeSourceType.ARRAY:
            return Array.isArray(data);

          case OpNodeSourceType.NUMBER:
            return typeof data === "number";

          case OpNodeSourceType.INTEGER:
            return Number.isInteger(data);

          case OpNodeSourceType.STRING:
            return typeof data === "string";

          case OpNodeSourceType.MAP:
          case OpNodeSourceType.OBJECT:
            return typeof data === "object";

          case OpNodeSourceType.ENUM:
            return typeof data === "string";

          default:
            return false;
        }
    }
    var OpNodeEditorUIControlType;
    (function(OpNodeEditorUIControlType) {
        OpNodeEditorUIControlType["FLOAT"] = "float";
        OpNodeEditorUIControlType["TEXT"] = "text";
        OpNodeEditorUIControlType["SLIDER"] = "slider";
        OpNodeEditorUIControlType["CHECKBOX"] = "checkbox";
        OpNodeEditorUIControlType["COLOR"] = "color";
        OpNodeEditorUIControlType["VECTOR3"] = "vector3";
        OpNodeEditorUIControlType["DROPDOWN"] = "dropdown";
        OpNodeEditorUIControlType["COLOR_TIMELINE"] = "color_timeline";
        OpNodeEditorUIControlType["NUMBER_TIMELINE"] = "number_timeline";
        OpNodeEditorUIControlType["UNKNOWN"] = "unknown";
    })(OpNodeEditorUIControlType || (OpNodeEditorUIControlType = {}));
    class OpPropertyPattern {
        constructor(pattern) {
            this._pattern = pattern;
        }
        get pattern() {
            return this._pattern;
        }
        clone() {
            return new OpPropertyPattern(this._pattern);
        }
        toString() {
            return `Pattern(${this._pattern})`;
        }
        validate(_key, _data, _log) {
            if (typeof _data !== "string") {
                _log?.error(`Key(${_key}): Data(${JSON.stringify(_data)}) is not a string`);
                return false;
            }
            const regex = new RegExp(this._pattern);
            const isMatch = regex.test(_data);
            if (!isMatch) {
                _log?.error(`Key(${_key}): Data(${String(_data)}) does not match pattern(${this._pattern})`);
            }
            return isMatch;
        }
    }
    class OpPropertyEditorTag {
        constructor(editorTag) {
            this._editorTag = editorTag;
        }
        get editorTag() {
            return this._editorTag;
        }
        clone() {
            return new OpPropertyEditorTag(this._editorTag);
        }
        toString() {
            return `Editor tag (${this._editorTag})`;
        }
        validate(_key, _data, _log) {
            return true;
        }
    }
    class OpPropertyValueRange {
        constructor(minimum, maximum) {
            this._minimum = minimum;
            this._maximum = maximum;
        }
        get min() {
            return this._minimum;
        }
        get max() {
            return this._maximum;
        }
        clone() {
            return new OpPropertyValueRange(this._minimum, this._maximum);
        }
        toString() {
            return `ValueRange(${this._minimum}, ${this._maximum})`;
        }
        validate(_key, data, _log) {
            if (typeof data !== "number") {
                _log?.error(`Key(${_key}): Data(${JSON.stringify(data)}) is not a number`);
                return false;
            }
            const isInRange = data >= this._minimum && data <= this._maximum;
            if (!isInRange) {
                _log?.error(`Key(${_key}): Data(${Number(data)}) is not in range(${this._minimum}, ${this._maximum})`);
            }
            return isInRange;
        }
    }
    class OpPropertyArrayBounds {
        constructor(minItems, maxItems) {
            this._minItems = minItems;
            this._maxItems = maxItems;
        }
        get minItems() {
            return this._minItems;
        }
        get maxItems() {
            return this._maxItems;
        }
        clone() {
            return new OpPropertyArrayBounds(this._minItems, this._maxItems);
        }
        toString() {
            return `ArrayBounds(${String(this._minItems)}, ${String(this._maxItems)})`;
        }
        validate(_key, _data, _log) {
            if (!Array.isArray(_data)) {
                return false;
            }
            if (this._minItems !== undefined && _data.length < this._minItems) {
                _log?.error(`Key(${_key}): Data(${JSON.stringify(_data)}) has less than min items(${this._minItems})`);
                return false;
            }
            if (this._maxItems !== undefined && _data.length > this._maxItems) {
                _log?.error(`Key(${_key}): Data(${JSON.stringify(_data)}) has more than max items(${this._maxItems})`);
                return false;
            }
            return true;
        }
    }
    class OpPropertyMapBounds {
        constructor(minProperties, maxProperties) {
            this._minProperties = minProperties;
            this._maxProperties = maxProperties;
        }
        get minProperties() {
            return this._minProperties;
        }
        get maxProperties() {
            return this._maxProperties;
        }
        clone() {
            return new OpPropertyMapBounds(this._minProperties, this._maxProperties);
        }
        toString() {
            return `MapBounds(${String(this._minProperties)}, ${String(this._maxProperties)})`;
        }
        validate(_key, _data, _log) {
            if (typeof _data !== "object") {
                return false;
            }
            const keys = Object.keys(_data);
            if (this._minProperties !== undefined && keys.length < this._minProperties) {
                _log?.error(`Key(${_key}): Data(${JSON.stringify(_data)}) has less than min properties(${this._minProperties})`);
                return false;
            }
            if (this._maxProperties !== undefined && keys.length > this._maxProperties) {
                _log?.error(`Key(${_key}): Data(${JSON.stringify(_data)}) has more than max properties(${this._maxProperties})`);
                return false;
            }
            return true;
        }
    }
    class OpPropertyStringLiteral {
        constructor(literal) {
            this._literal = literal;
        }
        get literal() {
            return this._literal;
        }
        clone() {
            return new OpPropertyStringLiteral(this._literal);
        }
        toString() {
            return `Literal(${this._literal})`;
        }
        validate(_key, _data, _log) {
            const isMatch = _key.localeCompare(this._literal) === 0;
            return isMatch;
        }
    }
    class OpPropertyEnum {
        constructor(enums) {
            this._enums = [];
            this._prettyEnums = [];
            this._enums = enums;
            this._prettyEnums = enums.map((e => e));
        }
        get enums() {
            return this._enums;
        }
        get prettyEnums() {
            return this._prettyEnums;
        }
        prettifyEnums(prettyFunction) {
            this._prettyEnums = this._enums.map((e => prettyFunction(e)));
        }
        getIndexOf(data) {
            let index = this._enums.indexOf(data);
            if (index < 0) {
                index = this._prettyEnums.indexOf(data);
            }
            return index;
        }
        clone() {
            return new OpPropertyEnum(this._enums);
        }
        toString() {
            return `Enum(${this._prettyEnums.join(", ")})`;
        }
        validate(_key, _data, _log) {
            if (typeof _data !== "string") {
                return false;
            }
            const isMatch = this._enums.includes(_data) || this._prettyEnums.includes(_data);
            if (!isMatch) {
                _log?.error(`Key(${_key}): Data(${_data}) is not in enum[${this._enums.join(", ")}]`);
            }
            return isMatch;
        }
    }
    class OpPropertyReadOnly {
        clone() {
            return new OpPropertyReadOnly;
        }
        toString() {
            return `ReadOnly(true)`;
        }
        validate(_key, _data, _log) {
            return true;
        }
    }
    class OpPropertyPrettifier {
        clone() {
            return new OpPropertyPrettifier;
        }
        toString() {
            return `Prettify(true)`;
        }
        validate(_key, _data, _log) {
            return true;
        }
        prettify(_input) {
            if (_input.startsWith("minecraft:")) {
                _input = _input.substring(10);
            }
            _input = _input.replace(/_/g, " ");
            _input = _input.replace(/([a-z])([A-Z])/g, "$1 $2");
            _input = _input.split(" ").map((word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase())).join(" ");
            return _input;
        }
    }
    class OpPropertyLabelAliases {
        constructor(labelRemaps) {
            this._labelRemaps = labelRemaps;
        }
        get aliases() {
            return this._labelRemaps;
        }
        addAlias(_original, _new) {
            this._labelRemaps[_original] = _new;
        }
        clone() {
            return new OpPropertyLabelAliases(this._labelRemaps);
        }
        toString() {
            return `Labels(${Object.entries(this._labelRemaps).map((([key, value]) => `${key}:${value}`)).join(", ")})`;
        }
        validate(_key, _data, _log) {
            if (typeof this._labelRemaps !== "object" && !Array.isArray(this._labelRemaps)) {
                _log?.error(`format for alias ${JSON.stringify(this._labelRemaps)} is invalid`);
                return false;
            }
            const isMatch = Object.keys(this._labelRemaps).every((key => typeof key === "string" && typeof this._labelRemaps[key] === "string"));
            return isMatch;
        }
        getLabelAlias(_label) {
            return this._labelRemaps[_label] ?? _label;
        }
    }
    class OpPropertyTags {
        constructor(_tags) {
            this._tags = [];
            this._tags = _tags;
        }
        get tags() {
            return this._tags;
        }
        addTag(_new) {
            this.tags.push(_new);
        }
        clone() {
            return new OpPropertyTags(this._tags);
        }
        toString() {
            return `Tags(${this._tags.join(", ")})`;
        }
        validate(_tag, _log) {
            if (typeof this._tags !== "object" && !Array.isArray(this._tags)) {
                _log?.error(`format for tags ${JSON.stringify(this._tags)} is invalid`);
                return false;
            }
            const isMatch = this._tags.some((tag => tag === _tag));
            return isMatch;
        }
    }
    class OpPropertyHelp {
        constructor(_help) {
            this._help = _help;
        }
        get help() {
            return this._help;
        }
        clone() {
            return new OpPropertyHelp(this._help);
        }
        toString() {
            return `Help(${this._help})`;
        }
        validate(_help, _log) {
            return true;
        }
    }
    class OpPropertyType {
        constructor(type) {
            this._type = OpNodeSourceType.NULL;
            this._type = type;
        }
        get type() {
            return this._type;
        }
        clone() {
            return new OpPropertyType(this._type);
        }
        toString() {
            return `Type(${this._type})`;
        }
        validate(_key, _data, _log) {
            return _isDataOfType(_data, this._type);
        }
    }
    class OpPropertyEditorUIControl {
        constructor(controlType) {
            this._controlType = OpNodeEditorUIControlType.UNKNOWN;
            this._controlType = controlType;
        }
        get controlType() {
            return this._controlType;
        }
        clone() {
            return new OpPropertyEditorUIControl(this._controlType);
        }
        toString() {
            return `EditorControl(${this._controlType})`;
        }
        validate(_key, _data, _log) {
            return true;
        }
    }
    class OpPropertyStack {
        constructor() {
            this._properties = [];
        }
        addOrReplaceProperty(property) {
            for (let i = 0; i < this._properties.length; i++) {
                if (this._properties[i].constructor.name === property.constructor.name) {
                    this._properties[i] = property;
                    return;
                }
            }
            this._properties.push(property);
        }
        removeProperty(propType) {
            for (let i = 0; i < this._properties.length; i++) {
                if (this._properties[i].constructor.name === propType) {
                    this._properties.splice(i, 1);
                    return;
                }
            }
        }
        hasProperty(propType) {
            for (let i = 0; i < this._properties.length; i++) {
                if (this._properties[i].constructor.name === propType) {
                    return true;
                }
            }
            return false;
        }
        getProperty(propType) {
            for (let i = 0; i < this._properties.length; i++) {
                if (this._properties[i].constructor.name === propType) {
                    return this._properties[i];
                }
            }
            return undefined;
        }
        _extractEditorProperties(_node, _schemaTagString) {
            if (!_schemaTagString || _schemaTagString.length === 0) {
                return;
            }
            const splitKeyValuePairs = data => {
                const pairs = [];
                let inBraces = false;
                let key = "";
                let current = "";
                let expectValue = false;
                for (const char of data) {
                    if (char === "{") {
                        inBraces = true;
                        current += char;
                    } else if (char === "}") {
                        inBraces = false;
                        current += char;
                    } else if (char === ":" && !inBraces) {
                        key = current.trim();
                        current = "";
                        expectValue = true;
                    } else if (char === "," && !inBraces) {
                        const keyValue = current.trim();
                        pairs.push({
                            key,
                            keyValue
                        });
                        current = "";
                        expectValue = false;
                    } else {
                        current += char;
                    }
                }
                if (expectValue) {
                    const keyValue = current.trim();
                    pairs.push({
                        key,
                        keyValue
                    });
                }
                return pairs;
            };
            const isValidTagOrLabel = name => {
                const identifierRegex = /^[A-Za-z_][A-Za-z0-9_]*$/;
                return identifierRegex.test(name);
            };
            const keyValuePairs = splitKeyValuePairs(_schemaTagString);
            const aliasRemaps = new OpPropertyLabelAliases({});
            const tags = new OpPropertyTags([]);
            let help;
            for (const {key, keyValue} of keyValuePairs) {
                if (key === "alias" && keyValue.startsWith("{") && keyValue.endsWith("}")) {
                    const aliasKeyValue = keyValue.slice(1, -1);
                    const aliasKeyValuePairs = splitKeyValuePairs(aliasKeyValue);
                    Object.entries(aliasKeyValuePairs).forEach((([_, value]) => {
                        const aliasKey = value.key.trim();
                        const aliasValue = value.keyValue.trim();
                        if (aliasKey && aliasValue) {
                            aliasRemaps.addAlias(aliasKey, aliasValue);
                        } else {
                            throw new Error(`Invalid alias key-value pair: ${JSON.stringify(keyValuePairs)}`);
                        }
                    }));
                } else if (key === "tag" && keyValue.startsWith("{") && keyValue.endsWith("}")) {
                    const tagKeyValue = keyValue.slice(1, -1);
                    const tagKeyValuePairs = tagKeyValue.split(",");
                    tagKeyValuePairs.forEach((tag => {
                        const t = tag.trim();
                        if (!isValidTagOrLabel(t)) {
                            throw new Error(`Invalid tag: ${t}`);
                        }
                        tags.addTag(t);
                    }));
                } else if (key === "help" && keyValue.startsWith("{") && keyValue.endsWith("}")) {
                    const tagKeyValue = keyValue.slice(1, -1);
                    help = new OpPropertyHelp(tagKeyValue.trim());
                } else {
                    if (!(key && keyValue)) {
                        throw new Error(`Invalid (key:value,...) key-value pair: ${JSON.stringify(keyValuePairs)}`);
                    }
                    const prettifyOrReadonlyModifier = keyValue === "true" || keyValue === "1" || keyValue === "yes" || keyValue === "on";
                    if (key === "prettify") {
                        if (prettifyOrReadonlyModifier) {
                            this.addOrReplaceProperty(new OpPropertyPrettifier);
                        }
                    } else if (key === "readonly") {
                        if (prettifyOrReadonlyModifier) {
                            this.addOrReplaceProperty(new OpPropertyReadOnly);
                        }
                    } else if (key === "type") {
                        let controlType = OpNodeEditorUIControlType.FLOAT;
                        switch (keyValue) {
                          case "float":
                          case "number":
                            controlType = OpNodeEditorUIControlType.FLOAT;
                            break;

                          case "text":
                          case "string":
                            controlType = _node.enum !== undefined ? OpNodeEditorUIControlType.DROPDOWN : OpNodeEditorUIControlType.TEXT;
                            break;

                          case "enum":
                          case "dropdown":
                            controlType = OpNodeEditorUIControlType.DROPDOWN;
                            break;

                          case "slider":
                            controlType = OpNodeEditorUIControlType.SLIDER;
                            break;

                          case "checkbox":
                          case "boolean":
                          case "bool":
                            controlType = OpNodeEditorUIControlType.CHECKBOX;
                            break;

                          case "color":
                            controlType = OpNodeEditorUIControlType.COLOR;
                            break;

                          case "vector3":
                          case "vec3":
                            controlType = OpNodeEditorUIControlType.VECTOR3;
                            break;

                          case "colorTimeline":
                            controlType = OpNodeEditorUIControlType.COLOR_TIMELINE;
                            break;

                          case "numberTimeline":
                            controlType = OpNodeEditorUIControlType.NUMBER_TIMELINE;
                            break;

                          default:
                            controlType = OpNodeEditorUIControlType.UNKNOWN;
                            throw new Error(`Unknown editor control type: ${keyValue}`);
                        }
                        this.addOrReplaceProperty(new OpPropertyEditorUIControl(controlType));
                    }
                }
            }
            if (Object.keys(aliasRemaps.aliases).length > 0) {
                this.addOrReplaceProperty(aliasRemaps);
            }
            if (Object.keys(tags.tags).length > 0) {
                this.addOrReplaceProperty(tags);
            }
            if (help !== undefined) {
                this.addOrReplaceProperty(help);
            }
        }
        extractProperties(node) {
            if (node === undefined) {
                return;
            }
            if (node.type !== undefined) {
                let nodeType = OpNodeSourceType.NULL;
                switch (node.type) {
                  case "null":
                    nodeType = OpNodeSourceType.NULL;
                    break;

                  case "boolean":
                    nodeType = OpNodeSourceType.BOOLEAN;
                    break;

                  case "object":
                    nodeType = node.additionalProperties !== undefined ? OpNodeSourceType.MAP : OpNodeSourceType.OBJECT;
                    break;

                  case "array":
                    nodeType = OpNodeSourceType.ARRAY;
                    break;

                  case "number":
                    nodeType = OpNodeSourceType.NUMBER;
                    break;

                  case "integer":
                    nodeType = OpNodeSourceType.INTEGER;
                    break;

                  case "string":
                    nodeType = node.enum !== undefined ? OpNodeSourceType.ENUM : OpNodeSourceType.STRING;
                    break;

                  default:
                    throw new Error(`Unknown type: ${JSON.stringify(node.type)}`);
                }
                this.addOrReplaceProperty(new OpPropertyType(nodeType));
            }
            if (node.enum !== undefined) {
                const enumArray = [ ...node.enum ];
                this.addOrReplaceProperty(new OpPropertyEnum(enumArray));
            }
            if (node.$metaProperties !== undefined && node.$metaProperties.CEREAL_EDITOR_SCHEMA_TAG !== undefined) {
                this.addOrReplaceProperty(new OpPropertyEditorTag(node.$metaProperties.CEREAL_EDITOR_SCHEMA_TAG));
                const description = String(node.$metaProperties.CEREAL_EDITOR_SCHEMA_TAG).trim();
                this._extractEditorProperties(node, description);
            }
            if (node.minimum !== undefined && node.maximum !== undefined) {
                this.addOrReplaceProperty(new OpPropertyValueRange(node.minimum, node.maximum));
            }
            if (node.pattern !== undefined) {
                this.addOrReplaceProperty(new OpPropertyPattern(node.pattern));
            }
            if (node.minProperties !== undefined || node.maxProperties !== undefined || node.additionalProperties !== undefined) {
                this.addOrReplaceProperty(new OpPropertyMapBounds(node.minProperties, node.maxProperties));
            } else if (node.minItems !== undefined || node.maxItems !== undefined || node.items !== undefined) {
                this.addOrReplaceProperty(new OpPropertyArrayBounds(node.minItems, node.maxItems));
            }
        }
        clone() {
            const stack = new OpPropertyStack;
            for (const property of this._properties) {
                stack.addOrReplaceProperty(property.clone());
            }
            return stack;
        }
        toString() {
            let str = "";
            for (let i = this._properties.length - 1; i >= 0; i--) {
                str += this._properties[i].toString() + " ";
            }
            return str;
        }
        validateAll(_key, _data, _log) {
            for (let i = this._properties.length - 1; i >= 0; i--) {
                if (!this._properties[i].validate(_key, _data, _log)) {
                    return false;
                }
            }
            return true;
        }
        validate(_type, _key, data, _log) {
            const property = this.getProperty(_type);
            if (property === undefined) {
                return true;
            }
            return property.validate(_key, data, _log);
        }
    }
    class OpBaseNode {
        constructor(_tabDepth, _schemaObject, _refMap, _propertyStack, _logger) {
            this._type = OpNodeSourceType.NULL;
            this._children = [];
            this._propertyStack = new OpPropertyStack;
            this._logger = _logger;
            _tabDepth = _tabDepth + "    ";
            if (_schemaObject === undefined) {
                throw new Error("SchemaObject is undefined");
            }
            _propertyStack.extractProperties(_schemaObject);
            _schemaObject = _refMap.resolve(_schemaObject);
            _propertyStack.extractProperties(_schemaObject);
            this._propertyStack = _propertyStack.clone();
            this._title = _schemaObject?.title ?? "";
            this._editorMetaProperties = _schemaObject?.$metaProperties?.CEREAL_EDITOR_SCHEMA_TAG ?? "";
            this._type = _schemaObject?.type ?? OpNodeSourceType.OBJECT;
            this._isArray = _schemaObject?.items !== undefined || this._title === "sequence container";
            this._isMap = _schemaObject?.additionalProperties !== undefined || this._title === "associative container";
            this._id = _schemaObject?.$id ?? "no-id";
            this._oneOf = _schemaObject?.oneOf !== undefined;
            if (this._type === "object" && this._isMap) {
                this._type = OpNodeSourceType.MAP;
            } else if (this._type === "object" && this._isArray) {
                this._type = OpNodeSourceType.ARRAY;
            }
            this._logger?.debug(`${_tabDepth}Title: ${this._title}, Id: ${this._id}, Type: ${this._type}, OneOf: ${this._oneOf}, Array: ${this._isArray}, Map: ${this._isMap}`);
            this._logger?.debug(`  ${_tabDepth}props[ ${this._propertyStack.toString()} ]`);
            if (typeof _schemaObject === "object") {
                if (_schemaObject.oneOf !== undefined) {
                    for (const oneOfObject of _schemaObject.oneOf) {
                        const oneOfPropertyStack = _propertyStack.clone();
                        oneOfPropertyStack.extractProperties(oneOfObject);
                        oneOfPropertyStack.removeProperty("OpPropertyStringLiteral");
                        const node = new OpBaseNode(_tabDepth, oneOfObject, _refMap, oneOfPropertyStack, this._logger);
                        this._children.push(node);
                    }
                } else if (_schemaObject.properties !== undefined) {
                    for (const key in _schemaObject.properties) {
                        const propertyPropertyStack = _propertyStack.clone();
                        let property = _schemaObject.properties[key];
                        propertyPropertyStack.extractProperties(property);
                        property = _refMap.resolve(property);
                        propertyPropertyStack.extractProperties(property);
                        propertyPropertyStack.addOrReplaceProperty(new OpPropertyStringLiteral(key));
                        const node = new OpBaseNode(_tabDepth, property, _refMap, propertyPropertyStack, this._logger);
                        this._children.push(node);
                    }
                } else {
                    if (this._type === OpNodeSourceType.ARRAY) {
                        if (_schemaObject.items !== undefined) {
                            const itemPropertyStack = _propertyStack.clone();
                            itemPropertyStack.extractProperties(_schemaObject.items);
                            itemPropertyStack.removeProperty("OpPropertyArrayBounds");
                            itemPropertyStack.removeProperty("OpPropertyStringLiteral");
                            const node = new OpBaseNode(_tabDepth, _schemaObject.items, _refMap, itemPropertyStack, this._logger);
                            this._children.push(node);
                        }
                    } else if (this._type === OpNodeSourceType.MAP) {
                        const additionalPropertyStack = _propertyStack.clone();
                        additionalPropertyStack.extractProperties(_schemaObject.additionalProperties);
                        additionalPropertyStack.removeProperty("OpPropertyMapBounds");
                        additionalPropertyStack.removeProperty("OpPropertyStringLiteral");
                        const uiControl = additionalPropertyStack.getProperty("OpPropertyEditorUIControl");
                        if (uiControl !== undefined) {
                            if (uiControl.controlType === OpNodeEditorUIControlType.COLOR_TIMELINE || uiControl.controlType === OpNodeEditorUIControlType.NUMBER_TIMELINE) {
                                additionalPropertyStack.removeProperty("OpPropertyEditorUIControl");
                            }
                        }
                        const node = new OpBaseNode(_tabDepth, _schemaObject.additionalProperties, _refMap, additionalPropertyStack, this._logger);
                        this._children.push(node);
                    } else {
                        this._logger?.debug(`  ${_tabDepth}No properties or oneOf`);
                    }
                }
            } else {
                this._logger?.debug(`  ${_tabDepth} current schema object is ${typeof _schemaObject} should be type object`);
            }
        }
        hasMatchingKey(_key) {
            const literalProperty = this._propertyStack.getProperty("OpPropertyStringLiteral");
            if (literalProperty !== undefined) {
                const literal = literalProperty;
                if (literal.literal === _key) {
                    return true;
                }
            }
            return true;
        }
        validate(_key, _data, _tabDepth, _path) {
            _tabDepth = _tabDepth + "    ";
            if (!this._oneOf && _key !== "") {
                _path += "/" + _key;
            }
            this._logger?.debug(`${_tabDepth}Node: ${this._title}, Type: ${this._type}, Id: ${this._id}, OneOf: ${this._oneOf}, Props: ${this._propertyStack.toString()}, Children: ${this._children.length}`);
            this._logger?.debug(`${_tabDepth}incoming Key: ${_key}, Type: ${typeof _data}, Data: ${JSON.stringify(_data)}, `);
            const isArray = Array.isArray(_data);
            if (!this._oneOf) {
                if (!this._propertyStack.validate("OpPropertyStringLiteral", _key, _data, this._logger)) {
                    return false;
                }
                if (!_isDataOfType(_data, this._type)) {
                    this._logger?.debug(`${_tabDepth}  Type mismatch: ${typeof _data} != ${this._type} (Array: ${isArray})`);
                    return false;
                }
                if (!this._propertyStack.validate("OpPropertyType", _key, _data, this._logger)) {
                    this._logger?.debug(`${_tabDepth}  Type mismatch: ${typeof _data} != ${this._type} (Array: ${isArray})`);
                    return false;
                }
                if (this._type === OpNodeSourceType.ARRAY) {
                    if (!this._propertyStack.validate("OpPropertyArrayBounds", _key, _data, this._logger)) {
                        return false;
                    }
                }
                if (this._type === OpNodeSourceType.MAP) {
                    if (!this._propertyStack.validate("OpPropertyMapBounds", _key, _data, this._logger)) {
                        return false;
                    }
                }
                if (this.type === OpNodeSourceType.STRING) {
                    if (!this._propertyStack.validate("OpPropertyPattern", _key, _data, this._logger)) {
                        return false;
                    }
                }
                if (this.type === OpNodeSourceType.NUMBER || this.type === OpNodeSourceType.INTEGER) {
                    if (!this._propertyStack.validate("OpPropertyValueRange", _key, _data, this._logger)) {
                        return false;
                    }
                }
            }
            if (!this._propertyStack.validate("OpPropertyStringLiteral", _key, _data, this._logger)) {
                return false;
            }
            if (!this._propertyStack.validate("OpPropertyEditorTag", _key, _data, this._logger)) {
                return false;
            }
            if (!this._propertyStack.validate("OpPropertyLabelAliases", _key, _data, this._logger)) {
                return false;
            }
            if (!this._oneOf) {
                if (_path !== "" && _key !== "") {
                    this._logger?.onStep(_path, _key, this._type, _data, this._propertyStack);
                }
            }
            if (this._type === OpNodeSourceType.OBJECT || this._type === OpNodeSourceType.MAP || this._oneOf) {
                if (this._oneOf) {
                    for (const child of this._children) {
                        if (child.validate(_key, _data, _tabDepth, _path)) {
                            return true;
                        }
                    }
                    this._logger?.debug(`${_tabDepth}  Object bounds validation failed (Key: ${_key}, Data: ${JSON.stringify(_data)})`);
                    return false;
                }
                for (const objectKey in _data) {
                    let found = false;
                    for (const child of this._children) {
                        if (child.hasMatchingKey(objectKey)) {
                            if (child.validate(objectKey, _data[objectKey], _tabDepth, _path)) {
                                found = true;
                                break;
                            }
                        }
                    }
                    if (!found) {
                        return false;
                    }
                }
                this._logger?.debug(`${_tabDepth}  All object properties validated successfully`);
                return true;
            } else if (isArray) {
                for (let index = 0; index < _data.length; index++) {
                    const element = _data[index];
                    for (const child of this._children) {
                        if (!child.validate(String(index), element, _tabDepth, _path)) {
                            this._logger?.debug(`${_tabDepth}  Array validation failed`);
                            return false;
                        }
                    }
                }
                this._logger?.debug(`${_tabDepth}  Array validation PASSED`);
                return true;
            } else if (this._type === OpNodeSourceType.STRING) {
                const propertyType = this._propertyStack.getProperty("OpPropertyType");
                if (propertyType !== undefined) {
                    if (propertyType.type === OpNodeSourceType.ENUM) {
                        const enumProperty = this._propertyStack.getProperty("OpPropertyEnum");
                        if (enumProperty !== undefined) {
                            if (!enumProperty.validate(_key, _data, this._logger)) {
                                return false;
                            }
                            this._logger?.debug(`${_tabDepth}  Enum validation PASSED`);
                            return true;
                        } else {
                            this._logger?.debug(`${_tabDepth}  Enum property not found`);
                            return false;
                        }
                    }
                }
            }
            this._logger?.debug(`${_tabDepth}  Data: "${_key} : ${JSON.stringify(_data)}" - appears valid`);
            return true;
        }
        get title() {
            return this._title;
        }
        get editorProperties() {
            return this._editorMetaProperties;
        }
        get type() {
            return this._type;
        }
        get id() {
            return this._id;
        }
    }
    class SchemaRefMap {
        constructor(_definitions) {
            this._map = new Map;
            if (_definitions !== undefined) {
                for (const key in _definitions) {
                    this._map.set(key, _definitions[key]);
                }
            }
        }
        resolve(_schema) {
            if (_schema === undefined) {
                throw new Error("Schema is undefined");
            }
            const refPrologue = "#/definitions/";
            if (_schema.$ref === undefined) {
                return _schema;
            }
            let ref = _schema.$ref;
            if (ref.startsWith(refPrologue)) {
                ref = ref.substring(refPrologue.length);
            } else {
                throw new Error(`Failed to resolve ref: ${String(_schema.$ref)}`);
            }
            const result = this._map.get(ref);
            if (result === undefined) {
                throw new Error(`Failed to resolve ref: ${String(_schema.$ref)}`);
            }
            return this.resolve(result);
        }
    }
    class SchemaValidatorBuilder {
        constructor(_logger) {
            this._schemaObject = {};
            this._root = undefined;
            this._refMap = new SchemaRefMap(undefined);
            this._logger = _logger;
        }
        build(_schemaObject) {
            this._schemaObject = _schemaObject;
            if (_schemaObject.definitions !== undefined) {
                this._refMap = new SchemaRefMap(_schemaObject.definitions);
            }
            try {
                const root = new OpBaseNode("", _schemaObject, this._refMap, new OpPropertyStack, this._logger);
                this._root = root;
            } catch {
                this._logger?.error(`Failed to build schema`);
                return false;
            }
            return true;
        }
        validate(_data) {
            if (_data === undefined) {
                throw new Error("Data is undefined");
            }
            if (this._root === undefined) {
                throw new Error("No Schema Map built yet");
            }
            return this._root.validate("", _data, "", "");
        }
    }
    async function deleteOperation(uiSession) {
        if (uiSession.extensionContext.selectionManager.volume.isEmpty) {
            uiSession.log.warning("Selection volume is empty - nothing to clear");
            return;
        }
        const selectionVolume = uiSession.extensionContext.selectionManager.volume.get();
        const onError = e => {
            uiSession.log.error(e.message);
        };
        await executeFunctionWithTransactionAndTicking(uiSession.extensionContext, uiSession.log, selectionVolume, "Delete", (() => {
            uiSession.extensionContext.blockUtilities.fillVolume(selectionVolume, lib_vanilla_MinecraftBlockTypes.Air);
        })).catch(onError);
    }
    class DeleteBehavior {
        constructor(uiSession, coreMenuItems) {
            const deleteAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    deleteOperation(uiSession).catch((e => uiSession.log.error(e.message, {
                        channelMask: server_editor_namespaceObject.LogChannel.All
                    })));
                }
            });
            coreMenuItems.edit.addItem({
                label: "resourcePack.editor.menuBar.edit.delete",
                tooltip: "resourcePack.editor.menuBar.edit.delete.tooltip"
            }, deleteAction);
            uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalEditor, deleteAction, {
                key: server_editor_namespaceObject.KeyboardKey.DELETE
            }, {
                uniqueId: "editor:toolModeKeyBinding:delete",
                label: "resourcePack.editor.delete.keyBinding.title",
                tooltip: "resourcePack.editor.delete.keyBinding.tooltip"
            });
        }
        teardown() {}
    }
    class PreviewVolume {
        constructor(uiSession) {
            this._session = uiSession;
            this._outlineColor = this.session.extensionContext.settings.theme.resolveColorKey(server_editor_namespaceObject.ThemeSettingsColorKey.SelectionVolumeFill);
            this._hullColor = this.session.extensionContext.settings.theme.resolveColorKey(server_editor_namespaceObject.ThemeSettingsColorKey.SelectionVolumeBorder);
            this._highlightOutlineColor = this.session.extensionContext.settings.theme.resolveColorKey(server_editor_namespaceObject.ThemeSettingsColorKey.SelectionVolumeOutlineBorder);
            this._highlightHullColor = this.session.extensionContext.settings.theme.resolveColorKey(server_editor_namespaceObject.ThemeSettingsColorKey.SelectionVolumeOutlineFill);
            const dimensionBounds = this.session.extensionContext.blockUtilities.getDimensionLocationBoundingBox();
            const center = server_namespaceObject.BlockBoundingBoxUtils.getCenter(dimensionBounds);
            this._volume = new server_editor_namespaceObject.RelativeVolumeListBlockVolume;
            this._widgetGroup = this.session.extensionContext.widgetManager.createGroup({
                visible: true
            });
            this._widget = this._widgetGroup.createWidget(center, {
                visible: false,
                selectable: false
            });
            this._widgetVolumeComponent = this._widget.addVolumeOutline("outline", this._volume, {
                outlineColor: this._outlineColor,
                hullColor: this._hullColor,
                highlightOutlineColor: this._highlightOutlineColor,
                highlightHullColor: this._highlightHullColor,
                showOutline: false,
                showHighlightOutline: true,
                visible: true
            });
        }
        get session() {
            return this._session;
        }
        get locationIterator() {
            return this._volume.getBlockLocationIterator();
        }
        get isEmpty() {
            return this._volume.isEmpty;
        }
        get bounds() {
            return this._volume.getBoundingBox();
        }
        get volume() {
            return this._volume;
        }
        get visible() {
            return this._widget.visible;
        }
        set visible(value) {
            if (this._widget !== undefined && this._widget.visible !== value) {
                this._widget.visible = value;
            }
        }
        get location() {
            return this._widget.location;
        }
        set location(position) {
            this._widget.location = position;
        }
        set outlineColor(value) {
            this._outlineColor = value;
            this._widgetVolumeComponent.outlineColor = value;
        }
        set hullColor(value) {
            this._hullColor = value;
            this._widgetVolumeComponent.hullColor = value;
        }
        set highlightOutlineColor(value) {
            this._highlightOutlineColor = value;
            this._widgetVolumeComponent.highlightOutlineColor = value;
        }
        set highlightHullColor(value) {
            this._highlightHullColor = value;
            this._widgetVolumeComponent.highlightHullColor = value;
        }
        addVolume(volume) {
            this._volume.add(volume);
            if (this._volume.isEmpty) {
                return;
            }
            const bounds = this._volume.getBoundingBox();
            this._widget.location = bounds.min;
        }
        removeVolume(volume) {
            this._volume.remove(volume);
            if (this._volume.isEmpty) {
                return;
            }
            const bounds = this._volume.getBoundingBox();
            this._widget.location = bounds.min;
        }
        clearVolume() {
            this._volume.clear();
        }
        teardown() {
            this._widgetVolumeComponent.delete();
            this._widget.delete();
            this._widgetGroup.delete();
        }
    }
    var LineTelemetry;
    (function(LineTelemetry) {
        LineTelemetry["QuickAction"] = "QuickAction";
        LineTelemetry["LeftClick"] = "LeftClick";
        LineTelemetry["ToggleSelectPoint"] = "ToggleSelectPoint";
        LineTelemetry["ClearAllPoints"] = "ClearAllPoints";
        LineTelemetry["ClearSelectedPoints"] = "ClearSelectedPoints";
        LineTelemetry["FillLine"] = "FillLine";
        LineTelemetry["DeleteBlocks"] = "DeleteBlocks";
        LineTelemetry["ToggleSelectAll"] = "ToggleSelectAll";
        LineTelemetry["AddToSelection"] = "AddToSelection";
        LineTelemetry["WeightChanged"] = "WeightChanged";
        LineTelemetry["SelectionModeChanged"] = "SelectionModeChanged";
        LineTelemetry["AlgorithmChanged"] = "AlgorithmChanged";
        LineTelemetry["Nudge"] = "Nudge";
        LineTelemetry["Move"] = "Move";
    })(LineTelemetry || (LineTelemetry = {}));
    class LinePreviewMap {
        constructor(uiSession) {
            this._uiSession = uiSession;
            this._previewVolume = new PreviewVolume(this._uiSession);
            this._locationMapping = new Map;
            const yellow = {
                red: .84,
                green: .7,
                blue: .09,
                alpha: .35
            };
            this.previewVolume.highlightHullColor = yellow;
        }
        get previewVolume() {
            return this._previewVolume;
        }
        addPoints(points) {
            for (let i = 0; i < points.length; i++) {
                const key = this.vector3ToString(points[i]);
                const value = this._locationMapping.get(key);
                this._locationMapping.set(key, value !== undefined ? value + 1 : 1);
            }
            this._previewVolume.addVolume(points);
            if (!this._previewVolume.visible && this._locationMapping.size > 0) {
                this._previewVolume.visible = true;
            }
        }
        removePoints(points) {
            const removedPts = [];
            for (let i = 0; i < points.length; i++) {
                const key = this.vector3ToString(points[i]);
                const value = this._locationMapping.get(key);
                if (value !== undefined) {
                    if (value === 1) {
                        this._locationMapping.delete(key);
                        removedPts.push(this.stringToVector3(key));
                    } else {
                        this._locationMapping.set(key, value - 1);
                    }
                }
            }
            this._previewVolume.removeVolume(removedPts);
        }
        hasPoint(point) {
            return this._locationMapping.has(this.vector3ToString(point));
        }
        clear() {
            this._previewVolume.visible = false;
            this._previewVolume.clearVolume();
            this._locationMapping.clear();
            this._previewVolume.visible = true;
        }
        teardown() {
            this.clear();
            this._previewVolume.visible = false;
            this._previewVolume.teardown();
        }
        vector3ToString(point) {
            return `${point.x},${point.y},${point.z}`;
        }
        stringToVector3(pointString) {
            let index = 0;
            const x = parseInt(pointString.slice(index, index = pointString.indexOf(",")), 10);
            const y = parseInt(pointString.slice(index + 1, index = pointString.indexOf(",", index + 1)), 10);
            const z = parseInt(pointString.slice(index + 1), 10);
            return {
                x,
                y,
                z
            };
        }
    }
    class ControlPoint extends BlockPoint {
        constructor(location, isSeparate, weightsOverridden, usingUniformValues, horizontalWeight, verticalWeight, blockLineTypeAlgorithm, linePreviewMap, widgetGroup, requestCursorTargetMode, requestGroundLevelAtLocation, gizmoMovedEvent, gizmoGrabbedEvent, gizmoReleasedEvent) {
            const blockPointType = blockLineTypeAlgorithm === BlockLineType.Direct || blockLineTypeAlgorithm === BlockLineType.Staggered ? BlockPointType.Normal : BlockPointType.Contour;
            super(location, requestCursorTargetMode, requestGroundLevelAtLocation, {
                horizontalWeight,
                verticalWeight,
                blockPointType
            });
            this._isSeparate = isSeparate;
            this._weightsOverridden = weightsOverridden;
            this._usingUniformValues = usingUniformValues;
            this._linePreviewMap = linePreviewMap;
            this._visible = false;
            this._widget = widgetGroup.createWidget(location, {
                selectable: true,
                snapToBlockLocation: true,
                visible: true,
                collisionOffset: {
                    x: .5,
                    y: .5,
                    z: .5
                },
                collisionRadius: 0,
                widgetName: "Line Tool - Control Point",
                stateChangeEvent: data => {
                    if (data.location !== undefined && !lib.Vector3Utils.equals(data.location, this.location)) {
                        const textComponent = data.widget.getComponent("position_text");
                        if (textComponent) {
                            textComponent.label = lib.Vector3Utils.toString(data.location, {
                                decimals: 1
                            });
                        }
                    }
                }
            });
            this._widget.addTextComponent("position_text", lib.Vector3Utils.toString(location, {
                decimals: 1
            }), {
                offset: {
                    x: .5,
                    y: 1,
                    z: .5
                },
                visible: true
            });
            this._movementGizmo = this._widget.addGizmoComponent("position_gizmo", {
                offset: {
                    x: .5,
                    y: .5,
                    z: .5
                },
                visible: true,
                stateChangeEvent: data => {
                    if (data.eventType === server_editor_namespaceObject.WidgetGizmoEventType.CornerMoved || data.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginMoved) {
                        if (!lib.Vector3Utils.equals(this.location, data.widget.location)) {
                            gizmoMovedEvent(this.location, data.widget.location, data.widget);
                        }
                    } else if (data.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginGrabbed || data.eventType === server_editor_namespaceObject.WidgetGizmoEventType.CornerGrabbed) {
                        gizmoGrabbedEvent(data.widget.location);
                    } else if (data.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginReleased || data.eventType === server_editor_namespaceObject.WidgetGizmoEventType.CornerReleased) {
                        gizmoReleasedEvent(data.widget.location);
                    }
                }
            });
            this._widget.addGuideComponent("position_guide");
        }
        get isSeparate() {
            return this._isSeparate;
        }
        get isSelected() {
            return this._widget.selected;
        }
        get isWeightsOverridden() {
            return this._weightsOverridden;
        }
        get usingUniformValues() {
            return this._usingUniformValues;
        }
        set isSelected(isSelected) {
            this._widget.selected = isSelected;
            this.setGizmoActivated(isSelected);
        }
        setWeightsOverridden(weightsOverridden) {
            this._weightsOverridden = weightsOverridden;
        }
        setUsingUniformValues(usingUniformValues) {
            this._usingUniformValues = usingUniformValues;
        }
        get visible() {
            return this._visible;
        }
        set visible(newIsVisible) {
            if (this._visible !== newIsVisible) {
                if (newIsVisible) {
                    this._linePreviewMap.addPoints([ ...this.lineDataIterator ]);
                } else {
                    this._linePreviewMap.removePoints([ ...this.lineDataIterator ]);
                }
                this._visible = newIsVisible;
            }
        }
        setGizmoActivated(isActivated) {
            this._movementGizmo.activated = isActivated;
        }
        move(targetLocation, moveGizmo = false) {
            const results = this.movePoint(targetLocation);
            if (moveGizmo) {
                this._widget.location = targetLocation;
            }
            return results;
        }
        teardown() {
            this._widget?.delete();
        }
    }
    ControlPoint.MAP_MARKER_ENTITY_NAME = "editor:ruler_idle";
    class LineSegment extends BlockLine {
        constructor(uiSession, horizontalWeight, verticalWeight, blockLineTypeAlgorithm, linePreviewMap, requestCursorTargetMode, requestGroundLevelAtLocation, start, end, startData, endData) {
            super(start.location, end.location, requestCursorTargetMode, requestGroundLevelAtLocation, {
                horizontalWeight,
                verticalWeight,
                blockLineType: blockLineTypeAlgorithm,
                startData,
                endData
            });
            this._linePreviewMap = linePreviewMap;
            this._visible = false;
        }
        get visible() {
            return this._visible;
        }
        teardown() {
            super.teardown();
        }
        set visible(newIsVisible) {
            void this.generateLine().then((() => {
                if (this._visible !== newIsVisible) {
                    if (newIsVisible) {
                        this._linePreviewMap.addPoints([ ...this.lineDataIterator ]);
                    } else {
                        this._linePreviewMap.removePoints([ ...this.lineDataIterator ]);
                    }
                    this._visible = newIsVisible;
                }
            }));
        }
    }
    class LineManager {
        constructor(uiSession, blockLineTypeAlgorithm, horizontalWeight, verticalWeight, requestStartTransaction, requestCommitTransaction, requestCancelTransaction) {
            this.pointGizmoMovedEventHandler = (oldLocation, newLocation, widget) => {
                const delta = lib.Vector3Utils.subtract(newLocation, oldLocation);
                if (lib.Vector3Utils.magnitude(delta) !== 0) {
                    if (!this.moveSelectedPoints(delta)) {
                        widget.location = oldLocation;
                    }
                }
            };
            this.pointGizmoGrabbedEventHandler = location => {
                this._gizmoGrabbedStartLocation = location;
                this._requestStartTransaction("ControlPointGizmoMove");
            };
            this.pointGizmoReleasedEventHandler = location => {
                if (this._gizmoGrabbedStartLocation !== undefined && !lib.Vector3Utils.equals(location, this._gizmoGrabbedStartLocation)) {
                    this._requestCommitTransaction("ControlPointGizmoMove");
                } else {
                    this._uiSession.log.debug("Canceling transaction - move gizmo was released but not moved.");
                    this._requestCancelTransaction();
                }
                this._gizmoGrabbedStartLocation = undefined;
            };
            this.cursorTargetModeRequested = () => this._uiSession.extensionContext.cursor.getProperties().targetMode ?? server_editor_namespaceObject.CursorTargetMode.Block;
            this.groundLevelAtLocationRequested = location => {
                const blockHit = this._uiSession.extensionContext.player.dimension.getBlockFromRay(location, lib.VECTOR3_DOWN, {
                    includePassableBlocks: false,
                    includeLiquidBlocks: true
                });
                if (blockHit?.block) {
                    return blockHit.block.location.y;
                } else {
                    return Infinity;
                }
            };
            this._uiSession = uiSession;
            this._blockLineTypeAlgorithm = blockLineTypeAlgorithm;
            this._horizontalWeight = horizontalWeight;
            this._verticalWeight = verticalWeight;
            this._requestStartTransaction = requestStartTransaction;
            this._requestCommitTransaction = requestCommitTransaction;
            this._requestCancelTransaction = requestCancelTransaction;
            this._widgetGroup = this._uiSession.extensionContext.widgetManager.createGroup({
                groupSelectionMode: server_editor_namespaceObject.WidgetGroupSelectionMode.Multiple
            });
            this._linePreviewMap = new LinePreviewMap(this._uiSession);
            this._controlPoints = [];
            this._lineSegments = [];
            this._gizmoGrabbedStartLocation = undefined;
        }
        get controlPoints() {
            return this._controlPoints;
        }
        get selectedPoints() {
            const points = [];
            for (const controlPoint of this._controlPoints) {
                if (controlPoint.isSelected) {
                    points.push(controlPoint);
                }
            }
            return points;
        }
        get linePreviewMap() {
            return this._linePreviewMap;
        }
        set blockLineTypeAlgorithm(newAlgorithm) {
            if (newAlgorithm !== this._blockLineTypeAlgorithm) {
                this._blockLineTypeAlgorithm = newAlgorithm;
                const blockPointType = newAlgorithm === BlockLineType.Direct || newAlgorithm === BlockLineType.Staggered ? BlockPointType.Normal : BlockPointType.Contour;
                for (let i = 0; i < this._controlPoints.length; i++) {
                    this.applyPreviewChangeResults(this._controlPoints[i].setBlockPointType(blockPointType));
                }
                for (let i = 0; i < this._lineSegments.length; i++) {
                    this._lineSegments[i].setBlockLineType(newAlgorithm).then((result => {
                        this.applyPreviewChangeResults(result);
                    })).catch((err => {
                        this._uiSession.log.error(err.message);
                    }));
                }
            }
        }
        setState(state) {
            this.clearAll();
            for (let i = 0; i < state.length; i++) {
                const newPoint = new ControlPoint(state[i].location, state[i].separation, state[i].weightsOverridden, state[i].usingUniformValue, state[i].horizontalWeight, state[i].verticalWeight, this._blockLineTypeAlgorithm, this._linePreviewMap, this._widgetGroup, this.cursorTargetModeRequested, this.groundLevelAtLocationRequested, this.pointGizmoMovedEventHandler, this.pointGizmoGrabbedEventHandler, this.pointGizmoReleasedEventHandler);
                this._controlPoints.push(newPoint);
                newPoint.isSelected = state[i].selection;
                newPoint.visible = true;
                if (i > 0 && !state[i].separation) {
                    const startPoint = this._controlPoints[i - 1];
                    const newLineSegment = new LineSegment(this._uiSession, this._horizontalWeight, this._verticalWeight, this._blockLineTypeAlgorithm, this._linePreviewMap, this.cursorTargetModeRequested, this.groundLevelAtLocationRequested, this._controlPoints[i - 1], this._controlPoints[i], startPoint.isWeightsOverridden ? {
                        horizontalWeight: startPoint.horizontalWeight,
                        verticalWeight: startPoint.verticalWeight
                    } : undefined, newPoint.isWeightsOverridden ? {
                        horizontalWeight: newPoint.horizontalWeight,
                        verticalWeight: newPoint.verticalWeight
                    } : undefined);
                    this._lineSegments.push(newLineSegment);
                    newLineSegment.visible = true;
                }
            }
        }
        addNewPoint(targetLocation, isSeparate = false) {
            if (this._controlPoints.some((controlPoint => lib.Vector3Utils.equals(controlPoint.location, targetLocation)))) {
                return;
            }
            const newPoint = new ControlPoint(targetLocation, isSeparate, false, false, this._horizontalWeight, this._verticalWeight, this._blockLineTypeAlgorithm, this._linePreviewMap, this._widgetGroup, this.cursorTargetModeRequested, this.groundLevelAtLocationRequested, this.pointGizmoMovedEventHandler, this.pointGizmoGrabbedEventHandler, this.pointGizmoReleasedEventHandler);
            this._controlPoints.push(newPoint);
            newPoint.isSelected = true;
            newPoint.visible = this._blockLineTypeAlgorithm !== BlockLineType.DirectContour && this._blockLineTypeAlgorithm !== BlockLineType.StaggeredContour;
            if (this._controlPoints.length > 1 && !isSeparate) {
                const previousControlPoint = this._controlPoints[this._controlPoints.length - 2];
                const newLineSegment = new LineSegment(this._uiSession, this._horizontalWeight, this._verticalWeight, this._blockLineTypeAlgorithm, this._linePreviewMap, this.cursorTargetModeRequested, this.groundLevelAtLocationRequested, previousControlPoint, newPoint, previousControlPoint.isWeightsOverridden ? {
                    horizontalWeight: previousControlPoint.horizontalWeight,
                    verticalWeight: previousControlPoint.verticalWeight
                } : undefined, newPoint.isWeightsOverridden ? {
                    horizontalWeight: newPoint.horizontalWeight,
                    verticalWeight: newPoint.verticalWeight
                } : undefined);
                this._lineSegments.push(newLineSegment);
                newLineSegment.visible = true;
            }
        }
        clearAll() {
            for (let i = 0; i < this._controlPoints.length; i++) {
                this._controlPoints[i].teardown();
            }
            this._controlPoints.length = 0;
            this._lineSegments.length = 0;
            this._linePreviewMap.clear();
        }
        clearSelectedPoints() {
            if (this._controlPoints.length <= 0) {
                return;
            }
            const pointsToRemove = this._controlPoints.filter((controlPoint => controlPoint.isSelected));
            if (pointsToRemove.length === this._controlPoints.length) {
                this.clearAll();
            } else {
                for (let i = 0; i < pointsToRemove.length; i++) {
                    const pointIdx = this._controlPoints.findIndex((point => lib.Vector3Utils.equals(point.location, pointsToRemove[i].location)));
                    if (pointIdx !== -1) {
                        this._controlPoints[pointIdx].visible = false;
                        this._controlPoints[pointIdx].teardown();
                        this._controlPoints.splice(pointIdx, 1);
                    }
                    const prevSegIdx = this._lineSegments.findIndex((segment => lib.Vector3Utils.equals(segment.end, pointsToRemove[i].location)));
                    if (prevSegIdx !== -1) {
                        this._lineSegments[prevSegIdx].visible = false;
                        this._lineSegments.splice(prevSegIdx, 1);
                    }
                    const nextSegIdx = this._lineSegments.findIndex((segment => lib.Vector3Utils.equals(segment.start, pointsToRemove[i].location)));
                    if (nextSegIdx !== -1) {
                        this._lineSegments[nextSegIdx].visible = false;
                        this._lineSegments.splice(nextSegIdx, 1);
                    }
                }
                for (let i = 1; i < this._controlPoints.length; i++) {
                    const start = this._controlPoints[i - 1];
                    const end = this._controlPoints[i];
                    if (!end.isSeparate) {
                        const segIdx = this._lineSegments.findIndex((segment => lib.Vector3Utils.equals(segment.start, start.location) && lib.Vector3Utils.equals(segment.end, end.location)));
                        if (segIdx === -1) {
                            const newLineSegment = new LineSegment(this._uiSession, this._horizontalWeight, this._verticalWeight, this._blockLineTypeAlgorithm, this._linePreviewMap, this.cursorTargetModeRequested, this.groundLevelAtLocationRequested, start, end, start.isWeightsOverridden ? {
                                horizontalWeight: start.horizontalWeight,
                                verticalWeight: start.verticalWeight
                            } : undefined, end.isWeightsOverridden ? {
                                horizontalWeight: end.horizontalWeight,
                                verticalWeight: end.verticalWeight
                            } : undefined);
                            this._lineSegments.push(newLineSegment);
                            newLineSegment.visible = true;
                        }
                    }
                }
            }
        }
        nudgeSelectedPoints(direction) {
            if (this._controlPoints.length <= 0) {
                return;
            }
            const rotationY = this._uiSession.extensionContext.player.getRotation().y;
            const rotationCorrectedVector = getRotationCorrectedDirectionVector(rotationY, direction);
            if (!this.moveSelectedPoints(rotationCorrectedVector, true)) {
                this._uiSession.log.warning(`Could not nudge control point(s) (points cannot overlap or be more than ${LineBehavior.MAX_CONTROL_POINTS_DISTANCE} blocks from the next/previous point).`);
            }
        }
        moveSelectedPoints(translationVector, moveGizmo = false) {
            const selectedPoints = [];
            const restrictedLocations = new Set;
            for (let i = 0; i < this._controlPoints.length; i++) {
                if (this._controlPoints[i].isSelected) {
                    selectedPoints.push(this._controlPoints[i]);
                } else {
                    restrictedLocations.add(`${this._controlPoints[i].location.x},${this._controlPoints[i].location.y},${this._controlPoints[i].location.z}`);
                }
            }
            if (selectedPoints.length === this._controlPoints.length) {
                for (let i = 0; i < this._lineSegments.length; i++) {
                    this._lineSegments[i].translateLine(translationVector).then((result => this.applyPreviewChangeResults(result))).catch((err => {
                        this._uiSession.log.error(err.message);
                    }));
                }
                for (let i = 0; i < this._controlPoints.length; i++) {
                    this.applyPreviewChangeResults(this._controlPoints[i].move(lib.Vector3Utils.add(this._controlPoints[i].location, translationVector), moveGizmo));
                }
            } else {
                for (let i = 0; i < selectedPoints.length; i++) {
                    const newLocation = lib.Vector3Utils.add(selectedPoints[i].location, translationVector);
                    if (restrictedLocations.has(`${newLocation.x},${newLocation.y},${newLocation.z}`)) {
                        this._uiSession.log.warning(`Cannot overlap control points!`);
                        return false;
                    }
                }
                for (let i = 0; i < this._controlPoints.length; i++) {
                    if (!this._controlPoints[i].isSelected) {
                        continue;
                    }
                    if (i - 1 > 0 && !this._controlPoints[i - 1].isSelected) {
                        const newLocation = lib.Vector3Utils.add(this._controlPoints[i].location, translationVector);
                        if (Math.abs(lib.Vector3Utils.magnitude(lib.Vector3Utils.subtract(newLocation, this._controlPoints[i - 1].location))) > LineBehavior.MAX_CONTROL_POINTS_DISTANCE) {
                            this._uiSession.log.warning(`Could not move control point(s) (points cannot be more than ${LineBehavior.MAX_CONTROL_POINTS_DISTANCE} blocks from the next/previous point).`);
                            return false;
                        }
                    }
                    if (i + 1 < this._controlPoints.length && !this._controlPoints[i + 1].isSelected) {
                        const newLocation = lib.Vector3Utils.add(this._controlPoints[i].location, translationVector);
                        if (Math.abs(lib.Vector3Utils.magnitude(lib.Vector3Utils.subtract(newLocation, this._controlPoints[i + 1].location))) > LineBehavior.MAX_CONTROL_POINTS_DISTANCE) {
                            this._uiSession.log.warning(`Could not nudge control point(s) (points cannot be more than ${LineBehavior.MAX_CONTROL_POINTS_DISTANCE} blocks from the next/previous point).`);
                            return false;
                        }
                    }
                }
                for (let i = 0; i < selectedPoints.length; i++) {
                    const prevSegIdx = this._lineSegments.findIndex((segment => lib.Vector3Utils.equals(segment.end, selectedPoints[i].location)));
                    if (prevSegIdx !== -1) {
                        this._lineSegments[prevSegIdx].setEnd(lib.Vector3Utils.add(this._lineSegments[prevSegIdx].end, translationVector), selectedPoints[i].isWeightsOverridden ? {
                            horizontalWeight: selectedPoints[i].horizontalWeight,
                            verticalWeight: selectedPoints[i].verticalWeight
                        } : undefined).then((result => {
                            this.applyPreviewChangeResults(result);
                        })).catch((err => {
                            this._uiSession.log.error(err.message);
                        }));
                    }
                    const nextSegIdx = this._lineSegments.findIndex((segment => lib.Vector3Utils.equals(segment.start, selectedPoints[i].location)));
                    if (nextSegIdx !== -1) {
                        this._lineSegments[nextSegIdx].setStart(lib.Vector3Utils.add(this._lineSegments[nextSegIdx].start, translationVector), selectedPoints[i].isWeightsOverridden ? {
                            horizontalWeight: selectedPoints[i].horizontalWeight,
                            verticalWeight: selectedPoints[i].verticalWeight
                        } : undefined).then((results => {
                            this.applyPreviewChangeResults(results);
                        })).catch((err => {
                            this._uiSession.log.error(err.message);
                        }));
                    }
                    this.applyPreviewChangeResults(selectedPoints[i].move(lib.Vector3Utils.add(selectedPoints[i].location, translationVector), moveGizmo));
                }
            }
            return true;
        }
        async fillLine(fillWithAir = false) {
            if (this._linePreviewMap.previewVolume.isEmpty) {
                return;
            }
            const onError = e => {
                this._uiSession.log.error(`Fill operation failed with error: ${e.message}`, {
                    channelMask: server_editor_namespaceObject.LogChannel.All
                });
            };
            await executeFunctionWithTransactionAndTicking(this._uiSession.extensionContext, this._uiSession.log, this._linePreviewMap.previewVolume.volume, "FillLine", (() => {
                if (fillWithAir) {
                    this._uiSession.extensionContext.blockUtilities.fillVolume(this._linePreviewMap.previewVolume.volume, lib_vanilla_MinecraftBlockTypes.Air);
                } else {
                    this._uiSession.extensionContext.blockUtilities.fillVolume(this._linePreviewMap.previewVolume.volume);
                }
            })).catch(onError);
        }
        updateSelectedControlPointData(isWeightOverridden, usingUniformValues, pointPosition, horizontalWeight, verticalWeight) {
            let updated = false;
            const selectedPoints = this.selectedPoints;
            if (selectedPoints.length !== 1) {
                return;
            }
            const selectedPoint = selectedPoints[0];
            const delta = lib.Vector3Utils.subtract(pointPosition, selectedPoint.location);
            if (selectedPoint.horizontalWeight !== horizontalWeight || selectedPoint.verticalWeight !== verticalWeight || !lib.Vector3Utils.equals(selectedPoint.location, pointPosition) || selectedPoint.isWeightsOverridden !== isWeightOverridden || selectedPoint.usingUniformValues !== usingUniformValues || lib.Vector3Utils.magnitude(delta) !== 0) {
                updated = true;
            }
            if (updated) {
                selectedPoint.setWeightsOverridden(isWeightOverridden);
                selectedPoint.setUsingUniformValues(usingUniformValues);
                this.applyPreviewChangeResults(selectedPoint.setWeights(horizontalWeight, verticalWeight));
                if (this.moveSelectedPoints(delta)) {
                    selectedPoint.move(pointPosition, true);
                }
            }
        }
        updateLineWeights(horizontalWeight, verticalWeight) {
            let updated = false;
            if (this._horizontalWeight !== horizontalWeight) {
                this._horizontalWeight = horizontalWeight;
                updated = true;
            }
            if (this._verticalWeight !== verticalWeight) {
                this._verticalWeight = verticalWeight;
                updated = true;
            }
            if (updated) {
                for (let i = 0; i < this._lineSegments.length; i++) {
                    this._lineSegments[i].setWeights(horizontalWeight, verticalWeight).then((results => this.applyPreviewChangeResults(results))).catch((err => {
                        this._uiSession.log.error(err.message);
                    }));
                }
            }
        }
        toggleSelectAllPoints() {
            if (this._controlPoints.length <= 0) {
                return;
            }
            if (this._controlPoints.some((controlPoint => !controlPoint.isSelected))) {
                this._widgetGroup.selectAllWidgets();
                this._controlPoints[this._controlPoints.length - 1].setGizmoActivated(true);
            } else {
                this._widgetGroup.deselectAllWidgets();
            }
        }
        toggleSelectPoint(controlPoint) {
            controlPoint.isSelected = !controlPoint.isSelected;
        }
        toggleVisibility(isVisible) {
            this._widgetGroup.visible = isVisible;
            this._linePreviewMap.previewVolume.visible = isVisible;
        }
        teardown() {
            this.clearAll();
            this._linePreviewMap.teardown();
        }
        applyPreviewChangeResults(results) {
            if (results.pointsRemoved.length > 0) {
                this._linePreviewMap.removePoints(results.pointsRemoved);
            }
            if (results.pointsAdded.length > 0) {
                this._linePreviewMap.addPoints(results.pointsAdded);
            }
        }
    }
    var QuickActionMode;
    (function(QuickActionMode) {
        QuickActionMode[QuickActionMode["Invalid"] = -1] = "Invalid";
        QuickActionMode[QuickActionMode["FillLine"] = 1] = "FillLine";
        QuickActionMode[QuickActionMode["DeleteBlocks"] = 2] = "DeleteBlocks";
        QuickActionMode[QuickActionMode["AddToSelection"] = 3] = "AddToSelection";
        QuickActionMode[QuickActionMode["ClearSelectedPoints"] = 4] = "ClearSelectedPoints";
        QuickActionMode[QuickActionMode["ClearAllPoints"] = 5] = "ClearAllPoints";
    })(QuickActionMode || (QuickActionMode = {}));
    class LineBehavior {
        constructor(uiSession) {
            this.startTransactionRequestedEventHandler = name => {
                this.startTransaction(name);
            };
            this.commitTransactionRequestedEventHandler = name => {
                this.commitTransaction(name);
            };
            this.cancelTransactionRequestedEventHandler = () => {
                this.cancelTransaction();
            };
            this._uiSession = uiSession;
            this._uiSession.log.debug(`Initializing ${LineBehavior.BEHAVIOR_NAME}`);
            this._updatePointAndLineValsOperationTickHandle = undefined;
            this._pointLinePropsDirty = false;
            this._toolCursorProperties = {
                outlineColor: LineBehavior.SELECTION_COLOR_LIGHT_BLUE,
                controlMode: server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse,
                targetMode: server_editor_namespaceObject.CursorTargetMode.Block,
                visible: true
            };
            this._paneProperties = {
                quickActionMode: (0, server_editor_namespaceObject.makeObservable)(QuickActionMode.Invalid),
                blockLineTypeAlgorithm: (0, server_editor_namespaceObject.makeObservable)(BlockLineType.Direct),
                isUniformWeight: (0, server_editor_namespaceObject.makeObservable)(false),
                uniformWeight: (0, server_editor_namespaceObject.makeObservable)(1),
                horizontalWeight: (0, server_editor_namespaceObject.makeObservable)(1),
                verticalWeight: (0, server_editor_namespaceObject.makeObservable)(1),
                uniformWeightPropertyItem: {},
                horizontalWeightPropertyItem: {},
                verticalWeightPropertyItem: {},
                fillButtonPropertyItem: {}
            };
            this._controlPointProperties = {
                pointPosition: (0, server_editor_namespaceObject.makeObservable)({
                    x: 0,
                    y: 0,
                    z: 0
                }),
                useGlobalLineWeight: (0, server_editor_namespaceObject.makeObservable)(true),
                isUniformWeight: (0, server_editor_namespaceObject.makeObservable)(false),
                uniformWeight: (0, server_editor_namespaceObject.makeObservable)(1),
                horizontalWeight: (0, server_editor_namespaceObject.makeObservable)(1),
                verticalWeight: (0, server_editor_namespaceObject.makeObservable)(1),
                isUniformWeightPropertyItem: undefined,
                uniformWeightPropertyItem: undefined,
                horizontalWeightPropertyItem: undefined,
                verticalWeightPropertyItem: undefined
            };
            this._telemetryManager = new TelemetryManager(this._uiSession.extensionContext.player, TelemetrySource.Line);
            this._lineSegmentsManager = new LineManager(this._uiSession, this._paneProperties.blockLineTypeAlgorithm.value, this._paneProperties.horizontalWeight.value, this._paneProperties.verticalWeight.value, this.startTransactionRequestedEventHandler, this.commitTransactionRequestedEventHandler, this.cancelTransactionRequestedEventHandler);
            this._transactionHandler = (0, server_editor_namespaceObject.registerUserDefinedTransactionHandler)(this._uiSession.extensionContext.transactionManager, (payload => {
                const oldState = payload.oldState;
                this.updateState(oldState);
            }), (payload => {
                const newState = payload.newState;
                this.updateState(newState);
            }));
            this._tool = this.createTool();
            this._pane = this.createPane();
            this._cursorControlHolderPane = this._pane.createSubPane({
                title: "Hidden Cursor Control Holder Pane",
                hasExpander: false
            });
            this._cursorModeControl = new CursorModeControl(this._uiSession, this._tool, this._cursorControlHolderPane, true, this._toolCursorProperties, {
                hasPaneMargins: false
            });
            this._cursorModeControl.initialize();
            this._controlPointWeightPane = this.createLineAndPointWeightsPanes(this._pane);
            this._pane.endConstruct();
            this._tool.bindPropertyPane(this._pane);
            this.registerMouseButtonInputs();
            this.registerKeyboardInputs();
            this._modeChangeEventSubscriptionHandle = this._uiSession.extensionContext.afterEvents.modeChange.subscribe((event => {
                if (event.mode === server_editor_namespaceObject.EditorMode.Crosshair) {
                    this._lineSegmentsManager.toggleVisibility(false);
                } else {
                    this._lineSegmentsManager.toggleVisibility(true);
                }
            }));
        }
        teardown() {
            if (this._modeChangeEventSubscriptionHandle) {
                this._uiSession.extensionContext.afterEvents.modeChange.unsubscribe(this._modeChangeEventSubscriptionHandle);
                this._modeChangeEventSubscriptionHandle = undefined;
            }
            this._cursorModeControl.shutdown();
            this._lineSegmentsManager.teardown();
        }
        createTool() {
            const toolToggleAction = this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this._uiSession.toolRail.setSelectedToolId(tool.id);
                }
            });
            this._uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, toolToggleAction, {
                key: server_editor_namespaceObject.KeyboardKey.KEY_L,
                modifier: server_editor_namespaceObject.InputModifier.Control
            }, {
                uniqueId: "editor:toolModeKeyBinding:toggleLine",
                label: "resourcePack.editor.toolRail.line.keyBinding.toggleTool.title",
                tooltip: "resourcePack.editor.toolRail.line.keyBinding.toggleTool.tooltip"
            });
            const tool = this._uiSession.toolRail.addTool("editor:modalTool:line", {
                title: "resourcePack.editor.toolRail.line.title",
                icon: "pack://textures/editor/Line.png?filtering=point",
                tooltip: {
                    description: "resourcePack.editor.toolRail.line.tooltip",
                    image: "pack://textures/editor/LineTool.gif"
                },
                action: toolToggleAction
            });
            tool.onModalToolActivation.subscribe((eventData => {
                if (eventData.isActiveTool) {
                    this._backedUpColors = backupColors(this._uiSession.extensionContext);
                    this._cursorModeControl.activateControl();
                    this._uiSession.extensionContext.cursor.setProperties(this._toolCursorProperties);
                    this._updatePointAndLineValsOperationTickHandle = server_namespaceObject.system.runInterval((() => {
                        this.runUpdatePointAndLineValsOperation();
                        this.toggleSelectedControlPointOp();
                    }), server_namespaceObject.TicksPerSecond);
                    this._lineSegmentsManager.toggleVisibility(true);
                } else {
                    if (this._updatePointAndLineValsOperationTickHandle !== undefined) {
                        server_namespaceObject.system.clearRun(this._updatePointAndLineValsOperationTickHandle);
                        this._updatePointAndLineValsOperationTickHandle = undefined;
                    }
                    this._cursorModeControl.deactivateControl();
                    if (this._backedUpColors) {
                        restoreBackedUpColors(this._uiSession.extensionContext, this._backedUpColors);
                        this._backedUpColors = undefined;
                    }
                    this._lineSegmentsManager.toggleVisibility(false);
                }
            }));
            return tool;
        }
        createPane() {
            const pane = this._uiSession.createPropertyPane({
                title: "resourcePack.editor.toolRail.line.title",
                infoTooltip: {
                    description: [ "resourcePack.editor.toolRail.line.tooltip", {
                        link: "https://aka.ms/BedrockEditorLineTool",
                        text: "resourcePack.editor.help.learnMore"
                    } ]
                }
            });
            pane.beginConstruct();
            pane.addDropdown(this._paneProperties.blockLineTypeAlgorithm, {
                title: "resourcePack.editor.toolRail.line.pane.algorithm.title",
                tooltip: "resourcePack.editor.toolRail.line.pane.algorithm.tooltip",
                entries: [ {
                    label: "resourcePack.editor.toolRail.line.pane.algorithm.Direct",
                    value: BlockLineType.Direct
                }, {
                    label: "resourcePack.editor.toolRail.line.pane.algorithm.StaggeredContour",
                    value: BlockLineType.StaggeredContour
                } ],
                onChange: () => {
                    this.updateLineAlgorithm();
                }
            });
            pane.addDivider();
            pane.addToggleGroup(this._paneProperties.quickActionMode, {
                title: "resourcePack.editor.toolRail.line.quickAction.title",
                tooltip: "resourcePack.editor.toolRail.line.quickAction.tooltip",
                hiddenLabel: false,
                entries: [ {
                    value: QuickActionMode.FillLine,
                    icon: "fillIcon",
                    tooltip: {
                        title: {
                            id: "resourcePack.editor.toolRail.line.quickAction.fillLines",
                            props: [ getInputMarkup("editor:lineToolKeyBinding:fill", "[", "]") ]
                        },
                        description: "resourcePack.editor.toolRail.line.quickAction.fillLines.tooltip"
                    }
                }, {
                    value: QuickActionMode.DeleteBlocks,
                    icon: "trashCanIcon",
                    tooltip: {
                        title: {
                            id: "resourcePack.editor.toolRail.line.quickAction.deleteBlocks",
                            props: [ getInputMarkup("editor:lineToolKeyBinding:delete", "[", "]") ]
                        },
                        description: "resourcePack.editor.toolRail.line.quickAction.deleteBlocks.tooltip"
                    }
                }, {
                    value: QuickActionMode.AddToSelection,
                    icon: "marqueeAddIcon",
                    tooltip: {
                        title: {
                            id: "resourcePack.editor.toolRail.line.quickAction.addToSelection",
                            props: [ getInputMarkup("editor:lineToolKeyBinding:addToSelection", "[", "]") ]
                        },
                        description: "resourcePack.editor.toolRail.line.quickAction.addToSelection.tooltip"
                    }
                }, {
                    value: QuickActionMode.ClearSelectedPoints,
                    icon: "pack://textures/editor/Point-Subtract.png",
                    tooltip: {
                        title: {
                            id: "resourcePack.editor.toolRail.line.quickAction.clearSelectedPoints",
                            props: [ getInputMarkup("editor:lineToolKeyBinding:clearSelected", "[", "]") ]
                        },
                        description: "resourcePack.editor.toolRail.line.quickAction.clearSelectedPoints.tooltip"
                    }
                }, {
                    value: QuickActionMode.ClearAllPoints,
                    icon: "clearIcon",
                    tooltip: {
                        title: {
                            id: "resourcePack.editor.toolRail.line.quickAction.clearAllPoints",
                            props: [ getInputMarkup("editor:lineToolKeyBinding:clearAll", "[", "]") ]
                        },
                        description: "resourcePack.editor.toolRail.line.quickAction.clearAllPoints.tooltip"
                    }
                } ],
                onChange: newVal => {
                    this._paneProperties.quickActionMode.set(QuickActionMode.Invalid);
                    switch (newVal) {
                      case QuickActionMode.FillLine:
                        {
                            this._telemetryManager.fireTelemetryEvent(LineTelemetry.QuickAction, {
                                action: LineTelemetry.FillLine
                            });
                            this.fillLine();
                            break;
                        }

                      case QuickActionMode.DeleteBlocks:
                        {
                            this._telemetryManager.fireTelemetryEvent(LineTelemetry.QuickAction, {
                                action: LineTelemetry.DeleteBlocks
                            });
                            this.deleteBlocks();
                            break;
                        }

                      case QuickActionMode.AddToSelection:
                        {
                            this._telemetryManager.fireTelemetryEvent(LineTelemetry.QuickAction, {
                                action: LineTelemetry.AddToSelection
                            });
                            this.addToSelection();
                            break;
                        }

                      case QuickActionMode.ClearSelectedPoints:
                        {
                            this._telemetryManager.fireTelemetryEvent(LineTelemetry.QuickAction, {
                                action: LineTelemetry.ClearSelectedPoints
                            });
                            this.clearSelectedPoints();
                            break;
                        }

                      case QuickActionMode.ClearAllPoints:
                        {
                            this._telemetryManager.fireTelemetryEvent(LineTelemetry.QuickAction, {
                                action: LineTelemetry.ClearAllPoints
                            });
                            this.clearAllPoints();
                            break;
                        }
                    }
                }
            });
            pane.addDivider();
            pane.hide();
            return pane;
        }
        disableControlPointWeightSliders(usingGlobalWeights) {
            if (!this._controlPointProperties.isUniformWeightPropertyItem || !this._controlPointProperties.uniformWeightPropertyItem || !this._controlPointProperties.horizontalWeightPropertyItem || !this._controlPointProperties.verticalWeightPropertyItem) {
                return;
            }
            this._controlPointProperties.isUniformWeightPropertyItem.enable = !usingGlobalWeights;
            this._controlPointProperties.uniformWeightPropertyItem.enable = !usingGlobalWeights;
            this._controlPointProperties.horizontalWeightPropertyItem.enable = !usingGlobalWeights;
            this._controlPointProperties.verticalWeightPropertyItem.enable = !usingGlobalWeights;
        }
        toggleUniformControlPointWeights(usingUniformValues) {
            if (!this._controlPointProperties.isUniformWeightPropertyItem || !this._controlPointProperties.uniformWeightPropertyItem || !this._controlPointProperties.horizontalWeightPropertyItem || !this._controlPointProperties.verticalWeightPropertyItem) {
                return;
            }
            this._controlPointProperties.uniformWeightPropertyItem.visible = usingUniformValues;
            this._controlPointProperties.uniformWeightPropertyItem.enable = usingUniformValues;
            this._controlPointProperties.horizontalWeightPropertyItem.visible = !usingUniformValues;
            this._controlPointProperties.horizontalWeightPropertyItem.enable = !usingUniformValues;
            this._controlPointProperties.verticalWeightPropertyItem.visible = !usingUniformValues;
            this._controlPointProperties.verticalWeightPropertyItem.enable = !usingUniformValues;
        }
        createLineAndPointWeightsPanes(pane) {
            const globalWeightPane = pane.createSubPane({
                title: "resourcePack.editor.toolRail.line.pane.globallineweight.title",
                infoTooltip: {
                    title: "resourcePack.editor.toolRail.line.pane.globallineweight.title",
                    description: [ "resourcePack.editor.toolRail.line.pane.thicknessWeight.tooltip" ]
                },
                hasExpander: true
            });
            globalWeightPane.beginConstruct();
            globalWeightPane.addBool(this._paneProperties.isUniformWeight, {
                title: "resourcePack.editor.toolRail.line.pane.uniformWeight.title",
                tooltip: "resourcePack.editor.toolRail.line.pane.uniformWeight.tooltip",
                onChange: newVal => {
                    this._paneProperties.uniformWeightPropertyItem.visible = newVal;
                    this._paneProperties.uniformWeightPropertyItem.enable = newVal;
                    this._paneProperties.horizontalWeightPropertyItem.visible = !newVal;
                    this._paneProperties.horizontalWeightPropertyItem.enable = !newVal;
                    this._paneProperties.verticalWeightPropertyItem.visible = !newVal;
                    this._paneProperties.verticalWeightPropertyItem.enable = !newVal;
                    this._pointLinePropsDirty = true;
                }
            });
            this._paneProperties.uniformWeightPropertyItem = globalWeightPane.addNumber(this._paneProperties.uniformWeight, {
                title: "resourcePack.editor.toolRail.line.pane.thicknessWeight.title",
                tooltip: "resourcePack.editor.toolRail.line.pane.thicknessWeight.tooltip",
                variant: server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider,
                isInteger: true,
                min: LineBehavior.LINE_MIN_WEIGHT,
                max: LineBehavior.LINE_MAX_WEIGHT,
                enable: false,
                visible: false,
                onChange: () => {
                    this._pointLinePropsDirty = true;
                }
            });
            this._paneProperties.horizontalWeightPropertyItem = globalWeightPane.addNumber(this._paneProperties.horizontalWeight, {
                title: "resourcePack.editor.toolRail.line.pane.thicknessHorizontalWeight.title",
                tooltip: "resourcePack.editor.toolRail.line.pane.thicknessHorizontalWeight.tooltip",
                variant: server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider,
                isInteger: true,
                min: LineBehavior.LINE_MIN_WEIGHT,
                max: LineBehavior.LINE_MAX_WEIGHT,
                enable: true,
                onChange: () => {
                    this._pointLinePropsDirty = true;
                }
            });
            this._paneProperties.verticalWeightPropertyItem = globalWeightPane.addNumber(this._paneProperties.verticalWeight, {
                title: "resourcePack.editor.toolRail.line.pane.thicknessVerticalWeight.title",
                tooltip: "resourcePack.editor.toolRail.line.pane.thicknessVerticalWeight.tooltip",
                variant: server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider,
                isInteger: true,
                min: LineBehavior.LINE_MIN_WEIGHT,
                max: LineBehavior.LINE_MAX_WEIGHT,
                enable: true,
                onChange: () => {
                    this._pointLinePropsDirty = true;
                }
            });
            globalWeightPane.endConstruct();
            const controlPointPane = pane.createSubPane({
                title: "Point Pane",
                hasExpander: false
            });
            controlPointPane.beginConstruct();
            const pointPropertiesPane = controlPointPane.createSubPane({
                title: "resourcePack.editor.toolRail.line.point.properties.pane.title",
                infoTooltip: {
                    title: "resourcePack.editor.toolRail.line.point.properties.pane.title",
                    description: [ "resourcePack.editor.toolRail.line.point.properties.pane.tooltip" ]
                },
                hasExpander: true,
                hasMargins: false
            });
            pointPropertiesPane.beginConstruct();
            pointPropertiesPane.addVector3(this._controlPointProperties.pointPosition, {
                title: "resourcePack.editor.toolRail.line.point.properties.position.pane.title",
                tooltip: "resourcePack.editor.toolRail.line.point.properties.position.pane.tooltip",
                onChange: () => {
                    this._pointLinePropsDirty = true;
                }
            });
            pointPropertiesPane.endConstruct();
            const pointWeightPane = controlPointPane.createSubPane({
                title: "resourcePack.editor.toolRail.line.point.weight.pane.title",
                infoTooltip: {
                    title: "resourcePack.editor.toolRail.line.point.weight.pane.title",
                    description: [ "resourcePack.editor.toolRail.line.point.weight.pane.tooltip" ]
                },
                hasExpander: true,
                hasMargins: false
            });
            pointWeightPane.beginConstruct();
            pointWeightPane.addBool(this._controlPointProperties.useGlobalLineWeight, {
                title: "resourcePack.editor.toolRail.line.point.globalweight.title",
                tooltip: "resourcePack.editor.toolRail.line.point.globalweight.tooltip",
                onChange: newVal => {
                    this.disableControlPointWeightSliders(newVal);
                    this._pointLinePropsDirty = true;
                }
            });
            this._controlPointProperties.isUniformWeightPropertyItem = pointWeightPane.addBool(this._controlPointProperties.isUniformWeight, {
                title: "resourcePack.editor.toolRail.line.pane.uniformWeight.title",
                tooltip: "resourcePack.editor.toolRail.line.pane.point.uniformWeight.tooltip",
                onChange: newVal => {
                    this.toggleUniformControlPointWeights(newVal);
                    this._pointLinePropsDirty = true;
                },
                enable: !this._controlPointProperties.useGlobalLineWeight.value
            });
            this._controlPointProperties.uniformWeightPropertyItem = pointWeightPane.addNumber(this._controlPointProperties.uniformWeight, {
                title: "resourcePack.editor.toolRail.line.pane.thicknessWeight.title",
                tooltip: "resourcePack.editor.toolRail.line.pane.point.thicknessWeight.tooltip",
                variant: server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider,
                isInteger: true,
                min: LineBehavior.LINE_MIN_WEIGHT,
                max: LineBehavior.LINE_MAX_WEIGHT,
                enable: !this._controlPointProperties.useGlobalLineWeight.value,
                visible: false,
                onChange: () => {
                    this._pointLinePropsDirty = true;
                }
            });
            this._controlPointProperties.horizontalWeightPropertyItem = pointWeightPane.addNumber(this._controlPointProperties.horizontalWeight, {
                title: "resourcePack.editor.toolRail.line.pane.thicknessHorizontalWeight.title",
                tooltip: "resourcePack.editor.toolRail.line.pane.point.thicknessHorizontalWeight.tooltip",
                variant: server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider,
                isInteger: true,
                min: LineBehavior.LINE_MIN_WEIGHT,
                max: LineBehavior.LINE_MAX_WEIGHT,
                enable: !this._controlPointProperties.useGlobalLineWeight.value,
                onChange: () => {
                    this._pointLinePropsDirty = true;
                }
            });
            this._controlPointProperties.verticalWeightPropertyItem = pointWeightPane.addNumber(this._controlPointProperties.verticalWeight, {
                title: "resourcePack.editor.toolRail.line.pane.thicknessVerticalWeight.title",
                tooltip: "resourcePack.editor.toolRail.line.pane.point.thicknessVerticalWeight.tooltip",
                variant: server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider,
                isInteger: true,
                min: LineBehavior.LINE_MIN_WEIGHT,
                max: LineBehavior.LINE_MAX_WEIGHT,
                enable: !this._controlPointProperties.useGlobalLineWeight.value,
                onChange: () => {
                    this._pointLinePropsDirty = true;
                }
            });
            pointWeightPane.endConstruct();
            controlPointPane.hide();
            controlPointPane.endConstruct();
            return controlPointPane;
        }
        registerMouseButtonInputs() {
            const executeAction = this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
                onExecute: (mouseRay, mouseProps) => {
                    if (mouseProps.mouseAction === server_editor_namespaceObject.MouseActionType.LeftButton && mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonUp && this._uiSession.toolRail.getSelectedToolId() === this._tool.id) {
                        if (mouseProps.modifiers.ctrl) {
                            this.ctrlClick(mouseRay);
                        } else {
                            this.click(mouseRay);
                        }
                    }
                }
            });
            this._tool.registerMouseButtonBinding(executeAction);
        }
        registerKeyboardInputs() {
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.clearAllPoints();
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.BACKSPACE,
                modifier: server_editor_namespaceObject.InputModifier.Control
            }, {
                uniqueId: `editor:lineToolKeyBinding:clearAll`,
                label: `resourcePack.editor.toolRail.line.keyBinding.clearAll.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.clearAll.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.clearSelectedPoints();
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.BACKSPACE,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, {
                uniqueId: `editor:lineToolKeyBinding:clearSelected`,
                label: `resourcePack.editor.toolRail.line.keyBinding.clearSelected.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.clearSelected.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.fillLine();
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.KEY_F,
                modifier: server_editor_namespaceObject.InputModifier.Control
            }, {
                uniqueId: `editor:lineToolKeyBinding:fill`,
                label: `resourcePack.editor.toolRail.line.keyBinding.fill.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.fill.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.toggleAllPoints();
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.KEY_A,
                modifier: server_editor_namespaceObject.InputModifier.Control
            }, {
                uniqueId: `editor:lineToolKeyBinding:toggleAll`,
                label: `resourcePack.editor.toolRail.line.keyBinding.toggleAll.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.toggleAll.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.deleteBlocks();
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.DELETE
            }, {
                uniqueId: `editor:lineToolKeyBinding:delete`,
                label: `resourcePack.editor.toolRail.line.keyBinding.delete.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.delete.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.addToSelection();
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.KEY_S,
                modifier: server_editor_namespaceObject.InputModifier.Alt
            }, {
                uniqueId: `editor:lineToolKeyBinding:addToSelection`,
                label: `resourcePack.editor.toolRail.line.keyBinding.addToSelection.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.addToSelection.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.clampWeights(1, true);
                    this._pointLinePropsDirty = true;
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.RIGHT,
                modifier: server_editor_namespaceObject.InputModifier.Shift
            }, {
                uniqueId: `editor:lineToolKeyBinding:increaseHorizontalWeight`,
                label: `resourcePack.editor.toolRail.line.keyBinding.increaseHorizontalWeight.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.increaseHorizontalWeight.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.clampWeights(-1, true);
                    this._pointLinePropsDirty = true;
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.LEFT,
                modifier: server_editor_namespaceObject.InputModifier.Shift
            }, {
                uniqueId: `editor:lineToolKeyBinding:decreaseHorizontalWeight`,
                label: `resourcePack.editor.toolRail.line.keyBinding.decreaseHorizontalWeight.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.decreaseHorizontalWeight.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.clampWeights(1, false);
                    this._pointLinePropsDirty = true;
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.UP,
                modifier: server_editor_namespaceObject.InputModifier.Shift
            }, {
                uniqueId: `editor:lineToolKeyBinding:increaseVerticalWeight`,
                label: `resourcePack.editor.toolRail.line.keyBinding.increaseVerticalWeight.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.increaseVerticalWeight.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.clampWeights(-1, false);
                    this._pointLinePropsDirty = true;
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.DOWN,
                modifier: server_editor_namespaceObject.InputModifier.Shift
            }, {
                uniqueId: `editor:lineToolKeyBinding:decreaseVerticalWeight`,
                label: `resourcePack.editor.toolRail.line.keyBinding.decreaseVerticalWeight.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.decreaseVerticalWeight.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.nudgeSelected(direction_Direction.Up, "up");
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.PAGE_UP,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, {
                uniqueId: `editor:lineToolKeyBinding:moveUp`,
                label: `resourcePack.editor.toolRail.line.keyBinding.moveUp.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.moveUp.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.nudgeSelected(direction_Direction.Down, "down");
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.PAGE_DOWN,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, {
                uniqueId: `editor:lineToolKeyBinding:moveDown`,
                label: `resourcePack.editor.toolRail.line.keyBinding.moveDown.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.moveDown.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.nudgeSelected(direction_Direction.Left, "left");
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.LEFT,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, {
                uniqueId: `editor:lineToolKeyBinding:moveLeft`,
                label: `resourcePack.editor.toolRail.line.keyBinding.moveLeft.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.moveLeft.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.nudgeSelected(direction_Direction.Right, "right");
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.RIGHT,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, {
                uniqueId: `editor:lineToolKeyBinding:moveRight`,
                label: `resourcePack.editor.toolRail.line.keyBinding.moveRight.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.moveRight.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.nudgeSelected(direction_Direction.Forward, "forward");
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.UP,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, {
                uniqueId: `editor:lineToolKeyBinding:moveForward`,
                label: `resourcePack.editor.toolRail.line.keyBinding.moveForward.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.moveForward.tooltip`
            });
            this._tool.registerKeyBinding(this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.nudgeSelected(direction_Direction.Back, "back");
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.DOWN,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, {
                uniqueId: `editor:lineToolKeyBinding:moveBack`,
                label: `resourcePack.editor.toolRail.line.keyBinding.moveBack.title`,
                tooltip: `resourcePack.editor.toolRail.line.keyBinding.moveBack.tooltip`
            });
        }
        clampWeights(value, isHorizontal) {
            let weight = this._paneProperties.isUniformWeight.value ? this._paneProperties.uniformWeight.value : isHorizontal ? this._paneProperties.horizontalWeight.value : this._paneProperties.verticalWeight.value;
            weight += value;
            const clamped = Math.min(Math.max(weight, LineBehavior.LINE_MIN_WEIGHT), LineBehavior.LINE_MAX_WEIGHT);
            if (this._paneProperties.isUniformWeight.value) {
                this._paneProperties.uniformWeight.set(clamped);
            } else if (isHorizontal) {
                this._paneProperties.horizontalWeight.set(clamped);
            } else {
                this._paneProperties.verticalWeight.set(clamped);
            }
        }
        updateState(stateInfo) {
            this._lineSegmentsManager.setState(stateInfo.pointStates);
            try {
                this._uiSession.extensionContext.selectionManager.volume.set(stateInfo.selectionVolume);
            } catch (e) {
                this._uiSession.log.error(`Something went wrong while restoring the selection volume during an undo/redo: '${stringFromException(e)}'`, {
                    channelMask: server_editor_namespaceObject.LogChannel.All
                });
            }
        }
        startTransaction(name) {
            if (this._tempTransactionData !== undefined) {
                throw new Error("Cannot perform a transactionable operation while another transaction is active");
            }
            const lineToolName = `LineTool:${name}`;
            const pointStates = [];
            for (let i = 0; i < this._lineSegmentsManager.controlPoints.length; i++) {
                const lineState = {
                    location: this._lineSegmentsManager.controlPoints[i].location,
                    separation: this._lineSegmentsManager.controlPoints[i].isSeparate,
                    selection: this._lineSegmentsManager.controlPoints[i].isSelected,
                    weightsOverridden: this._lineSegmentsManager.controlPoints[i].isWeightsOverridden,
                    usingUniformValue: this._lineSegmentsManager.controlPoints[i].usingUniformValues,
                    horizontalWeight: this._lineSegmentsManager.controlPoints[i].horizontalWeight,
                    verticalWeight: this._lineSegmentsManager.controlPoints[i].verticalWeight
                };
                pointStates.push(lineState);
            }
            const oldState = {
                pointStates,
                selectionVolume: this._uiSession.extensionContext.selectionManager.volume.get()
            };
            const newState = {
                pointStates: [],
                selectionVolume: oldState.selectionVolume
            };
            this._tempTransactionData = {
                oldState,
                newState,
                operationName: lineToolName
            };
            this._uiSession.extensionContext.transactionManager.openTransaction(lineToolName);
        }
        commitTransaction(name) {
            if (this._tempTransactionData) {
                const lineToolName = `LineTool:${name}`;
                const newPointStates = [];
                for (let i = 0; i < this._lineSegmentsManager.controlPoints.length; i++) {
                    const lineState = {
                        location: this._lineSegmentsManager.controlPoints[i].location,
                        separation: this._lineSegmentsManager.controlPoints[i].isSeparate,
                        selection: this._lineSegmentsManager.controlPoints[i].isSelected,
                        weightsOverridden: this._lineSegmentsManager.controlPoints[i].isWeightsOverridden,
                        usingUniformValue: this._lineSegmentsManager.controlPoints[i].usingUniformValues,
                        horizontalWeight: this._lineSegmentsManager.controlPoints[i].horizontalWeight,
                        verticalWeight: this._lineSegmentsManager.controlPoints[i].verticalWeight
                    };
                    newPointStates.push(lineState);
                }
                this._tempTransactionData.newState = {
                    pointStates: newPointStates,
                    selectionVolume: this._uiSession.extensionContext.selectionManager.volume.get()
                };
                this._transactionHandler.addUserDefinedOperation(this._tempTransactionData, lineToolName);
                this._uiSession.extensionContext.transactionManager.commitOpenTransaction();
                this._tempTransactionData = undefined;
            } else {
                this._uiSession.log.warning("There was no transaction data available to commit");
            }
        }
        cancelTransaction() {
            this._uiSession.extensionContext.transactionManager.discardOpenTransaction();
            this._tempTransactionData = undefined;
        }
        performSingleTransactionableOperation(operation, name) {
            this.startTransaction(name);
            try {
                const operationCompleted = operation();
                if (!operationCompleted) {
                    throw new Error(`Operation 'LineTool:${name}' failed`);
                }
                this.commitTransaction(name);
            } catch (e) {
                this.cancelTransaction();
                this._uiSession.log.error(`Something went wrong! 'LineTool:${name}' failed: ${stringFromException(e)}`, {
                    channelMask: server_editor_namespaceObject.LogChannel.All
                });
            }
        }
        clearAllPoints() {
            if (this._lineSegmentsManager.controlPoints.length === 0) {
                this._uiSession.log.warning(`No control points to clear.`);
                return;
            }
            this.performSingleTransactionableOperation((() => {
                this._telemetryManager.fireTelemetryEvent(LineTelemetry.ClearAllPoints);
                this._lineSegmentsManager.clearAll();
                this.toggleSelectedControlPointOp();
                return true;
            }), "ClearAllPoints");
        }
        fillLine() {
            if (this._lineSegmentsManager.controlPoints.length === 0) {
                this._uiSession.log.warning(`No lines or points available to fill`);
                return;
            }
            this._telemetryManager.fireTelemetryEvent(LineTelemetry.FillLine);
            this._lineSegmentsManager.fillLine().then((() => {})).catch((() => {}));
        }
        deleteBlocks() {
            if (this._lineSegmentsManager.controlPoints.length === 0) {
                this._uiSession.log.warning(`No blocks highlighted to delete.`);
                return;
            }
            this._telemetryManager.fireTelemetryEvent(LineTelemetry.DeleteBlocks);
            this._lineSegmentsManager.fillLine(true).then((() => {})).catch((() => {}));
        }
        updateLineAlgorithm() {
            this._telemetryManager.fireTelemetryEvent(LineTelemetry.AlgorithmChanged, {
                mode: this._paneProperties.blockLineTypeAlgorithm.value
            });
            this._lineSegmentsManager.blockLineTypeAlgorithm = this._paneProperties.blockLineTypeAlgorithm.value;
        }
        updatePointAndLineVals() {
            this._telemetryManager.fireTelemetryEvent(LineTelemetry.WeightChanged);
            this._lineSegmentsManager.updateSelectedControlPointData(!this._controlPointProperties.useGlobalLineWeight.value, this._controlPointProperties.isUniformWeight.value, this._controlPointProperties.pointPosition.value, this._controlPointProperties.isUniformWeight.value ? this._controlPointProperties.uniformWeight.value : this._controlPointProperties.horizontalWeight.value, this._controlPointProperties.isUniformWeight.value ? this._controlPointProperties.uniformWeight.value : this._controlPointProperties.verticalWeight.value);
            this._lineSegmentsManager.updateLineWeights(this._paneProperties.isUniformWeight.value ? this._paneProperties.uniformWeight.value : this._paneProperties.horizontalWeight.value, this._paneProperties.isUniformWeight.value ? this._paneProperties.uniformWeight.value : this._paneProperties.verticalWeight.value);
        }
        clearSelectedPoints() {
            if (!this._lineSegmentsManager.controlPoints.some((point => point.isSelected))) {
                this._uiSession.log.warning(`No selected control points to clear.`);
                return;
            }
            this.performSingleTransactionableOperation((() => {
                this._telemetryManager.fireTelemetryEvent(LineTelemetry.ClearSelectedPoints);
                this._lineSegmentsManager.clearSelectedPoints();
                this.toggleSelectedControlPointOp();
                return true;
            }), "ClearSelectedPoints");
        }
        toggleAllPoints() {
            if (this._lineSegmentsManager.controlPoints.length === 0) {
                this._uiSession.log.warning(`No control points to toggle.`);
                return;
            }
            this.performSingleTransactionableOperation((() => {
                this._telemetryManager.fireTelemetryEvent(LineTelemetry.ToggleSelectAll);
                this._lineSegmentsManager.toggleSelectAllPoints();
                return true;
            }), "ToggleSelectAllLinePoints");
        }
        addToSelection() {
            if (this._lineSegmentsManager.linePreviewMap.previewVolume.isEmpty) {
                this._uiSession.log.warning(`No lines exist to add to selection.`);
                return;
            }
            this.performSingleTransactionableOperation((() => {
                this._telemetryManager.fireTelemetryEvent(LineTelemetry.AddToSelection);
                this._uiSession.extensionContext.selectionManager.volume.add(this._lineSegmentsManager.linePreviewMap.previewVolume.volume);
                this._lineSegmentsManager.clearAll();
                return true;
            }), `AddToSelection`);
        }
        nudgeSelected(direction, directionStr) {
            if (this._lineSegmentsManager.controlPoints.length === 0) {
                this._uiSession.log.warning(`No control points to nudge.`);
                return;
            }
            this.performSingleTransactionableOperation((() => {
                this._telemetryManager.fireTelemetryEvent(LineTelemetry.Nudge, {
                    direction: directionStr
                });
                this._lineSegmentsManager.nudgeSelectedPoints(direction);
                return true;
            }), `Nudge${directionStr}`);
        }
        ctrlClick(mouseRay) {
            const found = this.getClosestControlPointClicked(mouseRay.location, mouseRay.direction);
            if (found !== undefined) {
                this.performSingleTransactionableOperation((() => {
                    this._telemetryManager.fireTelemetryEvent(LineTelemetry.LeftClick, {
                        mode: "noModifiers"
                    });
                    this._lineSegmentsManager.toggleSelectPoint(found);
                    this.updateControlPointProps(found);
                    return true;
                }), "ToggleSelectPoint");
            } else if (mouseRay?.cursorBlockLocation) {
                const targetLocation = mouseRay.cursorBlockLocation;
                if (this._lineSegmentsManager.controlPoints.length >= LineBehavior.MAX_CONTROL_POINTS) {
                    this._uiSession.log.warning(`Cannot place more than ${LineBehavior.MAX_CONTROL_POINTS} points.`);
                    return;
                }
                if (!this.isLocationValidForNewPoint(targetLocation)) {
                    this._uiSession.log.warning(`Cannot place point here (new control points must be within 100 blocks of the previous point, and no two points can exist in the same location).`);
                    return;
                }
                this.performSingleTransactionableOperation((() => {
                    this._telemetryManager.fireTelemetryEvent(LineTelemetry.LeftClick, {
                        mode: "ctrl"
                    });
                    this._lineSegmentsManager.addNewPoint(targetLocation, true);
                    this.toggleSelectedControlPointOp();
                    return true;
                }), "AddSeparatedPoint");
            }
        }
        click(mouseRay) {
            const found = this.getClosestControlPointClicked(mouseRay.location, mouseRay.direction);
            if (found !== undefined) {
                this.performSingleTransactionableOperation((() => {
                    this._telemetryManager.fireTelemetryEvent(LineTelemetry.LeftClick, {
                        mode: "noModifiers"
                    });
                    this._lineSegmentsManager.toggleSelectPoint(found);
                    this.updateControlPointProps(found);
                    return true;
                }), "ToggleSelectPoint");
            } else if (mouseRay?.cursorBlockLocation) {
                const targetLocation = mouseRay.cursorBlockLocation;
                if (this._lineSegmentsManager.controlPoints.length >= LineBehavior.MAX_CONTROL_POINTS) {
                    this._uiSession.log.warning(`Cannot place more than ${LineBehavior.MAX_CONTROL_POINTS} points.`);
                    return;
                }
                if (!this.isLocationValidForNewPoint(targetLocation)) {
                    this._uiSession.log.warning(`Cannot place point here (new control points must be within 100 blocks of the previous point, and no two points can exist in the same location).`);
                    return;
                }
                this.performSingleTransactionableOperation((() => {
                    this._telemetryManager.fireTelemetryEvent(LineTelemetry.LeftClick, {
                        mode: "noModifiers"
                    });
                    this._lineSegmentsManager.addNewPoint(targetLocation);
                    this.toggleSelectedControlPointOp();
                    return true;
                }), "AddPoint");
            }
        }
        getClosestControlPointClicked(startPos, direction) {
            let minDistance = Infinity;
            let result = undefined;
            const start = [ startPos.x, startPos.y, startPos.z ];
            const dir = [ direction.x, direction.y, direction.z ];
            for (let i = 0; i < this._lineSegmentsManager.controlPoints.length; i++) {
                let tMin = 0;
                let tMax = Infinity;
                const blockMin = {
                    x: this._lineSegmentsManager.controlPoints[i].location.x,
                    y: this._lineSegmentsManager.controlPoints[i].location.y,
                    z: this._lineSegmentsManager.controlPoints[i].location.z
                };
                const blockMax = {
                    x: this._lineSegmentsManager.controlPoints[i].location.x + 1,
                    y: this._lineSegmentsManager.controlPoints[i].location.y + 1,
                    z: this._lineSegmentsManager.controlPoints[i].location.z + 1
                };
                for (let i = 0; i < 3; i++) {
                    const min = [ blockMin.x, blockMin.y, blockMin.z ][i];
                    const max = [ blockMax.x, blockMax.y, blockMax.z ][i];
                    if (Math.abs(dir[i]) < 1e-6) {
                        if (start[i] < min || start[i] > max) {
                            continue;
                        }
                    } else {
                        const t1 = (min - start[i]) / dir[i];
                        const t2 = (max - start[i]) / dir[i];
                        tMin = Math.max(tMin, Math.min(t1, t2));
                        tMax = Math.min(tMax, Math.max(t1, t2));
                    }
                }
                if (tMax >= Math.max(0, tMin)) {
                    const ptDistance = Math.abs(lib.Vector3Utils.magnitude(lib.Vector3Utils.subtract(this._lineSegmentsManager.controlPoints[i].location, startPos)));
                    if (ptDistance < minDistance) {
                        result = this._lineSegmentsManager.controlPoints[i];
                        minDistance = ptDistance;
                    }
                }
            }
            return result;
        }
        runUpdatePointAndLineValsOperation() {
            if (this._pointLinePropsDirty) {
                this.updatePointAndLineVals();
                this._pointLinePropsDirty = false;
            }
        }
        toggleSelectedControlPointOp() {
            const selectedPoints = this._lineSegmentsManager.selectedPoints;
            if (selectedPoints.length !== 1) {
                this._controlPointWeightPane.hide();
                return;
            }
            this.updateControlPointProps(selectedPoints[0]);
            this._controlPointWeightPane.show();
        }
        updateControlPointProps(selectedPoint) {
            this._controlPointProperties.pointPosition.set(selectedPoint.location);
            this._controlPointProperties.horizontalWeight.set(selectedPoint.horizontalWeight);
            this._controlPointProperties.verticalWeight.set(selectedPoint.verticalWeight);
            if (this._controlPointProperties.isUniformWeight.value !== selectedPoint.usingUniformValues) {
                this._controlPointProperties.isUniformWeight.set(selectedPoint.usingUniformValues);
                this.toggleUniformControlPointWeights(selectedPoint.usingUniformValues);
            }
            if (this._controlPointProperties.useGlobalLineWeight.value !== !selectedPoint.isWeightsOverridden) {
                this._controlPointProperties.useGlobalLineWeight.set(!selectedPoint.isWeightsOverridden);
                this.disableControlPointWeightSliders(!selectedPoint.isWeightsOverridden);
            }
        }
        isLocationValidForNewPoint(location) {
            if (this._lineSegmentsManager.controlPoints.length === 0) {
                return true;
            }
            const locationUnoccupied = !this._lineSegmentsManager.controlPoints.some((pt => lib.Vector3Utils.equals(pt.location, location)));
            const locationWithinMaxDistance = Math.abs(lib.Vector3Utils.magnitude(lib.Vector3Utils.subtract(location, this._lineSegmentsManager.controlPoints[this._lineSegmentsManager.controlPoints.length - 1].location))) <= LineBehavior.MAX_CONTROL_POINTS_DISTANCE;
            return locationUnoccupied && locationWithinMaxDistance;
        }
    }
    LineBehavior.BEHAVIOR_NAME = "Line";
    LineBehavior.LINE_MIN_WEIGHT = 1;
    LineBehavior.LINE_MAX_WEIGHT = 5;
    LineBehavior.MAX_CONTROL_POINTS = 80;
    LineBehavior.MAX_CONTROL_POINTS_DISTANCE = 100;
    LineBehavior.MAX_PTS_PLAYER_DISTANCE = 100;
    LineBehavior.SELECTION_COLOR_LIGHT_BLUE = {
        red: 0,
        green: .85,
        blue: .95,
        alpha: 1
    };
    class Stack {
        constructor(maxStackSize) {
            this.maxStackSize = maxStackSize;
            this.internalStack = [];
            this.stackHead = -1;
        }
        isEmpty() {
            return this.internalStack.length === 0;
        }
        push(element) {
            if (this.stackHead < this.internalStack.length - 1) {
                this.internalStack.length = this.stackHead + 1;
            }
            const elementsToTrim = this.maxStackSize && this.internalStack.length >= this.maxStackSize ? this.maxStackSize - this.internalStack.length + 1 : 0;
            this.internalStack = [ ...this.internalStack.slice(elementsToTrim), element ];
            this.stackHead = this.internalStack.length - 1;
        }
        moveHeadDown() {
            if (this.isEmpty()) {
                return;
            }
            this.stackHead = (0, lib.clampNumber)(--this.stackHead, 0, this.internalStack.length - 1);
        }
        moveHeadUp() {
            if (this.isEmpty()) {
                return;
            }
            this.stackHead = (0, lib.clampNumber)(++this.stackHead, 0, this.internalStack.length - 1);
        }
        head() {
            if (this.isEmpty()) {
                return undefined;
            }
            return this.internalStack[this.stackHead];
        }
        length() {
            return this.internalStack.length;
        }
        clear() {
            this.internalStack = [];
            this.stackHead = -1;
        }
        forEach(callbackfn) {
            this.internalStack.forEach(callbackfn);
        }
    }
    const logNavigationInfoDynamicPropertyName = "navigationstack:lognavigationinfo";
    class NavigationStackBehavior {
        constructor(uiSession) {
            this.uiSession = uiSession;
            this.stack = new Stack(NavigationStackBehavior.MAX_STACK_SIZE);
            this.logNavigationInfo = false;
            this.navigationLoggingMenuItem = undefined;
            this.updateInternalHandle = undefined;
            uiSession.log.debug(`Initializing ${NavigationStackBehavior.BEHAVIOR_NAME}`);
            this.loadDynamicProperties(uiSession);
            if (this.shouldAddAutomatedRecord(uiSession.extensionContext.player)) {
                this.addRecordToStack(uiSession);
            }
            if (!this.updateInternalHandle) {
                this.queueInitialDelayAddRecordCheck(uiSession);
            }
        }
        teardown() {
            this.uiSession.log.debug(`Shutting down ${NavigationStackBehavior.BEHAVIOR_NAME}`);
            if (this.updateInternalHandle) {
                server_namespaceObject.system.clearRun(this.updateInternalHandle);
            }
        }
        shouldAddAutomatedRecord(player) {
            const headRecord = this.stack.head();
            if (headRecord) {
                if (player.dimension !== headRecord.dimension) {
                    return true;
                }
                const playerVelocity = player.getVelocity();
                const playerLocation = player.location;
                const headRecordLocation = headRecord.pos;
                const distanceFromHeadRecord = lib.Vector3Utils.magnitude(lib.Vector3Utils.subtract(headRecordLocation, playerLocation));
                const shouldAddAutomatedRecord = Math.abs(playerVelocity.x) === 0 && Math.abs(playerVelocity.y) === 0 && Math.abs(playerVelocity.z) === 0 && distanceFromHeadRecord >= NavigationStackBehavior.AUTO_ADD_MIN_DISTANCE_IN_BLOCKS;
                return shouldAddAutomatedRecord;
            } else {
                return true;
            }
        }
        addRecordToStack(uiSession) {
            const player = uiSession.extensionContext.player;
            this.stack.push({
                pos: player.location,
                rot: player.getRotation(),
                dimension: player.dimension
            });
            this.logStack();
        }
        queueInitialDelayAddRecordCheck(uiSession) {
            this.updateInternalHandle = server_namespaceObject.system.runTimeout((() => {
                if (this.shouldAddAutomatedRecord(uiSession.extensionContext.player)) {
                    this.addRecordToStack(uiSession);
                    this.queueInitialDelayAddRecordCheck(uiSession);
                } else {
                    this.doRepeatedAutomatedRecordCheck(uiSession);
                }
            }), NavigationStackBehavior.AUTO_ADD_INTERVAL_IN_SECONDS * server_namespaceObject.TicksPerSecond);
        }
        doRepeatedAutomatedRecordCheck(uiSession) {
            this.updateInternalHandle = server_namespaceObject.system.runInterval((() => {
                if (this.shouldAddAutomatedRecord(uiSession.extensionContext.player)) {
                    if (this.updateInternalHandle) {
                        server_namespaceObject.system.clearRun(this.updateInternalHandle);
                        this.updateInternalHandle = undefined;
                    }
                    this.addRecordToStack(uiSession);
                    this.queueInitialDelayAddRecordCheck(uiSession);
                }
            }), NavigationStackBehavior.POLL_INTERVAL_IN_SECONDS * server_namespaceObject.TicksPerSecond);
        }
        loadDynamicProperties(uiSession) {
            const player = uiSession.extensionContext.player;
            const logNavigationInfo = player.getDynamicProperty(logNavigationInfoDynamicPropertyName);
            if (logNavigationInfo) {
                if (typeof logNavigationInfo === "boolean") {
                    this.logNavigationInfo = logNavigationInfo;
                } else {
                    server_editor_namespaceObject.editor.log.warning(`LogNavigationInfo dynamic property type expected to be 'boolean' for NavigationStack extension, instead found '${typeof logNavigationInfo}'`);
                }
            }
        }
        logStack() {
            if (!this.logNavigationInfo) {
                return;
            }
            const logProperties = {
                tags: [ "Editor", "Navigation" ]
            };
            const headRecord = this.stack.head();
            if (headRecord) {
                this.stack.forEach(((record, index) => {
                    const pos = record.pos;
                    const rot = record.rot;
                    const dimensionID = record.dimension.id;
                    const headIndicator = record === headRecord ? "*" : "";
                    server_editor_namespaceObject.editor.log.info(`${index}: pos [${lib.Vector3Utils.toString(pos)}], rot [${lib.Vector2Utils.toString(rot)}], dim [${dimensionID}] ${headIndicator}`, logProperties);
                }));
            } else {
                server_editor_namespaceObject.editor.log.info("Navigation: stack is empty", logProperties);
            }
        }
    }
    NavigationStackBehavior.BEHAVIOR_NAME = "Navigation Stack";
    NavigationStackBehavior.MAX_STACK_SIZE = 50;
    NavigationStackBehavior.POLL_INTERVAL_IN_SECONDS = .5;
    NavigationStackBehavior.AUTO_ADD_INTERVAL_IN_SECONDS = 5;
    NavigationStackBehavior.AUTO_ADD_MIN_DISTANCE_IN_BLOCKS = 5;
    class PauseBehavior {
        constructor(uiSession) {
            this.uiSession = uiSession;
            this.pauseMobsMenuItem = undefined;
            this.simulationStateChangeHandle = server_editor_namespaceObject.editor.afterEvents.simulationStateChange.subscribe((evt => {
                if (this.pauseMobsMenuItem) {
                    this.pauseMobsMenuItem.checked = evt.paused;
                }
            }));
        }
        createPauseMenu(parentMenu) {
            const alternatePauseMobsAction = this.uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    if (this.pauseMobsMenuItem) {
                        if (server_editor_namespaceObject.editor.simulation.isPaused()) {
                            this.pauseMobsMenuItem.checked = false;
                            server_editor_namespaceObject.editor.simulation.setPaused(false);
                        } else {
                            this.pauseMobsMenuItem.checked = true;
                            server_editor_namespaceObject.editor.simulation.setPaused(true);
                        }
                    }
                }
            });
            this.pauseMobsMenuItem = parentMenu.addItem({
                label: "resourcePack.editor.menuBar.worldOptions.pause",
                checked: server_editor_namespaceObject.editor.simulation.isPaused(),
                tooltip: "resourcePack.editor.menuBar.worldOptions.pause.tooltip"
            }, alternatePauseMobsAction);
        }
        teardown() {
            if (this.simulationStateChangeHandle) {
                server_editor_namespaceObject.editor.afterEvents.simulationStateChange.unsubscribe(this.simulationStateChangeHandle);
            }
        }
    }
    class PlayerCountBehavior {
        constructor(uiSession) {
            const statusBarItem = uiSession.statusBar.createItem({
                alignment: server_editor_namespaceObject.StatusBarAlignment.Right,
                icon: "playersIcon"
            });
            uiSession.eventSubscriptionCache.subscribeToBedrockEvent("playerJoin", (() => this.updateStatusBarText(statusBarItem, server_namespaceObject.world.getAllPlayers().length + 1)));
            uiSession.eventSubscriptionCache.subscribeToBedrockEvent("playerLeave", (() => this.updateStatusBarText(statusBarItem, server_namespaceObject.world.getAllPlayers().length)));
            this.updateStatusBarText(statusBarItem, server_namespaceObject.world.getAllPlayers().length);
        }
        updateStatusBarText(statusBarItem, playerCount) {
            statusBarItem.setText({
                id: "resourcePack.editor.statusBar.connectedPlayers",
                props: [ `${playerCount}` ]
            });
        }
        teardown() {}
    }
    function formatAsTimeString(hours, minutes) {
        return hours.toString().padStart(2, "0") + ":" + minutes.toString().padStart(2, "0");
    }
    const Playtest_mcHoursPerTick = 1e3;
    const Playtest_mcMinsPerTick = 16.6667;
    const CUSTOM_TOD = -2;
    const Playtest_validGameModes = [ {
        val: server_namespaceObject.GameMode.Survival,
        label: "resourcePack.editor.exportProject.gameMode.survival"
    }, {
        val: server_namespaceObject.GameMode.Creative,
        label: "resourcePack.editor.exportProject.gameMode.creative"
    }, {
        val: server_namespaceObject.GameMode.Adventure,
        label: "resourcePack.editor.exportProject.gameMode.adventure"
    } ];
    const validDifficulties = [ {
        val: server_namespaceObject.Difficulty.Peaceful,
        label: "resourcePack.editor.exportProject.difficulty.peaceful"
    }, {
        val: server_namespaceObject.Difficulty.Easy,
        label: "resourcePack.editor.exportProject.difficulty.easy"
    }, {
        val: server_namespaceObject.Difficulty.Normal,
        label: "resourcePack.editor.exportProject.difficulty.normal"
    }, {
        val: server_namespaceObject.Difficulty.Hard,
        label: "resourcePack.editor.exportProject.difficulty.hard"
    } ];
    const Playtest_validDaylightCycle = [ {
        val: server_editor_namespaceObject.DaylightCycle.Normal,
        label: "resourcePack.editor.exportProject.cheatsSettings.daylightCycle.normal"
    }, {
        val: server_editor_namespaceObject.DaylightCycle.AlwaysDay,
        label: "resourcePack.editor.exportProject.cheatsSettings.daylightCycle.alwaysDay"
    }, {
        val: server_editor_namespaceObject.DaylightCycle.LockTime,
        label: "resourcePack.editor.exportProject.cheatsSettings.daylightCycle.lockTime"
    } ];
    const validWeather = [ {
        val: server_namespaceObject.WeatherType.Clear,
        label: "resourcePack.editor.exportProject.weather.clear"
    }, {
        val: server_namespaceObject.WeatherType.Rain,
        label: "resourcePack.editor.exportProject.weather.rain"
    }, {
        val: server_namespaceObject.WeatherType.Thunder,
        label: "resourcePack.editor.exportProject.weather.thunder"
    } ];
    const validTimes = [ {
        label: "resourcePack.editor.timeOfDay.currentTime",
        time: -1
    }, {
        label: "resourcePack.editor.timeOfDay.dropDown.day",
        time: server_namespaceObject.TimeOfDay.Day
    }, {
        label: "resourcePack.editor.timeOfDay.dropDown.noon",
        time: server_namespaceObject.TimeOfDay.Noon
    }, {
        label: "resourcePack.editor.timeOfDay.dropDown.sunset",
        time: server_namespaceObject.TimeOfDay.Sunset
    }, {
        label: "resourcePack.editor.timeOfDay.dropDown.night",
        time: server_namespaceObject.TimeOfDay.Night
    }, {
        label: "resourcePack.editor.timeOfDay.dropDown.midnight",
        time: server_namespaceObject.TimeOfDay.Midnight
    }, {
        label: "resourcePack.editor.timeOfDay.dropDown.sunrise",
        time: server_namespaceObject.TimeOfDay.Sunrise
    }, {
        label: "resourcePack.editor.timeOfDay.dropDown.custom",
        time: CUSTOM_TOD
    } ];
    const paneDataDynamicPropertyName = "playtest:paneData";
    class PlaytestBehavior {
        constructor(uiSession) {
            this._lastPlayTestAvailability = false;
            this._playTestData = this.loadPlayTestDynamicProperties(uiSession);
            this._extensionMenuItem = this.addMenuItem(uiSession);
            this._propertyPane = this.buildPropertyPane(uiSession);
            this.registerActionBarItem(uiSession);
            this._tickRunId = server_namespaceObject.system.runInterval((() => {
                const readyCondition = uiSession.extensionContext.playtest.getPlaytestSessionAvailability();
                const isReady = readyCondition === server_editor_namespaceObject.PlaytestSessionResult.OK;
                if (this._lastPlayTestAvailability !== isReady) {
                    if (this._testButton) {
                        this._testButton.enable = isReady;
                    }
                    this._lastPlayTestAvailability = isReady;
                }
            }), server_namespaceObject.TicksPerSecond / 4);
        }
        addMenuItem(uiSession) {
            const coreMenuItems = uiSession.scratchStorage?.coreMenuItems;
            const playtestMenuItem = coreMenuItems?.file.addItem({
                label: "resourcePack.editor.playtest.Menu.Title",
                tooltip: "resourcePack.editor.playtest.Dialog.tooltip"
            }, uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this._propertyPane?.show();
                }
            }));
            return playtestMenuItem;
        }
        registerActionBarItem(uiSession) {
            const showPlaytestAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this._propertyPane?.show();
                }
            });
            uiSession.actionBar.registerItem(server_editor_namespaceObject.CoreActionBarItemType.Playtest, showPlaytestAction, {
                label: "resourcePack.editor.playtest.Menu.Title",
                icon: "pack://textures/editor/Play.png",
                tooltipTitle: "resourcePack.editor.playtest.Menu.Title",
                tooltipDescription: "resourcePack.editor.playtest.Dialog.tooltip",
                enabled: true,
                executeOnAdd: true
            });
        }
        buildPropertyPane(uiSession) {
            const propertyPane = uiSession.createPropertyPane({
                title: "resourcePack.editor.playtest.Dialog.Title",
                uniqueId: "editor:pane:playtest",
                infoTooltip: {
                    description: [ "resourcePack.editor.playtest.Dialog.tooltip", {
                        link: "https://aka.ms/BedrockEditorTestSettings",
                        text: "resourcePack.editor.help.learnMore"
                    } ]
                }
            });
            const player = uiSession.extensionContext.player;
            const gameTypeItems = Playtest_validGameModes.map(((v, i) => {
                const item = {
                    label: v.label,
                    value: i
                };
                return item;
            }));
            propertyPane.addDropdown(this._playTestData.gameMode, {
                title: "resourcePack.editor.playtest.Dialog.GameMode",
                tooltip: "resourcePack.editor.playtest.Dialog.GameMode.tooltip",
                entries: gameTypeItems,
                onChange: () => {
                    this.savePlayTestDynamicProperties(player);
                }
            });
            const difficultyItems = validDifficulties.map(((v, i) => {
                const item = {
                    label: v.label,
                    value: i
                };
                return item;
            }));
            propertyPane.addDropdown(this._playTestData.difficulty, {
                title: "resourcePack.editor.playtest.Dialog.Difficulty",
                tooltip: "resourcePack.editor.playtest.Dialog.Difficulty.tooltip",
                entries: difficultyItems,
                onChange: () => {
                    this.savePlayTestDynamicProperties(player);
                }
            });
            propertyPane.addBool(this._playTestData.overrideSpawn, {
                title: "resourcePack.editor.playtest.Dialog.OverrideSpawn",
                tooltip: "resourcePack.editor.playtest.Dialog.OverrideSpawn.tooltip",
                onChange: () => {
                    this.savePlayTestDynamicProperties(player);
                }
            });
            const advancedPane = propertyPane.createSubPane({
                title: "resourcePack.editor.playtest.AdvancedSettings.title",
                infoTooltip: {
                    title: "resourcePack.editor.playtest.AdvancedSettings.title",
                    description: [ "resourcePack.editor.playtest.AdvancedSettings.tooltip" ]
                }
            });
            advancedPane.collapse();
            const daylightCycleItems = Playtest_validDaylightCycle.map(((v, i) => {
                const item = {
                    label: v.label,
                    value: i
                };
                return item;
            }));
            advancedPane.addDropdown(this._playTestData.daylightCycle, {
                title: "resourcePack.editor.playtest.Dialog.DaylightCycle",
                tooltip: "resourcePack.editor.playtest.Dialog.DaylightCycle.tooltip",
                entries: daylightCycleItems,
                onChange: () => {
                    this.savePlayTestDynamicProperties(player);
                }
            });
            const customTime = advancedPane.addString(this._playTestData.time, {
                title: "resourcePack.editor.timeOfDay.customTime",
                tooltip: "resourcePack.editor.timeOfDay.customTime.tooltip",
                enable: this._playTestData.timeOfDay.value === 7,
                onChange: (newValue, oldValue) => {
                    this.savePlayTestDynamicProperties(player);
                    if (!this._playTestData) {
                        return;
                    }
                    if (oldValue === newValue) {
                        return;
                    }
                    this._playTestData.time.set(this.parseTimeValue(newValue.toString()));
                }
            });
            const timeItems = validTimes.map(((v, i) => {
                const item = {
                    label: v.label,
                    value: i
                };
                return item;
            }));
            advancedPane.addDropdown(this._playTestData.timeOfDay, {
                title: "resourcePack.editor.playtest.Dialog.TimeOfDay",
                tooltip: "resourcePack.editor.playtest.Dialog.TimeOfDay.tooltip",
                entries: timeItems,
                onChange: newValue => {
                    if (Number.isSafeInteger(newValue)) {
                        const num = validTimes[newValue].time;
                        if (num === CUSTOM_TOD) {
                            customTime.enable = true;
                        } else if (num >= 0) {
                            this._playTestData.time.set(this.getTimeStringFromTime(num));
                            customTime.enable = false;
                        }
                    }
                    this.savePlayTestDynamicProperties(player);
                }
            });
            advancedPane.addBool(this._playTestData.weatherCycle, {
                title: "resourcePack.editor.playtest.Dialog.WeatherCycle",
                tooltip: "resourcePack.editor.playtest.Dialog.WeatherCycle.tooltip",
                onChange: () => {
                    this.savePlayTestDynamicProperties(player);
                }
            });
            const weatherItems = validWeather.map(((v, i) => {
                const item = {
                    label: v.label,
                    value: i
                };
                return item;
            }));
            advancedPane.addDropdown(this._playTestData.weather, {
                title: "resourcePack.editor.playtest.Dialog.weather",
                tooltip: "resourcePack.editor.playtest.Dialog.weather.tooltip",
                entries: weatherItems,
                onChange: () => {
                    this.savePlayTestDynamicProperties(player);
                }
            });
            advancedPane.addBool(this._playTestData.showCoordinates, {
                title: "resourcePack.editor.playtest.Dialog.ShowCoordinates",
                tooltip: "resourcePack.editor.playtest.Dialog.ShowCoordinates.tooltip",
                onChange: () => {
                    this.savePlayTestDynamicProperties(player);
                }
            });
            const oneSleepingPlayerMessage = {
                id: "resourcePack.editor.exportProject.advancedSettings.requiredSleepingPlayers.onePlayerMessage"
            };
            const initialTitlePercentMessage = this._playTestData.sleepSkipPercent.value <= 0 ? oneSleepingPlayerMessage.id : this._playTestData.sleepSkipPercent.value >= 101 ? `${100}` + `%%` : `${this._playTestData.sleepSkipPercent.value}` + `%%`;
            const localizedPercentTitle = {
                id: "resourcePack.editor.exportProject.advancedSettings.requiredSleepingPlayers",
                props: [ `${initialTitlePercentMessage}` ]
            };
            advancedPane.addBool(this._playTestData.bedsWork, {
                title: "resourcePack.editor.exportProject.advancedSettings.bedsWork",
                tooltip: "resourcePack.editor.exportProject.advancedSettings.bedsWork.tooltip",
                variant: server_editor_namespaceObject.BoolPropertyItemVariant.Checkbox,
                onChange: newValue => {
                    sleepSkipPercentPropItem.enable = newValue;
                    if (newValue) {
                        this._playTestData.sleepSkipPercent.set(100);
                    } else {
                        const sleepDisabledValue = 101;
                        this._playTestData.sleepSkipPercent.set(sleepDisabledValue);
                        if (localizedPercentTitle.props) {
                            localizedPercentTitle.props = [ `${this._playTestData.sleepSkipPercent.value}%%` ];
                        }
                        sleepSkipPercentPropItem.setTitle(localizedPercentTitle);
                    }
                    this.savePlayTestDynamicProperties(player);
                }
            });
            const sleepSkipPercentProps = {
                title: localizedPercentTitle,
                tooltip: "resourcePack.editor.exportProject.advancedSettings.requiredSleepingPlayers.tooltip",
                min: 0,
                max: 100,
                isInteger: true,
                enable: this._playTestData.bedsWork.value,
                variant: server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider,
                onChange: newValue => {
                    if (localizedPercentTitle.props && newValue > 0) {
                        localizedPercentTitle.props = [ `${newValue}%%` ];
                    } else {
                        localizedPercentTitle.props = [ oneSleepingPlayerMessage.id ];
                    }
                    sleepSkipPercentPropItem.setTitle(localizedPercentTitle);
                    this.savePlayTestDynamicProperties(player);
                }
            };
            const sleepSkipPercentPropItem = advancedPane.addNumber(this._playTestData.sleepSkipPercent, sleepSkipPercentProps);
            const informationSubPane = propertyPane.createSubPane({
                title: "resourcePack.editor.playtest.Dialog.Information",
                infoTooltip: {
                    title: "resourcePack.editor.playtest.Dialog.Information",
                    description: [ "resourcePack.editor.playtest.Dialog.Information.tooltip" ]
                }
            });
            informationSubPane.addText("resourcePack.editor.playtest.Dialog.Information.text");
            this._lastPlayTestAvailability = uiSession.extensionContext.playtest.getPlaytestSessionAvailability() === server_editor_namespaceObject.PlaytestSessionResult.OK;
            this._testButton = propertyPane.addButton(uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: async () => {
                    if (!this._playTestData) {
                        return;
                    }
                    const options = this.getGameOptionsFromPlayTestData(this._playTestData, uiSession);
                    const readyCondition = uiSession.extensionContext.playtest.getPlaytestSessionAvailability();
                    const isReady = readyCondition === server_editor_namespaceObject.PlaytestSessionResult.OK;
                    uiSession.log.debug(`Session status result: ${getEnumKeyByEnumValue(server_editor_namespaceObject.PlaytestSessionResult, readyCondition)}`);
                    if (!isReady) {
                        if (this._testButton) {
                            this._testButton.enable = false;
                        }
                        return;
                    }
                    fireTelemetryEvent(player, TelemetrySource.TestWorld, "TestWorldButton", {
                        settings: options
                    });
                    const result = await uiSession.extensionContext.playtest.beginPlaytest(options);
                    uiSession.log.debug(`Ending Playtest Session with result: ${getEnumKeyByEnumValue(server_editor_namespaceObject.PlaytestSessionResult, result)}`);
                }
            }), {
                title: "resourcePack.editor.playtest.Dialog.TestButton",
                visible: true,
                enable: this._lastPlayTestAvailability
            });
            return propertyPane;
        }
        loadPlayTestDynamicProperties(uiSession) {
            let loadedData;
            const dynamicPaneData = uiSession.extensionContext.player.getDynamicProperty(paneDataDynamicPropertyName);
            if (dynamicPaneData) {
                try {
                    loadedData = JSON.parse(dynamicPaneData);
                } catch (_e) {
                    uiSession.log.warning(`'${dynamicPaneData}' could not be parsed`);
                }
            }
            const defaultPaneData = {
                gameMode: (0, server_editor_namespaceObject.makeObservable)(loadedData?.gameMode ?? 0),
                difficulty: (0, server_editor_namespaceObject.makeObservable)(loadedData?.difficulty ?? 2),
                daylightCycle: (0, server_editor_namespaceObject.makeObservable)(loadedData?.daylightCycle ?? server_editor_namespaceObject.DaylightCycle.Normal),
                respawnRadius: (0, server_editor_namespaceObject.makeObservable)(loadedData?.respawnRadius ?? 10),
                weatherCycle: (0, server_editor_namespaceObject.makeObservable)(loadedData?.weatherCycle ?? true),
                weather: (0, server_editor_namespaceObject.makeObservable)(loadedData?.weather ?? 0),
                showCoordinates: (0, server_editor_namespaceObject.makeObservable)(loadedData?.showCoordinates ?? true),
                timeOfDay: (0, server_editor_namespaceObject.makeObservable)(loadedData?.timeOfDay ?? 0),
                time: (0, server_editor_namespaceObject.makeObservable)(loadedData?.time ?? ""),
                overrideSpawn: (0, server_editor_namespaceObject.makeObservable)(loadedData?.overrideSpawn ?? true),
                bedsWork: (0, server_editor_namespaceObject.makeObservable)(loadedData?.bedsWork ?? true),
                sleepSkipPercent: (0, server_editor_namespaceObject.makeObservable)(loadedData?.sleepSkipPercent ?? 100)
            };
            return defaultPaneData;
        }
        savePlayTestDynamicProperties(player) {
            if (player) {
                const paneData = Object.entries(this._playTestData).reduce(((data, [key, observable]) => {
                    data[key] = observable.value;
                    return data;
                }), {});
                player.setDynamicProperty(paneDataDynamicPropertyName, JSON.stringify(paneData));
            }
        }
        parseTimeValue(timeString) {
            let returnStr = "";
            let time = Number(timeString);
            if (isNaN(time)) {
                if (timeString.indexOf(":") >= 0) {
                    const timeArray = timeString.split(":");
                    if (timeArray.length === 2) {
                        let hours = Number(timeArray[0]);
                        let minutes = Number(timeArray[1]);
                        if (!isNaN(hours) && !isNaN(minutes)) {
                            if (minutes > 59) {
                                minutes = 0;
                                hours += 1;
                            } else {
                                minutes = (0, lib.clampNumber)(minutes, 0, 59);
                            }
                            if (hours > 23) {
                                hours = 23;
                                minutes = 59;
                            } else {
                                hours = (0, lib.clampNumber)(hours, 0, 23);
                            }
                            returnStr = formatAsTimeString(hours.toString(), minutes.toString());
                        }
                    }
                }
            } else {
                time = (0, lib.clampNumber)(time, 0, 23999);
                returnStr = this.getTimeStringFromTime(time);
            }
            return returnStr;
        }
        getTimeFromTimeString(timeOfDay) {
            if (Number.isSafeInteger(timeOfDay)) {
                return Number(timeOfDay);
            } else {
                if (timeOfDay.indexOf(":")) {
                    const timeArray = timeOfDay.split(":");
                    if (timeArray.length === 2) {
                        let hours = Number(timeArray[0]) - 6;
                        if (hours < 0) {
                            hours = 24 - (6 + hours);
                        }
                        let minutes = Number(timeArray[1]);
                        hours = (0, lib.clampNumber)(hours, 0, 23);
                        minutes = (0, lib.clampNumber)(minutes, 0, 59);
                        return hours * Playtest_mcHoursPerTick + minutes * Playtest_mcMinsPerTick;
                    }
                }
            }
            return 0;
        }
        getTimeStringFromTime(timeOfDay) {
            const mcHours = Math.trunc(timeOfDay / Playtest_mcHoursPerTick);
            const mcMinutes = timeOfDay % Playtest_mcHoursPerTick;
            const hours = (mcHours + 6) % 24;
            let minutes = Math.round(mcMinutes / Playtest_mcMinsPerTick);
            minutes = (0, lib.clampNumber)(minutes, 0, 59);
            return formatAsTimeString(hours.toString(), minutes.toString());
        }
        getGameOptionsFromPlayTestData(data, uiSession) {
            const gameMode = Playtest_validGameModes[data.gameMode.value].val;
            const difficulty = validDifficulties[data.difficulty.value].val;
            const timeOfDay = validTimes[data.timeOfDay.value].time;
            const daylightCycle = Playtest_validDaylightCycle[data.daylightCycle.value].val;
            const options = {
                daylightCycle,
                difficulty,
                respawnRadius: data.respawnRadius.value,
                gameMode,
                disableWeather: !data.weatherCycle.value,
                weather: data.weather.value,
                showCoordinates: data.showCoordinates.value,
                bedsWork: data.bedsWork.value,
                sleepSkipPercent: data.sleepSkipPercent.value
            };
            if (timeOfDay === CUSTOM_TOD) {
                options.timeOfDay = this.getTimeFromTimeString(data.time.value);
            } else if (timeOfDay >= 0) {
                options.timeOfDay = timeOfDay;
            } else {
                options.timeOfDay = 0;
            }
            if (data.overrideSpawn) {
                options.spawnPosition = uiSession.extensionContext.player.location;
                options.dimensionId = uiSession.extensionContext.player.dimension.id.replace("minecraft:", "").replace("_", " ");
            }
            return options;
        }
        teardown() {
            if (this._tickRunId) {
                server_namespaceObject.system.clearRun(this._tickRunId);
            }
        }
    }
    const Controls = {
        Up: server_editor_namespaceObject.KeyboardKey.PAGE_UP,
        Down: server_editor_namespaceObject.KeyboardKey.PAGE_DOWN,
        Forward: server_editor_namespaceObject.KeyboardKey.UP,
        Back: server_editor_namespaceObject.KeyboardKey.DOWN,
        Left: server_editor_namespaceObject.KeyboardKey.LEFT,
        Right: server_editor_namespaceObject.KeyboardKey.RIGHT,
        Select: server_editor_namespaceObject.KeyboardKey.ENTER,
        Clear: server_editor_namespaceObject.KeyboardKey.KEY_D
    };
    const SelectionCommonTypes_KEY_REPEAT_DELAY = 5;
    const SelectionCommonTypes_KEY_REPEAT_INTERVAL = 1;
    var SelectionMode;
    (function(SelectionMode) {
        SelectionMode[SelectionMode["Marquee"] = 1] = "Marquee";
        SelectionMode[SelectionMode["Freehand"] = 2] = "Freehand";
        SelectionMode[SelectionMode["MagicSelect"] = 3] = "MagicSelect";
    })(SelectionMode || (SelectionMode = {}));
    var SelectionCommonTypes_QuickActionMode;
    (function(QuickActionMode) {
        QuickActionMode[QuickActionMode["Invalid"] = -1] = "Invalid";
        QuickActionMode[QuickActionMode["DeselectSelection"] = 1] = "DeselectSelection";
        QuickActionMode[QuickActionMode["FillSelection"] = 2] = "FillSelection";
        QuickActionMode[QuickActionMode["DeleteSelection"] = 3] = "DeleteSelection";
    })(SelectionCommonTypes_QuickActionMode || (SelectionCommonTypes_QuickActionMode = {}));
    var TrimActionMode;
    (function(TrimActionMode) {
        TrimActionMode[TrimActionMode["Invalid"] = -1] = "Invalid";
        TrimActionMode[TrimActionMode["TrimVolume"] = 1] = "TrimVolume";
        TrimActionMode[TrimActionMode["RemoveAir"] = 2] = "RemoveAir";
        TrimActionMode[TrimActionMode["ShrinkWrap"] = 3] = "ShrinkWrap";
        TrimActionMode[TrimActionMode["Hollow"] = 4] = "Hollow";
    })(TrimActionMode || (TrimActionMode = {}));
    var SelectionTelemetry;
    (function(SelectionTelemetry) {
        SelectionTelemetry["QuickAction"] = "QuickAction";
        SelectionTelemetry["FillSelection"] = "FillSelection";
        SelectionTelemetry["DeleteSelection"] = "DeleteSelection";
        SelectionTelemetry["FreehandSelectionBegin"] = "FreehandSelectionBegin";
        SelectionTelemetry["FreehandSelectionComplete"] = "FreehandSelectionComplete";
        SelectionTelemetry["SelectionCreated"] = "SelectionCreated";
        SelectionTelemetry["SelectionExpanded"] = "SelectionExpanded";
        SelectionTelemetry["SelectionMoveTop"] = "SelectionMoveTop";
        SelectionTelemetry["SelectionShrink"] = "SelectionShrink";
        SelectionTelemetry["SelectionGrow"] = "SelectionGrow";
        SelectionTelemetry["ModeChanged"] = "ModeChanged";
        SelectionTelemetry["Deselect"] = "Deselect";
        SelectionTelemetry["TrimVolume"] = "TrimVolume";
        SelectionTelemetry["RemoveAir"] = "RemoveAir";
        SelectionTelemetry["MagicSelect"] = "MagicSelect";
        SelectionTelemetry["HollowVolume"] = "HollowVolume";
    })(SelectionTelemetry || (SelectionTelemetry = {}));
    function deepCopy(obj) {
        const serializedObject = (0, server_editor_namespaceObject.serialize)(obj);
        const objectCopy = (0, server_editor_namespaceObject.deserialize)(serializedObject);
        return objectCopy;
    }
    function createRGBAColorFromInts(r, g, b, a) {
        const red = Math.min(255, Math.max(0, r)) / 255;
        const green = Math.min(255, Math.max(0, g)) / 255;
        const blue = Math.min(255, Math.max(0, b)) / 255;
        const alpha = Math.min(255, Math.max(0, a)) / 255;
        return {
            blue,
            green,
            red,
            alpha
        };
    }
    function limitVolumeSize(volume, prospectiveTo, maxVolumeSize) {
        const newVolume = new server_namespaceObject.BlockVolume(volume.from, prospectiveTo);
        const newSpan = newVolume.getSpan();
        const deltaSizeX = newSpan.x - maxVolumeSize.x;
        const deltaSizeY = newSpan.y - maxVolumeSize.y;
        const deltaSizeZ = newSpan.z - maxVolumeSize.z;
        const oldSpan = volume.getSpan();
        const dirX = newSpan.x > oldSpan.x ? 1 : -1;
        const dirY = newSpan.y > oldSpan.y ? 1 : -1;
        const dirZ = newSpan.z > oldSpan.z ? 1 : -1;
        let newX = newVolume.to.x;
        let newY = newVolume.to.y;
        let newZ = newVolume.to.z;
        if (deltaSizeX > 0) {
            newX -= dirX * deltaSizeX;
        }
        if (deltaSizeY > 0) {
            newY -= dirY * deltaSizeY;
        }
        if (deltaSizeZ > 0) {
            newZ -= dirZ * deltaSizeZ;
        }
        return new server_namespaceObject.BlockVolume(volume.from, {
            x: newX,
            y: newY,
            z: newZ
        });
    }
    var MarqueeSelectionVolumeState;
    (function(MarqueeSelectionVolumeState) {
        MarqueeSelectionVolumeState[MarqueeSelectionVolumeState["Idle"] = 0] = "Idle";
        MarqueeSelectionVolumeState[MarqueeSelectionVolumeState["Dragging"] = 1] = "Dragging";
        MarqueeSelectionVolumeState[MarqueeSelectionVolumeState["Done"] = 2] = "Done";
    })(MarqueeSelectionVolumeState || (MarqueeSelectionVolumeState = {}));
    class MarqueeSelectionVolume {
        get parent() {
            return this._modeImpl.parent;
        }
        constructor(_modeImpl, _worldVolume, onChanged) {
            this._state = MarqueeSelectionVolumeState.Idle;
            this._onChanged = () => {};
            this._modeImpl = _modeImpl;
            this._worldVolume = _worldVolume;
            this._onChanged = onChanged || this._onChanged;
            this._widget = this._modeImpl.parent.widgetGroup.createWidget(_worldVolume.from, {
                snapToBlockLocation: true,
                visible: true,
                selectable: false
            });
            this._widget.addGizmoComponent("originHandle", {
                axes: server_editor_namespaceObject.Axis.X | server_editor_namespaceObject.Axis.Y | server_editor_namespaceObject.Axis.Z,
                visible: true,
                normalizedAutoOffset: {
                    x: 0,
                    y: 0,
                    z: 0
                },
                stateChangeEvent: evt => {
                    if (evt.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginActivated || evt.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginDeactivated) {
                        this.parent.debugLog(`Origin gizmo ${evt.eventType}`);
                        return;
                    }
                    if (evt.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginGrabbed) {
                        this.parent.debugLog(`Origin gizmo grabbed - opening transaction`);
                        this.parent.beginTransactionableOperation("Marquee Volume Move");
                        return;
                    }
                    try {
                        const prevBounds = this._worldVolume.getBoundingBox();
                        const newTransformedVolume = this._widgetBoxComponent.transformedWorldVolume;
                        const newBounds = newTransformedVolume.getBoundingBox();
                        this.parent.debugLog(`Transformed Volume: ${lib.Vector3Utils.toString(newBounds.min)} -> ${lib.Vector3Utils.toString(newBounds.max)}`);
                        if (evt.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginMoved) {
                            if (!server_namespaceObject.BlockBoundingBoxUtils.equals(prevBounds, newBounds)) {
                                const maxSelectionSize = server_editor_namespaceObject.editor.constants.maxSelectionSize;
                                const span = lib.Vector3Utils.clamp(newTransformedVolume.getSpan(), {
                                    min: {
                                        x: 1,
                                        y: 1,
                                        z: 1
                                    },
                                    max: maxSelectionSize
                                });
                                this._modeImpl.volumeOrigin = newTransformedVolume.from;
                                this._modeImpl.volumeSize = span;
                            }
                        }
                        if (evt.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginReleased) {
                            if (!server_namespaceObject.BlockBoundingBoxUtils.equals(prevBounds, newBounds)) {
                                const maxSelectionSize = server_editor_namespaceObject.editor.constants.maxSelectionSize;
                                const span = lib.Vector3Utils.clamp(newTransformedVolume.getSpan(), {
                                    min: {
                                        x: 1,
                                        y: 1,
                                        z: 1
                                    },
                                    max: maxSelectionSize
                                });
                                this._worldVolume.from = newTransformedVolume.from;
                                this._worldVolume.to = lib.Vector3Utils.add(newTransformedVolume.from, lib.Vector3Utils.subtract(span, lib.VECTOR3_ONE));
                                this.parent.endTransactionableOperation();
                                this._onChanged(this);
                            } else {
                                this.parent.debugLog(`Origin gizmo release with no changes - just ignoring: ${evt.eventType}`);
                                this.parent.cancelTransactionableOperation();
                            }
                        } else {
                            this.parent.debugLog(`Unhandled gizmo event: ${evt.eventType ?? "undefined"}`);
                        }
                    } catch {}
                }
            });
            const volumeSize = _worldVolume.getSpan();
            const boundsColors = _modeImpl.parent.boundingBoxColor;
            this._widgetBoxComponent = this._widget.addBoundingBox("bbox", volumeSize, {
                visible: true,
                boundsOffset: lib.VECTOR3_ZERO,
                showWorldIntersections: true,
                enableResizeHandles: server_editor_namespaceObject.Axis.X | server_editor_namespaceObject.Axis.Y | server_editor_namespaceObject.Axis.Z,
                hullColor: boundsColors.hull,
                outlineColor: boundsColors.outline,
                minSize: {
                    x: 1,
                    y: 1,
                    z: 1
                },
                maxSize: server_editor_namespaceObject.editor.constants.maxSelectionSize,
                stateChangeEvent: evt => {
                    if (evt.eventType === server_editor_namespaceObject.WidgetGizmoEventType.CornerGrabbed) {
                        this.parent.beginTransactionableOperation("Marquee Volume Resize");
                        return;
                    }
                    try {
                        const prevBounds = this._worldVolume.getBoundingBox();
                        const newTransformedVolume = evt.component.transformedWorldVolume;
                        const newBounds = newTransformedVolume.getBoundingBox();
                        if (evt.eventType === server_editor_namespaceObject.WidgetGizmoEventType.CornerMoved) {
                            if (!server_namespaceObject.BlockBoundingBoxUtils.equals(prevBounds, newBounds)) {
                                const maxSelectionSize = server_editor_namespaceObject.editor.constants.maxSelectionSize;
                                const span = lib.Vector3Utils.clamp(newTransformedVolume.getSpan(), {
                                    min: {
                                        x: 1,
                                        y: 1,
                                        z: 1
                                    },
                                    max: maxSelectionSize
                                });
                                this._modeImpl.volumeOrigin = newTransformedVolume.from;
                                this._modeImpl.volumeSize = span;
                            }
                        }
                        if (evt.eventType === server_editor_namespaceObject.WidgetGizmoEventType.CornerReleased) {
                            if (!server_namespaceObject.BlockBoundingBoxUtils.equals(prevBounds, newBounds)) {
                                const maxSelectionSize = server_editor_namespaceObject.editor.constants.maxSelectionSize;
                                const span = lib.Vector3Utils.clamp(newTransformedVolume.getSpan(), {
                                    min: {
                                        x: 1,
                                        y: 1,
                                        z: 1
                                    },
                                    max: maxSelectionSize
                                });
                                this._worldVolume.from = newTransformedVolume.from;
                                this._worldVolume.to = lib.Vector3Utils.add(newTransformedVolume.from, lib.Vector3Utils.subtract(span, lib.VECTOR3_ONE));
                                this.parent.endTransactionableOperation();
                                this._onChanged(this);
                            } else {
                                this.parent.debugLog(`Corner gizmo release with no changes - just ignoring: ${evt.eventType}`);
                                this.parent.cancelTransactionableOperation();
                            }
                        } else {
                            this._modeImpl.debugLog(`Unhandled gizmo event: ${evt.eventType ?? "undefined"}`);
                        }
                    } catch {}
                }
            });
        }
        teardown() {
            this._widgetBoxComponent.delete();
            this._widget.delete();
        }
        get visible() {
            return this._widget.visible;
        }
        set visible(value) {
            this._widget.visible = value;
        }
        get blockVolume() {
            return this._worldVolume;
        }
        get from() {
            return this._worldVolume.from;
        }
        set from(value) {
            this._worldVolume.from = value;
            this._widget.location = value;
            this._widgetBoxComponent.boundsOffset = lib.VECTOR3_ZERO;
            this._widgetBoxComponent.offset = lib.VECTOR3_ZERO;
            this._modeImpl.volumeOrigin = value;
        }
        get to() {
            return this._worldVolume.to;
        }
        set to(value) {
            if (!this.parent.session.extensionContext.blockUtilities.isLocationInsideCurrentDimensionBounds(value)) {
                this.parent.debugLog(`Invalid 'to' location for widget ${lib.Vector3Utils.toString(value)}`);
                return;
            }
            this._worldVolume.to = value;
            let bounds;
            try {
                bounds = this._worldVolume.getBoundingBox();
            } catch (_e) {
                this.parent.debugLog("Failed to get bounding box from volume");
                return;
            }
            this._widget.location = bounds.min;
            this._widgetBoxComponent.size = server_namespaceObject.BlockBoundingBoxUtils.getSpan(bounds);
            this._widgetBoxComponent.boundsOffset = lib.VECTOR3_ZERO;
            this._modeImpl.volumeOrigin = bounds.min;
            this._modeImpl.volumeSize = this._widgetBoxComponent.size;
        }
        set at(value) {
            if (!this.parent.session.extensionContext.blockUtilities.isLocationInsideCurrentDimensionBounds(value)) {
                this.parent.debugLog(`Invalid 'at' location for widget ${lib.Vector3Utils.toString(value)}`);
                return;
            }
            const diff = lib.Vector3Utils.subtract(value, this.from);
            this.from = value;
            this.to = lib.Vector3Utils.add(this.to, diff);
        }
        set span(value) {
            const span = {
                x: Math.max(1, value.x),
                y: Math.max(1, value.y),
                z: Math.max(1, value.z)
            };
            const size = {
                x: span.x - 1,
                y: span.y - 1,
                z: span.z - 1
            };
            const newTo = {
                x: this.from.x + size.x,
                y: this.from.y + size.y,
                z: this.from.z + size.z
            };
            this.to = newTo;
        }
        setFromBounds(value) {
            if (!server_namespaceObject.BlockBoundingBoxUtils.isValid(value)) {
                throw new Error(`Invalid bounds: ${JSON.stringify(value)}`);
            }
            const min = {
                x: value.min.x < value.max.x ? value.min.x : value.max.x,
                y: value.min.y < value.max.y ? value.min.y : value.max.y,
                z: value.min.z < value.max.z ? value.min.z : value.max.z
            };
            const max = {
                x: value.min.x > value.max.x ? value.min.x : value.max.x,
                y: value.min.y > value.max.y ? value.min.y : value.max.y,
                z: value.min.z > value.max.z ? value.min.z : value.max.z
            };
            this.from = min;
            this.to = max;
        }
        deactivateHandles() {
            this._widgetBoxComponent.deactivateHandles();
        }
        get state() {
            return this._state;
        }
        set state(value) {
            this._state = value;
        }
        get isDragging() {
            return this._state === MarqueeSelectionVolumeState.Dragging;
        }
        get isIdle() {
            return this._state === MarqueeSelectionVolumeState.Idle;
        }
        get isDone() {
            return this._state === MarqueeSelectionVolumeState.Done;
        }
        onColorChangeEvent(_outline, _hull) {
            this._widgetBoxComponent.hullColor = _hull;
            this._widgetBoxComponent.outlineColor = _outline;
        }
    }
    class SelectionModeMarquee {
        constructor(_parentPane, _parent) {
            this._volumeStack = [];
            this._translationKeyRepeatRefCount = 0;
            this._resizeKeyRepeatRefCount = 0;
            this._resizeShrink = false;
            this._parentPane = _parentPane;
            this._parent = _parent;
            this._modePane = this._parentPane.createSubPane({
                title: "resourcePack.editor.selectionTool.marquee.title",
                infoTooltip: {
                    title: "resourcePack.editor.selectionTool.marquee.title",
                    description: [ "resourcePack.editor.selectionTool.marqueePane.tooltip" ]
                },
                hasMargins: false
            });
            this._origin = (0, server_editor_namespaceObject.makeObservable)({
                x: 0,
                y: 0,
                z: 0
            });
            this._size = (0, server_editor_namespaceObject.makeObservable)({
                x: 1,
                y: 1,
                z: 1
            });
            const subPaneTransform = this._modePane.createSubPane({
                title: "resourcePack.editor.selectionTool.transformPane.title",
                infoTooltip: {
                    title: "resourcePack.editor.selectionTool.transformPane.title",
                    description: [ "resourcePack.editor.selectionTool.transformPane.tooltip" ]
                }
            });
            this._transformVec3UIComponent = subPaneTransform.addVector3(this._origin, {
                title: "resourcePack.editor.selectionTool.transformPane.origin",
                tooltip: "resourcePack.editor.selectionTool.transformPane.origin.tooltip",
                min: {
                    x: -3e5,
                    y: this.parent.session.extensionContext.player.dimension.heightRange.min,
                    z: -3e5
                },
                max: {
                    x: 3e5,
                    y: this.parent.session.extensionContext.player.dimension.heightRange.max,
                    z: 3e5
                },
                onChange: (newValue, oldValue) => {
                    this.parent.performSingleTransactionableOperation((() => {
                        const volume = this._currentVolume();
                        if (volume) {
                            volume.at = this._origin.value;
                        }
                        this.applyVolumeStackToSelectionManager();
                        const direction = lib.Vector3Utils.subtract(newValue, oldValue);
                        this.parent.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionMoveTop, {
                            direction
                        });
                        return true;
                    }), "Marquee Manual Origin change");
                }
            });
            this._sizeVec3UIComponent = subPaneTransform.addVector3(this._size, {
                title: "resourcePack.editor.selectionTool.transformPane.size",
                tooltip: "resourcePack.editor.selectionTool.transformPane.size.tooltip",
                min: {
                    x: 1,
                    y: 1,
                    z: 1
                },
                max: server_editor_namespaceObject.editor.constants.maxSelectionSize,
                onChange: (newValue, oldValue) => {
                    this.parent.performSingleTransactionableOperation((() => {
                        const volume = this._currentVolume();
                        if (volume) {
                            volume.span = this._size.value;
                        }
                        this.applyVolumeStackToSelectionManager();
                        return true;
                    }), "Marquee Manual Size change");
                    const direction = lib.Vector3Utils.subtract(newValue, oldValue);
                    const grow = direction.x > 0 || direction.y > 0 || direction.z > 0;
                    this.parent.telemetryManager.fireTelemetryEvent(grow ? SelectionTelemetry.SelectionGrow : SelectionTelemetry.SelectionShrink, {
                        direction
                    });
                }
            });
        }
        get parentPane() {
            return this._parentPane;
        }
        get modePane() {
            return this._modePane;
        }
        get parent() {
            return this._parent;
        }
        get session() {
            return this._parent.session;
        }
        set volumeOrigin(value) {
            this._origin.set(value);
        }
        set volumeSize(value) {
            this._size.set(value);
        }
        get modeType() {
            return SelectionMode.Marquee;
        }
        debugLog(message) {
            this.parent.debugLog(message);
        }
        teardown() {
            this._volumeStack.forEach((volume => {
                volume.teardown();
            }));
        }
        activate(_toolActive) {
            if (_toolActive) {
                this._modePane.show();
            }
            this._showVolumes();
        }
        deactivate(_toolActive, _switchingModes) {
            if (_toolActive) {
                this._modePane.hide();
            }
            this._volumeStack.forEach((volume => {
                volume.deactivateHandles();
            }));
            if (_switchingModes) {
                this.parent.performSingleTransactionableOperation((() => {
                    this._clearVolumeStack();
                    return true;
                }), "Deactivate Marquee");
            }
        }
        clearSelection() {
            this.parent.performSingleTransactionableOperation((() => {
                this.session.extensionContext.selectionManager.volume.clear();
                this._clearVolumeStack();
                return true;
            }), "Clear Selection");
            this.volumeOrigin = lib.VECTOR3_ZERO;
            this.volumeSize = {
                x: 1,
                y: 1,
                z: 1
            };
        }
        onMouseClickAndDrag(_mouseRay, _mouseProps, _oneShot = false) {
            if (_mouseProps.mouseAction === server_editor_namespaceObject.MouseActionType.LeftButton) {
                if (_mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonDown) {
                    if (_mouseRay.rayHit) {
                        this.parent.beginTransactionableOperation("Marquee Volume Creation");
                        if (this._volumeStack.length !== 0 && _mouseProps.modifiers.shift) {
                            const volume = this._currentVolume();
                            if (volume) {
                                this._tryAssignVolumeTo(volume, _mouseRay.cursorBlockLocation);
                                volume.state = MarqueeSelectionVolumeState.Idle;
                                this.debugLog(`SHIFT+Click - Marquee Volume to ${lib.Vector3Utils.toString(volume.to)}`);
                            } else {
                                this.parent.cancelTransactionableOperation();
                                throw new Error("Failed to fetch current volume");
                            }
                        } else {
                            if (!_mouseProps.modifiers.ctrl) {
                                this.debugLog(`Clearing Marquee Stack - no CTRL`);
                                this._clearVolumeStack();
                            } else {
                                this.debugLog(`CTRL pressed - creating new Marquee item on stack`);
                            }
                            const blockVolume = new server_namespaceObject.BlockVolume(_mouseRay.cursorBlockLocation, _mouseRay.cursorBlockLocation);
                            const newVolume = this._createVolume(blockVolume, true);
                            newVolume.state = MarqueeSelectionVolumeState.Idle;
                            this.debugLog(`Clicked at ${lib.Vector3Utils.toString(_mouseRay.cursorBlockLocation)}`);
                        }
                    } else {}
                } else if (_mouseProps.inputType === server_editor_namespaceObject.MouseInputType.DragStart || _mouseProps.inputType === server_editor_namespaceObject.MouseInputType.Drag) {
                    if (_mouseRay.rayHit) {
                        const volume = this._currentVolume();
                        if (volume) {
                            volume.state = MarqueeSelectionVolumeState.Dragging;
                            const maxSelectionSize = server_editor_namespaceObject.editor.constants.maxSelectionSize;
                            const newVolume = limitVolumeSize(volume.blockVolume, _mouseRay.cursorBlockLocation, maxSelectionSize);
                            this.debugLog(`Marquee drag ${lib.Vector3Utils.toString(newVolume.from)} -> ${lib.Vector3Utils.toString(newVolume.to)} (${lib.Vector3Utils.toString(newVolume.getSpan())})`);
                            this._tryAssignVolumeTo(volume, newVolume.to);
                        } else {
                            this.parent.cancelTransactionableOperation();
                            throw new Error("Failed to fetch current volume");
                        }
                    }
                } else if (_mouseProps.inputType === server_editor_namespaceObject.MouseInputType.DragEnd || _mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonUp) {
                    if (_mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonUp) {
                        this.debugLog(`Mouse button released`);
                    } else if (_mouseProps.inputType === server_editor_namespaceObject.MouseInputType.DragEnd) {
                        this.debugLog(`Mouse drag ended`);
                    }
                    if (!this.parent.isTransactionOperationActive()) {
                        return;
                    }
                    const volume = this._currentVolume();
                    if (volume) {
                        if (volume.isDragging || volume.isIdle) {
                            const maxSelectionSize = server_editor_namespaceObject.editor.constants.maxSelectionSize;
                            const newVolume = limitVolumeSize(volume.blockVolume, _mouseRay.cursorBlockLocation, maxSelectionSize);
                            this.debugLog(`Marquee drag END ${lib.Vector3Utils.toString(newVolume.from)} -> ${lib.Vector3Utils.toString(newVolume.to)} (${lib.Vector3Utils.toString(newVolume.getSpan())})`);
                            try {
                                const bounds = newVolume.getBoundingBox();
                                volume.from = bounds.min;
                                volume.span = newVolume.getSpan();
                            } catch {
                                this._popVolume();
                            }
                            volume.state = MarqueeSelectionVolumeState.Done;
                            this.applyVolumeStackToSelectionManager();
                            this.parent.endTransactionableOperation();
                        } else {
                            this.debugLog(`Marquee drag operation ended and volume is done already!`);
                        }
                    } else {
                        this.parent.cancelTransactionableOperation();
                    }
                }
            }
        }
        _tryAssignVolumeTo(volume, toLocation) {
            try {
                volume.to = toLocation;
            } catch (_e) {
                if (_e instanceof Error) {
                    this.session.log.error(`${_e.message}`, {
                        channelMask: server_editor_namespaceObject.LogChannel.All
                    });
                }
                this.parent.cancelTransactionableOperation();
            }
        }
        _showVolumes() {
            this._volumeStack.forEach((volume => {
                volume.visible = true;
            }));
        }
        _hideVolumes() {
            this._volumeStack.forEach((volume => {
                volume.visible = false;
            }));
        }
        applyVolumeStackToSelectionManager() {
            const newVolume = new server_editor_namespaceObject.RelativeVolumeListBlockVolume;
            this._volumeStack.forEach((volume => {
                newVolume.add(volume.blockVolume);
            }));
            this.session.extensionContext.selectionManager.volume.set(newVolume);
        }
        _clearSelectionManager() {
            this.session.extensionContext.selectionManager.volume.clear();
        }
        _clearVolumeStack() {
            this._volumeStack.forEach((volume => {
                volume.teardown();
            }));
            this._volumeStack = [];
            this._clearSelectionManager();
            this.volumeOrigin = lib.VECTOR3_ZERO;
            this.volumeSize = {
                x: 1,
                y: 1,
                z: 1
            };
        }
        _createVolume(_volume, _applyToSelection) {
            this._volumeStack.forEach((volume => {
                volume.deactivateHandles();
            }));
            const volume = new MarqueeSelectionVolume(this, _volume, (marqueeVolume => {
                this.debugLog(`Marquee bounds changed to ${lib.Vector3Utils.toString(marqueeVolume.from)} -> ${lib.Vector3Utils.toString(marqueeVolume.to)}`);
                this.volumeOrigin = _volume.from;
                this.volumeSize = _volume.getSpan();
                this.applyVolumeStackToSelectionManager();
            }));
            this._volumeStack.push(volume);
            if (_applyToSelection) {
                this.applyVolumeStackToSelectionManager();
            }
            return volume;
        }
        _currentVolume() {
            if (this._volumeStack.length === 0) {
                return undefined;
            }
            return this._volumeStack[this._volumeStack.length - 1];
        }
        _popVolume() {
            const volume = this._volumeStack.pop();
            if (volume) {
                volume.teardown();
            }
        }
        fillTransactionPayload(_payload) {
            _payload.mode = this.modeType;
            _payload.volumes = [];
            this._volumeStack.forEach((volume => {
                const relativeVolume = new server_editor_namespaceObject.RelativeVolumeListBlockVolume;
                relativeVolume.add(volume.blockVolume);
                _payload.volumes.push(relativeVolume);
            }));
        }
        applyUndo(_payload) {
            if (_payload.mode !== this.modeType) {
                throw new Error("Undo payload mode does not match current mode");
            }
            this.volumeOrigin = lib.VECTOR3_ZERO;
            this.volumeSize = {
                x: 1,
                y: 1,
                z: 1
            };
            this._clearVolumeStack();
            _payload.volumes.forEach((volume => {
                const volumeList = volume.getVolumeList();
                volumeList.forEach((volume => {
                    this._createVolume(volume, true);
                }));
            }));
            const latestVolume = this._currentVolume();
            if (latestVolume) {
                this.volumeOrigin = latestVolume.blockVolume.getMin();
                this.volumeSize = latestVolume.blockVolume.getSpan();
            }
        }
        applyRedo(_payload) {
            if (_payload.mode !== this.modeType) {
                throw new Error("Undo payload mode does not match current mode");
            }
            this.volumeOrigin = lib.VECTOR3_ZERO;
            this.volumeSize = {
                x: 1,
                y: 1,
                z: 1
            };
            this._clearVolumeStack();
            _payload.volumes.forEach((volume => {
                const volumeList = volume.getVolumeList();
                volumeList.forEach((volume => {
                    this._createVolume(volume, true);
                }));
            }));
            const latestVolume = this._currentVolume();
            if (latestVolume) {
                this.volumeOrigin = latestVolume.blockVolume.getMin();
                this.volumeSize = latestVolume.blockVolume.getSpan();
            }
        }
        onExternalSelectionChanged(_evt) {
            this.volumeOrigin = lib.VECTOR3_ZERO;
            this.volumeSize = {
                x: 1,
                y: 1,
                z: 1
            };
            if (!this.session.extensionContext.selectionManager.volume.isEmpty) {
                if (this.session.extensionContext.selectionManager.volume.volumeCount === 1) {
                    const volume = this._currentVolume();
                    if (volume) {
                        volume.deactivateHandles();
                        let externalVolumeBounds;
                        try {
                            externalVolumeBounds = this.session.extensionContext.selectionManager.volume.getBoundingBox();
                            volume.setFromBounds(externalVolumeBounds);
                        } catch {
                            this._popVolume();
                        }
                    } else {
                        let externalVolumeBounds;
                        try {
                            externalVolumeBounds = this.session.extensionContext.selectionManager.volume.getBoundingBox();
                            const newVolume = new server_namespaceObject.BlockVolume(externalVolumeBounds.min, externalVolumeBounds.max);
                            const applyToSelection = false;
                            this._createVolume(newVolume, applyToSelection);
                        } catch {
                            this._popVolume();
                        }
                    }
                } else {
                    while (this._volumeStack.length > 0) {
                        this._popVolume();
                    }
                }
            } else {
                while (this._volumeStack.length > 0) {
                    this._popVolume();
                }
            }
        }
        onDimensionChange() {
            this.debugLog("Dimension change - clearing volume stack");
            this._clearVolumeStack();
            this._transformVec3UIComponent.updateAxisLimits({
                min: {
                    y: this.parent.session.extensionContext.player.dimension.heightRange.min
                },
                max: {
                    y: this.parent.session.extensionContext.player.dimension.heightRange.max
                }
            });
        }
        beginManualInputTranslateVolume() {
            const first = this._translationKeyRepeatRefCount === 0;
            if (this._translationKeyRepeatRefCount === 0) {
                this.parent.beginTransactionableOperation("Marquee Volume Manual Translate");
            }
            ++this._translationKeyRepeatRefCount;
            return first;
        }
        manualInputTranslateVolume(_directionVector) {
            const volume = this._currentVolume();
            if (volume) {
                try {
                    const bounds = volume.blockVolume.getBoundingBox();
                    const newBounds = server_namespaceObject.BlockBoundingBoxUtils.translate(bounds, _directionVector);
                    if (!this.session.extensionContext.blockUtilities.isLocationInsideCurrentDimensionBounds(newBounds)) {
                        return;
                    }
                    volume.from = newBounds.min;
                    volume.to = newBounds.max;
                } catch {
                    this._popVolume();
                }
            }
        }
        endManualInputTranslateVolume() {
            --this._translationKeyRepeatRefCount;
            if (this._translationKeyRepeatRefCount === 0) {
                this.parent.endTransactionableOperation();
                this.applyVolumeStackToSelectionManager();
            } else if (this._translationKeyRepeatRefCount < 0) {
                throw new Error("Translation key repeat count is less than zero - mismatch of press/releases");
            }
        }
        beginManualInputResizeVolume(_shrink) {
            const first = this._resizeKeyRepeatRefCount === 0;
            if (this._resizeKeyRepeatRefCount === 0) {
                this._resizeShrink = _shrink;
                this.parent.beginTransactionableOperation("Marquee Volume Manual Resize");
            }
            ++this._resizeKeyRepeatRefCount;
            return first;
        }
        shrinkVolumeAlongViewAxis(_viewRotation, _direction) {
            if (this._resizeKeyRepeatRefCount > 0) {
                if (!this._resizeShrink) {
                    return;
                }
            }
            const volume = this._currentVolume();
            if (volume) {
                const actualVolume = volume.blockVolume;
                const worldBounds = this.session.extensionContext.blockUtilities.getDimensionLocationBoundingBox();
                const newVolume = shrinkVolumeAlongViewAxis(actualVolume, _viewRotation, _direction, 1, worldBounds);
                try {
                    const newBounds = newVolume.getBoundingBox();
                    volume.from = newBounds.min;
                    volume.to = newBounds.max;
                } catch {
                    this._popVolume();
                }
            }
        }
        growVolumeAlongViewAxis(_viewRotation, _direction) {
            if (this._resizeKeyRepeatRefCount > 0) {
                if (this._resizeShrink) {
                    return;
                }
            }
            const volume = this._currentVolume();
            if (volume) {
                const actualVolume = volume.blockVolume;
                const worldBounds = this.session.extensionContext.blockUtilities.getDimensionLocationBoundingBox();
                const newVolume = growVolumeAlongViewAxis(actualVolume, _viewRotation, _direction, 1, worldBounds);
                try {
                    const newBounds = newVolume.getBoundingBox();
                    volume.from = newBounds.min;
                    volume.to = newBounds.max;
                } catch {
                    this._popVolume();
                }
            }
        }
        endManualInputResizeVolume() {
            --this._resizeKeyRepeatRefCount;
            if (this._resizeKeyRepeatRefCount === 0) {
                this.parent.endTransactionableOperation();
                this.applyVolumeStackToSelectionManager();
            } else if (this._resizeKeyRepeatRefCount < 0) {
                throw new Error("Resize key repeat count is less than zero - mismatch of press/releases");
            }
        }
        onColorChangeEvent() {
            const boundsColors = this.parent.boundingBoxColor;
            this._volumeStack.forEach((volume => {
                volume.onColorChangeEvent(boundsColors.outline, boundsColors.hull);
            }));
        }
    }
    class FreehandSelectionVolume {
        constructor(_modeImpl, _onChanged) {
            this._onChanged = () => {};
            this._modeImpl = _modeImpl;
            this._onChanged = _onChanged || this._onChanged;
            let min = lib.VECTOR3_ZERO;
            let visible = true;
            try {
                const selectionBounds = this._modeImpl.session.extensionContext.selectionManager.volume.getBoundingBox();
                min = selectionBounds.min;
            } catch {
                visible = false;
            }
            this._widget = this._modeImpl.parent.widgetGroup.createWidget(min, {
                snapToBlockLocation: true,
                visible,
                selectable: false
            });
            this._widget.addGizmoComponent("freehandToolGizmo", {
                axes: server_editor_namespaceObject.Axis.X | server_editor_namespaceObject.Axis.Y | server_editor_namespaceObject.Axis.Z,
                visible: true,
                normalizedAutoOffset: {
                    x: 0,
                    y: 0,
                    z: 0
                },
                stateChangeEvent: evt => {
                    if (evt.eventType !== undefined && evt.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginMoved) {
                        this.applyVolumeLocationToSelectionManager();
                        return;
                    }
                }
            });
            const boundsColors = _modeImpl.parent.boundingBoxColor;
            const outlineColors = _modeImpl.parent.outlineBoxColor;
            this._widgetVolumeComponent = this._widget.addVolumeOutline("freehand_outline", undefined, {
                normalizedOrigin: {
                    x: -1,
                    y: -1,
                    z: -1
                },
                showHighlightOutline: true,
                showOutline: true,
                visible: true,
                hullColor: boundsColors.hull,
                outlineColor: boundsColors.outline,
                highlightOutlineColor: outlineColors.outline,
                highlightHullColor: outlineColors.hull
            });
        }
        teardown() {
            this._widget.visible = false;
            this._widgetVolumeComponent.delete();
            this._widget.delete();
        }
        get visible() {
            return this._widget.visible;
        }
        set visible(value) {
            this._widget.visible = value;
        }
        get actualSelectionBoundingBox() {
            let ret = {
                min: lib.VECTOR3_ZERO,
                max: lib.VECTOR3_ZERO
            };
            try {
                ret = this._modeImpl.session.extensionContext.selectionManager.volume.getBoundingBox();
            } catch {}
            return ret;
        }
        get blockVolume() {
            return this._modeImpl.session.extensionContext.selectionManager.volume.get();
        }
        refreshFromSelection() {
            try {
                const selectionBounds = this._modeImpl.session.extensionContext.selectionManager.volume.getBoundingBox();
                this._widget.location = selectionBounds.min;
                this.visible = true;
            } catch {
                this.visible = false;
            }
        }
        translate(_direction) {
            const selectionBounds = this._modeImpl.session.extensionContext.selectionManager.volume.getBoundingBox();
            const newBounds = server_namespaceObject.BlockBoundingBoxUtils.translate(selectionBounds, _direction);
            if (!this._modeImpl.session.extensionContext.blockUtilities.isLocationInsideCurrentDimensionBounds(newBounds)) {
                return;
            }
            let location = this._widget.location;
            location = lib.Vector3Utils.add(location, _direction);
            this._widget.location = location;
        }
        applyVolumeLocationToSelectionManager() {
            const location = this._widget.location;
            const oldBounds = this.actualSelectionBoundingBox;
            this._modeImpl.session.extensionContext.selectionManager.volume.moveTo(location);
            const newBounds = this.actualSelectionBoundingBox;
            this._modeImpl.debugLog(`Moved selection from ${lib.Vector3Utils.toString(oldBounds.min)} to ${lib.Vector3Utils.toString(newBounds.min)}`);
        }
        onColorChangeEvent(_boundsOutline, _boundsHull, _volumeOutline, _volumeHull) {
            this._widgetVolumeComponent.hullColor = _boundsHull;
            this._widgetVolumeComponent.outlineColor = _boundsOutline;
            this._widgetVolumeComponent.highlightHullColor = _volumeHull;
            this._widgetVolumeComponent.highlightOutlineColor = _volumeOutline;
        }
    }
    class SelectionModeFreehand {
        constructor(_parentPane, _parent) {
            this._freehandSelectionActive = false;
            this._volumeStack = [];
            this._translationKeyRepeatRefCount = 0;
            this._parent = _parent;
            this._parentPane = _parentPane;
            this._modePane = this._parentPane.createSubPane({
                title: "NO_ID",
                hasMargins: false,
                hasExpander: false
            });
            this._brushSharedControl = new BrushPaintSharedControl(this._parent.session, this._parent.tool, this._modePane, {
                paintMode: server_editor_namespaceObject.PaintMode.FreehandSelect
            }, (0, server_editor_namespaceObject.getDefaultBrushShapes)(), {
                hasPaneMargins: false
            });
            this._brushSharedControl.initialize();
        }
        get parentPane() {
            return this._parentPane;
        }
        get modePane() {
            return this._modePane;
        }
        get parent() {
            return this._parent;
        }
        get session() {
            return this._parent.session;
        }
        get modeType() {
            return SelectionMode.Freehand;
        }
        debugLog(message) {
            this.parent.debugLog(message);
        }
        teardown() {
            for (const volume of this._volumeStack) {
                volume.teardown();
            }
        }
        activate(_toolActive) {
            if (_toolActive) {
                this._brushSharedControl?.activateControl();
                this._brushSharedControl?.activateVisualization();
            }
            this._freehandSelectionActive = false;
            this._showVolumes();
        }
        deactivate(_toolActive, _switchingModes) {
            if (_toolActive) {
                this._brushSharedControl?.deactivateControl();
                this._brushSharedControl?.deactivateVisualization();
            }
            this._freehandSelectionActive = false;
            if (_switchingModes) {
                this.parent.performSingleTransactionableOperation((() => {
                    this._clearVolumeStack();
                    return true;
                }), "Deactivate Freehand");
            }
        }
        clearSelection() {
            this.parent.performSingleTransactionableOperation((() => {
                this.session.extensionContext.selectionManager.volume.clear();
                this._clearVolumeStack();
                return true;
            }), "Clear Selection");
            this._popVolume();
            this._clearSelectionManager();
        }
        onMouseClickAndDrag(_mouseRay, _mouseProps, _oneShot = false) {
            if (_mouseProps.mouseAction === server_editor_namespaceObject.MouseActionType.LeftButton) {
                if (_mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonDown) {
                    if (this.parent.isTransactionOperationActive()) {
                        this.session.log.warning(`Freehand selection already active`);
                        return;
                    }
                    this.parent.beginTransactionableOperation("Freehand Volume Creation");
                    if (!(_mouseProps.modifiers.shift || _mouseProps.modifiers.ctrl)) {
                        this.debugLog(`Clearing Freehand Stack - no SHIFT or CTRL pressed`);
                        this._clearSelectionManager();
                    } else {
                        this.debugLog(`SHIFT or CTRL pressed - leaving selection contents intact`);
                    }
                    this._beginFreehandSelection(_oneShot);
                } else if (_mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonUp) {
                    this._endFreehandSelection();
                }
            }
        }
        _beginFreehandSelection(_oneShot = false) {
            if (this._freehandSelectionActive) {
                this.session.log.warning(`Freehand selection already active`);
                return;
            }
            this.parent.telemetryManager.fireTelemetryEvent(SelectionTelemetry.FreehandSelectionBegin, {
                oneShot: _oneShot
            });
            this._freehandSelectionActive = true;
            this._popVolume();
            if (_oneShot) {
                this.session.extensionContext.brushShapeManager.singlePaint((_state => {
                    if (_state === server_editor_namespaceObject.PaintCompletionState.Success) {
                        this._freehandSelectionActive = false;
                        this._createVolume();
                        this.parent.endTransactionableOperation();
                    } else {
                        this._popVolume();
                        this.parent.cancelTransactionableOperation();
                    }
                }));
            } else {
                this.session.extensionContext.brushShapeManager.beginPainting((_state => {
                    if (_state === server_editor_namespaceObject.PaintCompletionState.Success) {
                        this._freehandSelectionActive = false;
                        this._createVolume();
                        this.parent.endTransactionableOperation();
                    } else {
                        this._popVolume();
                        this.parent.cancelTransactionableOperation();
                    }
                }));
            }
        }
        _endFreehandSelection() {
            if (!this._freehandSelectionActive) {
                this.session.log.warning(`Freehand selection not active`);
                return;
            }
            this.parent.telemetryManager.fireTelemetryEvent(SelectionTelemetry.FreehandSelectionComplete);
            this.session.extensionContext.brushShapeManager.endPainting(false);
        }
        _showVolumes() {
            this._volumeStack.forEach((volume => {
                volume.visible = true;
            }));
        }
        _hideVolumes() {
            this._volumeStack.forEach((volume => {
                volume.visible = false;
            }));
        }
        applyVolumeStackToSelectionManager() {
            const newVolume = new server_editor_namespaceObject.RelativeVolumeListBlockVolume;
            this._volumeStack.forEach((volume => {
                newVolume.add(volume.blockVolume);
            }));
            this.session.extensionContext.selectionManager.volume.set(newVolume);
        }
        _clearSelectionManager() {
            this.session.extensionContext.selectionManager.volume.clear();
        }
        _clearVolumeStack() {
            this._volumeStack.forEach((volume => {
                volume.teardown();
            }));
            this._volumeStack = [];
            this._clearSelectionManager();
        }
        _createVolume() {
            const volume = new FreehandSelectionVolume(this);
            this._volumeStack.push(volume);
            return volume;
        }
        _currentVolume() {
            if (this._volumeStack.length === 0) {
                return undefined;
            }
            return this._volumeStack[this._volumeStack.length - 1];
        }
        _popVolume() {
            const volume = this._volumeStack.pop();
            if (volume) {
                volume.teardown();
            }
        }
        fillTransactionPayload(_payload) {
            _payload.mode = this.modeType;
            _payload.volumes = this._volumeStack.map((volume => deepCopy(volume.blockVolume)));
        }
        applyUndo(_payload) {
            if (_payload.mode !== this.modeType) {
                throw new Error("Undo payload mode does not match current mode");
            }
            this._clearVolumeStack();
            _payload.volumes.forEach((_volume => {
                this.session.extensionContext.selectionManager.volume.add(_volume);
            }));
            this._createVolume();
        }
        applyRedo(_payload) {
            if (_payload.mode !== this.modeType) {
                throw new Error("Undo payload mode does not match current mode");
            }
            this._clearVolumeStack();
            _payload.volumes.forEach((_volume => {
                this.session.extensionContext.selectionManager.volume.add(_volume);
            }));
            this._createVolume();
        }
        onExternalSelectionChanged(_evt) {
            while (this._volumeStack.length > 0) {
                this._popVolume();
            }
            if (!this.session.extensionContext.selectionManager.volume.isEmpty) {
                if (this.session.extensionContext.selectionManager.volume.volumeCount !== 1) {
                    this._createVolume();
                }
            }
        }
        onDimensionChange() {
            this.debugLog("Dimension change - clearing volume stack");
            this._clearVolumeStack();
        }
        beginManualInputTranslateVolume() {
            const first = this._translationKeyRepeatRefCount === 0;
            if (this._translationKeyRepeatRefCount === 0) {
                this.parent.beginTransactionableOperation("Freehand Volume Manual Translate");
            }
            ++this._translationKeyRepeatRefCount;
            return first;
        }
        manualInputTranslateVolume(_directionVector) {
            const volume = this._currentVolume();
            if (volume) {
                volume.translate(_directionVector);
            }
        }
        endManualInputTranslateVolume() {
            --this._translationKeyRepeatRefCount;
            if (this._translationKeyRepeatRefCount === 0) {
                const volume = this._currentVolume();
                if (volume) {
                    volume.applyVolumeLocationToSelectionManager();
                }
                this.parent.endTransactionableOperation();
            } else if (this._translationKeyRepeatRefCount < 0) {
                throw new Error("Translation key repeat count is less than zero - mismatch of press/releases");
            }
        }
        beginManualInputResizeVolume(_shrink) {
            return false;
        }
        shrinkVolumeAlongViewAxis(_viewRotation, _direction) {}
        growVolumeAlongViewAxis(_viewRotation, _direction) {}
        endManualInputResizeVolume() {}
        onColorChangeEvent() {
            const boundsColors = this.parent.boundingBoxColor;
            const outlineColors = this.parent.outlineBoxColor;
            this._volumeStack.forEach((volume => {
                volume.onColorChangeEvent(boundsColors.outline, boundsColors.hull, outlineColors.outline, outlineColors.hull);
            }));
        }
    }
    const PROPERTY_NAME = "BlockMaskControl";
    const PROPERTY_LOCALIZATION_PREFIX = `resourcePack.editor.${PROPERTY_NAME}`;
    var BlockMaskControlMaskMode;
    (function(BlockMaskControlMaskMode) {
        BlockMaskControlMaskMode[BlockMaskControlMaskMode["Disabled"] = 0] = "Disabled";
        BlockMaskControlMaskMode[BlockMaskControlMaskMode["Mask"] = 1] = "Mask";
        BlockMaskControlMaskMode[BlockMaskControlMaskMode["Replace"] = 2] = "Replace";
    })(BlockMaskControlMaskMode || (BlockMaskControlMaskMode = {}));
    class BlockMaskSharedControl extends SharedControlImpl {
        constructor(session, parentTool, parentPropertyPane, controlGroupName, onBlockMaskModeChanged) {
            super(session, parentTool, parentPropertyPane, PROPERTY_NAME, PROPERTY_LOCALIZATION_PREFIX + "." + controlGroupName);
            this._maskMode = (0, server_editor_namespaceObject.makeObservable)(BlockMaskControlMaskMode.Disabled);
            this._blockListReplaceIds = (0, server_editor_namespaceObject.makeObservable)([]);
            this._blockListReplace = [];
            this._blockListMaskIds = (0, server_editor_namespaceObject.makeObservable)([]);
            this._blockListMask = [];
            this._onBlockMaskModeChanged = onBlockMaskModeChanged;
        }
        debugLog(_msg) {
            this.session.log.debug(`${PROPERTY_NAME}::${_msg}`);
        }
        info(_msg) {
            this.session.log.info(`${PROPERTY_NAME}::${_msg}`);
        }
        initialize() {
            super.initialize();
        }
        shutdown() {
            super.shutdown();
        }
        activateControl() {
            this.debugLog(`activateControl`);
            if (this.isActive) {
                this.debugLog(`activateControl - exiting early - already active`);
                return;
            }
            super.activateControl();
            this._constructUI();
        }
        deactivateControl() {
            this.debugLog("deactivateControl");
            if (!this.isActive) {
                this.debugLog("deactivateControl - exiting early - already deactivated");
                return;
            }
            super.deactivateControl();
            this._destroyUI();
        }
        _constructUI() {
            this.debugLog("constructUI");
            if (this._controlPane) {
                this.propertyPane.removeSubPane(this._controlPane);
                this._controlPane = undefined;
            }
            this._controlPane = this.propertyPane.createSubPane({
                title: this.localize("rootPane.title"),
                hasExpander: false
            });
            this._controlPane.addToggleGroup(this._maskMode, {
                title: this.localize("toggleGroup.title"),
                tooltip: this.localize("toggleGroup.tooltip"),
                entries: [ {
                    label: this.localize("toggleGroup.item.disabled.label"),
                    value: BlockMaskControlMaskMode.Disabled,
                    icon: "squareIcon",
                    tooltip: this.localize("toggleGroup.item.disabled.tooltip")
                }, {
                    label: this.localize("toggleGroup.item.mask.label"),
                    value: BlockMaskControlMaskMode.Mask,
                    icon: "pack://textures/editor/mask.png",
                    tooltip: this.localize("toggleGroup.item.mask.tooltip")
                }, {
                    label: this.localize("toggleGroup.item.replace.label"),
                    value: BlockMaskControlMaskMode.Replace,
                    icon: "pack://textures/editor/replace.png",
                    tooltip: this.localize("toggleGroup.item.replace.tooltip")
                } ],
                onChange: _newMode => {
                    switch (_newMode) {
                      case BlockMaskControlMaskMode.Disabled:
                        maskControl.visible = false;
                        replaceControl.visible = false;
                        break;

                      case BlockMaskControlMaskMode.Mask:
                        maskControl.visible = true;
                        replaceControl.visible = false;
                        break;

                      case BlockMaskControlMaskMode.Replace:
                        maskControl.visible = false;
                        replaceControl.visible = true;
                        break;
                    }
                    this._onBlockMaskModeChanged(_newMode);
                }
            });
            this._blockListMask = convertBlockStringsToBlockType([ "air" ]);
            this._blockListMaskIds.set(convertBlockTypesToBlockStrings(this._blockListMask));
            const maskControl = this._controlPane.addBlockList(this._blockListMaskIds, {
                visible: false,
                onChange: newVal => {
                    this._blockListMask = convertBlockStringsToBlockType(newVal);
                }
            });
            this._blockListReplace = convertBlockStringsToBlockType([ "air" ]);
            this._blockListReplaceIds.set(convertBlockTypesToBlockStrings(this._blockListReplace));
            const replaceControl = this._controlPane.addBlockList(this._blockListReplaceIds, {
                visible: false,
                onChange: newVal => {
                    this._blockListReplace = convertBlockStringsToBlockType(newVal);
                }
            });
        }
        _destroyUI() {}
        _getBlockMaskListTypeFromInternalMaskType(internalMaskType) {
            switch (internalMaskType) {
              case BlockMaskControlMaskMode.Mask:
                return server_editor_namespaceObject.BlockMaskListType.Mask;

              case BlockMaskControlMaskMode.Replace:
                return server_editor_namespaceObject.BlockMaskListType.Replace;

              case BlockMaskControlMaskMode.Disabled:
                return server_editor_namespaceObject.BlockMaskListType.Disabled;

              default:
                throw new Error("Invalid internal mask type");
            }
            return server_editor_namespaceObject.BlockMaskListType.Disabled;
        }
        getBlockMask() {
            const maskType = this._getBlockMaskListTypeFromInternalMaskType(this._maskMode.value);
            const blockList = this._maskMode.value === BlockMaskControlMaskMode.Mask ? this._blockListMask : this._blockListReplace;
            return {
                maskType,
                blockList
            };
        }
    }
    class MagicSelectionVolume {
        constructor(_modeImpl, _onChanged) {
            this._onChanged = () => {};
            this._modeImpl = _modeImpl;
            this._onChanged = _onChanged || this._onChanged;
            let min = lib.VECTOR3_ZERO;
            let visible = true;
            try {
                const selectionBounds = this._modeImpl.session.extensionContext.selectionManager.volume.getBoundingBox();
                min = selectionBounds.min;
            } catch {
                visible = false;
            }
            this._widget = this._modeImpl.parent.widgetGroup.createWidget(min, {
                snapToBlockLocation: true,
                visible,
                selectable: false
            });
            const boundsColors = _modeImpl.parent.boundingBoxColor;
            const outlineColors = _modeImpl.parent.outlineBoxColor;
            this._widgetVolumeComponent = this._widget.addVolumeOutline("magic_outline", undefined, {
                normalizedOrigin: {
                    x: -1,
                    y: -1,
                    z: -1
                },
                showHighlightOutline: true,
                showOutline: true,
                visible: true,
                hullColor: boundsColors.hull,
                outlineColor: boundsColors.outline,
                highlightOutlineColor: outlineColors.outline,
                highlightHullColor: outlineColors.hull
            });
            this._widget.addGizmoComponent("smartToolGizmo", {
                axes: server_editor_namespaceObject.Axis.X | server_editor_namespaceObject.Axis.Y | server_editor_namespaceObject.Axis.Z,
                visible: true,
                normalizedAutoOffset: {
                    x: 0,
                    y: 0,
                    z: 0
                },
                stateChangeEvent: evt => {
                    if (evt.eventType !== undefined && evt.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginMoved) {
                        this.applyVolumeLocationToSelectionManager();
                        return;
                    }
                }
            });
        }
        teardown() {
            this._widget.visible = false;
            this._widgetVolumeComponent.delete();
            this._widget.delete();
        }
        get visible() {
            return this._widget.visible;
        }
        set visible(value) {
            this._widget.visible = value;
        }
        get actualSelectionBoundingBox() {
            let ret = {
                min: lib.VECTOR3_ZERO,
                max: lib.VECTOR3_ZERO
            };
            try {
                ret = this._modeImpl.session.extensionContext.selectionManager.volume.getBoundingBox();
            } catch {}
            return ret;
        }
        get blockVolume() {
            return this._modeImpl.session.extensionContext.selectionManager.volume.get();
        }
        refreshFromSelection() {
            try {
                const selectionBounds = this._modeImpl.session.extensionContext.selectionManager.volume.getBoundingBox();
                this._widget.location = selectionBounds.min;
                this.visible = true;
            } catch {
                this.visible = false;
            }
        }
        translate(_direction) {
            const selectionBounds = this._modeImpl.session.extensionContext.selectionManager.volume.getBoundingBox();
            const newBounds = server_namespaceObject.BlockBoundingBoxUtils.translate(selectionBounds, _direction);
            if (!this._modeImpl.session.extensionContext.blockUtilities.isLocationInsideCurrentDimensionBounds(newBounds)) {
                return;
            }
            let location = this._widget.location;
            location = lib.Vector3Utils.add(location, _direction);
            this._widget.location = location;
        }
        applyVolumeLocationToSelectionManager() {
            const location = this._widget.location;
            const oldBounds = this.actualSelectionBoundingBox;
            this._modeImpl.session.extensionContext.selectionManager.volume.moveTo(location);
            const newBounds = this.actualSelectionBoundingBox;
            this._modeImpl.debugLog(`Moved selection from ${lib.Vector3Utils.toString(oldBounds.min)} to ${lib.Vector3Utils.toString(newBounds.min)}`);
        }
        onColorChangeEvent(_boundsOutline, _boundsHull, _volumeOutline, _volumeHull) {
            this._widgetVolumeComponent.hullColor = _boundsHull;
            this._widgetVolumeComponent.outlineColor = _boundsOutline;
            this._widgetVolumeComponent.highlightHullColor = _volumeHull;
            this._widgetVolumeComponent.highlightOutlineColor = _volumeOutline;
        }
    }
    class SelectionModeMagic {
        constructor(_parentPane, _parent) {
            this._volumeStack = [];
            this._translationKeyRepeatRefCount = 0;
            this._parent = _parent;
            this._parentPane = _parentPane;
            this._modePane = this._parentPane.createSubPane({
                title: "NO_ID",
                hasMargins: false,
                hasExpander: false
            });
        }
        get parentPane() {
            return this._parentPane;
        }
        get modePane() {
            return this._modePane;
        }
        get parent() {
            return this._parent;
        }
        get session() {
            return this._parent.session;
        }
        get modeType() {
            return SelectionMode.MagicSelect;
        }
        debugLog(message) {
            this.parent.debugLog(message);
        }
        teardown() {
            for (const volume of this._volumeStack) {
                volume.teardown();
            }
        }
        activate(_toolActive) {
            this._showVolumes();
        }
        deactivate(_toolActive, _switchingModes) {
            if (_switchingModes) {
                this.parent.performSingleTransactionableOperation((() => {
                    this._clearVolumeStack();
                    return true;
                }), "Deactivate Magic Select");
            }
        }
        clearSelection() {
            this.parent.performSingleTransactionableOperation((() => {
                this.session.extensionContext.selectionManager.volume.clear();
                this._clearVolumeStack();
                return true;
            }), "Clear Selection");
            this._popVolume();
            this._clearSelectionManager();
        }
        onMouseClickAndDrag(_mouseRay, _mouseProps, _oneShot = false) {
            if (_mouseProps.mouseAction === server_editor_namespaceObject.MouseActionType.LeftButton) {
                if (_mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonDown) {
                    this.parent.beginTransactionableOperation("Magic Select Volume Creation");
                    if (!_mouseProps.modifiers.shift) {
                        this.debugLog(`Clearing Magic Select Stack - no SHIFT`);
                        this._clearSelectionManager();
                    } else {
                        this.debugLog(`SHIFT pressed - leaving selection contents intact`);
                    }
                    this.parent.telemetryManager.fireTelemetryEvent(SelectionTelemetry.MagicSelect);
                    this._popVolume();
                    const block = this.session.extensionContext.player.dimension.getBlock(_mouseRay.cursorBlockLocation);
                    if (block) {
                        const newSelection = this._selectObjectFromBase(block);
                        this.session.extensionContext.selectionManager.volume.add(newSelection);
                        this._createVolume();
                    }
                    this.parent.endTransactionableOperation();
                }
            }
        }
        _showVolumes() {
            this._volumeStack.forEach((volume => {
                volume.visible = true;
            }));
        }
        _hideVolumes() {
            this._volumeStack.forEach((volume => {
                volume.visible = false;
            }));
        }
        applyVolumeStackToSelectionManager() {
            const newVolume = new server_editor_namespaceObject.RelativeVolumeListBlockVolume;
            this._volumeStack.forEach((volume => {
                newVolume.add(volume.blockVolume);
            }));
            this.session.extensionContext.selectionManager.volume.set(newVolume);
        }
        _clearSelectionManager() {
            this.session.extensionContext.selectionManager.volume.clear();
        }
        _clearVolumeStack() {
            this._volumeStack.forEach((volume => {
                volume.teardown();
            }));
            this._volumeStack = [];
            this._clearSelectionManager();
        }
        _createVolume() {
            const volume = new MagicSelectionVolume(this);
            this._volumeStack.push(volume);
            return volume;
        }
        _currentVolume() {
            if (this._volumeStack.length === 0) {
                return undefined;
            }
            return this._volumeStack[this._volumeStack.length - 1];
        }
        _popVolume() {
            const volume = this._volumeStack.pop();
            if (volume) {
                volume.teardown();
            }
        }
        fillTransactionPayload(_payload) {
            _payload.mode = this.modeType;
            _payload.volumes = this._volumeStack.map((volume => deepCopy(volume.blockVolume)));
        }
        applyUndo(_payload) {
            if (_payload.mode !== this.modeType) {
                throw new Error("Undo payload mode does not match current mode");
            }
            this._clearVolumeStack();
            _payload.volumes.forEach((_volume => {
                this.session.extensionContext.selectionManager.volume.add(_volume);
            }));
            this._createVolume();
        }
        applyRedo(_payload) {
            if (_payload.mode !== this.modeType) {
                throw new Error("Undo payload mode does not match current mode");
            }
            this._clearVolumeStack();
            _payload.volumes.forEach((_volume => {
                this.session.extensionContext.selectionManager.volume.add(_volume);
            }));
            this._createVolume();
        }
        onExternalSelectionChanged(_evt) {
            while (this._volumeStack.length > 0) {
                this._popVolume();
            }
        }
        onDimensionChange() {
            this.debugLog("Dimension change - clearing volume stack");
            this._clearVolumeStack();
        }
        beginManualInputTranslateVolume() {
            const first = this._translationKeyRepeatRefCount === 0;
            if (this._translationKeyRepeatRefCount === 0) {
                this.parent.beginTransactionableOperation("MagicSelect Volume Manual Translate");
            }
            ++this._translationKeyRepeatRefCount;
            return first;
        }
        manualInputTranslateVolume(_directionVector) {
            const volume = this._currentVolume();
            if (volume) {
                volume.translate(_directionVector);
            }
        }
        endManualInputTranslateVolume() {
            --this._translationKeyRepeatRefCount;
            if (this._translationKeyRepeatRefCount === 0) {
                const volume = this._currentVolume();
                if (volume) {
                    volume.applyVolumeLocationToSelectionManager();
                }
                this.parent.endTransactionableOperation();
            } else if (this._translationKeyRepeatRefCount < 0) {
                throw new Error("Translation key repeat count is less than zero - mismatch of press/releases");
            }
        }
        beginManualInputResizeVolume(_shrink) {
            return false;
        }
        shrinkVolumeAlongViewAxis(_viewRotation, _direction) {}
        growVolumeAlongViewAxis(_viewRotation, _direction) {}
        endManualInputResizeVolume() {}
        onColorChangeEvent() {
            const boundsColors = this.parent.boundingBoxColor;
            const outlineColors = this.parent.outlineBoxColor;
            this._volumeStack.forEach((volume => {
                volume.onColorChangeEvent(boundsColors.outline, boundsColors.hull, outlineColors.outline, outlineColors.hull);
            }));
        }
        _selectObjectFromBase(startBlock) {
            const searchOffsets = [ {
                x: 1,
                y: 0,
                z: 0
            }, {
                x: -1,
                y: 0,
                z: 0
            }, {
                x: 0,
                y: 1,
                z: 0
            }, {
                x: 0,
                y: -1,
                z: 0
            }, {
                x: 0,
                y: 0,
                z: 1
            }, {
                x: 0,
                y: 0,
                z: -1
            } ];
            const newVolume = new server_editor_namespaceObject.RelativeVolumeListBlockVolume;
            if (startBlock) {
                const radius = 16;
                const from = {
                    x: startBlock.location.x - radius,
                    y: startBlock.location.y,
                    z: startBlock.location.z - radius
                };
                const to = {
                    x: startBlock.location.x + radius,
                    y: startBlock.location.y + radius * 2,
                    z: startBlock.location.z + radius
                };
                const bounds = new server_namespaceObject.BlockVolume(from, to);
                const dimension = startBlock.dimension;
                const fillStack = [];
                const selectStack = [];
                const visitedBlocks = new Vector3Set;
                fillStack.push(startBlock.location);
                visitedBlocks.add(startBlock.location);
                while (fillStack.length > 0) {
                    const loc = fillStack.pop();
                    if (loc === undefined || !bounds.isInside(loc)) continue;
                    const blockAtLoc = dimension.getBlock(loc);
                    if (!blockAtLoc || blockAtLoc.type === server_namespaceObject.BlockTypes.get(lib_vanilla_MinecraftBlockTypes.Air)) {
                        continue;
                    }
                    selectStack.push(loc);
                    for (const offset of searchOffsets) {
                        const offsetLoc = {
                            x: loc.x + offset.x,
                            y: loc.y + offset.y,
                            z: loc.z + offset.z
                        };
                        if (!bounds.isInside(offsetLoc)) continue;
                        if (visitedBlocks.contains(offsetLoc)) {
                            continue;
                        }
                        fillStack.push(offsetLoc);
                        visitedBlocks.add(offsetLoc);
                    }
                }
                for (const selectLoc of selectStack) {
                    newVolume.add(selectLoc);
                }
            }
            return newVolume;
        }
    }
    class SelectionBehavior {
        get toolId() {
            return this._tool.id;
        }
        get session() {
            return this.uiSession;
        }
        get tool() {
            return this._tool;
        }
        get telemetryManager() {
            return this._telemetryManager;
        }
        get widgetGroup() {
            return this._widgetGroup;
        }
        get transactionHandler() {
            return this._transactionHandler;
        }
        get boundingBoxColor() {
            return {
                outline: this._colorBoundingBoxOutline,
                hull: this._colorBoundingBoxHull
            };
        }
        get outlineBoxColor() {
            return {
                outline: this._colorOutlineBoxOutline,
                hull: this._colorOutlineBoxHull
            };
        }
        get isActiveTool() {
            return this.toolId === this.session.toolRail.getSelectedToolId();
        }
        constructor(uiSession) {
            this.uiSession = uiSession;
            this._quickActionMode = (0, server_editor_namespaceObject.makeObservable)(SelectionCommonTypes_QuickActionMode.Invalid);
            this._volumeTrimActionMode = (0, server_editor_namespaceObject.makeObservable)(TrimActionMode.Invalid);
            this._volumeTrimIgnoreLiquid = (0, server_editor_namespaceObject.makeObservable)(true);
            this._volumeTrimOnlyCollision = (0, server_editor_namespaceObject.makeObservable)(true);
            this._cleanupHandles = [];
            this._colorBoundingBoxOutline = createRGBAColorFromInts(239, 201, 24, 255);
            this._colorBoundingBoxHull = createRGBAColorFromInts(116, 243, 239, 33);
            this._colorOutlineBoxOutline = createRGBAColorFromInts(0, 255, 0, 255);
            this._colorOutlineBoxHull = createRGBAColorFromInts(116, 243, 239, 114);
            this.shrinkVolume = (uiSession, direction) => {
                if (uiSession.extensionContext.selectionManager.volume.isEmpty) {
                    return;
                }
                const rotationY = uiSession.extensionContext.player.getRotation().y;
                this._activeModeImplementation?.shrinkVolumeAlongViewAxis(rotationY, direction);
            };
            this.growVolume = (uiSession, direction) => {
                if (uiSession.extensionContext.selectionManager.volume.isEmpty) {
                    return;
                }
                const rotationY = uiSession.extensionContext.player.getRotation().y;
                this._activeModeImplementation?.growVolumeAlongViewAxis(rotationY, direction);
            };
            this.bindToolInput = uiSession => {
                const singleClickAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
                    onExecute: (mouseRay, mouseProps) => {
                        this._activeModeImplementation?.onMouseClickAndDrag(mouseRay, mouseProps, false);
                    }
                });
                this._tool.registerMouseButtonBinding(singleClickAction);
                const dragClickAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
                    onExecute: (mouseRay, mouseProps) => {
                        this._activeModeImplementation?.onMouseClickAndDrag(mouseRay, mouseProps, false);
                    }
                });
                this._tool.registerMouseDragBinding(dragClickAction);
                const moveSelectionUpAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionMoveTop, {
                                direction: direction_Direction.Up
                            });
                            this._activeModeImplementation?.beginManualInputTranslateVolume();
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputTranslateVolume();
                            return;
                        }
                        const rotationY = uiSession.extensionContext.player.getRotation().y;
                        const correctedVector = getRotationCorrectedDirectionVector(rotationY, direction_Direction.Up);
                        this._activeModeImplementation?.manualInputTranslateVolume(correctedVector);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                const moveSelectionDownAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionMoveTop, {
                                direction: direction_Direction.Down
                            });
                            this._activeModeImplementation?.beginManualInputTranslateVolume();
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputTranslateVolume();
                            return;
                        }
                        const rotationY = uiSession.extensionContext.player.getRotation().y;
                        const correctedVector = getRotationCorrectedDirectionVector(rotationY, direction_Direction.Down);
                        this._activeModeImplementation?.manualInputTranslateVolume(correctedVector);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                const moveSelectionLeftAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionMoveTop, {
                                direction: direction_Direction.Left
                            });
                            this._activeModeImplementation?.beginManualInputTranslateVolume();
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputTranslateVolume();
                            return;
                        }
                        const rotationY = uiSession.extensionContext.player.getRotation().y;
                        const correctedVector = getRotationCorrectedDirectionVector(rotationY, direction_Direction.Left);
                        this._activeModeImplementation?.manualInputTranslateVolume(correctedVector);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                const moveSelectionRightAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionMoveTop, {
                                direction: direction_Direction.Right
                            });
                            this._activeModeImplementation?.beginManualInputTranslateVolume();
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputTranslateVolume();
                            return;
                        }
                        const rotationY = uiSession.extensionContext.player.getRotation().y;
                        const correctedVector = getRotationCorrectedDirectionVector(rotationY, direction_Direction.Right);
                        this._activeModeImplementation?.manualInputTranslateVolume(correctedVector);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                const moveSelectionForwardAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionMoveTop, {
                                direction: direction_Direction.Forward
                            });
                            this._activeModeImplementation?.beginManualInputTranslateVolume();
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputTranslateVolume();
                            return;
                        }
                        const rotationY = uiSession.extensionContext.player.getRotation().y;
                        const correctedVector = getRotationCorrectedDirectionVector(rotationY, direction_Direction.Forward);
                        this._activeModeImplementation?.manualInputTranslateVolume(correctedVector);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                const moveSelectionBackAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionMoveTop, {
                                direction: direction_Direction.Back
                            });
                            this._activeModeImplementation?.beginManualInputTranslateVolume();
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputTranslateVolume();
                            return;
                        }
                        const rotationY = uiSession.extensionContext.player.getRotation().y;
                        const correctedVector = getRotationCorrectedDirectionVector(rotationY, direction_Direction.Back);
                        this._activeModeImplementation?.manualInputTranslateVolume(correctedVector);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(moveSelectionForwardAction, {
                    key: Controls.Forward,
                    modifier: server_editor_namespaceObject.InputModifier.Alt
                }, "moveSelectionForward");
                this._registerToolKeyBinding(moveSelectionBackAction, {
                    key: Controls.Back,
                    modifier: server_editor_namespaceObject.InputModifier.Alt
                }, "moveSelectionBack");
                this._registerToolKeyBinding(moveSelectionLeftAction, {
                    key: Controls.Left,
                    modifier: server_editor_namespaceObject.InputModifier.Alt
                }, "moveSelectionLeft");
                this._registerToolKeyBinding(moveSelectionRightAction, {
                    key: Controls.Right,
                    modifier: server_editor_namespaceObject.InputModifier.Alt
                }, "moveSelectionRight");
                this._registerToolKeyBinding(moveSelectionUpAction, {
                    key: Controls.Up,
                    modifier: server_editor_namespaceObject.InputModifier.Alt
                }, "moveSelectionUp");
                this._registerToolKeyBinding(moveSelectionDownAction, {
                    key: Controls.Down,
                    modifier: server_editor_namespaceObject.InputModifier.Alt
                }, "moveSelectionDown");
                const keySelectAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                    onExecute: () => {
                        const blockLocation = uiSession.extensionContext.cursor.getPosition();
                        const ray = {
                            location: lib.VECTOR3_ZERO,
                            direction: lib.VECTOR3_ZERO,
                            cursorBlockLocation: blockLocation,
                            rayHit: true
                        };
                        const mouseProps = {
                            mouseAction: server_editor_namespaceObject.MouseActionType.LeftButton,
                            inputType: server_editor_namespaceObject.MouseInputType.ButtonDown,
                            modifiers: {
                                shift: false,
                                ctrl: false,
                                alt: false
                            }
                        };
                        const oneShot = true;
                        this._activeModeImplementation?.onMouseClickAndDrag(ray, mouseProps, oneShot);
                        mouseProps.inputType = server_editor_namespaceObject.MouseInputType.ButtonUp;
                        this._activeModeImplementation?.onMouseClickAndDrag(ray, mouseProps, oneShot);
                    }
                });
                this._registerToolKeyBinding(keySelectAction, {
                    key: Controls.Select
                }, "select");
                const keySelectMultipleAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                    onExecute: () => {
                        const blockLocation = uiSession.extensionContext.cursor.getPosition();
                        const ray = {
                            location: lib.VECTOR3_ZERO,
                            direction: lib.VECTOR3_ZERO,
                            cursorBlockLocation: blockLocation,
                            rayHit: true
                        };
                        const mouseProps = {
                            mouseAction: server_editor_namespaceObject.MouseActionType.LeftButton,
                            inputType: server_editor_namespaceObject.MouseInputType.ButtonDown,
                            modifiers: {
                                shift: true,
                                ctrl: false,
                                alt: false
                            }
                        };
                        const oneShot = true;
                        this._activeModeImplementation?.onMouseClickAndDrag(ray, mouseProps, oneShot);
                        mouseProps.inputType = server_editor_namespaceObject.MouseInputType.ButtonUp;
                        this._activeModeImplementation?.onMouseClickAndDrag(ray, mouseProps, oneShot);
                    }
                });
                this._registerToolKeyBinding(keySelectMultipleAction, {
                    key: Controls.Select,
                    modifier: server_editor_namespaceObject.InputModifier.Shift
                }, "selectMultiple");
                const keyGrowUpAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            const first = this._activeModeImplementation?.beginManualInputResizeVolume(false);
                            if (first) {
                                this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionGrow, {
                                    direction: direction_Direction.Up
                                });
                            }
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputResizeVolume();
                            return;
                        }
                        this.growVolume(uiSession, direction_Direction.Up);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(keyGrowUpAction, {
                    key: Controls.Up,
                    modifier: server_editor_namespaceObject.InputModifier.Shift
                }, "growUp");
                const keyGrowDownAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            const first = this._activeModeImplementation?.beginManualInputResizeVolume(false);
                            if (first) {
                                this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionGrow, {
                                    direction: direction_Direction.Down
                                });
                            }
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputResizeVolume();
                            return;
                        }
                        this.growVolume(uiSession, direction_Direction.Down);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(keyGrowDownAction, {
                    key: Controls.Down,
                    modifier: server_editor_namespaceObject.InputModifier.Shift
                }, "growDown");
                const keyGrowForwardAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            const first = this._activeModeImplementation?.beginManualInputResizeVolume(false);
                            if (first) {
                                this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionGrow, {
                                    direction: direction_Direction.Forward
                                });
                            }
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputResizeVolume();
                            return;
                        }
                        this.growVolume(uiSession, direction_Direction.Forward);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(keyGrowForwardAction, {
                    key: Controls.Forward,
                    modifier: server_editor_namespaceObject.InputModifier.Shift
                }, "growForward");
                const keyGrowBackAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            const first = this._activeModeImplementation?.beginManualInputResizeVolume(false);
                            if (first) {
                                this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionGrow, {
                                    direction: direction_Direction.Back
                                });
                            }
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputResizeVolume();
                            return;
                        }
                        this.growVolume(uiSession, direction_Direction.Back);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(keyGrowBackAction, {
                    key: Controls.Back,
                    modifier: server_editor_namespaceObject.InputModifier.Shift
                }, "growBack");
                const keyGrowLeftAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            const first = this._activeModeImplementation?.beginManualInputResizeVolume(false);
                            if (first) {
                                this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionGrow, {
                                    direction: direction_Direction.Left
                                });
                            }
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputResizeVolume();
                            return;
                        }
                        this.growVolume(uiSession, direction_Direction.Left);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(keyGrowLeftAction, {
                    key: Controls.Left,
                    modifier: server_editor_namespaceObject.InputModifier.Shift
                }, "growLeft");
                const keyGrowRightAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            const first = this._activeModeImplementation?.beginManualInputResizeVolume(false);
                            if (first) {
                                this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionGrow, {
                                    direction: direction_Direction.Right
                                });
                            }
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputResizeVolume();
                            return;
                        }
                        this.growVolume(uiSession, direction_Direction.Right);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(keyGrowRightAction, {
                    key: Controls.Right,
                    modifier: server_editor_namespaceObject.InputModifier.Shift
                }, "growRight");
                const keyShrinkUpAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            const first = this._activeModeImplementation?.beginManualInputResizeVolume(true);
                            if (first) {
                                this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionShrink, {
                                    direction: direction_Direction.Up
                                });
                            }
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputResizeVolume();
                            return;
                        }
                        this.shrinkVolume(uiSession, direction_Direction.Up);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(keyShrinkUpAction, {
                    key: Controls.Up,
                    modifier: server_editor_namespaceObject.InputModifier.Control
                }, "shrinkUp");
                const keyShrinkDownAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            const first = this._activeModeImplementation?.beginManualInputResizeVolume(true);
                            if (first) {
                                this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionShrink, {
                                    direction: direction_Direction.Down
                                });
                            }
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputResizeVolume();
                            return;
                        }
                        this.shrinkVolume(uiSession, direction_Direction.Down);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(keyShrinkDownAction, {
                    key: Controls.Down,
                    modifier: server_editor_namespaceObject.InputModifier.Control
                }, "shrinkDown");
                const keyShrinkForwardAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            const first = this._activeModeImplementation?.beginManualInputResizeVolume(true);
                            if (first) {
                                this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionShrink, {
                                    direction: direction_Direction.Forward
                                });
                            }
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputResizeVolume();
                            return;
                        }
                        this.shrinkVolume(uiSession, direction_Direction.Forward);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(keyShrinkForwardAction, {
                    key: Controls.Forward,
                    modifier: server_editor_namespaceObject.InputModifier.Control
                }, "shrinkForward");
                const keyShrinkBackAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            const first = this._activeModeImplementation?.beginManualInputResizeVolume(true);
                            if (first) {
                                this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionShrink, {
                                    direction: direction_Direction.Back
                                });
                            }
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputResizeVolume();
                            return;
                        }
                        this.shrinkVolume(uiSession, direction_Direction.Back);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(keyShrinkBackAction, {
                    key: Controls.Back,
                    modifier: server_editor_namespaceObject.InputModifier.Control
                }, "shrinkBack");
                const keyShrinkLeftAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            const first = this._activeModeImplementation?.beginManualInputResizeVolume(true);
                            if (first) {
                                this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionShrink, {
                                    direction: direction_Direction.Left
                                });
                            }
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputResizeVolume();
                            return;
                        }
                        this.shrinkVolume(uiSession, direction_Direction.Left);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(keyShrinkLeftAction, {
                    key: Controls.Left,
                    modifier: server_editor_namespaceObject.InputModifier.Control
                }, "shrinkLeft");
                const keyShrinkRightAction = uiSession.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                    onExecute: _state => {
                        if (_state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                            const first = this._activeModeImplementation?.beginManualInputResizeVolume(true);
                            if (first) {
                                this.telemetryManager.fireTelemetryEvent(SelectionTelemetry.SelectionShrink, {
                                    direction: direction_Direction.Right
                                });
                            }
                        }
                        if (_state === server_editor_namespaceObject.ContinuousActionState.End) {
                            this._activeModeImplementation?.endManualInputResizeVolume();
                            return;
                        }
                        this.shrinkVolume(uiSession, direction_Direction.Right);
                    },
                    repeatInterval: SelectionCommonTypes_KEY_REPEAT_INTERVAL,
                    repeatDelay: SelectionCommonTypes_KEY_REPEAT_DELAY
                });
                this._registerToolKeyBinding(keyShrinkRightAction, {
                    key: Controls.Right,
                    modifier: server_editor_namespaceObject.InputModifier.Control
                }, "shrinkRight");
            };
            this.addDeselectAndFillMenuItems = uiSession => {
                uiSession.scratchStorage?.coreMenuItems?.edit.addItem({
                    label: "resourcePack.editor.menuBar.edit.deselect",
                    tooltip: "resourcePack.editor.menuBar.edit.deselect.tooltip"
                }, this._deselectAction);
                uiSession.scratchStorage?.coreMenuItems?.edit.addItem({
                    label: "resourcePack.editor.menuBar.edit.quickFill",
                    tooltip: "resourcePack.editor.menuBar.edit.quickFill.tooltip"
                }, this._executeFillAction);
            };
            this._addModeSelectionControls = (_uiSession, _parentPane) => {
                _parentPane.addToggleGroup(this._selectionMode, {
                    title: "resourcePack.editor.selectionTool.modeSelection.title",
                    tooltip: "resourcePack.editor.selectionTool.modeSelection.tooltip",
                    hiddenLabel: false,
                    entries: [ {
                        value: SelectionMode.Marquee,
                        icon: "marqueeIcon",
                        tooltip: {
                            title: {
                                id: "resourcePack.editor.selectionTool.modeSelection.marquee.title",
                                props: [ getInputMarkup("editor:toolModeKeyBinding:toggleSelection", "[", "]") ]
                            },
                            description: {
                                id: "resourcePack.editor.selectionTool.modeSelection.marquee.tooltip",
                                props: [ newLineMarkup + newLineMarkup, getInputMarkup("editor:toolModeKeyBinding:toggleSelection", "[", "]") ]
                            }
                        }
                    }, {
                        value: SelectionMode.Freehand,
                        icon: "brushIcon",
                        tooltip: {
                            title: {
                                id: "resourcePack.editor.selectionTool.modeSelection.freehand.title",
                                props: [ getInputMarkup("editor:toolModeKeyBinding:toggleSelection", "[", "]") ]
                            },
                            description: {
                                id: "resourcePack.editor.selectionTool.modeSelection.freehand.tooltip",
                                props: [ newLineMarkup + newLineMarkup, getInputMarkup("editor:toolModeKeyBinding:toggleSelection", "[", "]") ]
                            }
                        }
                    }, {
                        value: SelectionMode.MagicSelect,
                        icon: "eyeDropperIcon",
                        tooltip: {
                            title: {
                                id: "resourcePack.editor.selectionTool.modeSelection.magic.title",
                                props: [ getInputMarkup("editor:toolModeKeyBinding:toggleSelection", "[", "]") ]
                            },
                            description: {
                                id: "resourcePack.editor.selectionTool.modeSelection.magic.tooltip",
                                props: [ newLineMarkup + newLineMarkup, getInputMarkup("editor:toolModeKeyBinding:toggleSelection", "[", "]") ]
                            }
                        }
                    } ],
                    onChange: (_newValue, _oldValue) => {
                        this._switchSelectionMode(_newValue, true);
                    }
                });
                _parentPane.addDivider();
                _parentPane.addToggleGroup(this._quickActionMode, {
                    title: "resourcePack.editor.selectionTool.quickAction.title",
                    tooltip: "resourcePack.editor.selectionTool.quickAction.tooltip",
                    hiddenLabel: false,
                    entries: [ {
                        value: SelectionCommonTypes_QuickActionMode.DeselectSelection,
                        label: {
                            id: "resourcePack.editor.selectionTool.quickAction.clearSelection",
                            props: [ getInputMarkup("editor:toolModeKeyBinding:deselectSelection", "[", "]") ]
                        },
                        icon: "marqueeRemoveIcon",
                        tooltip: "resourcePack.editor.selectionTool.quickAction.clearSelection.tooltip"
                    }, {
                        value: SelectionCommonTypes_QuickActionMode.FillSelection,
                        label: {
                            id: "resourcePack.editor.selectionTool.quickAction.fillSelection",
                            props: [ getInputMarkup("editor:toolModeKeyBinding:fillSelection", "[", "]") ]
                        },
                        icon: "fillIcon",
                        tooltip: "resourcePack.editor.selectionTool.quickAction.fillSelection.tooltip"
                    }, {
                        value: SelectionCommonTypes_QuickActionMode.DeleteSelection,
                        label: {
                            id: "resourcePack.editor.selectionTool.quickAction.deleteSelection",
                            props: [ getInputMarkup("editor:toolModeKeyBinding:delete", "[", "]") ]
                        },
                        icon: "trashCanIcon",
                        tooltip: "resourcePack.editor.selectionTool.quickAction.deleteSelection.tooltip"
                    } ],
                    onChange: _newValue => {
                        this._quickActionMode.set(SelectionCommonTypes_QuickActionMode.Invalid);
                        switch (_newValue) {
                          case SelectionCommonTypes_QuickActionMode.DeselectSelection:
                            this._telemetryManager.fireTelemetryEvent(SelectionTelemetry.QuickAction, {
                                action: SelectionTelemetry.Deselect
                            });
                            this.clearSelection();
                            break;

                          case SelectionCommonTypes_QuickActionMode.FillSelection:
                            {
                                this._telemetryManager.fireTelemetryEvent(SelectionTelemetry.QuickAction, {
                                    action: SelectionTelemetry.FillSelection
                                });
                                this._executeFillAction.onExecute();
                            }
                            break;

                          case SelectionCommonTypes_QuickActionMode.DeleteSelection:
                            {
                                const blockType = server_namespaceObject.BlockTypes.get(lib_vanilla_MinecraftBlockTypes.Air);
                                if (!blockType) {
                                    return;
                                }
                                this._telemetryManager.fireTelemetryEvent(SelectionTelemetry.QuickAction, {
                                    action: SelectionTelemetry.DeleteSelection
                                });
                                this.performDeleteOperation(this.uiSession).catch((e => this.uiSession.log.error(e.message, {
                                    channelMask: server_editor_namespaceObject.LogChannel.All
                                })));
                            }
                            break;
                        }
                    }
                });
            };
            this._addVolumeTrimActionControls = (_uiSession, _parentPane) => {
                this._volumeTrimActionsPane = _parentPane.createSubPane({
                    title: "Hidden Volume Trim Action Pane",
                    hasExpander: false
                });
                const trimVolumeAction = this.session.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                    onExecute: () => {
                        if (this.session.extensionContext.selectionManager.volume.isEmpty) {
                            this.session.log.warning("No selection available to trim");
                            return;
                        }
                        this._telemetryManager.fireTelemetryEvent(SelectionTelemetry.QuickAction, {
                            action: SelectionTelemetry.TrimVolume
                        });
                        this._performTrimOperation(this.uiSession, this.uiSession.extensionContext).catch((e => this.uiSession.log.error(e.message, {
                            channelMask: server_editor_namespaceObject.LogChannel.All
                        })));
                    }
                });
                const trimAirAction = this.session.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                    onExecute: () => {
                        if (this.session.extensionContext.selectionManager.volume.isEmpty) {
                            this.session.log.warning("No selection available to remove air");
                            return;
                        }
                        this._telemetryManager.fireTelemetryEvent(SelectionTelemetry.QuickAction, {
                            action: SelectionTelemetry.RemoveAir
                        });
                        this._performRemoveAirOperation(this.uiSession, this.uiSession.extensionContext).catch((e => this.uiSession.log.error(e.message, {
                            channelMask: server_editor_namespaceObject.LogChannel.All
                        })));
                    }
                });
                const trimHollowAction = this.session.actionManager.createAction({
                    actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                    onExecute: () => {
                        if (this.session.extensionContext.selectionManager.volume.isEmpty) {
                            this.session.log.warning("No selection available to hollow");
                            return;
                        }
                        this._telemetryManager.fireTelemetryEvent(SelectionTelemetry.QuickAction, {
                            action: SelectionTelemetry.HollowVolume
                        });
                        this._performHollowOperation(this.uiSession, this.uiSession.extensionContext).catch((e => this.uiSession.log.error(e.message, {
                            channelMask: server_editor_namespaceObject.LogChannel.All
                        })));
                    }
                });
                this._volumeTrimActionsPane.addToggleGroup(this._volumeTrimActionMode, {
                    title: "resourcePack.editor.selectionTool.trimAction.title",
                    tooltip: "resourcePack.editor.selectionTool.trimAction.tooltip",
                    hiddenLabel: false,
                    entries: [ {
                        value: TrimActionMode.TrimVolume,
                        label: "resourcePack.editor.selectionTool.trimAction.trimVolume",
                        icon: "objectIcon",
                        tooltip: "resourcePack.editor.selectionTool.trimAction.trimVolume.tooltip"
                    }, {
                        value: TrimActionMode.RemoveAir,
                        label: "resourcePack.editor.selectionTool.trimAction.removeAir",
                        icon: "scaleIcon",
                        tooltip: "resourcePack.editor.selectionTool.trimAction.removeAir.tooltip"
                    }, {
                        value: TrimActionMode.Hollow,
                        label: "resourcePack.editor.selectionTool.trimAction.trimHollow",
                        icon: "enderEyeIcon",
                        tooltip: "resourcePack.editor.selectionTool.trimAction.trimHollow.tooltip"
                    } ],
                    onChange: (_newValue, _oldValue) => {
                        this._volumeTrimActionMode.set(TrimActionMode.Invalid);
                        switch (_newValue) {
                          case TrimActionMode.TrimVolume:
                            trimVolumeAction.onExecute();
                            break;

                          case TrimActionMode.RemoveAir:
                            trimAirAction.onExecute();
                            break;

                          case TrimActionMode.Hollow:
                            trimHollowAction.onExecute();
                            break;
                        }
                    }
                });
                this._registerToolKeyBinding(trimVolumeAction, {
                    key: server_editor_namespaceObject.KeyboardKey.UNDEFINED
                }, "trimVolume");
                this._registerToolKeyBinding(trimAirAction, {
                    key: server_editor_namespaceObject.KeyboardKey.UNDEFINED
                }, "trimRemoveAir");
                this._registerToolKeyBinding(trimHollowAction, {
                    key: server_editor_namespaceObject.KeyboardKey.UNDEFINED
                }, "trimHollow");
                this._volumeTrimActionsSettingsPane = this._volumeTrimActionsPane.createSubPane({
                    title: "resourcePack.editor.selectionTool.trimAction.trimVolume.SettingsPane.title",
                    infoTooltip: {
                        title: "resourcePack.editor.selectionTool.trimAction.trimVolume.SettingsPane.title",
                        description: [ "resourcePack.editor.selectionTool.trimAction.trimVolume.SettingsPane.tooltip" ]
                    },
                    hasExpander: true,
                    collapsed: true,
                    hasMargins: false
                });
                const ignoreLiquidUIElement = this._volumeTrimActionsSettingsPane.addBool(this._volumeTrimIgnoreLiquid, {
                    title: "resourcePack.editor.selectionTool.trimAction.trimVolume.SettingsPane.ignoreLiquid",
                    tooltip: "resourcePack.editor.selectionTool.trimAction.trimVolume.SettingsPane.ignoreLiquid.tooltip",
                    variant: server_editor_namespaceObject.BoolPropertyItemVariant.ToggleSwitch
                });
                const collisionOnlyUIElement = this._volumeTrimActionsSettingsPane.addBool(this._volumeTrimOnlyCollision, {
                    title: "resourcePack.editor.selectionTool.trimAction.trimVolume.SettingsPane.onlyCollidable",
                    tooltip: "resourcePack.editor.selectionTool.trimAction.trimVolume.SettingsPane.onlyCollidable.tooltip",
                    variant: server_editor_namespaceObject.BoolPropertyItemVariant.ToggleSwitch
                });
                this._blockMaskSharedControl = new BlockMaskSharedControl(this.session, this.tool, this._volumeTrimActionsSettingsPane, "trim", (_mode => {
                    if (_mode === BlockMaskControlMaskMode.Disabled) {
                        ignoreLiquidUIElement.enable = true;
                        collisionOnlyUIElement.enable = true;
                    } else {
                        ignoreLiquidUIElement.enable = false;
                        collisionOnlyUIElement.enable = false;
                    }
                }));
                this._blockMaskSharedControl.initialize();
                this._blockMaskSharedControl.activateControl();
            };
            this._addTool = (uiSession, action) => {
                const tool = uiSession.toolRail.addTool("editor:modalTool:selection", {
                    title: "resourcePack.editor.selectionTool.toolRail.title",
                    icon: "pack://textures/editor/marquee.png?filtering=point",
                    tooltip: {
                        description: "resourcePack.editor.selectionTool.toolRail.description",
                        image: "pack://textures/editor/Selection.gif"
                    },
                    action
                });
                tool.onModalToolActivation.subscribe((eventData => {
                    if (eventData.isActiveTool) {
                        this._backedUpColors = backupColors(uiSession.extensionContext);
                        uiSession.extensionContext.cursor.setProperties(this._toolCursorProperties);
                    } else {
                        if (this._backedUpColors) {
                            restoreBackedUpColors(uiSession.extensionContext, this._backedUpColors);
                            this._backedUpColors = undefined;
                        }
                    }
                }));
                return tool;
            };
            this._bindGlobalActivationShortcut = uiSession => {
                uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, this._toggleAction, {
                    key: server_editor_namespaceObject.KeyboardKey.KEY_S,
                    modifier: server_editor_namespaceObject.InputModifier.Control
                }, {
                    uniqueId: "editor:toolModeKeyBinding:toggleSelection",
                    label: "resourcePack.editor.selectionTool.keyBinding.toggleTool.title",
                    tooltip: "resourcePack.editor.selectionTool.keyBinding.toggleTool.tooltip"
                });
                this._fillActionBarItem = uiSession.actionBar.registerItem(server_editor_namespaceObject.CoreActionBarItemType.Fill, this._executeFillAction, {
                    label: "resourcePack.editor.actionBar.fill",
                    icon: "pack://textures/editor/Fill.png",
                    tooltipTitle: "resourcePack.editor.actionBar.fill.tooltipTitle",
                    tooltipDescription: "resourcePack.editor.actionBar.fill.tooltipDescription",
                    enabled: !uiSession.extensionContext.selectionManager.volume.isEmpty
                });
                uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, this._executeFillAction, {
                    key: server_editor_namespaceObject.KeyboardKey.KEY_F,
                    modifier: server_editor_namespaceObject.InputModifier.Control
                }, {
                    uniqueId: "editor:toolModeKeyBinding:fillSelection",
                    label: "resourcePack.editor.selectionTool.keyBinding.fill.title",
                    tooltip: "resourcePack.editor.selectionTool.keyBinding.fill.tooltip"
                });
                uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, this._deselectAction, {
                    key: server_editor_namespaceObject.KeyboardKey.KEY_D,
                    modifier: server_editor_namespaceObject.InputModifier.Control
                }, {
                    uniqueId: "editor:toolModeKeyBinding:deselectSelection",
                    label: "resourcePack.editor.selectionTool.keyBinding.deselect.title",
                    tooltip: "resourcePack.editor.selectionTool.keyBinding.deselect.tooltip"
                });
            };
            this._performFillOperation = async (session, context) => {
                if (context.selectionManager.volume.isEmpty) {
                    session.log.warning("No selection available to fill");
                    return;
                }
                const onError = e => {
                    session.log.error(`Fill operation failed with error: ${e.message}`, {
                        channelMask: server_editor_namespaceObject.LogChannel.All
                    });
                };
                const volume = context.selectionManager.volume.get();
                await executeFunctionWithTransactionAndTicking(session.extensionContext, session.log, volume, "Select-Fill", (() => {
                    session.extensionContext.blockUtilities.fillVolume(volume);
                })).catch(onError);
            };
            this._internalChangeVolumeContentsNotification = () => {
                this._marqueeModeImplementation?.onExternalSelectionChanged({});
                this._freehandModeImplementation?.onExternalSelectionChanged({});
                this._magicModeImplementation?.onExternalSelectionChanged({});
                if (this.session.extensionContext.selectionManager.volume.volumeCount <= 1) {
                    if (this._selectionMode.value !== SelectionMode.Marquee) {
                        this._switchSelectionMode(SelectionMode.Marquee, true, false);
                    }
                } else if (this.session.extensionContext.selectionManager.volume.volumeCount > 1) {
                    if (this._selectionMode.value !== SelectionMode.Freehand) {
                        this._switchSelectionMode(SelectionMode.Freehand, true, false);
                    }
                }
            };
            this.performDeleteOperation = async session => {
                await deleteOperation(session);
            };
            const storage = uiSession.scratchStorage;
            if (!storage) {
                throw new Error("Can not instantiate Selection functionality without valid CoreEditor storage.");
            }
            this._telemetryManager = new TelemetryManager(uiSession.extensionContext.player, TelemetrySource.Selection);
            this._selectionMode = (0, server_editor_namespaceObject.makeObservable)(SelectionMode.Marquee);
            this._widgetGroup = this.session.extensionContext.widgetManager.createGroup({
                groupSelectionMode: server_editor_namespaceObject.WidgetGroupSelectionMode.None,
                visible: true
            });
            this._toolCursorProperties = {
                outlineColor: {
                    red: 1,
                    green: 1,
                    blue: 0,
                    alpha: 1
                },
                controlMode: server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse,
                targetMode: server_editor_namespaceObject.CursorTargetMode.Block,
                visible: true
            };
            this._colorBoundingBoxHull = this.session.extensionContext.settings.theme.resolveColorKey(server_editor_namespaceObject.ThemeSettingsColorKey.SelectionVolumeFill);
            this._colorBoundingBoxOutline = this.session.extensionContext.settings.theme.resolveColorKey(server_editor_namespaceObject.ThemeSettingsColorKey.SelectionVolumeBorder);
            this._colorOutlineBoxHull = this.session.extensionContext.settings.theme.resolveColorKey(server_editor_namespaceObject.ThemeSettingsColorKey.SelectionVolumeOutlineFill);
            this._colorOutlineBoxOutline = this.session.extensionContext.settings.theme.resolveColorKey(server_editor_namespaceObject.ThemeSettingsColorKey.SelectionVolumeOutlineBorder);
            this.debugLog(`Selection Tool initialized with colors:`);
            this.debugLog(`  BoundingBox Hull:${JSON.stringify(this._colorBoundingBoxHull)}, Outline:${JSON.stringify(this._colorBoundingBoxOutline)}`);
            this.debugLog(`  OutlineBox Hull:${JSON.stringify(this._colorOutlineBoxHull)}, Outline:${JSON.stringify(this._colorOutlineBoxOutline)}`);
            const themeChangeEventHandle = uiSession.extensionContext.afterEvents.currentThemeColorChange.subscribe((_event => {
                switch (_event.colorKey) {
                  case server_editor_namespaceObject.ThemeSettingsColorKey.SelectionVolumeFill:
                    this._colorBoundingBoxHull = _event.color;
                    this._activeModeImplementation?.onColorChangeEvent();
                    break;

                  case server_editor_namespaceObject.ThemeSettingsColorKey.SelectionVolumeBorder:
                    this._colorBoundingBoxOutline = _event.color;
                    this._activeModeImplementation?.onColorChangeEvent();
                    break;

                  case server_editor_namespaceObject.ThemeSettingsColorKey.SelectionVolumeOutlineFill:
                    this._colorOutlineBoxHull = _event.color;
                    this._activeModeImplementation?.onColorChangeEvent();
                    break;

                  case server_editor_namespaceObject.ThemeSettingsColorKey.SelectionVolumeOutlineBorder:
                    this._colorOutlineBoxOutline = _event.color;
                    this._activeModeImplementation?.onColorChangeEvent();
                    break;
                }
            }));
            this._cleanupHandles.push((() => uiSession.extensionContext.afterEvents.currentThemeColorChange.unsubscribe(themeChangeEventHandle)));
            this._transactionHandler = (0, server_editor_namespaceObject.registerUserDefinedTransactionHandler)(this.session.extensionContext.transactionManager, (_payload => {
                const oldStack = _payload.oldVolumeStack;
                this._switchSelectionMode(oldStack.mode, true, true);
                this._activeModeImplementation?.applyUndo(oldStack);
            }), (_payload => {
                const newStack = _payload.newVolumeStack;
                this._switchSelectionMode(newStack.mode, true, true);
                this._activeModeImplementation?.applyRedo(newStack);
            }));
            this._toggleAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    if (uiSession.toolRail.getSelectedToolId() === this._tool.id) {
                        this.cycleSelectionMode();
                    } else {
                        uiSession.toolRail.setSelectedToolId(this._tool.id);
                    }
                }
            });
            this._executeFillAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this._telemetryManager.fireTelemetryEvent(SelectionTelemetry.FillSelection);
                    this._performFillOperation(uiSession, uiSession.extensionContext).catch((e => uiSession.log.error(e.message, {
                        channelMask: server_editor_namespaceObject.LogChannel.All
                    })));
                }
            });
            this._deselectAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this._telemetryManager.fireTelemetryEvent(SelectionTelemetry.Deselect);
                    this.clearSelection();
                }
            });
            this._tool = this._addTool(uiSession, this._toggleAction);
            this._rootPane = uiSession.createPropertyPane({
                title: "resourcePack.editor.selectionTool.settingsPane.title",
                infoTooltip: {
                    description: [ "resourcePack.editor.selectionTool.toolRail.description", {
                        link: "https://aka.ms/BedrockEditorSelection",
                        text: "resourcePack.editor.help.learnMore"
                    } ]
                }
            });
            this._tool.bindPropertyPane(this._rootPane);
            this._addModeSelectionControls(uiSession, this._rootPane);
            this._rootPane.addDivider();
            this._addVolumeTrimActionControls(uiSession, this._rootPane);
            this._rootPane.addDivider();
            this._addCursorControls(uiSession, this._rootPane);
            this._rootPane.addDivider();
            this._modeHolderPane = this._rootPane.createSubPane({
                title: "Hidden Mode Holder Pane",
                hasExpander: false
            });
            this._marqueeModeImplementation = new SelectionModeMarquee(this._modeHolderPane, this);
            this._freehandModeImplementation = new SelectionModeFreehand(this._modeHolderPane, this);
            this._magicModeImplementation = new SelectionModeMagic(this._modeHolderPane, this);
            this._activeModeImplementation = this._marqueeModeImplementation;
            this._activeModeImplementation.activate(true);
            this._selectionMode.set(SelectionMode.Marquee);
            this._tool.onModalToolActivation.subscribe((eventData => {
                if (eventData.isActiveTool) {
                    if (this.session.extensionContext.selectionManager.volume.volumeCount <= 1) {
                        if (this._selectionMode.value !== SelectionMode.Marquee) {
                            this._switchSelectionMode(SelectionMode.Marquee, false, false);
                        } else {
                            this._activeModeImplementation?.activate(true);
                        }
                    } else if (this.session.extensionContext.selectionManager.volume.volumeCount > 1) {
                        if (this._selectionMode.value === SelectionMode.Marquee) {
                            this._switchSelectionMode(SelectionMode.Freehand, false, false);
                        } else {
                            this._activeModeImplementation?.activate(true);
                        }
                    } else {
                        this._activeModeImplementation?.activate(true);
                    }
                    this._cursorModeSharedControl?.activateControl();
                } else {
                    this._activeModeImplementation?.deactivate(true, false);
                    this._cursorModeSharedControl?.deactivateControl();
                }
            }));
            this.bindToolInput(uiSession);
            this._bindGlobalActivationShortcut(uiSession);
            server_namespaceObject.system.runTimeout((() => uiSession.toolRail.setSelectedToolId(this._tool.id)));
            const selectionChangeEventHandle = uiSession.extensionContext.afterEvents.SelectionChange.subscribe((event => {
                if (this._tool.id !== this.session.toolRail.getSelectedToolId()) {
                    if (event.volumeEventData) {
                        let type = "";
                        switch (event.volumeEventData.type) {
                          case server_editor_namespaceObject.SelectionVolumeEventType.Add:
                            type = "Add";
                            break;

                          case server_editor_namespaceObject.SelectionVolumeEventType.Remove:
                            type = "Remove";
                            break;

                          case server_editor_namespaceObject.SelectionVolumeEventType.Set:
                            type = "Set";
                            break;

                          case server_editor_namespaceObject.SelectionVolumeEventType.Clear:
                            type = "Clear";
                            break;

                          case server_editor_namespaceObject.SelectionVolumeEventType.Translate:
                            type = "Translate";
                            break;

                          case server_editor_namespaceObject.SelectionVolumeEventType.Move:
                            type = "Move";
                            break;
                        }
                        this.debugLog(`Selection was changed!! (${type})`);
                        this._internalChangeVolumeContentsNotification();
                    }
                }
                const enableFill = !uiSession.extensionContext.selectionManager.volume.isEmpty;
                if (this._fillActionBarItem && enableFill !== this._fillActionBarItem.getEnabled()) {
                    this._fillActionBarItem.setEnabled(enableFill);
                }
            }));
            this._cleanupHandles.push((() => uiSession.extensionContext.afterEvents.SelectionChange.unsubscribe(selectionChangeEventHandle)));
            this.uiSession.eventSubscriptionCache.subscribeToBedrockEvent("playerDimensionChange", (event => {
                if (event.player.id === uiSession.extensionContext.player.id) {
                    uiSession.extensionContext.selectionManager.volume.clear();
                    this._marqueeModeImplementation.onDimensionChange();
                    this._freehandModeImplementation.onDimensionChange();
                    this._magicModeImplementation.onDimensionChange();
                }
            }));
        }
        performSingleTransactionableOperation(_operation, _name) {
            if (this._temporaryTransactionData !== undefined) {
                throw new Error("Cannot perform a transactionable operation while a transaction is active");
            }
            if (this._activeModeImplementation === undefined) {
                throw new Error("Cannot perform a transactionable operation while no mode is active");
            }
            this._temporaryTransactionData = {
                oldVolumeStack: {
                    mode: SelectionMode.Marquee,
                    volumes: []
                },
                newVolumeStack: {
                    mode: SelectionMode.Marquee,
                    volumes: []
                },
                name: _name
            };
            this._activeModeImplementation?.fillTransactionPayload(this._temporaryTransactionData.oldVolumeStack);
            try {
                const completedOK = _operation();
                if (!completedOK) {
                    throw new Error("Operation failed");
                }
                this._activeModeImplementation?.fillTransactionPayload(this._temporaryTransactionData.newVolumeStack);
                this.createTransaction(this._temporaryTransactionData, _name);
                this._temporaryTransactionData = undefined;
            } catch (_e) {
                this._temporaryTransactionData = undefined;
            }
        }
        beginTransactionableOperation(_name) {
            if (this._temporaryTransactionData !== undefined) {
                throw new Error("Cannot begin a transactionable operation while a transaction is active");
            }
            if (this._activeModeImplementation === undefined) {
                throw new Error("Cannot begin a transactionable operation while no mode is active");
            }
            this._temporaryTransactionData = {
                oldVolumeStack: {
                    mode: SelectionMode.Marquee,
                    volumes: []
                },
                newVolumeStack: {
                    mode: SelectionMode.Marquee,
                    volumes: []
                },
                name: _name
            };
            this._activeModeImplementation?.fillTransactionPayload(this._temporaryTransactionData.oldVolumeStack);
        }
        endTransactionableOperation() {
            if (this._temporaryTransactionData === undefined) {
                throw new Error("Cannot end a transactionable operation without a begin");
            }
            if (this._activeModeImplementation === undefined) {
                throw new Error("Cannot end a transactionable operation while no mode is active");
            }
            this._activeModeImplementation?.fillTransactionPayload(this._temporaryTransactionData.newVolumeStack);
            this.createTransaction(this._temporaryTransactionData, this._temporaryTransactionData.name ?? "Selection (unnamed)");
            this._temporaryTransactionData = undefined;
        }
        cancelTransactionableOperation() {
            this._temporaryTransactionData = undefined;
        }
        createTransaction(_payload, _name) {
            this.session.extensionContext.transactionManager.openTransaction("Selection");
            this.transactionHandler.addUserDefinedOperation(_payload, _name);
            this.session.extensionContext.transactionManager.commitOpenTransaction();
        }
        isTransactionOperationActive() {
            return this._temporaryTransactionData !== undefined;
        }
        _addCursorControls(_uiSession, _rootPane) {
            this._cursorControlHolderPane = _rootPane.createSubPane({
                title: "Hidden Cursor Control Holder Pane",
                hasExpander: false
            });
            const bindManualControls = true;
            this._cursorModeSharedControl = new CursorModeControl(_uiSession, this._tool, this._cursorControlHolderPane, bindManualControls, this._toolCursorProperties, {
                hasPaneMargins: false
            });
            this._cursorModeSharedControl.initialize();
        }
        teardown() {
            if (this._activeModeImplementation) {
                this._activeModeImplementation.deactivate(this.uiSession.toolRail.getSelectedToolId() === this.toolId, false);
                this._activeModeImplementation = undefined;
            }
            this._marqueeModeImplementation.teardown();
            this._freehandModeImplementation.teardown();
            this._magicModeImplementation.teardown();
            if (this._cursorModeSharedControl && this._cursorModeSharedControl.isActive) {
                this._cursorModeSharedControl.deactivateControl();
            }
            this.uiSession.extensionContext.selectionManager.volume.clear();
            this._widgetGroup.delete();
            this._cleanupHandles.forEach((handle => handle()));
        }
        cycleSelectionMode() {
            switch (this._selectionMode.value) {
              case SelectionMode.Marquee:
                this._switchSelectionMode(SelectionMode.Freehand, true);
                break;

              case SelectionMode.Freehand:
                this._switchSelectionMode(SelectionMode.MagicSelect, true);
                break;

              case SelectionMode.MagicSelect:
                this._switchSelectionMode(SelectionMode.Marquee, true);
                break;

              default:
                throw new Error("Unknown selection mode requested");
            }
        }
        _switchSelectionMode(_newMode, userInitiated = false, _clearActiveVolumeStack = true) {
            if (_newMode === undefined || this._activeModeImplementation?.modeType !== _newMode) {
                if (userInitiated) {
                    this._activeModeImplementation?.deactivate(this.isActiveTool, _clearActiveVolumeStack);
                }
                this._activeModeImplementation = undefined;
            }
            if (_newMode === undefined || _newMode === this._activeModeImplementation?.modeType) {
                return;
            }
            switch (_newMode) {
              case SelectionMode.Marquee:
                this._telemetryManager.fireTelemetryEvent(SelectionTelemetry.ModeChanged, {
                    mode: "Marquee"
                }, userInitiated);
                this._activeModeImplementation = this._marqueeModeImplementation;
                this._activeModeImplementation.activate(this.isActiveTool);
                break;

              case SelectionMode.Freehand:
                this._telemetryManager.fireTelemetryEvent(SelectionTelemetry.ModeChanged, {
                    mode: "Paint"
                }, userInitiated);
                this._activeModeImplementation = this._freehandModeImplementation;
                this._activeModeImplementation.activate(this.isActiveTool);
                break;

              case SelectionMode.MagicSelect:
                this._telemetryManager.fireTelemetryEvent(SelectionTelemetry.ModeChanged, {
                    mode: "Magic"
                }, userInitiated);
                this._activeModeImplementation = this._magicModeImplementation;
                this._activeModeImplementation.activate(this.isActiveTool);
                break;

              default:
                throw new Error("Unknown selection mode requested");
            }
            this._selectionMode.set(this._activeModeImplementation?.modeType);
        }
        _registerToolKeyBinding(action, binding, tag) {
            this._tool.registerKeyBinding(action, binding, {
                uniqueId: `editor:selectionToolKeyBinding:${tag}`,
                label: `resourcePack.editor.selectionTool.keyBinding.${tag}.title`,
                tooltip: `resourcePack.editor.selectionTool.keyBinding.${tag}.tooltip`
            });
        }
        async _performTrimOperation(session, context) {
            if (context.selectionManager.volume.isEmpty) {
                session.log.warning("No selection available to trim");
                return;
            }
            const onError = e => {
                session.log.error(`Trim operation failed with error: ${e.message}`, {
                    channelMask: server_editor_namespaceObject.LogChannel.All
                });
            };
            const volume = context.selectionManager.volume.get();
            let bounds;
            try {
                bounds = volume.getBoundingBox();
            } catch (_e) {
                this.debugLog("Failed to get bounding box for volume to trim");
                return;
            }
            const boundsCopy = server_namespaceObject.BlockBoundingBoxUtils.createValid(bounds.min, bounds.max);
            await executeTickSafeOperation(session.extensionContext, session.log, boundsCopy, (() => {
                this.performSingleTransactionableOperation((() => {
                    const retainMarqueeAfterTrimming = true;
                    const ignoreLiquid = this._volumeTrimIgnoreLiquid.value;
                    const ignoreNoCollision = this._volumeTrimOnlyCollision.value;
                    const blockMask = this._blockMaskSharedControl?.getBlockMask();
                    const newVolume = this.session.extensionContext.blockUtilities.trimVolumeToFitContents(volume, retainMarqueeAfterTrimming, ignoreLiquid, ignoreNoCollision, blockMask);
                    if (newVolume.isEmpty) {
                        context.selectionManager.volume.clear();
                    } else {
                        context.selectionManager.volume.set(newVolume);
                    }
                    return true;
                }), "Trim Volume");
                this._internalChangeVolumeContentsNotification();
            })).catch(onError);
        }
        async _performRemoveAirOperation(session, context) {
            if (context.selectionManager.volume.isEmpty) {
                session.log.warning("No selection available to remove air");
                return;
            }
            const onError = e => {
                session.log.error(`Remove air operation failed with error: ${e.message}`, {
                    channelMask: server_editor_namespaceObject.LogChannel.All
                });
            };
            const volume = context.selectionManager.volume.get();
            let bounds;
            try {
                bounds = volume.getBoundingBox();
            } catch (_e) {
                this.debugLog("Failed to get bounding box for volume to remove air");
                return;
            }
            const boundsCopy = server_namespaceObject.BlockBoundingBoxUtils.createValid(bounds.min, bounds.max);
            await executeTickSafeOperation(session.extensionContext, session.log, boundsCopy, (() => {
                this.performSingleTransactionableOperation((() => {
                    const retainMarqueeAfterTrimming = false;
                    const ignoreLiquid = this._volumeTrimIgnoreLiquid.value;
                    const ignoreNoCollision = this._volumeTrimOnlyCollision.value;
                    const blockMask = this._blockMaskSharedControl?.getBlockMask();
                    const newVolume = this.session.extensionContext.blockUtilities.trimVolumeToFitContents(volume, retainMarqueeAfterTrimming, ignoreLiquid, ignoreNoCollision, blockMask);
                    if (newVolume.isEmpty) {
                        context.selectionManager.volume.clear();
                    } else {
                        context.selectionManager.volume.set(newVolume);
                    }
                    return true;
                }), "Remove Air");
                this._internalChangeVolumeContentsNotification();
            })).catch(onError);
        }
        async _performHollowOperation(session, context) {
            if (context.selectionManager.volume.isEmpty) {
                session.log.warning("No selection available to hollow");
                return;
            }
            const onError = e => {
                session.log.error(`Hollow operation failed with error: ${e.message}`, {
                    channelMask: server_editor_namespaceObject.LogChannel.All
                });
            };
            const volume = context.selectionManager.volume.get();
            let bounds;
            try {
                bounds = volume.getBoundingBox();
            } catch (_e) {
                this.debugLog("Failed to get bounding box for volume to hollow");
                return;
            }
            const boundsCopy = server_namespaceObject.BlockBoundingBoxUtils.createValid(bounds.min, bounds.max);
            await executeTickSafeOperation(session.extensionContext, session.log, boundsCopy, (() => {
                this.performSingleTransactionableOperation((() => {
                    const newVolume = this.session.extensionContext.blockUtilities.findObscuredBlocksWithinVolume(volume);
                    if (newVolume.isEmpty) {
                        this.session.log.info("Current Volume could not be hollowed out");
                    } else {
                        context.selectionManager.volume.set(newVolume);
                    }
                    return true;
                }), "Hollow Volume");
                this._internalChangeVolumeContentsNotification();
            })).catch(onError);
        }
        debugLog(_message) {}
        clearSelection() {
            this._activeModeImplementation?.clearSelection();
            this._freehandModeImplementation._clearVolumeStack();
            this._marqueeModeImplementation._clearVolumeStack();
        }
    }
    class UndoRedoBehavior {
        constructor(uiSession, coreMenuItems) {
            this._canUndo = false;
            this._canRedo = false;
            this._transactionManager = uiSession.extensionContext.transactionManager;
            this._canUndo = this._transactionManager.undoSize() > 0;
            this._canRedo = this._transactionManager.redoSize() > 0;
            const undoAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this._transactionManager.undo();
                }
            });
            const redoAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this._transactionManager.redo();
                }
            });
            this._undoMenuItem = coreMenuItems.edit.addItem({
                label: "resourcePack.editor.menuBar.edit.undo",
                enabled: this._canUndo,
                tooltip: "resourcePack.editor.menuBar.edit.undo.tooltip"
            }, undoAction);
            this._redoMenuItem = coreMenuItems.edit.addItem({
                label: "resourcePack.editor.menuBar.edit.redo",
                enabled: this._canRedo,
                tooltip: "resourcePack.editor.menuBar.edit.redo.tooltip"
            }, redoAction);
            this._undoActionBarItem = uiSession.actionBar.registerItem(server_editor_namespaceObject.CoreActionBarItemType.Undo, undoAction, {
                label: "resourcePack.editor.actionBar.undo",
                icon: "undoIcon",
                tooltipTitle: "resourcePack.editor.actionBar.undo.tooltipTitle",
                tooltipDescription: "resourcePack.editor.actionBar.undo.tooltipDescription",
                enabled: this._canUndo
            });
            this._redoActionBarItem = uiSession.actionBar.registerItem(server_editor_namespaceObject.CoreActionBarItemType.Redo, redoAction, {
                label: "resourcePack.editor.actionBar.redo",
                icon: "redoIcon",
                tooltipTitle: "resourcePack.editor.actionBar.redo.tooltipTitle",
                tooltipDescription: "resourcePack.editor.actionBar.redo.tooltipDescription",
                enabled: this._canRedo
            });
            uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalEditor, undoAction, {
                key: server_editor_namespaceObject.KeyboardKey.KEY_Z,
                modifier: server_editor_namespaceObject.InputModifier.Control
            }, {
                uniqueId: "editor:globalKeyBinding:undo",
                label: "resourcePack.editor.transaction.keyBinding.undo.title",
                tooltip: "resourcePack.editor.transaction.keyBinding.undo.tooltip"
            });
            uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalEditor, redoAction, {
                key: server_editor_namespaceObject.KeyboardKey.KEY_Y,
                modifier: server_editor_namespaceObject.InputModifier.Control
            }, {
                uniqueId: "editor:globalKeyBinding:redo",
                label: "resourcePack.editor.transaction.keyBinding.redo.title",
                tooltip: "resourcePack.editor.transaction.keyBinding.redo.tooltip"
            });
            this.updateHandle = server_namespaceObject.system.runInterval((() => {
                this._checkUndoRedoState();
            }), server_namespaceObject.TicksPerSecond / 2);
        }
        _checkUndoRedoState() {
            const canUndo = this._transactionManager.undoSize() > 0;
            const canRedo = this._transactionManager.redoSize() > 0;
            if (canUndo !== this._canUndo) {
                if (this._undoActionBarItem) {
                    this._undoActionBarItem.setEnabled(canUndo);
                }
                if (this._undoMenuItem) {
                    this._undoMenuItem.enabled = canUndo;
                }
                this._canUndo = canUndo;
            }
            if (canRedo !== this._canRedo) {
                if (this._redoActionBarItem) {
                    this._redoActionBarItem.setEnabled(canRedo);
                }
                if (this._redoMenuItem) {
                    this._redoMenuItem.enabled = canRedo;
                }
                this._canRedo = canRedo;
            }
        }
        teardown() {
            if (this.updateHandle) {
                server_namespaceObject.system.clearRun(this.updateHandle);
            }
        }
    }
    var SummonTelemetry;
    (function(SummonTelemetry) {
        SummonTelemetry["Create"] = "Create";
        SummonTelemetry["Delete"] = "Delete";
        SummonTelemetry["Clear"] = "Clear";
        SummonTelemetry["Nudge"] = "Nudge";
        SummonTelemetry["Undo"] = "Undo";
        SummonTelemetry["Redo"] = "Redo";
        SummonTelemetry["PickerUpdated"] = "PickerUpdated";
        SummonTelemetry["Select"] = "Select";
        SummonTelemetry["SelectMove"] = "SelectMove";
        SummonTelemetry["MoveCompleted"] = "MoveCompleted";
    })(SummonTelemetry || (SummonTelemetry = {}));
    const ROTATION_SCROLL_STEP_DEGREES = 10;
    class SummonTool {
        constructor(session) {
            this.NUDGE_REPEAT_INTERVAL = 5;
            this._nudgeActions = [];
            this._activeNudgeActions = new Set([]);
            this._isWidgetMoving = false;
            this._session = session;
            this._cursorProperties = {
                outlineColor: {
                    red: 1,
                    green: 1,
                    blue: 0,
                    alpha: 1
                },
                controlMode: server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse,
                targetMode: server_editor_namespaceObject.CursorTargetMode.Face,
                visible: true,
                fixedModeDistance: 5
            };
            this.telemetryManager = new TelemetryManager(session.extensionContext.player, TelemetrySource.Summon);
            const dimensionBounds = this._session.extensionContext.blockUtilities.getDimensionLocationBoundingBox();
            const center = server_namespaceObject.BlockBoundingBoxUtils.getCenter(dimensionBounds);
            this._widgetGroup = this._session.extensionContext.widgetManager.createGroup({
                visible: true
            });
            this._widget = this._widgetGroup.createWidget(center, {
                visible: false,
                selectable: true,
                snapToBlockLocation: false,
                widgetName: "summonToolWidget"
            });
            this._widget.addGizmoComponent("entity_gizmo", {
                offset: {
                    x: 0,
                    y: .5,
                    z: 0
                },
                visible: true,
                stateChangeEvent: data => {
                    if (!this._selectedEntity || !data.widget.location) return;
                    if ((data.eventType === server_editor_namespaceObject.WidgetGizmoEventType.CornerMoved || data.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginMoved) && !this._isWidgetMoving) {
                        this._isWidgetMoving = true;
                        this._widgetMoveStartLocation = {
                            ...this._selectedEntity.location
                        };
                    }
                    if (data.eventType === server_editor_namespaceObject.WidgetGizmoEventType.CornerMoved || data.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginMoved) {
                        this._selectedEntity.teleport(data.widget.location);
                    }
                    if (this._isWidgetMoving && (data.eventType === server_editor_namespaceObject.WidgetGizmoEventType.OriginReleased || data.eventType === server_editor_namespaceObject.WidgetGizmoEventType.CornerReleased)) {
                        const manager = this._session.extensionContext.transactionManager;
                        manager.openTransaction("Summon Tool - Move Entity");
                        this.telemetryManager.fireTelemetryEvent(SummonTelemetry.MoveCompleted, {
                            mode: "Begin"
                        });
                        try {
                            const oldLocation = this._widgetMoveStartLocation ?? this._selectedEntity.location;
                            const newLocation = this._selectedEntity.location;
                            const transactionPayload = {
                                entityID: this._selectedEntity.id,
                                oldLocation,
                                newLocation
                            };
                            this.telemetryManager.fireTelemetryEvent(SummonTelemetry.MoveCompleted, {
                                mode: "End"
                            });
                            this._moveTransactionHandler.addUserDefinedOperation(transactionPayload, "Entity Move");
                        } catch (e) {
                            this._session.log.error(`Unable to commit move entity transaction. ${stringFromException(e)}`, {
                                channelMask: server_editor_namespaceObject.LogChannel.All
                            });
                            manager.discardOpenTransaction();
                            this._isWidgetMoving = false;
                            this._widgetMoveStartLocation = undefined;
                            return;
                        }
                        manager.commitOpenTransaction();
                        this._isWidgetMoving = false;
                        this._widgetMoveStartLocation = undefined;
                    }
                }
            });
            this._session.log.debug("hello");
            const activationAction = this._session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this._session.toolRail.setSelectedToolId(this._tool.id);
                }
            });
            this._tool = this._session.toolRail.addTool("editor:modalTool:summon", {
                title: "resourcePack.editor.toolRail.summonTool.tool.title",
                icon: "pack://textures/editor/Entity.png?filtering=point",
                tooltip: {
                    description: "resourcePack.editor.toolRail.summonTool.tool.tip",
                    image: "pack://textures/editor/Summon.gif"
                },
                action: activationAction
            });
            this._tool.onModalToolActivation.subscribe((eventData => {
                if (eventData.isActiveTool) {
                    this._backedUpColors = backupColors(session.extensionContext);
                    this._session.extensionContext.cursor.setProperties(this._cursorProperties);
                } else {
                    if (this._isWidgetMoving) {
                        const manager = this._session.extensionContext.transactionManager;
                        manager.discardOpenTransaction();
                        this._isWidgetMoving = false;
                        this._widgetMoveStartLocation = undefined;
                    }
                    this.shutdownMouseWatcher();
                    this.clearSelection();
                    if (this._backedUpColors) {
                        restoreBackedUpColors(session.extensionContext, this._backedUpColors);
                        this._backedUpColors = undefined;
                    }
                }
            }));
            this._createTransactionHandler = (0, server_editor_namespaceObject.registerUserDefinedTransactionHandler)(this._session.extensionContext.transactionManager, (() => {
                this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Undo, {
                    mode: "Clear"
                });
                this.clearSelection();
            }), (payload => {
                this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Redo, {
                    mode: "Create"
                });
                const entity = server_namespaceObject.world.getEntity(payload.entityID);
                if (entity) {
                    this.selectEntity(entity);
                }
            }));
            this._deleteTransactionHandler = (0, server_editor_namespaceObject.registerUserDefinedTransactionHandler)(this._session.extensionContext.transactionManager, (payload => {
                this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Undo, {
                    mode: "Create"
                });
                const entity = server_namespaceObject.world.getEntity(payload.entityID);
                if (entity) {
                    this.selectEntity(entity);
                }
            }), (() => {
                this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Redo, {
                    mode: "Clear"
                });
                this.clearSelection();
            }));
            this._moveTransactionHandler = (0, server_editor_namespaceObject.registerUserDefinedTransactionHandler)(this._session.extensionContext.transactionManager, (payload => {
                const entity = server_namespaceObject.world.getEntity(payload.entityID);
                if (entity) {
                    entity.teleport(payload.oldLocation);
                    this.selectEntity(entity);
                }
            }), (payload => {
                const entity = server_namespaceObject.world.getEntity(payload.entityID);
                if (entity) {
                    entity.teleport(payload.newLocation);
                    this.selectEntity(entity);
                }
            }));
            this._session.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, activationAction, {
                key: server_editor_namespaceObject.KeyboardKey.KEY_S,
                modifier: server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift
            }, {
                uniqueId: "editor:toolModeKeyBinding:toggleSummonTool",
                label: "resourcePack.editor.toolRail.summonTool.keyBinding.toggle.title",
                tooltip: "resourcePack.editor.toolRail.summonTool.keyBinding.toggle.tooltip"
            });
            this._registerToolKeyBinding(this._session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    if (this._selectedEntity) {
                        this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Delete);
                        const manager = this._session.extensionContext.transactionManager;
                        manager.openTransaction("Summon Tool - Delete Entity");
                        try {
                            if (this._selectedEntity) {
                                const transactionPayload = {
                                    entityID: this._selectedEntity.id
                                };
                                this._deleteTransactionHandler.addUserDefinedOperation(transactionPayload, "Entity Delete");
                                manager.addEntityOperation(this._selectedEntity, server_editor_namespaceObject.EntityOperationType.Delete);
                            }
                        } catch (e) {
                            this._session.log.warning(`Unable to commit delete entity transaction. ${stringFromException(e)}`);
                            manager.discardOpenTransaction();
                            return;
                        }
                        manager.commitOpenTransaction();
                        try {
                            this._selectedEntity.remove();
                        } catch (e) {
                            this._session.log.error(`${stringFromException(e)}`, {
                                channelMask: server_editor_namespaceObject.LogChannel.All
                            });
                        } finally {
                            this.clearSelection();
                        }
                    }
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.DELETE
            }, "delete");
            this._registerToolKeyBinding(this._session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Clear);
                    this.clearSelection();
                }
            }), {
                key: server_editor_namespaceObject.KeyboardKey.KEY_D,
                modifier: server_editor_namespaceObject.InputModifier.Control
            }, "clear");
            const keyUpAction = this._session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                onExecute: state => {
                    if (state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                        this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Nudge, {
                            direction: "up"
                        });
                        this.nudgeSelected(lib.VECTOR3_UP);
                    } else if (state === server_editor_namespaceObject.ContinuousActionState.Repeat) {
                        this.nudgeSelected(lib.VECTOR3_UP);
                    }
                    this.handleNudgeState(state, keyUpAction.id);
                },
                repeatInterval: this.NUDGE_REPEAT_INTERVAL
            });
            const keyDownAction = this._session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                onExecute: state => {
                    if (state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                        this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Nudge, {
                            direction: "down"
                        });
                        this.nudgeSelected(lib.VECTOR3_DOWN);
                    } else if (state === server_editor_namespaceObject.ContinuousActionState.Repeat) {
                        this.nudgeSelected(lib.VECTOR3_DOWN);
                    }
                    this.handleNudgeState(state, keyDownAction.id);
                },
                repeatInterval: this.NUDGE_REPEAT_INTERVAL
            });
            const keyLeftAction = this._session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                onExecute: state => {
                    const nudgeVector = this.getRelativeNudgeDirection(direction_Direction.Left);
                    if (state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                        this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Nudge, {
                            direction: "left"
                        });
                        this.nudgeSelected(nudgeVector);
                    } else if (state === server_editor_namespaceObject.ContinuousActionState.Repeat) {
                        this.nudgeSelected(nudgeVector);
                    }
                    this.handleNudgeState(state, keyDownAction.id);
                },
                repeatInterval: this.NUDGE_REPEAT_INTERVAL
            });
            const keyRightAction = this._session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                onExecute: state => {
                    const nudgeVector = this.getRelativeNudgeDirection(direction_Direction.Right);
                    if (state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                        this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Nudge, {
                            direction: "right"
                        });
                        this.nudgeSelected(nudgeVector);
                    } else if (state === server_editor_namespaceObject.ContinuousActionState.Repeat) {
                        this.nudgeSelected(nudgeVector);
                    }
                    this.handleNudgeState(state, keyDownAction.id);
                },
                repeatInterval: this.NUDGE_REPEAT_INTERVAL
            });
            const keyForwardAction = this._session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                onExecute: state => {
                    const nudgeVector = this.getRelativeNudgeDirection(direction_Direction.Forward);
                    if (state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                        this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Nudge, {
                            direction: "forward"
                        });
                        this.nudgeSelected(nudgeVector);
                    } else if (state === server_editor_namespaceObject.ContinuousActionState.Repeat) {
                        this.nudgeSelected(nudgeVector);
                    }
                    this.handleNudgeState(state, keyDownAction.id);
                },
                repeatInterval: this.NUDGE_REPEAT_INTERVAL
            });
            const keyBackAction = this._session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.ContinuousAction,
                onExecute: state => {
                    const nudgeVector = this.getRelativeNudgeDirection(direction_Direction.Back);
                    if (state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                        this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Nudge, {
                            direction: "back"
                        });
                        this.nudgeSelected(nudgeVector);
                    } else if (state === server_editor_namespaceObject.ContinuousActionState.Repeat) {
                        this.nudgeSelected(nudgeVector);
                    }
                    this.handleNudgeState(state, keyDownAction.id);
                },
                repeatInterval: this.NUDGE_REPEAT_INTERVAL
            });
            this._nudgeActions = [ keyUpAction, keyDownAction, keyLeftAction, keyRightAction, keyBackAction, keyForwardAction ];
            this._registerToolKeyBinding(keyForwardAction, {
                key: server_editor_namespaceObject.KeyboardKey.UP
            }, "moveForward");
            this._registerToolKeyBinding(keyBackAction, {
                key: server_editor_namespaceObject.KeyboardKey.DOWN
            }, "moveBack");
            this._registerToolKeyBinding(keyLeftAction, {
                key: server_editor_namespaceObject.KeyboardKey.LEFT
            }, "moveLeft");
            this._registerToolKeyBinding(keyRightAction, {
                key: server_editor_namespaceObject.KeyboardKey.RIGHT
            }, "moveRight");
            this._registerToolKeyBinding(keyUpAction, {
                key: server_editor_namespaceObject.KeyboardKey.PAGE_UP
            }, "moveUp");
            this._registerToolKeyBinding(keyDownAction, {
                key: server_editor_namespaceObject.KeyboardKey.PAGE_DOWN
            }, "moveDown");
            this._rotation = (0, server_editor_namespaceObject.makeObservable)(0);
            this._mouseMoveWatcherId = -1;
            {
                this._pane = this._session.createPropertyPane({
                    title: "resourcePack.editor.toolRail.summonTool.pane.title",
                    infoTooltip: {
                        description: [ "resourcePack.editor.toolRail.summonTool.tool.tip", {
                            link: "https://aka.ms/BedrockEditorSummonTool",
                            text: "resourcePack.editor.help.learnMore"
                        } ]
                    }
                });
                this._entityType = (0, server_editor_namespaceObject.makeObservable)(MinecraftEntityTypes.Pig);
                this._pane.addNumber(this._rotation, {
                    title: "resourcePack.editor.toolRail.summonTool.tool.selectSubPane.rotation",
                    tooltip: "resourcePack.editor.toolRail.summonTool.tool.selectSubPane.rotation.tooltip",
                    min: -180,
                    max: 180,
                    isInteger: true,
                    variant: server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider,
                    onChange: () => {
                        this.updateRotation();
                    }
                });
                this._pane.addText("resourcePack.editor.toolRail.summonTool.tool.infoText");
                this._pane.addComboBox(this._entityType, {
                    title: "resourcePack.editor.summonTool.summonSubPane.EntityPickerTitle",
                    tooltip: "resourcePack.editor.toolRail.summonTool.pane.type.tooltip",
                    dataType: server_editor_namespaceObject.ComboBoxPropertyItemDataType.Entity,
                    onChange: newValue => {
                        this.telemetryManager.fireTelemetryEvent(SummonTelemetry.PickerUpdated, {
                            entity: newValue
                        });
                    }
                });
                this._tool.bindPropertyPane(this._pane);
            }
            const executeMouseButtonAction = this._session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
                onExecute: (mouseRay, mouseProps) => {
                    if (mouseProps.mouseAction !== server_editor_namespaceObject.MouseActionType.LeftButton) {
                        return;
                    }
                    const buttonDown = mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonDown;
                    if (buttonDown) {
                        const player = this._session.extensionContext.player;
                        const dimension = player.dimension;
                        const entityHitList = dimension.getEntitiesFromRay(mouseRay.location, mouseRay.direction);
                        let hitEntity = undefined;
                        if (entityHitList.length > 1) {
                            hitEntity = entityHitList[1];
                            if (hitEntity.entity === this._selectedEntity) {
                                this.telemetryManager.fireTelemetryEvent(SummonTelemetry.SelectMove, {
                                    state: "Begin"
                                });
                                this.handleBeginSelectMove(mouseRay);
                            } else if (hitEntity.entity !== this._selectedEntity) {
                                this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Select);
                                this.selectEntity(hitEntity.entity);
                            }
                        } else {
                            this.telemetryManager.fireTelemetryEvent(SummonTelemetry.Create);
                            this.handleBeginSummonMode(mouseRay);
                        }
                    } else {
                        if (this._mouseMoveWatcherId >= 0) {
                            this.telemetryManager.fireTelemetryEvent(SummonTelemetry.SelectMove, {
                                state: "End"
                            });
                            this.handleEndSelectMove(mouseRay);
                        }
                    }
                }
            });
            this._tool.registerMouseButtonBinding(executeMouseButtonAction);
            const rotateEntityAction = this._session.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
                onExecute: (mouseRay, mouseProps) => {
                    if (!this._selectedEntity) {
                        return;
                    }
                    if (mouseProps.mouseAction === server_editor_namespaceObject.MouseActionType.Wheel && mouseProps.modifiers.shift) {
                        if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.WheelOut) {
                            const newRot = this._rotation.value + ROTATION_SCROLL_STEP_DEGREES;
                            this._rotation.set(newRot > 180 ? newRot - 360 : newRot);
                            this.updateRotation();
                        } else if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.WheelIn) {
                            const newRot = this._rotation.value - ROTATION_SCROLL_STEP_DEGREES;
                            this._rotation.set(newRot < -180 ? 360 + newRot : newRot);
                            this.updateRotation();
                        }
                    }
                }
            });
            this._tool.registerMouseWheelBinding(rotateEntityAction);
        }
        nudgeSelected(nudgeVector) {
            if (this._selectedEntity && this._mouseMoveWatcherId < 0) {
                try {
                    const currentLocation = this._selectedEntity.location;
                    const newLocation = lib.Vector3Utils.add(currentLocation, nudgeVector);
                    this._selectedEntity.teleport(newLocation);
                    this.updateSelectionPreview();
                } catch (e) {
                    this._session.log.error(`Nudge failed: ${stringFromException(e)}`, {
                        channelMask: server_editor_namespaceObject.LogChannel.All
                    });
                }
            }
        }
        handleNudgeState(state, actionId) {
            if (state === server_editor_namespaceObject.ContinuousActionState.Begin) {
                this._activeNudgeActions.add(actionId);
            }
            if (state === server_editor_namespaceObject.ContinuousActionState.Repeat) {
                if (this._activeNudgeActions.size > 0) {
                    this._nudgeActions.forEach((action => action.repeatDelay = 0));
                }
            } else if (state === server_editor_namespaceObject.ContinuousActionState.End) {
                this._activeNudgeActions.delete(actionId);
                if (this._activeNudgeActions.size === 0) {
                    this._nudgeActions.forEach((action => action.repeatDelay = undefined));
                }
            }
        }
        selectEntity(entity) {
            this._selectedEntity = entity;
            this._rotation.set(entity.getRotation().y);
            this._widget.location = entity.location;
            this._widget.visible = true;
            this._session.extensionContext.cursor.setProperties({
                ...this._cursorProperties,
                visible: false
            });
            this.updateSelectionPreview();
        }
        getRelativeNudgeDirection(direction) {
            const rotationY = this._session.extensionContext.player.getRotation().y;
            const rotationCorrectedVector = getRotationCorrectedDirectionVector(rotationY, direction);
            return rotationCorrectedVector;
        }
        updateRotation() {
            if (!this._selectedEntity) {
                return;
            }
            let rotation = this._rotation.value;
            if (rotation < -180) {
                rotation += 360;
            } else if (rotation > 180) {
                rotation -= 360;
            }
            const location = this._selectedEntity.location;
            this._selectedEntity.setRotation({
                x: 0,
                y: rotation
            });
            this._selectedEntity.teleport(location);
            this._rotation.set(rotation);
        }
        shutdownMouseWatcher() {
            if (this._mouseMoveWatcherId >= 0) {
                server_namespaceObject.system.clearRun(this._mouseMoveWatcherId);
                this._mouseMoveWatcherId = -1;
            }
        }
        handleEndSelectMove(mouseRay) {
            this.shutdownMouseWatcher();
            if (this._selectedEntity) {
                const targetLoc = {
                    x: mouseRay.cursorBlockLocation.x + .5,
                    y: mouseRay.cursorBlockLocation.y,
                    z: mouseRay.cursorBlockLocation.z + .5
                };
                this._selectedEntity.teleport(targetLoc);
            }
            this.updateSelectionPreview();
        }
        handleBeginSelectMove(_) {
            if (!this._selectedEntity) {
                return;
            }
            let currentCursorLocation = this._session.extensionContext.cursor.getPosition();
            const mouseWatcherTick = () => {
                if (this._mouseMoveWatcherId >= 0 && this._selectedEntity) {
                    const cursorLoc = lib.Vector3Utils.floor(this._session.extensionContext.cursor.getPosition());
                    if (!lib.Vector3Utils.equals(cursorLoc, currentCursorLocation)) {
                        currentCursorLocation = cursorLoc;
                        const entityNewPos = lib.Vector3Utils.add(currentCursorLocation, {
                            x: .5,
                            y: 0,
                            z: .5
                        });
                        this._selectedEntity.teleport(entityNewPos);
                        this.updateSelectionPreview();
                    }
                    this._mouseMoveWatcherId = server_namespaceObject.system.run(mouseWatcherTick);
                }
            };
            this._mouseMoveWatcherId = server_namespaceObject.system.run(mouseWatcherTick);
            this.updateSelectionPreview();
        }
        handleBeginSummonMode(mouseRay) {
            const spawnLoc = {
                x: mouseRay.cursorBlockLocation.x + .5,
                y: mouseRay.cursorBlockLocation.y,
                z: mouseRay.cursorBlockLocation.z + .5
            };
            const player = this._session.extensionContext.player;
            const dimension = player.dimension;
            try {
                this._selectedEntity = dimension.spawnEntity(this._entityType.value, spawnLoc, {
                    initialPersistence: true
                });
            } catch (e) {
                this._session.log.error(`${stringFromException(e)}`, {
                    channelMask: server_editor_namespaceObject.LogChannel.All
                });
                this.clearSelection();
            }
            if (this._selectedEntity) {
                this.selectEntity(this._selectedEntity);
            }
            this.updateRotation();
            const manager = this._session.extensionContext.transactionManager;
            manager.openTransaction("Summon Tool - Create Entity");
            try {
                if (this._selectedEntity) {
                    manager.addEntityOperation(this._selectedEntity, server_editor_namespaceObject.EntityOperationType.Create);
                    const transactionPayload = {
                        entityID: this._selectedEntity.id
                    };
                    this._createTransactionHandler.addUserDefinedOperation(transactionPayload, "Entity Create");
                }
            } catch (e) {
                this._session.log.warning(`Unable to commit create entity transaction. ${stringFromException(e)}`);
                manager.discardOpenTransaction();
                return;
            }
            manager.commitOpenTransaction();
        }
        teardown() {
            this.shutdownMouseWatcher();
        }
        clearSelection() {
            this._widget.visible = false;
            this._selectedEntity = undefined;
            this._session.extensionContext.cursor.setProperties({
                ...this._cursorProperties,
                visible: true
            });
        }
        updateSelectionPreview() {
            if (this._selectedEntity) {
                this._widget.visible = true;
                this._widget.location = this._selectedEntity.location;
            } else {
                this._widget.visible = false;
            }
        }
        _registerToolKeyBinding(action, binding, tag) {
            this._tool.registerKeyBinding(action, binding, {
                uniqueId: `editor:summonToolKeyBinding:${tag}`,
                label: `resourcePack.editor.toolRail.summonTool.keyBinding.${tag}.title`,
                tooltip: `resourcePack.editor.toolRail.summonTool.keyBinding.${tag}.tooltip`
            });
        }
    }
    const TimeOfDay_validDaylightCycle = [ {
        val: server_editor_namespaceObject.DaylightCycle.Normal,
        label: "resourcePack.editor.exportProject.cheatsSettings.daylightCycle.normal"
    }, {
        val: server_editor_namespaceObject.DaylightCycle.AlwaysDay,
        label: "resourcePack.editor.exportProject.cheatsSettings.daylightCycle.alwaysDay"
    }, {
        val: server_editor_namespaceObject.DaylightCycle.LockTime,
        label: "resourcePack.editor.exportProject.cheatsSettings.daylightCycle.lockTime"
    } ];
    var TimeOfDayTelemetry;
    (function(TimeOfDayTelemetry) {
        TimeOfDayTelemetry["SettingsChanged"] = "SettingsChanged";
    })(TimeOfDayTelemetry || (TimeOfDayTelemetry = {}));
    class TimeOfDayBehavior {
        constructor(_uiSession, _parentMenu) {
            this._uiSession = _uiSession;
            this._timeOfDayValue = (0, server_editor_namespaceObject.makeObservable)(server_namespaceObject.world.getTimeOfDay());
            this._timeOfDayTimeString = (0, server_editor_namespaceObject.makeObservable)(convertTODToTime(server_namespaceObject.world.getTimeOfDay(), false));
            this._clockType = (0, server_editor_namespaceObject.makeObservable)(ClockType.CLOCK_24HR);
            this._customTime = (0, server_editor_namespaceObject.makeObservable)(0);
            this._daylightCycle = (0, server_editor_namespaceObject.makeObservable)(server_editor_namespaceObject.DaylightCycle.LockTime);
            this._currentPreset = (0, server_editor_namespaceObject.makeObservable)(TODDropDown.None);
            this.openMenuAction = this._uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this._timeOfDayValue.set(server_namespaceObject.world.getTimeOfDay());
                    this._pane?.show();
                }
            });
            this.createMenuItem(_parentMenu);
            this.telemetryManager = new TelemetryManager(_uiSession.extensionContext.player, TelemetrySource.TimeOfDay);
            this._pane = _uiSession.createPropertyPane({
                title: "resourcePack.editor.timeOfDay.title",
                uniqueId: "editor:pane:timeOfDay",
                infoTooltip: {
                    description: [ "resourcePack.editor.timeOfDay.tooltip", {
                        link: "https://aka.ms/BedrockEditorTimeOfDaySettings",
                        text: "resourcePack.editor.help.learnMore"
                    } ]
                }
            });
            const clockItems = clockValues.map((v => {
                const item = {
                    label: v.stringId,
                    value: v.index
                };
                return item;
            }));
            this._pane.addDropdown(this._clockType, {
                title: "resourcePack.editor.timeOfDay.clockType",
                tooltip: "resourcePack.editor.timeOfDay.clockType.tooltip",
                enable: true,
                entries: clockItems,
                onChange: newValue => {
                    this.telemetryManager.fireTelemetryEvent(TimeOfDayTelemetry.SettingsChanged, {
                        settingName: "clockType",
                        newSetting: newValue
                    });
                }
            });
            this._pane.addString(this._timeOfDayTimeString, {
                title: "resourcePack.editor.timeOfDay.currentTime",
                tooltip: "resourcePack.editor.timeOfDay.currentTime.tooltip",
                enable: false
            });
            const daylightCycleItems = TimeOfDay_validDaylightCycle.map(((v, i) => {
                const item = {
                    label: v.label,
                    value: i
                };
                return item;
            }));
            this._pane.addDropdown(this._daylightCycle, {
                title: "resourcePack.editor.timeOfDay.daylightCycle",
                tooltip: "resourcePack.editor.timeOfDay.daylightCycle.tooltip",
                entries: daylightCycleItems,
                onChange: newValue => {
                    const currentTime = server_namespaceObject.world.getTimeOfDay();
                    this.setDaylightCycle(newValue, currentTime, _uiSession);
                    this._currentPreset.set(TODDropDown.None);
                    this.telemetryManager.fireTelemetryEvent(TimeOfDayTelemetry.SettingsChanged, {
                        settingName: "daylightCycle",
                        newSetting: newValue
                    });
                }
            });
            this._pane.addDivider();
            const timeItems = validPresets.map((v => {
                const item = {
                    label: v.stringId,
                    value: v.time
                };
                return item;
            }));
            this._pane.addDropdown(this._currentPreset, {
                title: "resourcePack.editor.timeOfDay.dropDown.title",
                tooltip: "resourcePack.editor.timeOfDay.dropDown.tooltip",
                entries: timeItems,
                onChange: newValue => {
                    if (newValue === TODDropDown.None) {
                        customTime.enable = true;
                        customTime.visible = true;
                    } else {
                        this.setDaylightCycle(server_editor_namespaceObject.DaylightCycle.LockTime, newValue, _uiSession);
                        this._timeOfDayValue.set(newValue);
                        server_namespaceObject.world.setTimeOfDay(newValue);
                        customTime.enable = false;
                        customTime.visible = false;
                    }
                    this.telemetryManager.fireTelemetryEvent(TimeOfDayTelemetry.SettingsChanged, {
                        settingName: "currentPreset",
                        newSetting: newValue
                    });
                }
            });
            const customTime = this._pane.addNumber(this._customTime, {
                title: "resourcePack.editor.timeOfDay.customTime",
                tooltip: "resourcePack.editor.timeOfDay.customTime.tooltip",
                min: 0,
                max: 24 * mcHoursPerTick - 1,
                variant: server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider,
                isInteger: true,
                onChange: newValue => {
                    this._timeOfDayValue.set(newValue);
                    this.setDaylightCycle(server_editor_namespaceObject.DaylightCycle.LockTime, newValue, _uiSession);
                    this._daylightCycle.set(server_editor_namespaceObject.DaylightCycle.LockTime);
                }
            });
            this._updateHandle = server_namespaceObject.system.runInterval((() => {
                const currentTime = server_namespaceObject.world.getTimeOfDay();
                if (this._pane.visible) {
                    if (this._clockType.value !== ClockType.MINECRAFT_CLOCK) {
                        const is24HrClock = this._clockType.value === ClockType.CLOCK_24HR ? true : false;
                        this._timeOfDayTimeString.set(convertTODToTime(server_namespaceObject.world.getTimeOfDay(), is24HrClock));
                    } else {
                        this._timeOfDayTimeString.set(currentTime.toString());
                    }
                }
            }), 3);
            this._scriptEvent = server_namespaceObject.system.afterEvents.scriptEventReceive.subscribe((e => {
                if (e.id === "editor:agfxPreview:timeChanged") {
                    const newTime = parseInt(e.message);
                    customTime.enable = true;
                    customTime.visible = true;
                    this._currentPreset.set(TODDropDown.None);
                    this._timeOfDayValue.set(newTime);
                    this.setDaylightCycle(server_editor_namespaceObject.DaylightCycle.LockTime, newTime, _uiSession);
                    this._daylightCycle.set(server_editor_namespaceObject.DaylightCycle.LockTime);
                    this._customTime.set(newTime);
                }
            }));
        }
        createMenuItem(menu) {
            menu.addItem({
                label: "resourcePack.editor.timeOfDay.menu.title",
                tooltip: "resourcePack.editor.timeOfDay.menu.tooltip"
            }, this.openMenuAction);
        }
        setDaylightCycle(daylightCycle, currentTime, uiSession) {
            this._daylightCycle.set(daylightCycle);
            try {
                server_namespaceObject.world.getDimension("overworld").runCommand(`alwaysday ${(daylightCycle === server_editor_namespaceObject.DaylightCycle.AlwaysDay || daylightCycle === server_editor_namespaceObject.DaylightCycle.LockTime).toString()}`);
                const timeStr = daylightCycle === server_editor_namespaceObject.DaylightCycle.Normal ? "started" : "stopped";
                uiSession.log.info(`Time ${timeStr}`);
                if (daylightCycle === server_editor_namespaceObject.DaylightCycle.AlwaysDay) {
                    server_namespaceObject.world.setTimeOfDay(TODDropDown.Noon);
                } else {
                    server_namespaceObject.world.setTimeOfDay(currentTime);
                }
            } catch (_err) {
                uiSession.log.error("Unable to adjust daylight cycle due to unknown error.", {
                    channelMask: server_editor_namespaceObject.LogChannel.All
                });
            }
        }
        teardown() {
            if (this._updateHandle) {
                server_namespaceObject.system.clearRun(this._updateHandle);
            }
            if (this._scriptEvent) {
                server_namespaceObject.system.afterEvents.scriptEventReceive.unsubscribe(this._scriptEvent);
            }
        }
    }
    TimeOfDayBehavior.BEHAVIOR_NAME = "Time of Day";
    const STORED_LOCATION_DYNAMIC_PROPERTY_NAME = "goto-mark:storedLocations";
    const STORED_LOCATION_NAME_MAX_LENGTH = 16;
    const STORED_LOCATIONS_MAX = 9;
    const WHITE_RGBA = {
        red: 1,
        green: 1,
        blue: 1,
        alpha: 1
    };
    const BLACK_RGBA = {
        red: 0,
        green: 0,
        blue: 0,
        alpha: 1
    };
    const MAX_LOADED_CHUNK_SIZE = 78;
    const CACHE_LENGTH = 4 * MAX_LOADED_CHUNK_SIZE;
    const CACHE_UPDATE_DISTANCE = 16;
    const CACHE_MAX_SIZE = (CACHE_LENGTH + 1) * (CACHE_LENGTH + 1);
    const MAP_IMAGE_SIZE = 35;
    var MapSize;
    (function(MapSize) {
        MapSize[MapSize["Small"] = 0] = "Small";
        MapSize[MapSize["Middle"] = 1] = "Middle";
        MapSize[MapSize["Large"] = 2] = "Large";
    })(MapSize || (MapSize = {}));
    var Navigation_Direction;
    (function(Direction) {
        Direction[Direction["North"] = 0] = "North";
        Direction[Direction["East"] = 1] = "East";
        Direction[Direction["South"] = 2] = "South";
        Direction[Direction["West"] = 3] = "West";
        Direction[Direction["Northeast"] = 4] = "Northeast";
        Direction[Direction["Southwest"] = 5] = "Southwest";
        Direction[Direction["Southeast"] = 6] = "Southeast";
        Direction[Direction["Northwest"] = 7] = "Northwest";
    })(Navigation_Direction || (Navigation_Direction = {}));
    const mapSizeInPixels = {
        [MapSize.Small]: 64,
        [MapSize.Middle]: 128,
        [MapSize.Large]: 256
    };
    const pixelFactors = {
        [MapSize.Small]: 4,
        [MapSize.Middle]: 2,
        [MapSize.Large]: 1
    };
    const DimensionIds = {
        "minecraft:overworld": 0,
        "minecraft:nether": 1,
        "minecraft:the_end": 2
    };
    var NavigationTelemetry;
    (function(NavigationTelemetry) {
        NavigationTelemetry["ShowMapToggle"] = "ShowMapToggle";
        NavigationTelemetry["TeleportToLocation"] = "TeleportToLocation";
        NavigationTelemetry["StoredLocationsChanged"] = "StoredLocationsChanged";
        NavigationTelemetry["TeleportToStoredLocation"] = "TeleportToStoredLocation";
        NavigationTelemetry["DeleteStoredLocation"] = "DeleteStoredLocation";
        NavigationTelemetry["SaveLocation"] = "SaveLocation";
        NavigationTelemetry["TeleportViaMap"] = "TeleportViaMap";
    })(NavigationTelemetry || (NavigationTelemetry = {}));
    class NavigationBehavior {
        constructor(uiSession, parentMenu) {
            this.uiSession = uiSession;
            this.mapPayload = (0, server_editor_namespaceObject.makeObservable)("");
            this.previousDirectionPlayerIsFacing = Navigation_Direction.North;
            this.ifShowMap = (0, server_editor_namespaceObject.makeObservable)(false);
            this.mapSizeSelection = (0, server_editor_namespaceObject.makeObservable)(MapSize.Small);
            this.openMenuAction = this.uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.parentPane?.show();
                }
            });
            this.isWithinPlayerIconArea = (x, z) => z >= -15 && z <= 12 && x >= -9 && x <= 10 && !((x >= -9 && x <= -6 || x >= 7 && x <= 10) && (z >= -15 && z <= -8 || z >= 9 && z <= 12) || (x >= -5 && x <= -2 || x >= 3 && x <= 6) && z >= -15 && z <= -12);
            this.isWhiteBlockInPlayerIcon = (x, z) => x >= -1 && x <= 2 && z >= -11 && z <= 8 || (x >= -5 && x <= -2 || x >= 3 && x <= 6) && z >= -7 && z <= 8;
            this.playerIconMap = new Map([ [ Navigation_Direction.North, [ (z, x) => this.isWithinPlayerIconArea(x, z), (z, x) => this.isWhiteBlockInPlayerIcon(x, z) ] ], [ Navigation_Direction.East, [ (z, x) => this.isWithinPlayerIconArea(z, -x), (z, x) => this.isWhiteBlockInPlayerIcon(z, -x) ] ], [ Navigation_Direction.South, [ (z, x) => this.isWithinPlayerIconArea(x, -z), (z, x) => this.isWhiteBlockInPlayerIcon(x, -z) ] ], [ Navigation_Direction.West, [ (z, x) => this.isWithinPlayerIconArea(z, x), (z, x) => this.isWhiteBlockInPlayerIcon(z, x) ] ], [ Navigation_Direction.Northwest, [ (z, x) => z >= -12 && z <= 12 && x >= -12 && x <= 12 && !(this.playerIconAreaIndexArrays[x + 12].includes(z) || this.playerIconAreaIndexArrays[z + 12].includes(x)), (z, x) => this.playerIconWhiteBlockIndexArrays[x + 12].includes(z) || this.playerIconWhiteBlockIndexArrays[z + 12].includes(x) ] ], [ Navigation_Direction.Northeast, [ (z, x) => z >= -12 && z <= 12 && x >= -12 && x <= 12 && !(this.playerIconAreaIndexArrays[-x + 12].includes(z) || this.playerIconAreaIndexArrays[z + 12].includes(-x)), (z, x) => this.playerIconWhiteBlockIndexArrays[-x + 12].includes(z) || this.playerIconWhiteBlockIndexArrays[z + 12].includes(-x) ] ], [ Navigation_Direction.Southeast, [ (z, x) => z >= -12 && z <= 12 && x >= -12 && x <= 12 && !(this.playerIconAreaIndexArrays[-x + 12].includes(-z) || this.playerIconAreaIndexArrays[-z + 12].includes(-x)), (z, x) => this.playerIconWhiteBlockIndexArrays[-x + 12].includes(-z) || this.playerIconWhiteBlockIndexArrays[-z + 12].includes(-x) ] ], [ Navigation_Direction.Southwest, [ (z, x) => z >= -12 && z <= 12 && x >= -12 && x <= 12 && !(this.playerIconAreaIndexArrays[x + 12].includes(-z) || this.playerIconAreaIndexArrays[-z + 12].includes(x)), (z, x) => this.playerIconWhiteBlockIndexArrays[x + 12].includes(-z) || this.playerIconWhiteBlockIndexArrays[-z + 12].includes(x) ] ] ]);
            this.playerIconAreaIndexArrays = [ [ -12, -11, -8, -7, -6, -5, -2, -1, 0, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 ], [ -7, -6, -1, 4, 5, 6, 7, 8, 9, 10, 11, 12 ], [ 5, 6, 7, 8, 9, 10, 11, 12 ], [ 6, 7, 8, 9, 10, 11, 12 ], [ 7, 8, 9, 10, 11, 12 ], [ 8, 9, 10, 11, 12 ], [ 9, 10, 11, 12 ], [ 10, 11, 12 ], [ 11, 12 ], [ 12 ], [], [], [ 12 ], [ 12 ], [ 11, 12 ], [ 12 ], [], [], [ 12 ], [ 11, 12 ], [ 10, 11, 12 ], [ 9, 10, 11, 12 ], [ 10, 11, 12 ], [ 11, 12 ], [ 12 ] ];
            this.playerIconWhiteBlockIndexArrays = [ [], [], [], [], [ -7, -6, -1, 0 ], [ -7, -6, -5 - 2, -1, 0, 1 ], [ -6, -5, -4, -3, -2, -1, 0, 1, 2 ], [ -5, -4, -3, -2, -1, 0, 1, 2, 3 ], [ -4, -3, -2, -1, 0, 1, 2, 3, 4 ], [ -3, -2, -1, 0, 1, 2, 3, 4, 5 ], [ -2, -1, 0, 1, 2, 3, 4, 5, 6 ], [ -1, 0, 1, 2, 3, 4, 5, 6, 7 ], [ 0, 1, 2, 3, 4, 5, 6, 7, 8 ], [ 1, 2, 3, 4, 5, 6, 7, 8 ], [ 2, 3, 4, 5, 6, 7, 8, 9 ], [ 3, 4, 5, 6, 7, 8 ], [ 4, 5, 6, 7 ], [ 5, 6 ], [], [], [], [], [], [], [] ];
            uiSession.log.debug(`Initializing extension [${uiSession.extensionContext.extensionInfo.name}] for player [${uiSession.extensionContext.player.name}]`);
            this.createMenuItem(parentMenu);
            this.telemetryManager = new TelemetryManager(uiSession.extensionContext.player, TelemetrySource.Navigation);
            this.previousLocation = uiSession.extensionContext.player.location;
            this.storedLocations = [];
            this.transactionHandler = (0, server_editor_namespaceObject.registerUserDefinedTransactionHandler)(uiSession.extensionContext.transactionManager, (payload => {
                uiSession.log.info(`Teleporting to location ${lib.Vector3Utils.toString(payload.current)}`);
                try {
                    uiSession.extensionContext.player.teleport(payload.current);
                } catch (e) {
                    uiSession.log.error(`Teleport failed: ${(0, server_editor_namespaceObject.stringFromException)(e)}`, {
                        channelMask: server_editor_namespaceObject.LogChannel.All
                    });
                }
            }), (payload => {
                uiSession.log.info(`Teleporting to location ${lib.Vector3Utils.toString(payload.destination)}`);
                try {
                    uiSession.extensionContext.player.teleport(payload.destination);
                } catch (e) {
                    uiSession.log.error(`Teleport failed: ${(0, server_editor_namespaceObject.stringFromException)(e)}`, {
                        channelMask: server_editor_namespaceObject.LogChannel.All
                    });
                }
            }));
            this.surfaceBlockColorCache = {
                center: uiSession.extensionContext.player.location,
                blocks: {},
                isUpdating: false
            };
            this.locationMarkRenderingStorage = {};
            const me = uiSession.extensionContext.player;
            try {
                const fetchedLocationsString = me.getDynamicProperty(STORED_LOCATION_DYNAMIC_PROPERTY_NAME);
                if (!fetchedLocationsString) {
                    uiSession.log.info("No stored locations found during initialization");
                } else {
                    const fetchedLocationsArray = JSON.parse(fetchedLocationsString);
                    if (fetchedLocationsArray) {
                        this.storedLocations = fetchedLocationsArray;
                    }
                    uiSession.log.info(`Found ${this.storedLocations.length} stored locations during initialization`);
                }
            } catch (e) {
                uiSession.log.info(`Exception ${(0, server_editor_namespaceObject.stringFromException)(e)} occurred during initialization`);
            }
            this._buildParentPane();
            uiSession.actionBar.registerItem("editor:actionBarItem:goToMark", this.openMenuAction, {
                label: "resourcePack.editor.goToMark.title",
                icon: "pack://textures/editor/goto-mark.png",
                tooltipTitle: "resourcePack.editor.goToMark.actionBar.tooltip.title",
                tooltipDescription: "resourcePack.editor.goToMark.actionBar.tooltip.description",
                executeOnAdd: true
            });
        }
        teardown() {
            this.uiSession.log.debug(`Shutting down extension [${this.uiSession.extensionContext.extensionInfo.name}] for player [${this.uiSession.extensionContext.player.name}]`);
            if (this.updateHandle) {
                server_namespaceObject.system.clearRun(this.updateHandle);
            }
            if (this.cacheClearHandle) {
                server_namespaceObject.system.clearRun(this.cacheClearHandle);
            }
            if (this.cacheUpdateHandle) {
                server_namespaceObject.system.clearRun(this.cacheUpdateHandle);
            }
        }
        createMenuItem(menu) {
            menu.addItem({
                label: "resourcePack.editor.goToMark.title",
                tooltip: "resourcePack.editor.goToMark.menuTooltip"
            }, this.openMenuAction);
        }
        _buildParentPane() {
            const parentPane = this.uiSession.createPropertyPane({
                title: "resourcePack.editor.goToMark.title",
                uniqueId: "editor:pane:goToMark",
                infoTooltip: {
                    description: [ "resourcePack.editor.goToMark.tooltip", {
                        link: "https://aka.ms/BedrockEditorNavigationPanel",
                        text: "resourcePack.editor.help.learnMore"
                    } ]
                }
            });
            const currentLocation = lib.Vector3Utils.floor(this.uiSession.extensionContext.player.location);
            const playerLocation = (0, server_editor_namespaceObject.makeObservable)(currentLocation);
            this.previousLocation = {
                ...currentLocation
            };
            parentPane.addBool(this.ifShowMap, {
                title: "resourcePack.editor.goToMark.pane.showMap",
                tooltip: "resourcePack.editor.goToMark.pane.showMap.tooltip",
                onChange: current => {
                    if (current) {
                        this.updateLocationMarkRenderingStorage();
                        this.updateSurfaceBlockColorCache().then((() => {
                            this.mapPayload.set(this._createMiniMap());
                        })).catch((e => {
                            this.uiSession.log.error(`${e.message}`, {
                                channelMask: server_editor_namespaceObject.LogChannel.All
                            });
                        })).finally((() => {
                            this.surfaceBlockColorCache.isUpdating = false;
                        }));
                    }
                    if (this.mapSizeDropDown) {
                        this.mapSizeDropDown.enable = current;
                        this.mapSizeDropDown.visible = current;
                    }
                    if (this.mapImage) {
                        this.mapImage.visible = current;
                    }
                    if (this.refreshMapButton) {
                        this.refreshMapButton.enable = current;
                        this.refreshMapButton.visible = current;
                    }
                    if (this.locationMarkColorPicker) {
                        this.locationMarkColorPicker.visible = current;
                        this.locationMarkColorPicker.enable = current;
                    }
                    this.telemetryManager.fireTelemetryEvent(NavigationTelemetry.ShowMapToggle, {
                        showMap: current
                    });
                },
                variant: server_editor_namespaceObject.BoolPropertyItemVariant.ToggleSwitch
            });
            this.mapSizeDropDown = parentPane.addDropdown(this.mapSizeSelection, {
                visible: this.ifShowMap.value,
                enable: this.ifShowMap.value,
                title: "resourcePack.editor.goToMark.pane.mapSize",
                entries: [ {
                    label: "64 x 64 blocks",
                    value: MapSize.Small
                }, {
                    label: "128 x 128 blocks",
                    value: MapSize.Middle
                }, {
                    label: "256 x 256 blocks",
                    value: MapSize.Large
                } ],
                onChange: () => {
                    this.updateSurfaceBlockColorCache().then((() => {
                        this.mapPayload.set(this._createMiniMap());
                    })).catch((e => {
                        this.uiSession.log.error(`${e.message}`, {
                            channelMask: server_editor_namespaceObject.LogChannel.All
                        });
                    })).finally((() => {
                        this.surfaceBlockColorCache.isUpdating = false;
                    }));
                }
            });
            this.mapImage = parentPane.addImage(this.mapPayload, {
                visible: this.ifShowMap.value,
                imageSize: MAP_IMAGE_SIZE,
                alignment: server_editor_namespaceObject.LayoutAlignment.Center,
                onClick: (x, y) => {
                    const mapSize = mapSizeInPixels[this.mapSizeSelection.value];
                    const me = this.uiSession.extensionContext.player;
                    const currentLocation = lib.Vector3Utils.floor(me.location);
                    const clickedXZLocation = {
                        x: currentLocation.x + Math.floor(x * mapSize) - mapSize / 2,
                        y: 0,
                        z: currentLocation.z + Math.floor(y * mapSize) - mapSize / 2
                    };
                    const cacheKey = this.createCacheKey(clickedXZLocation.x, clickedXZLocation.z, DimensionIds[me.dimension.id]);
                    const blockBelowPlayerCacheKey = this.createCacheKey(currentLocation.x, currentLocation.z, DimensionIds[me.dimension.id]);
                    const cache = this.surfaceBlockColorCache;
                    if (cache.blocks[cacheKey] && cache.blocks[blockBelowPlayerCacheKey]) {
                        const blockBelowPlayerLocation = cache.blocks[blockBelowPlayerCacheKey].location;
                        const blockLocation = cache.blocks[cacheKey].location;
                        const teleportLocation = {
                            x: blockLocation.x,
                            y: blockLocation.y + currentLocation.y - blockBelowPlayerLocation.y,
                            z: blockLocation.z
                        };
                        this.teleportTo(teleportLocation);
                        this.telemetryManager.fireTelemetryEvent(NavigationTelemetry.TeleportViaMap);
                    } else {
                        this.uiSession.log.error(`Please wait for the blocks to be loaded`, {
                            channelMask: server_editor_namespaceObject.LogChannel.All
                        });
                    }
                }
            });
            this.refreshMapButton = parentPane.addButton(this.uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.updateSurfaceBlockColorCache().then((() => {
                        this.mapPayload.set(this._createMiniMap());
                    })).catch((e => {
                        this.uiSession.log.error(e.message, {
                            channelMask: server_editor_namespaceObject.LogChannel.All
                        });
                    })).finally((() => {
                        this.surfaceBlockColorCache.isUpdating = false;
                    }));
                }
            }), {
                title: "resourcePack.editor.goToMark.pane.refreshMap",
                visible: this.ifShowMap.value,
                enable: this.ifShowMap.value
            });
            const teleportLimit = 3e7;
            parentPane.addVector3(playerLocation, {
                title: "resourcePack.editor.goToMark.pane.location",
                tooltip: "resourcePack.editor.goToMark.pane.location.tooltip",
                min: {
                    x: -teleportLimit,
                    y: -teleportLimit,
                    z: -teleportLimit
                },
                max: {
                    x: teleportLimit,
                    y: teleportLimit,
                    z: teleportLimit
                }
            });
            this.updateHandle = server_namespaceObject.system.runInterval((() => {
                if (!parentPane.visible) {
                    return;
                }
                const player = this.uiSession.extensionContext.player;
                const currentLocation = lib.Vector3Utils.floor(player.location);
                const previousLocation = lib.Vector3Utils.floor(this.previousLocation);
                const directionPlayerIsFacing = this.getCurrentDirectionPlayerIsFacing();
                if (lib.Vector3Utils.equals(currentLocation, previousLocation) && directionPlayerIsFacing === this.previousDirectionPlayerIsFacing) {
                    return;
                }
                this.previousLocation = currentLocation;
                playerLocation.set({
                    ...currentLocation
                });
                this.previousDirectionPlayerIsFacing = directionPlayerIsFacing;
            }), 1);
            this.cacheUpdateHandle = server_namespaceObject.system.runInterval((() => {
                if (!this.ifShowMap.value || !parentPane.visible) {
                    return;
                }
                const cache = this.surfaceBlockColorCache;
                const playerLocation = lib.Vector3Utils.floor(this.uiSession.extensionContext.player.location);
                if (!this.isPlayerFarFromCenter(cache.center, playerLocation)) {
                    return;
                }
                this.updateSurfaceBlockColorCache().then((() => {
                    this.mapPayload.set(this._createMiniMap());
                })).catch((e => {
                    this.uiSession.log.error(e.message, {
                        channelMask: server_editor_namespaceObject.LogChannel.All
                    });
                })).finally((() => {
                    cache.isUpdating = false;
                }));
            }), 10);
            this.cacheClearHandle = server_namespaceObject.system.runInterval((() => {
                if (!this.ifShowMap.value || !parentPane.visible) {
                    return;
                }
                const cache = this.surfaceBlockColorCache;
                if (Object.keys(cache.blocks).length > CACHE_MAX_SIZE) {
                    this.uiSession.log.debug(`Cache Clean starts: cache size ${Object.keys(cache.blocks).length} at ${Date.now().toString()}`);
                    const latestPlayerLocation = lib.Vector3Utils.floor(this.uiSession.extensionContext.player.location);
                    for (const key in cache.blocks) {
                        if (Object.prototype.hasOwnProperty.call(cache.blocks, key)) {
                            if (this.shouldDeleteItemFromCache(latestPlayerLocation, cache.blocks[key].location)) {
                                delete cache.blocks[key];
                            }
                        }
                    }
                    this.uiSession.log.debug(`Cache Clean finished!: cache size ${Object.keys(cache.blocks).length} at ${Date.now().toString()}`);
                }
            }), 20);
            parentPane.addButton(this.uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const panelLocation = playerLocation.value;
                    this.teleportTo(panelLocation);
                    this.telemetryManager.fireTelemetryEvent(NavigationTelemetry.TeleportToLocation);
                }
            }), {
                title: "resourcePack.editor.goToMark.pane.teleport",
                visible: true
            });
            parentPane.addDivider();
            this.parentPane = parentPane;
            this.buildLocationPane(0);
            return parentPane;
        }
        mapDropdownItems() {
            return this.storedLocations.map(((v, index) => {
                const item = {
                    label: `${index + 1}: ${v.name} (${lib.Vector3Utils.toString(v.location)})`,
                    value: index
                };
                return item;
            }));
        }
        createTransaction(current, destination) {
            const transactionPayload = {
                current,
                destination
            };
            if (!this.uiSession.scratchStorage) {
                return;
            }
            this.uiSession.extensionContext.transactionManager.openTransaction("goto position");
            this.transactionHandler.addUserDefinedOperation(transactionPayload, "Goto(Teleport)");
            this.uiSession.extensionContext.transactionManager.commitOpenTransaction();
        }
        teleportTo(destination) {
            this.createTransaction(this.uiSession.extensionContext.player.location, destination);
            this.uiSession.log.info(`Teleporting to location ${lib.Vector3Utils.toString(destination)}`);
            try {
                this.uiSession.extensionContext.player.teleport(destination);
            } catch (e) {
                this.uiSession.log.error(`Teleport failed: ${(0, server_editor_namespaceObject.stringFromException)(e)}`, {
                    channelMask: server_editor_namespaceObject.LogChannel.All
                });
            }
        }
        buildLocationPane(initialSelection) {
            if (!this.parentPane) {
                this.uiSession.log.error("An error occurred: No UI pane could be found", {
                    channelMask: server_editor_namespaceObject.LogChannel.All
                });
                return;
            }
            const locationPane = this.parentPane.createSubPane({
                title: "resourcePack.editor.goToMark.pane.locationPane.title"
            });
            const currentColor = (0, server_editor_namespaceObject.makeObservable)(this.storedLocations[initialSelection]?.color ?? WHITE_RGBA);
            const currentSelection = (0, server_editor_namespaceObject.makeObservable)(initialSelection);
            const newName = (0, server_editor_namespaceObject.makeObservable)("");
            const dropdownItems = this.mapDropdownItems();
            this.dropdownMenu = locationPane.addDropdown(currentSelection, {
                title: "resourcePack.editor.goToMark.pane.locationPane.dropdownLabel",
                entries: dropdownItems,
                onChange: newValue => {
                    if (this.teleportButton) {
                        this.teleportButton.setTitle({
                            id: "resourcePack.editor.goToMark.pane.locationPane.teleport",
                            props: [ `${newValue + 1}` ]
                        });
                    }
                    if (this.storedLocations[newValue] === undefined) {
                        currentColor.set({
                            ...WHITE_RGBA
                        });
                        return;
                    }
                    currentColor.set({
                        ...this.storedLocations[newValue].color
                    });
                    this.telemetryManager.fireTelemetryEvent(NavigationTelemetry.StoredLocationsChanged);
                }
            });
            this.locationMarkColorPicker = locationPane.addColorPicker(currentColor, {
                visible: this.ifShowMap.value,
                enable: this.ifShowMap.value,
                variant: server_editor_namespaceObject.ColorPickerPropertyItemVariant.Inline,
                title: "resourcePack.editor.goToMark.pane.locationPane.markColor",
                hiddenAlpha: true,
                onChange: color => {
                    if (this.storedLocations[currentSelection.value] === undefined) {
                        return;
                    }
                    this.storedLocations[currentSelection.value].color = {
                        ...color
                    };
                    this.storeLocationsToPlayer();
                    if (this.ifShowMap.value) {
                        this.updateLocationMarkRenderingStorage();
                        this.mapPayload?.set(this._createMiniMap());
                    }
                }
            });
            locationPane.addDivider();
            this.teleportButton = locationPane.addButton(this.uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    if (currentSelection.value < 0 || currentSelection.value >= this.storedLocations.length) {
                        this.uiSession.log.error("No stored locations to delete", {
                            channelMask: server_editor_namespaceObject.LogChannel.All
                        });
                        return;
                    }
                    const destination = this.storedLocations[currentSelection.value].location;
                    this.teleportTo(destination);
                    this.telemetryManager.fireTelemetryEvent(NavigationTelemetry.TeleportToStoredLocation);
                }
            }), {
                title: {
                    id: "resourcePack.editor.goToMark.pane.locationPane.teleport",
                    props: [ dropdownItems.length > 0 ? `${currentSelection.value + 1}` : "" ]
                },
                visible: true
            });
            locationPane.addButton(this.uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const selectionValue = currentSelection.value;
                    if (selectionValue < 0 || selectionValue >= this.storedLocations.length) {
                        this.uiSession.log.error("No stored locations to delete", {
                            channelMask: server_editor_namespaceObject.LogChannel.All
                        });
                        return;
                    }
                    const locationData = this.storedLocations[selectionValue];
                    const locationName = locationData.name;
                    this.uiSession.log.info(`Deleting stored location name "${locationName}"`);
                    this.storedLocations.splice(selectionValue, 1);
                    this.storeLocationsToPlayer();
                    const dropdownItems = this.mapDropdownItems();
                    const newValue = selectionValue >= dropdownItems.length && selectionValue > 0 ? selectionValue - 1 : selectionValue;
                    this.dropdownMenu?.updateEntries(dropdownItems, newValue);
                    if (this.storedLocations[newValue] === undefined) {
                        currentColor.set({
                            ...WHITE_RGBA
                        });
                    } else {
                        currentColor.set({
                            ...this.storedLocations[newValue].color
                        });
                    }
                    this.updateLocationMarkRenderingStorage(locationData);
                    if (this.ifShowMap.value) {
                        this.mapPayload?.set(this._createMiniMap());
                    }
                    this.teleportButton?.setTitle({
                        id: "resourcePack.editor.goToMark.pane.locationPane.teleport",
                        props: [ dropdownItems.length > 0 ? `${newValue + 1}` : "" ]
                    });
                    this.telemetryManager.fireTelemetryEvent(NavigationTelemetry.DeleteStoredLocation);
                }
            }), {
                title: "resourcePack.editor.goToMark.pane.locationPane.delete",
                visible: true
            });
            locationPane.addString(newName, {
                title: "resourcePack.editor.goToMark.pane.locationPane.inputName"
            });
            locationPane.addButton(this.uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    if (this.storedLocations.length >= STORED_LOCATIONS_MAX) {
                        this.uiSession.log.error(`Cannot store more than ${STORED_LOCATIONS_MAX} locations`, {
                            channelMask: server_editor_namespaceObject.LogChannel.All
                        });
                        return;
                    }
                    const currentLocation = lib.Vector3Utils.floor(this.uiSession.extensionContext.player.location);
                    if (!newName.value || newName.value === "") {
                        newName.set(`Location ${this.storedLocations.length + 1}`);
                    } else {
                        const trimmedName = newName.value.trim();
                        if (trimmedName.length > STORED_LOCATION_NAME_MAX_LENGTH) {
                            newName.set(trimmedName.substring(0, STORED_LOCATION_NAME_MAX_LENGTH));
                        }
                    }
                    this.uiSession.log.info(`Adding Location ${lib.Vector3Utils.toString(currentLocation)} as "${newName.value}"`);
                    this.storedLocations.push({
                        name: newName.value,
                        location: currentLocation,
                        color: {
                            ...WHITE_RGBA
                        }
                    });
                    this.storeLocationsToPlayer();
                    const newSelectionIndex = this.storedLocations.length - 1;
                    const dropdownItems = this.mapDropdownItems();
                    this.dropdownMenu?.updateEntries(dropdownItems, newSelectionIndex);
                    currentColor.set({
                        ...WHITE_RGBA
                    });
                    if (this.ifShowMap.value) {
                        this.updateLocationMarkRenderingStorage();
                        this.mapPayload?.set(this._createMiniMap());
                    }
                    this.teleportButton?.setTitle({
                        id: "resourcePack.editor.goToMark.pane.locationPane.teleport",
                        props: [ `${newSelectionIndex + 1}` ]
                    });
                    newName.set("");
                    this.telemetryManager.fireTelemetryEvent(NavigationTelemetry.SaveLocation);
                }
            }), {
                title: "resourcePack.editor.goToMark.pane.locationPane.store"
            });
        }
        storeLocationsToPlayer() {
            const me = this.uiSession.extensionContext.player;
            me.setDynamicProperty(STORED_LOCATION_DYNAMIC_PROPERTY_NAME, JSON.stringify(this.storedLocations));
        }
        _createMiniMap() {
            const mapSize = mapSizeInPixels[this.mapSizeSelection.value];
            const pixelFactor = pixelFactors[this.mapSizeSelection.value];
            const me = this.uiSession.extensionContext.player;
            const currentPlayerLocation = lib.Vector3Utils.floor(me.location);
            const currentDirectionPlayerIsFacing = this.getCurrentDirectionPlayerIsFacing();
            const maxHeight = me.dimension.heightRange.max;
            const dimensionID = DimensionIds[me.dimension.id];
            const rgbValues = [];
            const cache = this.surfaceBlockColorCache;
            for (let zOffset = -mapSize / 2 * pixelFactor; zOffset < mapSize / 2 * pixelFactor; zOffset++) {
                for (let xOffset = -mapSize / 2 * pixelFactor; xOffset < mapSize / 2 * pixelFactor; xOffset++) {
                    let color = WHITE_RGBA;
                    const blockXOffset = Math.floor(xOffset / pixelFactor);
                    const blockZOffset = Math.floor(zOffset / pixelFactor);
                    const isWithinPlayerArea = this.playerIconMap.get(currentDirectionPlayerIsFacing)?.[0];
                    const isWhiteBlock = this.playerIconMap.get(currentDirectionPlayerIsFacing)?.[1];
                    const highestLocation = {
                        x: currentPlayerLocation.x + blockXOffset,
                        y: maxHeight,
                        z: currentPlayerLocation.z + blockZOffset
                    };
                    const currentXZString = this.createCacheKey(highestLocation.x, highestLocation.z, this.mapSizeSelection.value);
                    const cacheKey = this.createCacheKey(highestLocation.x, highestLocation.z, dimensionID);
                    if (cache.blocks[cacheKey]) {
                        color = cache.blocks[cacheKey].color;
                    }
                    if (isWithinPlayerArea?.(zOffset, xOffset)) {
                        color = isWhiteBlock?.(zOffset, xOffset) ? {
                            ...WHITE_RGBA
                        } : {
                            ...BLACK_RGBA
                        };
                    } else if (currentXZString in this.locationMarkRenderingStorage) {
                        color = this.locationMarkRenderingStorage[currentXZString].color;
                    }
                    const rgbObject = {
                        r: Math.round(color.red * 255),
                        g: Math.round(color.green * 255),
                        b: Math.round(color.blue * 255)
                    };
                    rgbValues.push(rgbObject);
                }
            }
            const base64Payload = CreateBase64ImageFromRGB(rgbValues, mapSize * pixelFactor, mapSize * pixelFactor);
            return base64Payload;
        }
        async updateSurfaceBlockColorCache() {
            const me = this.uiSession.extensionContext.player;
            const currentPlayerLocation = lib.Vector3Utils.floor(me.location);
            const maxHeight = me.dimension.heightRange.max;
            const dimensionID = DimensionIds[me.dimension.id];
            const cache = this.surfaceBlockColorCache;
            cache.center = currentPlayerLocation;
            cache.isUpdating = true;
            this.uiSession.log.debug(`Cache Update starts with cache size ${Object.keys(cache.blocks).length} at ${Date.now()}. Please wait for a while...`);
            const mapSize = mapSizeInPixels[this.mapSizeSelection.value];
            const region = server_editor_private_bindings_namespaceObject.editorInternal.getPlayerServices(me).regionManager.leaseRegion({
                extentX: {
                    min: currentPlayerLocation.x - mapSize / 2,
                    max: currentPlayerLocation.x + mapSize / 2
                },
                extentZ: {
                    min: currentPlayerLocation.z - mapSize / 2,
                    max: currentPlayerLocation.z + mapSize / 2
                }
            });
            await region.waitUntilAvailable();
            const maxHeightDistance = maxHeight - me.dimension.heightRange.min;
            for (let zOffset = -mapSize / 2; zOffset < mapSize / 2; zOffset++) {
                for (let xOffset = -mapSize / 2; xOffset < mapSize / 2; xOffset++) {
                    const highestLocation = {
                        x: currentPlayerLocation.x + xOffset,
                        y: maxHeight,
                        z: currentPlayerLocation.z + zOffset
                    };
                    const cacheKey = this.createCacheKey(highestLocation.x, highestLocation.z, dimensionID);
                    try {
                        const topLocation = region.getAvailableLocationFromRay({
                            x: highestLocation.x + .5,
                            y: highestLocation.y,
                            z: highestLocation.z + .5
                        }, lib.VECTOR3_DOWN, {
                            includeLiquidBlocks: true,
                            maxDistance: maxHeightDistance
                        });
                        if (topLocation) {
                            const color = region.getBlockMapColor(topLocation);
                            cache.blocks[cacheKey] = {
                                color: {
                                    ...color
                                },
                                location: lib.Vector3Utils.floor(topLocation)
                            };
                        }
                    } catch {}
                }
            }
            region.dispose();
            this.uiSession.log.debug(`Cache Update finished with cache size ${Object.keys(cache.blocks).length} at ${Date.now().toString()}`);
        }
        createCacheKey(x, z, extraItem) {
            return `${x},${z},${extraItem}`;
        }
        updateLocationMarkRenderingStorage(deletedLocation) {
            if (deletedLocation) {
                for (const locationString in this.locationMarkRenderingStorage) {
                    if (Object.prototype.hasOwnProperty.call(this.locationMarkRenderingStorage, locationString)) {
                        if (this.locationMarkRenderingStorage[locationString].relatedStoredLocation === deletedLocation) {
                            delete this.locationMarkRenderingStorage[locationString];
                        }
                    }
                }
            }
            this.processLocationMarkOnDifferentMapSize(-8, 0, -3, 3, ((z, x) => z === 0 && x === 0 || z === -1 && x >= -1 && x <= 1 || z === -2 && x >= -1 && x <= 1 || z === -3 && x >= -2 && x <= 2 || z >= -6 && z <= -4 && x >= -3 && x <= 3 || z === -7 && x >= -2 && x <= 2 || z === -8 && x >= -1 && x <= 1), ((z, x) => z === 0 && x === 0 || z === -1 && (x === -1 || x === 1) || z === -2 && (x === -1 || x === 1) || z === -3 && (x === -2 || x === 2) || z >= -6 && z <= -4 && (x === -3 || x === 3) || z === -7 && (x === -2 || x === 2) || z === -8 && x >= -1 && x <= 1), ((z, x) => z === -4 && x === 0 || z === -5 && x >= -1 && x <= 1 || z === -6 && x === 0), MapSize.Small);
            this.processLocationMarkOnDifferentMapSize(-8, 0, -3, 3, ((z, x) => z === 0 && x === 0 || z === -1 && x >= -1 && x <= 1 || z === -2 && x >= -1 && x <= 1 || z === -3 && x >= -2 && x <= 2 || z >= -6 && z <= -4 && x >= -3 && x <= 3 || z === -7 && x >= -2 && x <= 2 || z === -8 && x >= -1 && x <= 1), ((z, x) => z === 0 && x === 0 || z === -1 && (x === -1 || x === 1) || z === -2 && (x === -1 || x === 1) || z === -3 && (x === -2 || x === 2) || z >= -6 && z <= -4 && (x === -3 || x === 3) || z === -7 && (x === -2 || x === 2) || z === -8 && x >= -1 && x <= 1), ((z, x) => z === -4 && x === 0 || z === -5 && x >= -1 && x <= 1 || z === -6 && x === 0), MapSize.Middle);
            this.processLocationMarkOnDifferentMapSize(-18, 0, -7, 7, ((z, x) => z >= -2 && z <= 0 && x >= -1 && x <= 1 || z >= -6 && z <= -3 && x >= -3 && x <= 3 || z >= -8 && z <= -7 && x >= -5 && x <= 5 || z >= -14 && z <= -9 && x >= -7 && x <= 7 || z >= -16 && z <= -15 && x >= -5 && x <= 5 || z >= -18 && z <= -17 && x >= -3 && x <= 3), ((z, x) => z >= -2 && z <= 0 && (x === -1 || x === 0 || x === 1) || z >= -6 && z <= -3 && (x === -3 || x === -2 || x === 2 || x === 3) || z >= -8 && z <= -7 && (x === -4 || x === -5 || x === 4 || x === 5) || z >= -14 && z <= -9 && (x === -7 || x === -6 || x === 6 || x === 7) || z >= -16 && z <= -15 && (x === -4 || x === -5 || x === 4 || x === 5) || z >= -18 && z <= -17 && x >= -3 && x <= 3), ((z, x) => z === -7 && x === 0 || z === -8 && x === 0 || z === -9 && x >= 0 && x <= 1 || z === -10 && x >= -1 && x <= 1 || z === -11 && x >= -4 && x <= 2 || z === -12 && x >= -2 && x <= 2 || z === -13 && x >= 0 && x <= 3 || z === -14 && x === 3), MapSize.Large);
        }
        processLocationMarkOnDifferentMapSize(zLowerBound, zUpperBound, xLowerBound, xUpperBound, isWithinRange, isWithinOuterBorderRange, isWithinInnerBorderRange, mapSize) {
            for (const locationData of this.storedLocations) {
                for (let zOffset = zUpperBound; zOffset >= zLowerBound; zOffset--) {
                    for (let xOffset = xLowerBound; xOffset <= xUpperBound; xOffset++) {
                        const currentLocation = {
                            x: locationData.location.x + xOffset,
                            y: locationData.location.y,
                            z: locationData.location.z + zOffset
                        };
                        if (isWithinRange(zOffset, xOffset)) {
                            const locationString = this.createCacheKey(currentLocation.x, currentLocation.z, mapSize);
                            let color;
                            if (isWithinOuterBorderRange(zOffset, xOffset)) {
                                color = {
                                    ...BLACK_RGBA
                                };
                            } else if (isWithinInnerBorderRange(zOffset, xOffset)) {
                                color = this.isLocationMarkNearWhite(locationData.color) ? {
                                    ...BLACK_RGBA
                                } : {
                                    ...WHITE_RGBA
                                };
                            } else {
                                color = {
                                    ...locationData.color
                                };
                            }
                            if (!(locationString in this.locationMarkRenderingStorage)) {
                                this.locationMarkRenderingStorage[locationString] = {
                                    color,
                                    relatedStoredLocation: locationData
                                };
                            } else if (locationData.location.z >= this.locationMarkRenderingStorage[locationString].relatedStoredLocation.location.z) {
                                this.locationMarkRenderingStorage[locationString].relatedStoredLocation = locationData;
                                this.locationMarkRenderingStorage[locationString].color = color;
                            }
                        }
                    }
                }
            }
        }
        getCurrentDirectionPlayerIsFacing() {
            const player = this.uiSession.extensionContext.player;
            let directionPlayerIsFacing;
            const viewDirection = player.getViewDirection();
            let angle = Math.atan2(viewDirection.z, viewDirection.x);
            if (angle < 0) {
                angle += 2 * Math.PI;
            }
            if (angle >= 15 * Math.PI / 8 || angle < Math.PI / 8) {
                directionPlayerIsFacing = Navigation_Direction.East;
            } else if (angle >= Math.PI / 8 && angle < 3 * Math.PI / 8) {
                directionPlayerIsFacing = Navigation_Direction.Southeast;
            } else if (angle >= 3 * Math.PI / 8 && angle < 5 * Math.PI / 8) {
                directionPlayerIsFacing = Navigation_Direction.South;
            } else if (angle >= 5 * Math.PI / 8 && angle < 7 * Math.PI / 8) {
                directionPlayerIsFacing = Navigation_Direction.Southwest;
            } else if (angle >= 7 * Math.PI / 8 && angle < 9 * Math.PI / 8) {
                directionPlayerIsFacing = Navigation_Direction.West;
            } else if (angle >= 9 * Math.PI / 8 && angle < 11 * Math.PI / 8) {
                directionPlayerIsFacing = Navigation_Direction.Northwest;
            } else if (angle >= 11 * Math.PI / 8 && angle < 13 * Math.PI / 8) {
                directionPlayerIsFacing = Navigation_Direction.North;
            } else {
                directionPlayerIsFacing = Navigation_Direction.Northeast;
            }
            return directionPlayerIsFacing;
        }
        isPlayerFarFromCenter(center, currentLocation) {
            return Math.abs(center.x - currentLocation.x) > CACHE_UPDATE_DISTANCE || Math.abs(center.z - currentLocation.z) > CACHE_UPDATE_DISTANCE;
        }
        shouldDeleteItemFromCache(latestPlayerLocation, itemLocation) {
            return Math.abs(latestPlayerLocation.x - itemLocation.x) > CACHE_LENGTH / 2 || Math.abs(latestPlayerLocation.z - itemLocation.z) > CACHE_LENGTH / 2;
        }
        isLocationMarkNearWhite(color) {
            return color.red >= .9 && color.blue >= .9 && color.green >= .9;
        }
    }
    class WeatherBehavior {
        auxLog(logString, currentPlayer) {
            const currentTags = [ "Editor", "Weather" ];
            const currentLogProperties = {
                player: currentPlayer,
                tags: currentTags
            };
            server_editor_namespaceObject.editor.log.info(logString, currentLogProperties);
        }
        setWeatherAndLog(newWeatherType) {
            const dimension = server_namespaceObject.world.getDimension("overworld");
            dimension.setWeather(newWeatherType, this.weatherDuration);
            this.auxLog(`Setting weather to ${newWeatherType} in the Overworld dimension`);
        }
        getWeather() {
            const dimension = server_namespaceObject.world.getDimension("overworld");
            return dimension.getWeather();
        }
        resetMenuStates() {
            if (this.clearWeatherMenuItem) {
                this.clearWeatherMenuItem.checked = false;
            }
            if (this.rainWeatherMenuItem) {
                this.rainWeatherMenuItem.checked = false;
            }
            if (this.thunderWeatherMenuItem) {
                this.thunderWeatherMenuItem.checked = false;
            }
        }
        updateMenuStates(newWeatherType) {
            this.resetMenuStates();
            switch (newWeatherType) {
              case server_namespaceObject.WeatherType.Clear:
                if (this.clearWeatherMenuItem) {
                    this.clearWeatherMenuItem.checked = true;
                }
                break;

              case server_namespaceObject.WeatherType.Rain:
                if (this.rainWeatherMenuItem) {
                    this.rainWeatherMenuItem.checked = true;
                }
                break;

              case server_namespaceObject.WeatherType.Thunder:
                if (this.thunderWeatherMenuItem) {
                    this.thunderWeatherMenuItem.checked = true;
                }
                break;
            }
        }
        setSubscriptionToWeatherChangeEvent(uiSession) {
            uiSession.eventSubscriptionCache.subscribeToBedrockEvent("weatherChange", (evt => {
                this.auxLog(`Weather is now ${evt.newWeather} in the Overworld dimension`, uiSession.extensionContext.player);
                this.updateMenuStates(evt.newWeather);
            }));
        }
        constructor(uiSession, parentMenu) {
            this.uiSession = uiSession;
            this.weatherMenu = undefined;
            this.clearWeatherMenuItem = undefined;
            this.rainWeatherMenuItem = undefined;
            this.thunderWeatherMenuItem = undefined;
            this.weatherDuration = 1e6;
            this.createWeatherMenu(parentMenu);
            this.setSubscriptionToWeatherChangeEvent(this.uiSession);
            this.updateMenuStates(this.getWeather());
        }
        createWeatherMenu(parentMenu) {
            const weatherClearAction = this.uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.setWeatherAndLog(server_namespaceObject.WeatherType.Clear);
                }
            });
            const weatherRainAction = this.uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.setWeatherAndLog(server_namespaceObject.WeatherType.Rain);
                }
            });
            const weatherThunderAction = this.uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.setWeatherAndLog(server_namespaceObject.WeatherType.Thunder);
                }
            });
            if (this.uiSession.scratchStorage) {
                this.weatherMenu = parentMenu.addItem({
                    label: "resourcePack.editor.menuBar.parentMenu.weather",
                    tooltip: "resourcePack.editor.menuBar.parentMenu.weather.tooltip"
                });
                this.clearWeatherMenuItem = this.weatherMenu.addItem({
                    label: "resourcePack.editor.menuBar.parentMenu.weather.clear"
                }, weatherClearAction);
                this.rainWeatherMenuItem = this.weatherMenu.addItem({
                    label: "resourcePack.editor.menuBar.parentMenu.weather.rain"
                }, weatherRainAction);
                this.thunderWeatherMenuItem = this.weatherMenu.addItem({
                    label: "resourcePack.editor.menuBar.parentMenu.weather.thunder"
                }, weatherThunderAction);
            }
        }
        teardown() {
            this.resetMenuStates();
        }
    }
    function VibrantVisuals_stringFromException(e) {
        if (typeof e === "string") {
            return e;
        } else if (typeof e === "object" && e !== null && "message" in e) {
            return e.message;
        }
        return "Unknown exception";
    }
    var ObservableUIControlType;
    (function(ObservableUIControlType) {
        ObservableUIControlType[ObservableUIControlType["Number"] = 0] = "Number";
        ObservableUIControlType[ObservableUIControlType["String"] = 1] = "String";
        ObservableUIControlType[ObservableUIControlType["Slider"] = 2] = "Slider";
        ObservableUIControlType[ObservableUIControlType["Checkbox"] = 3] = "Checkbox";
        ObservableUIControlType[ObservableUIControlType["ColorRGB"] = 4] = "ColorRGB";
        ObservableUIControlType[ObservableUIControlType["ColorRGBA"] = 5] = "ColorRGBA";
        ObservableUIControlType[ObservableUIControlType["Vector3"] = 6] = "Vector3";
        ObservableUIControlType[ObservableUIControlType["Dropdown"] = 7] = "Dropdown";
        ObservableUIControlType[ObservableUIControlType["ColorTimeline"] = 8] = "ColorTimeline";
        ObservableUIControlType[ObservableUIControlType["NumberTimeline"] = 9] = "NumberTimeline";
    })(ObservableUIControlType || (ObservableUIControlType = {}));
    class DataItemGroupUIControlBase {
        get type() {
            throw new Error("Not implemented in base");
        }
        get group() {
            throw new Error("Not implemented in base");
        }
        _insertDataIntoOriginalObject(_propertyPath, _newValue, _actualData, _observableUIControlType, _originalType) {
            const fnInsertDataIntoObjectByPath = (_path, _value) => {
                const pathParts = _path.split("/").filter(Boolean);
                let data = _actualData;
                for (let i = 0; i < pathParts.length; i++) {
                    const part = pathParts[i];
                    if (data[part] === undefined) {
                        throw new Error(`Failed to find path element ${part}`);
                    }
                    if (i === pathParts.length - 1) {
                        data[part] = _value;
                        return true;
                    }
                    data = data[part];
                }
                throw new Error(`Failed to find path element ${_path}`);
            };
            switch (_observableUIControlType) {
              case ObservableUIControlType.Number:
              case ObservableUIControlType.Slider:
                {
                    if (typeof _newValue !== "number") {
                        throw new Error(`Invalid number value for property ${_propertyPath}`);
                    }
                    switch (_originalType) {
                      case OpNodeSourceType.INTEGER:
                        fnInsertDataIntoObjectByPath(_propertyPath, Math.round(_newValue));
                        break;

                      case OpNodeSourceType.NUMBER:
                        fnInsertDataIntoObjectByPath(_propertyPath, _newValue);
                        break;

                      default:
                        throw new Error(`Invalid original type for property ${_propertyPath}`);
                    }
                }
                break;

              case ObservableUIControlType.Checkbox:
                {
                    if (typeof _newValue !== "boolean") {
                        throw new Error(`Invalid number value for property ${_propertyPath}`);
                    }
                    fnInsertDataIntoObjectByPath(_propertyPath, _newValue);
                }
                break;

              case ObservableUIControlType.String:
                {
                    if (typeof _newValue !== "string") {
                        throw new Error(`Invalid string value for property ${_propertyPath}`);
                    }
                    if (_originalType !== OpNodeSourceType.STRING) {
                        throw new Error(`Invalid original type for property ${_propertyPath}`);
                    }
                    fnInsertDataIntoObjectByPath(_propertyPath, _newValue);
                }
                break;

              case ObservableUIControlType.ColorRGB:
              case ObservableUIControlType.ColorRGBA:
                {
                    if (typeof _newValue !== "object") {
                        throw new Error(`Invalid color value for property ${_propertyPath}`);
                    }
                    if (_originalType === OpNodeSourceType.ARRAY || _originalType === OpNodeSourceType.MAP) {
                        if ("red" in _newValue && "green" in _newValue && "blue" in _newValue) {
                            if (_originalType === OpNodeSourceType.ARRAY) {
                                const colorComponents = [];
                                colorComponents.push(Number(_newValue.red));
                                colorComponents.push(Number(_newValue.green));
                                colorComponents.push(Number(_newValue.blue));
                                if (_observableUIControlType === ObservableUIControlType.ColorRGBA && "alpha" in _newValue) {
                                    colorComponents.push(Number(_newValue.alpha));
                                }
                                for (let i = 0; i < colorComponents.length; i++) {
                                    const keyName = `${_propertyPath}/${i}`;
                                    fnInsertDataIntoObjectByPath(keyName, Math.round(colorComponents[i] * 255));
                                }
                            } else if (_originalType === OpNodeSourceType.MAP) {
                                throw new Error(`Associative container of named RGB values not yet implemented`);
                            }
                        } else {
                            throw new Error(`Invalid color value for property ${_propertyPath}`);
                        }
                    } else if (_originalType === OpNodeSourceType.STRING) {
                        if ("red" in _newValue && "green" in _newValue && "blue" in _newValue) {
                            const toHex = n => {
                                const hex = Math.max(0, Math.min(255, Math.round(n * 255))).toString(16);
                                return hex.length === 1 ? "0" + hex : hex;
                            };
                            const red = Number(_newValue.red);
                            const green = Number(_newValue.green);
                            const blue = Number(_newValue.blue);
                            let hexString = "";
                            if (_observableUIControlType === ObservableUIControlType.ColorRGBA && "alpha" in _newValue) {
                                const alpha = Number(_newValue.alpha);
                                hexString = `#${toHex(red)}${toHex(green)}${toHex(blue)}${toHex(alpha)}`;
                            } else {
                                hexString = `#${toHex(red)}${toHex(green)}${toHex(blue)}`;
                            }
                            fnInsertDataIntoObjectByPath(_propertyPath, hexString);
                        } else {
                            throw new Error(`Invalid color value for property ${_propertyPath}`);
                        }
                    } else {
                        throw new Error(`Invalid original type for property ${_propertyPath}`);
                    }
                }
                break;

              case ObservableUIControlType.Vector3:
                {
                    if (typeof _newValue !== "object" && !Array.isArray(_newValue)) {
                        throw new Error(`Invalid color value for property ${_propertyPath}`);
                    }
                    if (_originalType !== OpNodeSourceType.ARRAY && _originalType !== OpNodeSourceType.MAP) {
                        throw new Error(`Invalid original type for property ${_propertyPath}`);
                    }
                    if ("x" in _newValue && "y" in _newValue && "z" in _newValue) {
                        if (_originalType === OpNodeSourceType.ARRAY) {
                            const vectorComponents = [];
                            vectorComponents.push(Number(_newValue.x));
                            vectorComponents.push(Number(_newValue.y));
                            vectorComponents.push(Number(_newValue.z));
                            for (let i = 0; i < vectorComponents.length; i++) {
                                const keyName = `${_propertyPath}/${i}`;
                                fnInsertDataIntoObjectByPath(keyName, vectorComponents[i]);
                            }
                        } else if (_originalType === OpNodeSourceType.MAP) {
                            throw new Error(`Associative container of named XYZ values not yet implemented`);
                        }
                    } else {
                        throw new Error(`Invalid color value for property ${_propertyPath}`);
                    }
                }
                break;

              case ObservableUIControlType.Dropdown:
                {
                    if (typeof _newValue !== "string") {
                        throw new Error(`Invalid dropdown value for property ${_propertyPath}`);
                    }
                    if (_originalType !== OpNodeSourceType.STRING) {
                        throw new Error(`Invalid original type for property ${_propertyPath}`);
                    }
                    fnInsertDataIntoObjectByPath(_propertyPath, _newValue);
                }
                break;

              case ObservableUIControlType.ColorTimeline:
                {
                    if (typeof _newValue !== "object") {
                        throw new Error(`Invalid colorTimeline value for property ${_propertyPath}`);
                    }
                    if (_originalType !== OpNodeSourceType.MAP) {
                        throw new Error(`Invalid original type for property ${_propertyPath}`);
                    }
                    fnInsertDataIntoObjectByPath(_propertyPath, _newValue);
                }
                break;

              case ObservableUIControlType.NumberTimeline:
                {
                    if (typeof _newValue !== "object") {
                        throw new Error(`Invalid numberTimeline value for property ${_propertyPath}`);
                    }
                    if (_originalType !== OpNodeSourceType.MAP) {
                        throw new Error(`Invalid original type for property ${_propertyPath}`);
                    }
                    fnInsertDataIntoObjectByPath(_propertyPath, _newValue);
                }
                break;

              default:
                throw new Error(`Invalid property bag type for property ${_propertyPath}`);
            }
            return true;
        }
    }
    class DataItemGroupUIControlPropertyPane extends DataItemGroupUIControlBase {
        get type() {
            return DataItemGroupType.PropertyPane;
        }
        get group() {
            return this._group;
        }
        get propertyPane() {
            return this._uiPropertyPane;
        }
        constructor(group, _rootPane, _observables, _actualData, _schemaInterface, _dataItemChangedCallback, _helpString) {
            super();
            this._group = group;
            this._helpString = _helpString;
            const displayName = this.group.displayName;
            const displayExpander = this.group.displayName.length > 0;
            const toolTip = {
                title: displayName,
                description: [ _helpString ?? "" ]
            };
            this._uiPropertyPane = this.group.logicalGroupOnly ? _rootPane : _rootPane.createSubPane({
                title: displayName,
                hasExpander: displayExpander,
                infoTooltip: _helpString !== undefined ? toolTip : undefined
            });
            if (!this._uiPropertyPane) {
                throw new Error("Failed to create property pane");
            }
            const unsorted = group.tags.find((tag => tag === "unsorted")) !== undefined;
            if (!unsorted) {
                this.group.dataItems.sort(((a, b) => a._displayName.localeCompare(b._displayName)));
            }
            for (const item of this.group.dataItems) {
                const localizedTitle = `${item._displayName}`;
                const updateOriginalJSONData = newValue => {
                    const observableControlType = item._observableControlType;
                    const originalType = item._originalType;
                    const isJSONDataInserted = this._insertDataIntoOriginalObject(item._observableName, newValue, _actualData, observableControlType, originalType);
                    if (isJSONDataInserted && _dataItemChangedCallback) {
                        _dataItemChangedCallback();
                    }
                };
                switch (item._observableControlType) {
                  case ObservableUIControlType.Number:
                  case ObservableUIControlType.Slider:
                    {
                        const showSlider = item._observableControlType === ObservableUIControlType.Slider;
                        _schemaInterface.debug(`Adding number property: ${item._observableName} as ${showSlider ? "slider" : "number"}`);
                        const propItemOptions = {
                            title: localizedTitle
                        };
                        if (item._min !== undefined && item._max !== undefined) {
                            propItemOptions.min = item._min;
                            propItemOptions.max = item._max;
                            propItemOptions.variant = showSlider ? server_editor_namespaceObject.NumberPropertyItemVariant.InputFieldAndSlider : server_editor_namespaceObject.NumberPropertyItemVariant.InputField;
                        }
                        if (item._readonly) {
                            propItemOptions.enable = false;
                        }
                        propItemOptions.onChange = (newValue, _oldValue) => {
                            updateOriginalJSONData(newValue);
                        };
                        item._setOriginalJSONData = (observableTypes, propertyPath, newValue) => {
                            observableTypes[propertyPath].set(newValue);
                            updateOriginalJSONData(newValue);
                        };
                        if (item._helpString) {
                            propItemOptions.tooltip = item._helpString;
                        }
                        const currentObservable = _observables[item._observableName];
                        this._uiPropertyPane.addNumber(currentObservable, propItemOptions);
                    }
                    break;

                  case ObservableUIControlType.String:
                    {
                        _schemaInterface.debug(`Adding string property: ${item._observableName}`);
                        const propItemOptions = {
                            title: localizedTitle,
                            onChange: (newValue, _oldValue) => {
                                updateOriginalJSONData(newValue);
                            }
                        };
                        if (item._readonly) {
                            propItemOptions.enable = false;
                        }
                        item._setOriginalJSONData = (observableTypes, propertyPath, newValue) => {
                            observableTypes[propertyPath].set(newValue);
                            updateOriginalJSONData(newValue);
                        };
                        if (item._helpString) {
                            propItemOptions.tooltip = item._helpString;
                        }
                        const currentObservable = _observables[item._observableName];
                        this._uiPropertyPane.addString(currentObservable, propItemOptions);
                    }
                    break;

                  case ObservableUIControlType.ColorRGB:
                  case ObservableUIControlType.ColorRGBA:
                    {
                        _schemaInterface.debug(`Adding color property: ${item._observableName}`);
                        const propItemOptions = {
                            title: localizedTitle,
                            hiddenAlpha: item._observableControlType === ObservableUIControlType.ColorRGBA,
                            variant: server_editor_namespaceObject.ColorPickerPropertyItemVariant.Inline,
                            onChange: (newValue, _oldValue) => {
                                updateOriginalJSONData(newValue);
                            }
                        };
                        if (item._readonly) {
                            propItemOptions.enable = false;
                        }
                        item._setOriginalJSONData = (observableTypes, propertyPath, newValue) => {
                            observableTypes[propertyPath].set(newValue);
                            updateOriginalJSONData(newValue);
                        };
                        if (item._helpString) {
                            propItemOptions.tooltip = item._helpString;
                        }
                        const currentObservable = _observables[item._observableName];
                        this._uiPropertyPane.addColorPicker(currentObservable, propItemOptions);
                    }
                    break;

                  case ObservableUIControlType.Vector3:
                    {
                        _schemaInterface.debug(`Adding vector property: ${item._observableName}`);
                        const propItemOptions = {
                            title: localizedTitle,
                            onChange: (newValue, _oldValue) => {
                                updateOriginalJSONData(newValue);
                            }
                        };
                        if (item._min !== undefined) {
                            propItemOptions.min = {
                                x: item._min,
                                y: item._min,
                                z: item._min
                            };
                        }
                        if (item._max !== undefined) {
                            propItemOptions.max = {
                                x: item._max,
                                y: item._max,
                                z: item._max
                            };
                        }
                        if (item._readonly) {
                            propItemOptions.enable = false;
                        }
                        item._setOriginalJSONData = (observableTypes, propertyPath, newValue) => {
                            observableTypes[propertyPath].set(newValue);
                            updateOriginalJSONData(newValue);
                        };
                        if (item._helpString) {
                            propItemOptions.tooltip = item._helpString;
                        }
                        const currentObservable = _observables[item._observableName];
                        this._uiPropertyPane.addVector3(currentObservable, propItemOptions);
                    }
                    break;

                  case ObservableUIControlType.Dropdown:
                    {
                        _schemaInterface.debug(`Adding dropdown property: ${item._observableName}`);
                        if (item._enums === undefined || item._prettyEnums === undefined) {
                            throw new Error("Dropdown property must have enums defined");
                        }
                        const comboDropdownItems = item._prettyEnums?.map(((v, i) => {
                            const dropItem = {
                                label: v,
                                value: i
                            };
                            return dropItem;
                        }));
                        const propItemOptions = {
                            title: localizedTitle,
                            entries: comboDropdownItems,
                            onChange: (newValue, _oldValue, _items) => {
                                const dropDownNewValue = item._enums !== undefined ? item._enums[newValue] : newValue;
                                updateOriginalJSONData(dropDownNewValue);
                            }
                        };
                        if (item._readonly) {
                            propItemOptions.enable = false;
                        }
                        item._setOriginalJSONData = (observableTypes, propertyPath, newValue) => {
                            if (item._enums !== undefined) {
                                const index = item._enums.indexOf(item._enums[newValue]);
                                if (index !== -1) {
                                    observableTypes[propertyPath].set(index);
                                }
                            }
                            const dropDownNewValue = item._enums !== undefined ? item._enums[newValue] : "";
                            updateOriginalJSONData(dropDownNewValue);
                        };
                        if (item._helpString) {
                            propItemOptions.tooltip = item._helpString;
                        }
                        const currentObservable = _observables[item._observableName];
                        this._uiPropertyPane.addDropdown(currentObservable, propItemOptions);
                    }
                    break;

                  case ObservableUIControlType.Checkbox:
                    {
                        _schemaInterface.debug(`Adding checkbox property: ${item._observableName}`);
                        const propItemOptions = {
                            title: localizedTitle,
                            onChange: (newValue, _oldValue) => {
                                updateOriginalJSONData(newValue);
                            }
                        };
                        if (item._readonly) {
                            propItemOptions.enable = false;
                        }
                        item._setOriginalJSONData = (observableTypes, propertyPath, newValue) => {
                            observableTypes[propertyPath].set(newValue);
                            updateOriginalJSONData(newValue);
                        };
                        if (item._helpString) {
                            propItemOptions.tooltip = item._helpString;
                        }
                        const currentObservable = _observables[item._observableName];
                        this._uiPropertyPane.addBool(currentObservable, propItemOptions);
                    }
                    break;

                  case ObservableUIControlType.ColorTimeline:
                    throw new Error("ColorTimeline control cannot be used in a property pane");

                  case ObservableUIControlType.NumberTimeline:
                    throw new Error("NumberTimeline control cannot be used in a property pane");

                  default:
                    throw new Error(`invalid control type: ${item._observableControlType}`);
                }
            }
        }
    }
    class DataItemGroupUIControlColorTimeline extends DataItemGroupUIControlBase {
        get type() {
            return DataItemGroupType.ColorTimeline;
        }
        get group() {
            return this._group;
        }
        constructor(group, _rootPane, _observables, _actualData, _schemaInterface, _dataItemChangedCallback, _helpString) {
            super();
            this._isTimelinePreview = false;
            this._group = group;
            const displayName = group.displayName;
            const displayExpander = true;
            const toolTip = {
                title: displayName,
                description: [ _helpString ?? "" ]
            };
            this._uiPropertyPane = _rootPane.createSubPane({
                title: displayName,
                hasExpander: displayExpander,
                infoTooltip: _helpString !== undefined ? toolTip : undefined
            });
            if (!this._uiPropertyPane) {
                throw new Error("Failed to create property pane");
            }
            this._isTimelinePreview = group.tags.find((tag => tag === "previewTime")) !== undefined;
            const unsorted = group.tags.find((tag => tag === "unsorted")) !== undefined;
            if (!unsorted) {
                this.group.dataItems.sort(((a, b) => a._displayName.localeCompare(b._displayName)));
            }
            const dataTable = [];
            let colorValueTypes = undefined;
            let itemIndex = 0;
            for (const item of this.group.dataItems) {
                if (item._observableControlType !== ObservableUIControlType.ColorRGBA && item._observableControlType !== ObservableUIControlType.ColorRGB) {
                    throw new Error(`ColorTimeline control can only contain color data items.  Item ${item._observableName} is a ${item._observableControlType}`);
                }
                if (colorValueTypes === undefined) {
                    colorValueTypes = item._observableControlType;
                }
                if (colorValueTypes !== item._observableControlType) {
                    throw new Error("ColorTimeline control can only handle a container of the same color types - you can't mix RGB and RGBA value types");
                }
                item._setOriginalJSONData = (_o, _p, _v) => {};
                const itemName = group.path + "/" + itemIndex.toString();
                const currentObservable = _observables[item._observableName];
                try {
                    let time = parseFloat(item._displayName);
                    if (time < 0 || time > 1) {
                        _schemaInterface.error(`Warning: Time value in the ColorTimeline container should be between 0 and 1 [${itemName} = ${time}]`);
                        time = Math.max(0, Math.min(1, time));
                    }
                    dataTable.push({
                        id: itemName,
                        time,
                        value: currentObservable.value
                    });
                    _schemaInterface.debug(`Adding Key/Color property: ${itemName} -- [${time} = ${JSON.stringify(currentObservable.value)}]`);
                } catch (_e) {
                    _schemaInterface.error(`Failed to parse time value for item ${item._observableName} - ${VibrantVisuals_stringFromException(_e)}`);
                    throw new Error("ColorTimeline control only supports numeric key values");
                }
                ++itemIndex;
            }
            const _rebuildContainerObject = _dataItems => {
                const outMap = {};
                for (const item of _dataItems) {
                    const time = item.time;
                    const colorValue = item.value;
                    const red = Math.max(0, Math.min(255, Math.round(colorValue.red * 255)));
                    const green = Math.max(0, Math.min(255, Math.round(colorValue.green * 255)));
                    const blue = Math.max(0, Math.min(255, Math.round(colorValue.blue * 255)));
                    const alpha = Math.max(0, Math.min(255, Math.round(colorValue.alpha * 255)));
                    if (colorValueTypes === ObservableUIControlType.ColorRGBA) {
                        outMap[time] = [ red, green, blue, alpha ];
                    } else {
                        outMap[time] = [ red, green, blue ];
                    }
                }
                const outJSON = JSON.stringify(outMap);
                _schemaInterface.debug(`Rebuilding container object: ${outJSON}`);
                const isInserted = this._insertDataIntoOriginalObject(group.path, outMap, _actualData, ObservableUIControlType.ColorTimeline, OpNodeSourceType.MAP);
                if (isInserted && _dataItemChangedCallback) {
                    _dataItemChangedCallback();
                }
            };
            this._uiCurrentTime = (0, server_editor_namespaceObject.makeObservable)(.4);
            this._uiControl = this._uiPropertyPane.addColorTimeline(this._uiCurrentTime, {
                entries: dataTable,
                onNodeAdded: node => {
                    _schemaInterface._debug?.(`Node added: ${node.id}`);
                    _rebuildContainerObject(this._uiControl.getData());
                },
                onNodeChanged: node => {
                    _schemaInterface._debug?.(`Node changed: ${node.id}`);
                    _rebuildContainerObject(this._uiControl.getData());
                },
                onNodeRemoved: node => {
                    _schemaInterface._debug?.(`Node removed: ${node.id}`);
                    _rebuildContainerObject(this._uiControl.getData());
                },
                onTimeChanged: (time, _prev) => {
                    _schemaInterface._debug?.(`Time changed: ${time}`);
                    if (this._isTimelinePreview) {
                        let gameTime = (time * 24e3 + 6e3) % 24e3;
                        if (gameTime < 0) {
                            gameTime += 24e3;
                        }
                        server_namespaceObject.system.sendScriptEvent("editor:agfxPreview:timeChanged", gameTime.toString());
                    }
                }
            });
        }
    }
    class DataItemGroupUIControlNumberTimeline extends DataItemGroupUIControlBase {
        get type() {
            return DataItemGroupType.NumberTimeline;
        }
        get group() {
            return this._group;
        }
        constructor(group, _rootPane, _observables, _actualData, _schemaInterface, _dataItemChangedCallback, _helpString) {
            super();
            this._isTimelinePreview = false;
            this._group = group;
            const displayName = group.displayName;
            const displayExpander = true;
            const toolTip = {
                title: displayName,
                description: [ _helpString ?? "" ]
            };
            this._uiPropertyPane = _rootPane.createSubPane({
                title: displayName,
                hasExpander: displayExpander,
                infoTooltip: _helpString !== undefined ? toolTip : undefined
            });
            if (!this._uiPropertyPane) {
                throw new Error("Failed to create property pane");
            }
            this._isTimelinePreview = group.tags.find((tag => tag === "previewTime")) !== undefined;
            const unsorted = group.tags.find((tag => tag === "unsorted")) !== undefined;
            if (!unsorted) {
                this.group.dataItems.sort(((a, b) => a._displayName.localeCompare(b._displayName)));
            }
            const dataTable = [];
            let itemIndex = 0;
            let minValueBounds;
            let maxValueBounds;
            let minValueFound = Number.MAX_SAFE_INTEGER;
            let maxValueFound = Number.MIN_SAFE_INTEGER;
            for (const item of this.group.dataItems) {
                if (item._observableControlType !== ObservableUIControlType.Number) {
                    throw new Error(`NumberTimeline control can only contain number data items.  Item ${item._observableName} is a ${item._observableControlType}`);
                }
                item._setOriginalJSONData = (_o, _p, _v) => {};
                if (item._min !== undefined) {
                    if (item._min < minValueFound) {
                        minValueBounds = item._min;
                    }
                }
                if (item._max !== undefined) {
                    if (item._max > maxValueFound) {
                        maxValueBounds = item._max;
                    }
                }
                const itemName = group.path + "/" + itemIndex.toString();
                const currentObservable = _observables[item._observableName];
                try {
                    let time = parseFloat(item._displayName);
                    if (time < 0 || time > 1) {
                        _schemaInterface.error(`Warning: Time value in the NumberTimeline container should be between 0 and 1 [${itemName} = ${time}]`);
                        time = Math.max(0, Math.min(1, time));
                    }
                    const itemValue = currentObservable.value;
                    if (itemValue < minValueFound) {
                        minValueFound = itemValue;
                    }
                    if (itemValue > maxValueFound) {
                        maxValueFound = itemValue;
                    }
                    dataTable.push({
                        id: itemName,
                        time,
                        value: currentObservable.value
                    });
                    _schemaInterface.debug(`Adding Key/Number property: ${itemName} -- [${time} = ${JSON.stringify(currentObservable.value)}]`);
                } catch (_e) {
                    _schemaInterface.error(`Failed to parse time value for item ${item._observableName} - ${VibrantVisuals_stringFromException(_e)}`);
                    throw new Error("NumberTimeline control only supports numeric key values");
                }
                ++itemIndex;
            }
            const _rebuildContainerObject = _dataItems => {
                const outMap = {};
                for (const item of _dataItems) {
                    const time = item.time;
                    const value = item.value;
                    outMap[time] = value;
                }
                const outJSON = JSON.stringify(outMap);
                _schemaInterface.debug(`Rebuilding container object: ${outJSON}`);
                const isInserted = this._insertDataIntoOriginalObject(group.path, outMap, _actualData, ObservableUIControlType.NumberTimeline, OpNodeSourceType.MAP);
                if (isInserted && _dataItemChangedCallback) {
                    _dataItemChangedCallback();
                }
            };
            this._uiCurrentTime = (0, server_editor_namespaceObject.makeObservable)(.4);
            if (minValueBounds === undefined) {
                minValueBounds = minValueFound;
            }
            if (maxValueBounds === undefined) {
                maxValueBounds = maxValueFound;
            }
            this._uiControl = this._uiPropertyPane.addNumberTimeline(this._uiCurrentTime, {
                entries: dataTable,
                bounds: {
                    minValue: minValueBounds,
                    maxValue: maxValueBounds
                },
                gridSeparatorStepCount: {
                    x: .1,
                    y: 10
                },
                gridSeparatorSliceCount: {
                    x: 5,
                    y: 5
                },
                onNodeAdded: node => {
                    _schemaInterface._debug?.(`Node added: ${node.id}`);
                    _rebuildContainerObject(this._uiControl.getData());
                },
                onNodeChanged: node => {
                    _schemaInterface._debug?.(`Node changed: ${node.id}`);
                    _rebuildContainerObject(this._uiControl.getData());
                },
                onNodeRemoved: node => {
                    _schemaInterface._debug?.(`Node removed: ${node.id}`);
                    _rebuildContainerObject(this._uiControl.getData());
                },
                onTimeChanged: (time, _prev) => {
                    _schemaInterface._debug?.(`Time changed: ${time}`);
                    if (this._isTimelinePreview) {
                        server_namespaceObject.system.sendScriptEvent("editor:agfxPreview:timeChanged", (time * 24e3).toString());
                    }
                }
            });
        }
    }
    var DataItemGroupType;
    (function(DataItemGroupType) {
        DataItemGroupType[DataItemGroupType["PropertyPane"] = 0] = "PropertyPane";
        DataItemGroupType[DataItemGroupType["ColorTimeline"] = 1] = "ColorTimeline";
        DataItemGroupType[DataItemGroupType["NumberTimeline"] = 2] = "NumberTimeline";
    })(DataItemGroupType || (DataItemGroupType = {}));
    class DataItemGroup {
        constructor(_displayName, _path, _parentGroup, _type, _tags, _editorControlType, _helpString) {
            this._tags = [];
            this._displayName = _displayName;
            this._path = _path;
            this._dataItems = [];
            this._parentGroup = _parentGroup;
            this._logicalGroupOnly = false;
            this._type = _type;
            this._tags = _tags;
            this._helpString = _helpString;
            switch (_editorControlType ?? OpNodeEditorUIControlType.UNKNOWN) {
              case OpNodeEditorUIControlType.COLOR_TIMELINE:
                this._groupType = DataItemGroupType.ColorTimeline;
                break;

              case OpNodeEditorUIControlType.NUMBER_TIMELINE:
                this._groupType = DataItemGroupType.NumberTimeline;
                break;

              default:
                this._groupType = DataItemGroupType.PropertyPane;
            }
        }
        get displayName() {
            return this._displayName;
        }
        get path() {
            return this._path;
        }
        get containerBounds() {
            return this._containerBounds;
        }
        set containerBounds(value) {
            this._containerBounds = value;
        }
        get propertyPane() {
            if (this._UIControl && this._UIControl.type === DataItemGroupType.PropertyPane) {
                return this._UIControl.propertyPane;
            }
            return undefined;
        }
        get logicalGroupOnly() {
            return this._logicalGroupOnly;
        }
        set logicalGroupOnly(value) {
            this._logicalGroupOnly = value;
        }
        get type() {
            return this._type;
        }
        get groupType() {
            return this._groupType;
        }
        get dataItems() {
            return this._dataItems;
        }
        get tags() {
            return this._tags;
        }
        createPropertyPane(_rootPane, _observables, _actualData, _schemaInterface, _dataItemChangedCallback) {
            if (this._parentGroup) {
                if (this._parentGroup.propertyPane) {
                    _rootPane = this._parentGroup.propertyPane;
                }
            }
            if (!_rootPane) {
                throw new Error(`Missing parent property pane`);
            }
            if (this._UIControl) {
                throw new Error("Property pane already created");
            }
            this._UIControl = new DataItemGroupUIControlPropertyPane(this, _rootPane, _observables, _actualData, _schemaInterface, _dataItemChangedCallback, this._helpString);
        }
        createColorTimeline(_rootPane, _observables, _actualData, _schemaInterface, _dataItemChangedCallback) {
            if (this._parentGroup) {
                if (this._parentGroup.propertyPane) {
                    _rootPane = this._parentGroup.propertyPane;
                }
            }
            if (!_rootPane) {
                throw new Error(`Missing parent property pane`);
            }
            if (this._UIControl) {
                throw new Error("Property pane already created");
            }
            this._UIControl = new DataItemGroupUIControlColorTimeline(this, _rootPane, _observables, _actualData, _schemaInterface, _dataItemChangedCallback, this._helpString);
        }
        createNumberTimeline(_rootPane, _observables, _actualData, _schemaInterface, _dataItemChangedCallback) {
            if (this._parentGroup) {
                if (this._parentGroup.propertyPane) {
                    _rootPane = this._parentGroup.propertyPane;
                }
            }
            if (!_rootPane) {
                throw new Error(`Missing parent property pane`);
            }
            if (this._UIControl) {
                throw new Error("Property pane already created");
            }
            this._UIControl = new DataItemGroupUIControlNumberTimeline(this, _rootPane, _observables, _actualData, _schemaInterface, _dataItemChangedCallback, this._helpString);
        }
        addNumberDataItem(_displayName, _observableName, _originalType, _min, _max, _readonly, _helpString) {
            this._dataItems.push({
                _displayName,
                _observableName,
                _observableControlType: ObservableUIControlType.Number,
                _min,
                _max,
                _originalType,
                _uiCollectionComponent: false,
                _readonly: _readonly ?? false,
                _helpString
            });
        }
        addStringDataItem(_displayName, _observableName, _validationRegex, _readonly, _helpString) {
            this._dataItems.push({
                _displayName,
                _observableName,
                _observableControlType: ObservableUIControlType.String,
                _validationRegex,
                _originalType: OpNodeSourceType.STRING,
                _uiCollectionComponent: false,
                _readonly: _readonly ?? false,
                _helpString
            });
        }
        addSliderDataItem(_displayName, _observableName, _originalType, _min, _max, _helpString) {
            this._dataItems.push({
                _displayName,
                _observableName,
                _observableControlType: ObservableUIControlType.Slider,
                _min,
                _max,
                _originalType,
                _uiCollectionComponent: false,
                _readonly: false,
                _helpString
            });
        }
        addColorDataItem(_displayName, _observableName, size, _originalType, _uiCollectionComponent, _helpString) {
            this._dataItems.push({
                _displayName,
                _observableName,
                _observableControlType: size === 4 ? ObservableUIControlType.ColorRGBA : ObservableUIControlType.ColorRGB,
                _originalType,
                _uiCollectionComponent,
                _readonly: false,
                _helpString
            });
        }
        addVector3DataItem(_displayName, _observableName, _originalType, _min, _max, _readonly, _helpString) {
            this._dataItems.push({
                _displayName,
                _observableName,
                _observableControlType: ObservableUIControlType.Vector3,
                _originalType,
                _min,
                _max,
                _uiCollectionComponent: true,
                _readonly: _readonly ?? false,
                _helpString
            });
        }
        addDropdownDataItem(_displayName, _observableName, _originalType, _enums, _prettyEnums, _readonly, _helpString) {
            this._dataItems.push({
                _displayName,
                _observableName,
                _observableControlType: ObservableUIControlType.Dropdown,
                _originalType,
                _uiCollectionComponent: false,
                _readonly: _readonly ?? false,
                _enums,
                _prettyEnums,
                _helpString
            });
        }
        addCheckboxDataItem(_displayName, _observableName, _originalType, _readonly, _helpString) {
            this._dataItems.push({
                _displayName,
                _observableName,
                _observableControlType: ObservableUIControlType.Checkbox,
                _originalType,
                _uiCollectionComponent: false,
                _readonly: _readonly ?? false,
                _helpString
            });
        }
        restoreData(_observables, _defaultObservable) {
            for (const item of this._dataItems) {
                const path = item._observableName;
                const newValue = _defaultObservable[path];
                if (item._setOriginalJSONData) {
                    item._setOriginalJSONData(_observables, path, newValue);
                }
            }
        }
    }
    class UIComponentMap {
        constructor(session, data) {
            this._editableProperties = {};
            this._groups = [];
            this._session = session;
            this._dirty = false;
            this._reverting = false;
            this._currentData = JSON.parse(JSON.stringify(data));
        }
        get dirty() {
            return this._dirty;
        }
        set dirty(value) {
            this._dirty = value;
        }
        get reverting() {
            return this._reverting;
        }
        set reverting(value) {
            this._reverting = value;
        }
        get currentData() {
            return this._currentData;
        }
        _findGroupFromPath(path) {
            const lastSlash = path.lastIndexOf("/");
            if (lastSlash <= 0) {
                return undefined;
            }
            const parentPath = path.slice(0, lastSlash);
            for (const group of this._groups) {
                if (group.path === parentPath) {
                    return group;
                }
            }
            throw new Error(`Failed to find a parent group for a non-root data item (${path})`);
            return undefined;
        }
        addDataItem(_path, _key, _type, _data, _properties) {
            let parentGroup = this._findGroupFromPath(_path);
            const fnConvertNodeTypeToDefaultEditor = _type => {
                switch (_type) {
                  case OpNodeSourceType.STRING:
                    return OpNodeEditorUIControlType.TEXT;

                  case OpNodeSourceType.NUMBER:
                  case OpNodeSourceType.INTEGER:
                    return OpNodeEditorUIControlType.FLOAT;

                  case OpNodeSourceType.BOOLEAN:
                    return OpNodeEditorUIControlType.CHECKBOX;

                  default:
                    return OpNodeEditorUIControlType.UNKNOWN;
                }
            };
            let editorControl = fnConvertNodeTypeToDefaultEditor(_type);
            const editorProperty = _properties.getProperty("OpPropertyEditorUIControl");
            if (editorProperty) {
                editorControl = editorProperty.controlType;
            }
            const labelAliases = _properties.getProperty("OpPropertyLabelAliases");
            const prettify = _properties.getProperty("OpPropertyPrettifier");
            const tagsProperty = _properties.getProperty("OpPropertyTags");
            const helpProperty = _properties.getProperty("OpPropertyHelp");
            const helpString = helpProperty?.help ?? undefined;
            const aliasAndPrettify = _key => {
                const alias = labelAliases?.getLabelAlias(_key) ?? _key;
                const displayName = prettify?.prettify(alias) ?? alias;
                return displayName;
            };
            const displayName = aliasAndPrettify(_key);
            if (_type === OpNodeSourceType.NULL) {
                throw new Error("I don't know what to do with nulls");
            } else if (_type === OpNodeSourceType.OBJECT || _type === OpNodeSourceType.ARRAY || _type === OpNodeSourceType.MAP) {
                const tags = tagsProperty?.tags ?? [];
                this._groups.push(new DataItemGroup(displayName, _path, parentGroup, _type, tags, editorControl, helpString));
                const containerBounds = {
                    min: 0,
                    max: 0
                };
                const arrayBoundsProperty = _properties.getProperty("OpPropertyArrayBounds");
                if (arrayBoundsProperty) {
                    if (arrayBoundsProperty.minItems !== undefined) {
                        containerBounds.min = arrayBoundsProperty.minItems;
                    }
                    if (arrayBoundsProperty.maxItems !== undefined) {
                        containerBounds.max = arrayBoundsProperty.maxItems;
                    }
                } else {
                    const mapBoundsProperty = _properties.getProperty("OpPropertyMapBounds");
                    if (mapBoundsProperty) {
                        if (mapBoundsProperty.minProperties !== undefined) {
                            containerBounds.min = mapBoundsProperty.minProperties;
                        }
                        if (mapBoundsProperty.maxProperties !== undefined) {
                            containerBounds.max = mapBoundsProperty.maxProperties;
                        }
                    }
                }
                if (editorControl === OpNodeEditorUIControlType.COLOR || editorControl === OpNodeEditorUIControlType.VECTOR3) {
                    if (containerBounds.min !== containerBounds.max || containerBounds.min !== 3 && containerBounds.min !== 4) {
                        throw new Error(`Container bounds not specified - Path(${_path}), Key(${_key}) -- minItems and maxItems MUST be specified in the schema`);
                    }
                }
                if (editorControl === OpNodeEditorUIControlType.COLOR) {
                    this._groups[this._groups.length - 1].containerBounds = containerBounds;
                    this._groups[this._groups.length - 1].logicalGroupOnly = true;
                    const color = {
                        Red: 0,
                        Green: 0,
                        Blue: 0,
                        Alpha: 0
                    };
                    this._editableProperties[_path] = (0, server_editor_namespaceObject.makeObservable)(color);
                } else if (editorControl === OpNodeEditorUIControlType.VECTOR3) {
                    this._groups[this._groups.length - 1].containerBounds = containerBounds;
                    this._groups[this._groups.length - 1].logicalGroupOnly = true;
                    const vec3 = {
                        x: 0,
                        y: 0,
                        z: 0
                    };
                    this._editableProperties[_path] = (0, server_editor_namespaceObject.makeObservable)(vec3);
                } else if (editorControl === OpNodeEditorUIControlType.COLOR_TIMELINE) {
                    this._groups[this._groups.length - 1].containerBounds = containerBounds;
                    this._groups[this._groups.length - 1].logicalGroupOnly = true;
                } else if (editorControl === OpNodeEditorUIControlType.NUMBER_TIMELINE) {
                    this._groups[this._groups.length - 1].containerBounds = containerBounds;
                    this._groups[this._groups.length - 1].logicalGroupOnly = true;
                }
            } else {
                if (!parentGroup) {
                    const tags = tagsProperty?.tags ?? [];
                    const groupIndex = this._groups.push(new DataItemGroup("", _path, undefined, OpNodeSourceType.NULL, tags, OpNodeEditorUIControlType.UNKNOWN));
                    parentGroup = this._groups[groupIndex - 1];
                }
                if (_type !== OpNodeSourceType.STRING && _type !== OpNodeSourceType.NUMBER && _type !== OpNodeSourceType.INTEGER && _type !== OpNodeSourceType.BOOLEAN) {
                    return;
                }
                this._editableProperties[_path] = (0, server_editor_namespaceObject.makeObservable)(_data);
                const regexValidator = _properties.getProperty("OpPropertyPattern")?.pattern;
                const valueMin = _properties.getProperty("OpPropertyValueRange")?.min;
                const valueMax = _properties.getProperty("OpPropertyValueRange")?.max;
                const readonly = _properties.hasProperty("OpPropertyReadOnly");
                switch (editorControl) {
                  case OpNodeEditorUIControlType.COLOR_TIMELINE:
                  case OpNodeEditorUIControlType.NUMBER_TIMELINE:
                    break;

                  case OpNodeEditorUIControlType.FLOAT:
                    parentGroup.addNumberDataItem(displayName, _path, _type, valueMin, valueMax, readonly, helpString);
                    break;

                  case OpNodeEditorUIControlType.SLIDER:
                    parentGroup.addSliderDataItem(displayName, _path, _type, valueMin, valueMax, helpString);
                    break;

                  case OpNodeEditorUIControlType.TEXT:
                    parentGroup.addStringDataItem(displayName, _path, regexValidator, readonly, helpString);
                    break;

                  case OpNodeEditorUIControlType.CHECKBOX:
                    parentGroup.addCheckboxDataItem(displayName, _path, _type, readonly, helpString);
                    break;

                  case OpNodeEditorUIControlType.COLOR:
                    {
                        const parentPath = parentGroup.path;
                        if (_type === OpNodeSourceType.NUMBER || _type === OpNodeSourceType.INTEGER) {
                            if (parentGroup.type !== OpNodeSourceType.ARRAY) {
                                throw new Error(`Associative container of named RGB values not yet implemented`);
                            }
                            const colorSize = parentGroup.containerBounds?.max;
                            if (!colorSize) {
                                throw new Error(`Array bounds not specified - Path(${_path}), Key(${_key})`);
                            }
                            const index = Number(_key);
                            if (index >= colorSize || index < 0) {
                                throw new Error(`Array bounds exceeded - Path(${_path}), Key(${_key})`);
                            } else if (index === colorSize - 1) {
                                const componentData = [];
                                for (let i = 0; i < colorSize; i++) {
                                    const colorComponentPath = `${parentPath}/${i}`;
                                    const colorComponent = this._editableProperties[colorComponentPath].value;
                                    if (typeof colorComponent !== "number") {
                                        throw new Error(`Invalid color component value at path ${colorComponentPath}`);
                                    }
                                    componentData.push(colorComponent / 255);
 