export class DropKitchenTable {
	constructor() {
		this.blockTag = "drop:kitchen_table"
		this.onPlace = this.onPlace.bind(this);
		this.onPlayerDestroy = this.onPlayerDestroy.bind(this);
	}
	isFull(block) {
		const north = block.north()?.hasTag(this.blockTag);
		const south = block.south()?.hasTag(this.blockTag);
		const east = block.east()?.hasTag(this.blockTag);
		const west = block.west()?.hasTag(this.blockTag);
		return (
			(north && west && block.north()?.west()?.hasTag(this.blockTag)) ||
			(north && east && block.north()?.east()?.hasTag(this.blockTag)) ||
			(south && west && block.south()?.west()?.hasTag(this.blockTag)) ||
			(south && east && block.south()?.east()?.hasTag(this.blockTag))
		);
	}
	updateBlock(block) {
		if(!block) return;
		block.setPermutation(block.permutation
			.withState("drop:n", block.north()?.hasTag(this.blockTag))
			.withState("drop:s", block.south()?.hasTag(this.blockTag))
			.withState("drop:w", block.west()?.hasTag(this.blockTag))
			.withState("drop:e", block.east()?.hasTag(this.blockTag))
			.withState("drop:full", this.isFull(block)));
	}
	updateAdjacentBlocks(block) {
		const north = block.north();
		const south = block.south();
		const west = block.west();
		const east = block.east();
		if (north?.hasTag(this.blockTag)) this.updateBlock(north);
		if (south?.hasTag(this.blockTag)) this.updateBlock(south);
		if (west?.hasTag(this.blockTag)) this.updateBlock(west);
		if (east?.hasTag(this.blockTag)) this.updateBlock(east);
		if (north?.hasTag(this.blockTag) && west?.hasTag(this.blockTag) && north.west()?.hasTag(this.blockTag)) this.updateBlock(north.west());
		if (north?.hasTag(this.blockTag) && east?.hasTag(this.blockTag) && north.east()?.hasTag(this.blockTag)) this.updateBlock(north.east());
		if (south?.hasTag(this.blockTag) && west?.hasTag(this.blockTag) && south.west()?.hasTag(this.blockTag)) this.updateBlock(south.west());
		if (south?.hasTag(this.blockTag) && east?.hasTag(this.blockTag) && south.east()?.hasTag(this.blockTag)) this.updateBlock(south.east());
	}
	onPlace(e) {
		this.updateBlock(e.block);
		this.updateAdjacentBlocks(e.block);
	}
	onPlayerDestroy(e) {
		this.updateAdjacentBlocks(e.block);
	}
}