import { EquipmentSlot, ItemStack } from '@minecraft/server';
import { decrementItemInHand, itemApplyDamage, spawnEntityRotatedByBlock } from '../util/utils';
import { directionState } from '../util/globalVariables';

const CUTTABLE_ITEMS = {
	"minecraft:carrot": { result: "drop:chopped_carrot", amount: 3 },
	"minecraft:beetroot": { result: "drop:chopped_beetroot", amount: 3 },
	"minecraft:cod": { result: "drop:chopped_cod", amount: 3 },
	"minecraft:potato": { result: "drop:raw_fries", amount: 3 }
}
export class DropCuttingBoard {
	onPlayerInteract(e) {
		const { player, block, dimension } = e;
		const item = player.getComponent("equippable")?.getEquipment(EquipmentSlot.Mainhand);
		if (!item) return;
		const cuttable = CUTTABLE_ITEMS[item.typeId];
		const foodEntity = dimension.getEntitiesAtBlockLocation(block.location).find(en => en.matches({ type: "drop:cuttable_food" }));
		const location = block.bottomCenter();
		if (!foodEntity && cuttable) {
			const direction = block.permutation.getState(directionState);
			const cuttableFood = spawnEntityRotatedByBlock("drop:cuttable_food", block, direction, { init: location });
			cuttableFood.getComponent("inventory").container.setItem(0, new ItemStack(item.typeId, 1));
			cuttableFood.runCommand(`replaceitem entity @s slot.weapon.mainhand 0 ${item.typeId}`);
			cuttableFood.setDynamicProperty("drop:food_result", cuttable.result);
			cuttableFood.setDynamicProperty("drop:food_amount", cuttable.amount);
			dimension.playSound("block.itemframe.add_item", location);
			decrementItemInHand(player);
			return;
		}
		if (foodEntity && item.hasTag("mc:is_knife")) {
			dimension.spawnItem(new ItemStack(foodEntity.getDynamicProperty("drop:food_result"), foodEntity.getDynamicProperty("drop:food_amount")), location);
			itemApplyDamage(player, item);
			dimension.playSound("effect.cutting_board.cut", location);
			foodEntity.remove();
		}
	}
}