import { directionState, leftBlockLocation, rightBlockLocation } from "../util/globalVariables";

export class DropUpdateSideBlock {
	constructor(blockTag = "drop:") {
		this.blockTag = blockTag;
		this.rightstate = "drop:right";
		this.leftState = "drop:left";
		this.onPlace = this.onPlace.bind(this);
		this.onPlayerDestroy = this.onPlayerDestroy.bind(this);
	}
	getAdjacentBlocks(block, direction) {
		return {
			rightBlock: block.offset(rightBlockLocation[direction]),
			leftBlock: block.offset(leftBlockLocation[direction])
		};
	}
	updateBlock(block, direction) {
		const { rightBlock, leftBlock } = this.getAdjacentBlocks(block, direction);
		const tag = `${this.blockTag}_${direction}`;
		block.setPermutation(block.permutation
			.withState(this.leftState, leftBlock.hasTag(tag))
			.withState(this.rightstate, rightBlock.hasTag(tag))
		);
	}
	updateNearestBlock(block, direction) {
		const { rightBlock, leftBlock } = this.getAdjacentBlocks(block, direction);
		const tag = `${this.blockTag}_${direction}`;
		if (rightBlock?.hasTag(tag)) this.updateBlock(rightBlock, rightBlock.permutation.getState(directionState));
		if (leftBlock?.hasTag(tag)) this.updateBlock(leftBlock, leftBlock.permutation.getState(directionState));
	}
	onPlace(e) {
		this.updateBlock(e.block, e.block.permutation.getState(directionState));
		this.updateNearestBlock(e.block, e.block.permutation.getState(directionState));
	}
	onPlayerDestroy(e) {
		this.updateNearestBlock(e.block, e.destroyedBlockPermutation.getState(directionState));
	}
}