import { BlockPermutation, MolangVariableMap } from '@minecraft/server';
import { extractColor, itemApplyDamage } from '../util/utils';
import { colors, directionState, leftBlockLocation, rightBlockLocation } from '../util/globalVariables';

const COLOR_MAP = {
	"black": {r: 0.18, g: 0.18, b: 0.21},
	"blue": {r: 0.27, g: 0.35, b: 0.74},
	"brown": {r: 0.53, g: 0.33, b: 0.19},
	"cyan": {r: 0.07, g: 0.62, b: 0.62},
	"gray": {r: 0.38, g: 0.44, b: 0.45},
	"green": {r: 0.34, g: 0.46, b: 0.08},
	"light_blue": {r: 0.16, g: 0.63, b: 0.84},
	"light_gray": {r: 0.58, g: 0.58, b: 0.55},
	"lime": {r: 0.48, g: 0.78, b: 0.09},
	"magenta": {r: 0.74, g: 0.24, b: 0.71},
	"orange": {r: 1, g: 0.51, b: 0.09},
	"pink": {r: 0.93, g: 0.47, b: 0.61},
	"purple": {r: 0.48, g: 0.16, b: 0.67},
	"red": {r: 0.71, g: 0.19, b: 0.16},
	"white": {r: 0.9, g: 0.92, b: 0.92},
	"yellow": {r: 1, g: 0.81, b: 0.16}
}
const DYEABLE_BLOCKS = {
	"drop:terracotta_clay_beaker": "drop:color_clay_beaker",
	"drop:bottle_0_water": "drop:bottle_0_color",
	"drop:bottle_1_water": "drop:bottle_1_color",
	"drop:bottle_2_water": "drop:bottle_2_color",
	"drop:candle_table_base": "drop:candle_table_color",
	"drop:lamp": "drop:lamp_color",
	"drop:terracotta_large_pot": "drop:color_large_pot",
	"drop:terracotta_large_pot_dirt": "drop:color_large_pot_dirt",
	"drop:terracotta_pot": "drop:color_pot",
	"drop:terracotta_teapot": "drop:color_teapot",
	"drop:toilet_terracotta": "drop:toilet_color",
	"drop:water_pot_terracotta": "drop:water_pot_color"
}
export class DropPaintBlock {
	onUseOn(e) {
		const { block, itemStack, source } = e;
		const dyeableBlocks = DYEABLE_BLOCKS[block.typeId];
		if (!block.hasTag("drop:dyeable_block") && !block.hasTag("drop:dyeable_entity") && !block.hasTag("drop:dyeable_sided_block") && !dyeableBlocks) return;
		const itemColor = extractColor(itemStack.typeId);
		if (block.hasTag("drop:dyeable_entity")) {
			const dyeableEntity = source.dimension.getEntitiesAtBlockLocation(block.location).find(en => en.matches({ families: [ "drop_dyeable_entity" ] }));
			if (!dyeableEntity) return;
			const entityColor = colors[dyeableEntity.getProperty("drop:color")];
			if (entityColor === itemColor) return;
			dyeableEntity.setProperty("drop:color", colors.indexOf(itemColor));
		} else {
			const blockColor = extractColor(block.typeId);
			if (blockColor === itemColor && !dyeableBlocks) return;
			if (block.hasTag("drop:dyeable_block")) {
				block.setPermutation(BlockPermutation.resolve(block.typeId.replace(blockColor, itemColor), block.permutation.getAllStates()));
			} else if (block.hasTag("drop:dyeable_sided_block")) {
				const direction = block.permutation.getState(directionState);
				const part = block.permutation.getState("mc:block_parts");
				const sideBlock = part === 1 ? block.offset(rightBlockLocation[direction]) : block.offset(leftBlockLocation[direction]);
				block.setPermutation(BlockPermutation.resolve(block.typeId.replace(blockColor, itemColor), block.permutation.getAllStates()));
				sideBlock.setPermutation(BlockPermutation.resolve(sideBlock.typeId.replace(blockColor, itemColor), sideBlock.permutation.getAllStates()));
			} else if (dyeableBlocks) {
				block.setPermutation(BlockPermutation.resolve(dyeableBlocks.replace("color", itemColor), block.permutation.getAllStates()));
			}
		}
		const paintParticle = new MolangVariableMap();
		const selectedColor = COLOR_MAP[itemColor];
		paintParticle.setFloat("variable.r", selectedColor.r);
		paintParticle.setFloat("variable.g", selectedColor.g);
		paintParticle.setFloat("variable.b", selectedColor.b);
		source.dimension.playSound("effect.splash", block.center());
		source.dimension.spawnParticle("drop:paint_particle", block.center(), paintParticle);
		source.dimension.playSound("block.itemframe.add_item", block.center());
		itemApplyDamage(source, itemStack);
	}
}