import { world, BlockPermutation } from '@minecraft/server';


//extraido de bedrock dev
export class IronGolemStructureSpawner {

    /**Summons an entity with the structure of the iron golem.
     * 
     * @param {string} headBlockTypeId
     * @param {string} bodyBlockTypeId
     * @param {string} spawnEntityTypeId
     * 
     */
    constructor(headBlockTypeId, bodyBlockTypeId, spawnEntityTypeId) {
        this.head_block_type = headBlockTypeId;
        this.body_block_type = bodyBlockTypeId;
        this.spawn_entity_type = spawnEntityTypeId;

        world.afterEvents.playerPlaceBlock.subscribe(this.handleBlockPlacement.bind(this));
    }

    handleBlockPlacement(ev) {
        const player = ev.player;
        const block = ev.block;

        const blockBelow1 = block.below();
        const blockBelow2 = blockBelow1.below();
        const blockNorth = blockBelow1.north();
        const blockSouth = blockBelow1.south();
        const blockEast = blockBelow1.east();
        const blockWest = blockBelow1.west();

        const structureBlocks = [block, blockBelow1, blockBelow2];

        const isHeadBlock = block.typeId == this.head_block_type;
        const isBodyBlock = blockBelow1.typeId == this.body_block_type && blockBelow2.typeId == this.body_block_type;
        const hasHorizontalBodyBlocks = (blockNorth.typeId == this.body_block_type && blockSouth.typeId == this.body_block_type) ||
            (blockEast.typeId == this.body_block_type && blockWest.typeId == this.body_block_type);

        // Check the structure
        if (isHeadBlock && isBodyBlock && hasHorizontalBodyBlocks) {

            if (blockEast.typeId == this.body_block_type && blockWest.typeId == this.body_block_type) {
                structureBlocks.push(blockEast, blockWest)
            } else if (blockNorth.typeId == this.body_block_type && blockSouth.typeId == this.body_block_type) {
                structureBlocks.push(blockNorth, blockSouth)
            }
            // Clear the blocks in the structure
            structureBlocks.forEach(block => block.setPermutation(BlockPermutation.resolve('minecraft:air')));

            // Spawn the defined entity
            player.dimension.spawnEntity(this.spawn_entity_type, blockBelow2.location);
        }
    }
}

export class SnowGolemStructureSpawner {

    /**Summons an entity with the structure of the snow golem.
     * @param {string} headBlockTypeId
     * @param {string} bodyBlockTypeId
     * @param {string} spawnEntityTypeId
     * 
     */
    constructor(headBlockTypeId, bodyBlockTypeId, spawnEntityTypeId) {
        this.head_block_type = headBlockTypeId;
        this.body_block_type = bodyBlockTypeId;
        this.spawn_entity_type = spawnEntityTypeId;

        world.afterEvents.playerPlaceBlock.subscribe(this.handleBlockPlacement.bind(this));
    }

    handleBlockPlacement(ev) {
        const player = ev.player;
        const block = ev.block;


        const blockBelow1 = block.below();
        const blockBelow2 = blockBelow1.below();

        const structureBlocks = [block, blockBelow1, blockBelow2];

        const isHeadBlock = block.typeId == this.head_block_type;
        const isBodyBlock = blockBelow1.typeId == this.body_block_type && blockBelow2.typeId == this.body_block_type;

        // Check the structure
        if (isHeadBlock && isBodyBlock) {

            // Clear the blocks in the structure
            structureBlocks.forEach(block => block.setPermutation(BlockPermutation.resolve('minecraft:air')));

            // Spawn the defined entity
            player.dimension.spawnEntity(this.spawn_entity_type, blockBelow2.location);
        }
    }
}