import { EntityEquippableComponent, EquipmentSlot, GameMode, ItemEnchantableComponent, ItemStack, system, world } from "@minecraft/server";
import { destroyBlock, getBlocks } from "../utils/block";
import { calculateFortune, getToolLevel, reduceDurability, spawnItem } from "../utils/item";
import { randomNum } from "../utils/math";
import { GlobalIntervals } from "../utils/globalIntervals";
const items = [];
class Veinminer {
  static register(item) {
    items.push(item);
  }
  static initialize() {
    world.afterEvents.playerBreakBlock.subscribe((data) => {
      var _a, _b;
      const { brokenBlockPermutation, player } = data;
      if (!player.isSneaking) return;
      const mainhand = player.getComponent(EntityEquippableComponent.componentId).getEquipmentSlot(EquipmentSlot.Mainhand);
      if (!mainhand) return;
      const item = mainhand.getItem();
      if (!item) return;
      const gamemode = player.getGameMode();
      const enchComp = item.getComponent(ItemEnchantableComponent.componentId);
      let silktouch = (enchComp == null ? void 0 : enchComp.getEnchantment("silk_touch")) !== void 0;
      const fortune = (_a = enchComp == null ? void 0 : enchComp.getEnchantment("fortune")) == null ? void 0 : _a.level;
      let blockAmount = 0;
      const initialLoc = data.block.center();
      for (const itemData of items) {
        let tickBlock = function(block, initialId, segment) {
          const interval = GlobalIntervals.set(() => {
            var _a2, _b2, _c, _d, _e;
            GlobalIntervals.clear(interval);
            if (!player || !player.isValid()) return;
            if (!player.isSneaking) return;
            if (((_a2 = mainhand.getItem()) == null ? void 0 : _a2.typeId) !== (item == null ? void 0 : item.typeId)) return;
            const typeId = block.typeId;
            if (blockAmount > ((_b2 = itemData.blockLimit) != null ? _b2 : 1e3)) return;
            if (typeId !== initialId) return;
            const blockData2 = itemData.blocks[typeId];
            if (!blockData2) return;
            if (!blockData2.connectedLimit) segment = 0;
            if (segment > ((_c = blockData2.connectedLimit) != null ? _c : 9999)) return;
            if (blockData2.upBlockAmount !== false) blockAmount++;
            const lastGamerule = world.gameRules.doTileDrops;
            let extra = 0;
            if (fortune !== void 0 && blockData2.fortune) {
              extra = calculateFortune(fortune, blockData2.fortune.levels);
            }
            if (silktouch && blockData2.silkTouch !== false || extra > 0 && fortune !== void 0 && ((_d = blockData2.fortune) == null ? void 0 : _d.replaceDefault)) world.gameRules.doTileDrops = false;
            destroyBlock(block);
            world.gameRules.doTileDrops = lastGamerule;
            if (silktouch) spawnItem(new ItemStack(typeof blockData2.silkTouch === "string" ? blockData2.silkTouch : typeId, 1), block.dimension, block.center());
            if (extra > 0 && blockData2.fortune) {
              for (let i = 0; i < extra; i++) spawnItem(new ItemStack(blockData2.fortune.item, 1), block.dimension, block.center());
            }
            data.dimension.getEntities({ location: block.center(), maxDistance: 1 }).filter((f) => ["minecraft:item", "minecraft:xp_orb"].includes(f.typeId)).forEach((itemEntity) => {
              itemEntity.teleport(initialLoc);
              itemEntity == null ? void 0 : itemEntity.applyImpulse({
                x: randomNum(-0.1, 0.1),
                y: randomNum(0.1, 0.25),
                z: randomNum(-0.1, 0.1)
              });
            });
            if (blockData2.lowerDurability !== false && gamemode !== GameMode.creative && gamemode !== GameMode.spectator) mainhand.setItem(reduceDurability(player, mainhand.getItem()));
            for (const connected of getBlocks(block)) {
              if (typeId === connected.typeId || ((_e = blockData2.connectedBlocks) == null ? void 0 : _e.includes(connected.typeId))) {
                system.runTimeout(() => {
                  tickBlock(connected, connected.typeId, typeId === data.brokenBlockPermutation.type.id ? 0 : segment + 1);
                }, 1);
              }
            }
          }, 3);
        };
        if (itemData.idMatches && itemData.idMatches !== item.typeId) continue;
        if (itemData.idIncludes) {
          let includes = false;
          for (const string of itemData.idIncludes) if (item.typeId.includes(string)) includes = true;
          if (!includes) continue;
        }
        const blockData = itemData.blocks[brokenBlockPermutation.type.id];
        if (!blockData) continue;
        if (blockData.toolLevel && getToolLevel(item) < blockData.toolLevel) continue;
        if (blockData.default === false) continue;
        if (itemData.applySilkTouch) silktouch = true;
        const blocks = getBlocks(data.block);
        for (const block of blocks) {
          if (data.brokenBlockPermutation.type.id === block.typeId || ((_b = blockData.connectedBlocks) == null ? void 0 : _b.includes(block.typeId))) {
            system.runTimeout(() => {
              tickBlock(block, block.typeId, 0);
            });
          }
        }
        return;
      }
    });
  }
}
export {
  Veinminer
};
