import { Veinminer } from "./classes/veinminer";
import { AxeNoLeaves } from "./data/axe";
import { PickaxeDefaultBlocks } from "./data/pickaxe";
import { SwordDefaultBlocks } from "./data/sword";
import { HoeDefaultBlocks } from "./data/hoe";
import { ShovelDefaultBlocks } from "./data/shovel";
import { ShearsDefaultBlocks } from "./data/shears";
import { GlobalIntervals } from "./utils/globalIntervals";
GlobalIntervals.initialize();
Veinminer.register({
    idIncludes: ["_sword"],
    blocks: SwordDefaultBlocks
});
Veinminer.register({
    idIncludes: ["_axe"],
    blocks: AxeNoLeaves
});
Veinminer.register({
    idIncludes: ["_pickaxe"],
    blocks: PickaxeDefaultBlocks
});
Veinminer.register({
    idIncludes: ["_hoe"],
    blocks: HoeDefaultBlocks
});
Veinminer.register({
    idIncludes: ["_shovel"],
    blocks: ShovelDefaultBlocks
});
Veinminer.register({
    idMatches: "minecraft:shears",
    applySilkTouch: true,
    blocks: ShearsDefaultBlocks
});
Veinminer.initialize();
