function getBlock(dimension, location) {
  try {
    return dimension.getBlock(location);
  } catch (e) {
    return void 0;
  }
}
function getBlocks(block) {
  const blocks = [];
  const loc = block.location;
  for (let x = -1; x <= 1; x++) {
    for (let y = -1; y <= 1; y++) {
      for (let z = -1; z <= 1; z++) {
        const newLoc = { x: loc.x, y: loc.y, z: loc.z };
        newLoc.x += x;
        newLoc.y += y;
        newLoc.z += z;
        if (newLoc.x === loc.x && newLoc.y === loc.y && newLoc.z === loc.z) continue;
        const newBlock = getBlock(block.dimension, newLoc);
        if (newBlock) blocks.push(newBlock);
      }
    }
  }
  return blocks;
}
function destroyBlock(block) {
  const loc = block.location;
  block.dimension.runCommand(`setblock ${loc.x} ${loc.y} ${loc.z} air destroy`);
}
export {
  destroyBlock,
  getBlock,
  getBlocks
};
